/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/HasPlatformTypeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "intention", "Lorg/jetbrains/kotlin/idea/intentions/SpecifyTypeExplicitlyIntention;", "publicAPIOnly", "", "(Lorg/jetbrains/kotlin/idea/intentions/SpecifyTypeExplicitlyIntention;Z)V", "getIntention", "()Lorg/jetbrains/kotlin/idea/intentions/SpecifyTypeExplicitlyIntention;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "getProblemHighlightType", "()Lcom/intellij/codeInspection/ProblemHighlightType;", "problemText", "", "getProblemText", "()Ljava/lang/String;", "additionalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "createOptionsPanel", "Ljavax/swing/JComponent;", "inspectionRange", "Lcom/intellij/openapi/util/TextRange;", "idea"})
public final class HasPlatformTypeInspection
extends IntentionBasedInspection<KtCallableDeclaration> {
    @NotNull
    private final ProblemHighlightType problemHighlightType;
    @NotNull
    private final String problemText = "Declaration has platform type. Make the type explicit to prevent subtle bugs.";
    @NotNull
    private final SpecifyTypeExplicitlyIntention intention;
    @JvmField
    public boolean publicAPIOnly;

    @Override
    @NotNull
    protected ProblemHighlightType getProblemHighlightType() {
        return this.problemHighlightType;
    }

    @Override
    @NotNull
    protected String getProblemText() {
        return this.problemText;
    }

    @Override
    @Nullable
    public List<LocalQuickFix> additionalFixes(@NotNull KtCallableDeclaration element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KotlinType kotlinType = this.intention.dangerousFlexibleTypeOrNull(element2, this.publicAPIOnly);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        if (FlexibleTypesKt.isNullabilityFlexible(type2)) {
            PsiElement expression2;
            ASTNode aSTNode = element2.getNode().findChildByType((IElementType)KtTokens.EQ);
            PsiElement psiElement = aSTNode != null && (aSTNode = aSTNode.getPsi()) != null ? PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments((PsiElement)aSTNode) : (expression2 = null);
            if (expression2 != null) {
                return CollectionsKt.listOf((Object)new IntentionWrapper((IntentionAction)new AddExclExclCallFix(expression2), element2.getContainingFile()));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public TextRange inspectionRange(@NotNull KtCallableDeclaration element2) {
        TextRange textRange;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        PsiElement psiElement = element2.getNameIdentifier();
        if (psiElement != null) {
            PsiElement psiElement2 = psiElement;
            PsiElement it = psiElement2;
            int start = PsiUtilsKt.getStartOffsetIn(it, element2);
            textRange = new TextRange(start, start + PsiUtilsKt.getEndOffset(it) - PsiUtilsKt.getStartOffset(it));
        } else {
            textRange = null;
        }
        return textRange;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Apply only to public or protected members", "publicAPIOnly");
        return (JComponent)panel;
    }

    @NotNull
    public final SpecifyTypeExplicitlyIntention getIntention() {
        return this.intention;
    }

    public HasPlatformTypeInspection(final @NotNull SpecifyTypeExplicitlyIntention intention, final boolean publicAPIOnly) {
        Intrinsics.checkParameterIsNotNull((Object)intention, (String)"intention");
        super(intention, (Function1)new Function1<KtCallableDeclaration, Boolean>(){

            public final boolean invoke(@NotNull KtCallableDeclaration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return intention.dangerousFlexibleTypeOrNull(it, publicAPIOnly) != null;
            }
        });
        this.intention = intention;
        this.publicAPIOnly = publicAPIOnly;
        this.problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        this.problemText = "Declaration has platform type. Make the type explicit to prevent subtle bugs.";
    }

    public /* synthetic */ HasPlatformTypeInspection(SpecifyTypeExplicitlyIntention specifyTypeExplicitlyIntention, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            specifyTypeExplicitlyIntention = new SpecifyTypeExplicitlyIntention();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(specifyTypeExplicitlyIntention, bl);
    }

    public HasPlatformTypeInspection() {
        this(null, false, 3, null);
    }
}

