/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.Collection;

public class CompilerPathsEx
extends CompilerPaths {
    public static void visitFiles(Collection<VirtualFile> directories, FileVisitor visitor) {
        for (VirtualFile outputDir : directories) {
            ApplicationManager.getApplication().runReadAction(() -> {
                String path2 = outputDir.getPath();
                visitor.accept(outputDir, path2, path2);
            });
        }
    }

    public static String[] getOutputPaths(Module[] modules) {
        OrderedSet outputPaths = new OrderedSet();
        for (Module module : modules) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension;
            CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension = !module.isDisposed() ? CompilerModuleExtension.getInstance(module) : null;
            if (compilerModuleExtension == null) continue;
            String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathUrl).replace('/', File.separatorChar));
            }
            if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathForTestsUrl).replace('/', File.separatorChar));
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEnumerationHandler.Factory handlerFactory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
                if (!handlerFactory.isApplicable(module)) continue;
                OrderEnumerationHandler handler = handlerFactory.createHandler(module);
                SmartList outputUrls = new SmartList();
                handler.addCustomModuleRoots(OrderRootType.CLASSES, moduleRootManager, (Collection<String>)outputUrls, true, true);
                for (String outputUrl : outputUrls) {
                    outputPaths.add(VirtualFileManager.extractPath(outputUrl).replace('/', File.separatorChar));
                }
            }
        }
        return ArrayUtil.toStringArray((Collection)outputPaths);
    }

    public static class FileVisitor {
        protected void accept(VirtualFile file, String fileRoot, String filePath2) {
            if (file.isDirectory()) {
                this.acceptDirectory(file, fileRoot, filePath2);
            } else {
                this.acceptFile(file, fileRoot, filePath2);
            }
        }

        protected void acceptFile(VirtualFile file, String fileRoot, String filePath2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptDirectory(VirtualFile file, String fileRoot, String filePath2) {
            VirtualFile[] children;
            ProgressManager.checkCanceled();
            for (VirtualFile child : children = file.getChildren()) {
                String _filePath;
                String name = child.getName();
                StringBuilder buf = StringBuilderSpinAllocator.alloc();
                try {
                    buf.append(filePath2).append("/").append(name);
                    _filePath = buf.toString();
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                }
                this.accept(child, fileRoot, _filePath);
            }
        }
    }
}

