/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class DiffNavigationContext {
    private final String myTargetString;
    private final Iterable<String> myPreviousLinesIterable;

    public DiffNavigationContext(@NotNull Iterable<String> previousLinesIterable, @NotNull String targetString) {
        if (previousLinesIterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousLinesIterable", "com/intellij/openapi/diff/DiffNavigationContext", "<init>"));
        }
        if (targetString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetString", "com/intellij/openapi/diff/DiffNavigationContext", "<init>"));
        }
        this.myPreviousLinesIterable = previousLinesIterable;
        this.myTargetString = targetString;
    }

    public Iterable<String> getPreviousLinesIterable() {
        return this.myPreviousLinesIterable;
    }

    public String getTargetString() {
        return this.myTargetString;
    }

    public int contextMatchCheck(@NotNull Iterator<Pair<Integer, CharSequence>> changedLinesIterator) {
        if (changedLinesIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedLinesIterator", "com/intellij/openapi/diff/DiffNavigationContext", "contextMatchCheck"));
        }
        Iterator<String> iterator = this.getPreviousLinesIterable().iterator();
        if (iterator.hasNext()) {
            CharSequence contextLine = iterator.next();
            while (changedLinesIterator.hasNext()) {
                Pair<Integer, CharSequence> pair = changedLinesIterator.next();
                if (!StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)pair.getSecond()), (CharSequence)contextLine)) continue;
                if (!iterator.hasNext()) break;
                contextLine = iterator.next();
            }
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (!changedLinesIterator.hasNext()) {
            return -1;
        }
        while (changedLinesIterator.hasNext()) {
            Pair<Integer, CharSequence> pair = changedLinesIterator.next();
            if (!StringUtil.equalsTrimWhitespaces((CharSequence)((CharSequence)pair.getSecond()), (CharSequence)this.getTargetString())) continue;
            return (Integer)pair.getFirst();
        }
        return -1;
    }
}

