/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxScopeEnlarger
extends UseScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        PsiElement declarationScope;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxScopeEnlarger", "getAdditionalUseScope"));
        }
        PsiClass containingClass = null;
        if (element instanceof PsiField) {
            containingClass = ((PsiField)element).getContainingClass();
        } else if (element instanceof PsiMethod) {
            containingClass = ((PsiMethod)element).getContainingClass();
        } else if (element instanceof PsiParameter && (declarationScope = ((PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)declarationScope))) {
            containingClass = ((PsiMethod)declarationScope).getContainingClass();
        }
        if (containingClass != null && (element instanceof PsiField && JavaFxScopeEnlarger.needToEnlargeFieldScope((PsiField)element) || element instanceof PsiMethod && JavaFxScopeEnlarger.needToEnlargeMethodScope((PsiMethod)element) || element instanceof PsiParameter) && (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"javafx.scene.Node") || this.isControllerClass(containingClass))) {
            GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
            return new GlobalFxmlSearchScope(projectScope);
        }
        return null;
    }

    public boolean isControllerClass(PsiClass psiClass) {
        Project project = psiClass.getProject();
        GlobalSearchScope resolveScope = psiClass.getResolveScope();
        if (JavaFxScopeEnlarger.isControllerClassName(project, psiClass.getQualifiedName(), resolveScope)) {
            return true;
        }
        Ref refFound = new Ref((Object)false);
        ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)resolveScope, (boolean)true, (boolean)true, (boolean)false).forEach(aClass -> {
            if (JavaFxScopeEnlarger.isControllerClassName(project, aClass.getQualifiedName(), resolveScope)) {
                refFound.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)refFound.get();
    }

    private static boolean isControllerClassName(@NotNull Project project, @Nullable String qualifiedName, @NotNull GlobalSearchScope resolveScope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxScopeEnlarger", "isControllerClassName"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxScopeEnlarger", "isControllerClassName"));
        }
        return qualifiedName != null && !JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName, resolveScope).isEmpty();
    }

    private static boolean needToEnlargeFieldScope(PsiField field) {
        return !field.hasModifierProperty("public") && AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (String)"javafx.fxml.FXML", (boolean)false);
    }

    private static boolean needToEnlargeMethodScope(PsiMethod method) {
        boolean isStatic = method.hasModifierProperty("static");
        return isStatic && method.getParameterList().getParametersCount() == 2 && InheritanceUtil.isInheritor((PsiType)method.getParameterList().getParameters()[0].getType(), (String)"javafx.scene.Node") || !isStatic && !method.hasModifierProperty("public") && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javafx.fxml.FXML", (boolean)false);
    }

    public static class GlobalFxmlSearchScope
    extends DelegatingGlobalSearchScope {
        public GlobalFxmlSearchScope(GlobalSearchScope baseScope) {
            super(baseScope);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxScopeEnlarger$GlobalFxmlSearchScope", "contains"));
            }
            return super.contains(file) && JavaFxFileTypeFactory.isFxml(file);
        }
    }
}

