/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.indexing.FxmlDataExternalizer;
import org.jetbrains.plugins.javaFX.indexing.FxmlDataIndexer;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxIdsIndex
extends FileBasedIndexExtension<String, Set<String>> {
    @NonNls
    public static final ID<String, Set<String>> KEY = ID.create((String)"javafx.id.name");
    private final FileBasedIndex.InputFilter myInputFilter = new JavaFxControllerClassIndex.MyInputFilter();
    private final FxmlDataIndexer myDataIndexer = new FxmlDataIndexer();
    private final FxmlDataExternalizer myDataExternalizer = new FxmlDataExternalizer();

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        FxmlDataIndexer fxmlDataIndexer = this.myDataIndexer;
        if (fxmlDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxIdsIndex", "getIndexer"));
        }
        return fxmlDataIndexer;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        FxmlDataExternalizer fxmlDataExternalizer = this.myDataExternalizer;
        if (fxmlDataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxIdsIndex", "getValueExternalizer"));
        }
        return fxmlDataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxIdsIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    @NotNull
    public ID<String, Set<String>> getName() {
        ID<String, Set<String>> iD = KEY;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxIdsIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxIdsIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public static Collection<String> getAllRegisteredIds(Project project) {
        CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
        FileBasedIndex.getInstance().processAllKeys(KEY, (Processor)processor, project);
        ArrayList<String> results = new ArrayList<String>(processor.getResults());
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Set pathSet;
            String id = (String)iterator.next();
            List values = FileBasedIndex.getInstance().getValues(KEY, (Object)id, searchScope);
            if (!values.isEmpty() && (pathSet = (Set)values.get(0)) != null) continue;
            iterator.remove();
        }
        ArrayList<String> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxIdsIndex", "getAllRegisteredIds"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<VirtualFile> getContainingFiles(Project project, String id) {
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(KEY, (Object)id, GlobalSearchScope.projectScope((Project)project));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxIdsIndex", "getContainingFiles"));
        }
        return collection;
    }
}

