/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.svg2svg;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.IntegerKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.transcoder.svg2svg.PrettyPrinter;
import org.w3c.dom.Document;

public class SVGTranscoder
extends AbstractTranscoder {
    public static final ErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void error(TranscoderException transcoderException) throws TranscoderException {
            throw transcoderException;
        }

        @Override
        public void fatalError(TranscoderException transcoderException) throws TranscoderException {
            throw transcoderException;
        }

        @Override
        public void warning(TranscoderException transcoderException) throws TranscoderException {
        }
    };
    public static final TranscodingHints.Key KEY_NEWLINE = new NewlineKey();
    public static final NewlineValue VALUE_NEWLINE_CR = new NewlineValue("\r");
    public static final NewlineValue VALUE_NEWLINE_CR_LF = new NewlineValue("\r\n");
    public static final NewlineValue VALUE_NEWLINE_LF = new NewlineValue("\n");
    public static final TranscodingHints.Key KEY_FORMAT = new BooleanKey();
    public static final Boolean VALUE_FORMAT_ON = Boolean.TRUE;
    public static final Boolean VALUE_FORMAT_OFF = Boolean.FALSE;
    public static final TranscodingHints.Key KEY_TABULATION_WIDTH = new IntegerKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_WIDTH = new IntegerKey();
    public static final TranscodingHints.Key KEY_DOCTYPE = new DoctypeKey();
    public static final DoctypeValue VALUE_DOCTYPE_CHANGE = new DoctypeValue(0);
    public static final DoctypeValue VALUE_DOCTYPE_REMOVE = new DoctypeValue(1);
    public static final DoctypeValue VALUE_DOCTYPE_KEEP_UNCHANGED = new DoctypeValue(2);
    public static final TranscodingHints.Key KEY_PUBLIC_ID = new StringKey();
    public static final TranscodingHints.Key KEY_SYSTEM_ID = new StringKey();
    public static final TranscodingHints.Key KEY_XML_DECLARATION = new StringKey();

    public SVGTranscoder() {
        this.setErrorHandler(DEFAULT_ERROR_HANDLER);
    }

    @Override
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        Reader reader = transcoderInput.getReader();
        Writer writer = transcoderOutput.getWriter();
        if (reader == null) {
            Document document = transcoderInput.getDocument();
            if (document == null) {
                throw new Error("Reader or Document expected");
            }
            StringWriter stringWriter = new StringWriter(1024);
            try {
                DOMUtilities.writeDocument(document, stringWriter);
            }
            catch (IOException iOException) {
                throw new Error("IO:" + iOException.getMessage());
            }
            reader = new StringReader(stringWriter.toString());
        }
        if (writer == null) {
            throw new Error("Writer expected");
        }
        this.prettyPrint(reader, writer);
    }

    protected void prettyPrint(Reader reader, Writer writer) throws TranscoderException {
        try {
            String string;
            DoctypeValue doctypeValue;
            Integer n;
            Boolean bl;
            PrettyPrinter prettyPrinter = new PrettyPrinter();
            NewlineValue newlineValue = (NewlineValue)this.hints.get(KEY_NEWLINE);
            if (newlineValue != null) {
                prettyPrinter.setNewline(newlineValue.getValue());
            }
            if ((bl = (Boolean)this.hints.get(KEY_FORMAT)) != null) {
                prettyPrinter.setFormat(bl);
            }
            if ((n = (Integer)this.hints.get(KEY_TABULATION_WIDTH)) != null) {
                prettyPrinter.setTabulationWidth(n);
            }
            if ((n = (Integer)this.hints.get(KEY_DOCUMENT_WIDTH)) != null) {
                prettyPrinter.setDocumentWidth(n);
            }
            if ((doctypeValue = (DoctypeValue)this.hints.get(KEY_DOCTYPE)) != null) {
                prettyPrinter.setDoctypeOption(doctypeValue.getValue());
            }
            if ((string = (String)this.hints.get(KEY_PUBLIC_ID)) != null) {
                prettyPrinter.setPublicId(string);
            }
            if ((string = (String)this.hints.get(KEY_SYSTEM_ID)) != null) {
                prettyPrinter.setSystemId(string);
            }
            if ((string = (String)this.hints.get(KEY_XML_DECLARATION)) != null) {
                prettyPrinter.setXMLDeclaration(string);
            }
            prettyPrinter.print(reader, writer);
            writer.flush();
        }
        catch (IOException iOException) {
            this.getErrorHandler().fatalError(new TranscoderException(iOException.getMessage()));
        }
    }

    protected static class DoctypeValue {
        final int value;

        protected DoctypeValue(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static class DoctypeKey
    extends TranscodingHints.Key {
        protected DoctypeKey() {
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object instanceof DoctypeValue;
        }
    }

    protected static class NewlineValue {
        protected final String value;

        protected NewlineValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }

    protected static class NewlineKey
    extends TranscodingHints.Key {
        protected NewlineKey() {
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object instanceof NewlineValue;
        }
    }
}

