/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.freeform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.mathutil.randomize.ConsistentRandomizer;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLContext;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.freeform.FreeformConnection;
import org.encog.neural.freeform.FreeformContextNeuron;
import org.encog.neural.freeform.FreeformLayer;
import org.encog.neural.freeform.FreeformNetworkError;
import org.encog.neural.freeform.FreeformNeuron;
import org.encog.neural.freeform.InputSummation;
import org.encog.neural.freeform.basic.BasicActivationSummationFactory;
import org.encog.neural.freeform.basic.BasicFreeformConnectionFactory;
import org.encog.neural.freeform.basic.BasicFreeformLayerFactory;
import org.encog.neural.freeform.basic.BasicFreeformNeuronFactory;
import org.encog.neural.freeform.factory.FreeformConnectionFactory;
import org.encog.neural.freeform.factory.FreeformLayerFactory;
import org.encog.neural.freeform.factory.FreeformNeuronFactory;
import org.encog.neural.freeform.factory.InputSummationFactory;
import org.encog.neural.freeform.task.ConnectionTask;
import org.encog.neural.freeform.task.NeuronTask;
import org.encog.neural.networks.BasicNetwork;
import org.encog.util.EngineArray;
import org.encog.util.obj.ObjectCloner;
import org.encog.util.simple.EncogUtility;

public class FreeformNetwork
extends BasicML
implements MLContext,
Cloneable,
MLRegression,
MLEncodable,
MLResettable,
MLClassification,
MLError {
    private static final long serialVersionUID = 1L;
    private FreeformLayer inputLayer;
    private FreeformLayer outputLayer;
    private final FreeformConnectionFactory connectionFactory = new BasicFreeformConnectionFactory();
    private final FreeformLayerFactory layerFactory = new BasicFreeformLayerFactory();
    private final FreeformNeuronFactory neuronFactory = new BasicFreeformNeuronFactory();
    private final InputSummationFactory summationFactory = new BasicActivationSummationFactory();

    public static FreeformNetwork createElman(int input, int hidden1, int output, ActivationFunction af) {
        FreeformNetwork network = new FreeformNetwork();
        FreeformLayer inputLayer = network.createInputLayer(input);
        FreeformLayer hiddenLayer1 = network.createLayer(hidden1);
        FreeformLayer outputLayer = network.createOutputLayer(output);
        network.connectLayers(inputLayer, hiddenLayer1, af, 1.0, false);
        network.connectLayers(hiddenLayer1, outputLayer, af, 1.0, false);
        network.createContext(hiddenLayer1, hiddenLayer1);
        network.reset();
        return network;
    }

    public static FreeformNetwork createFeedforward(int input, int hidden1, int hidden2, int output, ActivationFunction af) {
        FreeformLayer currentLayer;
        FreeformNetwork network = new FreeformNetwork();
        FreeformLayer lastLayer = network.createInputLayer(input);
        if (hidden1 > 0) {
            currentLayer = network.createLayer(hidden1);
            network.connectLayers(lastLayer, currentLayer, af, 1.0, false);
            lastLayer = currentLayer;
        }
        if (hidden2 > 0) {
            currentLayer = network.createLayer(hidden2);
            network.connectLayers(lastLayer, currentLayer, af, 1.0, false);
            lastLayer = currentLayer;
        }
        currentLayer = network.createOutputLayer(output);
        network.connectLayers(lastLayer, currentLayer, af, 1.0, false);
        network.reset();
        return network;
    }

    public FreeformNetwork() {
    }

    public FreeformNetwork(BasicNetwork network) {
        if (network.getLayerCount() < 2) {
            throw new FreeformNetworkError("The BasicNetwork must have at least two layers to be converted.");
        }
        FreeformLayer previousLayer = null;
        for (int currentLayerIndex = 0; currentLayerIndex < network.getLayerCount(); ++currentLayerIndex) {
            FreeformLayer currentLayer = this.layerFactory.factor();
            if (this.inputLayer == null) {
                this.inputLayer = currentLayer;
            }
            for (int i = 0; i < network.getLayerNeuronCount(currentLayerIndex); ++i) {
                InputSummation summation = null;
                if (previousLayer != null) {
                    summation = this.summationFactory.factor(network.getActivation(currentLayerIndex));
                }
                currentLayer.add(this.neuronFactory.factorRegular(summation));
            }
            if (previousLayer != null) {
                this.connectLayersFromBasic(network, currentLayerIndex - 1, previousLayer, currentLayerIndex, currentLayer, currentLayerIndex, false);
            }
            if (network.isLayerBiased(currentLayerIndex)) {
                FreeformNeuron biasNeuron = this.neuronFactory.factorRegular(null);
                biasNeuron.setBias(true);
                biasNeuron.setActivation(network.getLayerBiasActivation(currentLayerIndex));
                currentLayer.add(biasNeuron);
            }
            previousLayer = currentLayer;
            currentLayer = null;
        }
        this.outputLayer = previousLayer;
    }

    @Override
    public double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    @Override
    public int classify(MLData input) {
        MLData output = this.compute(input);
        return EngineArray.maxIndex(output.getData());
    }

    @Override
    public void clearContext() {
        this.performNeuronTask(new NeuronTask(){

            @Override
            public void task(FreeformNeuron neuron) {
                if (neuron instanceof FreeformContextNeuron) {
                    neuron.setActivation(0.0);
                }
            }
        });
    }

    public Object clone() {
        BasicNetwork result = (BasicNetwork)ObjectCloner.deepCopy(this);
        return result;
    }

    @Override
    public MLData compute(MLData input) {
        int i;
        BasicMLData result = new BasicMLData(this.outputLayer.size());
        for (i = 0; i < input.size(); ++i) {
            this.inputLayer.setActivation(i, input.getData(i));
        }
        for (i = 0; i < this.outputLayer.size(); ++i) {
            FreeformNeuron outputNeuron = this.outputLayer.getNeurons().get(i);
            outputNeuron.performCalculation();
            result.setData(i, outputNeuron.getActivation());
        }
        this.updateContext();
        return result;
    }

    public void connectLayers(FreeformLayer source, FreeformLayer target) {
        this.connectLayers(source, target, new ActivationTANH(), 1.0, false);
    }

    public void connectLayers(FreeformLayer source, FreeformLayer target, ActivationFunction theActivationFunction, double biasActivation, boolean isRecurrent) {
        if (biasActivation > 1.0E-13) {
            if (source.hasBias()) {
                throw new FreeformNetworkError("The source layer already has a bias neuron, you cannot create a second.");
            }
            FreeformNeuron biasNeuron = this.neuronFactory.factorRegular(null);
            biasNeuron.setActivation(biasActivation);
            biasNeuron.setBias(true);
            source.add(biasNeuron);
        }
        for (FreeformNeuron targetNeuron : target.getNeurons()) {
            InputSummation summation = targetNeuron.getInputSummation();
            if (summation == null) {
                summation = this.summationFactory.factor(theActivationFunction);
                targetNeuron.setInputSummation(summation);
            }
            for (FreeformNeuron sourceNeuron : source.getNeurons()) {
                FreeformConnection connection = this.connectionFactory.factor(sourceNeuron, targetNeuron);
                sourceNeuron.addOutput(connection);
                targetNeuron.addInput(connection);
            }
        }
    }

    public void ConnectLayers(FreeformLayer source, FreeformLayer target, ActivationFunction theActivationFunction) {
        this.connectLayers(source, target, theActivationFunction, 1.0, false);
    }

    private void connectLayersFromBasic(BasicNetwork network, int fromLayerIdx, FreeformLayer source, int sourceIdx, FreeformLayer target, int targetIdx, boolean isRecurrent) {
        for (int targetNeuronIdx = 0; targetNeuronIdx < target.size(); ++targetNeuronIdx) {
            for (int sourceNeuronIdx = 0; sourceNeuronIdx < source.size(); ++sourceNeuronIdx) {
                FreeformNeuron sourceNeuron = source.getNeurons().get(sourceNeuronIdx);
                FreeformNeuron targetNeuron = target.getNeurons().get(targetNeuronIdx);
                if (targetNeuron.getInputSummation() == null) continue;
                FreeformConnection connection = this.connectionFactory.factor(sourceNeuron, targetNeuron);
                sourceNeuron.addOutput(connection);
                targetNeuron.addInput(connection);
                double weight = network.getWeight(fromLayerIdx, sourceNeuronIdx, targetNeuronIdx);
                connection.setWeight(weight);
            }
        }
    }

    public FreeformLayer createContext(FreeformLayer source, FreeformLayer target) {
        double biasActivation = 0.0;
        ActivationFunction activatonFunction = null;
        if (source.getNeurons().get(0).getOutputs().size() < 1) {
            throw new FreeformNetworkError("A layer cannot have a context layer connected if there are no other outbound connections from the source layer.  Please connect the source layer somewhere else first.");
        }
        activatonFunction = source.getNeurons().get(0).getInputSummation().getActivationFunction();
        FreeformLayer result = this.layerFactory.factor();
        for (int i = 0; i < source.size(); ++i) {
            FreeformNeuron neuron = source.getNeurons().get(i);
            if (neuron.isBias()) {
                FreeformNeuron biasNeuron = this.neuronFactory.factorRegular(null);
                biasNeuron.setBias(true);
                biasNeuron.setActivation(neuron.getActivation());
                result.add(biasNeuron);
                continue;
            }
            FreeformNeuron contextNeuron = this.neuronFactory.factorContext(neuron);
            result.add(contextNeuron);
        }
        this.connectLayers(result, target, activatonFunction, 0.0, false);
        return result;
    }

    public FreeformLayer createInputLayer(int neuronCount) {
        if (neuronCount < 1) {
            throw new FreeformNetworkError("Input layer must have at least one neuron.");
        }
        this.inputLayer = this.createLayer(neuronCount);
        return this.inputLayer;
    }

    public FreeformLayer createLayer(int neuronCount) {
        if (neuronCount < 1) {
            throw new FreeformNetworkError("Layer must have at least one neuron.");
        }
        FreeformLayer result = this.layerFactory.factor();
        for (int i = 0; i < neuronCount; ++i) {
            result.add(this.neuronFactory.factorRegular(null));
        }
        return result;
    }

    public FreeformLayer createOutputLayer(int neuronCount) {
        if (neuronCount < 1) {
            throw new FreeformNetworkError("Output layer must have at least one neuron.");
        }
        this.outputLayer = this.createLayer(neuronCount);
        return this.outputLayer;
    }

    @Override
    public void decodeFromArray(double[] encoded) {
        int index = 0;
        HashSet<FreeformNeuron> visited = new HashSet<FreeformNeuron>();
        ArrayList<FreeformNeuron> queue = new ArrayList<FreeformNeuron>();
        for (FreeformNeuron neuron : this.outputLayer.getNeurons()) {
            queue.add(neuron);
        }
        while (queue.size() > 0) {
            FreeformNeuron neuron = (FreeformNeuron)queue.get(0);
            queue.remove(0);
            visited.add(neuron);
            if (neuron.getInputSummation() == null) continue;
            for (FreeformConnection connection : neuron.getInputSummation().list()) {
                connection.setWeight(encoded[index++]);
                FreeformNeuron nextNeuron = connection.getSource();
                if (visited.contains(nextNeuron)) continue;
                queue.add(nextNeuron);
            }
        }
    }

    @Override
    public int encodedArrayLength() {
        int result = 0;
        HashSet<FreeformNeuron> visited = new HashSet<FreeformNeuron>();
        ArrayList<FreeformNeuron> queue = new ArrayList<FreeformNeuron>();
        for (FreeformNeuron neuron : this.outputLayer.getNeurons()) {
            queue.add(neuron);
        }
        while (queue.size() > 0) {
            FreeformNeuron neuron = (FreeformNeuron)queue.get(0);
            queue.remove(0);
            visited.add(neuron);
            if (neuron.getInputSummation() == null) continue;
            for (FreeformConnection connection : neuron.getInputSummation().list()) {
                ++result;
                FreeformNeuron nextNeuron = connection.getSource();
                if (visited.contains(nextNeuron)) continue;
                queue.add(nextNeuron);
            }
        }
        return result;
    }

    @Override
    public void encodeToArray(double[] encoded) {
        int index = 0;
        HashSet<FreeformNeuron> visited = new HashSet<FreeformNeuron>();
        ArrayList<FreeformNeuron> queue = new ArrayList<FreeformNeuron>();
        for (FreeformNeuron neuron : this.outputLayer.getNeurons()) {
            queue.add(neuron);
        }
        while (queue.size() > 0) {
            FreeformNeuron neuron = (FreeformNeuron)queue.get(0);
            queue.remove(0);
            visited.add(neuron);
            if (neuron.getInputSummation() == null) continue;
            for (FreeformConnection connection : neuron.getInputSummation().list()) {
                encoded[index++] = connection.getWeight();
                FreeformNeuron nextNeuron = connection.getSource();
                if (visited.contains(nextNeuron)) continue;
                queue.add(nextNeuron);
            }
        }
    }

    @Override
    public int getInputCount() {
        return this.inputLayer.sizeNonBias();
    }

    @Override
    public int getOutputCount() {
        return this.outputLayer.sizeNonBias();
    }

    public FreeformLayer getOutputLayer() {
        return this.outputLayer;
    }

    public void performConnectionTask(ConnectionTask task) {
        HashSet<FreeformNeuron> visited = new HashSet<FreeformNeuron>();
        for (FreeformNeuron neuron : this.outputLayer.getNeurons()) {
            this.performConnectionTask(visited, neuron, task);
        }
    }

    private void performConnectionTask(Set<FreeformNeuron> visited, FreeformNeuron parentNeuron, ConnectionTask task) {
        visited.add(parentNeuron);
        if (parentNeuron.getInputSummation() != null) {
            for (FreeformConnection connection : parentNeuron.getInputSummation().list()) {
                task.task(connection);
                FreeformNeuron neuron = connection.getSource();
                if (visited.contains(neuron)) continue;
                this.performConnectionTask(visited, neuron, task);
            }
        }
    }

    public void performNeuronTask(NeuronTask task) {
        HashSet<FreeformNeuron> visited = new HashSet<FreeformNeuron>();
        for (FreeformNeuron neuron : this.outputLayer.getNeurons()) {
            this.performNeuronTask(visited, neuron, task);
        }
    }

    private void performNeuronTask(Set<FreeformNeuron> visited, FreeformNeuron parentNeuron, NeuronTask task) {
        visited.add(parentNeuron);
        task.task(parentNeuron);
        if (parentNeuron.getInputSummation() != null) {
            for (FreeformConnection connection : parentNeuron.getInputSummation().list()) {
                FreeformNeuron neuron = connection.getSource();
                if (visited.contains(neuron)) continue;
                this.performNeuronTask(visited, neuron, task);
            }
        }
    }

    @Override
    public void reset() {
        this.reset((int)(System.currentTimeMillis() % Integer.MAX_VALUE));
    }

    @Override
    public void reset(int seed) {
        final ConsistentRandomizer randomizer = new ConsistentRandomizer(-1.0, 1.0, seed);
        this.performConnectionTask(new ConnectionTask(){

            @Override
            public void task(FreeformConnection connection) {
                connection.setWeight(randomizer.nextDouble());
            }
        });
    }

    public void tempTrainingAllocate(final int neuronSize, final int connectionSize) {
        this.performNeuronTask(new NeuronTask(){

            @Override
            public void task(FreeformNeuron neuron) {
                neuron.allocateTempTraining(neuronSize);
                if (neuron.getInputSummation() != null) {
                    for (FreeformConnection connection : neuron.getInputSummation().list()) {
                        connection.allocateTempTraining(connectionSize);
                    }
                }
            }
        });
    }

    public void tempTrainingClear() {
        this.performNeuronTask(new NeuronTask(){

            @Override
            public void task(FreeformNeuron neuron) {
                neuron.clearTempTraining();
                if (neuron.getInputSummation() != null) {
                    for (FreeformConnection connection : neuron.getInputSummation().list()) {
                        connection.clearTempTraining();
                    }
                }
            }
        });
    }

    public void updateContext() {
        this.performNeuronTask(new NeuronTask(){

            @Override
            public void task(FreeformNeuron neuron) {
                neuron.updateContext();
            }
        });
    }

    @Override
    public void updateProperties() {
    }
}

