/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.zaproxy.zap.extension.httppanel.ComponentChangedEvent;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.MessagePanelEventListener;
import org.zaproxy.zap.extension.httppanel.MessageViewSelectedEvent;
import org.zaproxy.zap.extension.httppanel.component.HttpPanelComponentInterface;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelComponent;
import org.zaproxy.zap.extension.tab.Tab;

public abstract class HttpPanel
extends AbstractPanel
implements Tab {
    private static final long serialVersionUID = 5221591643257366570L;
    private static final Logger logger = Logger.getLogger(HttpPanel.class);
    private static final String NO_SUITABLE_COMPONENT_FOUND_LABEL = Constant.messages.getString("http.panel.noSuitableComponentFound");
    private static final String HTTP_PANEL_KEY = "httppanel.";
    private static final String COMPONENTS_KEY = "components.";
    private static final String DEFAULT_COMPONENT_KEY = "defaultcomponent";
    private static Comparator<HttpPanelComponentInterface> componentsComparator;
    private JPanel panelHeader;
    private JPanel panelContent;
    private boolean isEditable = false;
    private boolean isEnableViewSelect = false;
    protected Message message;
    private String baseConfigurationKey;
    private String componentsConfigurationKey;
    private SwitchComponentItemListener switchComponentItemListener;
    private Hashtable<String, HttpPanelComponentInterface> components = new Hashtable();
    private List<HttpPanelComponentInterface> enabledComponents = new ArrayList<HttpPanelComponentInterface>();
    private HttpPanelComponentInterface currentComponent;
    private JPanel noComponentsPanel;
    private String savedLastSelectedComponentName;
    private JPanel allOptions;
    private JPanel componentOptions;
    private JPanel moreOptionsComponent;
    private JToolBar toolBarComponents;
    private JToolBar toolBarMoreOptions;
    private JPanel endAllOptions;

    public HttpPanel(boolean bl, String string) {
        this.isEditable = bl;
        this.message = null;
        this.setConfigurationKey(string);
        this.initialize();
        this.initUi();
        this.initSpecial();
    }

    protected abstract void initComponents();

    protected abstract void initSpecial();

    private void setConfigurationKey(String string) {
        this.baseConfigurationKey = string + HTTP_PANEL_KEY;
        this.componentsConfigurationKey = this.baseConfigurationKey + COMPONENTS_KEY;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanelHeader(), "North");
        this.add((Component)this.getPanelContent(), "Center");
    }

    private void initUi() {
        this.allOptions = new JPanel(new FlowLayout(1, 0, 0));
        this.componentOptions = new JPanel(new BorderLayout(0, 0));
        this.moreOptionsComponent = new JPanel(new BorderLayout(0, 0));
        this.toolBarComponents = new JToolBar();
        this.toolBarComponents.setFloatable(false);
        this.toolBarComponents.setBorder(BorderFactory.createEmptyBorder());
        this.toolBarComponents.setRollover(true);
        this.toolBarMoreOptions = new JToolBar();
        this.toolBarMoreOptions.setFloatable(false);
        this.toolBarMoreOptions.setBorder(BorderFactory.createEmptyBorder());
        this.toolBarMoreOptions.setRollover(true);
        this.endAllOptions = new JPanel();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(this.allOptions);
        jPanel2.add(this.componentOptions);
        jPanel2.add(this.toolBarComponents);
        jPanel2.add(this.moreOptionsComponent);
        jPanel2.add(this.toolBarMoreOptions);
        jPanel.add((Component)jPanel2, "West");
        jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(this.endAllOptions);
        jPanel.add((Component)jPanel2, "East");
        this.panelHeader.add((Component)jPanel, "North");
        this.initComponents();
        this.setMessage(null);
    }

    private JPanel getPanelContent() {
        if (this.panelContent == null) {
            this.panelContent = new JPanel(new CardLayout());
        }
        return this.panelContent;
    }

    private JPanel getPanelHeader() {
        if (this.panelHeader == null) {
            this.panelHeader = new JPanel(new BorderLayout());
        }
        return this.panelHeader;
    }

    public void setMessage(Message message) {
        this.message = message;
        Iterator<Map.Entry<String, HttpPanelComponentInterface>> iterator = this.components.entrySet().iterator();
        while (iterator.hasNext()) {
            HttpPanelComponentInterface httpPanelComponentInterface = iterator.next().getValue();
            if (!httpPanelComponentInterface.isEnabled(this.message)) {
                if (!this.enabledComponents.contains(httpPanelComponentInterface)) continue;
                this.disableComponent(httpPanelComponentInterface);
                continue;
            }
            if (this.enabledComponents.contains(httpPanelComponentInterface)) continue;
            this.enableComponent(httpPanelComponentInterface);
        }
        if (this.enabledComponents.size() == 0) {
            this.currentComponent = null;
            this.switchEmptyComponent();
            return;
        }
        boolean bl = true;
        if (this.currentComponent != null && this.enabledComponents.contains(this.components.get(this.currentComponent.getName()))) {
            bl = false;
        }
        this.validate();
        if (bl) {
            this.switchComponent(this.enabledComponents.get(0).getName());
        } else {
            this.updateContent();
        }
    }

    protected HttpPanelComponentInterface getCurrentComponent() {
        return this.currentComponent;
    }

    public Message getMessage() {
        return this.message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEditable(boolean bl) {
        if (this.isEditable != bl) {
            this.isEditable = bl;
            Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
            synchronized (hashtable) {
                Iterator<HttpPanelComponentInterface> iterator = this.components.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().setEditable(bl);
                }
            }
        }
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void clearView() {
        this.setMessage(null);
        if (this.currentComponent != null) {
            this.currentComponent.clearView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnableViewSelect(boolean bl) {
        if (this.isEnableViewSelect != bl) {
            this.isEnableViewSelect = bl;
            Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
            synchronized (hashtable) {
                for (HttpPanelComponentInterface httpPanelComponentInterface : this.components.values()) {
                    httpPanelComponentInterface.setEnableViewSelect(bl);
                    httpPanelComponentInterface.getButton().setEnabled(bl);
                }
            }
        }
    }

    public boolean isEnableViewSelect() {
        return this.isEnableViewSelect;
    }

    public void clearView(boolean bl) {
        this.clearView();
        this.setEnableViewSelect(bl);
    }

    public void setMessage(Message message, boolean bl) {
        this.setMessage(message);
        this.setEnableViewSelect(bl);
    }

    public void updateContent() {
        if (this.currentComponent != null) {
            this.currentComponent.setMessage(this.message);
        }
    }

    public void saveData() {
        if (this.message == null || this.currentComponent == null) {
            return;
        }
        this.currentComponent.save();
    }

    private void switchComponent(String string) {
        if (this.currentComponent != null && this.currentComponent.getName().equals(string)) {
            this.currentComponent.setSelected(true);
            return;
        }
        HttpPanelComponentInterface httpPanelComponentInterface = this.components.get(string);
        if (httpPanelComponentInterface == null) {
            logger.info((Object)("No component found with name: " + string));
            return;
        }
        if (this.currentComponent != null) {
            this.currentComponent.setSelected(false);
            this.currentComponent.clearView();
            if (this.currentComponent.getOptionsPanel() != null) {
                this.componentOptions.remove(0);
            }
            if (this.currentComponent.getMoreOptionsPanel() != null) {
                this.moreOptionsComponent.remove(0);
            }
        }
        HttpPanelComponentInterface httpPanelComponentInterface2 = this.currentComponent;
        this.currentComponent = httpPanelComponentInterface;
        this.updateContent();
        JPanel jPanel = this.currentComponent.getOptionsPanel();
        if (jPanel != null) {
            this.componentOptions.add(jPanel);
        }
        this.componentOptions.validate();
        JPanel jPanel2 = this.currentComponent.getMoreOptionsPanel();
        if (jPanel2 != null) {
            this.moreOptionsComponent.add(jPanel2);
        }
        this.moreOptionsComponent.validate();
        ((CardLayout)this.getPanelContent().getLayout()).show(this.panelContent, string);
        this.currentComponent.setSelected(true);
        this.fireComponentChangedEvent(httpPanelComponentInterface2, this.currentComponent);
    }

    protected List<HttpPanelComponentInterface> getEnabledComponents() {
        return this.enabledComponents;
    }

    private void switchEmptyComponent() {
        if (this.currentComponent != null) {
            this.currentComponent.setSelected(false);
            this.currentComponent.clearView();
            if (this.currentComponent.getOptionsPanel() != null) {
                this.componentOptions.remove(0);
            }
            if (this.currentComponent.getMoreOptionsPanel() != null) {
                this.moreOptionsComponent.remove(0);
            }
            this.currentComponent = null;
        }
        if (this.noComponentsPanel == null) {
            this.noComponentsPanel = new JPanel(new BorderLayout(5, 5));
            this.noComponentsPanel.add(new JLabel(NO_SUITABLE_COMPONENT_FOUND_LABEL));
            this.getPanelContent().add((Component)new JScrollPane(this.noComponentsPanel), "");
        }
        this.componentOptions.removeAll();
        this.componentOptions.validate();
        ((CardLayout)this.getPanelContent().getLayout()).show(this.panelContent, "");
    }

    public void addOptions(Component component, OptionsLocation optionsLocation) {
        switch (optionsLocation) {
            case BEGIN: {
                this.allOptions.add(component);
                break;
            }
            case AFTER_COMPONENTS: {
                this.toolBarMoreOptions.add(component);
                break;
            }
            case END: {
                this.endAllOptions.add(component);
                break;
            }
        }
    }

    public void addOptionsSeparator() {
        this.toolBarMoreOptions.addSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComponent(HttpPanelComponentInterface httpPanelComponentInterface) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            String string = httpPanelComponentInterface.getName();
            if (this.components.containsKey(string)) {
                this.removeComponent(string);
            }
            httpPanelComponentInterface.setEditable(this.isEditable);
            httpPanelComponentInterface.setEnableViewSelect(this.isEnableViewSelect);
            this.components.put(string, httpPanelComponentInterface);
            this.panelContent.add((Component)httpPanelComponentInterface.getMainPanel(), string);
            JToggleButton jToggleButton = httpPanelComponentInterface.getButton();
            jToggleButton.setActionCommand(string);
            jToggleButton.addActionListener(this.getSwitchComponentItemListener());
            jToggleButton.setEnabled(this.isEnableViewSelect);
            if (httpPanelComponentInterface.isEnabled(this.message)) {
                this.enableComponent(httpPanelComponentInterface);
                if (this.currentComponent == null) {
                    this.switchComponent(string);
                } else if (this.savedLastSelectedComponentName != null && this.savedLastSelectedComponentName.equals(string)) {
                    this.switchComponent(string);
                } else if (this.savedLastSelectedComponentName == null && this.currentComponent.getPosition() > httpPanelComponentInterface.getPosition()) {
                    this.switchComponent(string);
                }
            }
        }
    }

    private void enableComponent(HttpPanelComponentInterface httpPanelComponentInterface) {
        this.enabledComponents.add(httpPanelComponentInterface);
        Collections.sort(this.enabledComponents, HttpPanel.getComponentsComparator());
        if (this.enabledComponents.size() == 1) {
            this.toolBarComponents.addSeparator();
            this.toolBarComponents.addSeparator();
        }
        this.toolBarComponents.add((Component)httpPanelComponentInterface.getButton(), this.enabledComponents.indexOf(httpPanelComponentInterface) + 1);
    }

    private void disableComponent(HttpPanelComponentInterface httpPanelComponentInterface) {
        this.toolBarComponents.remove(httpPanelComponentInterface.getButton());
        this.enabledComponents.remove(httpPanelComponentInterface);
        if (this.enabledComponents.size() == 0) {
            this.toolBarComponents.removeAll();
        }
    }

    public void addComponent(HttpPanelComponentInterface httpPanelComponentInterface, FileConfiguration fileConfiguration) {
        this.addComponent(httpPanelComponentInterface);
        httpPanelComponentInterface.setParentConfigurationKey(this.componentsConfigurationKey);
        httpPanelComponentInterface.loadConfig(fileConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(String string) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface httpPanelComponentInterface = this.components.get(string);
            if (httpPanelComponentInterface != null) {
                if (httpPanelComponentInterface.isEnabled(this.message)) {
                    this.disableComponent(httpPanelComponentInterface);
                }
                if (this.enabledComponents.size() > 0) {
                    this.switchComponent(this.enabledComponents.get(0).getName());
                } else {
                    this.switchEmptyComponent();
                }
                this.components.remove(string);
                this.panelContent.remove(httpPanelComponentInterface.getMainPanel());
                this.validate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addView(String string, HttpPanelView httpPanelView, Object object, FileConfiguration fileConfiguration) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface httpPanelComponentInterface = this.components.get(string);
            if (httpPanelComponentInterface != null) {
                httpPanelComponentInterface.addView(httpPanelView, object, fileConfiguration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(String string, String string2, Object object) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface httpPanelComponentInterface = this.components.get(string);
            if (httpPanelComponentInterface != null) {
                httpPanelComponentInterface.removeView(string2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultViewSelector(String string, HttpPanelDefaultViewSelector httpPanelDefaultViewSelector, Object object) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface httpPanelComponentInterface = this.components.get(string);
            if (httpPanelComponentInterface != null) {
                httpPanelComponentInterface.addDefaultViewSelector(httpPanelDefaultViewSelector, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefaultViewSelector(String string, String string2, Object object) {
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            HttpPanelComponentInterface httpPanelComponentInterface = this.components.get(string);
            if (httpPanelComponentInterface != null) {
                httpPanelComponentInterface.removeDefaultViewSelector(string2, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(FileConfiguration fileConfiguration) {
        this.savedLastSelectedComponentName = fileConfiguration.getString(this.baseConfigurationKey + DEFAULT_COMPONENT_KEY);
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            Iterator<HttpPanelComponentInterface> iterator = this.components.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().loadConfig(fileConfiguration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig(FileConfiguration fileConfiguration) {
        if (this.currentComponent != null) {
            fileConfiguration.setProperty(this.baseConfigurationKey + DEFAULT_COMPONENT_KEY, (Object)this.currentComponent.getName());
        }
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            Iterator<HttpPanelComponentInterface> iterator = this.components.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().saveConfig(fileConfiguration);
            }
        }
    }

    private static Comparator<HttpPanelComponentInterface> getComponentsComparator() {
        if (componentsComparator == null) {
            HttpPanel.createComponentsComparator();
        }
        return componentsComparator;
    }

    private static synchronized void createComponentsComparator() {
        if (componentsComparator == null) {
            componentsComparator = new ComponentsComparator();
        }
    }

    private SwitchComponentItemListener getSwitchComponentItemListener() {
        if (this.switchComponentItemListener == null) {
            this.switchComponentItemListener = new SwitchComponentItemListener();
        }
        return this.switchComponentItemListener;
    }

    public void highlightHeader(SearchMatch searchMatch) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightHeader(searchMatch);
        } else {
            HttpPanelComponentInterface httpPanelComponentInterface = this.findSearchablePanel();
            if (httpPanelComponentInterface != null) {
                this.switchComponent(httpPanelComponentInterface.getName());
                ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightHeader(searchMatch);
            }
        }
    }

    public void highlightBody(SearchMatch searchMatch) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightBody(searchMatch);
        } else {
            HttpPanelComponentInterface httpPanelComponentInterface = this.findSearchablePanel();
            if (httpPanelComponentInterface != null) {
                this.switchComponent(httpPanelComponentInterface.getName());
                ((SearchableHttpPanelComponent)((Object)this.currentComponent)).highlightBody(searchMatch);
            }
        }
    }

    public void headerSearch(Pattern pattern, List<SearchMatch> list) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).searchHeader(pattern, list);
        } else {
            HttpPanelComponentInterface httpPanelComponentInterface = this.findSearchablePanel();
            if (httpPanelComponentInterface != null) {
                ((SearchableHttpPanelComponent)((Object)httpPanelComponentInterface)).searchHeader(pattern, list);
            }
        }
    }

    public void bodySearch(Pattern pattern, List<SearchMatch> list) {
        if (this.currentComponent instanceof SearchableHttpPanelComponent) {
            ((SearchableHttpPanelComponent)((Object)this.currentComponent)).searchBody(pattern, list);
        } else {
            HttpPanelComponentInterface httpPanelComponentInterface = this.findSearchablePanel();
            if (httpPanelComponentInterface != null) {
                ((SearchableHttpPanelComponent)((Object)httpPanelComponentInterface)).searchBody(pattern, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpPanelComponentInterface findSearchablePanel() {
        HttpPanelComponentInterface httpPanelComponentInterface = null;
        Hashtable<String, HttpPanelComponentInterface> hashtable = this.components;
        synchronized (hashtable) {
            for (HttpPanelComponentInterface httpPanelComponentInterface2 : this.components.values()) {
                if (!(httpPanelComponentInterface2 instanceof SearchableHttpPanelComponent)) continue;
                httpPanelComponentInterface = httpPanelComponentInterface2;
                break;
            }
        }
        return httpPanelComponentInterface;
    }

    public void addMessagePanelEventListener(MessagePanelEventListener messagePanelEventListener) {
        this.listenerList.add(MessagePanelEventListener.class, messagePanelEventListener);
    }

    public void removeMessagePanelEventListener(MessagePanelEventListener messagePanelEventListener) {
        this.listenerList.remove(MessagePanelEventListener.class, messagePanelEventListener);
    }

    public void fireMessageViewChangedEvent(HttpPanelView httpPanelView, HttpPanelView httpPanelView2) {
        MessageViewSelectedEvent messageViewSelectedEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MessagePanelEventListener.class) continue;
            if (messageViewSelectedEvent == null) {
                messageViewSelectedEvent = new MessageViewSelectedEvent(this, httpPanelView, httpPanelView2);
            }
            ((MessagePanelEventListener)objectArray[i + 1]).viewSelected(messageViewSelectedEvent);
        }
    }

    private void fireComponentChangedEvent(HttpPanelComponentInterface httpPanelComponentInterface, HttpPanelComponentInterface httpPanelComponentInterface2) {
        ComponentChangedEvent componentChangedEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MessagePanelEventListener.class) continue;
            if (componentChangedEvent == null) {
                componentChangedEvent = new ComponentChangedEvent(this, httpPanelComponentInterface, httpPanelComponentInterface2);
            }
            ((MessagePanelEventListener)objectArray[i + 1]).componentChanged(componentChangedEvent);
        }
    }

    private final class SwitchComponentItemListener
    implements ActionListener {
        private SwitchComponentItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (HttpPanel.this.isEditable()) {
                HttpPanel.this.saveData();
            }
            HttpPanel.this.switchComponent(actionEvent.getActionCommand());
        }
    }

    private static final class ComponentsComparator
    implements Comparator<HttpPanelComponentInterface>,
    Serializable {
        private static final long serialVersionUID = -1380844848294384189L;

        private ComponentsComparator() {
        }

        @Override
        public int compare(HttpPanelComponentInterface httpPanelComponentInterface, HttpPanelComponentInterface httpPanelComponentInterface2) {
            int n;
            int n2 = httpPanelComponentInterface.getPosition();
            if (n2 < (n = httpPanelComponentInterface2.getPosition())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }

    public static enum OptionsLocation {
        BEGIN,
        AFTER_COMPONENTS,
        END;

    }
}

