/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.main;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTable
extends JTable {
    private TableColumnModel _tcm;
    private String[] _columnNames;
    private Map<String, Integer> _positions = new HashMap<String, Integer>();
    private Map<String, ColumnData> _hiddens = new HashMap<String, ColumnData>();

    public BasicTable(DefaultTableModel tableModel, String[] columnNames) {
        super(tableModel);
        this._columnNames = columnNames;
        for (int i = 0; i < columnNames.length; ++i) {
            tableModel.addColumn(columnNames[i]);
            this._positions.put(columnNames[i], i);
        }
        this._tcm = this.getColumnModel();
    }

    public void showColumns(List<Boolean> views) {
        for (int i = 0; i < this._columnNames.length - 1; ++i) {
            this.showColumn(views.get(i), i);
        }
    }

    public void showColumn(boolean show, int index) {
        String name = this._columnNames[index];
        if (show) {
            this.show(name);
        } else {
            this.hide(name);
        }
    }

    private void hide(String name) {
        try {
            int index = this._tcm.getColumnIndex(name);
            TableColumn column = this._tcm.getColumn(index);
            ColumnData cd = new ColumnData(column, index);
            if (this._hiddens.put(name, cd) != null) {
                throw new IllegalArgumentException("Duplicate column name");
            }
            this._tcm.removeColumn(column);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void show(String name) {
        ColumnData cd = this._hiddens.remove(name);
        if (cd != null) {
            this._tcm.addColumn(cd.column);
            int lastColumn = this._tcm.getColumnCount() - 1;
            if (cd.index < lastColumn) {
                this._tcm.moveColumn(lastColumn, this.getSortedPosition(name));
            }
        }
    }

    private int getSortedPosition(String name) {
        int pos = this._positions.get(name);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String colName = this._tcm.getColumn(i).getHeaderValue().toString();
            int absPosition = this._positions.get(colName);
            if (pos >= absPosition) continue;
            return this._tcm.getColumnIndex(colName);
        }
        return 0;
    }

    public void clear() {
        ((DefaultTableModel)this.getModel()).setNumRows(0);
    }

    private class ColumnData {
        private int index;
        private TableColumn column;

        public ColumnData(TableColumn column, int index) {
            this.column = column;
            this.index = index;
        }
    }
}

