/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import sun.security.util.Debug;

class KeyStoreDelegator
extends KeyStoreSpi {
    private static final String KEYSTORE_TYPE_COMPAT = "keystore.type.compat";
    private static final Debug debug = Debug.getInstance("keystore");
    private final String primaryType;
    private final String secondaryType;
    private final Class<? extends KeyStoreSpi> primaryKeyStore;
    private final Class<? extends KeyStoreSpi> secondaryKeyStore;
    private String type;
    private KeyStoreSpi keystore;
    private boolean compatModeEnabled = "true".equalsIgnoreCase(AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return Security.getProperty(KeyStoreDelegator.KEYSTORE_TYPE_COMPAT);
        }
    }));

    public KeyStoreDelegator(String string, Class<? extends KeyStoreSpi> clazz, String string2, Class<? extends KeyStoreSpi> clazz2) {
        if (this.compatModeEnabled) {
            this.primaryType = string;
            this.secondaryType = string2;
            this.primaryKeyStore = clazz;
            this.secondaryKeyStore = clazz2;
        } else {
            this.primaryType = string;
            this.secondaryType = null;
            this.primaryKeyStore = clazz;
            this.secondaryKeyStore = null;
            if (debug != null) {
                debug.println("WARNING: compatibility mode disabled for " + string + " and " + string2 + " keystore types");
            }
        }
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.keystore.engineGetKey(string, cArray);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        return this.keystore.engineGetCertificateChain(string);
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        return this.keystore.engineGetCertificate(string);
    }

    @Override
    public Date engineGetCreationDate(String string) {
        return this.keystore.engineGetCreationDate(string);
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this.keystore.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.keystore.engineSetKeyEntry(string, byArray, certificateArray);
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.keystore.engineSetCertificateEntry(string, certificate);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        this.keystore.engineDeleteEntry(string);
    }

    @Override
    public Enumeration<String> engineAliases() {
        return this.keystore.engineAliases();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.keystore.engineContainsAlias(string);
    }

    @Override
    public int engineSize() {
        return this.keystore.engineSize();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return this.keystore.engineIsKeyEntry(string);
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return this.keystore.engineIsCertificateEntry(string);
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        return this.keystore.engineGetCertificateAlias(certificate);
    }

    @Override
    public KeyStore.Entry engineGetEntry(String string, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        return this.keystore.engineGetEntry(string, protectionParameter);
    }

    @Override
    public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        this.keystore.engineSetEntry(string, entry, protectionParameter);
    }

    @Override
    public boolean engineEntryInstanceOf(String string, Class<? extends KeyStore.Entry> clazz) {
        return this.keystore.engineEntryInstanceOf(string, clazz);
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.println("Storing keystore in " + this.type + " format");
        }
        this.keystore.engineStore(outputStream, cArray);
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream == null || !this.compatModeEnabled) {
            try {
                this.keystore = this.primaryKeyStore.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
            this.type = this.primaryType;
            if (debug != null && inputStream == null) {
                debug.println("Creating a new keystore in " + this.type + " format");
            }
            this.keystore.engineLoad(inputStream, cArray);
        } else {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                ((InputStream)bufferedInputStream).mark(Integer.MAX_VALUE);
                try {
                    this.keystore = this.primaryKeyStore.newInstance();
                    this.type = this.primaryType;
                    this.keystore.engineLoad(bufferedInputStream, cArray);
                }
                catch (Exception exception) {
                    if (exception instanceof IOException && exception.getCause() instanceof UnrecoverableKeyException) {
                        throw (IOException)exception;
                    }
                    try {
                        this.keystore = this.secondaryKeyStore.newInstance();
                        this.type = this.secondaryType;
                        ((InputStream)bufferedInputStream).reset();
                        this.keystore.engineLoad(bufferedInputStream, cArray);
                        if (debug != null) {
                            debug.println("WARNING: switching from " + this.primaryType + " to " + this.secondaryType + " keystore file format has altered the " + "keystore security level");
                        }
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    }
                    catch (IOException | NoSuchAlgorithmException | CertificateException exception2) {
                        if (exception2 instanceof IOException && exception2.getCause() instanceof UnrecoverableKeyException) {
                            throw (IOException)exception2;
                        }
                        if (exception instanceof IOException) {
                            throw (IOException)exception;
                        }
                        if (exception instanceof CertificateException) {
                            throw (CertificateException)exception;
                        }
                        if (exception instanceof NoSuchAlgorithmException) {
                            throw (NoSuchAlgorithmException)exception;
                        }
                    }
                }
            }
            if (debug != null) {
                debug.println("Loaded a keystore in " + this.type + " format");
            }
        }
    }
}

