/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.Diagnostic;

class CleaningAnnotationProcessorImpl
implements Runnable {
    private final ProcessingEnvironment processingEnv;
    private final RoundEnvironment roundEnv;
    private final Set<String> seenElements;
    private static final AtomicReference<Boolean> HAS_BUG = new AtomicReference();

    public CleaningAnnotationProcessorImpl(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnvironment, Set<String> set) {
        this.processingEnv = processingEnvironment;
        this.roundEnv = roundEnvironment;
        this.seenElements = set;
    }

    @Override
    public void run() {
        try {
            if (!this.shouldWorkaroundBug()) {
                return;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Attempting to workaround javac bug #6512707");
            final Trees trees = Trees.instance(this.processingEnv);
            final LinkedList linkedList = new LinkedList();
            for (Element object : this.roundEnv.getRootElements()) {
                if (!object.getKind().isClass() && !object.getKind().isInterface()) continue;
                this.seenElements.add(((TypeElement)object).getQualifiedName().toString());
            }
            for (String string : this.seenElements) {
                TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(string);
                if (typeElement == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Cannot clean " + string);
                    continue;
                }
                new ElementScanner6<Void, Void>(){

                    @Override
                    public Void visitExecutable(ExecutableElement executableElement, Void void_) {
                        MethodTree methodTree = trees.getTree(executableElement);
                        if (methodTree != null && methodTree.getKind() == Tree.Kind.METHOD) {
                            JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)methodTree;
                            linkedList.add(jCMethodDecl.defaultValue);
                        }
                        return (Void)super.visitExecutable(executableElement, void_);
                    }
                }.scan(typeElement, null);
            }
            Method method = JavacProcessingEnvironment.class.getDeclaredMethod("cleanTrees", List.class);
            method.setAccessible(true);
            method.invoke(null, List.from(linkedList.toArray(new JCTree[0])));
        }
        catch (Throwable throwable) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Failed with a Throwable: " + throwable.getMessage());
        }
    }

    private boolean shouldWorkaroundBug() {
        Boolean bl = HAS_BUG.get();
        if (bl != null) {
            return bl;
        }
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker treeMaker = TreeMaker.instance(context);
        final JCTree.JCLiteral jCLiteral = treeMaker.Literal("");
        JCTree.JCMethodDecl jCMethodDecl = treeMaker.MethodDef(null, null, null, List.<JCTree.JCTypeParameter>nil(), List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, jCLiteral);
        final boolean[] blArray = new boolean[]{false};
        new TreeScanner(){

            @Override
            public void scan(JCTree jCTree) {
                blArray[0] = blArray[0] | jCTree == jCLiteral;
                super.scan(jCTree);
            }
        }.scan(jCMethodDecl);
        HAS_BUG.compareAndSet(null, !blArray[0]);
        return HAS_BUG.get();
    }
}

