/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io.sza;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.sf.freecol.common.io.sza.AnimationEvent;
import net.sf.freecol.common.io.sza.ImageAnimationEvent;

public final class SimpleZippedAnimation
implements Iterable<AnimationEvent> {
    private static final String ANIMATION_DESCRIPTOR_FILE = "animation.txt";
    private final List<AnimationEvent> events;
    private final int width;
    private final int height;

    public SimpleZippedAnimation(URL url) throws IOException {
        this(url.openStream());
    }

    public SimpleZippedAnimation(InputStream zipStream) throws IOException {
        this(new ZipInputStream(zipStream));
    }

    private SimpleZippedAnimation(List<AnimationEvent> events, int width, int height) {
        this.events = events;
        this.width = width;
        this.height = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleZippedAnimation(ZipInputStream zipStream) throws IOException {
        this.events = new ArrayList<AnimationEvent>();
        HashMap<String, BufferedImage> loadingImages = new HashMap<String, BufferedImage>();
        LinkedList<String> loadingDescriptor = new LinkedList<String>();
        try {
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (ANIMATION_DESCRIPTOR_FILE.equals(entry.getName())) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)zipStream, "UTF-8"));
                    while ((line = in.readLine()) != null) {
                        loadingDescriptor.add(line);
                    }
                } else {
                    loadingImages.put(entry.getName(), ImageIO.read(zipStream));
                }
                zipStream.closeEntry();
            }
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException entry) {}
        }
        if (loadingDescriptor.isEmpty()) {
            throw new IOException("animation.txt is missing from the SZA.");
        }
        int largestWidth = 0;
        int largestHeight = 0;
        for (String line : loadingDescriptor) {
            int index = line.indexOf(40);
            int index2 = line.indexOf("ms)");
            if (index < 0 || index2 <= index) {
                throw new IOException("animation.txt should use the format: FILNAME (TIMEms)");
            }
            String imageName = line.substring(0, index).trim();
            int durationInMs = Integer.parseInt(line.substring(index + 1, index2));
            BufferedImage image = (BufferedImage)loadingImages.get(imageName);
            if (image == null) {
                throw new IOException("Could not find referenced image: " + imageName);
            }
            this.events.add(new ImageAnimationEventImpl(image, durationInMs));
            if (image.getWidth() > largestWidth) {
                largestWidth = image.getWidth();
            }
            if (image.getHeight() <= largestHeight) continue;
            largestHeight = image.getHeight();
        }
        this.width = largestWidth;
        this.height = largestHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public Iterator<AnimationEvent> iterator() {
        return Collections.unmodifiableList(this.events).iterator();
    }

    public SimpleZippedAnimation createScaledVersion(float scale) {
        ArrayList<AnimationEvent> newEvents = new ArrayList<AnimationEvent>();
        for (AnimationEvent event : this.events) {
            if (event instanceof ImageAnimationEvent) {
                newEvents.add(((ImageAnimationEventImpl)event).createScaledVersion(scale));
                continue;
            }
            newEvents.add(event);
        }
        return new SimpleZippedAnimation(newEvents, (int)((float)this.width * scale), (int)((float)this.height * scale));
    }

    private static final class ImageAnimationEventImpl
    implements ImageAnimationEvent {
        private static final Component _c = new Component(){};
        private final Image image;
        private final int durationInMs;

        private ImageAnimationEventImpl(Image image, int durationInMs) {
            this.image = image;
            this.durationInMs = durationInMs;
        }

        @Override
        public Image getImage() {
            return this.image;
        }

        @Override
        public int getDurationInMs() {
            return this.durationInMs;
        }

        private ImageAnimationEvent createScaledVersion(float scale) {
            int width = (int)((float)this.image.getWidth(null) * scale);
            int height = (int)((float)this.image.getHeight(null) * scale);
            BufferedImage scaled = new BufferedImage(width, height, 2);
            Graphics2D g = scaled.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(this.image, 0, 0, width, height, null);
            g.dispose();
            return new ImageAnimationEventImpl(scaled, this.durationInMs);
        }
    }
}

