/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class IndianDemandMessage
extends DOMMessage {
    private final String unitId;
    private final String colonyId;
    private final String typeId;
    private final String amount;
    private String result;

    public IndianDemandMessage(Unit unit, Colony colony, GoodsType type, int amount) {
        super(IndianDemandMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.colonyId = colony.getId();
        this.typeId = type == null ? null : type.getId();
        this.amount = Integer.toString(amount);
        this.result = null;
    }

    public IndianDemandMessage(Game game, Element element) {
        super(IndianDemandMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.colonyId = element.getAttribute("colony");
        this.typeId = !element.hasAttribute("type") ? null : element.getAttribute("type");
        this.amount = element.getAttribute("amount");
        this.result = element.getAttribute("result");
    }

    public Unit getUnit(Game game) {
        return game.getFreeColGameObject(this.unitId, Unit.class);
    }

    public Colony getColony(Game game) {
        return game.getFreeColGameObject(this.colonyId, Colony.class);
    }

    public GoodsType getType(Game game) {
        return this.typeId == null ? null : game.getSpecification().getGoodsType(this.typeId);
    }

    public int getAmount() {
        try {
            return Integer.parseInt(this.amount);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public boolean getResult() {
        return Boolean.parseBoolean(this.result);
    }

    public void setResult(boolean result) {
        this.result = Boolean.toString(result);
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = player.getGame();
        try {
            if (this.result == null) {
                unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
                if (unit.getMovesLeft() <= 0) {
                    return DOMMessage.clientError("Unit has no moves left: " + this.unitId);
                }
            } else {
                unit = game.getFreeColGameObject(this.unitId, Unit.class);
                if (unit == null) {
                    return DOMMessage.clientError("Not a unit: " + this.unitId);
                }
            }
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            Settlement settlement = unit.getAdjacentSettlementSafely(this.colonyId);
            if (!(settlement instanceof Colony)) {
                return DOMMessage.clientError("Not a colony: " + this.colonyId);
            }
            colony = (Colony)settlement;
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (this.getAmount() <= 0) {
            return DOMMessage.clientError("Bad amount: " + this.amount);
        }
        return server.getInGameController().indianDemand(serverPlayer, unit, colony, this.getType(game), this.getAmount());
    }

    @Override
    public Element toXMLElement() {
        Element ret = IndianDemandMessage.createMessage(IndianDemandMessage.getXMLElementTagName(), "unit", this.unitId, "colony", this.colonyId, "amount", this.amount);
        if (this.typeId != null) {
            ret.setAttribute("type", this.typeId);
        }
        if (this.result != null) {
            ret.setAttribute("result", this.result);
        }
        return ret;
    }

    public static String getXMLElementTagName() {
        return "indianDemand";
    }
}

