/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.Util;
import dguitar.codecs.guitarPro.GPSlide;
import dguitar.gui.DisplayOptions;
import dguitar.gui.OptionsDisplay;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class SlideLabel
extends JLabel
implements OptionsDisplay {
    private DisplayOptions displayOptions;
    private int typeOfSlide;
    public static final int SLIDE_SHIFT = 1;
    public static final int SLIDE_LEGATO = 2;
    public static final int SLIDE_IN_FROM_BELOW = 3;
    public static final int SLIDE_IN_FROM_ABOVE = 4;
    public static final int SLIDE_OUT_UPWARDS = 5;
    public static final int SLIDE_OUT_DOWNWARDS = 6;
    public static String[] slidesNames = new String[]{"Shift slide", "Legato slide", "Slide in from below", "Slide in from above", "Slide out upwards", "Slide out downwards"};
    private Color color;
    private int width;
    private static final int MIN_WIDTH = 5;

    public SlideLabel() {
        this.typeOfSlide = 1;
        this.displayOptions = null;
        this.color = Color.PINK;
    }

    public SlideLabel(DisplayOptions currentDisplayOptions, int desiredWidth) {
        if (currentDisplayOptions == null || desiredWidth < 5) {
            String msg = currentDisplayOptions == null ? "displayOptions is null" : "desiredWidth is <= 5";
            throw new NullPointerException(msg);
        }
        this.typeOfSlide = 1;
        this.width = desiredWidth;
        this.setDisplayOptions(currentDisplayOptions);
        this.color = Color.BLUE;
    }

    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(this.width, this.displayOptions.LS);
        return dim;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Point getPoint(int x, int y) {
        return this.getPoint(new Point(x, y));
    }

    public Point getPoint(Point anchor) {
        int deltaY;
        int deltaX;
        int w = this.width - 1;
        int h = this.displayOptions.LS - 1;
        Point p = new Point();
        if (this.typeOfSlide == 4 || this.typeOfSlide == 3) {
            deltaX = -w - 5;
            deltaY = this.typeOfSlide == 3 ? 0 : -h;
        } else {
            deltaX = 5;
            deltaY = this.typeOfSlide == 6 ? 0 : -h;
        }
        p.x = anchor.x + deltaX;
        p.y = anchor.y + deltaY;
        return p;
    }

    public Point setAnchor(Point anchor) {
        Point resp = this.getPoint(anchor);
        this.setLocation(resp);
        return resp;
    }

    public Point setAnchor(int x, int y) {
        Point resp = this.getPoint(x, y);
        this.setLocation(resp);
        return resp;
    }

    public void setTypeOfSlide(int aTypeOfSlide) {
        if (aTypeOfSlide >= 1 && aTypeOfSlide <= 6) {
            this.typeOfSlide = aTypeOfSlide;
            if (this.typeOfSlide == 2) {
                this.setSize(this.width, 2 * this.displayOptions.LS);
            }
        } else {
            throw new IllegalArgumentException("invalid range for a aTypeOfSlide");
        }
    }

    public int getTypeOfSlide() {
        return this.typeOfSlide;
    }

    private void paintImpl(Graphics g) {
        Point p1 = new Point();
        Point p2 = new Point();
        int w = this.width - 1;
        int h = this.displayOptions.LS - 1;
        p1.x = 0;
        p2.x = w;
        if (this.typeOfSlide == 4 || this.typeOfSlide == 6) {
            p1.y = 0;
            p2.y = h;
        } else {
            p1.y = h;
            p2.y = this.typeOfSlide == 2 ? h / 2 : 0;
        }
        g.setColor(this.color);
        Util.drawLine(g, p1, p2);
        if (this.typeOfSlide == 2) {
            g.drawArc(0, 0, w, h / 2, 0, 180);
        }
    }

    protected void paintComponent(Graphics gg) {
        Graphics g = gg.create();
        super.paintComponent(g);
        this.paintImpl(g);
        g.dispose();
    }

    public static void main(String[] args) {
        SlideLabel slide;
        JFrame jFrame = new JFrame("Types of Slide Test");
        Container pane = jFrame.getContentPane();
        pane.setLayout(null);
        DisplayOptions aDO = new DisplayOptions();
        Point anchor = new Point();
        anchor.x = 50;
        anchor.y = 20;
        int i = 1;
        while (i <= 6) {
            slide = new SlideLabel(aDO, 20);
            slide.setTypeOfSlide(i);
            slide.setToolTipText(slidesNames[i - 1]);
            slide.setAnchor(anchor);
            pane.add(slide);
            anchor.y += 2 * aDO.LS + 5;
            ++i;
        }
        anchor.x += 5 * aDO.NS;
        anchor.y = 20;
        i = 1;
        while (i <= 7) {
            slide = new SlideLabel(aDO, 50);
            int aux = 1 + (int)(Math.random() * 6.0);
            slide.setTypeOfSlide(aux);
            slide.setToolTipText(slidesNames[aux - 1]);
            Point p = slide.getPoint(anchor);
            slide.setLocation(p);
            pane.add(slide);
            anchor.y += 2 * aDO.LS + 5;
            ++i;
        }
        jFrame.setBounds(10, 10, 300, 300);
        jFrame.setVisible(true);
    }

    public void setTypeOfSlide(GPSlide aGPSlide) {
        int GPStype = aGPSlide.getIndex();
        int type = -99;
        switch (GPStype) {
            case 0: {
                type = 4;
                break;
            }
            case 1: {
                type = 3;
                break;
            }
            case 2: {
                type = 1;
                break;
            }
            case 3: {
                type = 2;
                break;
            }
            case 4: {
                type = 6;
                break;
            }
            case 5: {
                type = 5;
            }
        }
        this.setTypeOfSlide(type);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setDisplayOptions(DisplayOptions displayOptions) {
        this.displayOptions = displayOptions;
        this.setSize(this.width, this.displayOptions.LS);
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }
}

