/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.base.plugins;

import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.testing.base.TestSuiteBinarySpec;
import org.gradle.testing.base.TestSuiteContainer;
import org.gradle.testing.base.TestSuiteSpec;
import org.gradle.testing.base.TestSuiteTaskCollection;
import org.gradle.testing.base.internal.BaseTestSuiteSpec;

@Incubating
public class TestingModelBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void registerTestSuiteSpec(TypeBuilder<TestSuiteSpec> builder) {
            builder.defaultImplementation(BaseTestSuiteSpec.class);
        }

        @Model
        void testSuites(TestSuiteContainer testSuites) {
        }

        @Mutate
        void copyTestBinariesToGlobalContainer(BinaryContainer binaries, TestSuiteContainer testSuites) {
            for (TestSuiteSpec testSuite : testSuites.values()) {
                for (BinarySpecInternal binary : testSuite.getBinaries().withType(BinarySpecInternal.class).values()) {
                    binaries.put(binary.getProjectScopedName(), (Object)binary);
                }
            }
        }

        @Mutate
        void attachBinariesToCheckLifecycle(@Path(value="tasks.check") Task checkTask, @Path(value="binaries") ModelMap<TestSuiteBinarySpec> binaries) {
            for (TestSuiteBinarySpec testBinary : binaries) {
                BinaryTasksCollection tasks;
                if (!testBinary.isBuildable() || !((tasks = testBinary.getTasks()) instanceof TestSuiteTaskCollection)) continue;
                checkTask.dependsOn(new Object[]{((TestSuiteTaskCollection)tasks).getRun()});
            }
        }
    }
}

