/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import java.util.concurrent.Callable;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.scala.ScalaDoc;

public class ScalaPlugin
implements Plugin<Project> {
    public static final String SCALA_DOC_TASK_NAME = "scaladoc";

    public void apply(Project project) {
        project.getPluginManager().apply(ScalaBasePlugin.class);
        project.getPluginManager().apply(JavaPlugin.class);
        ScalaPlugin.configureScaladoc(project);
    }

    private static void configureScaladoc(final Project project) {
        project.getTasks().withType(ScalaDoc.class, (Action)new Action<ScalaDoc>(){

            public void execute(ScalaDoc scalaDoc) {
                final SourceSet main = (SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main");
                scalaDoc.getConventionMapping().map("classpath", (Callable)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        ConfigurableFileCollection files = project.files(new Object[0]);
                        files.from(new Object[]{main.getOutput()});
                        files.from(new Object[]{main.getCompileClasspath()});
                        return files;
                    }
                });
                scalaDoc.setSource(InvokerHelper.invokeMethod((Object)main, (String)"getScala", null));
            }
        });
        ScalaDoc scalaDoc = (ScalaDoc)project.getTasks().create(SCALA_DOC_TASK_NAME, ScalaDoc.class);
        scalaDoc.setDescription("Generates Scaladoc for the main source code.");
        scalaDoc.setGroup("documentation");
    }
}

