/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.IconPathPatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.ScalableIcon;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.ImageLoader;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.RetinaImage;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakHashMap;
import org.jetbrains.kotlin.com.intellij.util.ui.ImageUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.JBImageIcon;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;
import org.jetbrains.kotlin.com.intellij.util.ui.UIUtil;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    public static boolean STRICT = false;
    private static boolean USE_DARK_ICONS = UIUtil.isUnderDarcula();
    private static float SCALE = JBUI.scale(1.0f);
    private static ImageFilter IMAGE_FILTER;
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache;
    private static final Map<Icon, Icon> ourIcon2DisabledIcon;
    @NonNls
    private static final List<IconPathPatcher> ourPatchers;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static void installPathPatcher(IconPathPatcher patcher) {
        ourPatchers.add(patcher);
        IconLoader.clearCache();
    }

    @Deprecated
    public static Icon getIcon(@NotNull Image image) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        return new JBImageIcon(image);
    }

    private static void clearCache() {
        ourIconsCache.clear();
        ourIcon2DisabledIcon.clear();
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        Icon icon = IconLoader.getIcon(path, callerClass);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        return icon;
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path, ClassLoader classLoader) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "getReflectiveIcon"));
        }
        try {
            String pckg = path.startsWith("AllIcons.") ? "org.jetbrains.kotlin.com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class aClass2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        Icon icon = IconLoader.findIcon(path, aClass2);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass2 + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "getIcon"));
        }
        return icon2;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass2) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        return IconLoader.findIcon(path, aClass2, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass2, boolean computeNow) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        return IconLoader.findIcon(path, aClass2, computeNow, STRICT);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass2, boolean computeNow, boolean strict) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "findIcon"));
        }
        String originalPath = path;
        if (IconLoader.isReflectivePath(path = IconLoader.patchPath(path))) {
            return IconLoader.getReflectiveIcon(path, aClass2.getClassLoader());
        }
        URL myURL = aClass2.getResource(path);
        if (myURL == null) {
            if (strict) {
                throw new RuntimeException("Can't find icon in '" + path + "' near " + aClass2);
            }
            return null;
        }
        Icon icon = IconLoader.findIcon(myURL);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = aClass2.getClassLoader();
        }
        return icon;
    }

    private static String patchPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "patchPath"));
        }
        for (IconPathPatcher patcher : ourPatchers) {
            String newPath = patcher.patchPath(path);
            if (newPath == null) continue;
            path = newPath;
        }
        return path;
    }

    private static boolean isReflectivePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "isReflectivePath"));
        }
        List<String> paths = StringUtil.split(path, ".");
        return paths.size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            if (useCache) {
                icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
            }
        }
        return icon;
    }

    @Nullable
    private static ImageIcon checkIcon(Image image, @NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "checkIcon"));
        }
        if (image == null || image.getHeight(LabelHolder.ourFakeComponent) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (icon != null && !IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        assert (icon instanceof ImageIcon);
        return (ImageIcon)icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader", "isGoodSize"));
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    static {
        ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
        ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
        ourPatchers = new ArrayList<IconPathPatcher>(2);
        IconLoader.installPathPatcher(new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
        ourIsActivated = false;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();
    }

    private static final class CachedImageIcon
    implements ScalableIcon {
        private volatile Object myRealIcon;
        private String myOriginalPath;
        private ClassLoader myClassLoader;
        @NotNull
        private URL myUrl;
        private volatile boolean dark;
        private volatile float scale;
        private volatile int numberOfPatchers;
        private volatile ImageFilter filter;
        private final MyScaledIconsCache myScaledIconsCache;

        public CachedImageIcon(@NotNull URL url) {
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon", "<init>"));
            }
            this.numberOfPatchers = ourPatchers.size();
            this.myScaledIconsCache = new MyScaledIconsCache();
            this.myUrl = url;
            this.dark = USE_DARK_ICONS;
            this.scale = SCALE;
            this.filter = IMAGE_FILTER;
        }

        @NotNull
        private synchronized ImageIcon getRealIcon() {
            ImageIcon icon;
            Object realIcon;
            if (IconLoader.isLoaderDisabled() && (this.myRealIcon == null || this.dark != USE_DARK_ICONS || this.scale != SCALE || this.filter != IMAGE_FILTER || this.numberOfPatchers != ourPatchers.size())) {
                ImageIcon imageIcon = EMPTY_ICON;
                if (imageIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
                }
                return imageIcon;
            }
            if (!this.isValid()) {
                this.myRealIcon = null;
                this.dark = USE_DARK_ICONS;
                this.scale = SCALE;
                this.filter = IMAGE_FILTER;
                this.myScaledIconsCache.clear();
                if (this.numberOfPatchers != ourPatchers.size()) {
                    URL url;
                    String path;
                    this.numberOfPatchers = ourPatchers.size();
                    String string = path = this.myOriginalPath == null ? null : IconLoader.patchPath(this.myOriginalPath);
                    if (this.myClassLoader != null && path != null && path.startsWith("/") && (url = this.myClassLoader.getResource(path = path.substring(1))) != null) {
                        this.myUrl = url;
                    }
                }
            }
            if ((realIcon = this.myRealIcon) instanceof Icon) {
                ImageIcon imageIcon = (ImageIcon)realIcon;
                if (imageIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
                }
                return imageIcon;
            }
            if (realIcon instanceof Reference && (icon = (ImageIcon)((Reference)realIcon).get()) != null) {
                ImageIcon imageIcon = icon;
                if (imageIcon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
                }
                return imageIcon;
            }
            Image image = ImageLoader.loadFromUrl(this.myUrl, true, this.filter);
            icon = IconLoader.checkIcon(image, this.myUrl);
            if (icon != null) {
                realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<ImageIcon>(icon);
                this.myRealIcon = realIcon;
            }
            ImageIcon imageIcon = icon == null ? EMPTY_ICON : icon;
            if (imageIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon", "getRealIcon"));
            }
            return imageIcon;
        }

        private boolean isValid() {
            return this.dark == USE_DARK_ICONS && this.scale == SCALE && this.filter == IMAGE_FILTER && this.numberOfPatchers == ourPatchers.size();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }

        @Override
        public Icon scale(float scaleFactor) {
            Icon icon;
            if (scaleFactor == 1.0f) {
                return this;
            }
            if (!this.isValid()) {
                this.getRealIcon();
            }
            if ((icon = this.myScaledIconsCache.getScaledIcon(scaleFactor)) != null) {
                return icon;
            }
            return this;
        }

        private class MyScaledIconsCache {
            private Map<Boolean, SoftReference<Image>> origImagesCache = Collections.synchronizedMap(new HashMap(2));
            private Map<Float, SoftReference<Icon>> scaledIconsCache = Collections.synchronizedMap(new LinkedHashMap<Float, SoftReference<Icon>>(5){

                @Override
                public boolean removeEldestEntry(Map.Entry<Float, SoftReference<Icon>> entry) {
                    return this.size() > 5;
                }
            });

            private MyScaledIconsCache() {
            }

            public Image getOrigImage(boolean retina) {
                Image img = (Image)SoftReference.dereference(this.origImagesCache.get(retina));
                if (img == null) {
                    img = ImageLoader.loadFromUrl(CachedImageIcon.this.myUrl, UIUtil.isUnderDarcula(), retina, CachedImageIcon.this.filter);
                    this.origImagesCache.put(retina, new SoftReference<Image>(img));
                }
                return img;
            }

            public Icon getScaledIcon(float scale) {
                boolean needRetinaImage;
                Image image;
                float effectiveScale = scale * JBUI.scale(1.0f);
                Icon icon = (Icon)SoftReference.dereference(this.scaledIconsCache.get(Float.valueOf(effectiveScale)));
                if (icon == null && (image = this.getOrigImage(needRetinaImage = effectiveScale >= 1.5f || UIUtil.isRetina())) != null) {
                    Image iconImage = CachedImageIcon.this.getRealIcon().getImage();
                    int width = (int)((float)ImageUtil.getRealWidth(iconImage) * scale);
                    int height = (int)((float)ImageUtil.getRealHeight(iconImage) * scale);
                    Image resizedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
                    if (UIUtil.isRetina()) {
                        resizedImage = RetinaImage.createFrom(resizedImage);
                    }
                    icon = IconLoader.getIcon(resizedImage);
                    this.scaledIconsCache.put(Float.valueOf(effectiveScale), new SoftReference<Icon>(icon));
                }
                return icon;
            }

            public void clear() {
                this.scaledIconsCache.clear();
                this.origImagesCache.clear();
            }
        }
    }
}

