/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ReceiverParameterDescriptorImpl;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.coroutine.CoroutineReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class FunctionDescriptorUtil {
    private static final TypeSubstitutor MAKE_TYPE_PARAMETERS_FRESH = TypeSubstitutor.create(new TypeSubstitution(){

        @Override
        public TypeProjection get(@NotNull KotlinType key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil$1", "get"));
            }
            return null;
        }

        public String toString() {
            return "FunctionDescriptorUtil.MAKE_TYPE_PARAMETERS_FRESH";
        }
    });

    private FunctionDescriptorUtil() {
    }

    public static TypeSubstitution createSubstitution(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<KotlinType> typeArguments2) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "createSubstitution"));
        }
        if (typeArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "createSubstitution"));
        }
        if (functionDescriptor.getTypeParameters().isEmpty()) {
            return TypeSubstitution.EMPTY;
        }
        return new IndexedParametersSubstitution(functionDescriptor.getTypeParameters(), TypeUtilsKt.defaultProjections(typeArguments2));
    }

    @NotNull
    public static LexicalScope getFunctionInnerScope(@NotNull LexicalScope outerScope, @NotNull FunctionDescriptor descriptor2, @NotNull BindingTrace trace, @NotNull OverloadChecker overloadChecker) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (overloadChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadChecker", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, descriptor2, new TraceBasedLocalRedeclarationChecker(trace, overloadChecker));
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        return lexicalScope;
    }

    @NotNull
    public static LexicalScope getFunctionInnerScope(@NotNull LexicalScope outerScope, final @NotNull FunctionDescriptor descriptor2, @NotNull LocalRedeclarationChecker redeclarationChecker) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (redeclarationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarationChecker", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        ReceiverParameterDescriptor receiver = descriptor2.getExtensionReceiverParameter();
        if (descriptor2 instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)descriptor2).isCoroutine() && receiver != null && receiver.getValue() instanceof ExtensionReceiver) {
            receiver = new ReceiverParameterDescriptorImpl(descriptor2, new CoroutineReceiverValue(((ExtensionReceiver)receiver.getValue()).getDeclarationDescriptor(), receiver.getValue().getType()));
        }
        LexicalScopeImpl lexicalScopeImpl = new LexicalScopeImpl(outerScope, descriptor2, true, receiver, LexicalScopeKind.FUNCTION_INNER_SCOPE, redeclarationChecker, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

            @Override
            public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
                    handler2.addClassifierDescriptor(typeParameter);
                }
                for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
                    handler2.addVariableDescriptor(valueParameterDescriptor);
                }
                return Unit.INSTANCE;
            }
        });
        if (lexicalScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        return lexicalScopeImpl;
    }

    public static <D extends CallableDescriptor> D alphaConvertTypeParameters(D candidate) {
        return (D)candidate.substitute(MAKE_TYPE_PARAMETERS_FRESH);
    }
}

