/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jruby.truffle.core.cast.ToEncodingNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ToEncodingNode.class)
public final class ToEncodingNodeGen
extends ToEncodingNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @Node.Child
    private BaseNode_ specialization_;

    private ToEncodingNodeGen(RubyNode value) {
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Encoding executeToEncoding(Object valueValue) {
        return this.specialization_.executeEncoding(valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ToEncodingNode create(RubyNode value) {
        return new ToEncodingNodeGen(value);
    }

    @GeneratedBy(methodName="failure(Object)", value=ToEncodingNode.class)
    private static final class FallbackNode_
    extends BaseNode_ {
        FallbackNode_(ToEncodingNodeGen root) {
            super(root, 0x7FFFFFFE);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean guardFallback(Object valueValue) {
            return this.createNext((Frame)null, valueValue) == null;
        }

        @Override
        public Encoding executeEncoding(Object valueValue) {
            if (this.guardFallback(valueValue)) {
                return this.root.failure(valueValue);
            }
            return this.getNext().executeEncoding(valueValue);
        }

        static BaseNode_ create(ToEncodingNodeGen root) {
            return new FallbackNode_(root);
        }
    }

    @GeneratedBy(methodName="rubyEncodingToEncoding(DynamicObject)", value=ToEncodingNode.class)
    private static final class RubyEncodingToEncodingNode_
    extends BaseNode_ {
        RubyEncodingToEncodingNode_(ToEncodingNodeGen root) {
            super(root, 4);
        }

        @Override
        public Encoding executeEncoding(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyEncoding(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.rubyEncodingToEncoding(valueValue_);
            }
            return this.getNext().executeEncoding(valueValue);
        }

        static BaseNode_ create(ToEncodingNodeGen root) {
            return new RubyEncodingToEncodingNode_(root);
        }
    }

    @GeneratedBy(methodName="regexpToEncoding(DynamicObject)", value=ToEncodingNode.class)
    private static final class RegexpToEncodingNode_
    extends BaseNode_ {
        RegexpToEncodingNode_(ToEncodingNodeGen root) {
            super(root, 3);
        }

        @Override
        public Encoding executeEncoding(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyRegexp(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.regexpToEncoding(valueValue_);
            }
            return this.getNext().executeEncoding(valueValue);
        }

        static BaseNode_ create(ToEncodingNodeGen root) {
            return new RegexpToEncodingNode_(root);
        }
    }

    @GeneratedBy(methodName="symbolToEncoding(DynamicObject)", value=ToEncodingNode.class)
    private static final class SymbolToEncodingNode_
    extends BaseNode_ {
        SymbolToEncodingNode_(ToEncodingNodeGen root) {
            super(root, 2);
        }

        @Override
        public Encoding executeEncoding(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubySymbol(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.symbolToEncoding(valueValue_);
            }
            return this.getNext().executeEncoding(valueValue);
        }

        static BaseNode_ create(ToEncodingNodeGen root) {
            return new SymbolToEncodingNode_(root);
        }
    }

    @GeneratedBy(methodName="stringToEncoding(DynamicObject)", value=ToEncodingNode.class)
    private static final class StringToEncodingNode_
    extends BaseNode_ {
        StringToEncodingNode_(ToEncodingNodeGen root) {
            super(root, 1);
        }

        @Override
        public Encoding executeEncoding(Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyString(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.stringToEncoding(valueValue_);
            }
            return this.getNext().executeEncoding(valueValue);
        }

        static BaseNode_ create(ToEncodingNodeGen root) {
            return new StringToEncodingNode_(root);
        }
    }

    @GeneratedBy(value=ToEncodingNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ToEncodingNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public Encoding executeEncoding(Object valueValue) {
            return this.getNext().executeEncoding(valueValue);
        }

        static BaseNode_ create(ToEncodingNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ToEncodingNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ToEncodingNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Encoding executeEncoding(Object valueValue) {
            return (Encoding)this.uninitialized((Frame)null, valueValue);
        }

        static BaseNode_ create(ToEncodingNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ToEncodingNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ToEncodingNodeGen root;

        BaseNode_(ToEncodingNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ToEncodingNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeEncoding(valueValue);
        }

        public abstract Encoding executeEncoding(Object var1);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.executeEncoding(valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            if (valueValue instanceof DynamicObject) {
                DynamicObject valueValue_ = (DynamicObject)valueValue;
                if (RubyGuards.isRubyString(valueValue_)) {
                    return StringToEncodingNode_.create(this.root);
                }
                if (RubyGuards.isRubySymbol(valueValue_)) {
                    return SymbolToEncodingNode_.create(this.root);
                }
                if (RubyGuards.isRubyRegexp(valueValue_)) {
                    return RegexpToEncodingNode_.create(this.root);
                }
                if (RubyGuards.isRubyEncoding(valueValue_)) {
                    return RubyEncodingToEncodingNode_.create(this.root);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createFallback() {
            return FallbackNode_.create(this.root);
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

