/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsDoWhile;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsForIn;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsWhile;
import com.google.dart.compiler.backend.js.ast.RecursiveJsVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.inline.clean.WhileConditionFolding;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\bJ\u001a\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/WhileConditionFolding;", "", "body", "Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "(Lcom/google/dart/compiler/backend/js/ast/JsBlock;)V", "getBody", "()Lcom/google/dart/compiler/backend/js/ast/JsBlock;", "changed", "", "apply", "hasContinue", "statement", "Lcom/google/dart/compiler/backend/js/ast/JsStatement;", "label", "Lcom/google/dart/compiler/backend/js/ast/JsName;", "kotlin-compiler"})
public final class WhileConditionFolding {
    private boolean changed;
    @NotNull
    private final JsBlock body;

    public final boolean apply() {
        this.body.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ WhileConditionFolding this$0;

            public void visitLabel(@NotNull JsLabel x) {
                JsStatement innerStatement;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsStatement jsStatement = innerStatement = x.getStatement();
                if (jsStatement instanceof JsWhile) {
                    this.process((JsWhile)innerStatement, x.getName());
                } else if (jsStatement instanceof JsDoWhile) {
                    this.process((JsDoWhile)innerStatement, x.getName());
                } else {
                    super.visitLabel(x);
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.process(x, (JsName)null);
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                this.process(x, (JsName)null);
            }

            private final void process(JsWhile statement, JsName name) {
                this.process(statement, name, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsStatement>(this){
                    final /* synthetic */ apply.1 this$0;

                    @NotNull
                    public final JsStatement invoke(@NotNull JsStatement it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return apply.1.access$first(this.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsBlock>(this){
                    final /* synthetic */ apply.1 this$0;

                    @NotNull
                    public final JsBlock invoke(@NotNull JsStatement it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return apply.1.access$removeFirst(this.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, apply.process.3.INSTANCE);
            }

            private final void process(JsDoWhile statement, JsName name) {
                JsStatement jsStatement = statement.getBody();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement, "statement.body");
                if (!WhileConditionFolding.access$hasContinue(this.this$0, jsStatement, name)) {
                    this.process(statement, name, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsStatement>(this){
                        final /* synthetic */ apply.1 this$0;

                        @NotNull
                        public final JsStatement invoke(@NotNull JsStatement it) {
                            Intrinsics.checkParameterIsNotNull(it, "it");
                            return apply.1.access$last(this.this$0, it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, (Function1<? super JsStatement, ? extends JsStatement>)new Function1<JsStatement, JsBlock>(this){
                        final /* synthetic */ apply.1 this$0;

                        @NotNull
                        public final JsBlock invoke(@NotNull JsStatement it) {
                            Intrinsics.checkParameterIsNotNull(it, "it");
                            return apply.1.access$removeLast(this.this$0, it);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, apply.process.6.INSTANCE);
                }
            }

            private final void process(JsWhile statement, JsName name, Function1<? super JsStatement, ? extends JsStatement> find, Function1<? super JsStatement, ? extends JsStatement> remove, Function2<? super JsExpression, ? super JsExpression, ? extends JsExpression> combine) {
                boolean optimized;
                statement.getBody().accept(this);
                do {
                    JsExpression jsExpression;
                    JsExpression existingCondition;
                    optimized = false;
                    JsStatement jsStatement = statement.getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement, "statement.body");
                    JsStatement first = find.invoke(jsStatement);
                    JsExpression condition = this.extractCondition(first, name);
                    if (condition == null) continue;
                    JsStatement jsStatement2 = statement.getBody();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement2, "statement.body");
                    statement.setBody(remove.invoke(jsStatement2));
                    JsExpression jsExpression2 = existingCondition = statement.getCondition();
                    if (Intrinsics.areEqual(jsExpression2, JsLiteral.TRUE)) {
                        jsExpression = condition;
                    } else {
                        JsExpression jsExpression3 = existingCondition;
                        Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "existingCondition");
                        jsExpression = combine.invoke(jsExpression3, condition);
                    }
                    statement.setCondition(jsExpression);
                    WhileConditionFolding.access$setChanged$p(this.this$0, true);
                    optimized = true;
                } while (optimized);
            }

            private final JsExpression extractCondition(JsStatement statement, JsName label) {
                JsExpression jsExpression;
                JsStatement jsStatement = statement;
                if (jsStatement instanceof JsBreak) {
                    JsNameRef jsNameRef = ((JsBreak)statement).getLabel();
                    JsName target = jsNameRef != null ? jsNameRef.getName() : null;
                    jsExpression = label == null || Intrinsics.areEqual(label, target) ? JsLiteral.FALSE : (JsLiteral.JsBooleanLiteral)null;
                } else if (jsStatement instanceof JsIf) {
                    JsExpression nextCondition;
                    JsExpression jsExpression2;
                    JsExpression result2;
                    JsStatement jsStatement2 = ((JsIf)statement).getThenStatement();
                    if (jsStatement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    JsStatement then2 = jsStatement2;
                    jsExpression = ((JsIf)statement).getElseStatement() == null ? (result2 = Intrinsics.areEqual(jsExpression2 = (nextCondition = this.extractCondition(then2, label)), JsLiteral.FALSE) ? JsAstUtils.negatedOptimized(((JsIf)statement).getIfExpression()) : (Intrinsics.areEqual(jsExpression2, null) ? (JsExpression)null : (JsExpression)JsAstUtils.or(JsAstUtils.negatedOptimized(((JsIf)statement).getIfExpression()), nextCondition))) : (JsExpression)null;
                } else if (jsStatement instanceof JsBlock) {
                    if (((JsBlock)statement).getStatements().size() == 1) {
                        JsStatement jsStatement3 = ((JsBlock)statement).getStatements().get(0);
                        Intrinsics.checkExpressionValueIsNotNull(jsStatement3, "statement.statements[0]");
                        jsExpression = this.extractCondition(jsStatement3, label);
                    } else {
                        jsExpression = null;
                    }
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }

            private final JsStatement first(JsStatement statement) {
                JsStatement jsStatement;
                JsStatement jsStatement2 = statement;
                if (jsStatement2 instanceof JsBlock) {
                    jsStatement = CollectionsKt.firstOrNull(((JsBlock)statement).getStatements());
                    if (jsStatement == null) {
                        jsStatement = statement;
                    }
                } else {
                    jsStatement = statement;
                }
                return jsStatement;
            }

            private final JsBlock removeFirst(JsStatement statement) {
                JsBlock jsBlock;
                JsStatement jsStatement = statement;
                if (jsStatement instanceof JsBlock) {
                    List<JsStatement> statements = ((JsBlock)statement).getStatements();
                    Collection collection = statements;
                    if (!collection.isEmpty()) {
                        statements.remove(0);
                    }
                    jsBlock = (JsBlock)statement;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            private final JsStatement last(JsStatement statement) {
                JsStatement jsStatement;
                JsStatement jsStatement2 = statement;
                if (jsStatement2 instanceof JsBlock) {
                    jsStatement = CollectionsKt.lastOrNull(((JsBlock)statement).getStatements());
                    if (jsStatement == null) {
                        jsStatement = statement;
                    }
                } else {
                    jsStatement = statement;
                }
                return jsStatement;
            }

            private final JsBlock removeLast(JsStatement statement) {
                JsBlock jsBlock;
                JsStatement jsStatement = statement;
                if (jsStatement instanceof JsBlock) {
                    List<JsStatement> statements = ((JsBlock)statement).getStatements();
                    Collection collection = statements;
                    if (!collection.isEmpty()) {
                        statements.remove(CollectionsKt.getLastIndex(statements));
                    }
                    jsBlock = (JsBlock)statement;
                } else {
                    jsBlock = new JsBlock();
                }
                return jsBlock;
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }
            {
                this.this$0 = $outer;
            }

            @NotNull
            public static final /* synthetic */ JsStatement access$first(apply.1 $this, @NotNull JsStatement statement) {
                return $this.first(statement);
            }

            @NotNull
            public static final /* synthetic */ JsBlock access$removeFirst(apply.1 $this, @NotNull JsStatement statement) {
                return $this.removeFirst(statement);
            }

            @NotNull
            public static final /* synthetic */ JsStatement access$last(apply.1 $this, @NotNull JsStatement statement) {
                return $this.last(statement);
            }

            @NotNull
            public static final /* synthetic */ JsBlock access$removeLast(apply.1 $this, @NotNull JsStatement statement) {
                return $this.removeLast(statement);
            }
        });
        return this.changed;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasContinue(JsStatement statement, JsName label) {
        void found;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        statement.accept(new RecursiveJsVisitor((Ref.BooleanRef)found, label){
            private int level;
            final /* synthetic */ Ref.BooleanRef $found;
            final /* synthetic */ JsName $label;

            public void visitContinue(@NotNull JsContinue x) {
                JsName name;
                Intrinsics.checkParameterIsNotNull(x, "x");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = name = jsNameRef != null ? jsNameRef.getName() : null;
                if (name == null) {
                    if (this.level == 0) {
                        this.$found.element = true;
                    }
                } else if (Intrinsics.areEqual(name, this.$label)) {
                    this.$found.element = true;
                }
            }

            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitFor(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitDoWhile(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitForIn(@NotNull JsForIn x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                int n = this.level;
                this.level = n + 1;
                super.visitForIn(x);
                n = this.level;
                this.level = n + -1;
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull(x, "x");
            }

            protected void visitElement(@NotNull JsNode node) {
                Intrinsics.checkParameterIsNotNull(node, "node");
                if (!this.$found.element) {
                    super.visitElement(node);
                }
            }
            {
                this.$found = $captured_local_variable$0;
                this.$label = $captured_local_variable$1;
            }
        });
        return found.element;
    }

    @NotNull
    public final JsBlock getBody() {
        return this.body;
    }

    public WhileConditionFolding(@NotNull JsBlock body) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        this.body = body;
    }

    public static final /* synthetic */ boolean access$hasContinue(WhileConditionFolding $this, @NotNull JsStatement statement, @Nullable JsName label) {
        return $this.hasContinue(statement, label);
    }

    public static final /* synthetic */ boolean access$getChanged$p(WhileConditionFolding $this) {
        return $this.changed;
    }

    public static final /* synthetic */ void access$setChanged$p(WhileConditionFolding $this, boolean bl) {
        $this.changed = bl;
    }
}

