/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.quant.QuantError;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class AnalystEvaluateRawCSV
extends BasicFile {
    private EncogAnalyst analyst;
    private int inputCount;
    private int outputCount;
    private int idealCount;

    public void analyze(EncogAnalyst theAnalyst, File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.analyst = theAnalyst;
        this.setAnalyzed(true);
        this.performBasicCounts();
        this.inputCount = this.analyst.determineInputCount();
        this.outputCount = this.analyst.determineOutputCount();
        this.idealCount = this.getInputHeadings().length - this.inputCount;
        if (this.getInputHeadings().length != this.inputCount && this.getInputHeadings().length != this.inputCount + this.outputCount) {
            throw new AnalystError("Invalid number of columns(" + this.getInputHeadings().length + "), must match input(" + this.inputCount + ") count or input+output(" + (this.inputCount + this.outputCount) + ") count.");
        }
    }

    private PrintWriter analystPrepareOutputFile(File outputFile) {
        try {
            PrintWriter tw = new PrintWriter(new FileWriter(outputFile));
            if (this.isProduceOutputHeaders()) {
                StringBuilder line = new StringBuilder();
                for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
                    if (!field.isInput()) continue;
                    field.addRawHeadings(line, null, this.getFormat());
                }
                if (this.idealCount > 0) {
                    for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
                        if (!field.isOutput()) continue;
                        field.addRawHeadings(line, "ideal:", this.getFormat());
                    }
                }
                for (AnalystField field : this.analyst.getScript().getNormalize().getNormalizedFields()) {
                    if (!field.isOutput()) continue;
                    field.addRawHeadings(line, "output:", this.getFormat());
                }
                tw.println(line.toString());
            }
            return tw;
        }
        catch (IOException e) {
            throw new QuantError(e);
        }
    }

    public void process(File outputFile, MLRegression method) {
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
        if (method.getInputCount() != this.inputCount) {
            throw new AnalystError("This machine learning method has " + method.getInputCount() + " inputs, however, the data has " + this.inputCount + " inputs.");
        }
        MLData output = null;
        BasicMLData input = new BasicMLData(method.getInputCount());
        PrintWriter tw = this.analystPrepareOutputFile(outputFile);
        this.resetStatus();
        while (csv.next()) {
            int i;
            this.updateStatus(false);
            LoadedRow row = new LoadedRow(csv, this.idealCount);
            int dataIndex = 0;
            for (i = 0; i < this.inputCount; ++i) {
                String str = row.getData()[i];
                double d = this.getFormat().parse(str);
                input.setData(i, d);
                ++dataIndex;
            }
            dataIndex += this.idealCount;
            output = method.compute(input);
            for (i = 0; i < this.outputCount; ++i) {
                double d = output.getData(i);
                row.getData()[dataIndex++] = this.getFormat().format(d, this.getPrecision());
            }
            this.writeRow(tw, row);
        }
        this.reportDone(false);
        tw.close();
        csv.close();
    }
}

