/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.cross;

import org.encog.neural.flat.FlatNetwork;
import org.encog.util.EngineArray;

public class NetworkFold {
    private final double[] weights;
    private final double[] output;

    public NetworkFold(FlatNetwork flat) {
        this.weights = EngineArray.arrayCopy(flat.getWeights());
        this.output = EngineArray.arrayCopy(flat.getLayerOutput());
    }

    public final void copyToNetwork(FlatNetwork target) {
        EngineArray.arrayCopy(this.weights, target.getWeights());
        EngineArray.arrayCopy(this.output, target.getLayerOutput());
    }

    public final void copyFromNetwork(FlatNetwork source) {
        EngineArray.arrayCopy(source.getWeights(), this.weights);
        EngineArray.arrayCopy(source.getLayerOutput(), this.output);
    }

    public final double[] getWeights() {
        return this.weights;
    }

    public final double[] getOutput() {
        return this.output;
    }
}

