/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;

public class JordanPattern
implements NeuralNetworkPattern {
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;
    private ActivationFunction activation;

    @Override
    public void addHiddenLayer(int count) {
        if (this.hiddenNeurons != -1) {
            throw new PatternError("A Jordan neural network should have only one hidden layer.");
        }
        this.hiddenNeurons = count;
    }

    @Override
    public void clear() {
        this.hiddenNeurons = -1;
    }

    @Override
    public MLMethod generate() {
        BasicNetwork network = new BasicNetwork();
        network.addLayer(new BasicLayer(null, true, this.inputNeurons));
        BasicLayer hidden = new BasicLayer(this.activation, true, this.hiddenNeurons);
        network.addLayer(hidden);
        BasicLayer output = new BasicLayer(this.activation, false, this.outputNeurons);
        network.addLayer(output);
        hidden.setContextFedBy(output);
        network.getStructure().finalizeStructure();
        network.reset();
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        this.activation = activation;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

