/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.encog.bot.BotError;

public class FormUtility {
    public static final String ENCODE = "UTF-8";
    public static final int BUFFER_SIZE = 8192;
    public static final int RANDOM_LENGTH = 36;
    private static Random random = new Random();
    private final String boundary;
    private final OutputStream os;
    private boolean first;

    private static String encode(String str) {
        try {
            return URLEncoder.encode(str, ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String getBoundary() {
        return "---------------------------" + FormUtility.randomString() + FormUtility.randomString() + FormUtility.randomString();
    }

    public static Map<String, String> parse(String form) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tok = new StringTokenizer(form, "&");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            StringTokenizer tok2 = new StringTokenizer(str, "=");
            if (!tok2.hasMoreTokens()) continue;
            String left = tok2.nextToken();
            if (!tok2.hasMoreTokens()) {
                left = FormUtility.encode(left);
                result.put(left, null);
                continue;
            }
            String right = tok2.nextToken();
            right = FormUtility.encode(right);
            result.put(left, right);
        }
        return result;
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    public FormUtility(OutputStream os, String boundary) {
        this.os = os;
        this.boundary = boundary;
        this.first = true;
    }

    public void add(String name, File file) {
        try {
            if (this.boundary != null) {
                int nread;
                this.boundary();
                this.writeName(name);
                this.write("; filename=\"");
                this.write(file.getName());
                this.write("\"");
                this.newline();
                this.write("Content-Type: ");
                String type = URLConnection.guessContentTypeFromName(file.getName());
                if (type == null) {
                    type = "application/octet-stream";
                }
                this.writeln(type);
                this.newline();
                byte[] buf = new byte[8192];
                FileInputStream in = new FileInputStream(file);
                while ((nread = ((InputStream)in).read(buf, 0, buf.length)) >= 0) {
                    this.os.write(buf, 0, nread);
                }
                this.newline();
            }
        }
        catch (IOException e) {
            throw new BotError(e);
        }
    }

    public void add(String name, String value) {
        if (this.boundary != null) {
            this.boundary();
            this.writeName(name);
            this.newline();
            this.newline();
            this.writeln(value);
        } else {
            if (!this.first) {
                this.write("&");
            }
            this.write(FormUtility.encode(name));
            this.write("=");
            this.write(FormUtility.encode(value));
        }
        this.first = false;
    }

    private void boundary() {
        this.write("--");
        this.write(this.boundary);
    }

    public void complete() {
        try {
            if (this.boundary != null) {
                this.boundary();
                this.writeln("--");
                this.os.flush();
            }
        }
        catch (IOException e) {
            throw new BotError(e);
        }
    }

    private void newline() {
        this.write("\r\n");
    }

    private void write(String str) {
        try {
            this.os.write(str.getBytes());
        }
        catch (IOException e) {
            throw new BotError(e);
        }
    }

    protected void writeln(String str) {
        this.write(str);
        this.newline();
    }

    private void writeName(String name) {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(name);
        this.write("\"");
    }
}

