/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.RethrottleRequest;
import org.elasticsearch.index.reindex.TransportRethrottleAction;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.elasticsearch.tasks.TaskId;

public class RestRethrottleAction
extends BaseRestHandler {
    private final TransportRethrottleAction action;

    @Inject
    public RestRethrottleAction(Settings settings, RestController controller, Client client, TransportRethrottleAction action) {
        super(settings, controller, client);
        this.action = action;
        controller.registerHandler(RestRequest.Method.POST, "/_update_by_query/{taskId}/_rethrottle", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_reindex/{taskId}/_rethrottle", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        RethrottleRequest internalRequest = new RethrottleRequest();
        internalRequest.setTaskId(new TaskId(request.param("taskId")));
        Float requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(request);
        if (requestsPerSecond == null) {
            throw new IllegalArgumentException("requests_per_second is a required parameter");
        }
        internalRequest.setRequestsPerSecond(requestsPerSecond.floatValue());
        this.action.execute((ActionRequest)internalRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

