/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.ProfileBreakdown;
import org.elasticsearch.search.profile.ProfileWeight;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private ProfileWeight profileWeight;
    private final ProfileBreakdown profile;

    ProfileScorer(ProfileWeight w, Scorer scorer, ProfileBreakdown profile) throws IOException {
        super((Weight)w);
        this.scorer = scorer;
        this.profileWeight = w;
        this.profile = profile;
    }

    public int docID() {
        return this.scorer.docID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float score() throws IOException {
        this.profile.startTime(ProfileBreakdown.TimingType.SCORE);
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.profile.stopAndRecordTime();
        }
    }

    public int freq() throws IOException {
        return this.scorer.freq();
    }

    public Weight getWeight() {
        return this.profileWeight;
    }

    public Collection<Scorer.ChildScorer> getChildren() {
        return this.scorer.getChildren();
    }

    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.scorer.iterator();
        return new DocIdSetIterator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int advance(int target) throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.ADVANCE);
                try {
                    int n = in.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextDoc() throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.NEXT_DOC);
                try {
                    int n = in.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public int docID() {
                return in.docID();
            }

            public long cost() {
                return in.cost();
            }
        };
    }

    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int advance(int target) throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.ADVANCE);
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int nextDoc() throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.NEXT_DOC);
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public int docID() {
                return inApproximation.docID();
            }

            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean matches() throws IOException {
                ProfileScorer.this.profile.startTime(ProfileBreakdown.TimingType.MATCH);
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.profile.stopAndRecordTime();
                }
            }

            public float matchCost() {
                return in.matchCost();
            }
        };
    }
}

