/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.Convert;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConverterFactory;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentMerger;
import org.openoffice.xmerge.test.ConverterInfoList;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.openoffice.xmerge.util.registry.ConverterInfoMgr;
import org.openoffice.xmerge.util.registry.ConverterInfoReader;

public final class Driver {
    private String fromMime = null;
    private String toMime = null;
    private String mergeFile = null;
    private final ArrayList<String> deviceFiles = new ArrayList();
    private final String[] mimeTypes = new String[]{"sxc", "staroffice/sxc", "sxw", "staroffice/sxw"};

    public static void main(String[] args) {
        try {
            String propFile = "ConverterInfoList.properties";
            ConverterInfoList cil = new ConverterInfoList(propFile);
            Iterator<String> jarFileEnum = cil.getJarFileEnum();
            while (jarFileEnum.hasNext()) {
                String jarName = jarFileEnum.next();
                try {
                    ConverterInfoReader cir = new ConverterInfoReader(jarName, false);
                    Iterator<ConverterInfo> jarInfoEnumeration = cir.getConverterInfoEnumeration();
                    ConverterInfoMgr.addPlugIn(jarInfoEnumeration);
                }
                catch (Exception e) {
                    System.out.println("\nCannot not load <" + jarName + "> from the <" + propFile + "> property file");
                }
            }
            Driver app = new Driver();
            app.parseCommandLine(args);
            app.doConversion();
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            if (msg != null) {
                System.out.println("\n" + msg);
            }
            Driver.showUsage();
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg != null) {
                System.out.println("\n" + msg);
            }
            ex.printStackTrace();
        }
    }

    private void doConversion() throws IllegalArgumentException {
        block14: {
            ConverterFactory cf = new ConverterFactory();
            Convert myConvert = cf.getConverter(this.fromMime, this.toMime);
            String processFile2 = null;
            if (myConvert == null) {
                System.out.println("\nNo plug-in exists to convert from <" + this.fromMime + "> to <" + this.toMime + ">");
                throw new IllegalArgumentException();
            }
            try {
                for (String processFile2 : this.deviceFiles) {
                    File f = new File(processFile2);
                    if (!f.exists()) {
                        System.out.println(processFile2 + " does not exist!");
                        System.exit(0);
                    }
                    FileInputStream fis = new FileInputStream(f);
                    myConvert.addInputStream(f.getName(), fis);
                }
            }
            catch (Exception addExcept) {
                throw new IllegalArgumentException("\nFile <" + processFile2 + "> is not in <" + this.fromMime + "> format", addExcept);
            }
            ConvertData dataOut = null;
            try {
                dataOut = myConvert.convert();
            }
            catch (Exception convertExcept) {
                System.out.println("\nThere was an error in the conversion");
                convertExcept.printStackTrace();
            }
            if (dataOut == null) break block14;
            if (this.mergeFile == null) {
                Iterator<Object> docEnum = dataOut.getDocumentEnumeration();
                while (docEnum.hasNext()) {
                    Document docOut = (Document)docEnum.next();
                    String fileName = docOut.getFileName();
                    try {
                        FileOutputStream fos = new FileOutputStream(fileName);
                        docOut.write(fos);
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception writeExcept) {
                        System.out.println("\nThere was an writing out file <" + fileName + ">");
                        writeExcept.printStackTrace();
                    }
                }
            } else {
                try {
                    FileInputStream mergeIS = new FileInputStream(this.mergeFile);
                    Document mergeDoc = myConvert.getOfficeDocument(this.mergeFile, mergeIS);
                    DocumentMerger merger = myConvert.getDocumentMerger(mergeDoc);
                    Iterator<Object> mergeDocEnum = dataOut.getDocumentEnumeration();
                    Document convertedFile = (Document)mergeDocEnum.next();
                    merger.merge(convertedFile);
                    mergeIS.close();
                    FileOutputStream fos = new FileOutputStream(this.mergeFile);
                    mergeDoc.write(fos);
                    fos.flush();
                    fos.close();
                }
                catch (Exception mergeExcept) {
                    System.out.println("\nThere was an error in the merge");
                    mergeExcept.printStackTrace();
                }
            }
        }
    }

    private static void showUsage() {
        System.out.println("\nUsage:");
        System.out.println("\n   java org.openoffice.xmerge.test.Driver <args>");
        System.out.println("\n   where <args> is as follows:");
        System.out.println("   -from <MIMETYPE> -to <MIMETYPE> [ -merge <OrigDoc ] <document>\n");
    }

    private void parseCommandLine(String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < args.length; ++i) {
            int j;
            String arg = args[i];
            if ("-to".equals(arg)) {
                this.toMime = this.extractArg(i, args);
                for (j = 0; j < this.mimeTypes.length; j += 2) {
                    if (!this.mimeTypes[j].equals(this.extractArg(i, args))) continue;
                    this.toMime = this.mimeTypes[j + 1];
                }
                ++i;
                continue;
            }
            if ("-from".equals(arg)) {
                this.fromMime = this.extractArg(i, args);
                for (j = 0; j < this.mimeTypes.length; j += 2) {
                    if (!this.mimeTypes[j].equals(this.extractArg(i, args))) continue;
                    this.fromMime = this.mimeTypes[j + 1];
                }
                ++i;
                continue;
            }
            if ("-merge".equals(arg)) {
                this.mergeFile = this.extractArg(i, args);
                if (!this.isZip(this.mergeFile)) {
                    throw new IllegalArgumentException("Arg " + i + ": expected zip, got " + this.mergeFile);
                }
                ++i;
                continue;
            }
            this.deviceFiles.add(arg);
        }
        System.out.println("\nConverting from " + this.fromMime + " to " + this.toMime + (this.mergeFile != null ? " with merge " : " "));
    }

    private String extractArg(int i, String[] args) throws IllegalArgumentException {
        if (i + 1 < args.length) {
            return args[i + 1];
        }
        throw new IllegalArgumentException("Arg " + i + ": expected arg for " + args[i]);
    }

    private boolean isZip(String zipName) {
        String str = zipName.toLowerCase();
        return str.endsWith("sxw") || zipName.endsWith("sxc");
    }
}

