;;; strad.scm -- Translation CLM -> Snd

;; Bowed string physical model with stiffness.  CLM version adapted
;; from the Matlab and C versions courtesy of JOS and Stefania Serafin
;; from code revised on 7/14/01

;; CLM version by Juan Reyes
;; SND version by Michael Scholz (based on strad.ins)
;; revised by Bill to suit the run macro

(provide 'snd-strad.scm)
(if (provided? 'snd)
    (require snd-ws.scm)
    (require sndlib-ws.scm))

(define make-biquad 
  (let ((documentation "(make-biquad a0 a1 a2 b1 b2) returns a biquad filter (use with the CLM filter gen)"))
    (lambda (a0 a1 a2 b1 b2)
      (make-filter 3 
		   (float-vector a0 a1 a2) 
		   (float-vector 0.0 b1 b2)))))

(definstrument (bow beg dur frq amplitude
		    (bufsize 2205)
		    (fb 0.2) ;; bow force: between 0.0 and 1.0
		    (vb 0.05)	;; bow velocity: between 0.0 and 0.8
		    (bp 0.08)	;; bow position: 0.0=bridge; 0.5=middle of string; 1.0=Nut 
		    (inharm 0.1) ;; inharmonicity: 0.0 harmonic; 1.0 not harmonico
		    (ampenv '(0 1 15 1 95 1 100 0))
		    (degree 45) (dist 0.0025) (reverb 0))
  (let ((beg (seconds->samples beg))
	(len-1 (seconds->samples dur))
	(freq frq)
	(len (- (/ *clm-srate* frq ) 2))
	(twavespeedfactor 5.2)
	(stringImpedance 0.55)
	(stringImpedancet 1.8))
    (let ((lent (/ (- (/ *clm-srate* freq) 2) twavespeedfactor)))
      (let ((ampf (make-env :envelope ampenv :scaler amplitude :duration dur))
	    (end (+ beg len-1))
	    (loc (make-locsig degree dist reverb))
	    (vinut      (make-float-vector bufsize)) 
	    (vinbridge  (make-float-vector bufsize))
	    (vinutt     (make-float-vector bufsize))
	    (vinbridget (make-float-vector bufsize))
	    (vib 0.0) (vin 0.0) (vibt 0.0) (vint 0.0)
	    (mus 0.8)
	    (posl 0) (posr 0) 
	    (poslt 0) (posrt 0)
	    (indexl 0) (indexr 0)
	    (indexlt 0) (indexrt 0)
	    (indexl_1 0) (indexr_1 0)
	    (indexlt_1 0) (indexrt_1 0)
	    (indexl_2 0) (indexr_2 0)
	    (indexlt_2 0) (indexrt_2 0)
	    (updl 0) (updr 0)
	    (updlt 0) (updrt 0)
	    (b0b 0.859210)
	    (b1b -0.704922)
	    (b2b 0.022502)
	    (a1b -0.943639)
	    (a2b  0.120665)
	    (b0n  7.0580050e-001)
	    (b1n -5.3168461e-001)
	    (b2n  1.4579750e-002)
	    (a1n  -9.9142489e-001)
	    (a2n   1.8012052e-001)
	    (b0bt 9.9157155e-001)
	    (b1bt -8.2342890e-001)
	    (b2bt  8.8441749e-002)
	    (a1bt -8.3628218e-001)
	    (a2bt  9.2866585e-002)
	    (b0nt 4.3721359e-001)
	    (b1nt -2.7034968e-001)
	    (b2nt -5.7147560e-002)
	    (a1nt -1.2158343e+000)
	    (a2nt  3.2555068e-001)
	    (ynbt 0.0)
	    (ynn 0.0) (ynnt 0.0)
	    (y1nb 0.0) 
	    (vh 0.0)
	    (aa 0.0) (bb1 0.0) (cc1 0.0) (delta1 0.0)
	    (bb2 0.0) (cc2 0.0) (delta2 0.0)
	    (v 0.0) (v1 0.0) (v2 0.0)
	    (rhs #f) (lhs #f)
	    (vtemp 0.0)
	    (f 0.0)
	    (stick 0)
	    ;;(zslope (/ 1 (+ (/ 1 (* 2 stringImpedance)) (/ 1 (* 2 stringImpedancet)))))
	    (zslope (/ (* 2 stringImpedance stringImpedancet) (+ stringImpedance stringImpedancet)))
	    (xnn 0.0) (xnb 0.0)
	    (xnnt 0.0) (xnbt 0.0)
	    (alphar 0) (alphal 0)
	    (alphart 0) (alphalt 0)
	    (del_right (* len bp))
	    (del_left (* len (- 1 bp)))
	    (del_leftt (* lent (- 1 bp)))
	    (del_rightt (* lent bp)))
	(let ((samp_rperiod (floor del_right))
	      (samp_lperiod  (floor del_left))
	      (samp_lperiodt (floor del_leftt))
	      (samp_rperiodt (floor del_rightt)))

	  (define bowfilt
	    (let ((g1 (make-biquad b0b b1b b2b a1b a2b))
		  (g2 (make-biquad b0n b1n b2n a1n a2n))
		  (g3 (make-biquad b0bt b1bt b2bt a1bt a2bt))
		  (g4 (make-biquad b0nt b1nt b2nt a1nt a2nt))
		  (ya1nb 0.0) (ynba1 0.0) (ynb 0.0))
	      (lambda (inharmon)
		(set! ynb (filter g1 vib))
		(set! ynn (filter g2 vin))
		(set! ynbt (filter g3 vibt))
		(set! ynnt (filter g4 vint))
		(set! inharmon (min 0.9999 (max inharmon 0.00001)))
		(set! y1nb (- (+ ynba1 (* inharmon ya1nb)) (* inharmon ynb)))
		(set! ya1nb y1nb)
		(set! ynba1 ynb)
		(set! y1nb (- y1nb))
		(set! ynn (- ynn))
		(set! ynbt (- ynbt)))))
	    
	    (set! samp_rperiod (min (- bufsize 1) (max samp_rperiod 0)))
	    (set! samp_lperiod (min (- bufsize 1) (max samp_lperiod 0)))
	    (set! alphar (* 1.0 (- del_right samp_rperiod)))
	    (set! alphal (* 1.0 (- del_left samp_lperiod)))
	    (set! samp_rperiodt (min (- bufsize 1) (max samp_rperiodt 0)))
	    (set! samp_lperiodt (min (- bufsize 1) (max samp_lperiodt 0)))
	    (set! alphart (* 1.0 (- del_rightt samp_rperiodt)))
	    (set! alphalt (* 1.0 (- del_leftt samp_lperiodt)))
	    (set! posr (modulo (floor (+ end posr)) bufsize))
	    (set! posl (modulo (floor (+ end posl)) bufsize))
	    (set! posrt (modulo (floor (+ end posrt)) bufsize))
	    (set! poslt (modulo (floor (+ end poslt)) bufsize))
	    
	    (set! indexl (modulo (floor (- (+ beg posl bufsize) samp_lperiod)) bufsize))
	    (set! indexr (modulo (floor (- (+ beg posr bufsize) samp_rperiod)) bufsize))
	    (set! indexlt (modulo (floor (- (+ beg poslt bufsize) samp_lperiodt)) bufsize))
	    (set! indexrt (modulo (floor (- (+ beg posrt bufsize) samp_rperiodt)) bufsize))
	    (set! indexl_1 (modulo (floor (- (+ beg posl bufsize) samp_lperiod 1)) bufsize))
	    (set! indexr_1 (modulo (floor (- (+ beg posr bufsize) samp_rperiod 1)) bufsize))
	    (set! indexlt_1 (modulo (floor (- (+ beg poslt bufsize) samp_lperiodt 1)) bufsize))
	    (set! indexrt_1 (modulo (floor (- (+ beg posrt bufsize) samp_rperiodt 1)) bufsize))
	    (set! indexl_2 (modulo (floor (- (+ beg posl bufsize) samp_lperiod 2)) bufsize))
	    (set! indexr_2 (modulo (floor (- (+ beg posr bufsize) samp_rperiod 2)) bufsize))
	    (set! indexlt_2 (modulo (floor (- (+ beg poslt bufsize) samp_lperiodt 2)) bufsize))
	    (set! indexrt_2 (modulo (floor (- (+ beg posrt bufsize) samp_rperiodt 2)) bufsize))

	    (set! updl (modulo (floor (+ beg posl bufsize)) bufsize))
	    (set! updr (modulo (floor (+ beg posr bufsize)) bufsize))
	    (set! updlt (modulo (floor (+ beg poslt bufsize)) bufsize))
	    (set! updrt (modulo (floor (+ beg posrt bufsize)) bufsize))

	    (do ((i beg (+ i 1)))
		((= i end))

	      (set! vib (- (/ (* (- alphal 1)
				 (+ (* (vinbridge indexl_2) (- alphal 2))
				    (* (vinbridge indexl) alphal)))
			      2)
			   (* (vinbridge indexl_1) alphal (- alphal 2))))

	      (set! vin (- (/ (* (- alphar 1) 
				 (+ (* (vinut indexr_2) (- alphar 2)) 
				    (* (vinut indexr) alphar)))
			      2)
			   (* (vinut indexr_1) alphar (- alphar 2))))

	      (set! vibt (- (/ (* (- alphalt 1) 
				  (+ (* (vinbridget indexlt_2) (- alphalt 2))
				     (* (vinbridget indexlt) alphalt)))
			       2)
			    (* (vinbridget indexlt_1) alphalt (- alphalt 2))))

	      (set! vint (- (/ (* (- alphart 1) 
				  (+ (* (vinutt indexrt_2) (- alphart 2))
				     (* (vinutt indexrt) alphart)))
			       2)
			    (* (vinutt indexrt_1) alphart (- alphart 2))))

	      (bowfilt inharm)
	      (set! vh (+ ynn y1nb ynnt ynbt))
	      
	      (set! aa zslope)
	      (set! bb1 (- (+ (* 0.2 zslope) (* 0.3 fb)) (* zslope vb) (* zslope vh)))
	      (set! cc1 (- (+ (* 0.06 fb) (* zslope vh vb)) (* 0.2 zslope vh) (* 0.3 vb fb)))
	      (set! delta1 (- (* bb1 bb1) (* 4 aa cc1)))
	      (set! bb2 (- (* -0.2 zslope) (* 0.3 fb) (* zslope vb) (* zslope vh)))
	      (set! cc2 (+ (* 0.06 fb) 
			   (* zslope vh vb)
			   (* 0.2 zslope vh) 
			   (* 0.3 vb fb)
			   (* 0.1 fb)))
	      (set! delta2 (- (* bb2 bb2) (* 4 aa cc2)))
	      (if (or (= vb 0) (= fb 0))
		  (set! v vh)
		  (begin
		    (if (= vh vb)
			(begin
			  (set! v vb)
			  (set! stick 1))
			(begin
			  (if (> vh vb)
			      (begin
				(set! lhs #f)
				(set! rhs #t))
			      (begin
				(set! rhs #f)
				(set! lhs #t)))
			  (if rhs
			      (if (< delta1 0)
				  (begin
				    (set! v vb)
				    (set! stick 1))
				  (if (= stick 1)
				      (begin
					(set! vtemp vb)
					(set! f (* 2 zslope (- vtemp vh)))
					(if (>= f (- (* mus fb)))
					    (set! v vtemp)
					    (begin
					      (set! v1 (/ (- (sqrt delta1) bb1) (* 2 aa)))
					      (set! v2 (/ (- (+ bb1 (sqrt delta1))) (* 2 aa)))
					      (set! v (min v1 v2))
					      (set! stick 0))))
				      (begin
					(set! v1 (/ (- (sqrt delta1) bb1) (* 2 aa)))
					(set! v2 (/ (- (+ bb1 (sqrt delta1))) (* 2 aa)))
					(set! v (min v1 v2))
					(set! stick 0))))
			      (when lhs
				(if (< delta2 0)
				    (begin
				      (set! v vb)
				      (set! stick 1))
				    (if (= stick 1)
					(begin
					  (set! vtemp vb)
					  (set! f (* zslope (- vtemp vh)))
					  (if (and (<= f (* mus fb)) (> f 0))
					      (set! v vtemp)
					      (begin
						(set! v1 (/ (- (+ bb2 (sqrt delta2))) (* 2 aa)))
						(set! v2 (/ (- (sqrt delta2) bb2) (* 2 aa)))
						(set! vtemp (min v1 v2))
						(set! stick 0)
						(if (> vtemp vb)
						    (begin
						      (set! v vb)
						      (set! stick 1))
						    (begin
						      (set! v vtemp)
						      (set! f (* zslope (- v vh) )))))))
					(begin
					  (set! v1 (/ (- (+ bb2 (sqrt delta2))) (* 2 aa)))
					  (set! v2 (/ (- (sqrt delta2) bb2) (* 2 aa)))
					  (set! v (min v1 v2))
					  (set! stick 0))))
				(if (> v vb)
				    (begin
				      (set! v vb)
				      (set! stick 1)))))))
		    (set! f (* zslope (- v vh)))
		    (set! xnn (+ y1nb (/ f (* 2 stringImpedance))))
		    (set! xnb (+ ynn (/ f (* 2 stringImpedance))))))
	      
	      (set! f (* zslope (- v vh)))
	      (set! xnnt (+ ynbt (/ f (* 2 stringImpedancet))))
	      (set! xnbt (+ ynnt (/ f (* 2 stringImpedancet))))

	      (set! (vinbridge updl) xnb)
	      (set! (vinut updr) xnn)
	      (set! (vinbridget updlt) xnbt)
	      (set! (vinutt updrt) xnnt)
	      
	      (set! indexl (+ indexl 1)) (if (>= indexl bufsize) (set! indexl 0))
	      (set! indexr (+ indexr 1)) (if (>= indexr bufsize) (set! indexr 0))
	      (set! indexlt (+ indexlt 1)) (if (>= indexlt bufsize) (set! indexlt 0))
	      (set! indexrt (+ indexrt 1)) (if (>= indexrt bufsize) (set! indexrt 0))
	      (set! indexl_1 (+ indexl_1 1)) (if (>= indexl_1 bufsize) (set! indexl_1 0))
	      (set! indexr_1 (+ indexr_1 1)) (if (>= indexr_1 bufsize) (set! indexr_1 0))
	      (set! indexlt_1 (+ indexlt_1 1)) (if (>= indexlt_1 bufsize) (set! indexlt_1 0))
	      (set! indexrt_1 (+ indexrt_1 1)) (if (>= indexrt_1 bufsize) (set! indexrt_1 0))
	      (set! indexl_2 (+ indexl_2 1)) (if (>= indexl_2 bufsize) (set! indexl_2 0))
	      (set! indexr_2 (+ indexr_2 1)) (if (>= indexr_2 bufsize) (set! indexr_2 0))
	      (set! indexlt_2 (+ indexlt_2 1)) (if (>= indexlt_2 bufsize) (set! indexlt_2 0))
	      (set! indexrt_2 (+ indexrt_2 1)) (if (>= indexrt_2 bufsize) (set! indexrt_2 0))
	      
	      (set! updl (+ updl 1)) (if (>= updl bufsize) (set! updl 0))
	      (set! updr (+ updr 1)) (if (>= updr bufsize) (set! updr 0))
	      (set! updlt (+ updlt 1)) (if (>= updlt bufsize) (set! updlt 0))
	      (set! updrt (+ updrt 1)) (if (>= updrt bufsize) (set! updrt 0))

	      (locsig loc i (* xnb (env ampf)))
	      (set! lhs #f)
	      (set! rhs #f)))))))

					;(with-sound (:channels 2) (bow 0 3 400 0.5 :vb 0.15 :fb 0.1 :inharm 0.25))
					;(with-sound (:channels 2) (bow 0 2 440 0.5  :fb 0.25))
					;(with-sound (:channels 2) (bow 0 4 600 0.8))
					;(with-sound (:channels 2) (bow 0 6 147 2 :fb 0.035 :vb 0.1))
					;(with-sound (:channels 2) (bow 0 3 1100 0.5 :vb 0.45 :fb 0.9 :inharm 0.3))
					;(with-sound (:channels 2) (bow 0 3 1500 0.5 :vb 0.25 :fb 0.9 :inharm 0.3))
					;(with-sound (:channels 2) (bow 0 3 1525 0.5 :vb 0.25 :fb 0.9 :inharm 0.3))
					;(with-sound (:channels 2 :reverb jc-reverb) (bow 0 1 400 0.5 :reverb 0.0051))
					;
					;(with-sound (:channels 2 :reverb jc-reverb)
					; 	    (bow 0 3 366 0.5  :degree 0)
					; 	    (bow 0 3 422 0.5  :degree 90)
					; 	    (bow 4 6 147 2 :fb 0.035 :vb 0.1 :reverb 0.051))

;; strad.scm ends here
