/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publication;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.Usage;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.artifact.DefaultMavenArtifactSet;
import org.gradle.api.publish.maven.internal.dependencies.DefaultMavenDependency;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPom;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.api.specs.Spec;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.CollectionUtils;

public class DefaultMavenPublication
implements MavenPublicationInternal {
    private static final Set<ExcludeRule> EXCLUDE_ALL_RULE = Collections.singleton(new DefaultExcludeRule("*", "*"));
    private final String name;
    private final MavenPomInternal pom;
    private final MavenProjectIdentity projectIdentity;
    private final DefaultMavenArtifactSet mavenArtifacts;
    private final Set<MavenDependencyInternal> runtimeDependencies = new LinkedHashSet<MavenDependencyInternal>();
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private FileCollection pomFile;
    private SoftwareComponentInternal component;

    public DefaultMavenPublication(String name, MavenProjectIdentity projectIdentity, NotationParser<Object, MavenArtifact> mavenArtifactParser, Instantiator instantiator, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory) {
        this.name = name;
        this.projectDependencyResolver = projectDependencyResolver;
        this.projectIdentity = new DefaultMavenProjectIdentity(projectIdentity.getGroupId(), projectIdentity.getArtifactId(), projectIdentity.getVersion());
        this.mavenArtifacts = (DefaultMavenArtifactSet)instantiator.newInstance(DefaultMavenArtifactSet.class, new Object[]{name, mavenArtifactParser, fileCollectionFactory});
        this.pom = (MavenPomInternal)instantiator.newInstance(DefaultMavenPom.class, new Object[]{this});
    }

    public String getName() {
        return this.name;
    }

    @Override
    public MavenPomInternal getPom() {
        return this.pom;
    }

    @Override
    public void setPomFile(FileCollection pomFile) {
        this.pomFile = pomFile;
    }

    @Override
    public void pom(Action<? super MavenPom> configure) {
        configure.execute((Object)this.pom);
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Maven publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        for (Usage usage : this.component.getUsages()) {
            for (PublishArtifact publishArtifact : usage.getArtifacts()) {
                this.artifact(publishArtifact);
            }
            for (ModuleDependency dependency : usage.getDependencies()) {
                if (dependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)dependency);
                    continue;
                }
                this.addModuleDependency(dependency);
            }
        }
    }

    private void addProjectDependency(ProjectDependency dependency) {
        ModuleVersionIdentifier identifier = this.projectDependencyResolver.resolve(dependency);
        this.runtimeDependencies.add(new DefaultMavenDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), Collections.emptyList(), DefaultMavenPublication.getExcludeRules((ModuleDependency)dependency)));
    }

    private void addModuleDependency(ModuleDependency dependency) {
        this.runtimeDependencies.add(new DefaultMavenDependency(dependency.getGroup(), dependency.getName(), dependency.getVersion(), dependency.getArtifacts(), DefaultMavenPublication.getExcludeRules(dependency)));
    }

    private static Set<ExcludeRule> getExcludeRules(ModuleDependency dependency) {
        return dependency.isTransitive() ? dependency.getExcludeRules() : EXCLUDE_ALL_RULE;
    }

    @Override
    public MavenArtifact artifact(Object source) {
        return this.mavenArtifacts.artifact(source);
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        return this.mavenArtifacts.artifact(source, config);
    }

    @Override
    public MavenArtifactSet getArtifacts() {
        return this.mavenArtifacts;
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.mavenArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public String getGroupId() {
        return this.projectIdentity.getGroupId();
    }

    @Override
    public void setGroupId(String groupId) {
        this.projectIdentity.setGroupId(groupId);
    }

    @Override
    public String getArtifactId() {
        return this.projectIdentity.getArtifactId();
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.projectIdentity.setArtifactId(artifactId);
    }

    @Override
    public String getVersion() {
        return this.projectIdentity.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.projectIdentity.setVersion(version);
    }

    @Override
    public FileCollection getPublishableFiles() {
        return new UnionFileCollection(new FileCollection[]{this.mavenArtifacts.getFiles(), this.pomFile});
    }

    @Override
    public MavenProjectIdentity getMavenProjectIdentity() {
        return this.projectIdentity;
    }

    @Override
    public Set<MavenDependencyInternal> getRuntimeDependencies() {
        return this.runtimeDependencies;
    }

    @Override
    public MavenNormalizedPublication asNormalisedPublication() {
        return new MavenNormalizedPublication(this.name, this.getPomFile(), this.projectIdentity, (Set<MavenArtifact>)((Object)this.getArtifacts()), this.determineMainArtifact());
    }

    private File getPomFile() {
        if (this.pomFile == null) {
            throw new IllegalStateException("pomFile not set for publication");
        }
        return this.pomFile.getSingleFile();
    }

    @Override
    public String determinePackagingFromArtifacts() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next().getExtension();
        }
        return "pom";
    }

    private MavenArtifact determineMainArtifact() {
        Set<MavenArtifact> unclassifiedArtifacts = this.getUnclassifiedArtifactsWithExtension();
        if (unclassifiedArtifacts.isEmpty()) {
            return null;
        }
        if (unclassifiedArtifacts.size() == 1) {
            return unclassifiedArtifacts.iterator().next();
        }
        for (MavenArtifact unclassifiedArtifact : unclassifiedArtifacts) {
            String packaging = this.pom.getPackaging();
            if (!unclassifiedArtifact.getExtension().equals(packaging)) continue;
            return unclassifiedArtifact;
        }
        return null;
    }

    private Set<MavenArtifact> getUnclassifiedArtifactsWithExtension() {
        return CollectionUtils.filter((Set)((Object)this.mavenArtifacts), (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact mavenArtifact) {
                return DefaultMavenPublication.this.hasNoClassifier(mavenArtifact) && DefaultMavenPublication.this.hasExtension(mavenArtifact);
            }
        });
    }

    private boolean hasNoClassifier(MavenArtifact element) {
        return element.getClassifier() == null || element.getClassifier().length() == 0;
    }

    private boolean hasExtension(MavenArtifact element) {
        return element.getExtension() != null && element.getExtension().length() > 0;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return new DefaultModuleVersionIdentifier(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }
}

