/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeatureSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.SimpleDeclarationChecker;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/SuspendModifierChecker;", "Lorg/jetbrains/kotlin/resolve/SimpleDeclarationChecker;", "()V", "ALLOW_SUSPEND_EXTENSIONS_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin-compiler"})
public final class SuspendModifierChecker
implements SimpleDeclarationChecker {
    private static final FqName ALLOW_SUSPEND_EXTENSIONS_ANNOTATION_FQ_NAME;
    public static final SuspendModifierChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        boolean isValidContinuation;
        Annotated annotated;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!functionDescriptor2.isSuspend()) {
            return;
        }
        KtModifierList ktModifierList = declaration.getModifierList();
        PsiElement psiElement = ktModifierList != null ? ktModifierList.getModifier(KtTokens.SUSPEND_KEYWORD) : null;
        void v3 = $receiver$iv;
        if (v3 == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = String.valueOf(declaration.getText());
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        PsiElement suspendModifierElement = (PsiElement)v3;
        Function1<String, Unit> report$ = new Function1<String, Unit>(diagnosticHolder, suspendModifierElement){
            final /* synthetic */ DiagnosticSink $diagnosticHolder;
            final /* synthetic */ PsiElement $suspendModifierElement;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull(message, "message");
                this.$diagnosticHolder.report(Errors.INAPPLICABLE_MODIFIER.on(this.$suspendModifierElement, KtTokens.SUSPEND_KEYWORD, message));
            }
            {
                this.$diagnosticHolder = diagnosticSink;
                this.$suspendModifierElement = psiElement;
                super(1);
            }
        };
        if (functionDescriptor2.getDispatchReceiverParameter() == null) {
            ClassDescriptor classDescriptor;
            ClassifierDescriptor classifierDescriptor;
            if (functionDescriptor2.getExtensionReceiverParameter() == null) {
                report$.invoke("function must be either a class member or an extension");
                return;
            }
            ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (!((classifierDescriptor = receiverParameterDescriptor.getType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((classDescriptor = (ClassDescriptor)classifierDescriptor) == null) {
                report$.invoke("function must be an extension to class");
                return;
            }
            if (!classDescriptor.getAnnotations().hasAnnotation(ALLOW_SUSPEND_EXTENSIONS_ANNOTATION_FQ_NAME)) {
                report$.invoke("controller class must be annotated with AllowSuspendExtensions annotation");
                return;
            }
        }
        boolean bl = (annotated = CollectionsKt.lastOrNull(functionDescriptor2.getValueParameters())) != null && (annotated = annotated.getType()) != null ? CoroutineUtilKt.isValidContinuation((KotlinType)annotated) : (isValidContinuation = false);
        if (!isValidContinuation) {
            report$.invoke("last parameter of suspend function should have a type of Continuation<T>");
            return;
        }
    }

    private SuspendModifierChecker() {
        INSTANCE = this;
        ALLOW_SUSPEND_EXTENSIONS_ANNOTATION_FQ_NAME = new FqName("kotlin.coroutines.AllowSuspendExtensions");
    }

    static {
        new SuspendModifierChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageFeatureSettings languageFeatureSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageFeatureSettings, "languageFeatureSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageFeatureSettings);
    }
}

