/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.ShiftedProjecting;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;

public class TileCoordinateConverter {
    private MapView mapView;
    private TileSourceDisplaySettings settings;
    private final TileSource tileSource;

    public TileCoordinateConverter(MapView mapView, TileSource tileSource, TileSourceDisplaySettings tileSourceDisplaySettings) {
        this.mapView = mapView;
        this.tileSource = tileSource;
        this.settings = tileSourceDisplaySettings;
    }

    private MapViewState.MapViewPoint pos(ICoordinate iCoordinate) {
        return this.mapView.getState().getPointFor(new LatLon(iCoordinate)).add(this.settings.getDisplacement());
    }

    public Projecting getProjecting() {
        return new ShiftedProjecting(this.mapView.getProjection(), this.settings.getDisplacement());
    }

    public Point2D getPixelForTile(Tile tile) {
        ICoordinate iCoordinate = tile.getTileSource().tileXYToLatLon(tile);
        return this.pos(iCoordinate).getInView();
    }

    public Rectangle2D getRectangleForTile(Tile tile) {
        ICoordinate iCoordinate = tile.getTileSource().tileXYToLatLon(tile);
        ICoordinate iCoordinate2 = tile.getTileSource().tileXYToLatLon(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return this.pos(iCoordinate).rectTo(this.pos(iCoordinate2)).getInView();
    }

    public double getScaleFactor(int n) {
        LatLon latLon = this.mapView.getLatLon(0, 0);
        LatLon latLon2 = this.mapView.getLatLon(this.mapView.getWidth(), this.mapView.getHeight());
        TileXY tileXY = this.tileSource.latLonToTileXY(latLon.toCoordinate(), n);
        TileXY tileXY2 = this.tileSource.latLonToTileXY(latLon2.toCoordinate(), n);
        int n2 = this.mapView.getWidth() * this.mapView.getHeight();
        double d = Math.abs((tileXY2.getY() - tileXY.getY()) * (tileXY2.getX() - tileXY.getX()) * (double)this.tileSource.getTileSize() * (double)this.tileSource.getTileSize());
        if (n2 == 0 || d == 0.0) {
            return 1.0;
        }
        return (double)n2 / d;
    }
}

