/* Copyright 2012 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* jshint globalstrict: false */
/* umdutils ignore */

(function (root, factory) {
  'use strict';
  if (typeof define === 'function' && define.amd) {
define('pdfjs-dist/build/pdf.worker', ['exports'], factory);
  } else if (typeof exports !== 'undefined') {
    factory(exports);
  } else {
factory((root.pdfjsDistBuildPdfWorker = {}));
  }
}(this, function (exports) {
  // Use strict in our context only - users might not want it
  'use strict';

var pdfjsVersion = '1.5.408';
var pdfjsBuild = '23b13d3';

  var pdfjsFilePath =
    typeof document !== 'undefined' && document.currentScript ?
      document.currentScript.src : null;

  var pdfjsLibs = {};

  (function pdfjsWrapper() {



(function (root, factory) {
  {
    factory((root.pdfjsCoreArithmeticDecoder = {}));
  }
}(this, function (exports) {

/* This class implements the QM Coder decoding as defined in
 *   JPEG 2000 Part I Final Committee Draft Version 1.0
 *   Annex C.3 Arithmetic decoding procedure
 * available at http://www.jpeg.org/public/fcd15444-1.pdf
 *
 * The arithmetic decoder is used in conjunction with context models to decode
 * JPEG2000 and JBIG2 streams.
 */
var ArithmeticDecoder = (function ArithmeticDecoderClosure() {
  // Table C-2
  var QeTable = [
    {qe: 0x5601, nmps: 1, nlps: 1, switchFlag: 1},
    {qe: 0x3401, nmps: 2, nlps: 6, switchFlag: 0},
    {qe: 0x1801, nmps: 3, nlps: 9, switchFlag: 0},
    {qe: 0x0AC1, nmps: 4, nlps: 12, switchFlag: 0},
    {qe: 0x0521, nmps: 5, nlps: 29, switchFlag: 0},
    {qe: 0x0221, nmps: 38, nlps: 33, switchFlag: 0},
    {qe: 0x5601, nmps: 7, nlps: 6, switchFlag: 1},
    {qe: 0x5401, nmps: 8, nlps: 14, switchFlag: 0},
    {qe: 0x4801, nmps: 9, nlps: 14, switchFlag: 0},
    {qe: 0x3801, nmps: 10, nlps: 14, switchFlag: 0},
    {qe: 0x3001, nmps: 11, nlps: 17, switchFlag: 0},
    {qe: 0x2401, nmps: 12, nlps: 18, switchFlag: 0},
    {qe: 0x1C01, nmps: 13, nlps: 20, switchFlag: 0},
    {qe: 0x1601, nmps: 29, nlps: 21, switchFlag: 0},
    {qe: 0x5601, nmps: 15, nlps: 14, switchFlag: 1},
    {qe: 0x5401, nmps: 16, nlps: 14, switchFlag: 0},
    {qe: 0x5101, nmps: 17, nlps: 15, switchFlag: 0},
    {qe: 0x4801, nmps: 18, nlps: 16, switchFlag: 0},
    {qe: 0x3801, nmps: 19, nlps: 17, switchFlag: 0},
    {qe: 0x3401, nmps: 20, nlps: 18, switchFlag: 0},
    {qe: 0x3001, nmps: 21, nlps: 19, switchFlag: 0},
    {qe: 0x2801, nmps: 22, nlps: 19, switchFlag: 0},
    {qe: 0x2401, nmps: 23, nlps: 20, switchFlag: 0},
    {qe: 0x2201, nmps: 24, nlps: 21, switchFlag: 0},
    {qe: 0x1C01, nmps: 25, nlps: 22, switchFlag: 0},
    {qe: 0x1801, nmps: 26, nlps: 23, switchFlag: 0},
    {qe: 0x1601, nmps: 27, nlps: 24, switchFlag: 0},
    {qe: 0x1401, nmps: 28, nlps: 25, switchFlag: 0},
    {qe: 0x1201, nmps: 29, nlps: 26, switchFlag: 0},
    {qe: 0x1101, nmps: 30, nlps: 27, switchFlag: 0},
    {qe: 0x0AC1, nmps: 31, nlps: 28, switchFlag: 0},
    {qe: 0x09C1, nmps: 32, nlps: 29, switchFlag: 0},
    {qe: 0x08A1, nmps: 33, nlps: 30, switchFlag: 0},
    {qe: 0x0521, nmps: 34, nlps: 31, switchFlag: 0},
    {qe: 0x0441, nmps: 35, nlps: 32, switchFlag: 0},
    {qe: 0x02A1, nmps: 36, nlps: 33, switchFlag: 0},
    {qe: 0x0221, nmps: 37, nlps: 34, switchFlag: 0},
    {qe: 0x0141, nmps: 38, nlps: 35, switchFlag: 0},
    {qe: 0x0111, nmps: 39, nlps: 36, switchFlag: 0},
    {qe: 0x0085, nmps: 40, nlps: 37, switchFlag: 0},
    {qe: 0x0049, nmps: 41, nlps: 38, switchFlag: 0},
    {qe: 0x0025, nmps: 42, nlps: 39, switchFlag: 0},
    {qe: 0x0015, nmps: 43, nlps: 40, switchFlag: 0},
    {qe: 0x0009, nmps: 44, nlps: 41, switchFlag: 0},
    {qe: 0x0005, nmps: 45, nlps: 42, switchFlag: 0},
    {qe: 0x0001, nmps: 45, nlps: 43, switchFlag: 0},
    {qe: 0x5601, nmps: 46, nlps: 46, switchFlag: 0}
  ];

  // C.3.5 Initialisation of the decoder (INITDEC)
  function ArithmeticDecoder(data, start, end) {
    this.data = data;
    this.bp = start;
    this.dataEnd = end;

    this.chigh = data[start];
    this.clow = 0;

    this.byteIn();

    this.chigh = ((this.chigh << 7) & 0xFFFF) | ((this.clow >> 9) & 0x7F);
    this.clow = (this.clow << 7) & 0xFFFF;
    this.ct -= 7;
    this.a = 0x8000;
  }

  ArithmeticDecoder.prototype = {
    // C.3.4 Compressed data input (BYTEIN)
    byteIn: function ArithmeticDecoder_byteIn() {
      var data = this.data;
      var bp = this.bp;
      if (data[bp] === 0xFF) {
        var b1 = data[bp + 1];
        if (b1 > 0x8F) {
          this.clow += 0xFF00;
          this.ct = 8;
        } else {
          bp++;
          this.clow += (data[bp] << 9);
          this.ct = 7;
          this.bp = bp;
        }
      } else {
        bp++;
        this.clow += bp < this.dataEnd ? (data[bp] << 8) : 0xFF00;
        this.ct = 8;
        this.bp = bp;
      }
      if (this.clow > 0xFFFF) {
        this.chigh += (this.clow >> 16);
        this.clow &= 0xFFFF;
      }
    },
    // C.3.2 Decoding a decision (DECODE)
    readBit: function ArithmeticDecoder_readBit(contexts, pos) {
      // contexts are packed into 1 byte:
      // highest 7 bits carry cx.index, lowest bit carries cx.mps
      var cx_index = contexts[pos] >> 1, cx_mps = contexts[pos] & 1;
      var qeTableIcx = QeTable[cx_index];
      var qeIcx = qeTableIcx.qe;
      var d;
      var a = this.a - qeIcx;

      if (this.chigh < qeIcx) {
        // exchangeLps
        if (a < qeIcx) {
          a = qeIcx;
          d = cx_mps;
          cx_index = qeTableIcx.nmps;
        } else {
          a = qeIcx;
          d = 1 ^ cx_mps;
          if (qeTableIcx.switchFlag === 1) {
            cx_mps = d;
          }
          cx_index = qeTableIcx.nlps;
        }
      } else {
        this.chigh -= qeIcx;
        if ((a & 0x8000) !== 0) {
          this.a = a;
          return cx_mps;
        }
        // exchangeMps
        if (a < qeIcx) {
          d = 1 ^ cx_mps;
          if (qeTableIcx.switchFlag === 1) {
            cx_mps = d;
          }
          cx_index = qeTableIcx.nlps;
        } else {
          d = cx_mps;
          cx_index = qeTableIcx.nmps;
        }
      }
      // C.3.3 renormD;
      do {
        if (this.ct === 0) {
          this.byteIn();
        }

        a <<= 1;
        this.chigh = ((this.chigh << 1) & 0xFFFF) | ((this.clow >> 15) & 1);
        this.clow = (this.clow << 1) & 0xFFFF;
        this.ct--;
      } while ((a & 0x8000) === 0);
      this.a = a;

      contexts[pos] = cx_index << 1 | cx_mps;
      return d;
    }
  };

  return ArithmeticDecoder;
})();

exports.ArithmeticDecoder = ArithmeticDecoder;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreBidi = {}));
  }
}(this, function (exports) {

  // Character types for symbols from 0000 to 00FF.
  var baseTypes = [
    'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'S', 'B', 'S', 'WS',
    'B', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN',
    'BN', 'BN', 'B', 'B', 'B', 'S', 'WS', 'ON', 'ON', 'ET', 'ET', 'ET', 'ON',
    'ON', 'ON', 'ON', 'ON', 'ON', 'CS', 'ON', 'CS', 'ON', 'EN', 'EN', 'EN',
    'EN', 'EN', 'EN', 'EN', 'EN', 'EN', 'EN', 'ON', 'ON', 'ON', 'ON', 'ON',
    'ON', 'ON', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L',
    'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'ON', 'ON',
    'ON', 'ON', 'ON', 'ON', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L',
    'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L',
    'L', 'ON', 'ON', 'ON', 'ON', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'B', 'BN',
    'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN',
    'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN', 'BN',
    'BN', 'CS', 'ON', 'ET', 'ET', 'ET', 'ET', 'ON', 'ON', 'ON', 'ON', 'L', 'ON',
    'ON', 'ON', 'ON', 'ON', 'ET', 'ET', 'EN', 'EN', 'ON', 'L', 'ON', 'ON', 'ON',
    'EN', 'L', 'ON', 'ON', 'ON', 'ON', 'ON', 'L', 'L', 'L', 'L', 'L', 'L', 'L',
    'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L',
    'L', 'ON', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L',
    'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L',
    'L', 'L', 'L', 'ON', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L'
  ];

  // Character types for symbols from 0600 to 06FF
  var arabicTypes = [
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'CS', 'AL', 'ON', 'ON', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM',
    'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AN', 'AN', 'AN', 'AN', 'AN', 'AN', 'AN', 'AN', 'AN',
    'AN', 'ET', 'AN', 'AN', 'AL', 'AL', 'AL', 'NSM', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM',
    'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'NSM', 'ON', 'NSM',
    'NSM', 'NSM', 'NSM', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL',
    'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL', 'AL'
  ];

  function isOdd(i) {
    return (i & 1) !== 0;
  }

  function isEven(i) {
    return (i & 1) === 0;
  }

  function findUnequal(arr, start, value) {
    for (var j = start, jj = arr.length; j < jj; ++j) {
      if (arr[j] !== value) {
        return j;
      }
    }
    return j;
  }

  function setValues(arr, start, end, value) {
    for (var j = start; j < end; ++j) {
      arr[j] = value;
    }
  }

  function reverseValues(arr, start, end) {
    for (var i = start, j = end - 1; i < j; ++i, --j) {
      var temp = arr[i];
      arr[i] = arr[j];
      arr[j] = temp;
    }
  }

  function createBidiText(str, isLTR, vertical) {
    return {
      str: str,
      dir: (vertical ? 'ttb' : (isLTR ? 'ltr' : 'rtl'))
    };
  }

  // These are used in bidi(), which is called frequently. We re-use them on
  // each call to avoid unnecessary allocations.
  var chars = [];
  var types = [];

  function bidi(str, startLevel, vertical) {
    var isLTR = true;
    var strLength = str.length;
    if (strLength === 0 || vertical) {
      return createBidiText(str, isLTR, vertical);
    }

    // Get types and fill arrays
    chars.length = strLength;
    types.length = strLength;
    var numBidi = 0;

    var i, ii;
    for (i = 0; i < strLength; ++i) {
      chars[i] = str.charAt(i);

      var charCode = str.charCodeAt(i);
      var charType = 'L';
      if (charCode <= 0x00ff) {
        charType = baseTypes[charCode];
      } else if (0x0590 <= charCode && charCode <= 0x05f4) {
        charType = 'R';
      } else if (0x0600 <= charCode && charCode <= 0x06ff) {
        charType = arabicTypes[charCode & 0xff];
      } else if (0x0700 <= charCode && charCode <= 0x08AC) {
        charType = 'AL';
      }
      if (charType === 'R' || charType === 'AL' || charType === 'AN') {
        numBidi++;
      }
      types[i] = charType;
    }

    // Detect the bidi method
    // - If there are no rtl characters then no bidi needed
    // - If less than 30% chars are rtl then string is primarily ltr
    // - If more than 30% chars are rtl then string is primarily rtl
    if (numBidi === 0) {
      isLTR = true;
      return createBidiText(str, isLTR);
    }

    if (startLevel === -1) {
      if ((strLength / numBidi) < 0.3) {
        isLTR = true;
        startLevel = 0;
      } else {
        isLTR = false;
        startLevel = 1;
      }
    }

    var levels = [];
    for (i = 0; i < strLength; ++i) {
      levels[i] = startLevel;
    }

    /*
     X1-X10: skip most of this, since we are NOT doing the embeddings.
     */
    var e = (isOdd(startLevel) ? 'R' : 'L');
    var sor = e;
    var eor = sor;

    /*
     W1. Examine each non-spacing mark (NSM) in the level run, and change the
     type of the NSM to the type of the previous character. If the NSM is at the
     start of the level run, it will get the type of sor.
     */
    var lastType = sor;
    for (i = 0; i < strLength; ++i) {
      if (types[i] === 'NSM') {
        types[i] = lastType;
      } else {
        lastType = types[i];
      }
    }

    /*
     W2. Search backwards from each instance of a European number until the
     first strong type (R, L, AL, or sor) is found.  If an AL is found, change
     the type of the European number to Arabic number.
     */
    lastType = sor;
    var t;
    for (i = 0; i < strLength; ++i) {
      t = types[i];
      if (t === 'EN') {
        types[i] = (lastType === 'AL') ? 'AN' : 'EN';
      } else if (t === 'R' || t === 'L' || t === 'AL') {
        lastType = t;
      }
    }

    /*
     W3. Change all ALs to R.
     */
    for (i = 0; i < strLength; ++i) {
      t = types[i];
      if (t === 'AL') {
        types[i] = 'R';
      }
    }

    /*
     W4. A single European separator between two European numbers changes to a
     European number. A single common separator between two numbers of the same
     type changes to that type:
     */
    for (i = 1; i < strLength - 1; ++i) {
      if (types[i] === 'ES' && types[i - 1] === 'EN' && types[i + 1] === 'EN') {
        types[i] = 'EN';
      }
      if (types[i] === 'CS' &&
          (types[i - 1] === 'EN' || types[i - 1] === 'AN') &&
          types[i + 1] === types[i - 1]) {
        types[i] = types[i - 1];
      }
    }

    /*
     W5. A sequence of European terminators adjacent to European numbers changes
     to all European numbers:
     */
    for (i = 0; i < strLength; ++i) {
      if (types[i] === 'EN') {
        // do before
        var j;
        for (j = i - 1; j >= 0; --j) {
          if (types[j] !== 'ET') {
            break;
          }
          types[j] = 'EN';
        }
        // do after
        for (j = i + 1; j < strLength; ++j) {
          if (types[j] !== 'ET') {
            break;
          }
          types[j] = 'EN';
        }
      }
    }

    /*
     W6. Otherwise, separators and terminators change to Other Neutral:
     */
    for (i = 0; i < strLength; ++i) {
      t = types[i];
      if (t === 'WS' || t === 'ES' || t === 'ET' || t === 'CS') {
        types[i] = 'ON';
      }
    }

    /*
     W7. Search backwards from each instance of a European number until the
     first strong type (R, L, or sor) is found. If an L is found,  then change
     the type of the European number to L.
     */
    lastType = sor;
    for (i = 0; i < strLength; ++i) {
      t = types[i];
      if (t === 'EN') {
        types[i] = ((lastType === 'L') ? 'L' : 'EN');
      } else if (t === 'R' || t === 'L') {
        lastType = t;
      }
    }

    /*
     N1. A sequence of neutrals takes the direction of the surrounding strong
     text if the text on both sides has the same direction. European and Arabic
     numbers are treated as though they were R. Start-of-level-run (sor) and
     end-of-level-run (eor) are used at level run boundaries.
     */
    for (i = 0; i < strLength; ++i) {
      if (types[i] === 'ON') {
        var end = findUnequal(types, i + 1, 'ON');
        var before = sor;
        if (i > 0) {
          before = types[i - 1];
        }

        var after = eor;
        if (end + 1 < strLength) {
          after = types[end + 1];
        }
        if (before !== 'L') {
          before = 'R';
        }
        if (after !== 'L') {
          after = 'R';
        }
        if (before === after) {
          setValues(types, i, end, before);
        }
        i = end - 1; // reset to end (-1 so next iteration is ok)
      }
    }

    /*
     N2. Any remaining neutrals take the embedding direction.
     */
    for (i = 0; i < strLength; ++i) {
      if (types[i] === 'ON') {
        types[i] = e;
      }
    }

    /*
     I1. For all characters with an even (left-to-right) embedding direction,
     those of type R go up one level and those of type AN or EN go up two
     levels.
     I2. For all characters with an odd (right-to-left) embedding direction,
     those of type L, EN or AN go up one level.
     */
    for (i = 0; i < strLength; ++i) {
      t = types[i];
      if (isEven(levels[i])) {
        if (t === 'R') {
          levels[i] += 1;
        } else if (t === 'AN' || t === 'EN') {
          levels[i] += 2;
        }
      } else { // isOdd
        if (t === 'L' || t === 'AN' || t === 'EN') {
          levels[i] += 1;
        }
      }
    }

    /*
     L1. On each line, reset the embedding level of the following characters to
     the paragraph embedding level:

     segment separators,
     paragraph separators,
     any sequence of whitespace characters preceding a segment separator or
     paragraph separator, and any sequence of white space characters at the end
     of the line.
     */

    // don't bother as text is only single line

    /*
     L2. From the highest level found in the text to the lowest odd level on
     each line, reverse any contiguous sequence of characters that are at that
     level or higher.
     */

    // find highest level & lowest odd level
    var highestLevel = -1;
    var lowestOddLevel = 99;
    var level;
    for (i = 0, ii = levels.length; i < ii; ++i) {
      level = levels[i];
      if (highestLevel < level) {
        highestLevel = level;
      }
      if (lowestOddLevel > level && isOdd(level)) {
        lowestOddLevel = level;
      }
    }

    // now reverse between those limits
    for (level = highestLevel; level >= lowestOddLevel; --level) {
      // find segments to reverse
      var start = -1;
      for (i = 0, ii = levels.length; i < ii; ++i) {
        if (levels[i] < level) {
          if (start >= 0) {
            reverseValues(chars, start, i);
            start = -1;
          }
        } else if (start < 0) {
          start = i;
        }
      }
      if (start >= 0) {
        reverseValues(chars, start, levels.length);
      }
    }

    /*
     L3. Combining marks applied to a right-to-left base character will at this
     point precede their base character. If the rendering engine expects them to
     follow the base characters in the final display process, then the ordering
     of the marks and the base character must be reversed.
     */

    // don't bother for now

    /*
     L4. A character that possesses the mirrored property as specified by
     Section 4.7, Mirrored, must be depicted by a mirrored glyph if the resolved
     directionality of that character is R.
     */

    // don't mirror as characters are already mirrored in the pdf

    // Finally, return string
    for (i = 0, ii = chars.length; i < ii; ++i) {
      var ch = chars[i];
      if (ch === '<' || ch === '>') {
        chars[i] = '';
      }
    }
    return createBidiText(chars.join(''), isLTR);
  }

exports.bidi = bidi;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreCharsets = {}));
  }
}(this, function (exports) {

var ISOAdobeCharset = [
  '.notdef', 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar',
  'percent', 'ampersand', 'quoteright', 'parenleft', 'parenright',
  'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash', 'zero',
  'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight',
  'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question',
  'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
  'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
  'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore',
  'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l',
  'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
  'braceleft', 'bar', 'braceright', 'asciitilde', 'exclamdown', 'cent',
  'sterling', 'fraction', 'yen', 'florin', 'section', 'currency',
  'quotesingle', 'quotedblleft', 'guillemotleft', 'guilsinglleft',
  'guilsinglright', 'fi', 'fl', 'endash', 'dagger', 'daggerdbl',
  'periodcentered', 'paragraph', 'bullet', 'quotesinglbase',
  'quotedblbase', 'quotedblright', 'guillemotright', 'ellipsis',
  'perthousand', 'questiondown', 'grave', 'acute', 'circumflex', 'tilde',
  'macron', 'breve', 'dotaccent', 'dieresis', 'ring', 'cedilla',
  'hungarumlaut', 'ogonek', 'caron', 'emdash', 'AE', 'ordfeminine',
  'Lslash', 'Oslash', 'OE', 'ordmasculine', 'ae', 'dotlessi', 'lslash',
  'oslash', 'oe', 'germandbls', 'onesuperior', 'logicalnot', 'mu',
  'trademark', 'Eth', 'onehalf', 'plusminus', 'Thorn', 'onequarter',
  'divide', 'brokenbar', 'degree', 'thorn', 'threequarters', 'twosuperior',
  'registered', 'minus', 'eth', 'multiply', 'threesuperior', 'copyright',
  'Aacute', 'Acircumflex', 'Adieresis', 'Agrave', 'Aring', 'Atilde',
  'Ccedilla', 'Eacute', 'Ecircumflex', 'Edieresis', 'Egrave', 'Iacute',
  'Icircumflex', 'Idieresis', 'Igrave', 'Ntilde', 'Oacute', 'Ocircumflex',
  'Odieresis', 'Ograve', 'Otilde', 'Scaron', 'Uacute', 'Ucircumflex',
  'Udieresis', 'Ugrave', 'Yacute', 'Ydieresis', 'Zcaron', 'aacute',
  'acircumflex', 'adieresis', 'agrave', 'aring', 'atilde', 'ccedilla',
  'eacute', 'ecircumflex', 'edieresis', 'egrave', 'iacute', 'icircumflex',
  'idieresis', 'igrave', 'ntilde', 'oacute', 'ocircumflex', 'odieresis',
  'ograve', 'otilde', 'scaron', 'uacute', 'ucircumflex', 'udieresis',
  'ugrave', 'yacute', 'ydieresis', 'zcaron'
];

var ExpertCharset = [
  '.notdef', 'space', 'exclamsmall', 'Hungarumlautsmall', 'dollaroldstyle',
  'dollarsuperior', 'ampersandsmall', 'Acutesmall', 'parenleftsuperior',
  'parenrightsuperior', 'twodotenleader', 'onedotenleader', 'comma',
  'hyphen', 'period', 'fraction', 'zerooldstyle', 'oneoldstyle',
  'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle',
  'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle',
  'colon', 'semicolon', 'commasuperior', 'threequartersemdash',
  'periodsuperior', 'questionsmall', 'asuperior', 'bsuperior',
  'centsuperior', 'dsuperior', 'esuperior', 'isuperior', 'lsuperior',
  'msuperior', 'nsuperior', 'osuperior', 'rsuperior', 'ssuperior',
  'tsuperior', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'parenleftinferior',
  'parenrightinferior', 'Circumflexsmall', 'hyphensuperior', 'Gravesmall',
  'Asmall', 'Bsmall', 'Csmall', 'Dsmall', 'Esmall', 'Fsmall', 'Gsmall',
  'Hsmall', 'Ismall', 'Jsmall', 'Ksmall', 'Lsmall', 'Msmall', 'Nsmall',
  'Osmall', 'Psmall', 'Qsmall', 'Rsmall', 'Ssmall', 'Tsmall', 'Usmall',
  'Vsmall', 'Wsmall', 'Xsmall', 'Ysmall', 'Zsmall', 'colonmonetary',
  'onefitted', 'rupiah', 'Tildesmall', 'exclamdownsmall', 'centoldstyle',
  'Lslashsmall', 'Scaronsmall', 'Zcaronsmall', 'Dieresissmall',
  'Brevesmall', 'Caronsmall', 'Dotaccentsmall', 'Macronsmall',
  'figuredash', 'hypheninferior', 'Ogoneksmall', 'Ringsmall',
  'Cedillasmall', 'onequarter', 'onehalf', 'threequarters',
  'questiondownsmall', 'oneeighth', 'threeeighths', 'fiveeighths',
  'seveneighths', 'onethird', 'twothirds', 'zerosuperior', 'onesuperior',
  'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior',
  'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior',
  'zeroinferior', 'oneinferior', 'twoinferior', 'threeinferior',
  'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior',
  'eightinferior', 'nineinferior', 'centinferior', 'dollarinferior',
  'periodinferior', 'commainferior', 'Agravesmall', 'Aacutesmall',
  'Acircumflexsmall', 'Atildesmall', 'Adieresissmall', 'Aringsmall',
  'AEsmall', 'Ccedillasmall', 'Egravesmall', 'Eacutesmall',
  'Ecircumflexsmall', 'Edieresissmall', 'Igravesmall', 'Iacutesmall',
  'Icircumflexsmall', 'Idieresissmall', 'Ethsmall', 'Ntildesmall',
  'Ogravesmall', 'Oacutesmall', 'Ocircumflexsmall', 'Otildesmall',
  'Odieresissmall', 'OEsmall', 'Oslashsmall', 'Ugravesmall', 'Uacutesmall',
  'Ucircumflexsmall', 'Udieresissmall', 'Yacutesmall', 'Thornsmall',
  'Ydieresissmall'
];

var ExpertSubsetCharset = [
  '.notdef', 'space', 'dollaroldstyle', 'dollarsuperior',
  'parenleftsuperior', 'parenrightsuperior', 'twodotenleader',
  'onedotenleader', 'comma', 'hyphen', 'period', 'fraction',
  'zerooldstyle', 'oneoldstyle', 'twooldstyle', 'threeoldstyle',
  'fouroldstyle', 'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle',
  'eightoldstyle', 'nineoldstyle', 'colon', 'semicolon', 'commasuperior',
  'threequartersemdash', 'periodsuperior', 'asuperior', 'bsuperior',
  'centsuperior', 'dsuperior', 'esuperior', 'isuperior', 'lsuperior',
  'msuperior', 'nsuperior', 'osuperior', 'rsuperior', 'ssuperior',
  'tsuperior', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'parenleftinferior',
  'parenrightinferior', 'hyphensuperior', 'colonmonetary', 'onefitted',
  'rupiah', 'centoldstyle', 'figuredash', 'hypheninferior', 'onequarter',
  'onehalf', 'threequarters', 'oneeighth', 'threeeighths', 'fiveeighths',
  'seveneighths', 'onethird', 'twothirds', 'zerosuperior', 'onesuperior',
  'twosuperior', 'threesuperior', 'foursuperior', 'fivesuperior',
  'sixsuperior', 'sevensuperior', 'eightsuperior', 'ninesuperior',
  'zeroinferior', 'oneinferior', 'twoinferior', 'threeinferior',
  'fourinferior', 'fiveinferior', 'sixinferior', 'seveninferior',
  'eightinferior', 'nineinferior', 'centinferior', 'dollarinferior',
  'periodinferior', 'commainferior'
];

exports.ISOAdobeCharset = ISOAdobeCharset;
exports.ExpertCharset = ExpertCharset;
exports.ExpertSubsetCharset = ExpertSubsetCharset;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreEncodings = {}));
  }
}(this, function (exports) {

  var ExpertEncoding = [
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'space', 'exclamsmall', 'Hungarumlautsmall', '', 'dollaroldstyle',
    'dollarsuperior', 'ampersandsmall', 'Acutesmall', 'parenleftsuperior',
    'parenrightsuperior', 'twodotenleader', 'onedotenleader', 'comma',
    'hyphen', 'period', 'fraction', 'zerooldstyle', 'oneoldstyle',
    'twooldstyle', 'threeoldstyle', 'fouroldstyle', 'fiveoldstyle',
    'sixoldstyle', 'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'colon',
    'semicolon', 'commasuperior', 'threequartersemdash', 'periodsuperior',
    'questionsmall', '', 'asuperior', 'bsuperior', 'centsuperior', 'dsuperior',
    'esuperior', '', '', 'isuperior', '', '', 'lsuperior', 'msuperior',
    'nsuperior', 'osuperior', '', '', 'rsuperior', 'ssuperior', 'tsuperior',
    '', 'ff', 'fi', 'fl', 'ffi', 'ffl', 'parenleftinferior', '',
    'parenrightinferior', 'Circumflexsmall', 'hyphensuperior', 'Gravesmall',
    'Asmall', 'Bsmall', 'Csmall', 'Dsmall', 'Esmall', 'Fsmall', 'Gsmall',
    'Hsmall', 'Ismall', 'Jsmall', 'Ksmall', 'Lsmall', 'Msmall', 'Nsmall',
    'Osmall', 'Psmall', 'Qsmall', 'Rsmall', 'Ssmall', 'Tsmall', 'Usmall',
    'Vsmall', 'Wsmall', 'Xsmall', 'Ysmall', 'Zsmall', 'colonmonetary',
    'onefitted', 'rupiah', 'Tildesmall', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', 'exclamdownsmall', 'centoldstyle', 'Lslashsmall',
    '', '', 'Scaronsmall', 'Zcaronsmall', 'Dieresissmall', 'Brevesmall',
    'Caronsmall', '', 'Dotaccentsmall', '', '', 'Macronsmall', '', '',
    'figuredash', 'hypheninferior', '', '', 'Ogoneksmall', 'Ringsmall',
    'Cedillasmall', '', '', '', 'onequarter', 'onehalf', 'threequarters',
    'questiondownsmall', 'oneeighth', 'threeeighths', 'fiveeighths',
    'seveneighths', 'onethird', 'twothirds', '', '', 'zerosuperior',
    'onesuperior', 'twosuperior', 'threesuperior', 'foursuperior',
    'fivesuperior', 'sixsuperior', 'sevensuperior', 'eightsuperior',
    'ninesuperior', 'zeroinferior', 'oneinferior', 'twoinferior',
    'threeinferior', 'fourinferior', 'fiveinferior', 'sixinferior',
    'seveninferior', 'eightinferior', 'nineinferior', 'centinferior',
    'dollarinferior', 'periodinferior', 'commainferior', 'Agravesmall',
    'Aacutesmall', 'Acircumflexsmall', 'Atildesmall', 'Adieresissmall',
    'Aringsmall', 'AEsmall', 'Ccedillasmall', 'Egravesmall', 'Eacutesmall',
    'Ecircumflexsmall', 'Edieresissmall', 'Igravesmall', 'Iacutesmall',
    'Icircumflexsmall', 'Idieresissmall', 'Ethsmall', 'Ntildesmall',
    'Ogravesmall', 'Oacutesmall', 'Ocircumflexsmall', 'Otildesmall',
    'Odieresissmall', 'OEsmall', 'Oslashsmall', 'Ugravesmall', 'Uacutesmall',
    'Ucircumflexsmall', 'Udieresissmall', 'Yacutesmall', 'Thornsmall',
    'Ydieresissmall'];

  var MacExpertEncoding = [
    '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'space', 'exclamsmall', 'Hungarumlautsmall', 'centoldstyle',
    'dollaroldstyle', 'dollarsuperior', 'ampersandsmall', 'Acutesmall',
    'parenleftsuperior', 'parenrightsuperior', 'twodotenleader',
    'onedotenleader', 'comma', 'hyphen', 'period', 'fraction', 'zerooldstyle',
    'oneoldstyle', 'twooldstyle', 'threeoldstyle', 'fouroldstyle',
    'fiveoldstyle', 'sixoldstyle', 'sevenoldstyle', 'eightoldstyle',
    'nineoldstyle', 'colon', 'semicolon', '', 'threequartersemdash', '',
    'questionsmall', '', '', '', '', 'Ethsmall', '', '', 'onequarter',
    'onehalf', 'threequarters', 'oneeighth', 'threeeighths', 'fiveeighths',
    'seveneighths', 'onethird', 'twothirds', '', '', '', '', '', '', 'ff',
    'fi', 'fl', 'ffi', 'ffl', 'parenleftinferior', '', 'parenrightinferior',
    'Circumflexsmall', 'hypheninferior', 'Gravesmall', 'Asmall', 'Bsmall',
    'Csmall', 'Dsmall', 'Esmall', 'Fsmall', 'Gsmall', 'Hsmall', 'Ismall',
    'Jsmall', 'Ksmall', 'Lsmall', 'Msmall', 'Nsmall', 'Osmall', 'Psmall',
    'Qsmall', 'Rsmall', 'Ssmall', 'Tsmall', 'Usmall', 'Vsmall', 'Wsmall',
    'Xsmall', 'Ysmall', 'Zsmall', 'colonmonetary', 'onefitted', 'rupiah',
    'Tildesmall', '', '', 'asuperior', 'centsuperior', '', '', '', '',
    'Aacutesmall', 'Agravesmall', 'Acircumflexsmall', 'Adieresissmall',
    'Atildesmall', 'Aringsmall', 'Ccedillasmall', 'Eacutesmall', 'Egravesmall',
    'Ecircumflexsmall', 'Edieresissmall', 'Iacutesmall', 'Igravesmall',
    'Icircumflexsmall', 'Idieresissmall', 'Ntildesmall', 'Oacutesmall',
    'Ogravesmall', 'Ocircumflexsmall', 'Odieresissmall', 'Otildesmall',
    'Uacutesmall', 'Ugravesmall', 'Ucircumflexsmall', 'Udieresissmall', '',
    'eightsuperior', 'fourinferior', 'threeinferior', 'sixinferior',
    'eightinferior', 'seveninferior', 'Scaronsmall', '', 'centinferior',
    'twoinferior', '', 'Dieresissmall', '', 'Caronsmall', 'osuperior',
    'fiveinferior', '', 'commainferior', 'periodinferior', 'Yacutesmall', '',
    'dollarinferior', '', 'Thornsmall', '', 'nineinferior', 'zeroinferior',
    'Zcaronsmall', 'AEsmall', 'Oslashsmall', 'questiondownsmall',
    'oneinferior', 'Lslashsmall', '', '', '', '', '', '', 'Cedillasmall', '',
    '', '', '', '', 'OEsmall', 'figuredash', 'hyphensuperior', '', '', '', '',
    'exclamdownsmall', '', 'Ydieresissmall', '', 'onesuperior', 'twosuperior',
    'threesuperior', 'foursuperior', 'fivesuperior', 'sixsuperior',
    'sevensuperior', 'ninesuperior', 'zerosuperior', '', 'esuperior',
    'rsuperior', 'tsuperior', '', '', 'isuperior', 'ssuperior', 'dsuperior',
    '', '', '', '', '', 'lsuperior', 'Ogoneksmall', 'Brevesmall',
    'Macronsmall', 'bsuperior', 'nsuperior', 'msuperior', 'commasuperior',
    'periodsuperior', 'Dotaccentsmall', 'Ringsmall'];

  var MacRomanEncoding = [
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent',
    'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus',
    'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three',
    'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon',
    'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F',
    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',
    'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright',
    'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
    'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
    'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', '',
    'Adieresis', 'Aring', 'Ccedilla', 'Eacute', 'Ntilde', 'Odieresis',
    'Udieresis', 'aacute', 'agrave', 'acircumflex', 'adieresis', 'atilde',
    'aring', 'ccedilla', 'eacute', 'egrave', 'ecircumflex', 'edieresis',
    'iacute', 'igrave', 'icircumflex', 'idieresis', 'ntilde', 'oacute',
    'ograve', 'ocircumflex', 'odieresis', 'otilde', 'uacute', 'ugrave',
    'ucircumflex', 'udieresis', 'dagger', 'degree', 'cent', 'sterling',
    'section', 'bullet', 'paragraph', 'germandbls', 'registered', 'copyright',
    'trademark', 'acute', 'dieresis', 'notequal', 'AE', 'Oslash', 'infinity',
    'plusminus', 'lessequal', 'greaterequal', 'yen', 'mu', 'partialdiff',
    'summation', 'product', 'pi', 'integral', 'ordfeminine', 'ordmasculine',
    'Omega', 'ae', 'oslash', 'questiondown', 'exclamdown', 'logicalnot',
    'radical', 'florin', 'approxequal', 'Delta', 'guillemotleft',
    'guillemotright', 'ellipsis', 'space', 'Agrave', 'Atilde', 'Otilde', 'OE',
    'oe', 'endash', 'emdash', 'quotedblleft', 'quotedblright', 'quoteleft',
    'quoteright', 'divide', 'lozenge', 'ydieresis', 'Ydieresis', 'fraction',
    'currency', 'guilsinglleft', 'guilsinglright', 'fi', 'fl', 'daggerdbl',
    'periodcentered', 'quotesinglbase', 'quotedblbase', 'perthousand',
    'Acircumflex', 'Ecircumflex', 'Aacute', 'Edieresis', 'Egrave', 'Iacute',
    'Icircumflex', 'Idieresis', 'Igrave', 'Oacute', 'Ocircumflex', 'apple',
    'Ograve', 'Uacute', 'Ucircumflex', 'Ugrave', 'dotlessi', 'circumflex',
    'tilde', 'macron', 'breve', 'dotaccent', 'ring', 'cedilla', 'hungarumlaut',
    'ogonek', 'caron'];

  var StandardEncoding = [
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent',
    'ampersand', 'quoteright', 'parenleft', 'parenright', 'asterisk', 'plus',
    'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three',
    'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon',
    'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F',
    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',
    'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright',
    'asciicircum', 'underscore', 'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f',
    'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u',
    'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'exclamdown',
    'cent', 'sterling', 'fraction', 'yen', 'florin', 'section', 'currency',
    'quotesingle', 'quotedblleft', 'guillemotleft', 'guilsinglleft',
    'guilsinglright', 'fi', 'fl', '', 'endash', 'dagger', 'daggerdbl',
    'periodcentered', '', 'paragraph', 'bullet', 'quotesinglbase',
    'quotedblbase', 'quotedblright', 'guillemotright', 'ellipsis',
    'perthousand', '', 'questiondown', '', 'grave', 'acute', 'circumflex',
    'tilde', 'macron', 'breve', 'dotaccent', 'dieresis', '', 'ring', 'cedilla',
    '', 'hungarumlaut', 'ogonek', 'caron', 'emdash', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', 'AE', '', 'ordfeminine', '', '',
    '', '', 'Lslash', 'Oslash', 'OE', 'ordmasculine', '', '', '', '', '', 'ae',
    '', '', '', 'dotlessi', '', '', 'lslash', 'oslash', 'oe', 'germandbls'];

  var WinAnsiEncoding = [
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent',
    'ampersand', 'quotesingle', 'parenleft', 'parenright', 'asterisk', 'plus',
    'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three',
    'four', 'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon',
    'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F',
    'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',
    'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright',
    'asciicircum', 'underscore', 'grave', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
    'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
    'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde',
    'bullet', 'Euro', 'bullet', 'quotesinglbase', 'florin', 'quotedblbase',
    'ellipsis', 'dagger', 'daggerdbl', 'circumflex', 'perthousand', 'Scaron',
    'guilsinglleft', 'OE', 'bullet', 'Zcaron', 'bullet', 'bullet', 'quoteleft',
    'quoteright', 'quotedblleft', 'quotedblright', 'bullet', 'endash',
    'emdash', 'tilde', 'trademark', 'scaron', 'guilsinglright', 'oe', 'bullet',
    'zcaron', 'Ydieresis', 'space', 'exclamdown', 'cent', 'sterling',
    'currency', 'yen', 'brokenbar', 'section', 'dieresis', 'copyright',
    'ordfeminine', 'guillemotleft', 'logicalnot', 'hyphen', 'registered',
    'macron', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute',
    'mu', 'paragraph', 'periodcentered', 'cedilla', 'onesuperior',
    'ordmasculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters',
    'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adieresis',
    'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Edieresis',
    'Igrave', 'Iacute', 'Icircumflex', 'Idieresis', 'Eth', 'Ntilde', 'Ograve',
    'Oacute', 'Ocircumflex', 'Otilde', 'Odieresis', 'multiply', 'Oslash',
    'Ugrave', 'Uacute', 'Ucircumflex', 'Udieresis', 'Yacute', 'Thorn',
    'germandbls', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adieresis',
    'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'edieresis',
    'igrave', 'iacute', 'icircumflex', 'idieresis', 'eth', 'ntilde', 'ograve',
    'oacute', 'ocircumflex', 'otilde', 'odieresis', 'divide', 'oslash',
    'ugrave', 'uacute', 'ucircumflex', 'udieresis', 'yacute', 'thorn',
    'ydieresis'];

  var SymbolSetEncoding = [
    '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'space', 'exclam', 'universal', 'numbersign', 'existential', 'percent',
    'ampersand', 'suchthat', 'parenleft', 'parenright', 'asteriskmath', 'plus',
    'comma', 'minus', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four',
    'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less',
    'equal', 'greater', 'question', 'congruent', 'Alpha', 'Beta', 'Chi',
    'Delta', 'Epsilon', 'Phi', 'Gamma', 'Eta', 'Iota', 'theta1', 'Kappa',
    'Lambda', 'Mu', 'Nu', 'Omicron', 'Pi', 'Theta', 'Rho', 'Sigma', 'Tau',
    'Upsilon', 'sigma1', 'Omega', 'Xi', 'Psi', 'Zeta', 'bracketleft',
    'therefore', 'bracketright', 'perpendicular', 'underscore', 'radicalex',
    'alpha', 'beta', 'chi', 'delta', 'epsilon', 'phi', 'gamma', 'eta', 'iota',
    'phi1', 'kappa', 'lambda', 'mu', 'nu', 'omicron', 'pi', 'theta', 'rho',
    'sigma', 'tau', 'upsilon', 'omega1', 'omega', 'xi', 'psi', 'zeta',
    'braceleft', 'bar', 'braceright', 'similar', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', 'Euro', 'Upsilon1', 'minute', 'lessequal',
    'fraction', 'infinity', 'florin', 'club', 'diamond', 'heart', 'spade',
    'arrowboth', 'arrowleft', 'arrowup', 'arrowright', 'arrowdown', 'degree',
    'plusminus', 'second', 'greaterequal', 'multiply', 'proportional',
    'partialdiff', 'bullet', 'divide', 'notequal', 'equivalence',
    'approxequal', 'ellipsis', 'arrowvertex', 'arrowhorizex', 'carriagereturn',
    'aleph', 'Ifraktur', 'Rfraktur', 'weierstrass', 'circlemultiply',
    'circleplus', 'emptyset', 'intersection', 'union', 'propersuperset',
    'reflexsuperset', 'notsubset', 'propersubset', 'reflexsubset', 'element',
    'notelement', 'angle', 'gradient', 'registerserif', 'copyrightserif',
    'trademarkserif', 'product', 'radical', 'dotmath', 'logicalnot',
    'logicaland', 'logicalor', 'arrowdblboth', 'arrowdblleft', 'arrowdblup',
    'arrowdblright', 'arrowdbldown', 'lozenge', 'angleleft', 'registersans',
    'copyrightsans', 'trademarksans', 'summation', 'parenlefttp',
    'parenleftex', 'parenleftbt', 'bracketlefttp', 'bracketleftex',
    'bracketleftbt', 'bracelefttp', 'braceleftmid', 'braceleftbt', 'braceex',
    '', 'angleright', 'integral', 'integraltp', 'integralex', 'integralbt',
    'parenrighttp', 'parenrightex', 'parenrightbt', 'bracketrighttp',
    'bracketrightex', 'bracketrightbt', 'bracerighttp', 'bracerightmid',
    'bracerightbt'];

  var ZapfDingbatsEncoding = [
    '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    'space', 'a1', 'a2', 'a202', 'a3', 'a4', 'a5', 'a119', 'a118', 'a117',
    'a11', 'a12', 'a13', 'a14', 'a15', 'a16', 'a105', 'a17', 'a18', 'a19',
    'a20', 'a21', 'a22', 'a23', 'a24', 'a25', 'a26', 'a27', 'a28', 'a6', 'a7',
    'a8', 'a9', 'a10', 'a29', 'a30', 'a31', 'a32', 'a33', 'a34', 'a35', 'a36',
    'a37', 'a38', 'a39', 'a40', 'a41', 'a42', 'a43', 'a44', 'a45', 'a46',
    'a47', 'a48', 'a49', 'a50', 'a51', 'a52', 'a53', 'a54', 'a55', 'a56',
    'a57', 'a58', 'a59', 'a60', 'a61', 'a62', 'a63', 'a64', 'a65', 'a66',
    'a67', 'a68', 'a69', 'a70', 'a71', 'a72', 'a73', 'a74', 'a203', 'a75',
    'a204', 'a76', 'a77', 'a78', 'a79', 'a81', 'a82', 'a83', 'a84', 'a97',
    'a98', 'a99', 'a100', '', 'a89', 'a90', 'a93', 'a94', 'a91', 'a92', 'a205',
    'a85', 'a206', 'a86', 'a87', 'a88', 'a95', 'a96', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', '', '', 'a101', 'a102', 'a103',
    'a104', 'a106', 'a107', 'a108', 'a112', 'a111', 'a110', 'a109', 'a120',
    'a121', 'a122', 'a123', 'a124', 'a125', 'a126', 'a127', 'a128', 'a129',
    'a130', 'a131', 'a132', 'a133', 'a134', 'a135', 'a136', 'a137', 'a138',
    'a139', 'a140', 'a141', 'a142', 'a143', 'a144', 'a145', 'a146', 'a147',
    'a148', 'a149', 'a150', 'a151', 'a152', 'a153', 'a154', 'a155', 'a156',
    'a157', 'a158', 'a159', 'a160', 'a161', 'a163', 'a164', 'a196', 'a165',
    'a192', 'a166', 'a167', 'a168', 'a169', 'a170', 'a171', 'a172', 'a173',
    'a162', 'a174', 'a175', 'a176', 'a177', 'a178', 'a179', 'a193', 'a180',
    'a199', 'a181', 'a200', 'a182', '', 'a201', 'a183', 'a184', 'a197', 'a185',
    'a194', 'a198', 'a186', 'a195', 'a187', 'a188', 'a189', 'a190', 'a191'];

  function getEncoding(encodingName) {
    switch (encodingName) {
      case 'WinAnsiEncoding':
        return WinAnsiEncoding;
      case 'StandardEncoding':
        return StandardEncoding;
      case 'MacRomanEncoding':
        return MacRomanEncoding;
      case 'SymbolSetEncoding':
        return SymbolSetEncoding;
      case 'ZapfDingbatsEncoding':
        return ZapfDingbatsEncoding;
      case 'ExpertEncoding':
        return ExpertEncoding;
      case 'MacExpertEncoding':
        return MacExpertEncoding;
      default:
        return null;
    }
  }

  exports.WinAnsiEncoding = WinAnsiEncoding;
  exports.StandardEncoding = StandardEncoding;
  exports.MacRomanEncoding = MacRomanEncoding;
  exports.SymbolSetEncoding = SymbolSetEncoding;
  exports.ZapfDingbatsEncoding = ZapfDingbatsEncoding;
  exports.ExpertEncoding = ExpertEncoding;
  exports.getEncoding = getEncoding;
}));



(function (root, factory) {
  {
    factory((root.pdfjsCoreJpg = {}));
  }
}(this, function (exports) {

/*
This code was forked from https://github.com/notmasteryet/jpgjs. The original
version was created by github user notmasteryet

- The JPEG specification can be found in the ITU CCITT Recommendation T.81
 (www.w3.org/Graphics/JPEG/itu-t81.pdf)
- The JFIF specification can be found in the JPEG File Interchange Format
 (www.w3.org/Graphics/JPEG/jfif3.pdf)
- The Adobe Application-Specific JPEG markers in the Supporting the DCT Filters
 in PostScript Level 2, Technical Note #5116
 (partners.adobe.com/public/developer/en/ps/sdk/5116.DCT_Filter.pdf)
*/

var JpegImage = (function jpegImage() {
  var dctZigZag = new Uint8Array([
     0,
     1,  8,
    16,  9,  2,
     3, 10, 17, 24,
    32, 25, 18, 11, 4,
     5, 12, 19, 26, 33, 40,
    48, 41, 34, 27, 20, 13,  6,
     7, 14, 21, 28, 35, 42, 49, 56,
    57, 50, 43, 36, 29, 22, 15,
    23, 30, 37, 44, 51, 58,
    59, 52, 45, 38, 31,
    39, 46, 53, 60,
    61, 54, 47,
    55, 62,
    63
  ]);

  var dctCos1  =  4017;   // cos(pi/16)
  var dctSin1  =   799;   // sin(pi/16)
  var dctCos3  =  3406;   // cos(3*pi/16)
  var dctSin3  =  2276;   // sin(3*pi/16)
  var dctCos6  =  1567;   // cos(6*pi/16)
  var dctSin6  =  3784;   // sin(6*pi/16)
  var dctSqrt2 =  5793;   // sqrt(2)
  var dctSqrt1d2 = 2896;  // sqrt(2) / 2

  function constructor() {
  }

  function buildHuffmanTable(codeLengths, values) {
    var k = 0, code = [], i, j, length = 16;
    while (length > 0 && !codeLengths[length - 1]) {
      length--;
    }
    code.push({children: [], index: 0});
    var p = code[0], q;
    for (i = 0; i < length; i++) {
      for (j = 0; j < codeLengths[i]; j++) {
        p = code.pop();
        p.children[p.index] = values[k];
        while (p.index > 0) {
          p = code.pop();
        }
        p.index++;
        code.push(p);
        while (code.length <= i) {
          code.push(q = {children: [], index: 0});
          p.children[p.index] = q.children;
          p = q;
        }
        k++;
      }
      if (i + 1 < length) {
        // p here points to last code
        code.push(q = {children: [], index: 0});
        p.children[p.index] = q.children;
        p = q;
      }
    }
    return code[0].children;
  }

  function getBlockBufferOffset(component, row, col) {
    return 64 * ((component.blocksPerLine + 1) * row + col);
  }

  function decodeScan(data, offset, frame, components, resetInterval,
                      spectralStart, spectralEnd, successivePrev, successive) {
    var mcusPerLine = frame.mcusPerLine;
    var progressive = frame.progressive;

    var startOffset = offset, bitsData = 0, bitsCount = 0;

    function readBit() {
      if (bitsCount > 0) {
        bitsCount--;
        return (bitsData >> bitsCount) & 1;
      }
      bitsData = data[offset++];
      if (bitsData === 0xFF) {
        var nextByte = data[offset++];
        if (nextByte) {
          throw 'unexpected marker: ' +
            ((bitsData << 8) | nextByte).toString(16);
        }
        // unstuff 0
      }
      bitsCount = 7;
      return bitsData >>> 7;
    }

    function decodeHuffman(tree) {
      var node = tree;
      while (true) {
        node = node[readBit()];
        if (typeof node === 'number') {
          return node;
        }
        if (typeof node !== 'object') {
          throw 'invalid huffman sequence';
        }
      }
    }

    function receive(length) {
      var n = 0;
      while (length > 0) {
        n = (n << 1) | readBit();
        length--;
      }
      return n;
    }

    function receiveAndExtend(length) {
      if (length === 1) {
        return readBit() === 1 ? 1 : -1;
      }
      var n = receive(length);
      if (n >= 1 << (length - 1)) {
        return n;
      }
      return n + (-1 << length) + 1;
    }

    function decodeBaseline(component, offset) {
      var t = decodeHuffman(component.huffmanTableDC);
      var diff = t === 0 ? 0 : receiveAndExtend(t);
      component.blockData[offset] = (component.pred += diff);
      var k = 1;
      while (k < 64) {
        var rs = decodeHuffman(component.huffmanTableAC);
        var s = rs & 15, r = rs >> 4;
        if (s === 0) {
          if (r < 15) {
            break;
          }
          k += 16;
          continue;
        }
        k += r;
        var z = dctZigZag[k];
        component.blockData[offset + z] = receiveAndExtend(s);
        k++;
      }
    }

    function decodeDCFirst(component, offset) {
      var t = decodeHuffman(component.huffmanTableDC);
      var diff = t === 0 ? 0 : (receiveAndExtend(t) << successive);
      component.blockData[offset] = (component.pred += diff);
    }

    function decodeDCSuccessive(component, offset) {
      component.blockData[offset] |= readBit() << successive;
    }

    var eobrun = 0;
    function decodeACFirst(component, offset) {
      if (eobrun > 0) {
        eobrun--;
        return;
      }
      var k = spectralStart, e = spectralEnd;
      while (k <= e) {
        var rs = decodeHuffman(component.huffmanTableAC);
        var s = rs & 15, r = rs >> 4;
        if (s === 0) {
          if (r < 15) {
            eobrun = receive(r) + (1 << r) - 1;
            break;
          }
          k += 16;
          continue;
        }
        k += r;
        var z = dctZigZag[k];
        component.blockData[offset + z] =
          receiveAndExtend(s) * (1 << successive);
        k++;
      }
    }

    var successiveACState = 0, successiveACNextValue;
    function decodeACSuccessive(component, offset) {
      var k = spectralStart;
      var e = spectralEnd;
      var r = 0;
      var s;
      var rs;
      while (k <= e) {
        var z = dctZigZag[k];
        switch (successiveACState) {
        case 0: // initial state
          rs = decodeHuffman(component.huffmanTableAC);
          s = rs & 15;
          r = rs >> 4;
          if (s === 0) {
            if (r < 15) {
              eobrun = receive(r) + (1 << r);
              successiveACState = 4;
            } else {
              r = 16;
              successiveACState = 1;
            }
          } else {
            if (s !== 1) {
              throw 'invalid ACn encoding';
            }
            successiveACNextValue = receiveAndExtend(s);
            successiveACState = r ? 2 : 3;
          }
          continue;
        case 1: // skipping r zero items
        case 2:
          if (component.blockData[offset + z]) {
            component.blockData[offset + z] += (readBit() << successive);
          } else {
            r--;
            if (r === 0) {
              successiveACState = successiveACState === 2 ? 3 : 0;
            }
          }
          break;
        case 3: // set value for a zero item
          if (component.blockData[offset + z]) {
            component.blockData[offset + z] += (readBit() << successive);
          } else {
            component.blockData[offset + z] =
              successiveACNextValue << successive;
            successiveACState = 0;
          }
          break;
        case 4: // eob
          if (component.blockData[offset + z]) {
            component.blockData[offset + z] += (readBit() << successive);
          }
          break;
        }
        k++;
      }
      if (successiveACState === 4) {
        eobrun--;
        if (eobrun === 0) {
          successiveACState = 0;
        }
      }
    }

    function decodeMcu(component, decode, mcu, row, col) {
      var mcuRow = (mcu / mcusPerLine) | 0;
      var mcuCol = mcu % mcusPerLine;
      var blockRow = mcuRow * component.v + row;
      var blockCol = mcuCol * component.h + col;
      var offset = getBlockBufferOffset(component, blockRow, blockCol);
      decode(component, offset);
    }

    function decodeBlock(component, decode, mcu) {
      var blockRow = (mcu / component.blocksPerLine) | 0;
      var blockCol = mcu % component.blocksPerLine;
      var offset = getBlockBufferOffset(component, blockRow, blockCol);
      decode(component, offset);
    }

    var componentsLength = components.length;
    var component, i, j, k, n;
    var decodeFn;
    if (progressive) {
      if (spectralStart === 0) {
        decodeFn = successivePrev === 0 ? decodeDCFirst : decodeDCSuccessive;
      } else {
        decodeFn = successivePrev === 0 ? decodeACFirst : decodeACSuccessive;
      }
    } else {
      decodeFn = decodeBaseline;
    }

    var mcu = 0, marker;
    var mcuExpected;
    if (componentsLength === 1) {
      mcuExpected = components[0].blocksPerLine * components[0].blocksPerColumn;
    } else {
      mcuExpected = mcusPerLine * frame.mcusPerColumn;
    }
    if (!resetInterval) {
      resetInterval = mcuExpected;
    }

    var h, v;
    while (mcu < mcuExpected) {
      // reset interval stuff
      for (i = 0; i < componentsLength; i++) {
        components[i].pred = 0;
      }
      eobrun = 0;

      if (componentsLength === 1) {
        component = components[0];
        for (n = 0; n < resetInterval; n++) {
          decodeBlock(component, decodeFn, mcu);
          mcu++;
        }
      } else {
        for (n = 0; n < resetInterval; n++) {
          for (i = 0; i < componentsLength; i++) {
            component = components[i];
            h = component.h;
            v = component.v;
            for (j = 0; j < v; j++) {
              for (k = 0; k < h; k++) {
                decodeMcu(component, decodeFn, mcu, j, k);
              }
            }
          }
          mcu++;
        }
      }

      // find marker
      bitsCount = 0;
      marker = (data[offset] << 8) | data[offset + 1];
      if (marker <= 0xFF00) {
        throw 'marker was not found';
      }

      if (marker >= 0xFFD0 && marker <= 0xFFD7) { // RSTx
        offset += 2;
      } else {
        break;
      }
    }

    return offset - startOffset;
  }

  // A port of poppler's IDCT method which in turn is taken from:
  //   Christoph Loeffler, Adriaan Ligtenberg, George S. Moschytz,
  //   'Practical Fast 1-D DCT Algorithms with 11 Multiplications',
  //   IEEE Intl. Conf. on Acoustics, Speech & Signal Processing, 1989,
  //   988-991.
  function quantizeAndInverse(component, blockBufferOffset, p) {
    var qt = component.quantizationTable, blockData = component.blockData;
    var v0, v1, v2, v3, v4, v5, v6, v7;
    var p0, p1, p2, p3, p4, p5, p6, p7;
    var t;

    // inverse DCT on rows
    for (var row = 0; row < 64; row += 8) {
      // gather block data
      p0 = blockData[blockBufferOffset + row];
      p1 = blockData[blockBufferOffset + row + 1];
      p2 = blockData[blockBufferOffset + row + 2];
      p3 = blockData[blockBufferOffset + row + 3];
      p4 = blockData[blockBufferOffset + row + 4];
      p5 = blockData[blockBufferOffset + row + 5];
      p6 = blockData[blockBufferOffset + row + 6];
      p7 = blockData[blockBufferOffset + row + 7];

      // dequant p0
      p0 *= qt[row];

      // check for all-zero AC coefficients
      if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
        t = (dctSqrt2 * p0 + 512) >> 10;
        p[row] = t;
        p[row + 1] = t;
        p[row + 2] = t;
        p[row + 3] = t;
        p[row + 4] = t;
        p[row + 5] = t;
        p[row + 6] = t;
        p[row + 7] = t;
        continue;
      }
      // dequant p1 ... p7
      p1 *= qt[row + 1];
      p2 *= qt[row + 2];
      p3 *= qt[row + 3];
      p4 *= qt[row + 4];
      p5 *= qt[row + 5];
      p6 *= qt[row + 6];
      p7 *= qt[row + 7];

      // stage 4
      v0 = (dctSqrt2 * p0 + 128) >> 8;
      v1 = (dctSqrt2 * p4 + 128) >> 8;
      v2 = p2;
      v3 = p6;
      v4 = (dctSqrt1d2 * (p1 - p7) + 128) >> 8;
      v7 = (dctSqrt1d2 * (p1 + p7) + 128) >> 8;
      v5 = p3 << 4;
      v6 = p5 << 4;

      // stage 3
      v0 = (v0 + v1 + 1) >> 1;
      v1 = v0 - v1;
      t  = (v2 * dctSin6 + v3 * dctCos6 + 128) >> 8;
      v2 = (v2 * dctCos6 - v3 * dctSin6 + 128) >> 8;
      v3 = t;
      v4 = (v4 + v6 + 1) >> 1;
      v6 = v4 - v6;
      v7 = (v7 + v5 + 1) >> 1;
      v5 = v7 - v5;

      // stage 2
      v0 = (v0 + v3 + 1) >> 1;
      v3 = v0 - v3;
      v1 = (v1 + v2 + 1) >> 1;
      v2 = v1 - v2;
      t  = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
      v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
      v7 = t;
      t  = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
      v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
      v6 = t;

      // stage 1
      p[row] = v0 + v7;
      p[row + 7] = v0 - v7;
      p[row + 1] = v1 + v6;
      p[row + 6] = v1 - v6;
      p[row + 2] = v2 + v5;
      p[row + 5] = v2 - v5;
      p[row + 3] = v3 + v4;
      p[row + 4] = v3 - v4;
    }

    // inverse DCT on columns
    for (var col = 0; col < 8; ++col) {
      p0 = p[col];
      p1 = p[col +  8];
      p2 = p[col + 16];
      p3 = p[col + 24];
      p4 = p[col + 32];
      p5 = p[col + 40];
      p6 = p[col + 48];
      p7 = p[col + 56];

      // check for all-zero AC coefficients
      if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
        t = (dctSqrt2 * p0 + 8192) >> 14;
        // convert to 8 bit
        t = (t < -2040) ? 0 : (t >= 2024) ? 255 : (t + 2056) >> 4;
        blockData[blockBufferOffset + col] = t;
        blockData[blockBufferOffset + col +  8] = t;
        blockData[blockBufferOffset + col + 16] = t;
        blockData[blockBufferOffset + col + 24] = t;
        blockData[blockBufferOffset + col + 32] = t;
        blockData[blockBufferOffset + col + 40] = t;
        blockData[blockBufferOffset + col + 48] = t;
        blockData[blockBufferOffset + col + 56] = t;
        continue;
      }

      // stage 4
      v0 = (dctSqrt2 * p0 + 2048) >> 12;
      v1 = (dctSqrt2 * p4 + 2048) >> 12;
      v2 = p2;
      v3 = p6;
      v4 = (dctSqrt1d2 * (p1 - p7) + 2048) >> 12;
      v7 = (dctSqrt1d2 * (p1 + p7) + 2048) >> 12;
      v5 = p3;
      v6 = p5;

      // stage 3
      // Shift v0 by 128.5 << 5 here, so we don't need to shift p0...p7 when
      // converting to UInt8 range later.
      v0 = ((v0 + v1 + 1) >> 1) + 4112;
      v1 = v0 - v1;
      t  = (v2 * dctSin6 + v3 * dctCos6 + 2048) >> 12;
      v2 = (v2 * dctCos6 - v3 * dctSin6 + 2048) >> 12;
      v3 = t;
      v4 = (v4 + v6 + 1) >> 1;
      v6 = v4 - v6;
      v7 = (v7 + v5 + 1) >> 1;
      v5 = v7 - v5;

      // stage 2
      v0 = (v0 + v3 + 1) >> 1;
      v3 = v0 - v3;
      v1 = (v1 + v2 + 1) >> 1;
      v2 = v1 - v2;
      t  = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
      v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
      v7 = t;
      t  = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
      v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
      v6 = t;

      // stage 1
      p0 = v0 + v7;
      p7 = v0 - v7;
      p1 = v1 + v6;
      p6 = v1 - v6;
      p2 = v2 + v5;
      p5 = v2 - v5;
      p3 = v3 + v4;
      p4 = v3 - v4;

      // convert to 8-bit integers
      p0 = (p0 < 16) ? 0 : (p0 >= 4080) ? 255 : p0 >> 4;
      p1 = (p1 < 16) ? 0 : (p1 >= 4080) ? 255 : p1 >> 4;
      p2 = (p2 < 16) ? 0 : (p2 >= 4080) ? 255 : p2 >> 4;
      p3 = (p3 < 16) ? 0 : (p3 >= 4080) ? 255 : p3 >> 4;
      p4 = (p4 < 16) ? 0 : (p4 >= 4080) ? 255 : p4 >> 4;
      p5 = (p5 < 16) ? 0 : (p5 >= 4080) ? 255 : p5 >> 4;
      p6 = (p6 < 16) ? 0 : (p6 >= 4080) ? 255 : p6 >> 4;
      p7 = (p7 < 16) ? 0 : (p7 >= 4080) ? 255 : p7 >> 4;

      // store block data
      blockData[blockBufferOffset + col] = p0;
      blockData[blockBufferOffset + col +  8] = p1;
      blockData[blockBufferOffset + col + 16] = p2;
      blockData[blockBufferOffset + col + 24] = p3;
      blockData[blockBufferOffset + col + 32] = p4;
      blockData[blockBufferOffset + col + 40] = p5;
      blockData[blockBufferOffset + col + 48] = p6;
      blockData[blockBufferOffset + col + 56] = p7;
    }
  }

  function buildComponentData(frame, component) {
    var blocksPerLine = component.blocksPerLine;
    var blocksPerColumn = component.blocksPerColumn;
    var computationBuffer = new Int16Array(64);

    for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
      for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
        var offset = getBlockBufferOffset(component, blockRow, blockCol);
        quantizeAndInverse(component, offset, computationBuffer);
      }
    }
    return component.blockData;
  }

  function clamp0to255(a) {
    return a <= 0 ? 0 : a >= 255 ? 255 : a;
  }

  constructor.prototype = {
    parse: function parse(data) {

      function readUint16() {
        var value = (data[offset] << 8) | data[offset + 1];
        offset += 2;
        return value;
      }

      function readDataBlock() {
        var length = readUint16();
        var array = data.subarray(offset, offset + length - 2);
        offset += array.length;
        return array;
      }

      function prepareComponents(frame) {
        var mcusPerLine = Math.ceil(frame.samplesPerLine / 8 / frame.maxH);
        var mcusPerColumn = Math.ceil(frame.scanLines / 8 / frame.maxV);
        for (var i = 0; i < frame.components.length; i++) {
          component = frame.components[i];
          var blocksPerLine = Math.ceil(Math.ceil(frame.samplesPerLine / 8) *
                                        component.h / frame.maxH);
          var blocksPerColumn = Math.ceil(Math.ceil(frame.scanLines  / 8) *
                                          component.v / frame.maxV);
          var blocksPerLineForMcu = mcusPerLine * component.h;
          var blocksPerColumnForMcu = mcusPerColumn * component.v;

          var blocksBufferSize = 64 * blocksPerColumnForMcu *
                                      (blocksPerLineForMcu + 1);
          component.blockData = new Int16Array(blocksBufferSize);
          component.blocksPerLine = blocksPerLine;
          component.blocksPerColumn = blocksPerColumn;
        }
        frame.mcusPerLine = mcusPerLine;
        frame.mcusPerColumn = mcusPerColumn;
      }

      var offset = 0;
      var jfif = null;
      var adobe = null;
      var frame, resetInterval;
      var quantizationTables = [];
      var huffmanTablesAC = [], huffmanTablesDC = [];
      var fileMarker = readUint16();
      if (fileMarker !== 0xFFD8) { // SOI (Start of Image)
        throw 'SOI not found';
      }

      fileMarker = readUint16();
      while (fileMarker !== 0xFFD9) { // EOI (End of image)
        var i, j, l;
        switch(fileMarker) {
          case 0xFFE0: // APP0 (Application Specific)
          case 0xFFE1: // APP1
          case 0xFFE2: // APP2
          case 0xFFE3: // APP3
          case 0xFFE4: // APP4
          case 0xFFE5: // APP5
          case 0xFFE6: // APP6
          case 0xFFE7: // APP7
          case 0xFFE8: // APP8
          case 0xFFE9: // APP9
          case 0xFFEA: // APP10
          case 0xFFEB: // APP11
          case 0xFFEC: // APP12
          case 0xFFED: // APP13
          case 0xFFEE: // APP14
          case 0xFFEF: // APP15
          case 0xFFFE: // COM (Comment)
            var appData = readDataBlock();

            if (fileMarker === 0xFFE0) {
              if (appData[0] === 0x4A && appData[1] === 0x46 &&
                  appData[2] === 0x49 && appData[3] === 0x46 &&
                  appData[4] === 0) { // 'JFIF\x00'
                jfif = {
                  version: { major: appData[5], minor: appData[6] },
                  densityUnits: appData[7],
                  xDensity: (appData[8] << 8) | appData[9],
                  yDensity: (appData[10] << 8) | appData[11],
                  thumbWidth: appData[12],
                  thumbHeight: appData[13],
                  thumbData: appData.subarray(14, 14 +
                                              3 * appData[12] * appData[13])
                };
              }
            }
            // TODO APP1 - Exif
            if (fileMarker === 0xFFEE) {
              if (appData[0] === 0x41 && appData[1] === 0x64 &&
                  appData[2] === 0x6F && appData[3] === 0x62 &&
                  appData[4] === 0x65) { // 'Adobe'
                adobe = {
                  version: (appData[5] << 8) | appData[6],
                  flags0: (appData[7] << 8) | appData[8],
                  flags1: (appData[9] << 8) | appData[10],
                  transformCode: appData[11]
                };
              }
            }
            break;

          case 0xFFDB: // DQT (Define Quantization Tables)
            var quantizationTablesLength = readUint16();
            var quantizationTablesEnd = quantizationTablesLength + offset - 2;
            var z;
            while (offset < quantizationTablesEnd) {
              var quantizationTableSpec = data[offset++];
              var tableData = new Uint16Array(64);
              if ((quantizationTableSpec >> 4) === 0) { // 8 bit values
                for (j = 0; j < 64; j++) {
                  z = dctZigZag[j];
                  tableData[z] = data[offset++];
                }
              } else if ((quantizationTableSpec >> 4) === 1) { //16 bit
                for (j = 0; j < 64; j++) {
                  z = dctZigZag[j];
                  tableData[z] = readUint16();
                }
              } else {
                throw 'DQT: invalid table spec';
              }
              quantizationTables[quantizationTableSpec & 15] = tableData;
            }
            break;

          case 0xFFC0: // SOF0 (Start of Frame, Baseline DCT)
          case 0xFFC1: // SOF1 (Start of Frame, Extended DCT)
          case 0xFFC2: // SOF2 (Start of Frame, Progressive DCT)
            if (frame) {
              throw 'Only single frame JPEGs supported';
            }
            readUint16(); // skip data length
            frame = {};
            frame.extended = (fileMarker === 0xFFC1);
            frame.progressive = (fileMarker === 0xFFC2);
            frame.precision = data[offset++];
            frame.scanLines = readUint16();
            frame.samplesPerLine = readUint16();
            frame.components = [];
            frame.componentIds = {};
            var componentsCount = data[offset++], componentId;
            var maxH = 0, maxV = 0;
            for (i = 0; i < componentsCount; i++) {
              componentId = data[offset];
              var h = data[offset + 1] >> 4;
              var v = data[offset + 1] & 15;
              if (maxH < h) {
                maxH = h;
              }
              if (maxV < v) {
                maxV = v;
              }
              var qId = data[offset + 2];
              l = frame.components.push({
                h: h,
                v: v,
                quantizationTable: quantizationTables[qId]
              });
              frame.componentIds[componentId] = l - 1;
              offset += 3;
            }
            frame.maxH = maxH;
            frame.maxV = maxV;
            prepareComponents(frame);
            break;

          case 0xFFC4: // DHT (Define Huffman Tables)
            var huffmanLength = readUint16();
            for (i = 2; i < huffmanLength;) {
              var huffmanTableSpec = data[offset++];
              var codeLengths = new Uint8Array(16);
              var codeLengthSum = 0;
              for (j = 0; j < 16; j++, offset++) {
                codeLengthSum += (codeLengths[j] = data[offset]);
              }
              var huffmanValues = new Uint8Array(codeLengthSum);
              for (j = 0; j < codeLengthSum; j++, offset++) {
                huffmanValues[j] = data[offset];
              }
              i += 17 + codeLengthSum;

              ((huffmanTableSpec >> 4) === 0 ?
                huffmanTablesDC : huffmanTablesAC)[huffmanTableSpec & 15] =
                buildHuffmanTable(codeLengths, huffmanValues);
            }
            break;

          case 0xFFDD: // DRI (Define Restart Interval)
            readUint16(); // skip data length
            resetInterval = readUint16();
            break;

          case 0xFFDA: // SOS (Start of Scan)
            var scanLength = readUint16();
            var selectorsCount = data[offset++];
            var components = [], component;
            for (i = 0; i < selectorsCount; i++) {
              var componentIndex = frame.componentIds[data[offset++]];
              component = frame.components[componentIndex];
              var tableSpec = data[offset++];
              component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
              component.huffmanTableAC = huffmanTablesAC[tableSpec & 15];
              components.push(component);
            }
            var spectralStart = data[offset++];
            var spectralEnd = data[offset++];
            var successiveApproximation = data[offset++];
            var processed = decodeScan(data, offset,
              frame, components, resetInterval,
              spectralStart, spectralEnd,
              successiveApproximation >> 4, successiveApproximation & 15);
            offset += processed;
            break;

          case 0xFFFF: // Fill bytes
            if (data[offset] !== 0xFF) { // Avoid skipping a valid marker.
              offset--;
            }
            break;

          default:
            if (data[offset - 3] === 0xFF &&
                data[offset - 2] >= 0xC0 && data[offset - 2] <= 0xFE) {
              // could be incorrect encoding -- last 0xFF byte of the previous
              // block was eaten by the encoder
              offset -= 3;
              break;
            }
            throw 'unknown JPEG marker ' + fileMarker.toString(16);
        }
        fileMarker = readUint16();
      }

      this.width = frame.samplesPerLine;
      this.height = frame.scanLines;
      this.jfif = jfif;
      this.adobe = adobe;
      this.components = [];
      for (i = 0; i < frame.components.length; i++) {
        component = frame.components[i];
        this.components.push({
          output: buildComponentData(frame, component),
          scaleX: component.h / frame.maxH,
          scaleY: component.v / frame.maxV,
          blocksPerLine: component.blocksPerLine,
          blocksPerColumn: component.blocksPerColumn
        });
      }
      this.numComponents = this.components.length;
    },

    _getLinearizedBlockData: function getLinearizedBlockData(width, height) {
      var scaleX = this.width / width, scaleY = this.height / height;

      var component, componentScaleX, componentScaleY, blocksPerScanline;
      var x, y, i, j, k;
      var index;
      var offset = 0;
      var output;
      var numComponents = this.components.length;
      var dataLength = width * height * numComponents;
      var data = new Uint8Array(dataLength);
      var xScaleBlockOffset = new Uint32Array(width);
      var mask3LSB = 0xfffffff8; // used to clear the 3 LSBs

      for (i = 0; i < numComponents; i++) {
        component = this.components[i];
        componentScaleX = component.scaleX * scaleX;
        componentScaleY = component.scaleY * scaleY;
        offset = i;
        output = component.output;
        blocksPerScanline = (component.blocksPerLine + 1) << 3;
        // precalculate the xScaleBlockOffset
        for (x = 0; x < width; x++) {
          j = 0 | (x * componentScaleX);
          xScaleBlockOffset[x] = ((j & mask3LSB) << 3) | (j & 7);
        }
        // linearize the blocks of the component
        for (y = 0; y < height; y++) {
          j = 0 | (y * componentScaleY);
          index = blocksPerScanline * (j & mask3LSB) | ((j & 7) << 3);
          for (x = 0; x < width; x++) {
            data[offset] = output[index + xScaleBlockOffset[x]];
            offset += numComponents;
          }
        }
      }

      // decodeTransform contains pairs of multiplier (-256..256) and additive
      var transform = this.decodeTransform;
      if (transform) {
        for (i = 0; i < dataLength;) {
          for (j = 0, k = 0; j < numComponents; j++, i++, k += 2) {
            data[i] = ((data[i] * transform[k]) >> 8) + transform[k + 1];
          }
        }
      }
      return data;
    },

    _isColorConversionNeeded: function isColorConversionNeeded() {
      if (this.adobe && this.adobe.transformCode) {
        // The adobe transform marker overrides any previous setting
        return true;
      } else if (this.numComponents === 3) {
        return true;
      } else {
        return false;
      }
    },

    _convertYccToRgb: function convertYccToRgb(data) {
      var Y, Cb, Cr;
      for (var i = 0, length = data.length; i < length; i += 3) {
        Y  = data[i    ];
        Cb = data[i + 1];
        Cr = data[i + 2];
        data[i    ] = clamp0to255(Y - 179.456 + 1.402 * Cr);
        data[i + 1] = clamp0to255(Y + 135.459 - 0.344 * Cb - 0.714 * Cr);
        data[i + 2] = clamp0to255(Y - 226.816 + 1.772 * Cb);
      }
      return data;
    },

    _convertYcckToRgb: function convertYcckToRgb(data) {
      var Y, Cb, Cr, k;
      var offset = 0;
      for (var i = 0, length = data.length; i < length; i += 4) {
        Y  = data[i];
        Cb = data[i + 1];
        Cr = data[i + 2];
        k = data[i + 3];

        var r = -122.67195406894 +
          Cb * (-6.60635669420364e-5 * Cb + 0.000437130475926232 * Cr -
                5.4080610064599e-5 * Y + 0.00048449797120281 * k -
                0.154362151871126) +
          Cr * (-0.000957964378445773 * Cr + 0.000817076911346625 * Y -
                0.00477271405408747 * k + 1.53380253221734) +
          Y * (0.000961250184130688 * Y - 0.00266257332283933 * k +
               0.48357088451265) +
          k * (-0.000336197177618394 * k + 0.484791561490776);

        var g = 107.268039397724 +
          Cb * (2.19927104525741e-5 * Cb - 0.000640992018297945 * Cr +
                0.000659397001245577 * Y + 0.000426105652938837 * k -
                0.176491792462875) +
          Cr * (-0.000778269941513683 * Cr + 0.00130872261408275 * Y +
                0.000770482631801132 * k - 0.151051492775562) +
          Y * (0.00126935368114843 * Y - 0.00265090189010898 * k +
               0.25802910206845) +
          k * (-0.000318913117588328 * k - 0.213742400323665);

        var b = -20.810012546947 +
          Cb * (-0.000570115196973677 * Cb - 2.63409051004589e-5 * Cr +
                0.0020741088115012 * Y - 0.00288260236853442 * k +
                0.814272968359295) +
          Cr * (-1.53496057440975e-5 * Cr - 0.000132689043961446 * Y +
                0.000560833691242812 * k - 0.195152027534049) +
          Y * (0.00174418132927582 * Y - 0.00255243321439347 * k +
               0.116935020465145) +
          k * (-0.000343531996510555 * k + 0.24165260232407);

        data[offset++] = clamp0to255(r);
        data[offset++] = clamp0to255(g);
        data[offset++] = clamp0to255(b);
      }
      return data;
    },

    _convertYcckToCmyk: function convertYcckToCmyk(data) {
      var Y, Cb, Cr;
      for (var i = 0, length = data.length; i < length; i += 4) {
        Y  = data[i];
        Cb = data[i + 1];
        Cr = data[i + 2];
        data[i    ] = clamp0to255(434.456 - Y - 1.402 * Cr);
        data[i + 1] = clamp0to255(119.541 - Y + 0.344 * Cb + 0.714 * Cr);
        data[i + 2] = clamp0to255(481.816 - Y - 1.772 * Cb);
        // K in data[i + 3] is unchanged
      }
      return data;
    },

    _convertCmykToRgb: function convertCmykToRgb(data) {
      var c, m, y, k;
      var offset = 0;
      var min = -255 * 255 * 255;
      var scale = 1 / 255 / 255;
      for (var i = 0, length = data.length; i < length; i += 4) {
        c = data[i];
        m = data[i + 1];
        y = data[i + 2];
        k = data[i + 3];

        var r =
          c * (-4.387332384609988 * c + 54.48615194189176 * m +
               18.82290502165302 * y + 212.25662451639585 * k -
               72734.4411664936) +
          m * (1.7149763477362134 * m - 5.6096736904047315 * y -
               17.873870861415444 * k - 1401.7366389350734) +
          y * (-2.5217340131683033 * y - 21.248923337353073 * k +
               4465.541406466231) -
          k * (21.86122147463605 * k + 48317.86113160301);
        var g =
          c * (8.841041422036149 * c + 60.118027045597366 * m +
               6.871425592049007 * y + 31.159100130055922 * k -
               20220.756542821975) +
          m * (-15.310361306967817 * m + 17.575251261109482 * y +
               131.35250912493976 * k - 48691.05921601825) +
          y * (4.444339102852739 * y + 9.8632861493405 * k -
               6341.191035517494) -
          k * (20.737325471181034 * k + 47890.15695978492);
        var b =
          c * (0.8842522430003296 * c + 8.078677503112928 * m +
               30.89978309703729 * y - 0.23883238689178934 * k -
               3616.812083916688) +
          m * (10.49593273432072 * m + 63.02378494754052 * y +
               50.606957656360734 * k - 28620.90484698408) +
          y * (0.03296041114873217 * y + 115.60384449646641 * k -
               49363.43385999684) -
          k * (22.33816807309886 * k + 45932.16563550634);

        data[offset++] = r >= 0 ? 255 : r <= min ? 0 : 255 + r * scale | 0;
        data[offset++] = g >= 0 ? 255 : g <= min ? 0 : 255 + g * scale | 0;
        data[offset++] = b >= 0 ? 255 : b <= min ? 0 : 255 + b * scale | 0;
      }
      return data;
    },

    getData: function getData(width, height, forceRGBoutput) {
      if (this.numComponents > 4) {
        throw 'Unsupported color mode';
      }
      // type of data: Uint8Array(width * height * numComponents)
      var data = this._getLinearizedBlockData(width, height);

      if (this.numComponents === 1 && forceRGBoutput) {
        var dataLength = data.length;
        var rgbData = new Uint8Array(dataLength * 3);
        var offset = 0;
        for (var i = 0; i < dataLength; i++) {
          var grayColor = data[i];
          rgbData[offset++] = grayColor;
          rgbData[offset++] = grayColor;
          rgbData[offset++] = grayColor;
        }
        return rgbData;
      } else if (this.numComponents === 3) {
        return this._convertYccToRgb(data);
      } else if (this.numComponents === 4) {
        if (this._isColorConversionNeeded()) {
          if (forceRGBoutput) {
            return this._convertYcckToRgb(data);
          } else {
            return this._convertYcckToCmyk(data);
          }
        } else if (forceRGBoutput) {
          return this._convertCmykToRgb(data);
        }
      }
      return data;
    }
  };

  return constructor;
})();

exports.JpegImage = JpegImage;
}));


(function (root, factory) {
  {
    factory((root.pdfjsSharedUtil = {}));
  }
}(this, function (exports) {

var globalScope = (typeof window !== 'undefined') ? window :
                  (typeof global !== 'undefined') ? global :
                  (typeof self !== 'undefined') ? self : this;

var FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];

var TextRenderingMode = {
  FILL: 0,
  STROKE: 1,
  FILL_STROKE: 2,
  INVISIBLE: 3,
  FILL_ADD_TO_PATH: 4,
  STROKE_ADD_TO_PATH: 5,
  FILL_STROKE_ADD_TO_PATH: 6,
  ADD_TO_PATH: 7,
  FILL_STROKE_MASK: 3,
  ADD_TO_PATH_FLAG: 4
};

var ImageKind = {
  GRAYSCALE_1BPP: 1,
  RGB_24BPP: 2,
  RGBA_32BPP: 3
};

var AnnotationType = {
  TEXT: 1,
  LINK: 2,
  FREETEXT: 3,
  LINE: 4,
  SQUARE: 5,
  CIRCLE: 6,
  POLYGON: 7,
  POLYLINE: 8,
  HIGHLIGHT: 9,
  UNDERLINE: 10,
  SQUIGGLY: 11,
  STRIKEOUT: 12,
  STAMP: 13,
  CARET: 14,
  INK: 15,
  POPUP: 16,
  FILEATTACHMENT: 17,
  SOUND: 18,
  MOVIE: 19,
  WIDGET: 20,
  SCREEN: 21,
  PRINTERMARK: 22,
  TRAPNET: 23,
  WATERMARK: 24,
  THREED: 25,
  REDACT: 26
};

var AnnotationFlag = {
  INVISIBLE: 0x01,
  HIDDEN: 0x02,
  PRINT: 0x04,
  NOZOOM: 0x08,
  NOROTATE: 0x10,
  NOVIEW: 0x20,
  READONLY: 0x40,
  LOCKED: 0x80,
  TOGGLENOVIEW: 0x100,
  LOCKEDCONTENTS: 0x200
};

var AnnotationBorderStyleType = {
  SOLID: 1,
  DASHED: 2,
  BEVELED: 3,
  INSET: 4,
  UNDERLINE: 5
};

var StreamType = {
  UNKNOWN: 0,
  FLATE: 1,
  LZW: 2,
  DCT: 3,
  JPX: 4,
  JBIG: 5,
  A85: 6,
  AHX: 7,
  CCF: 8,
  RL: 9
};

var FontType = {
  UNKNOWN: 0,
  TYPE1: 1,
  TYPE1C: 2,
  CIDFONTTYPE0: 3,
  CIDFONTTYPE0C: 4,
  TRUETYPE: 5,
  CIDFONTTYPE2: 6,
  TYPE3: 7,
  OPENTYPE: 8,
  TYPE0: 9,
  MMTYPE1: 10
};

var VERBOSITY_LEVELS = {
  errors: 0,
  warnings: 1,
  infos: 5
};

// All the possible operations for an operator list.
var OPS = {
  // Intentionally start from 1 so it is easy to spot bad operators that will be
  // 0's.
  dependency: 1,
  setLineWidth: 2,
  setLineCap: 3,
  setLineJoin: 4,
  setMiterLimit: 5,
  setDash: 6,
  setRenderingIntent: 7,
  setFlatness: 8,
  setGState: 9,
  save: 10,
  restore: 11,
  transform: 12,
  moveTo: 13,
  lineTo: 14,
  curveTo: 15,
  curveTo2: 16,
  curveTo3: 17,
  closePath: 18,
  rectangle: 19,
  stroke: 20,
  closeStroke: 21,
  fill: 22,
  eoFill: 23,
  fillStroke: 24,
  eoFillStroke: 25,
  closeFillStroke: 26,
  closeEOFillStroke: 27,
  endPath: 28,
  clip: 29,
  eoClip: 30,
  beginText: 31,
  endText: 32,
  setCharSpacing: 33,
  setWordSpacing: 34,
  setHScale: 35,
  setLeading: 36,
  setFont: 37,
  setTextRenderingMode: 38,
  setTextRise: 39,
  moveText: 40,
  setLeadingMoveText: 41,
  setTextMatrix: 42,
  nextLine: 43,
  showText: 44,
  showSpacedText: 45,
  nextLineShowText: 46,
  nextLineSetSpacingShowText: 47,
  setCharWidth: 48,
  setCharWidthAndBounds: 49,
  setStrokeColorSpace: 50,
  setFillColorSpace: 51,
  setStrokeColor: 52,
  setStrokeColorN: 53,
  setFillColor: 54,
  setFillColorN: 55,
  setStrokeGray: 56,
  setFillGray: 57,
  setStrokeRGBColor: 58,
  setFillRGBColor: 59,
  setStrokeCMYKColor: 60,
  setFillCMYKColor: 61,
  shadingFill: 62,
  beginInlineImage: 63,
  beginImageData: 64,
  endInlineImage: 65,
  paintXObject: 66,
  markPoint: 67,
  markPointProps: 68,
  beginMarkedContent: 69,
  beginMarkedContentProps: 70,
  endMarkedContent: 71,
  beginCompat: 72,
  endCompat: 73,
  paintFormXObjectBegin: 74,
  paintFormXObjectEnd: 75,
  beginGroup: 76,
  endGroup: 77,
  beginAnnotations: 78,
  endAnnotations: 79,
  beginAnnotation: 80,
  endAnnotation: 81,
  paintJpegXObject: 82,
  paintImageMaskXObject: 83,
  paintImageMaskXObjectGroup: 84,
  paintImageXObject: 85,
  paintInlineImageXObject: 86,
  paintInlineImageXObjectGroup: 87,
  paintImageXObjectRepeat: 88,
  paintImageMaskXObjectRepeat: 89,
  paintSolidColorImageMask: 90,
  constructPath: 91
};

var verbosity = VERBOSITY_LEVELS.warnings;

function setVerbosityLevel(level) {
  verbosity = level;
}

function getVerbosityLevel() {
  return verbosity;
}

// A notice for devs. These are good for things that are helpful to devs, such
// as warning that Workers were disabled, which is important to devs but not
// end users.
function info(msg) {
  if (verbosity >= VERBOSITY_LEVELS.infos) {
    console.log('Info: ' + msg);
  }
}

// Non-fatal warnings.
function warn(msg) {
  if (verbosity >= VERBOSITY_LEVELS.warnings) {
    console.log('Warning: ' + msg);
  }
}

// Deprecated API function -- display regardless of the PDFJS.verbosity setting.
function deprecated(details) {
  console.log('Deprecated API usage: ' + details);
}

// Fatal errors that should trigger the fallback UI and halt execution by
// throwing an exception.
function error(msg) {
  if (verbosity >= VERBOSITY_LEVELS.errors) {
    console.log('Error: ' + msg);
    console.log(backtrace());
  }
  throw new Error(msg);
}

function backtrace() {
  try {
    throw new Error();
  } catch (e) {
    return e.stack ? e.stack.split('\n').slice(2).join('\n') : '';
  }
}

function assert(cond, msg) {
  if (!cond) {
    error(msg);
  }
}

var UNSUPPORTED_FEATURES = {
  unknown: 'unknown',
  forms: 'forms',
  javaScript: 'javaScript',
  smask: 'smask',
  shadingPattern: 'shadingPattern',
  font: 'font'
};

// Checks if URLs have the same origin. For non-HTTP based URLs, returns false.
function isSameOrigin(baseUrl, otherUrl) {
  try {
    var base = new URL(baseUrl);
    if (!base.origin || base.origin === 'null') {
      return false; // non-HTTP url
    }
  } catch (e) {
    return false;
  }

  var other = new URL(otherUrl, base);
  return base.origin === other.origin;
}

// Validates if URL is safe and allowed, e.g. to avoid XSS.
function isValidUrl(url, allowRelative) {
  if (!url || typeof url !== 'string') {
    return false;
  }
  // RFC 3986 (http://tools.ietf.org/html/rfc3986#section-3.1)
  // scheme = ALPHA *( ALPHA / DIGIT / "+" / "-" / "." )
  var protocol = /^[a-z][a-z0-9+\-.]*(?=:)/i.exec(url);
  if (!protocol) {
    return allowRelative;
  }
  protocol = protocol[0].toLowerCase();
  switch (protocol) {
    case 'http':
    case 'https':
    case 'ftp':
    case 'mailto':
    case 'tel':
      return true;
    default:
      return false;
  }
}

function shadow(obj, prop, value) {
  Object.defineProperty(obj, prop, { value: value,
                                     enumerable: true,
                                     configurable: true,
                                     writable: false });
  return value;
}

function getLookupTableFactory(initializer) {
  var lookup;
  return function () {
    if (initializer) {
      lookup = Object.create(null);
      initializer(lookup);
      initializer = null;
    }
    return lookup;
  };
}

var PasswordResponses = {
  NEED_PASSWORD: 1,
  INCORRECT_PASSWORD: 2
};

var PasswordException = (function PasswordExceptionClosure() {
  function PasswordException(msg, code) {
    this.name = 'PasswordException';
    this.message = msg;
    this.code = code;
  }

  PasswordException.prototype = new Error();
  PasswordException.constructor = PasswordException;

  return PasswordException;
})();

var UnknownErrorException = (function UnknownErrorExceptionClosure() {
  function UnknownErrorException(msg, details) {
    this.name = 'UnknownErrorException';
    this.message = msg;
    this.details = details;
  }

  UnknownErrorException.prototype = new Error();
  UnknownErrorException.constructor = UnknownErrorException;

  return UnknownErrorException;
})();

var InvalidPDFException = (function InvalidPDFExceptionClosure() {
  function InvalidPDFException(msg) {
    this.name = 'InvalidPDFException';
    this.message = msg;
  }

  InvalidPDFException.prototype = new Error();
  InvalidPDFException.constructor = InvalidPDFException;

  return InvalidPDFException;
})();

var MissingPDFException = (function MissingPDFExceptionClosure() {
  function MissingPDFException(msg) {
    this.name = 'MissingPDFException';
    this.message = msg;
  }

  MissingPDFException.prototype = new Error();
  MissingPDFException.constructor = MissingPDFException;

  return MissingPDFException;
})();

var UnexpectedResponseException =
    (function UnexpectedResponseExceptionClosure() {
  function UnexpectedResponseException(msg, status) {
    this.name = 'UnexpectedResponseException';
    this.message = msg;
    this.status = status;
  }

  UnexpectedResponseException.prototype = new Error();
  UnexpectedResponseException.constructor = UnexpectedResponseException;

  return UnexpectedResponseException;
})();

var NotImplementedException = (function NotImplementedExceptionClosure() {
  function NotImplementedException(msg) {
    this.message = msg;
  }

  NotImplementedException.prototype = new Error();
  NotImplementedException.prototype.name = 'NotImplementedException';
  NotImplementedException.constructor = NotImplementedException;

  return NotImplementedException;
})();

var MissingDataException = (function MissingDataExceptionClosure() {
  function MissingDataException(begin, end) {
    this.begin = begin;
    this.end = end;
    this.message = 'Missing data [' + begin + ', ' + end + ')';
  }

  MissingDataException.prototype = new Error();
  MissingDataException.prototype.name = 'MissingDataException';
  MissingDataException.constructor = MissingDataException;

  return MissingDataException;
})();

var XRefParseException = (function XRefParseExceptionClosure() {
  function XRefParseException(msg) {
    this.message = msg;
  }

  XRefParseException.prototype = new Error();
  XRefParseException.prototype.name = 'XRefParseException';
  XRefParseException.constructor = XRefParseException;

  return XRefParseException;
})();

var NullCharactersRegExp = /\x00/g;

function removeNullCharacters(str) {
  if (typeof str !== 'string') {
    warn('The argument for removeNullCharacters must be a string.');
    return str;
  }
  return str.replace(NullCharactersRegExp, '');
}

function bytesToString(bytes) {
  assert(bytes !== null && typeof bytes === 'object' &&
         bytes.length !== undefined, 'Invalid argument for bytesToString');
  var length = bytes.length;
  var MAX_ARGUMENT_COUNT = 8192;
  if (length < MAX_ARGUMENT_COUNT) {
    return String.fromCharCode.apply(null, bytes);
  }
  var strBuf = [];
  for (var i = 0; i < length; i += MAX_ARGUMENT_COUNT) {
    var chunkEnd = Math.min(i + MAX_ARGUMENT_COUNT, length);
    var chunk = bytes.subarray(i, chunkEnd);
    strBuf.push(String.fromCharCode.apply(null, chunk));
  }
  return strBuf.join('');
}

function stringToBytes(str) {
  assert(typeof str === 'string', 'Invalid argument for stringToBytes');
  var length = str.length;
  var bytes = new Uint8Array(length);
  for (var i = 0; i < length; ++i) {
    bytes[i] = str.charCodeAt(i) & 0xFF;
  }
  return bytes;
}

/**
 * Gets length of the array (Array, Uint8Array, or string) in bytes.
 * @param {Array|Uint8Array|string} arr
 * @returns {number}
 */
function arrayByteLength(arr) {
  if (arr.length !== undefined) {
    return arr.length;
  }
  assert(arr.byteLength !== undefined);
  return arr.byteLength;
}

/**
 * Combines array items (arrays) into single Uint8Array object.
 * @param {Array} arr - the array of the arrays (Array, Uint8Array, or string).
 * @returns {Uint8Array}
 */
function arraysToBytes(arr) {
  // Shortcut: if first and only item is Uint8Array, return it.
  if (arr.length === 1 && (arr[0] instanceof Uint8Array)) {
    return arr[0];
  }
  var resultLength = 0;
  var i, ii = arr.length;
  var item, itemLength ;
  for (i = 0; i < ii; i++) {
    item = arr[i];
    itemLength = arrayByteLength(item);
    resultLength += itemLength;
  }
  var pos = 0;
  var data = new Uint8Array(resultLength);
  for (i = 0; i < ii; i++) {
    item = arr[i];
    if (!(item instanceof Uint8Array)) {
      if (typeof item === 'string') {
        item = stringToBytes(item);
      } else {
        item = new Uint8Array(item);
      }
    }
    itemLength = item.byteLength;
    data.set(item, pos);
    pos += itemLength;
  }
  return data;
}

function string32(value) {
  return String.fromCharCode((value >> 24) & 0xff, (value >> 16) & 0xff,
                             (value >> 8) & 0xff, value & 0xff);
}

function log2(x) {
  var n = 1, i = 0;
  while (x > n) {
    n <<= 1;
    i++;
  }
  return i;
}

function readInt8(data, start) {
  return (data[start] << 24) >> 24;
}

function readUint16(data, offset) {
  return (data[offset] << 8) | data[offset + 1];
}

function readUint32(data, offset) {
  return ((data[offset] << 24) | (data[offset + 1] << 16) |
         (data[offset + 2] << 8) | data[offset + 3]) >>> 0;
}

// Lazy test the endianness of the platform
// NOTE: This will be 'true' for simulated TypedArrays
function isLittleEndian() {
  var buffer8 = new Uint8Array(2);
  buffer8[0] = 1;
  var buffer16 = new Uint16Array(buffer8.buffer);
  return (buffer16[0] === 1);
}

// Checks if it's possible to eval JS expressions.
function isEvalSupported() {
  try {
    /* jshint evil: true */
    new Function('');
    return true;
  } catch (e) {
    return false;
  }
}

var Uint32ArrayView = (function Uint32ArrayViewClosure() {

  function Uint32ArrayView(buffer, length) {
    this.buffer = buffer;
    this.byteLength = buffer.length;
    this.length = length === undefined ? (this.byteLength >> 2) : length;
    ensureUint32ArrayViewProps(this.length);
  }
  Uint32ArrayView.prototype = Object.create(null);

  var uint32ArrayViewSetters = 0;
  function createUint32ArrayProp(index) {
    return {
      get: function () {
        var buffer = this.buffer, offset = index << 2;
        return (buffer[offset] | (buffer[offset + 1] << 8) |
          (buffer[offset + 2] << 16) | (buffer[offset + 3] << 24)) >>> 0;
      },
      set: function (value) {
        var buffer = this.buffer, offset = index << 2;
        buffer[offset] = value & 255;
        buffer[offset + 1] = (value >> 8) & 255;
        buffer[offset + 2] = (value >> 16) & 255;
        buffer[offset + 3] = (value >>> 24) & 255;
      }
    };
  }

  function ensureUint32ArrayViewProps(length) {
    while (uint32ArrayViewSetters < length) {
      Object.defineProperty(Uint32ArrayView.prototype,
        uint32ArrayViewSetters,
        createUint32ArrayProp(uint32ArrayViewSetters));
      uint32ArrayViewSetters++;
    }
  }

  return Uint32ArrayView;
})();

exports.Uint32ArrayView = Uint32ArrayView;

var IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];

var Util = (function UtilClosure() {
  function Util() {}

  var rgbBuf = ['rgb(', 0, ',', 0, ',', 0, ')'];

  // makeCssRgb() can be called thousands of times. Using |rgbBuf| avoids
  // creating many intermediate strings.
  Util.makeCssRgb = function Util_makeCssRgb(r, g, b) {
    rgbBuf[1] = r;
    rgbBuf[3] = g;
    rgbBuf[5] = b;
    return rgbBuf.join('');
  };

  // Concatenates two transformation matrices together and returns the result.
  Util.transform = function Util_transform(m1, m2) {
    return [
      m1[0] * m2[0] + m1[2] * m2[1],
      m1[1] * m2[0] + m1[3] * m2[1],
      m1[0] * m2[2] + m1[2] * m2[3],
      m1[1] * m2[2] + m1[3] * m2[3],
      m1[0] * m2[4] + m1[2] * m2[5] + m1[4],
      m1[1] * m2[4] + m1[3] * m2[5] + m1[5]
    ];
  };

  // For 2d affine transforms
  Util.applyTransform = function Util_applyTransform(p, m) {
    var xt = p[0] * m[0] + p[1] * m[2] + m[4];
    var yt = p[0] * m[1] + p[1] * m[3] + m[5];
    return [xt, yt];
  };

  Util.applyInverseTransform = function Util_applyInverseTransform(p, m) {
    var d = m[0] * m[3] - m[1] * m[2];
    var xt = (p[0] * m[3] - p[1] * m[2] + m[2] * m[5] - m[4] * m[3]) / d;
    var yt = (-p[0] * m[1] + p[1] * m[0] + m[4] * m[1] - m[5] * m[0]) / d;
    return [xt, yt];
  };

  // Applies the transform to the rectangle and finds the minimum axially
  // aligned bounding box.
  Util.getAxialAlignedBoundingBox =
    function Util_getAxialAlignedBoundingBox(r, m) {

    var p1 = Util.applyTransform(r, m);
    var p2 = Util.applyTransform(r.slice(2, 4), m);
    var p3 = Util.applyTransform([r[0], r[3]], m);
    var p4 = Util.applyTransform([r[2], r[1]], m);
    return [
      Math.min(p1[0], p2[0], p3[0], p4[0]),
      Math.min(p1[1], p2[1], p3[1], p4[1]),
      Math.max(p1[0], p2[0], p3[0], p4[0]),
      Math.max(p1[1], p2[1], p3[1], p4[1])
    ];
  };

  Util.inverseTransform = function Util_inverseTransform(m) {
    var d = m[0] * m[3] - m[1] * m[2];
    return [m[3] / d, -m[1] / d, -m[2] / d, m[0] / d,
      (m[2] * m[5] - m[4] * m[3]) / d, (m[4] * m[1] - m[5] * m[0]) / d];
  };

  // Apply a generic 3d matrix M on a 3-vector v:
  //   | a b c |   | X |
  //   | d e f | x | Y |
  //   | g h i |   | Z |
  // M is assumed to be serialized as [a,b,c,d,e,f,g,h,i],
  // with v as [X,Y,Z]
  Util.apply3dTransform = function Util_apply3dTransform(m, v) {
    return [
      m[0] * v[0] + m[1] * v[1] + m[2] * v[2],
      m[3] * v[0] + m[4] * v[1] + m[5] * v[2],
      m[6] * v[0] + m[7] * v[1] + m[8] * v[2]
    ];
  };

  // This calculation uses Singular Value Decomposition.
  // The SVD can be represented with formula A = USV. We are interested in the
  // matrix S here because it represents the scale values.
  Util.singularValueDecompose2dScale =
    function Util_singularValueDecompose2dScale(m) {

    var transpose = [m[0], m[2], m[1], m[3]];

    // Multiply matrix m with its transpose.
    var a = m[0] * transpose[0] + m[1] * transpose[2];
    var b = m[0] * transpose[1] + m[1] * transpose[3];
    var c = m[2] * transpose[0] + m[3] * transpose[2];
    var d = m[2] * transpose[1] + m[3] * transpose[3];

    // Solve the second degree polynomial to get roots.
    var first = (a + d) / 2;
    var second = Math.sqrt((a + d) * (a + d) - 4 * (a * d - c * b)) / 2;
    var sx = first + second || 1;
    var sy = first - second || 1;

    // Scale values are the square roots of the eigenvalues.
    return [Math.sqrt(sx), Math.sqrt(sy)];
  };

  // Normalize rectangle rect=[x1, y1, x2, y2] so that (x1,y1) < (x2,y2)
  // For coordinate systems whose origin lies in the bottom-left, this
  // means normalization to (BL,TR) ordering. For systems with origin in the
  // top-left, this means (TL,BR) ordering.
  Util.normalizeRect = function Util_normalizeRect(rect) {
    var r = rect.slice(0); // clone rect
    if (rect[0] > rect[2]) {
      r[0] = rect[2];
      r[2] = rect[0];
    }
    if (rect[1] > rect[3]) {
      r[1] = rect[3];
      r[3] = rect[1];
    }
    return r;
  };

  // Returns a rectangle [x1, y1, x2, y2] corresponding to the
  // intersection of rect1 and rect2. If no intersection, returns 'false'
  // The rectangle coordinates of rect1, rect2 should be [x1, y1, x2, y2]
  Util.intersect = function Util_intersect(rect1, rect2) {
    function compare(a, b) {
      return a - b;
    }

    // Order points along the axes
    var orderedX = [rect1[0], rect1[2], rect2[0], rect2[2]].sort(compare),
        orderedY = [rect1[1], rect1[3], rect2[1], rect2[3]].sort(compare),
        result = [];

    rect1 = Util.normalizeRect(rect1);
    rect2 = Util.normalizeRect(rect2);

    // X: first and second points belong to different rectangles?
    if ((orderedX[0] === rect1[0] && orderedX[1] === rect2[0]) ||
        (orderedX[0] === rect2[0] && orderedX[1] === rect1[0])) {
      // Intersection must be between second and third points
      result[0] = orderedX[1];
      result[2] = orderedX[2];
    } else {
      return false;
    }

    // Y: first and second points belong to different rectangles?
    if ((orderedY[0] === rect1[1] && orderedY[1] === rect2[1]) ||
        (orderedY[0] === rect2[1] && orderedY[1] === rect1[1])) {
      // Intersection must be between second and third points
      result[1] = orderedY[1];
      result[3] = orderedY[2];
    } else {
      return false;
    }

    return result;
  };

  Util.sign = function Util_sign(num) {
    return num < 0 ? -1 : 1;
  };

  var ROMAN_NUMBER_MAP = [
    '', 'C', 'CC', 'CCC', 'CD', 'D', 'DC', 'DCC', 'DCCC', 'CM',
    '', 'X', 'XX', 'XXX', 'XL', 'L', 'LX', 'LXX', 'LXXX', 'XC',
    '', 'I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII', 'IX'
  ];
  /**
   * Converts positive integers to (upper case) Roman numerals.
   * @param {integer} number - The number that should be converted.
   * @param {boolean} lowerCase - Indicates if the result should be converted
   *   to lower case letters. The default is false.
   * @return {string} The resulting Roman number.
   */
  Util.toRoman = function Util_toRoman(number, lowerCase) {
    assert(isInt(number) && number > 0,
           'The number should be a positive integer.');
    var pos, romanBuf = [];
    // Thousands
    while (number >= 1000) {
      number -= 1000;
      romanBuf.push('M');
    }
    // Hundreds
    pos = (number / 100) | 0;
    number %= 100;
    romanBuf.push(ROMAN_NUMBER_MAP[pos]);
    // Tens
    pos = (number / 10) | 0;
    number %= 10;
    romanBuf.push(ROMAN_NUMBER_MAP[10 + pos]);
    // Ones
    romanBuf.push(ROMAN_NUMBER_MAP[20 + number]);

    var romanStr = romanBuf.join('');
    return (lowerCase ? romanStr.toLowerCase() : romanStr);
  };

  Util.appendToArray = function Util_appendToArray(arr1, arr2) {
    Array.prototype.push.apply(arr1, arr2);
  };

  Util.prependToArray = function Util_prependToArray(arr1, arr2) {
    Array.prototype.unshift.apply(arr1, arr2);
  };

  Util.extendObj = function extendObj(obj1, obj2) {
    for (var key in obj2) {
      obj1[key] = obj2[key];
    }
  };

  Util.getInheritableProperty = function Util_getInheritableProperty(dict,
                                                                     name) {
    while (dict && !dict.has(name)) {
      dict = dict.get('Parent');
    }
    if (!dict) {
      return null;
    }
    return dict.get(name);
  };

  Util.inherit = function Util_inherit(sub, base, prototype) {
    sub.prototype = Object.create(base.prototype);
    sub.prototype.constructor = sub;
    for (var prop in prototype) {
      sub.prototype[prop] = prototype[prop];
    }
  };

  Util.loadScript = function Util_loadScript(src, callback) {
    var script = document.createElement('script');
    var loaded = false;
    script.setAttribute('src', src);
    if (callback) {
      script.onload = function() {
        if (!loaded) {
          callback();
        }
        loaded = true;
      };
    }
    document.getElementsByTagName('head')[0].appendChild(script);
  };

  return Util;
})();

/**
 * PDF page viewport created based on scale, rotation and offset.
 * @class
 * @alias PageViewport
 */
var PageViewport = (function PageViewportClosure() {
  /**
   * @constructor
   * @private
   * @param viewBox {Array} xMin, yMin, xMax and yMax coordinates.
   * @param scale {number} scale of the viewport.
   * @param rotation {number} rotations of the viewport in degrees.
   * @param offsetX {number} offset X
   * @param offsetY {number} offset Y
   * @param dontFlip {boolean} if true, axis Y will not be flipped.
   */
  function PageViewport(viewBox, scale, rotation, offsetX, offsetY, dontFlip) {
    this.viewBox = viewBox;
    this.scale = scale;
    this.rotation = rotation;
    this.offsetX = offsetX;
    this.offsetY = offsetY;

    // creating transform to convert pdf coordinate system to the normal
    // canvas like coordinates taking in account scale and rotation
    var centerX = (viewBox[2] + viewBox[0]) / 2;
    var centerY = (viewBox[3] + viewBox[1]) / 2;
    var rotateA, rotateB, rotateC, rotateD;
    rotation = rotation % 360;
    rotation = rotation < 0 ? rotation + 360 : rotation;
    switch (rotation) {
      case 180:
        rotateA = -1; rotateB = 0; rotateC = 0; rotateD = 1;
        break;
      case 90:
        rotateA = 0; rotateB = 1; rotateC = 1; rotateD = 0;
        break;
      case 270:
        rotateA = 0; rotateB = -1; rotateC = -1; rotateD = 0;
        break;
      //case 0:
      default:
        rotateA = 1; rotateB = 0; rotateC = 0; rotateD = -1;
        break;
    }

    if (dontFlip) {
      rotateC = -rotateC; rotateD = -rotateD;
    }

    var offsetCanvasX, offsetCanvasY;
    var width, height;
    if (rotateA === 0) {
      offsetCanvasX = Math.abs(centerY - viewBox[1]) * scale + offsetX;
      offsetCanvasY = Math.abs(centerX - viewBox[0]) * scale + offsetY;
      width = Math.abs(viewBox[3] - viewBox[1]) * scale;
      height = Math.abs(viewBox[2] - viewBox[0]) * scale;
    } else {
      offsetCanvasX = Math.abs(centerX - viewBox[0]) * scale + offsetX;
      offsetCanvasY = Math.abs(centerY - viewBox[1]) * scale + offsetY;
      width = Math.abs(viewBox[2] - viewBox[0]) * scale;
      height = Math.abs(viewBox[3] - viewBox[1]) * scale;
    }
    // creating transform for the following operations:
    // translate(-centerX, -centerY), rotate and flip vertically,
    // scale, and translate(offsetCanvasX, offsetCanvasY)
    this.transform = [
      rotateA * scale,
      rotateB * scale,
      rotateC * scale,
      rotateD * scale,
      offsetCanvasX - rotateA * scale * centerX - rotateC * scale * centerY,
      offsetCanvasY - rotateB * scale * centerX - rotateD * scale * centerY
    ];

    this.width = width;
    this.height = height;
    this.fontScale = scale;
  }
  PageViewport.prototype = /** @lends PageViewport.prototype */ {
    /**
     * Clones viewport with additional properties.
     * @param args {Object} (optional) If specified, may contain the 'scale' or
     * 'rotation' properties to override the corresponding properties in
     * the cloned viewport.
     * @returns {PageViewport} Cloned viewport.
     */
    clone: function PageViewPort_clone(args) {
      args = args || {};
      var scale = 'scale' in args ? args.scale : this.scale;
      var rotation = 'rotation' in args ? args.rotation : this.rotation;
      return new PageViewport(this.viewBox.slice(), scale, rotation,
                              this.offsetX, this.offsetY, args.dontFlip);
    },
    /**
     * Converts PDF point to the viewport coordinates. For examples, useful for
     * converting PDF location into canvas pixel coordinates.
     * @param x {number} X coordinate.
     * @param y {number} Y coordinate.
     * @returns {Object} Object that contains 'x' and 'y' properties of the
     * point in the viewport coordinate space.
     * @see {@link convertToPdfPoint}
     * @see {@link convertToViewportRectangle}
     */
    convertToViewportPoint: function PageViewport_convertToViewportPoint(x, y) {
      return Util.applyTransform([x, y], this.transform);
    },
    /**
     * Converts PDF rectangle to the viewport coordinates.
     * @param rect {Array} xMin, yMin, xMax and yMax coordinates.
     * @returns {Array} Contains corresponding coordinates of the rectangle
     * in the viewport coordinate space.
     * @see {@link convertToViewportPoint}
     */
    convertToViewportRectangle:
      function PageViewport_convertToViewportRectangle(rect) {
      var tl = Util.applyTransform([rect[0], rect[1]], this.transform);
      var br = Util.applyTransform([rect[2], rect[3]], this.transform);
      return [tl[0], tl[1], br[0], br[1]];
    },
    /**
     * Converts viewport coordinates to the PDF location. For examples, useful
     * for converting canvas pixel location into PDF one.
     * @param x {number} X coordinate.
     * @param y {number} Y coordinate.
     * @returns {Object} Object that contains 'x' and 'y' properties of the
     * point in the PDF coordinate space.
     * @see {@link convertToViewportPoint}
     */
    convertToPdfPoint: function PageViewport_convertToPdfPoint(x, y) {
      return Util.applyInverseTransform([x, y], this.transform);
    }
  };
  return PageViewport;
})();

var PDFStringTranslateTable = [
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0x2D8, 0x2C7, 0x2C6, 0x2D9, 0x2DD, 0x2DB, 0x2DA, 0x2DC, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2022, 0x2020, 0x2021, 0x2026, 0x2014,
  0x2013, 0x192, 0x2044, 0x2039, 0x203A, 0x2212, 0x2030, 0x201E, 0x201C,
  0x201D, 0x2018, 0x2019, 0x201A, 0x2122, 0xFB01, 0xFB02, 0x141, 0x152, 0x160,
  0x178, 0x17D, 0x131, 0x142, 0x153, 0x161, 0x17E, 0, 0x20AC
];

function stringToPDFString(str) {
  var i, n = str.length, strBuf = [];
  if (str[0] === '\xFE' && str[1] === '\xFF') {
    // UTF16BE BOM
    for (i = 2; i < n; i += 2) {
      strBuf.push(String.fromCharCode(
        (str.charCodeAt(i) << 8) | str.charCodeAt(i + 1)));
    }
  } else {
    for (i = 0; i < n; ++i) {
      var code = PDFStringTranslateTable[str.charCodeAt(i)];
      strBuf.push(code ? String.fromCharCode(code) : str.charAt(i));
    }
  }
  return strBuf.join('');
}

function stringToUTF8String(str) {
  return decodeURIComponent(escape(str));
}

function utf8StringToString(str) {
  return unescape(encodeURIComponent(str));
}

function isEmptyObj(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
}

function isBool(v) {
  return typeof v === 'boolean';
}

function isInt(v) {
  return typeof v === 'number' && ((v | 0) === v);
}

function isNum(v) {
  return typeof v === 'number';
}

function isString(v) {
  return typeof v === 'string';
}

function isArray(v) {
  return v instanceof Array;
}

function isArrayBuffer(v) {
  return typeof v === 'object' && v !== null && v.byteLength !== undefined;
}

// Checks if ch is one of the following characters: SPACE, TAB, CR or LF.
function isSpace(ch) {
  return (ch === 0x20 || ch === 0x09 || ch === 0x0D || ch === 0x0A);
}

/**
 * Promise Capability object.
 *
 * @typedef {Object} PromiseCapability
 * @property {Promise} promise - A promise object.
 * @property {function} resolve - Fulfills the promise.
 * @property {function} reject - Rejects the promise.
 */

/**
 * Creates a promise capability object.
 * @alias createPromiseCapability
 *
 * @return {PromiseCapability} A capability object contains:
 * - a Promise, resolve and reject methods.
 */
function createPromiseCapability() {
  var capability = {};
  capability.promise = new Promise(function (resolve, reject) {
    capability.resolve = resolve;
    capability.reject = reject;
  });
  return capability;
}

/**
 * Polyfill for Promises:
 * The following promise implementation tries to generally implement the
 * Promise/A+ spec. Some notable differences from other promise libraries are:
 * - There currently isn't a separate deferred and promise object.
 * - Unhandled rejections eventually show an error if they aren't handled.
 *
 * Based off of the work in:
 * https://bugzilla.mozilla.org/show_bug.cgi?id=810490
 */
(function PromiseClosure() {
  if (globalScope.Promise) {
    // Promises existing in the DOM/Worker, checking presence of all/resolve
    if (typeof globalScope.Promise.all !== 'function') {
      globalScope.Promise.all = function (iterable) {
        var count = 0, results = [], resolve, reject;
        var promise = new globalScope.Promise(function (resolve_, reject_) {
          resolve = resolve_;
          reject = reject_;
        });
        iterable.forEach(function (p, i) {
          count++;
          p.then(function (result) {
            results[i] = result;
            count--;
            if (count === 0) {
              resolve(results);
            }
          }, reject);
        });
        if (count === 0) {
          resolve(results);
        }
        return promise;
      };
    }
    if (typeof globalScope.Promise.resolve !== 'function') {
      globalScope.Promise.resolve = function (value) {
        return new globalScope.Promise(function (resolve) { resolve(value); });
      };
    }
    if (typeof globalScope.Promise.reject !== 'function') {
      globalScope.Promise.reject = function (reason) {
        return new globalScope.Promise(function (resolve, reject) {
          reject(reason);
        });
      };
    }
    if (typeof globalScope.Promise.prototype.catch !== 'function') {
      globalScope.Promise.prototype.catch = function (onReject) {
        return globalScope.Promise.prototype.then(undefined, onReject);
      };
    }
    return;
  }
  var STATUS_PENDING = 0;
  var STATUS_RESOLVED = 1;
  var STATUS_REJECTED = 2;

  // In an attempt to avoid silent exceptions, unhandled rejections are
  // tracked and if they aren't handled in a certain amount of time an
  // error is logged.
  var REJECTION_TIMEOUT = 500;

  var HandlerManager = {
    handlers: [],
    running: false,
    unhandledRejections: [],
    pendingRejectionCheck: false,

    scheduleHandlers: function scheduleHandlers(promise) {
      if (promise._status === STATUS_PENDING) {
        return;
      }

      this.handlers = this.handlers.concat(promise._handlers);
      promise._handlers = [];

      if (this.running) {
        return;
      }
      this.running = true;

      setTimeout(this.runHandlers.bind(this), 0);
    },

    runHandlers: function runHandlers() {
      var RUN_TIMEOUT = 1; // ms
      var timeoutAt = Date.now() + RUN_TIMEOUT;
      while (this.handlers.length > 0) {
        var handler = this.handlers.shift();

        var nextStatus = handler.thisPromise._status;
        var nextValue = handler.thisPromise._value;

        try {
          if (nextStatus === STATUS_RESOLVED) {
            if (typeof handler.onResolve === 'function') {
              nextValue = handler.onResolve(nextValue);
            }
          } else if (typeof handler.onReject === 'function') {
              nextValue = handler.onReject(nextValue);
              nextStatus = STATUS_RESOLVED;

              if (handler.thisPromise._unhandledRejection) {
                this.removeUnhandeledRejection(handler.thisPromise);
              }
          }
        } catch (ex) {
          nextStatus = STATUS_REJECTED;
          nextValue = ex;
        }

        handler.nextPromise._updateStatus(nextStatus, nextValue);
        if (Date.now() >= timeoutAt) {
          break;
        }
      }

      if (this.handlers.length > 0) {
        setTimeout(this.runHandlers.bind(this), 0);
        return;
      }

      this.running = false;
    },

    addUnhandledRejection: function addUnhandledRejection(promise) {
      this.unhandledRejections.push({
        promise: promise,
        time: Date.now()
      });
      this.scheduleRejectionCheck();
    },

    removeUnhandeledRejection: function removeUnhandeledRejection(promise) {
      promise._unhandledRejection = false;
      for (var i = 0; i < this.unhandledRejections.length; i++) {
        if (this.unhandledRejections[i].promise === promise) {
          this.unhandledRejections.splice(i);
          i--;
        }
      }
    },

    scheduleRejectionCheck: function scheduleRejectionCheck() {
      if (this.pendingRejectionCheck) {
        return;
      }
      this.pendingRejectionCheck = true;
      setTimeout(function rejectionCheck() {
        this.pendingRejectionCheck = false;
        var now = Date.now();
        for (var i = 0; i < this.unhandledRejections.length; i++) {
          if (now - this.unhandledRejections[i].time > REJECTION_TIMEOUT) {
            var unhandled = this.unhandledRejections[i].promise._value;
            var msg = 'Unhandled rejection: ' + unhandled;
            if (unhandled.stack) {
              msg += '\n' + unhandled.stack;
            }
            warn(msg);
            this.unhandledRejections.splice(i);
            i--;
          }
        }
        if (this.unhandledRejections.length) {
          this.scheduleRejectionCheck();
        }
      }.bind(this), REJECTION_TIMEOUT);
    }
  };

  function Promise(resolver) {
    this._status = STATUS_PENDING;
    this._handlers = [];
    try {
      resolver.call(this, this._resolve.bind(this), this._reject.bind(this));
    } catch (e) {
      this._reject(e);
    }
  }
  /**
   * Builds a promise that is resolved when all the passed in promises are
   * resolved.
   * @param {array} promises array of data and/or promises to wait for.
   * @return {Promise} New dependent promise.
   */
  Promise.all = function Promise_all(promises) {
    var resolveAll, rejectAll;
    var deferred = new Promise(function (resolve, reject) {
      resolveAll = resolve;
      rejectAll = reject;
    });
    var unresolved = promises.length;
    var results = [];
    if (unresolved === 0) {
      resolveAll(results);
      return deferred;
    }
    function reject(reason) {
      if (deferred._status === STATUS_REJECTED) {
        return;
      }
      results = [];
      rejectAll(reason);
    }
    for (var i = 0, ii = promises.length; i < ii; ++i) {
      var promise = promises[i];
      var resolve = (function(i) {
        return function(value) {
          if (deferred._status === STATUS_REJECTED) {
            return;
          }
          results[i] = value;
          unresolved--;
          if (unresolved === 0) {
            resolveAll(results);
          }
        };
      })(i);
      if (Promise.isPromise(promise)) {
        promise.then(resolve, reject);
      } else {
        resolve(promise);
      }
    }
    return deferred;
  };

  /**
   * Checks if the value is likely a promise (has a 'then' function).
   * @return {boolean} true if value is thenable
   */
  Promise.isPromise = function Promise_isPromise(value) {
    return value && typeof value.then === 'function';
  };

  /**
   * Creates resolved promise
   * @param value resolve value
   * @returns {Promise}
   */
  Promise.resolve = function Promise_resolve(value) {
    return new Promise(function (resolve) { resolve(value); });
  };

  /**
   * Creates rejected promise
   * @param reason rejection value
   * @returns {Promise}
   */
  Promise.reject = function Promise_reject(reason) {
    return new Promise(function (resolve, reject) { reject(reason); });
  };

  Promise.prototype = {
    _status: null,
    _value: null,
    _handlers: null,
    _unhandledRejection: null,

    _updateStatus: function Promise__updateStatus(status, value) {
      if (this._status === STATUS_RESOLVED ||
          this._status === STATUS_REJECTED) {
        return;
      }

      if (status === STATUS_RESOLVED &&
          Promise.isPromise(value)) {
        value.then(this._updateStatus.bind(this, STATUS_RESOLVED),
                   this._updateStatus.bind(this, STATUS_REJECTED));
        return;
      }

      this._status = status;
      this._value = value;

      if (status === STATUS_REJECTED && this._handlers.length === 0) {
        this._unhandledRejection = true;
        HandlerManager.addUnhandledRejection(this);
      }

      HandlerManager.scheduleHandlers(this);
    },

    _resolve: function Promise_resolve(value) {
      this._updateStatus(STATUS_RESOLVED, value);
    },

    _reject: function Promise_reject(reason) {
      this._updateStatus(STATUS_REJECTED, reason);
    },

    then: function Promise_then(onResolve, onReject) {
      var nextPromise = new Promise(function (resolve, reject) {
        this.resolve = resolve;
        this.reject = reject;
      });
      this._handlers.push({
        thisPromise: this,
        onResolve: onResolve,
        onReject: onReject,
        nextPromise: nextPromise
      });
      HandlerManager.scheduleHandlers(this);
      return nextPromise;
    },

    catch: function Promise_catch(onReject) {
      return this.then(undefined, onReject);
    }
  };

  globalScope.Promise = Promise;
})();

var StatTimer = (function StatTimerClosure() {
  function rpad(str, pad, length) {
    while (str.length < length) {
      str += pad;
    }
    return str;
  }
  function StatTimer() {
    this.started = Object.create(null);
    this.times = [];
    this.enabled = true;
  }
  StatTimer.prototype = {
    time: function StatTimer_time(name) {
      if (!this.enabled) {
        return;
      }
      if (name in this.started) {
        warn('Timer is already running for ' + name);
      }
      this.started[name] = Date.now();
    },
    timeEnd: function StatTimer_timeEnd(name) {
      if (!this.enabled) {
        return;
      }
      if (!(name in this.started)) {
        warn('Timer has not been started for ' + name);
      }
      this.times.push({
        'name': name,
        'start': this.started[name],
        'end': Date.now()
      });
      // Remove timer from started so it can be called again.
      delete this.started[name];
    },
    toString: function StatTimer_toString() {
      var i, ii;
      var times = this.times;
      var out = '';
      // Find the longest name for padding purposes.
      var longest = 0;
      for (i = 0, ii = times.length; i < ii; ++i) {
        var name = times[i]['name'];
        if (name.length > longest) {
          longest = name.length;
        }
      }
      for (i = 0, ii = times.length; i < ii; ++i) {
        var span = times[i];
        var duration = span.end - span.start;
        out += rpad(span['name'], ' ', longest) + ' ' + duration + 'ms\n';
      }
      return out;
    }
  };
  return StatTimer;
})();

var createBlob = function createBlob(data, contentType) {
  if (typeof Blob !== 'undefined') {
    return new Blob([data], { type: contentType });
  }
  warn('The "Blob" constructor is not supported.');
};

var createObjectURL = (function createObjectURLClosure() {
  // Blob/createObjectURL is not available, falling back to data schema.
  var digits =
    'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';

  return function createObjectURL(data, contentType, forceDataSchema) {
    if (!forceDataSchema &&
        typeof URL !== 'undefined' && URL.createObjectURL) {
      var blob = createBlob(data, contentType);
      return URL.createObjectURL(blob);
    }

    var buffer = 'data:' + contentType + ';base64,';
    for (var i = 0, ii = data.length; i < ii; i += 3) {
      var b1 = data[i] & 0xFF;
      var b2 = data[i + 1] & 0xFF;
      var b3 = data[i + 2] & 0xFF;
      var d1 = b1 >> 2, d2 = ((b1 & 3) << 4) | (b2 >> 4);
      var d3 = i + 1 < ii ? ((b2 & 0xF) << 2) | (b3 >> 6) : 64;
      var d4 = i + 2 < ii ? (b3 & 0x3F) : 64;
      buffer += digits[d1] + digits[d2] + digits[d3] + digits[d4];
    }
    return buffer;
  };
})();

function MessageHandler(sourceName, targetName, comObj) {
  this.sourceName = sourceName;
  this.targetName = targetName;
  this.comObj = comObj;
  this.callbackIndex = 1;
  this.postMessageTransfers = true;
  var callbacksCapabilities = this.callbacksCapabilities = Object.create(null);
  var ah = this.actionHandler = Object.create(null);

  this._onComObjOnMessage = function messageHandlerComObjOnMessage(event) {
    var data = event.data;
    if (data.targetName !== this.sourceName) {
      return;
    }
    if (data.isReply) {
      var callbackId = data.callbackId;
      if (data.callbackId in callbacksCapabilities) {
        var callback = callbacksCapabilities[callbackId];
        delete callbacksCapabilities[callbackId];
        if ('error' in data) {
          callback.reject(data.error);
        } else {
          callback.resolve(data.data);
        }
      } else {
        error('Cannot resolve callback ' + callbackId);
      }
    } else if (data.action in ah) {
      var action = ah[data.action];
      if (data.callbackId) {
        var sourceName = this.sourceName;
        var targetName = data.sourceName;
        Promise.resolve().then(function () {
          return action[0].call(action[1], data.data);
        }).then(function (result) {
          comObj.postMessage({
            sourceName: sourceName,
            targetName: targetName,
            isReply: true,
            callbackId: data.callbackId,
            data: result
          });
        }, function (reason) {
          if (reason instanceof Error) {
            // Serialize error to avoid "DataCloneError"
            reason = reason + '';
          }
          comObj.postMessage({
            sourceName: sourceName,
            targetName: targetName,
            isReply: true,
            callbackId: data.callbackId,
            error: reason
          });
        });
      } else {
        action[0].call(action[1], data.data);
      }
    } else {
      error('Unknown action from worker: ' + data.action);
    }
  }.bind(this);
  comObj.addEventListener('message', this._onComObjOnMessage);
}

MessageHandler.prototype = {
  on: function messageHandlerOn(actionName, handler, scope) {
    var ah = this.actionHandler;
    if (ah[actionName]) {
      error('There is already an actionName called "' + actionName + '"');
    }
    ah[actionName] = [handler, scope];
  },
  /**
   * Sends a message to the comObj to invoke the action with the supplied data.
   * @param {String} actionName Action to call.
   * @param {JSON} data JSON data to send.
   * @param {Array} [transfers] Optional list of transfers/ArrayBuffers
   */
  send: function messageHandlerSend(actionName, data, transfers) {
    var message = {
      sourceName: this.sourceName,
      targetName: this.targetName,
      action: actionName,
      data: data
    };
    this.postMessage(message, transfers);
  },
  /**
   * Sends a message to the comObj to invoke the action with the supplied data.
   * Expects that other side will callback with the response.
   * @param {String} actionName Action to call.
   * @param {JSON} data JSON data to send.
   * @param {Array} [transfers] Optional list of transfers/ArrayBuffers.
   * @returns {Promise} Promise to be resolved with response data.
   */
  sendWithPromise:
    function messageHandlerSendWithPromise(actionName, data, transfers) {
    var callbackId = this.callbackIndex++;
    var message = {
      sourceName: this.sourceName,
      targetName: this.targetName,
      action: actionName,
      data: data,
      callbackId: callbackId
    };
    var capability = createPromiseCapability();
    this.callbacksCapabilities[callbackId] = capability;
    try {
      this.postMessage(message, transfers);
    } catch (e) {
      capability.reject(e);
    }
    return capability.promise;
  },
  /**
   * Sends raw message to the comObj.
   * @private
   * @param message {Object} Raw message.
   * @param transfers List of transfers/ArrayBuffers, or undefined.
   */
  postMessage: function (message, transfers) {
    if (transfers && this.postMessageTransfers) {
      this.comObj.postMessage(message, transfers);
    } else {
      this.comObj.postMessage(message);
    }
  },

  destroy: function () {
    this.comObj.removeEventListener('message', this._onComObjOnMessage);
  }
};

function loadJpegStream(id, imageUrl, objs) {
  var img = new Image();
  img.onload = (function loadJpegStream_onloadClosure() {
    objs.resolve(id, img);
  });
  img.onerror = (function loadJpegStream_onerrorClosure() {
    objs.resolve(id, null);
    warn('Error during JPEG image loading');
  });
  img.src = imageUrl;
}

  // Polyfill from https://github.com/Polymer/URL
/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */
(function checkURLConstructor(scope) {
  /* jshint ignore:start */

  // feature detect for URL constructor
  var hasWorkingUrl = false;
  try {
    if (typeof URL === 'function' &&
        typeof URL.prototype === 'object' &&
        ('origin' in URL.prototype)) {
      var u = new URL('b', 'http://a');
      u.pathname = 'c%20d';
      hasWorkingUrl = u.href === 'http://a/c%20d';
    }
  } catch(e) { }

  if (hasWorkingUrl)
    return;

  var relative = Object.create(null);
  relative['ftp'] = 21;
  relative['file'] = 0;
  relative['gopher'] = 70;
  relative['http'] = 80;
  relative['https'] = 443;
  relative['ws'] = 80;
  relative['wss'] = 443;

  var relativePathDotMapping = Object.create(null);
  relativePathDotMapping['%2e'] = '.';
  relativePathDotMapping['.%2e'] = '..';
  relativePathDotMapping['%2e.'] = '..';
  relativePathDotMapping['%2e%2e'] = '..';

  function isRelativeScheme(scheme) {
    return relative[scheme] !== undefined;
  }

  function invalid() {
    clear.call(this);
    this._isInvalid = true;
  }

  function IDNAToASCII(h) {
    if ('' == h) {
      invalid.call(this)
    }
    // XXX
    return h.toLowerCase()
  }

  function percentEscape(c) {
    var unicode = c.charCodeAt(0);
    if (unicode > 0x20 &&
       unicode < 0x7F &&
       // " # < > ? `
       [0x22, 0x23, 0x3C, 0x3E, 0x3F, 0x60].indexOf(unicode) == -1
      ) {
      return c;
    }
    return encodeURIComponent(c);
  }

  function percentEscapeQuery(c) {
    // XXX This actually needs to encode c using encoding and then
    // convert the bytes one-by-one.

    var unicode = c.charCodeAt(0);
    if (unicode > 0x20 &&
       unicode < 0x7F &&
       // " # < > ` (do not escape '?')
       [0x22, 0x23, 0x3C, 0x3E, 0x60].indexOf(unicode) == -1
      ) {
      return c;
    }
    return encodeURIComponent(c);
  }

  var EOF = undefined,
      ALPHA = /[a-zA-Z]/,
      ALPHANUMERIC = /[a-zA-Z0-9\+\-\.]/;

  function parse(input, stateOverride, base) {
    function err(message) {
      errors.push(message)
    }

    var state = stateOverride || 'scheme start',
        cursor = 0,
        buffer = '',
        seenAt = false,
        seenBracket = false,
        errors = [];

    loop: while ((input[cursor - 1] != EOF || cursor == 0) && !this._isInvalid) {
      var c = input[cursor];
      switch (state) {
        case 'scheme start':
          if (c && ALPHA.test(c)) {
            buffer += c.toLowerCase(); // ASCII-safe
            state = 'scheme';
          } else if (!stateOverride) {
            buffer = '';
            state = 'no scheme';
            continue;
          } else {
            err('Invalid scheme.');
            break loop;
          }
          break;

        case 'scheme':
          if (c && ALPHANUMERIC.test(c)) {
            buffer += c.toLowerCase(); // ASCII-safe
          } else if (':' == c) {
            this._scheme = buffer;
            buffer = '';
            if (stateOverride) {
              break loop;
            }
            if (isRelativeScheme(this._scheme)) {
              this._isRelative = true;
            }
            if ('file' == this._scheme) {
              state = 'relative';
            } else if (this._isRelative && base && base._scheme == this._scheme) {
              state = 'relative or authority';
            } else if (this._isRelative) {
              state = 'authority first slash';
            } else {
              state = 'scheme data';
            }
          } else if (!stateOverride) {
            buffer = '';
            cursor = 0;
            state = 'no scheme';
            continue;
          } else if (EOF == c) {
            break loop;
          } else {
            err('Code point not allowed in scheme: ' + c)
            break loop;
          }
          break;

        case 'scheme data':
          if ('?' == c) {
            this._query = '?';
            state = 'query';
          } else if ('#' == c) {
            this._fragment = '#';
            state = 'fragment';
          } else {
            // XXX error handling
            if (EOF != c && '\t' != c && '\n' != c && '\r' != c) {
              this._schemeData += percentEscape(c);
            }
          }
          break;

        case 'no scheme':
          if (!base || !(isRelativeScheme(base._scheme))) {
            err('Missing scheme.');
            invalid.call(this);
          } else {
            state = 'relative';
            continue;
          }
          break;

        case 'relative or authority':
          if ('/' == c && '/' == input[cursor+1]) {
            state = 'authority ignore slashes';
          } else {
            err('Expected /, got: ' + c);
            state = 'relative';
            continue
          }
          break;

        case 'relative':
          this._isRelative = true;
          if ('file' != this._scheme)
            this._scheme = base._scheme;
          if (EOF == c) {
            this._host = base._host;
            this._port = base._port;
            this._path = base._path.slice();
            this._query = base._query;
            this._username = base._username;
            this._password = base._password;
            break loop;
          } else if ('/' == c || '\\' == c) {
            if ('\\' == c)
              err('\\ is an invalid code point.');
            state = 'relative slash';
          } else if ('?' == c) {
            this._host = base._host;
            this._port = base._port;
            this._path = base._path.slice();
            this._query = '?';
            this._username = base._username;
            this._password = base._password;
            state = 'query';
          } else if ('#' == c) {
            this._host = base._host;
            this._port = base._port;
            this._path = base._path.slice();
            this._query = base._query;
            this._fragment = '#';
            this._username = base._username;
            this._password = base._password;
            state = 'fragment';
          } else {
            var nextC = input[cursor+1]
            var nextNextC = input[cursor+2]
            if (
              'file' != this._scheme || !ALPHA.test(c) ||
              (nextC != ':' && nextC != '|') ||
              (EOF != nextNextC && '/' != nextNextC && '\\' != nextNextC && '?' != nextNextC && '#' != nextNextC)) {
              this._host = base._host;
              this._port = base._port;
              this._username = base._username;
              this._password = base._password;
              this._path = base._path.slice();
              this._path.pop();
            }
            state = 'relative path';
            continue;
          }
          break;

        case 'relative slash':
          if ('/' == c || '\\' == c) {
            if ('\\' == c) {
              err('\\ is an invalid code point.');
            }
            if ('file' == this._scheme) {
              state = 'file host';
            } else {
              state = 'authority ignore slashes';
            }
          } else {
            if ('file' != this._scheme) {
              this._host = base._host;
              this._port = base._port;
              this._username = base._username;
              this._password = base._password;
            }
            state = 'relative path';
            continue;
          }
          break;

        case 'authority first slash':
          if ('/' == c) {
            state = 'authority second slash';
          } else {
            err("Expected '/', got: " + c);
            state = 'authority ignore slashes';
            continue;
          }
          break;

        case 'authority second slash':
          state = 'authority ignore slashes';
          if ('/' != c) {
            err("Expected '/', got: " + c);
            continue;
          }
          break;

        case 'authority ignore slashes':
          if ('/' != c && '\\' != c) {
            state = 'authority';
            continue;
          } else {
            err('Expected authority, got: ' + c);
          }
          break;

        case 'authority':
          if ('@' == c) {
            if (seenAt) {
              err('@ already seen.');
              buffer += '%40';
            }
            seenAt = true;
            for (var i = 0; i < buffer.length; i++) {
              var cp = buffer[i];
              if ('\t' == cp || '\n' == cp || '\r' == cp) {
                err('Invalid whitespace in authority.');
                continue;
              }
              // XXX check URL code points
              if (':' == cp && null === this._password) {
                this._password = '';
                continue;
              }
              var tempC = percentEscape(cp);
              (null !== this._password) ? this._password += tempC : this._username += tempC;
            }
            buffer = '';
          } else if (EOF == c || '/' == c || '\\' == c || '?' == c || '#' == c) {
            cursor -= buffer.length;
            buffer = '';
            state = 'host';
            continue;
          } else {
            buffer += c;
          }
          break;

        case 'file host':
          if (EOF == c || '/' == c || '\\' == c || '?' == c || '#' == c) {
            if (buffer.length == 2 && ALPHA.test(buffer[0]) && (buffer[1] == ':' || buffer[1] == '|')) {
              state = 'relative path';
            } else if (buffer.length == 0) {
              state = 'relative path start';
            } else {
              this._host = IDNAToASCII.call(this, buffer);
              buffer = '';
              state = 'relative path start';
            }
            continue;
          } else if ('\t' == c || '\n' == c || '\r' == c) {
            err('Invalid whitespace in file host.');
          } else {
            buffer += c;
          }
          break;

        case 'host':
        case 'hostname':
          if (':' == c && !seenBracket) {
            // XXX host parsing
            this._host = IDNAToASCII.call(this, buffer);
            buffer = '';
            state = 'port';
            if ('hostname' == stateOverride) {
              break loop;
            }
          } else if (EOF == c || '/' == c || '\\' == c || '?' == c || '#' == c) {
            this._host = IDNAToASCII.call(this, buffer);
            buffer = '';
            state = 'relative path start';
            if (stateOverride) {
              break loop;
            }
            continue;
          } else if ('\t' != c && '\n' != c && '\r' != c) {
            if ('[' == c) {
              seenBracket = true;
            } else if (']' == c) {
              seenBracket = false;
            }
            buffer += c;
          } else {
            err('Invalid code point in host/hostname: ' + c);
          }
          break;

        case 'port':
          if (/[0-9]/.test(c)) {
            buffer += c;
          } else if (EOF == c || '/' == c || '\\' == c || '?' == c || '#' == c || stateOverride) {
            if ('' != buffer) {
              var temp = parseInt(buffer, 10);
              if (temp != relative[this._scheme]) {
                this._port = temp + '';
              }
              buffer = '';
            }
            if (stateOverride) {
              break loop;
            }
            state = 'relative path start';
            continue;
          } else if ('\t' == c || '\n' == c || '\r' == c) {
            err('Invalid code point in port: ' + c);
          } else {
            invalid.call(this);
          }
          break;

        case 'relative path start':
          if ('\\' == c)
            err("'\\' not allowed in path.");
          state = 'relative path';
          if ('/' != c && '\\' != c) {
            continue;
          }
          break;

        case 'relative path':
          if (EOF == c || '/' == c || '\\' == c || (!stateOverride && ('?' == c || '#' == c))) {
            if ('\\' == c) {
              err('\\ not allowed in relative path.');
            }
            var tmp;
            if (tmp = relativePathDotMapping[buffer.toLowerCase()]) {
              buffer = tmp;
            }
            if ('..' == buffer) {
              this._path.pop();
              if ('/' != c && '\\' != c) {
                this._path.push('');
              }
            } else if ('.' == buffer && '/' != c && '\\' != c) {
              this._path.push('');
            } else if ('.' != buffer) {
              if ('file' == this._scheme && this._path.length == 0 && buffer.length == 2 && ALPHA.test(buffer[0]) && buffer[1] == '|') {
                buffer = buffer[0] + ':';
              }
              this._path.push(buffer);
            }
            buffer = '';
            if ('?' == c) {
              this._query = '?';
              state = 'query';
            } else if ('#' == c) {
              this._fragment = '#';
              state = 'fragment';
            }
          } else if ('\t' != c && '\n' != c && '\r' != c) {
            buffer += percentEscape(c);
          }
          break;

        case 'query':
          if (!stateOverride && '#' == c) {
            this._fragment = '#';
            state = 'fragment';
          } else if (EOF != c && '\t' != c && '\n' != c && '\r' != c) {
            this._query += percentEscapeQuery(c);
          }
          break;

        case 'fragment':
          if (EOF != c && '\t' != c && '\n' != c && '\r' != c) {
            this._fragment += c;
          }
          break;
      }

      cursor++;
    }
  }

  function clear() {
    this._scheme = '';
    this._schemeData = '';
    this._username = '';
    this._password = null;
    this._host = '';
    this._port = '';
    this._path = [];
    this._query = '';
    this._fragment = '';
    this._isInvalid = false;
    this._isRelative = false;
  }

  // Does not process domain names or IP addresses.
  // Does not handle encoding for the query parameter.
  function jURL(url, base /* , encoding */) {
    if (base !== undefined && !(base instanceof jURL))
      base = new jURL(String(base));

    this._url = url;
    clear.call(this);

    var input = url.replace(/^[ \t\r\n\f]+|[ \t\r\n\f]+$/g, '');
    // encoding = encoding || 'utf-8'

    parse.call(this, input, null, base);
  }

  jURL.prototype = {
    toString: function() {
      return this.href;
    },
    get href() {
      if (this._isInvalid)
        return this._url;

      var authority = '';
      if ('' != this._username || null != this._password) {
        authority = this._username +
            (null != this._password ? ':' + this._password : '') + '@';
      }

      return this.protocol +
          (this._isRelative ? '//' + authority + this.host : '') +
          this.pathname + this._query + this._fragment;
    },
    set href(href) {
      clear.call(this);
      parse.call(this, href);
    },

    get protocol() {
      return this._scheme + ':';
    },
    set protocol(protocol) {
      if (this._isInvalid)
        return;
      parse.call(this, protocol + ':', 'scheme start');
    },

    get host() {
      return this._isInvalid ? '' : this._port ?
          this._host + ':' + this._port : this._host;
    },
    set host(host) {
      if (this._isInvalid || !this._isRelative)
        return;
      parse.call(this, host, 'host');
    },

    get hostname() {
      return this._host;
    },
    set hostname(hostname) {
      if (this._isInvalid || !this._isRelative)
        return;
      parse.call(this, hostname, 'hostname');
    },

    get port() {
      return this._port;
    },
    set port(port) {
      if (this._isInvalid || !this._isRelative)
        return;
      parse.call(this, port, 'port');
    },

    get pathname() {
      return this._isInvalid ? '' : this._isRelative ?
          '/' + this._path.join('/') : this._schemeData;
    },
    set pathname(pathname) {
      if (this._isInvalid || !this._isRelative)
        return;
      this._path = [];
      parse.call(this, pathname, 'relative path start');
    },

    get search() {
      return this._isInvalid || !this._query || '?' == this._query ?
          '' : this._query;
    },
    set search(search) {
      if (this._isInvalid || !this._isRelative)
        return;
      this._query = '?';
      if ('?' == search[0])
        search = search.slice(1);
      parse.call(this, search, 'query');
    },

    get hash() {
      return this._isInvalid || !this._fragment || '#' == this._fragment ?
          '' : this._fragment;
    },
    set hash(hash) {
      if (this._isInvalid)
        return;
      this._fragment = '#';
      if ('#' == hash[0])
        hash = hash.slice(1);
      parse.call(this, hash, 'fragment');
    },

    get origin() {
      var host;
      if (this._isInvalid || !this._scheme) {
        return '';
      }
      // javascript: Gecko returns String(""), WebKit/Blink String("null")
      // Gecko throws error for "data://"
      // data: Gecko returns "", Blink returns "data://", WebKit returns "null"
      // Gecko returns String("") for file: mailto:
      // WebKit/Blink returns String("SCHEME://") for file: mailto:
      switch (this._scheme) {
        case 'data':
        case 'file':
        case 'javascript':
        case 'mailto':
          return 'null';
      }
      host = this.host;
      if (!host) {
        return '';
      }
      return this._scheme + '://' + host;
    }
  };

  // Copy over the static methods
  var OriginalURL = scope.URL;
  if (OriginalURL) {
    jURL.createObjectURL = function(blob) {
      // IE extension allows a second optional options argument.
      // http://msdn.microsoft.com/en-us/library/ie/hh772302(v=vs.85).aspx
      return OriginalURL.createObjectURL.apply(OriginalURL, arguments);
    };
    jURL.revokeObjectURL = function(url) {
      OriginalURL.revokeObjectURL(url);
    };
  }

  scope.URL = jURL;
  /* jshint ignore:end */
})(globalScope);

exports.FONT_IDENTITY_MATRIX = FONT_IDENTITY_MATRIX;
exports.IDENTITY_MATRIX = IDENTITY_MATRIX;
exports.OPS = OPS;
exports.VERBOSITY_LEVELS = VERBOSITY_LEVELS;
exports.UNSUPPORTED_FEATURES = UNSUPPORTED_FEATURES;
exports.AnnotationBorderStyleType = AnnotationBorderStyleType;
exports.AnnotationFlag = AnnotationFlag;
exports.AnnotationType = AnnotationType;
exports.FontType = FontType;
exports.ImageKind = ImageKind;
exports.InvalidPDFException = InvalidPDFException;
exports.MessageHandler = MessageHandler;
exports.MissingDataException = MissingDataException;
exports.MissingPDFException = MissingPDFException;
exports.NotImplementedException = NotImplementedException;
exports.PageViewport = PageViewport;
exports.PasswordException = PasswordException;
exports.PasswordResponses = PasswordResponses;
exports.StatTimer = StatTimer;
exports.StreamType = StreamType;
exports.TextRenderingMode = TextRenderingMode;
exports.UnexpectedResponseException = UnexpectedResponseException;
exports.UnknownErrorException = UnknownErrorException;
exports.Util = Util;
exports.XRefParseException = XRefParseException;
exports.arrayByteLength = arrayByteLength;
exports.arraysToBytes = arraysToBytes;
exports.assert = assert;
exports.bytesToString = bytesToString;
exports.createBlob = createBlob;
exports.createPromiseCapability = createPromiseCapability;
exports.createObjectURL = createObjectURL;
exports.deprecated = deprecated;
exports.error = error;
exports.getLookupTableFactory = getLookupTableFactory;
exports.getVerbosityLevel = getVerbosityLevel;
exports.globalScope = globalScope;
exports.info = info;
exports.isArray = isArray;
exports.isArrayBuffer = isArrayBuffer;
exports.isBool = isBool;
exports.isEmptyObj = isEmptyObj;
exports.isInt = isInt;
exports.isNum = isNum;
exports.isString = isString;
exports.isSpace = isSpace;
exports.isSameOrigin = isSameOrigin;
exports.isValidUrl = isValidUrl;
exports.isLittleEndian = isLittleEndian;
exports.isEvalSupported = isEvalSupported;
exports.loadJpegStream = loadJpegStream;
exports.log2 = log2;
exports.readInt8 = readInt8;
exports.readUint16 = readUint16;
exports.readUint32 = readUint32;
exports.removeNullCharacters = removeNullCharacters;
exports.setVerbosityLevel = setVerbosityLevel;
exports.shadow = shadow;
exports.string32 = string32;
exports.stringToBytes = stringToBytes;
exports.stringToPDFString = stringToPDFString;
exports.stringToUTF8String = stringToUTF8String;
exports.utf8StringToString = utf8StringToString;
exports.warn = warn;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreCFFParser = {}), root.pdfjsSharedUtil,
      root.pdfjsCoreCharsets, root.pdfjsCoreEncodings);
  }
}(this, function (exports, sharedUtil, coreCharsets, coreEncodings) {

var error = sharedUtil.error;
var info = sharedUtil.info;
var bytesToString = sharedUtil.bytesToString;
var warn = sharedUtil.warn;
var isArray = sharedUtil.isArray;
var Util = sharedUtil.Util;
var stringToBytes = sharedUtil.stringToBytes;
var assert = sharedUtil.assert;
var ISOAdobeCharset = coreCharsets.ISOAdobeCharset;
var ExpertCharset = coreCharsets.ExpertCharset;
var ExpertSubsetCharset = coreCharsets.ExpertSubsetCharset;
var StandardEncoding = coreEncodings.StandardEncoding;
var ExpertEncoding = coreEncodings.ExpertEncoding;

// Maximum subroutine call depth of type 2 chartrings. Matches OTS.
var MAX_SUBR_NESTING = 10;

/**
 * The CFF class takes a Type1 file and wrap it into a
 * 'Compact Font Format' which itself embed Type2 charstrings.
 */
var CFFStandardStrings = [
  '.notdef', 'space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent',
  'ampersand', 'quoteright', 'parenleft', 'parenright', 'asterisk', 'plus',
  'comma', 'hyphen', 'period', 'slash', 'zero', 'one', 'two', 'three', 'four',
  'five', 'six', 'seven', 'eight', 'nine', 'colon', 'semicolon', 'less',
  'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
  'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
  'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum',
  'underscore', 'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
  'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y',
  'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'exclamdown', 'cent',
  'sterling', 'fraction', 'yen', 'florin', 'section', 'currency',
  'quotesingle', 'quotedblleft', 'guillemotleft', 'guilsinglleft',
  'guilsinglright', 'fi', 'fl', 'endash', 'dagger', 'daggerdbl',
  'periodcentered', 'paragraph', 'bullet', 'quotesinglbase', 'quotedblbase',
  'quotedblright', 'guillemotright', 'ellipsis', 'perthousand', 'questiondown',
  'grave', 'acute', 'circumflex', 'tilde', 'macron', 'breve', 'dotaccent',
  'dieresis', 'ring', 'cedilla', 'hungarumlaut', 'ogonek', 'caron', 'emdash',
  'AE', 'ordfeminine', 'Lslash', 'Oslash', 'OE', 'ordmasculine', 'ae',
  'dotlessi', 'lslash', 'oslash', 'oe', 'germandbls', 'onesuperior',
  'logicalnot', 'mu', 'trademark', 'Eth', 'onehalf', 'plusminus', 'Thorn',
  'onequarter', 'divide', 'brokenbar', 'degree', 'thorn', 'threequarters',
  'twosuperior', 'registered', 'minus', 'eth', 'multiply', 'threesuperior',
  'copyright', 'Aacute', 'Acircumflex', 'Adieresis', 'Agrave', 'Aring',
  'Atilde', 'Ccedilla', 'Eacute', 'Ecircumflex', 'Edieresis', 'Egrave',
  'Iacute', 'Icircumflex', 'Idieresis', 'Igrave', 'Ntilde', 'Oacute',
  'Ocircumflex', 'Odieresis', 'Ograve', 'Otilde', 'Scaron', 'Uacute',
  'Ucircumflex', 'Udieresis', 'Ugrave', 'Yacute', 'Ydieresis', 'Zcaron',
  'aacute', 'acircumflex', 'adieresis', 'agrave', 'aring', 'atilde',
  'ccedilla', 'eacute', 'ecircumflex', 'edieresis', 'egrave', 'iacute',
  'icircumflex', 'idieresis', 'igrave', 'ntilde', 'oacute', 'ocircumflex',
  'odieresis', 'ograve', 'otilde', 'scaron', 'uacute', 'ucircumflex',
  'udieresis', 'ugrave', 'yacute', 'ydieresis', 'zcaron', 'exclamsmall',
  'Hungarumlautsmall', 'dollaroldstyle', 'dollarsuperior', 'ampersandsmall',
  'Acutesmall', 'parenleftsuperior', 'parenrightsuperior', 'twodotenleader',
  'onedotenleader', 'zerooldstyle', 'oneoldstyle', 'twooldstyle',
  'threeoldstyle', 'fouroldstyle', 'fiveoldstyle', 'sixoldstyle',
  'sevenoldstyle', 'eightoldstyle', 'nineoldstyle', 'commasuperior',
  'threequartersemdash', 'periodsuperior', 'questionsmall', 'asuperior',
  'bsuperior', 'centsuperior', 'dsuperior', 'esuperior', 'isuperior',
  'lsuperior', 'msuperior', 'nsuperior', 'osuperior', 'rsuperior', 'ssuperior',
  'tsuperior', 'ff', 'ffi', 'ffl', 'parenleftinferior', 'parenrightinferior',
  'Circumflexsmall', 'hyphensuperior', 'Gravesmall', 'Asmall', 'Bsmall',
  'Csmall', 'Dsmall', 'Esmall', 'Fsmall', 'Gsmall', 'Hsmall', 'Ismall',
  'Jsmall', 'Ksmall', 'Lsmall', 'Msmall', 'Nsmall', 'Osmall', 'Psmall',
  'Qsmall', 'Rsmall', 'Ssmall', 'Tsmall', 'Usmall', 'Vsmall', 'Wsmall',
  'Xsmall', 'Ysmall', 'Zsmall', 'colonmonetary', 'onefitted', 'rupiah',
  'Tildesmall', 'exclamdownsmall', 'centoldstyle', 'Lslashsmall',
  'Scaronsmall', 'Zcaronsmall', 'Dieresissmall', 'Brevesmall', 'Caronsmall',
  'Dotaccentsmall', 'Macronsmall', 'figuredash', 'hypheninferior',
  'Ogoneksmall', 'Ringsmall', 'Cedillasmall', 'questiondownsmall', 'oneeighth',
  'threeeighths', 'fiveeighths', 'seveneighths', 'onethird', 'twothirds',
  'zerosuperior', 'foursuperior', 'fivesuperior', 'sixsuperior',
  'sevensuperior', 'eightsuperior', 'ninesuperior', 'zeroinferior',
  'oneinferior', 'twoinferior', 'threeinferior', 'fourinferior',
  'fiveinferior', 'sixinferior', 'seveninferior', 'eightinferior',
  'nineinferior', 'centinferior', 'dollarinferior', 'periodinferior',
  'commainferior', 'Agravesmall', 'Aacutesmall', 'Acircumflexsmall',
  'Atildesmall', 'Adieresissmall', 'Aringsmall', 'AEsmall', 'Ccedillasmall',
  'Egravesmall', 'Eacutesmall', 'Ecircumflexsmall', 'Edieresissmall',
  'Igravesmall', 'Iacutesmall', 'Icircumflexsmall', 'Idieresissmall',
  'Ethsmall', 'Ntildesmall', 'Ogravesmall', 'Oacutesmall', 'Ocircumflexsmall',
  'Otildesmall', 'Odieresissmall', 'OEsmall', 'Oslashsmall', 'Ugravesmall',
  'Uacutesmall', 'Ucircumflexsmall', 'Udieresissmall', 'Yacutesmall',
  'Thornsmall', 'Ydieresissmall', '001.000', '001.001', '001.002', '001.003',
  'Black', 'Bold', 'Book', 'Light', 'Medium', 'Regular', 'Roman', 'Semibold'
];


var CFFParser = (function CFFParserClosure() {
  var CharstringValidationData = [
    null,
    { id: 'hstem', min: 2, stackClearing: true, stem: true },
    null,
    { id: 'vstem', min: 2, stackClearing: true, stem: true },
    { id: 'vmoveto', min: 1, stackClearing: true },
    { id: 'rlineto', min: 2, resetStack: true },
    { id: 'hlineto', min: 1, resetStack: true },
    { id: 'vlineto', min: 1, resetStack: true },
    { id: 'rrcurveto', min: 6, resetStack: true },
    null,
    { id: 'callsubr', min: 1, undefStack: true },
    { id: 'return', min: 0, undefStack: true },
    null, // 12
    null,
    { id: 'endchar', min: 0, stackClearing: true },
    null,
    null,
    null,
    { id: 'hstemhm', min: 2, stackClearing: true, stem: true },
    { id: 'hintmask', min: 0, stackClearing: true },
    { id: 'cntrmask', min: 0, stackClearing: true },
    { id: 'rmoveto', min: 2, stackClearing: true },
    { id: 'hmoveto', min: 1, stackClearing: true },
    { id: 'vstemhm', min: 2, stackClearing: true, stem: true },
    { id: 'rcurveline', min: 8, resetStack: true },
    { id: 'rlinecurve', min: 8, resetStack: true },
    { id: 'vvcurveto', min: 4, resetStack: true },
    { id: 'hhcurveto', min: 4, resetStack: true },
    null, // shortint
    { id: 'callgsubr', min: 1, undefStack: true },
    { id: 'vhcurveto', min: 4, resetStack: true },
    { id: 'hvcurveto', min: 4, resetStack: true }
  ];
  var CharstringValidationData12 = [
    null,
    null,
    null,
    { id: 'and', min: 2, stackDelta: -1 },
    { id: 'or', min: 2, stackDelta: -1 },
    { id: 'not', min: 1, stackDelta: 0 },
    null,
    null,
    null,
    { id: 'abs', min: 1, stackDelta: 0 },
    { id: 'add', min: 2, stackDelta: -1,
      stackFn: function stack_div(stack, index) {
        stack[index - 2] = stack[index - 2] + stack[index - 1];
      }
    },
    { id: 'sub', min: 2, stackDelta: -1,
      stackFn: function stack_div(stack, index) {
        stack[index - 2] = stack[index - 2] - stack[index - 1];
      }
    },
    { id: 'div', min: 2, stackDelta: -1,
      stackFn: function stack_div(stack, index) {
        stack[index - 2] = stack[index - 2] / stack[index - 1];
      }
    },
    null,
    { id: 'neg', min: 1, stackDelta: 0,
      stackFn: function stack_div(stack, index) {
        stack[index - 1] = -stack[index - 1];
      }
    },
    { id: 'eq', min: 2, stackDelta: -1 },
    null,
    null,
    { id: 'drop', min: 1, stackDelta: -1 },
    null,
    { id: 'put', min: 2, stackDelta: -2 },
    { id: 'get', min: 1, stackDelta: 0 },
    { id: 'ifelse', min: 4, stackDelta: -3 },
    { id: 'random', min: 0, stackDelta: 1 },
    { id: 'mul', min: 2, stackDelta: -1,
      stackFn: function stack_div(stack, index) {
        stack[index - 2] = stack[index - 2] * stack[index - 1];
      }
    },
    null,
    { id: 'sqrt', min: 1, stackDelta: 0 },
    { id: 'dup', min: 1, stackDelta: 1 },
    { id: 'exch', min: 2, stackDelta: 0 },
    { id: 'index', min: 2, stackDelta: 0 },
    { id: 'roll', min: 3, stackDelta: -2 },
    null,
    null,
    null,
    { id: 'hflex', min: 7, resetStack: true },
    { id: 'flex', min: 13, resetStack: true },
    { id: 'hflex1', min: 9, resetStack: true },
    { id: 'flex1', min: 11, resetStack: true }
  ];

  function CFFParser(file, properties, seacAnalysisEnabled) {
    this.bytes = file.getBytes();
    this.properties = properties;
    this.seacAnalysisEnabled = !!seacAnalysisEnabled;
  }
  CFFParser.prototype = {
    parse: function CFFParser_parse() {
      var properties = this.properties;
      var cff = new CFF();
      this.cff = cff;

      // The first five sections must be in order, all the others are reached
      // via offsets contained in one of the below.
      var header = this.parseHeader();
      var nameIndex = this.parseIndex(header.endPos);
      var topDictIndex = this.parseIndex(nameIndex.endPos);
      var stringIndex = this.parseIndex(topDictIndex.endPos);
      var globalSubrIndex = this.parseIndex(stringIndex.endPos);

      var topDictParsed = this.parseDict(topDictIndex.obj.get(0));
      var topDict = this.createDict(CFFTopDict, topDictParsed, cff.strings);

      cff.header = header.obj;
      cff.names = this.parseNameIndex(nameIndex.obj);
      cff.strings = this.parseStringIndex(stringIndex.obj);
      cff.topDict = topDict;
      cff.globalSubrIndex = globalSubrIndex.obj;

      this.parsePrivateDict(cff.topDict);

      cff.isCIDFont = topDict.hasName('ROS');

      var charStringOffset = topDict.getByName('CharStrings');
      var charStringIndex = this.parseIndex(charStringOffset).obj;

      var fontMatrix = topDict.getByName('FontMatrix');
      if (fontMatrix) {
        properties.fontMatrix = fontMatrix;
      }

      var fontBBox = topDict.getByName('FontBBox');
      if (fontBBox) {
        // adjusting ascent/descent
        properties.ascent = fontBBox[3];
        properties.descent = fontBBox[1];
        properties.ascentScaled = true;
      }

      var charset, encoding;
      if (cff.isCIDFont) {
        var fdArrayIndex = this.parseIndex(topDict.getByName('FDArray')).obj;
        for (var i = 0, ii = fdArrayIndex.count; i < ii; ++i) {
          var dictRaw = fdArrayIndex.get(i);
          var fontDict = this.createDict(CFFTopDict, this.parseDict(dictRaw),
                                         cff.strings);
          this.parsePrivateDict(fontDict);
          cff.fdArray.push(fontDict);
        }
        // cid fonts don't have an encoding
        encoding = null;
        charset = this.parseCharsets(topDict.getByName('charset'),
                                     charStringIndex.count, cff.strings, true);
        cff.fdSelect = this.parseFDSelect(topDict.getByName('FDSelect'),
                                          charStringIndex.count);
      } else {
        charset = this.parseCharsets(topDict.getByName('charset'),
                                     charStringIndex.count, cff.strings, false);
        encoding = this.parseEncoding(topDict.getByName('Encoding'),
                                      properties,
                                      cff.strings, charset.charset);
      }

      cff.charset = charset;
      cff.encoding = encoding;

      var charStringsAndSeacs = this.parseCharStrings(
                                  charStringIndex,
                                  topDict.privateDict.subrsIndex,
                                  globalSubrIndex.obj,
                                  cff.fdSelect,
                                  cff.fdArray);
      cff.charStrings = charStringsAndSeacs.charStrings;
      cff.seacs = charStringsAndSeacs.seacs;
      cff.widths = charStringsAndSeacs.widths;

      return cff;
    },
    parseHeader: function CFFParser_parseHeader() {
      var bytes = this.bytes;
      var bytesLength = bytes.length;
      var offset = 0;

      // Prevent an infinite loop, by checking that the offset is within the
      // bounds of the bytes array. Necessary in empty, or invalid, font files.
      while (offset < bytesLength && bytes[offset] !== 1) {
        ++offset;
      }
      if (offset >= bytesLength) {
        error('Invalid CFF header');
      } else if (offset !== 0) {
        info('cff data is shifted');
        bytes = bytes.subarray(offset);
        this.bytes = bytes;
      }
      var major = bytes[0];
      var minor = bytes[1];
      var hdrSize = bytes[2];
      var offSize = bytes[3];
      var header = new CFFHeader(major, minor, hdrSize, offSize);
      return { obj: header, endPos: hdrSize };
    },
    parseDict: function CFFParser_parseDict(dict) {
      var pos = 0;

      function parseOperand() {
        var value = dict[pos++];
        if (value === 30) {
          return parseFloatOperand();
        } else if (value === 28) {
          value = dict[pos++];
          value = ((value << 24) | (dict[pos++] << 16)) >> 16;
          return value;
        } else if (value === 29) {
          value = dict[pos++];
          value = (value << 8) | dict[pos++];
          value = (value << 8) | dict[pos++];
          value = (value << 8) | dict[pos++];
          return value;
        } else if (value >= 32 && value <= 246) {
          return value - 139;
        } else if (value >= 247 && value <= 250) {
          return ((value - 247) * 256) + dict[pos++] + 108;
        } else if (value >= 251 && value <= 254) {
          return -((value - 251) * 256) - dict[pos++] - 108;
        } else {
          error('255 is not a valid DICT command');
        }
        return -1;
      }

      function parseFloatOperand() {
        var str = '';
        var eof = 15;
        var lookup = ['0', '1', '2', '3', '4', '5', '6', '7', '8',
            '9', '.', 'E', 'E-', null, '-'];
        var length = dict.length;
        while (pos < length) {
          var b = dict[pos++];
          var b1 = b >> 4;
          var b2 = b & 15;

          if (b1 === eof) {
            break;
          }
          str += lookup[b1];

          if (b2 === eof) {
            break;
          }
          str += lookup[b2];
        }
        return parseFloat(str);
      }

      var operands = [];
      var entries = [];

      pos = 0;
      var end = dict.length;
      while (pos < end) {
        var b = dict[pos];
        if (b <= 21) {
          if (b === 12) {
            b = (b << 8) | dict[++pos];
          }
          entries.push([b, operands]);
          operands = [];
          ++pos;
        } else {
          operands.push(parseOperand());
        }
      }
      return entries;
    },
    parseIndex: function CFFParser_parseIndex(pos) {
      var cffIndex = new CFFIndex();
      var bytes = this.bytes;
      var count = (bytes[pos++] << 8) | bytes[pos++];
      var offsets = [];
      var end = pos;
      var i, ii;

      if (count !== 0) {
        var offsetSize = bytes[pos++];
        // add 1 for offset to determine size of last object
        var startPos = pos + ((count + 1) * offsetSize) - 1;

        for (i = 0, ii = count + 1; i < ii; ++i) {
          var offset = 0;
          for (var j = 0; j < offsetSize; ++j) {
            offset <<= 8;
            offset += bytes[pos++];
          }
          offsets.push(startPos + offset);
        }
        end = offsets[count];
      }
      for (i = 0, ii = offsets.length - 1; i < ii; ++i) {
        var offsetStart = offsets[i];
        var offsetEnd = offsets[i + 1];
        cffIndex.add(bytes.subarray(offsetStart, offsetEnd));
      }
      return {obj: cffIndex, endPos: end};
    },
    parseNameIndex: function CFFParser_parseNameIndex(index) {
      var names = [];
      for (var i = 0, ii = index.count; i < ii; ++i) {
        var name = index.get(i);
        // OTS doesn't allow names to be over 127 characters.
        var length = Math.min(name.length, 127);
        var data = [];
        // OTS also only permits certain characters in the name.
        for (var j = 0; j < length; ++j) {
          var c = name[j];
          if (j === 0 && c === 0) {
            data[j] = c;
            continue;
          }
          if ((c < 33 || c > 126) || c === 91 /* [ */ || c === 93 /* ] */ ||
              c === 40 /* ( */ || c === 41 /* ) */ || c === 123 /* { */ ||
              c === 125 /* } */ || c === 60 /* < */ || c === 62 /* > */ ||
              c === 47 /* / */ || c === 37 /* % */ || c === 35 /* # */) {
            data[j] = 95;
            continue;
          }
          data[j] = c;
        }
        names.push(bytesToString(data));
      }
      return names;
    },
    parseStringIndex: function CFFParser_parseStringIndex(index) {
      var strings = new CFFStrings();
      for (var i = 0, ii = index.count; i < ii; ++i) {
        var data = index.get(i);
        strings.add(bytesToString(data));
      }
      return strings;
    },
    createDict: function CFFParser_createDict(Type, dict, strings) {
      var cffDict = new Type(strings);
      for (var i = 0, ii = dict.length; i < ii; ++i) {
        var pair = dict[i];
        var key = pair[0];
        var value = pair[1];
        cffDict.setByKey(key, value);
      }
      return cffDict;
    },
    parseCharString: function CFFParser_parseCharString(state, data,
                                                        localSubrIndex,
                                                        globalSubrIndex) {
      if (state.callDepth > MAX_SUBR_NESTING) {
        return false;
      }
      var stackSize = state.stackSize;
      var stack = state.stack;

      var length = data.length;

      for (var j = 0; j < length;) {
        var value = data[j++];
        var validationCommand = null;
        if (value === 12) {
          var q = data[j++];
          if (q === 0) {
            // The CFF specification state that the 'dotsection' command
            // (12, 0) is deprecated and treated as a no-op, but all Type2
            // charstrings processors should support them. Unfortunately
            // the font sanitizer don't. As a workaround the sequence (12, 0)
            // is replaced by a useless (0, hmoveto).
            data[j - 2] = 139;
            data[j - 1] = 22;
            stackSize = 0;
          } else {
            validationCommand = CharstringValidationData12[q];
          }
        } else if (value === 28) { // number (16 bit)
          stack[stackSize] = ((data[j] << 24) | (data[j + 1] << 16)) >> 16;
          j += 2;
          stackSize++;
        } else if (value === 14) {
          if (stackSize >= 4) {
            stackSize -= 4;
            if (this.seacAnalysisEnabled) {
              state.seac = stack.slice(stackSize, stackSize + 4);
              return false;
            }
          }
          validationCommand = CharstringValidationData[value];
        } else if (value >= 32 && value <= 246) {  // number
          stack[stackSize] = value - 139;
          stackSize++;
        } else if (value >= 247 && value <= 254) {  // number (+1 bytes)
          stack[stackSize] = (value < 251 ?
                              ((value - 247) << 8) + data[j] + 108 :
                              -((value - 251) << 8) - data[j] - 108);
          j++;
          stackSize++;
        } else if (value === 255) {  // number (32 bit)
          stack[stackSize] = ((data[j] << 24) | (data[j + 1] << 16) |
                              (data[j + 2] << 8) | data[j + 3]) / 65536;
          j += 4;
          stackSize++;
        } else if (value === 19 || value === 20) {
          state.hints += stackSize >> 1;
          // skipping right amount of hints flag data
          j += (state.hints + 7) >> 3;
          stackSize %= 2;
          validationCommand = CharstringValidationData[value];
        } else if (value === 10 || value === 29) {
          var subrsIndex;
          if (value === 10) {
            subrsIndex = localSubrIndex;
          } else {
            subrsIndex = globalSubrIndex;
          }
          if (!subrsIndex) {
            validationCommand = CharstringValidationData[value];
            warn('Missing subrsIndex for ' + validationCommand.id);
            return false;
          }
          var bias = 32768;
          if (subrsIndex.count < 1240) {
            bias = 107;
          } else if (subrsIndex.count < 33900) {
            bias = 1131;
          }
          var subrNumber = stack[--stackSize] + bias;
          if (subrNumber < 0 || subrNumber >= subrsIndex.count) {
            validationCommand = CharstringValidationData[value];
            warn('Out of bounds subrIndex for ' + validationCommand.id);
            return false;
          }
          state.stackSize = stackSize;
          state.callDepth++;
          var valid = this.parseCharString(state, subrsIndex.get(subrNumber),
                                           localSubrIndex, globalSubrIndex);
          if (!valid) {
            return false;
          }
          state.callDepth--;
          stackSize = state.stackSize;
          continue;
        } else if (value === 11) {
          state.stackSize = stackSize;
          return true;
        } else {
          validationCommand = CharstringValidationData[value];
        }
        if (validationCommand) {
          if (validationCommand.stem) {
            state.hints += stackSize >> 1;
          }
          if ('min' in validationCommand) {
            if (!state.undefStack && stackSize < validationCommand.min) {
              warn('Not enough parameters for ' + validationCommand.id +
                   '; actual: ' + stackSize +
                   ', expected: ' + validationCommand.min);
              return false;
            }
          }
          if (state.firstStackClearing && validationCommand.stackClearing) {
            state.firstStackClearing = false;
            // the optional character width can be found before the first
            // stack-clearing command arguments
            stackSize -= validationCommand.min;
            if (stackSize >= 2 && validationCommand.stem) {
              // there are even amount of arguments for stem commands
              stackSize %= 2;
            } else if (stackSize > 1) {
              warn('Found too many parameters for stack-clearing command');
            }
            if (stackSize > 0 && stack[stackSize - 1] >= 0) {
              state.width = stack[stackSize - 1];
            }
          }
          if ('stackDelta' in validationCommand) {
            if ('stackFn' in validationCommand) {
              validationCommand.stackFn(stack, stackSize);
            }
            stackSize += validationCommand.stackDelta;
          } else if (validationCommand.stackClearing) {
            stackSize = 0;
          } else if (validationCommand.resetStack) {
            stackSize = 0;
            state.undefStack = false;
          } else if (validationCommand.undefStack) {
            stackSize = 0;
            state.undefStack = true;
            state.firstStackClearing = false;
          }
        }
      }
      state.stackSize = stackSize;
      return true;
    },
    parseCharStrings: function CFFParser_parseCharStrings(charStrings,
                                                          localSubrIndex,
                                                          globalSubrIndex,
                                                          fdSelect,
                                                          fdArray) {
      var seacs = [];
      var widths = [];
      var count = charStrings.count;
      for (var i = 0; i < count; i++) {
        var charstring = charStrings.get(i);
        var state = {
          callDepth: 0,
          stackSize: 0,
          stack: [],
          undefStack: true,
          hints: 0,
          firstStackClearing: true,
          seac: null,
          width: null
        };
        var valid = true;
        var localSubrToUse = null;
        if (fdSelect && fdArray.length) {
          var fdIndex = fdSelect.getFDIndex(i);
          if (fdIndex === -1) {
            warn('Glyph index is not in fd select.');
            valid = false;
          }
          if (fdIndex >= fdArray.length) {
            warn('Invalid fd index for glyph index.');
            valid = false;
          }
          if (valid) {
            localSubrToUse = fdArray[fdIndex].privateDict.subrsIndex;
          }
        } else if (localSubrIndex) {
          localSubrToUse = localSubrIndex;
        }
        if (valid) {
          valid = this.parseCharString(state, charstring, localSubrToUse,
                                       globalSubrIndex);
        }
        if (state.width !== null) {
          widths[i] = state.width;
        }
        if (state.seac !== null) {
          seacs[i] = state.seac;
        }
        if (!valid) {
          // resetting invalid charstring to single 'endchar'
          charStrings.set(i, new Uint8Array([14]));
        }
      }
      return { charStrings: charStrings, seacs: seacs, widths: widths };
    },
    emptyPrivateDictionary:
      function CFFParser_emptyPrivateDictionary(parentDict) {
      var privateDict = this.createDict(CFFPrivateDict, [],
                                        parentDict.strings);
      parentDict.setByKey(18, [0, 0]);
      parentDict.privateDict = privateDict;
    },
    parsePrivateDict: function CFFParser_parsePrivateDict(parentDict) {
      // no private dict, do nothing
      if (!parentDict.hasName('Private')) {
        this.emptyPrivateDictionary(parentDict);
        return;
      }
      var privateOffset = parentDict.getByName('Private');
      // make sure the params are formatted correctly
      if (!isArray(privateOffset) || privateOffset.length !== 2) {
        parentDict.removeByName('Private');
        return;
      }
      var size = privateOffset[0];
      var offset = privateOffset[1];
      // remove empty dicts or ones that refer to invalid location
      if (size === 0 || offset >= this.bytes.length) {
        this.emptyPrivateDictionary(parentDict);
        return;
      }

      var privateDictEnd = offset + size;
      var dictData = this.bytes.subarray(offset, privateDictEnd);
      var dict = this.parseDict(dictData);
      var privateDict = this.createDict(CFFPrivateDict, dict,
                                        parentDict.strings);
      parentDict.privateDict = privateDict;

      // Parse the Subrs index also since it's relative to the private dict.
      if (!privateDict.getByName('Subrs')) {
        return;
      }
      var subrsOffset = privateDict.getByName('Subrs');
      var relativeOffset = offset + subrsOffset;
      // Validate the offset.
      if (subrsOffset === 0 || relativeOffset >= this.bytes.length) {
        this.emptyPrivateDictionary(parentDict);
        return;
      }
      var subrsIndex = this.parseIndex(relativeOffset);
      privateDict.subrsIndex = subrsIndex.obj;
    },
    parseCharsets: function CFFParser_parseCharsets(pos, length, strings, cid) {
      if (pos === 0) {
        return new CFFCharset(true, CFFCharsetPredefinedTypes.ISO_ADOBE,
                              ISOAdobeCharset);
      } else if (pos === 1) {
        return new CFFCharset(true, CFFCharsetPredefinedTypes.EXPERT,
                              ExpertCharset);
      } else if (pos === 2) {
        return new CFFCharset(true, CFFCharsetPredefinedTypes.EXPERT_SUBSET,
                              ExpertSubsetCharset);
      }

      var bytes = this.bytes;
      var start = pos;
      var format = bytes[pos++];
      var charset = ['.notdef'];
      var id, count, i;

      // subtract 1 for the .notdef glyph
      length -= 1;

      switch (format) {
        case 0:
          for (i = 0; i < length; i++) {
            id = (bytes[pos++] << 8) | bytes[pos++];
            charset.push(cid ? id : strings.get(id));
          }
          break;
        case 1:
          while (charset.length <= length) {
            id = (bytes[pos++] << 8) | bytes[pos++];
            count = bytes[pos++];
            for (i = 0; i <= count; i++) {
              charset.push(cid ? id++ : strings.get(id++));
            }
          }
          break;
        case 2:
          while (charset.length <= length) {
            id = (bytes[pos++] << 8) | bytes[pos++];
            count = (bytes[pos++] << 8) | bytes[pos++];
            for (i = 0; i <= count; i++) {
              charset.push(cid ? id++ : strings.get(id++));
            }
          }
          break;
        default:
          error('Unknown charset format');
      }
      // Raw won't be needed if we actually compile the charset.
      var end = pos;
      var raw = bytes.subarray(start, end);

      return new CFFCharset(false, format, charset, raw);
    },
    parseEncoding: function CFFParser_parseEncoding(pos,
                                                    properties,
                                                    strings,
                                                    charset) {
      var encoding = Object.create(null);
      var bytes = this.bytes;
      var predefined = false;
      var hasSupplement = false;
      var format, i, ii;
      var raw = null;

      function readSupplement() {
        var supplementsCount = bytes[pos++];
        for (i = 0; i < supplementsCount; i++) {
          var code = bytes[pos++];
          var sid = (bytes[pos++] << 8) + (bytes[pos++] & 0xff);
          encoding[code] = charset.indexOf(strings.get(sid));
        }
      }

      if (pos === 0 || pos === 1) {
        predefined = true;
        format = pos;
        var baseEncoding = pos ? ExpertEncoding : StandardEncoding;
        for (i = 0, ii = charset.length; i < ii; i++) {
          var index = baseEncoding.indexOf(charset[i]);
          if (index !== -1) {
            encoding[index] = i;
          }
        }
      } else {
        var dataStart = pos;
        format = bytes[pos++];
        switch (format & 0x7f) {
          case 0:
            var glyphsCount = bytes[pos++];
            for (i = 1; i <= glyphsCount; i++) {
              encoding[bytes[pos++]] = i;
            }
            break;

          case 1:
            var rangesCount = bytes[pos++];
            var gid = 1;
            for (i = 0; i < rangesCount; i++) {
              var start = bytes[pos++];
              var left = bytes[pos++];
              for (var j = start; j <= start + left; j++) {
                encoding[j] = gid++;
              }
            }
            break;

          default:
            error('Unknown encoding format: ' + format + ' in CFF');
            break;
        }
        var dataEnd = pos;
        if (format & 0x80) {
          // The font sanitizer does not support CFF encoding with a
          // supplement, since the encoding is not really used to map
          // between gid to glyph, let's overwrite what is declared in
          // the top dictionary to let the sanitizer think the font use
          // StandardEncoding, that's a lie but that's ok.
          bytes[dataStart] &= 0x7f;
          readSupplement();
          hasSupplement = true;
        }
        raw = bytes.subarray(dataStart, dataEnd);
      }
      format = format & 0x7f;
      return new CFFEncoding(predefined, format, encoding, raw);
    },
    parseFDSelect: function CFFParser_parseFDSelect(pos, length) {
      var start = pos;
      var bytes = this.bytes;
      var format = bytes[pos++];
      var fdSelect = [], rawBytes;
      var i, invalidFirstGID = false;

      switch (format) {
        case 0:
          for (i = 0; i < length; ++i) {
            var id = bytes[pos++];
            fdSelect.push(id);
          }
          rawBytes = bytes.subarray(start, pos);
          break;
        case 3:
          var rangesCount = (bytes[pos++] << 8) | bytes[pos++];
          for (i = 0; i < rangesCount; ++i) {
            var first = (bytes[pos++] << 8) | bytes[pos++];
            if (i === 0 && first !== 0) {
              warn('parseFDSelect: The first range must have a first GID of 0' +
                   ' -- trying to recover.');
              invalidFirstGID = true;
              first = 0;
            }
            var fdIndex = bytes[pos++];
            var next = (bytes[pos] << 8) | bytes[pos + 1];
            for (var j = first; j < next; ++j) {
              fdSelect.push(fdIndex);
            }
          }
          // Advance past the sentinel(next).
          pos += 2;
          rawBytes = bytes.subarray(start, pos);

          if (invalidFirstGID) {
            rawBytes[3] = rawBytes[4] = 0; // Adjust the first range, first GID.
          }
          break;
        default:
          error('parseFDSelect: Unknown format "' + format + '".');
          break;
      }
      assert(fdSelect.length === length, 'parseFDSelect: Invalid font data.');

      return new CFFFDSelect(fdSelect, rawBytes);
    }
  };
  return CFFParser;
})();

// Compact Font Format
var CFF = (function CFFClosure() {
  function CFF() {
    this.header = null;
    this.names = [];
    this.topDict = null;
    this.strings = new CFFStrings();
    this.globalSubrIndex = null;

    // The following could really be per font, but since we only have one font
    // store them here.
    this.encoding = null;
    this.charset = null;
    this.charStrings = null;
    this.fdArray = [];
    this.fdSelect = null;

    this.isCIDFont = false;
  }
  return CFF;
})();

var CFFHeader = (function CFFHeaderClosure() {
  function CFFHeader(major, minor, hdrSize, offSize) {
    this.major = major;
    this.minor = minor;
    this.hdrSize = hdrSize;
    this.offSize = offSize;
  }
  return CFFHeader;
})();

var CFFStrings = (function CFFStringsClosure() {
  function CFFStrings() {
    this.strings = [];
  }
  CFFStrings.prototype = {
    get: function CFFStrings_get(index) {
      if (index >= 0 && index <= 390) {
        return CFFStandardStrings[index];
      }
      if (index - 391 <= this.strings.length) {
        return this.strings[index - 391];
      }
      return CFFStandardStrings[0];
    },
    add: function CFFStrings_add(value) {
      this.strings.push(value);
    },
    get count() {
      return this.strings.length;
    }
  };
  return CFFStrings;
})();

var CFFIndex = (function CFFIndexClosure() {
  function CFFIndex() {
    this.objects = [];
    this.length = 0;
  }
  CFFIndex.prototype = {
    add: function CFFIndex_add(data) {
      this.length += data.length;
      this.objects.push(data);
    },
    set: function CFFIndex_set(index, data) {
      this.length += data.length - this.objects[index].length;
      this.objects[index] = data;
    },
    get: function CFFIndex_get(index) {
      return this.objects[index];
    },
    get count() {
      return this.objects.length;
    }
  };
  return CFFIndex;
})();

var CFFDict = (function CFFDictClosure() {
  function CFFDict(tables, strings) {
    this.keyToNameMap = tables.keyToNameMap;
    this.nameToKeyMap = tables.nameToKeyMap;
    this.defaults = tables.defaults;
    this.types = tables.types;
    this.opcodes = tables.opcodes;
    this.order = tables.order;
    this.strings = strings;
    this.values = Object.create(null);
  }
  CFFDict.prototype = {
    // value should always be an array
    setByKey: function CFFDict_setByKey(key, value) {
      if (!(key in this.keyToNameMap)) {
        return false;
      }
      // ignore empty values
      if (value.length === 0) {
        return true;
      }
      var type = this.types[key];
      // remove the array wrapping these types of values
      if (type === 'num' || type === 'sid' || type === 'offset') {
        value = value[0];
        // Ignore invalid values (fixes bug 1068432).
        if (isNaN(value)) {
          warn('Invalid CFFDict value: ' + value + ', for key: ' + key + '.');
          return true;
        }
      }
      this.values[key] = value;
      return true;
    },
    setByName: function CFFDict_setByName(name, value) {
      if (!(name in this.nameToKeyMap)) {
        error('Invalid dictionary name "' + name + '"');
      }
      this.values[this.nameToKeyMap[name]] = value;
    },
    hasName: function CFFDict_hasName(name) {
      return this.nameToKeyMap[name] in this.values;
    },
    getByName: function CFFDict_getByName(name) {
      if (!(name in this.nameToKeyMap)) {
        error('Invalid dictionary name "' + name + '"');
      }
      var key = this.nameToKeyMap[name];
      if (!(key in this.values)) {
        return this.defaults[key];
      }
      return this.values[key];
    },
    removeByName: function CFFDict_removeByName(name) {
      delete this.values[this.nameToKeyMap[name]];
    }
  };
  CFFDict.createTables = function CFFDict_createTables(layout) {
    var tables = {
      keyToNameMap: {},
      nameToKeyMap: {},
      defaults: {},
      types: {},
      opcodes: {},
      order: []
    };
    for (var i = 0, ii = layout.length; i < ii; ++i) {
      var entry = layout[i];
      var key = isArray(entry[0]) ? (entry[0][0] << 8) + entry[0][1] : entry[0];
      tables.keyToNameMap[key] = entry[1];
      tables.nameToKeyMap[entry[1]] = key;
      tables.types[key] = entry[2];
      tables.defaults[key] = entry[3];
      tables.opcodes[key] = isArray(entry[0]) ? entry[0] : [entry[0]];
      tables.order.push(key);
    }
    return tables;
  };
  return CFFDict;
})();

var CFFTopDict = (function CFFTopDictClosure() {
  var layout = [
    [[12, 30], 'ROS', ['sid', 'sid', 'num'], null],
    [[12, 20], 'SyntheticBase', 'num', null],
    [0, 'version', 'sid', null],
    [1, 'Notice', 'sid', null],
    [[12, 0], 'Copyright', 'sid', null],
    [2, 'FullName', 'sid', null],
    [3, 'FamilyName', 'sid', null],
    [4, 'Weight', 'sid', null],
    [[12, 1], 'isFixedPitch', 'num', 0],
    [[12, 2], 'ItalicAngle', 'num', 0],
    [[12, 3], 'UnderlinePosition', 'num', -100],
    [[12, 4], 'UnderlineThickness', 'num', 50],
    [[12, 5], 'PaintType', 'num', 0],
    [[12, 6], 'CharstringType', 'num', 2],
    [[12, 7], 'FontMatrix', ['num', 'num', 'num', 'num', 'num', 'num'],
                            [0.001, 0, 0, 0.001, 0, 0]],
    [13, 'UniqueID', 'num', null],
    [5, 'FontBBox', ['num', 'num', 'num', 'num'], [0, 0, 0, 0]],
    [[12, 8], 'StrokeWidth', 'num', 0],
    [14, 'XUID', 'array', null],
    [15, 'charset', 'offset', 0],
    [16, 'Encoding', 'offset', 0],
    [17, 'CharStrings', 'offset', 0],
    [18, 'Private', ['offset', 'offset'], null],
    [[12, 21], 'PostScript', 'sid', null],
    [[12, 22], 'BaseFontName', 'sid', null],
    [[12, 23], 'BaseFontBlend', 'delta', null],
    [[12, 31], 'CIDFontVersion', 'num', 0],
    [[12, 32], 'CIDFontRevision', 'num', 0],
    [[12, 33], 'CIDFontType', 'num', 0],
    [[12, 34], 'CIDCount', 'num', 8720],
    [[12, 35], 'UIDBase', 'num', null],
    // XXX: CID Fonts on DirectWrite 6.1 only seem to work if FDSelect comes
    // before FDArray.
    [[12, 37], 'FDSelect', 'offset', null],
    [[12, 36], 'FDArray', 'offset', null],
    [[12, 38], 'FontName', 'sid', null]
  ];
  var tables = null;
  function CFFTopDict(strings) {
    if (tables === null) {
      tables = CFFDict.createTables(layout);
    }
    CFFDict.call(this, tables, strings);
    this.privateDict = null;
  }
  CFFTopDict.prototype = Object.create(CFFDict.prototype);
  return CFFTopDict;
})();

var CFFPrivateDict = (function CFFPrivateDictClosure() {
  var layout = [
    [6, 'BlueValues', 'delta', null],
    [7, 'OtherBlues', 'delta', null],
    [8, 'FamilyBlues', 'delta', null],
    [9, 'FamilyOtherBlues', 'delta', null],
    [[12, 9], 'BlueScale', 'num', 0.039625],
    [[12, 10], 'BlueShift', 'num', 7],
    [[12, 11], 'BlueFuzz', 'num', 1],
    [10, 'StdHW', 'num', null],
    [11, 'StdVW', 'num', null],
    [[12, 12], 'StemSnapH', 'delta', null],
    [[12, 13], 'StemSnapV', 'delta', null],
    [[12, 14], 'ForceBold', 'num', 0],
    [[12, 17], 'LanguageGroup', 'num', 0],
    [[12, 18], 'ExpansionFactor', 'num', 0.06],
    [[12, 19], 'initialRandomSeed', 'num', 0],
    [20, 'defaultWidthX', 'num', 0],
    [21, 'nominalWidthX', 'num', 0],
    [19, 'Subrs', 'offset', null]
  ];
  var tables = null;
  function CFFPrivateDict(strings) {
    if (tables === null) {
      tables = CFFDict.createTables(layout);
    }
    CFFDict.call(this, tables, strings);
    this.subrsIndex = null;
  }
  CFFPrivateDict.prototype = Object.create(CFFDict.prototype);
  return CFFPrivateDict;
})();

var CFFCharsetPredefinedTypes = {
  ISO_ADOBE: 0,
  EXPERT: 1,
  EXPERT_SUBSET: 2
};
var CFFCharset = (function CFFCharsetClosure() {
  function CFFCharset(predefined, format, charset, raw) {
    this.predefined = predefined;
    this.format = format;
    this.charset = charset;
    this.raw = raw;
  }
  return CFFCharset;
})();

var CFFEncoding = (function CFFEncodingClosure() {
  function CFFEncoding(predefined, format, encoding, raw) {
    this.predefined = predefined;
    this.format = format;
    this.encoding = encoding;
    this.raw = raw;
  }
  return CFFEncoding;
})();

var CFFFDSelect = (function CFFFDSelectClosure() {
  function CFFFDSelect(fdSelect, raw) {
    this.fdSelect = fdSelect;
    this.raw = raw;
  }
  CFFFDSelect.prototype = {
    getFDIndex: function CFFFDSelect_get(glyphIndex) {
      if (glyphIndex < 0 || glyphIndex >= this.fdSelect.length) {
        return -1;
      }
      return this.fdSelect[glyphIndex];
    }
  };
  return CFFFDSelect;
})();

// Helper class to keep track of where an offset is within the data and helps
// filling in that offset once it's known.
var CFFOffsetTracker = (function CFFOffsetTrackerClosure() {
  function CFFOffsetTracker() {
    this.offsets = Object.create(null);
  }
  CFFOffsetTracker.prototype = {
    isTracking: function CFFOffsetTracker_isTracking(key) {
      return key in this.offsets;
    },
    track: function CFFOffsetTracker_track(key, location) {
      if (key in this.offsets) {
        error('Already tracking location of ' + key);
      }
      this.offsets[key] = location;
    },
    offset: function CFFOffsetTracker_offset(value) {
      for (var key in this.offsets) {
        this.offsets[key] += value;
      }
    },
    setEntryLocation: function CFFOffsetTracker_setEntryLocation(key,
                                                                 values,
                                                                 output) {
      if (!(key in this.offsets)) {
        error('Not tracking location of ' + key);
      }
      var data = output.data;
      var dataOffset = this.offsets[key];
      var size = 5;
      for (var i = 0, ii = values.length; i < ii; ++i) {
        var offset0 = i * size + dataOffset;
        var offset1 = offset0 + 1;
        var offset2 = offset0 + 2;
        var offset3 = offset0 + 3;
        var offset4 = offset0 + 4;
        // It's easy to screw up offsets so perform this sanity check.
        if (data[offset0] !== 0x1d || data[offset1] !== 0 ||
            data[offset2] !== 0 || data[offset3] !== 0 || data[offset4] !== 0) {
          error('writing to an offset that is not empty');
        }
        var value = values[i];
        data[offset0] = 0x1d;
        data[offset1] = (value >> 24) & 0xFF;
        data[offset2] = (value >> 16) & 0xFF;
        data[offset3] = (value >> 8) & 0xFF;
        data[offset4] = value & 0xFF;
      }
    }
  };
  return CFFOffsetTracker;
})();

// Takes a CFF and converts it to the binary representation.
var CFFCompiler = (function CFFCompilerClosure() {
  function CFFCompiler(cff) {
    this.cff = cff;
  }
  CFFCompiler.prototype = {
    compile: function CFFCompiler_compile() {
      var cff = this.cff;
      var output = {
        data: [],
        length: 0,
        add: function CFFCompiler_add(data) {
          this.data = this.data.concat(data);
          this.length = this.data.length;
        }
      };

      // Compile the five entries that must be in order.
      var header = this.compileHeader(cff.header);
      output.add(header);

      var nameIndex = this.compileNameIndex(cff.names);
      output.add(nameIndex);

      if (cff.isCIDFont) {
        // The spec is unclear on how font matrices should relate to each other
        // when there is one in the main top dict and the sub top dicts.
        // Windows handles this differently than linux and osx so we have to
        // normalize to work on all.
        // Rules based off of some mailing list discussions:
        // - If main font has a matrix and subfont doesn't, use the main matrix.
        // - If no main font matrix and there is a subfont matrix, use the
        //   subfont matrix.
        // - If both have matrices, concat together.
        // - If neither have matrices, use default.
        // To make this work on all platforms we move the top matrix into each
        // sub top dict and concat if necessary.
        if (cff.topDict.hasName('FontMatrix')) {
          var base = cff.topDict.getByName('FontMatrix');
          cff.topDict.removeByName('FontMatrix');
          for (var i = 0, ii = cff.fdArray.length; i < ii; i++) {
            var subDict = cff.fdArray[i];
            var matrix = base.slice(0);
            if (subDict.hasName('FontMatrix')) {
              matrix = Util.transform(matrix, subDict.getByName('FontMatrix'));
            }
            subDict.setByName('FontMatrix', matrix);
          }
        }
      }

      var compiled = this.compileTopDicts([cff.topDict],
                                          output.length,
                                          cff.isCIDFont);
      output.add(compiled.output);
      var topDictTracker = compiled.trackers[0];

      var stringIndex = this.compileStringIndex(cff.strings.strings);
      output.add(stringIndex);

      var globalSubrIndex = this.compileIndex(cff.globalSubrIndex);
      output.add(globalSubrIndex);

      // Now start on the other entries that have no specific order.
      if (cff.encoding && cff.topDict.hasName('Encoding')) {
        if (cff.encoding.predefined) {
          topDictTracker.setEntryLocation('Encoding', [cff.encoding.format],
                                          output);
        } else {
          var encoding = this.compileEncoding(cff.encoding);
          topDictTracker.setEntryLocation('Encoding', [output.length], output);
          output.add(encoding);
        }
      }

      if (cff.charset && cff.topDict.hasName('charset')) {
        if (cff.charset.predefined) {
          topDictTracker.setEntryLocation('charset', [cff.charset.format],
                                          output);
        } else {
          var charset = this.compileCharset(cff.charset);
          topDictTracker.setEntryLocation('charset', [output.length], output);
          output.add(charset);
        }
      }

      var charStrings = this.compileCharStrings(cff.charStrings);
      topDictTracker.setEntryLocation('CharStrings', [output.length], output);
      output.add(charStrings);

      if (cff.isCIDFont) {
        // For some reason FDSelect must be in front of FDArray on windows. OSX
        // and linux don't seem to care.
        topDictTracker.setEntryLocation('FDSelect', [output.length], output);
        var fdSelect = this.compileFDSelect(cff.fdSelect.raw);
        output.add(fdSelect);
        // It is unclear if the sub font dictionary can have CID related
        // dictionary keys, but the sanitizer doesn't like them so remove them.
        compiled = this.compileTopDicts(cff.fdArray, output.length, true);
        topDictTracker.setEntryLocation('FDArray', [output.length], output);
        output.add(compiled.output);
        var fontDictTrackers = compiled.trackers;

        this.compilePrivateDicts(cff.fdArray, fontDictTrackers, output);
      }

      this.compilePrivateDicts([cff.topDict], [topDictTracker], output);

      // If the font data ends with INDEX whose object data is zero-length,
      // the sanitizer will bail out. Add a dummy byte to avoid that.
      output.add([0]);

      return output.data;
    },
    encodeNumber: function CFFCompiler_encodeNumber(value) {
      if (parseFloat(value) === parseInt(value, 10) && !isNaN(value)) { // isInt
        return this.encodeInteger(value);
      } else {
        return this.encodeFloat(value);
      }
    },
    encodeFloat: function CFFCompiler_encodeFloat(num) {
      var value = num.toString();

      // rounding inaccurate doubles
      var m = /\.(\d*?)(?:9{5,20}|0{5,20})\d{0,2}(?:e(.+)|$)/.exec(value);
      if (m) {
        var epsilon = parseFloat('1e' + ((m[2] ? +m[2] : 0) + m[1].length));
        value = (Math.round(num * epsilon) / epsilon).toString();
      }

      var nibbles = '';
      var i, ii;
      for (i = 0, ii = value.length; i < ii; ++i) {
        var a = value[i];
        if (a === 'e') {
          nibbles += value[++i] === '-' ? 'c' : 'b';
        } else if (a === '.') {
          nibbles += 'a';
        } else if (a === '-') {
          nibbles += 'e';
        } else {
          nibbles += a;
        }
      }
      nibbles += (nibbles.length & 1) ? 'f' : 'ff';
      var out = [30];
      for (i = 0, ii = nibbles.length; i < ii; i += 2) {
        out.push(parseInt(nibbles.substr(i, 2), 16));
      }
      return out;
    },
    encodeInteger: function CFFCompiler_encodeInteger(value) {
      var code;
      if (value >= -107 && value <= 107) {
        code = [value + 139];
      } else if (value >= 108 && value <= 1131) {
        value = value - 108;
        code = [(value >> 8) + 247, value & 0xFF];
      } else if (value >= -1131 && value <= -108) {
        value = -value - 108;
        code = [(value >> 8) + 251, value & 0xFF];
      } else if (value >= -32768 && value <= 32767) {
        code = [0x1c, (value >> 8) & 0xFF, value & 0xFF];
      } else {
        code = [0x1d,
                (value >> 24) & 0xFF,
                (value >> 16) & 0xFF,
                (value >> 8) & 0xFF,
                 value & 0xFF];
      }
      return code;
    },
    compileHeader: function CFFCompiler_compileHeader(header) {
      return [
        header.major,
        header.minor,
        header.hdrSize,
        header.offSize
      ];
    },
    compileNameIndex: function CFFCompiler_compileNameIndex(names) {
      var nameIndex = new CFFIndex();
      for (var i = 0, ii = names.length; i < ii; ++i) {
        nameIndex.add(stringToBytes(names[i]));
      }
      return this.compileIndex(nameIndex);
    },
    compileTopDicts: function CFFCompiler_compileTopDicts(dicts,
                                                          length,
                                                          removeCidKeys) {
      var fontDictTrackers = [];
      var fdArrayIndex = new CFFIndex();
      for (var i = 0, ii = dicts.length; i < ii; ++i) {
        var fontDict = dicts[i];
        if (removeCidKeys) {
          fontDict.removeByName('CIDFontVersion');
          fontDict.removeByName('CIDFontRevision');
          fontDict.removeByName('CIDFontType');
          fontDict.removeByName('CIDCount');
          fontDict.removeByName('UIDBase');
        }
        var fontDictTracker = new CFFOffsetTracker();
        var fontDictData = this.compileDict(fontDict, fontDictTracker);
        fontDictTrackers.push(fontDictTracker);
        fdArrayIndex.add(fontDictData);
        fontDictTracker.offset(length);
      }
      fdArrayIndex = this.compileIndex(fdArrayIndex, fontDictTrackers);
      return {
        trackers: fontDictTrackers,
        output: fdArrayIndex
      };
    },
    compilePrivateDicts: function CFFCompiler_compilePrivateDicts(dicts,
                                                                  trackers,
                                                                  output) {
      for (var i = 0, ii = dicts.length; i < ii; ++i) {
        var fontDict = dicts[i];
        assert(fontDict.privateDict && fontDict.hasName('Private'),
               'There must be an private dictionary.');
        var privateDict = fontDict.privateDict;
        var privateDictTracker = new CFFOffsetTracker();
        var privateDictData = this.compileDict(privateDict, privateDictTracker);

        var outputLength = output.length;
        privateDictTracker.offset(outputLength);
        if (!privateDictData.length) {
          // The private dictionary was empty, set the output length to zero to
          // ensure the offset length isn't out of bounds in the eyes of the
          // sanitizer.
          outputLength = 0;
        }

        trackers[i].setEntryLocation('Private',
                                     [privateDictData.length, outputLength],
                                     output);
        output.add(privateDictData);

        if (privateDict.subrsIndex && privateDict.hasName('Subrs')) {
          var subrs = this.compileIndex(privateDict.subrsIndex);
          privateDictTracker.setEntryLocation('Subrs', [privateDictData.length],
                                              output);
          output.add(subrs);
        }
      }
    },
    compileDict: function CFFCompiler_compileDict(dict, offsetTracker) {
      var out = [];
      // The dictionary keys must be in a certain order.
      var order = dict.order;
      for (var i = 0; i < order.length; ++i) {
        var key = order[i];
        if (!(key in dict.values)) {
          continue;
        }
        var values = dict.values[key];
        var types = dict.types[key];
        if (!isArray(types)) {
          types = [types];
        }
        if (!isArray(values)) {
          values = [values];
        }

        // Remove any empty dict values.
        if (values.length === 0) {
          continue;
        }

        for (var j = 0, jj = types.length; j < jj; ++j) {
          var type = types[j];
          var value = values[j];
          switch (type) {
            case 'num':
            case 'sid':
              out = out.concat(this.encodeNumber(value));
              break;
            case 'offset':
              // For offsets we just insert a 32bit integer so we don't have to
              // deal with figuring out the length of the offset when it gets
              // replaced later on by the compiler.
              var name = dict.keyToNameMap[key];
              // Some offsets have the offset and the length, so just record the
              // position of the first one.
              if (!offsetTracker.isTracking(name)) {
                offsetTracker.track(name, out.length);
              }
              out = out.concat([0x1d, 0, 0, 0, 0]);
              break;
            case 'array':
            case 'delta':
              out = out.concat(this.encodeNumber(value));
              for (var k = 1, kk = values.length; k < kk; ++k) {
                out = out.concat(this.encodeNumber(values[k]));
              }
              break;
            default:
              error('Unknown data type of ' + type);
              break;
          }
        }
        out = out.concat(dict.opcodes[key]);
      }
      return out;
    },
    compileStringIndex: function CFFCompiler_compileStringIndex(strings) {
      var stringIndex = new CFFIndex();
      for (var i = 0, ii = strings.length; i < ii; ++i) {
        stringIndex.add(stringToBytes(strings[i]));
      }
      return this.compileIndex(stringIndex);
    },
    compileGlobalSubrIndex: function CFFCompiler_compileGlobalSubrIndex() {
      var globalSubrIndex = this.cff.globalSubrIndex;
      this.out.writeByteArray(this.compileIndex(globalSubrIndex));
    },
    compileCharStrings: function CFFCompiler_compileCharStrings(charStrings) {
      return this.compileIndex(charStrings);
    },
    compileCharset: function CFFCompiler_compileCharset(charset) {
      return this.compileTypedArray(charset.raw);
    },
    compileEncoding: function CFFCompiler_compileEncoding(encoding) {
      return this.compileTypedArray(encoding.raw);
    },
    compileFDSelect: function CFFCompiler_compileFDSelect(fdSelect) {
      return this.compileTypedArray(fdSelect);
    },
    compileTypedArray: function CFFCompiler_compileTypedArray(data) {
      var out = [];
      for (var i = 0, ii = data.length; i < ii; ++i) {
        out[i] = data[i];
      }
      return out;
    },
    compileIndex: function CFFCompiler_compileIndex(index, trackers) {
      trackers = trackers || [];
      var objects = index.objects;
      // First 2 bytes contains the number of objects contained into this index
      var count = objects.length;

      // If there is no object, just create an index. This technically
      // should just be [0, 0] but OTS has an issue with that.
      if (count === 0) {
        return [0, 0, 0];
      }

      var data = [(count >> 8) & 0xFF, count & 0xff];

      var lastOffset = 1, i;
      for (i = 0; i < count; ++i) {
        lastOffset += objects[i].length;
      }

      var offsetSize;
      if (lastOffset < 0x100) {
        offsetSize = 1;
      } else if (lastOffset < 0x10000) {
        offsetSize = 2;
      } else if (lastOffset < 0x1000000) {
        offsetSize = 3;
      } else {
        offsetSize = 4;
      }

      // Next byte contains the offset size use to reference object in the file
      data.push(offsetSize);

      // Add another offset after this one because we need a new offset
      var relativeOffset = 1;
      for (i = 0; i < count + 1; i++) {
        if (offsetSize === 1) {
          data.push(relativeOffset & 0xFF);
        } else if (offsetSize === 2) {
          data.push((relativeOffset >> 8) & 0xFF,
                     relativeOffset & 0xFF);
        } else if (offsetSize === 3) {
          data.push((relativeOffset >> 16) & 0xFF,
                    (relativeOffset >> 8) & 0xFF,
                     relativeOffset & 0xFF);
        } else {
          data.push((relativeOffset >>> 24) & 0xFF,
                    (relativeOffset >> 16) & 0xFF,
                    (relativeOffset >> 8) & 0xFF,
                     relativeOffset & 0xFF);
        }

        if (objects[i]) {
          relativeOffset += objects[i].length;
        }
      }

      for (i = 0; i < count; i++) {
        // Notify the tracker where the object will be offset in the data.
        if (trackers[i]) {
          trackers[i].offset(data.length);
        }
        for (var j = 0, jj = objects[i].length; j < jj; j++) {
          data.push(objects[i][j]);
        }
      }
      return data;
    }
  };
  return CFFCompiler;
})();

exports.CFFStandardStrings = CFFStandardStrings;
exports.CFFParser = CFFParser;
exports.CFF = CFF;
exports.CFFHeader = CFFHeader;
exports.CFFStrings = CFFStrings;
exports.CFFIndex = CFFIndex;
exports.CFFCharset = CFFCharset;
exports.CFFTopDict = CFFTopDict;
exports.CFFPrivateDict = CFFPrivateDict;
exports.CFFCompiler = CFFCompiler;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreChunkedStream = {}), root.pdfjsSharedUtil);
  }
}(this, function (exports, sharedUtil) {

var MissingDataException = sharedUtil.MissingDataException;
var arrayByteLength = sharedUtil.arrayByteLength;
var arraysToBytes = sharedUtil.arraysToBytes;
var assert = sharedUtil.assert;
var createPromiseCapability = sharedUtil.createPromiseCapability;
var isInt = sharedUtil.isInt;
var isEmptyObj = sharedUtil.isEmptyObj;

var ChunkedStream = (function ChunkedStreamClosure() {
  function ChunkedStream(length, chunkSize, manager) {
    this.bytes = new Uint8Array(length);
    this.start = 0;
    this.pos = 0;
    this.end = length;
    this.chunkSize = chunkSize;
    this.loadedChunks = [];
    this.numChunksLoaded = 0;
    this.numChunks = Math.ceil(length / chunkSize);
    this.manager = manager;
    this.progressiveDataLength = 0;
    this.lastSuccessfulEnsureByteChunk = -1;  // a single-entry cache
  }

  // required methods for a stream. if a particular stream does not
  // implement these, an error should be thrown
  ChunkedStream.prototype = {

    getMissingChunks: function ChunkedStream_getMissingChunks() {
      var chunks = [];
      for (var chunk = 0, n = this.numChunks; chunk < n; ++chunk) {
        if (!this.loadedChunks[chunk]) {
          chunks.push(chunk);
        }
      }
      return chunks;
    },

    getBaseStreams: function ChunkedStream_getBaseStreams() {
      return [this];
    },

    allChunksLoaded: function ChunkedStream_allChunksLoaded() {
      return this.numChunksLoaded === this.numChunks;
    },

    onReceiveData: function ChunkedStream_onReceiveData(begin, chunk) {
      var end = begin + chunk.byteLength;

      assert(begin % this.chunkSize === 0, 'Bad begin offset: ' + begin);
      // Using this.length is inaccurate here since this.start can be moved
      // See ChunkedStream.moveStart()
      var length = this.bytes.length;
      assert(end % this.chunkSize === 0 || end === length,
             'Bad end offset: ' + end);

      this.bytes.set(new Uint8Array(chunk), begin);
      var chunkSize = this.chunkSize;
      var beginChunk = Math.floor(begin / chunkSize);
      var endChunk = Math.floor((end - 1) / chunkSize) + 1;
      var curChunk;

      for (curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        if (!this.loadedChunks[curChunk]) {
          this.loadedChunks[curChunk] = true;
          ++this.numChunksLoaded;
        }
      }
    },

    onReceiveProgressiveData:
        function ChunkedStream_onReceiveProgressiveData(data) {
      var position = this.progressiveDataLength;
      var beginChunk = Math.floor(position / this.chunkSize);

      this.bytes.set(new Uint8Array(data), position);
      position += data.byteLength;
      this.progressiveDataLength = position;
      var endChunk = position >= this.end ? this.numChunks :
                     Math.floor(position / this.chunkSize);
      var curChunk;
      for (curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        if (!this.loadedChunks[curChunk]) {
          this.loadedChunks[curChunk] = true;
          ++this.numChunksLoaded;
        }
      }
    },

    ensureByte: function ChunkedStream_ensureByte(pos) {
      var chunk = Math.floor(pos / this.chunkSize);
      if (chunk === this.lastSuccessfulEnsureByteChunk) {
        return;
      }

      if (!this.loadedChunks[chunk]) {
        throw new MissingDataException(pos, pos + 1);
      }
      this.lastSuccessfulEnsureByteChunk = chunk;
    },

    ensureRange: function ChunkedStream_ensureRange(begin, end) {
      if (begin >= end) {
        return;
      }

      if (end <= this.progressiveDataLength) {
        return;
      }

      var chunkSize = this.chunkSize;
      var beginChunk = Math.floor(begin / chunkSize);
      var endChunk = Math.floor((end - 1) / chunkSize) + 1;
      for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
        if (!this.loadedChunks[chunk]) {
          throw new MissingDataException(begin, end);
        }
      }
    },

    nextEmptyChunk: function ChunkedStream_nextEmptyChunk(beginChunk) {
      var chunk, numChunks = this.numChunks;
      for (var i = 0; i < numChunks; ++i) {
        chunk = (beginChunk + i) % numChunks; // Wrap around to beginning
        if (!this.loadedChunks[chunk]) {
          return chunk;
        }
      }
      return null;
    },

    hasChunk: function ChunkedStream_hasChunk(chunk) {
      return !!this.loadedChunks[chunk];
    },

    get length() {
      return this.end - this.start;
    },

    get isEmpty() {
      return this.length === 0;
    },

    getByte: function ChunkedStream_getByte() {
      var pos = this.pos;
      if (pos >= this.end) {
        return -1;
      }
      this.ensureByte(pos);
      return this.bytes[this.pos++];
    },

    getUint16: function ChunkedStream_getUint16() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      if (b0 === -1 || b1 === -1) {
        return -1;
      }
      return (b0 << 8) + b1;
    },

    getInt32: function ChunkedStream_getInt32() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      var b2 = this.getByte();
      var b3 = this.getByte();
      return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    },

    // returns subarray of original buffer
    // should only be read
    getBytes: function ChunkedStream_getBytes(length) {
      var bytes = this.bytes;
      var pos = this.pos;
      var strEnd = this.end;

      if (!length) {
        this.ensureRange(pos, strEnd);
        return bytes.subarray(pos, strEnd);
      }

      var end = pos + length;
      if (end > strEnd) {
        end = strEnd;
      }
      this.ensureRange(pos, end);

      this.pos = end;
      return bytes.subarray(pos, end);
    },

    peekByte: function ChunkedStream_peekByte() {
      var peekedByte = this.getByte();
      this.pos--;
      return peekedByte;
    },

    peekBytes: function ChunkedStream_peekBytes(length) {
      var bytes = this.getBytes(length);
      this.pos -= bytes.length;
      return bytes;
    },

    getByteRange: function ChunkedStream_getBytes(begin, end) {
      this.ensureRange(begin, end);
      return this.bytes.subarray(begin, end);
    },

    skip: function ChunkedStream_skip(n) {
      if (!n) {
        n = 1;
      }
      this.pos += n;
    },

    reset: function ChunkedStream_reset() {
      this.pos = this.start;
    },

    moveStart: function ChunkedStream_moveStart() {
      this.start = this.pos;
    },

    makeSubStream: function ChunkedStream_makeSubStream(start, length, dict) {
      this.ensureRange(start, start + length);

      function ChunkedStreamSubstream() {}
      ChunkedStreamSubstream.prototype = Object.create(this);
      ChunkedStreamSubstream.prototype.getMissingChunks = function() {
        var chunkSize = this.chunkSize;
        var beginChunk = Math.floor(this.start / chunkSize);
        var endChunk = Math.floor((this.end - 1) / chunkSize) + 1;
        var missingChunks = [];
        for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
          if (!this.loadedChunks[chunk]) {
            missingChunks.push(chunk);
          }
        }
        return missingChunks;
      };
      var subStream = new ChunkedStreamSubstream();
      subStream.pos = subStream.start = start;
      subStream.end = start + length || this.end;
      subStream.dict = dict;
      return subStream;
    },

    isStream: true
  };

  return ChunkedStream;
})();

var ChunkedStreamManager = (function ChunkedStreamManagerClosure() {

  function ChunkedStreamManager(pdfNetworkStream, args) {
    var chunkSize = args.rangeChunkSize;
    var length = args.length;
    this.stream = new ChunkedStream(length, chunkSize, this);
    this.length = length;
    this.chunkSize = chunkSize;
    this.pdfNetworkStream = pdfNetworkStream;
    this.url = args.url;
    this.disableAutoFetch = args.disableAutoFetch;
    this.msgHandler = args.msgHandler;

    this.currRequestId = 0;

    this.chunksNeededByRequest = Object.create(null);
    this.requestsByChunk = Object.create(null);
    this.promisesByRequest = Object.create(null);
    this.progressiveDataLength = 0;
    this.aborted = false;

    this._loadedStreamCapability = createPromiseCapability();
  }

  ChunkedStreamManager.prototype = {
    onLoadedStream: function ChunkedStreamManager_getLoadedStream() {
      return this._loadedStreamCapability.promise;
    },

    sendRequest: function ChunkedStreamManager_sendRequest(begin, end) {
      var rangeReader = this.pdfNetworkStream.getRangeReader(begin, end);
      if (!rangeReader.isStreamingSupported) {
        rangeReader.onProgress = this.onProgress.bind(this);
      }
      var chunks = [], loaded = 0;
      var manager = this;
      var promise = new Promise(function (resolve, reject) {
        var readChunk = function (chunk) {
          try {
            if (!chunk.done) {
              var data = chunk.value;
              chunks.push(data);
              loaded += arrayByteLength(data);
              if (rangeReader.isStreamingSupported) {
                manager.onProgress({loaded: loaded});
              }
              rangeReader.read().then(readChunk, reject);
              return;
            }
            var chunkData = arraysToBytes(chunks);
            chunks = null;
            resolve(chunkData);
          } catch (e) {
            reject(e);
          }
        };
        rangeReader.read().then(readChunk, reject);
      });
      promise.then(function (data) {
        if (this.aborted) {
          return; // ignoring any data after abort
        }
        this.onReceiveData({chunk: data, begin: begin});
      }.bind(this));
      // TODO check errors
    },

    // Get all the chunks that are not yet loaded and groups them into
    // contiguous ranges to load in as few requests as possible
    requestAllChunks: function ChunkedStreamManager_requestAllChunks() {
      var missingChunks = this.stream.getMissingChunks();
      this._requestChunks(missingChunks);
      return this._loadedStreamCapability.promise;
    },

    _requestChunks: function ChunkedStreamManager_requestChunks(chunks) {
      var requestId = this.currRequestId++;

      var i, ii;
      var chunksNeeded = Object.create(null);
      this.chunksNeededByRequest[requestId] = chunksNeeded;
      for (i = 0, ii = chunks.length; i < ii; i++) {
        if (!this.stream.hasChunk(chunks[i])) {
          chunksNeeded[chunks[i]] = true;
        }
      }

      if (isEmptyObj(chunksNeeded)) {
        return Promise.resolve();
      }

      var capability = createPromiseCapability();
      this.promisesByRequest[requestId] = capability;

      var chunksToRequest = [];
      for (var chunk in chunksNeeded) {
        chunk = chunk | 0;
        if (!(chunk in this.requestsByChunk)) {
          this.requestsByChunk[chunk] = [];
          chunksToRequest.push(chunk);
        }
        this.requestsByChunk[chunk].push(requestId);
      }

      if (!chunksToRequest.length) {
        return capability.promise;
      }

      var groupedChunksToRequest = this.groupChunks(chunksToRequest);

      for (i = 0; i < groupedChunksToRequest.length; ++i) {
        var groupedChunk = groupedChunksToRequest[i];
        var begin = groupedChunk.beginChunk * this.chunkSize;
        var end = Math.min(groupedChunk.endChunk * this.chunkSize, this.length);
        this.sendRequest(begin, end);
      }

      return capability.promise;
    },

    getStream: function ChunkedStreamManager_getStream() {
      return this.stream;
    },

    // Loads any chunks in the requested range that are not yet loaded
    requestRange: function ChunkedStreamManager_requestRange(begin, end) {

      end = Math.min(end, this.length);

      var beginChunk = this.getBeginChunk(begin);
      var endChunk = this.getEndChunk(end);

      var chunks = [];
      for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
        chunks.push(chunk);
      }

      return this._requestChunks(chunks);
    },

    requestRanges: function ChunkedStreamManager_requestRanges(ranges) {
      ranges = ranges || [];
      var chunksToRequest = [];

      for (var i = 0; i < ranges.length; i++) {
        var beginChunk = this.getBeginChunk(ranges[i].begin);
        var endChunk = this.getEndChunk(ranges[i].end);
        for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
          if (chunksToRequest.indexOf(chunk) < 0) {
            chunksToRequest.push(chunk);
          }
        }
      }

      chunksToRequest.sort(function(a, b) { return a - b; });
      return this._requestChunks(chunksToRequest);
    },

    // Groups a sorted array of chunks into as few contiguous larger
    // chunks as possible
    groupChunks: function ChunkedStreamManager_groupChunks(chunks) {
      var groupedChunks = [];
      var beginChunk = -1;
      var prevChunk = -1;
      for (var i = 0; i < chunks.length; ++i) {
        var chunk = chunks[i];

        if (beginChunk < 0) {
          beginChunk = chunk;
        }

        if (prevChunk >= 0 && prevChunk + 1 !== chunk) {
          groupedChunks.push({ beginChunk: beginChunk,
                               endChunk: prevChunk + 1 });
          beginChunk = chunk;
        }
        if (i + 1 === chunks.length) {
          groupedChunks.push({ beginChunk: beginChunk,
                               endChunk: chunk + 1 });
        }

        prevChunk = chunk;
      }
      return groupedChunks;
    },

    onProgress: function ChunkedStreamManager_onProgress(args) {
      var bytesLoaded = (this.stream.numChunksLoaded * this.chunkSize +
                         args.loaded);
      this.msgHandler.send('DocProgress', {
        loaded: bytesLoaded,
        total: this.length
      });
    },

    onReceiveData: function ChunkedStreamManager_onReceiveData(args) {
      var chunk = args.chunk;
      var isProgressive = args.begin === undefined;
      var begin = isProgressive ? this.progressiveDataLength : args.begin;
      var end = begin + chunk.byteLength;

      var beginChunk = Math.floor(begin / this.chunkSize);
      var endChunk = end < this.length ? Math.floor(end / this.chunkSize) :
                                         Math.ceil(end / this.chunkSize);

      if (isProgressive) {
        this.stream.onReceiveProgressiveData(chunk);
        this.progressiveDataLength = end;
      } else {
        this.stream.onReceiveData(begin, chunk);
      }

      if (this.stream.allChunksLoaded()) {
        this._loadedStreamCapability.resolve(this.stream);
      }

      var loadedRequests = [];
      var i, requestId;
      for (chunk = beginChunk; chunk < endChunk; ++chunk) {
        // The server might return more chunks than requested
        var requestIds = this.requestsByChunk[chunk] || [];
        delete this.requestsByChunk[chunk];

        for (i = 0; i < requestIds.length; ++i) {
          requestId = requestIds[i];
          var chunksNeeded = this.chunksNeededByRequest[requestId];
          if (chunk in chunksNeeded) {
            delete chunksNeeded[chunk];
          }

          if (!isEmptyObj(chunksNeeded)) {
            continue;
          }

          loadedRequests.push(requestId);
        }
      }

      // If there are no pending requests, automatically fetch the next
      // unfetched chunk of the PDF
      if (!this.disableAutoFetch && isEmptyObj(this.requestsByChunk)) {
        var nextEmptyChunk;
        if (this.stream.numChunksLoaded === 1) {
          // This is a special optimization so that after fetching the first
          // chunk, rather than fetching the second chunk, we fetch the last
          // chunk.
          var lastChunk = this.stream.numChunks - 1;
          if (!this.stream.hasChunk(lastChunk)) {
            nextEmptyChunk = lastChunk;
          }
        } else {
          nextEmptyChunk = this.stream.nextEmptyChunk(endChunk);
        }
        if (isInt(nextEmptyChunk)) {
          this._requestChunks([nextEmptyChunk]);
        }
      }

      for (i = 0; i < loadedRequests.length; ++i) {
        requestId = loadedRequests[i];
        var capability = this.promisesByRequest[requestId];
        delete this.promisesByRequest[requestId];
        capability.resolve();
      }

      this.msgHandler.send('DocProgress', {
        loaded: this.stream.numChunksLoaded * this.chunkSize,
        total: this.length
      });
    },

    onError: function ChunkedStreamManager_onError(err) {
      this._loadedStreamCapability.reject(err);
    },

    getBeginChunk: function ChunkedStreamManager_getBeginChunk(begin) {
      var chunk = Math.floor(begin / this.chunkSize);
      return chunk;
    },

    getEndChunk: function ChunkedStreamManager_getEndChunk(end) {
      var chunk = Math.floor((end - 1) / this.chunkSize) + 1;
      return chunk;
    },

    abort: function ChunkedStreamManager_abort() {
      this.aborted = true;
      if (this.pdfNetworkStream) {
        this.pdfNetworkStream.cancelAllRequests('abort');
      }
      for(var requestId in this.promisesByRequest) {
        var capability = this.promisesByRequest[requestId];
        capability.reject(new Error('Request was aborted'));
      }
    }
  };

  return ChunkedStreamManager;
})();

exports.ChunkedStream = ChunkedStream;
exports.ChunkedStreamManager = ChunkedStreamManager;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreGlyphList = {}), root.pdfjsSharedUtil);
  }
}(this, function (exports, sharedUtil) {
var getLookupTableFactory = sharedUtil.getLookupTableFactory;

var getGlyphsUnicode = getLookupTableFactory(function (t) {
  t['A'] = 0x0041;
  t['AE'] = 0x00C6;
  t['AEacute'] = 0x01FC;
  t['AEmacron'] = 0x01E2;
  t['AEsmall'] = 0xF7E6;
  t['Aacute'] = 0x00C1;
  t['Aacutesmall'] = 0xF7E1;
  t['Abreve'] = 0x0102;
  t['Abreveacute'] = 0x1EAE;
  t['Abrevecyrillic'] = 0x04D0;
  t['Abrevedotbelow'] = 0x1EB6;
  t['Abrevegrave'] = 0x1EB0;
  t['Abrevehookabove'] = 0x1EB2;
  t['Abrevetilde'] = 0x1EB4;
  t['Acaron'] = 0x01CD;
  t['Acircle'] = 0x24B6;
  t['Acircumflex'] = 0x00C2;
  t['Acircumflexacute'] = 0x1EA4;
  t['Acircumflexdotbelow'] = 0x1EAC;
  t['Acircumflexgrave'] = 0x1EA6;
  t['Acircumflexhookabove'] = 0x1EA8;
  t['Acircumflexsmall'] = 0xF7E2;
  t['Acircumflextilde'] = 0x1EAA;
  t['Acute'] = 0xF6C9;
  t['Acutesmall'] = 0xF7B4;
  t['Acyrillic'] = 0x0410;
  t['Adblgrave'] = 0x0200;
  t['Adieresis'] = 0x00C4;
  t['Adieresiscyrillic'] = 0x04D2;
  t['Adieresismacron'] = 0x01DE;
  t['Adieresissmall'] = 0xF7E4;
  t['Adotbelow'] = 0x1EA0;
  t['Adotmacron'] = 0x01E0;
  t['Agrave'] = 0x00C0;
  t['Agravesmall'] = 0xF7E0;
  t['Ahookabove'] = 0x1EA2;
  t['Aiecyrillic'] = 0x04D4;
  t['Ainvertedbreve'] = 0x0202;
  t['Alpha'] = 0x0391;
  t['Alphatonos'] = 0x0386;
  t['Amacron'] = 0x0100;
  t['Amonospace'] = 0xFF21;
  t['Aogonek'] = 0x0104;
  t['Aring'] = 0x00C5;
  t['Aringacute'] = 0x01FA;
  t['Aringbelow'] = 0x1E00;
  t['Aringsmall'] = 0xF7E5;
  t['Asmall'] = 0xF761;
  t['Atilde'] = 0x00C3;
  t['Atildesmall'] = 0xF7E3;
  t['Aybarmenian'] = 0x0531;
  t['B'] = 0x0042;
  t['Bcircle'] = 0x24B7;
  t['Bdotaccent'] = 0x1E02;
  t['Bdotbelow'] = 0x1E04;
  t['Becyrillic'] = 0x0411;
  t['Benarmenian'] = 0x0532;
  t['Beta'] = 0x0392;
  t['Bhook'] = 0x0181;
  t['Blinebelow'] = 0x1E06;
  t['Bmonospace'] = 0xFF22;
  t['Brevesmall'] = 0xF6F4;
  t['Bsmall'] = 0xF762;
  t['Btopbar'] = 0x0182;
  t['C'] = 0x0043;
  t['Caarmenian'] = 0x053E;
  t['Cacute'] = 0x0106;
  t['Caron'] = 0xF6CA;
  t['Caronsmall'] = 0xF6F5;
  t['Ccaron'] = 0x010C;
  t['Ccedilla'] = 0x00C7;
  t['Ccedillaacute'] = 0x1E08;
  t['Ccedillasmall'] = 0xF7E7;
  t['Ccircle'] = 0x24B8;
  t['Ccircumflex'] = 0x0108;
  t['Cdot'] = 0x010A;
  t['Cdotaccent'] = 0x010A;
  t['Cedillasmall'] = 0xF7B8;
  t['Chaarmenian'] = 0x0549;
  t['Cheabkhasiancyrillic'] = 0x04BC;
  t['Checyrillic'] = 0x0427;
  t['Chedescenderabkhasiancyrillic'] = 0x04BE;
  t['Chedescendercyrillic'] = 0x04B6;
  t['Chedieresiscyrillic'] = 0x04F4;
  t['Cheharmenian'] = 0x0543;
  t['Chekhakassiancyrillic'] = 0x04CB;
  t['Cheverticalstrokecyrillic'] = 0x04B8;
  t['Chi'] = 0x03A7;
  t['Chook'] = 0x0187;
  t['Circumflexsmall'] = 0xF6F6;
  t['Cmonospace'] = 0xFF23;
  t['Coarmenian'] = 0x0551;
  t['Csmall'] = 0xF763;
  t['D'] = 0x0044;
  t['DZ'] = 0x01F1;
  t['DZcaron'] = 0x01C4;
  t['Daarmenian'] = 0x0534;
  t['Dafrican'] = 0x0189;
  t['Dcaron'] = 0x010E;
  t['Dcedilla'] = 0x1E10;
  t['Dcircle'] = 0x24B9;
  t['Dcircumflexbelow'] = 0x1E12;
  t['Dcroat'] = 0x0110;
  t['Ddotaccent'] = 0x1E0A;
  t['Ddotbelow'] = 0x1E0C;
  t['Decyrillic'] = 0x0414;
  t['Deicoptic'] = 0x03EE;
  t['Delta'] = 0x2206;
  t['Deltagreek'] = 0x0394;
  t['Dhook'] = 0x018A;
  t['Dieresis'] = 0xF6CB;
  t['DieresisAcute'] = 0xF6CC;
  t['DieresisGrave'] = 0xF6CD;
  t['Dieresissmall'] = 0xF7A8;
  t['Digammagreek'] = 0x03DC;
  t['Djecyrillic'] = 0x0402;
  t['Dlinebelow'] = 0x1E0E;
  t['Dmonospace'] = 0xFF24;
  t['Dotaccentsmall'] = 0xF6F7;
  t['Dslash'] = 0x0110;
  t['Dsmall'] = 0xF764;
  t['Dtopbar'] = 0x018B;
  t['Dz'] = 0x01F2;
  t['Dzcaron'] = 0x01C5;
  t['Dzeabkhasiancyrillic'] = 0x04E0;
  t['Dzecyrillic'] = 0x0405;
  t['Dzhecyrillic'] = 0x040F;
  t['E'] = 0x0045;
  t['Eacute'] = 0x00C9;
  t['Eacutesmall'] = 0xF7E9;
  t['Ebreve'] = 0x0114;
  t['Ecaron'] = 0x011A;
  t['Ecedillabreve'] = 0x1E1C;
  t['Echarmenian'] = 0x0535;
  t['Ecircle'] = 0x24BA;
  t['Ecircumflex'] = 0x00CA;
  t['Ecircumflexacute'] = 0x1EBE;
  t['Ecircumflexbelow'] = 0x1E18;
  t['Ecircumflexdotbelow'] = 0x1EC6;
  t['Ecircumflexgrave'] = 0x1EC0;
  t['Ecircumflexhookabove'] = 0x1EC2;
  t['Ecircumflexsmall'] = 0xF7EA;
  t['Ecircumflextilde'] = 0x1EC4;
  t['Ecyrillic'] = 0x0404;
  t['Edblgrave'] = 0x0204;
  t['Edieresis'] = 0x00CB;
  t['Edieresissmall'] = 0xF7EB;
  t['Edot'] = 0x0116;
  t['Edotaccent'] = 0x0116;
  t['Edotbelow'] = 0x1EB8;
  t['Efcyrillic'] = 0x0424;
  t['Egrave'] = 0x00C8;
  t['Egravesmall'] = 0xF7E8;
  t['Eharmenian'] = 0x0537;
  t['Ehookabove'] = 0x1EBA;
  t['Eightroman'] = 0x2167;
  t['Einvertedbreve'] = 0x0206;
  t['Eiotifiedcyrillic'] = 0x0464;
  t['Elcyrillic'] = 0x041B;
  t['Elevenroman'] = 0x216A;
  t['Emacron'] = 0x0112;
  t['Emacronacute'] = 0x1E16;
  t['Emacrongrave'] = 0x1E14;
  t['Emcyrillic'] = 0x041C;
  t['Emonospace'] = 0xFF25;
  t['Encyrillic'] = 0x041D;
  t['Endescendercyrillic'] = 0x04A2;
  t['Eng'] = 0x014A;
  t['Enghecyrillic'] = 0x04A4;
  t['Enhookcyrillic'] = 0x04C7;
  t['Eogonek'] = 0x0118;
  t['Eopen'] = 0x0190;
  t['Epsilon'] = 0x0395;
  t['Epsilontonos'] = 0x0388;
  t['Ercyrillic'] = 0x0420;
  t['Ereversed'] = 0x018E;
  t['Ereversedcyrillic'] = 0x042D;
  t['Escyrillic'] = 0x0421;
  t['Esdescendercyrillic'] = 0x04AA;
  t['Esh'] = 0x01A9;
  t['Esmall'] = 0xF765;
  t['Eta'] = 0x0397;
  t['Etarmenian'] = 0x0538;
  t['Etatonos'] = 0x0389;
  t['Eth'] = 0x00D0;
  t['Ethsmall'] = 0xF7F0;
  t['Etilde'] = 0x1EBC;
  t['Etildebelow'] = 0x1E1A;
  t['Euro'] = 0x20AC;
  t['Ezh'] = 0x01B7;
  t['Ezhcaron'] = 0x01EE;
  t['Ezhreversed'] = 0x01B8;
  t['F'] = 0x0046;
  t['Fcircle'] = 0x24BB;
  t['Fdotaccent'] = 0x1E1E;
  t['Feharmenian'] = 0x0556;
  t['Feicoptic'] = 0x03E4;
  t['Fhook'] = 0x0191;
  t['Fitacyrillic'] = 0x0472;
  t['Fiveroman'] = 0x2164;
  t['Fmonospace'] = 0xFF26;
  t['Fourroman'] = 0x2163;
  t['Fsmall'] = 0xF766;
  t['G'] = 0x0047;
  t['GBsquare'] = 0x3387;
  t['Gacute'] = 0x01F4;
  t['Gamma'] = 0x0393;
  t['Gammaafrican'] = 0x0194;
  t['Gangiacoptic'] = 0x03EA;
  t['Gbreve'] = 0x011E;
  t['Gcaron'] = 0x01E6;
  t['Gcedilla'] = 0x0122;
  t['Gcircle'] = 0x24BC;
  t['Gcircumflex'] = 0x011C;
  t['Gcommaaccent'] = 0x0122;
  t['Gdot'] = 0x0120;
  t['Gdotaccent'] = 0x0120;
  t['Gecyrillic'] = 0x0413;
  t['Ghadarmenian'] = 0x0542;
  t['Ghemiddlehookcyrillic'] = 0x0494;
  t['Ghestrokecyrillic'] = 0x0492;
  t['Gheupturncyrillic'] = 0x0490;
  t['Ghook'] = 0x0193;
  t['Gimarmenian'] = 0x0533;
  t['Gjecyrillic'] = 0x0403;
  t['Gmacron'] = 0x1E20;
  t['Gmonospace'] = 0xFF27;
  t['Grave'] = 0xF6CE;
  t['Gravesmall'] = 0xF760;
  t['Gsmall'] = 0xF767;
  t['Gsmallhook'] = 0x029B;
  t['Gstroke'] = 0x01E4;
  t['H'] = 0x0048;
  t['H18533'] = 0x25CF;
  t['H18543'] = 0x25AA;
  t['H18551'] = 0x25AB;
  t['H22073'] = 0x25A1;
  t['HPsquare'] = 0x33CB;
  t['Haabkhasiancyrillic'] = 0x04A8;
  t['Hadescendercyrillic'] = 0x04B2;
  t['Hardsigncyrillic'] = 0x042A;
  t['Hbar'] = 0x0126;
  t['Hbrevebelow'] = 0x1E2A;
  t['Hcedilla'] = 0x1E28;
  t['Hcircle'] = 0x24BD;
  t['Hcircumflex'] = 0x0124;
  t['Hdieresis'] = 0x1E26;
  t['Hdotaccent'] = 0x1E22;
  t['Hdotbelow'] = 0x1E24;
  t['Hmonospace'] = 0xFF28;
  t['Hoarmenian'] = 0x0540;
  t['Horicoptic'] = 0x03E8;
  t['Hsmall'] = 0xF768;
  t['Hungarumlaut'] = 0xF6CF;
  t['Hungarumlautsmall'] = 0xF6F8;
  t['Hzsquare'] = 0x3390;
  t['I'] = 0x0049;
  t['IAcyrillic'] = 0x042F;
  t['IJ'] = 0x0132;
  t['IUcyrillic'] = 0x042E;
  t['Iacute'] = 0x00CD;
  t['Iacutesmall'] = 0xF7ED;
  t['Ibreve'] = 0x012C;
  t['Icaron'] = 0x01CF;
  t['Icircle'] = 0x24BE;
  t['Icircumflex'] = 0x00CE;
  t['Icircumflexsmall'] = 0xF7EE;
  t['Icyrillic'] = 0x0406;
  t['Idblgrave'] = 0x0208;
  t['Idieresis'] = 0x00CF;
  t['Idieresisacute'] = 0x1E2E;
  t['Idieresiscyrillic'] = 0x04E4;
  t['Idieresissmall'] = 0xF7EF;
  t['Idot'] = 0x0130;
  t['Idotaccent'] = 0x0130;
  t['Idotbelow'] = 0x1ECA;
  t['Iebrevecyrillic'] = 0x04D6;
  t['Iecyrillic'] = 0x0415;
  t['Ifraktur'] = 0x2111;
  t['Igrave'] = 0x00CC;
  t['Igravesmall'] = 0xF7EC;
  t['Ihookabove'] = 0x1EC8;
  t['Iicyrillic'] = 0x0418;
  t['Iinvertedbreve'] = 0x020A;
  t['Iishortcyrillic'] = 0x0419;
  t['Imacron'] = 0x012A;
  t['Imacroncyrillic'] = 0x04E2;
  t['Imonospace'] = 0xFF29;
  t['Iniarmenian'] = 0x053B;
  t['Iocyrillic'] = 0x0401;
  t['Iogonek'] = 0x012E;
  t['Iota'] = 0x0399;
  t['Iotaafrican'] = 0x0196;
  t['Iotadieresis'] = 0x03AA;
  t['Iotatonos'] = 0x038A;
  t['Ismall'] = 0xF769;
  t['Istroke'] = 0x0197;
  t['Itilde'] = 0x0128;
  t['Itildebelow'] = 0x1E2C;
  t['Izhitsacyrillic'] = 0x0474;
  t['Izhitsadblgravecyrillic'] = 0x0476;
  t['J'] = 0x004A;
  t['Jaarmenian'] = 0x0541;
  t['Jcircle'] = 0x24BF;
  t['Jcircumflex'] = 0x0134;
  t['Jecyrillic'] = 0x0408;
  t['Jheharmenian'] = 0x054B;
  t['Jmonospace'] = 0xFF2A;
  t['Jsmall'] = 0xF76A;
  t['K'] = 0x004B;
  t['KBsquare'] = 0x3385;
  t['KKsquare'] = 0x33CD;
  t['Kabashkircyrillic'] = 0x04A0;
  t['Kacute'] = 0x1E30;
  t['Kacyrillic'] = 0x041A;
  t['Kadescendercyrillic'] = 0x049A;
  t['Kahookcyrillic'] = 0x04C3;
  t['Kappa'] = 0x039A;
  t['Kastrokecyrillic'] = 0x049E;
  t['Kaverticalstrokecyrillic'] = 0x049C;
  t['Kcaron'] = 0x01E8;
  t['Kcedilla'] = 0x0136;
  t['Kcircle'] = 0x24C0;
  t['Kcommaaccent'] = 0x0136;
  t['Kdotbelow'] = 0x1E32;
  t['Keharmenian'] = 0x0554;
  t['Kenarmenian'] = 0x053F;
  t['Khacyrillic'] = 0x0425;
  t['Kheicoptic'] = 0x03E6;
  t['Khook'] = 0x0198;
  t['Kjecyrillic'] = 0x040C;
  t['Klinebelow'] = 0x1E34;
  t['Kmonospace'] = 0xFF2B;
  t['Koppacyrillic'] = 0x0480;
  t['Koppagreek'] = 0x03DE;
  t['Ksicyrillic'] = 0x046E;
  t['Ksmall'] = 0xF76B;
  t['L'] = 0x004C;
  t['LJ'] = 0x01C7;
  t['LL'] = 0xF6BF;
  t['Lacute'] = 0x0139;
  t['Lambda'] = 0x039B;
  t['Lcaron'] = 0x013D;
  t['Lcedilla'] = 0x013B;
  t['Lcircle'] = 0x24C1;
  t['Lcircumflexbelow'] = 0x1E3C;
  t['Lcommaaccent'] = 0x013B;
  t['Ldot'] = 0x013F;
  t['Ldotaccent'] = 0x013F;
  t['Ldotbelow'] = 0x1E36;
  t['Ldotbelowmacron'] = 0x1E38;
  t['Liwnarmenian'] = 0x053C;
  t['Lj'] = 0x01C8;
  t['Ljecyrillic'] = 0x0409;
  t['Llinebelow'] = 0x1E3A;
  t['Lmonospace'] = 0xFF2C;
  t['Lslash'] = 0x0141;
  t['Lslashsmall'] = 0xF6F9;
  t['Lsmall'] = 0xF76C;
  t['M'] = 0x004D;
  t['MBsquare'] = 0x3386;
  t['Macron'] = 0xF6D0;
  t['Macronsmall'] = 0xF7AF;
  t['Macute'] = 0x1E3E;
  t['Mcircle'] = 0x24C2;
  t['Mdotaccent'] = 0x1E40;
  t['Mdotbelow'] = 0x1E42;
  t['Menarmenian'] = 0x0544;
  t['Mmonospace'] = 0xFF2D;
  t['Msmall'] = 0xF76D;
  t['Mturned'] = 0x019C;
  t['Mu'] = 0x039C;
  t['N'] = 0x004E;
  t['NJ'] = 0x01CA;
  t['Nacute'] = 0x0143;
  t['Ncaron'] = 0x0147;
  t['Ncedilla'] = 0x0145;
  t['Ncircle'] = 0x24C3;
  t['Ncircumflexbelow'] = 0x1E4A;
  t['Ncommaaccent'] = 0x0145;
  t['Ndotaccent'] = 0x1E44;
  t['Ndotbelow'] = 0x1E46;
  t['Nhookleft'] = 0x019D;
  t['Nineroman'] = 0x2168;
  t['Nj'] = 0x01CB;
  t['Njecyrillic'] = 0x040A;
  t['Nlinebelow'] = 0x1E48;
  t['Nmonospace'] = 0xFF2E;
  t['Nowarmenian'] = 0x0546;
  t['Nsmall'] = 0xF76E;
  t['Ntilde'] = 0x00D1;
  t['Ntildesmall'] = 0xF7F1;
  t['Nu'] = 0x039D;
  t['O'] = 0x004F;
  t['OE'] = 0x0152;
  t['OEsmall'] = 0xF6FA;
  t['Oacute'] = 0x00D3;
  t['Oacutesmall'] = 0xF7F3;
  t['Obarredcyrillic'] = 0x04E8;
  t['Obarreddieresiscyrillic'] = 0x04EA;
  t['Obreve'] = 0x014E;
  t['Ocaron'] = 0x01D1;
  t['Ocenteredtilde'] = 0x019F;
  t['Ocircle'] = 0x24C4;
  t['Ocircumflex'] = 0x00D4;
  t['Ocircumflexacute'] = 0x1ED0;
  t['Ocircumflexdotbelow'] = 0x1ED8;
  t['Ocircumflexgrave'] = 0x1ED2;
  t['Ocircumflexhookabove'] = 0x1ED4;
  t['Ocircumflexsmall'] = 0xF7F4;
  t['Ocircumflextilde'] = 0x1ED6;
  t['Ocyrillic'] = 0x041E;
  t['Odblacute'] = 0x0150;
  t['Odblgrave'] = 0x020C;
  t['Odieresis'] = 0x00D6;
  t['Odieresiscyrillic'] = 0x04E6;
  t['Odieresissmall'] = 0xF7F6;
  t['Odotbelow'] = 0x1ECC;
  t['Ogoneksmall'] = 0xF6FB;
  t['Ograve'] = 0x00D2;
  t['Ogravesmall'] = 0xF7F2;
  t['Oharmenian'] = 0x0555;
  t['Ohm'] = 0x2126;
  t['Ohookabove'] = 0x1ECE;
  t['Ohorn'] = 0x01A0;
  t['Ohornacute'] = 0x1EDA;
  t['Ohorndotbelow'] = 0x1EE2;
  t['Ohorngrave'] = 0x1EDC;
  t['Ohornhookabove'] = 0x1EDE;
  t['Ohorntilde'] = 0x1EE0;
  t['Ohungarumlaut'] = 0x0150;
  t['Oi'] = 0x01A2;
  t['Oinvertedbreve'] = 0x020E;
  t['Omacron'] = 0x014C;
  t['Omacronacute'] = 0x1E52;
  t['Omacrongrave'] = 0x1E50;
  t['Omega'] = 0x2126;
  t['Omegacyrillic'] = 0x0460;
  t['Omegagreek'] = 0x03A9;
  t['Omegaroundcyrillic'] = 0x047A;
  t['Omegatitlocyrillic'] = 0x047C;
  t['Omegatonos'] = 0x038F;
  t['Omicron'] = 0x039F;
  t['Omicrontonos'] = 0x038C;
  t['Omonospace'] = 0xFF2F;
  t['Oneroman'] = 0x2160;
  t['Oogonek'] = 0x01EA;
  t['Oogonekmacron'] = 0x01EC;
  t['Oopen'] = 0x0186;
  t['Oslash'] = 0x00D8;
  t['Oslashacute'] = 0x01FE;
  t['Oslashsmall'] = 0xF7F8;
  t['Osmall'] = 0xF76F;
  t['Ostrokeacute'] = 0x01FE;
  t['Otcyrillic'] = 0x047E;
  t['Otilde'] = 0x00D5;
  t['Otildeacute'] = 0x1E4C;
  t['Otildedieresis'] = 0x1E4E;
  t['Otildesmall'] = 0xF7F5;
  t['P'] = 0x0050;
  t['Pacute'] = 0x1E54;
  t['Pcircle'] = 0x24C5;
  t['Pdotaccent'] = 0x1E56;
  t['Pecyrillic'] = 0x041F;
  t['Peharmenian'] = 0x054A;
  t['Pemiddlehookcyrillic'] = 0x04A6;
  t['Phi'] = 0x03A6;
  t['Phook'] = 0x01A4;
  t['Pi'] = 0x03A0;
  t['Piwrarmenian'] = 0x0553;
  t['Pmonospace'] = 0xFF30;
  t['Psi'] = 0x03A8;
  t['Psicyrillic'] = 0x0470;
  t['Psmall'] = 0xF770;
  t['Q'] = 0x0051;
  t['Qcircle'] = 0x24C6;
  t['Qmonospace'] = 0xFF31;
  t['Qsmall'] = 0xF771;
  t['R'] = 0x0052;
  t['Raarmenian'] = 0x054C;
  t['Racute'] = 0x0154;
  t['Rcaron'] = 0x0158;
  t['Rcedilla'] = 0x0156;
  t['Rcircle'] = 0x24C7;
  t['Rcommaaccent'] = 0x0156;
  t['Rdblgrave'] = 0x0210;
  t['Rdotaccent'] = 0x1E58;
  t['Rdotbelow'] = 0x1E5A;
  t['Rdotbelowmacron'] = 0x1E5C;
  t['Reharmenian'] = 0x0550;
  t['Rfraktur'] = 0x211C;
  t['Rho'] = 0x03A1;
  t['Ringsmall'] = 0xF6FC;
  t['Rinvertedbreve'] = 0x0212;
  t['Rlinebelow'] = 0x1E5E;
  t['Rmonospace'] = 0xFF32;
  t['Rsmall'] = 0xF772;
  t['Rsmallinverted'] = 0x0281;
  t['Rsmallinvertedsuperior'] = 0x02B6;
  t['S'] = 0x0053;
  t['SF010000'] = 0x250C;
  t['SF020000'] = 0x2514;
  t['SF030000'] = 0x2510;
  t['SF040000'] = 0x2518;
  t['SF050000'] = 0x253C;
  t['SF060000'] = 0x252C;
  t['SF070000'] = 0x2534;
  t['SF080000'] = 0x251C;
  t['SF090000'] = 0x2524;
  t['SF100000'] = 0x2500;
  t['SF110000'] = 0x2502;
  t['SF190000'] = 0x2561;
  t['SF200000'] = 0x2562;
  t['SF210000'] = 0x2556;
  t['SF220000'] = 0x2555;
  t['SF230000'] = 0x2563;
  t['SF240000'] = 0x2551;
  t['SF250000'] = 0x2557;
  t['SF260000'] = 0x255D;
  t['SF270000'] = 0x255C;
  t['SF280000'] = 0x255B;
  t['SF360000'] = 0x255E;
  t['SF370000'] = 0x255F;
  t['SF380000'] = 0x255A;
  t['SF390000'] = 0x2554;
  t['SF400000'] = 0x2569;
  t['SF410000'] = 0x2566;
  t['SF420000'] = 0x2560;
  t['SF430000'] = 0x2550;
  t['SF440000'] = 0x256C;
  t['SF450000'] = 0x2567;
  t['SF460000'] = 0x2568;
  t['SF470000'] = 0x2564;
  t['SF480000'] = 0x2565;
  t['SF490000'] = 0x2559;
  t['SF500000'] = 0x2558;
  t['SF510000'] = 0x2552;
  t['SF520000'] = 0x2553;
  t['SF530000'] = 0x256B;
  t['SF540000'] = 0x256A;
  t['Sacute'] = 0x015A;
  t['Sacutedotaccent'] = 0x1E64;
  t['Sampigreek'] = 0x03E0;
  t['Scaron'] = 0x0160;
  t['Scarondotaccent'] = 0x1E66;
  t['Scaronsmall'] = 0xF6FD;
  t['Scedilla'] = 0x015E;
  t['Schwa'] = 0x018F;
  t['Schwacyrillic'] = 0x04D8;
  t['Schwadieresiscyrillic'] = 0x04DA;
  t['Scircle'] = 0x24C8;
  t['Scircumflex'] = 0x015C;
  t['Scommaaccent'] = 0x0218;
  t['Sdotaccent'] = 0x1E60;
  t['Sdotbelow'] = 0x1E62;
  t['Sdotbelowdotaccent'] = 0x1E68;
  t['Seharmenian'] = 0x054D;
  t['Sevenroman'] = 0x2166;
  t['Shaarmenian'] = 0x0547;
  t['Shacyrillic'] = 0x0428;
  t['Shchacyrillic'] = 0x0429;
  t['Sheicoptic'] = 0x03E2;
  t['Shhacyrillic'] = 0x04BA;
  t['Shimacoptic'] = 0x03EC;
  t['Sigma'] = 0x03A3;
  t['Sixroman'] = 0x2165;
  t['Smonospace'] = 0xFF33;
  t['Softsigncyrillic'] = 0x042C;
  t['Ssmall'] = 0xF773;
  t['Stigmagreek'] = 0x03DA;
  t['T'] = 0x0054;
  t['Tau'] = 0x03A4;
  t['Tbar'] = 0x0166;
  t['Tcaron'] = 0x0164;
  t['Tcedilla'] = 0x0162;
  t['Tcircle'] = 0x24C9;
  t['Tcircumflexbelow'] = 0x1E70;
  t['Tcommaaccent'] = 0x0162;
  t['Tdotaccent'] = 0x1E6A;
  t['Tdotbelow'] = 0x1E6C;
  t['Tecyrillic'] = 0x0422;
  t['Tedescendercyrillic'] = 0x04AC;
  t['Tenroman'] = 0x2169;
  t['Tetsecyrillic'] = 0x04B4;
  t['Theta'] = 0x0398;
  t['Thook'] = 0x01AC;
  t['Thorn'] = 0x00DE;
  t['Thornsmall'] = 0xF7FE;
  t['Threeroman'] = 0x2162;
  t['Tildesmall'] = 0xF6FE;
  t['Tiwnarmenian'] = 0x054F;
  t['Tlinebelow'] = 0x1E6E;
  t['Tmonospace'] = 0xFF34;
  t['Toarmenian'] = 0x0539;
  t['Tonefive'] = 0x01BC;
  t['Tonesix'] = 0x0184;
  t['Tonetwo'] = 0x01A7;
  t['Tretroflexhook'] = 0x01AE;
  t['Tsecyrillic'] = 0x0426;
  t['Tshecyrillic'] = 0x040B;
  t['Tsmall'] = 0xF774;
  t['Twelveroman'] = 0x216B;
  t['Tworoman'] = 0x2161;
  t['U'] = 0x0055;
  t['Uacute'] = 0x00DA;
  t['Uacutesmall'] = 0xF7FA;
  t['Ubreve'] = 0x016C;
  t['Ucaron'] = 0x01D3;
  t['Ucircle'] = 0x24CA;
  t['Ucircumflex'] = 0x00DB;
  t['Ucircumflexbelow'] = 0x1E76;
  t['Ucircumflexsmall'] = 0xF7FB;
  t['Ucyrillic'] = 0x0423;
  t['Udblacute'] = 0x0170;
  t['Udblgrave'] = 0x0214;
  t['Udieresis'] = 0x00DC;
  t['Udieresisacute'] = 0x01D7;
  t['Udieresisbelow'] = 0x1E72;
  t['Udieresiscaron'] = 0x01D9;
  t['Udieresiscyrillic'] = 0x04F0;
  t['Udieresisgrave'] = 0x01DB;
  t['Udieresismacron'] = 0x01D5;
  t['Udieresissmall'] = 0xF7FC;
  t['Udotbelow'] = 0x1EE4;
  t['Ugrave'] = 0x00D9;
  t['Ugravesmall'] = 0xF7F9;
  t['Uhookabove'] = 0x1EE6;
  t['Uhorn'] = 0x01AF;
  t['Uhornacute'] = 0x1EE8;
  t['Uhorndotbelow'] = 0x1EF0;
  t['Uhorngrave'] = 0x1EEA;
  t['Uhornhookabove'] = 0x1EEC;
  t['Uhorntilde'] = 0x1EEE;
  t['Uhungarumlaut'] = 0x0170;
  t['Uhungarumlautcyrillic'] = 0x04F2;
  t['Uinvertedbreve'] = 0x0216;
  t['Ukcyrillic'] = 0x0478;
  t['Umacron'] = 0x016A;
  t['Umacroncyrillic'] = 0x04EE;
  t['Umacrondieresis'] = 0x1E7A;
  t['Umonospace'] = 0xFF35;
  t['Uogonek'] = 0x0172;
  t['Upsilon'] = 0x03A5;
  t['Upsilon1'] = 0x03D2;
  t['Upsilonacutehooksymbolgreek'] = 0x03D3;
  t['Upsilonafrican'] = 0x01B1;
  t['Upsilondieresis'] = 0x03AB;
  t['Upsilondieresishooksymbolgreek'] = 0x03D4;
  t['Upsilonhooksymbol'] = 0x03D2;
  t['Upsilontonos'] = 0x038E;
  t['Uring'] = 0x016E;
  t['Ushortcyrillic'] = 0x040E;
  t['Usmall'] = 0xF775;
  t['Ustraightcyrillic'] = 0x04AE;
  t['Ustraightstrokecyrillic'] = 0x04B0;
  t['Utilde'] = 0x0168;
  t['Utildeacute'] = 0x1E78;
  t['Utildebelow'] = 0x1E74;
  t['V'] = 0x0056;
  t['Vcircle'] = 0x24CB;
  t['Vdotbelow'] = 0x1E7E;
  t['Vecyrillic'] = 0x0412;
  t['Vewarmenian'] = 0x054E;
  t['Vhook'] = 0x01B2;
  t['Vmonospace'] = 0xFF36;
  t['Voarmenian'] = 0x0548;
  t['Vsmall'] = 0xF776;
  t['Vtilde'] = 0x1E7C;
  t['W'] = 0x0057;
  t['Wacute'] = 0x1E82;
  t['Wcircle'] = 0x24CC;
  t['Wcircumflex'] = 0x0174;
  t['Wdieresis'] = 0x1E84;
  t['Wdotaccent'] = 0x1E86;
  t['Wdotbelow'] = 0x1E88;
  t['Wgrave'] = 0x1E80;
  t['Wmonospace'] = 0xFF37;
  t['Wsmall'] = 0xF777;
  t['X'] = 0x0058;
  t['Xcircle'] = 0x24CD;
  t['Xdieresis'] = 0x1E8C;
  t['Xdotaccent'] = 0x1E8A;
  t['Xeharmenian'] = 0x053D;
  t['Xi'] = 0x039E;
  t['Xmonospace'] = 0xFF38;
  t['Xsmall'] = 0xF778;
  t['Y'] = 0x0059;
  t['Yacute'] = 0x00DD;
  t['Yacutesmall'] = 0xF7FD;
  t['Yatcyrillic'] = 0x0462;
  t['Ycircle'] = 0x24CE;
  t['Ycircumflex'] = 0x0176;
  t['Ydieresis'] = 0x0178;
  t['Ydieresissmall'] = 0xF7FF;
  t['Ydotaccent'] = 0x1E8E;
  t['Ydotbelow'] = 0x1EF4;
  t['Yericyrillic'] = 0x042B;
  t['Yerudieresiscyrillic'] = 0x04F8;
  t['Ygrave'] = 0x1EF2;
  t['Yhook'] = 0x01B3;
  t['Yhookabove'] = 0x1EF6;
  t['Yiarmenian'] = 0x0545;
  t['Yicyrillic'] = 0x0407;
  t['Yiwnarmenian'] = 0x0552;
  t['Ymonospace'] = 0xFF39;
  t['Ysmall'] = 0xF779;
  t['Ytilde'] = 0x1EF8;
  t['Yusbigcyrillic'] = 0x046A;
  t['Yusbigiotifiedcyrillic'] = 0x046C;
  t['Yuslittlecyrillic'] = 0x0466;
  t['Yuslittleiotifiedcyrillic'] = 0x0468;
  t['Z'] = 0x005A;
  t['Zaarmenian'] = 0x0536;
  t['Zacute'] = 0x0179;
  t['Zcaron'] = 0x017D;
  t['Zcaronsmall'] = 0xF6FF;
  t['Zcircle'] = 0x24CF;
  t['Zcircumflex'] = 0x1E90;
  t['Zdot'] = 0x017B;
  t['Zdotaccent'] = 0x017B;
  t['Zdotbelow'] = 0x1E92;
  t['Zecyrillic'] = 0x0417;
  t['Zedescendercyrillic'] = 0x0498;
  t['Zedieresiscyrillic'] = 0x04DE;
  t['Zeta'] = 0x0396;
  t['Zhearmenian'] = 0x053A;
  t['Zhebrevecyrillic'] = 0x04C1;
  t['Zhecyrillic'] = 0x0416;
  t['Zhedescendercyrillic'] = 0x0496;
  t['Zhedieresiscyrillic'] = 0x04DC;
  t['Zlinebelow'] = 0x1E94;
  t['Zmonospace'] = 0xFF3A;
  t['Zsmall'] = 0xF77A;
  t['Zstroke'] = 0x01B5;
  t['a'] = 0x0061;
  t['aabengali'] = 0x0986;
  t['aacute'] = 0x00E1;
  t['aadeva'] = 0x0906;
  t['aagujarati'] = 0x0A86;
  t['aagurmukhi'] = 0x0A06;
  t['aamatragurmukhi'] = 0x0A3E;
  t['aarusquare'] = 0x3303;
  t['aavowelsignbengali'] = 0x09BE;
  t['aavowelsigndeva'] = 0x093E;
  t['aavowelsigngujarati'] = 0x0ABE;
  t['abbreviationmarkarmenian'] = 0x055F;
  t['abbreviationsigndeva'] = 0x0970;
  t['abengali'] = 0x0985;
  t['abopomofo'] = 0x311A;
  t['abreve'] = 0x0103;
  t['abreveacute'] = 0x1EAF;
  t['abrevecyrillic'] = 0x04D1;
  t['abrevedotbelow'] = 0x1EB7;
  t['abrevegrave'] = 0x1EB1;
  t['abrevehookabove'] = 0x1EB3;
  t['abrevetilde'] = 0x1EB5;
  t['acaron'] = 0x01CE;
  t['acircle'] = 0x24D0;
  t['acircumflex'] = 0x00E2;
  t['acircumflexacute'] = 0x1EA5;
  t['acircumflexdotbelow'] = 0x1EAD;
  t['acircumflexgrave'] = 0x1EA7;
  t['acircumflexhookabove'] = 0x1EA9;
  t['acircumflextilde'] = 0x1EAB;
  t['acute'] = 0x00B4;
  t['acutebelowcmb'] = 0x0317;
  t['acutecmb'] = 0x0301;
  t['acutecomb'] = 0x0301;
  t['acutedeva'] = 0x0954;
  t['acutelowmod'] = 0x02CF;
  t['acutetonecmb'] = 0x0341;
  t['acyrillic'] = 0x0430;
  t['adblgrave'] = 0x0201;
  t['addakgurmukhi'] = 0x0A71;
  t['adeva'] = 0x0905;
  t['adieresis'] = 0x00E4;
  t['adieresiscyrillic'] = 0x04D3;
  t['adieresismacron'] = 0x01DF;
  t['adotbelow'] = 0x1EA1;
  t['adotmacron'] = 0x01E1;
  t['ae'] = 0x00E6;
  t['aeacute'] = 0x01FD;
  t['aekorean'] = 0x3150;
  t['aemacron'] = 0x01E3;
  t['afii00208'] = 0x2015;
  t['afii08941'] = 0x20A4;
  t['afii10017'] = 0x0410;
  t['afii10018'] = 0x0411;
  t['afii10019'] = 0x0412;
  t['afii10020'] = 0x0413;
  t['afii10021'] = 0x0414;
  t['afii10022'] = 0x0415;
  t['afii10023'] = 0x0401;
  t['afii10024'] = 0x0416;
  t['afii10025'] = 0x0417;
  t['afii10026'] = 0x0418;
  t['afii10027'] = 0x0419;
  t['afii10028'] = 0x041A;
  t['afii10029'] = 0x041B;
  t['afii10030'] = 0x041C;
  t['afii10031'] = 0x041D;
  t['afii10032'] = 0x041E;
  t['afii10033'] = 0x041F;
  t['afii10034'] = 0x0420;
  t['afii10035'] = 0x0421;
  t['afii10036'] = 0x0422;
  t['afii10037'] = 0x0423;
  t['afii10038'] = 0x0424;
  t['afii10039'] = 0x0425;
  t['afii10040'] = 0x0426;
  t['afii10041'] = 0x0427;
  t['afii10042'] = 0x0428;
  t['afii10043'] = 0x0429;
  t['afii10044'] = 0x042A;
  t['afii10045'] = 0x042B;
  t['afii10046'] = 0x042C;
  t['afii10047'] = 0x042D;
  t['afii10048'] = 0x042E;
  t['afii10049'] = 0x042F;
  t['afii10050'] = 0x0490;
  t['afii10051'] = 0x0402;
  t['afii10052'] = 0x0403;
  t['afii10053'] = 0x0404;
  t['afii10054'] = 0x0405;
  t['afii10055'] = 0x0406;
  t['afii10056'] = 0x0407;
  t['afii10057'] = 0x0408;
  t['afii10058'] = 0x0409;
  t['afii10059'] = 0x040A;
  t['afii10060'] = 0x040B;
  t['afii10061'] = 0x040C;
  t['afii10062'] = 0x040E;
  t['afii10063'] = 0xF6C4;
  t['afii10064'] = 0xF6C5;
  t['afii10065'] = 0x0430;
  t['afii10066'] = 0x0431;
  t['afii10067'] = 0x0432;
  t['afii10068'] = 0x0433;
  t['afii10069'] = 0x0434;
  t['afii10070'] = 0x0435;
  t['afii10071'] = 0x0451;
  t['afii10072'] = 0x0436;
  t['afii10073'] = 0x0437;
  t['afii10074'] = 0x0438;
  t['afii10075'] = 0x0439;
  t['afii10076'] = 0x043A;
  t['afii10077'] = 0x043B;
  t['afii10078'] = 0x043C;
  t['afii10079'] = 0x043D;
  t['afii10080'] = 0x043E;
  t['afii10081'] = 0x043F;
  t['afii10082'] = 0x0440;
  t['afii10083'] = 0x0441;
  t['afii10084'] = 0x0442;
  t['afii10085'] = 0x0443;
  t['afii10086'] = 0x0444;
  t['afii10087'] = 0x0445;
  t['afii10088'] = 0x0446;
  t['afii10089'] = 0x0447;
  t['afii10090'] = 0x0448;
  t['afii10091'] = 0x0449;
  t['afii10092'] = 0x044A;
  t['afii10093'] = 0x044B;
  t['afii10094'] = 0x044C;
  t['afii10095'] = 0x044D;
  t['afii10096'] = 0x044E;
  t['afii10097'] = 0x044F;
  t['afii10098'] = 0x0491;
  t['afii10099'] = 0x0452;
  t['afii10100'] = 0x0453;
  t['afii10101'] = 0x0454;
  t['afii10102'] = 0x0455;
  t['afii10103'] = 0x0456;
  t['afii10104'] = 0x0457;
  t['afii10105'] = 0x0458;
  t['afii10106'] = 0x0459;
  t['afii10107'] = 0x045A;
  t['afii10108'] = 0x045B;
  t['afii10109'] = 0x045C;
  t['afii10110'] = 0x045E;
  t['afii10145'] = 0x040F;
  t['afii10146'] = 0x0462;
  t['afii10147'] = 0x0472;
  t['afii10148'] = 0x0474;
  t['afii10192'] = 0xF6C6;
  t['afii10193'] = 0x045F;
  t['afii10194'] = 0x0463;
  t['afii10195'] = 0x0473;
  t['afii10196'] = 0x0475;
  t['afii10831'] = 0xF6C7;
  t['afii10832'] = 0xF6C8;
  t['afii10846'] = 0x04D9;
  t['afii299'] = 0x200E;
  t['afii300'] = 0x200F;
  t['afii301'] = 0x200D;
  t['afii57381'] = 0x066A;
  t['afii57388'] = 0x060C;
  t['afii57392'] = 0x0660;
  t['afii57393'] = 0x0661;
  t['afii57394'] = 0x0662;
  t['afii57395'] = 0x0663;
  t['afii57396'] = 0x0664;
  t['afii57397'] = 0x0665;
  t['afii57398'] = 0x0666;
  t['afii57399'] = 0x0667;
  t['afii57400'] = 0x0668;
  t['afii57401'] = 0x0669;
  t['afii57403'] = 0x061B;
  t['afii57407'] = 0x061F;
  t['afii57409'] = 0x0621;
  t['afii57410'] = 0x0622;
  t['afii57411'] = 0x0623;
  t['afii57412'] = 0x0624;
  t['afii57413'] = 0x0625;
  t['afii57414'] = 0x0626;
  t['afii57415'] = 0x0627;
  t['afii57416'] = 0x0628;
  t['afii57417'] = 0x0629;
  t['afii57418'] = 0x062A;
  t['afii57419'] = 0x062B;
  t['afii57420'] = 0x062C;
  t['afii57421'] = 0x062D;
  t['afii57422'] = 0x062E;
  t['afii57423'] = 0x062F;
  t['afii57424'] = 0x0630;
  t['afii57425'] = 0x0631;
  t['afii57426'] = 0x0632;
  t['afii57427'] = 0x0633;
  t['afii57428'] = 0x0634;
  t['afii57429'] = 0x0635;
  t['afii57430'] = 0x0636;
  t['afii57431'] = 0x0637;
  t['afii57432'] = 0x0638;
  t['afii57433'] = 0x0639;
  t['afii57434'] = 0x063A;
  t['afii57440'] = 0x0640;
  t['afii57441'] = 0x0641;
  t['afii57442'] = 0x0642;
  t['afii57443'] = 0x0643;
  t['afii57444'] = 0x0644;
  t['afii57445'] = 0x0645;
  t['afii57446'] = 0x0646;
  t['afii57448'] = 0x0648;
  t['afii57449'] = 0x0649;
  t['afii57450'] = 0x064A;
  t['afii57451'] = 0x064B;
  t['afii57452'] = 0x064C;
  t['afii57453'] = 0x064D;
  t['afii57454'] = 0x064E;
  t['afii57455'] = 0x064F;
  t['afii57456'] = 0x0650;
  t['afii57457'] = 0x0651;
  t['afii57458'] = 0x0652;
  t['afii57470'] = 0x0647;
  t['afii57505'] = 0x06A4;
  t['afii57506'] = 0x067E;
  t['afii57507'] = 0x0686;
  t['afii57508'] = 0x0698;
  t['afii57509'] = 0x06AF;
  t['afii57511'] = 0x0679;
  t['afii57512'] = 0x0688;
  t['afii57513'] = 0x0691;
  t['afii57514'] = 0x06BA;
  t['afii57519'] = 0x06D2;
  t['afii57534'] = 0x06D5;
  t['afii57636'] = 0x20AA;
  t['afii57645'] = 0x05BE;
  t['afii57658'] = 0x05C3;
  t['afii57664'] = 0x05D0;
  t['afii57665'] = 0x05D1;
  t['afii57666'] = 0x05D2;
  t['afii57667'] = 0x05D3;
  t['afii57668'] = 0x05D4;
  t['afii57669'] = 0x05D5;
  t['afii57670'] = 0x05D6;
  t['afii57671'] = 0x05D7;
  t['afii57672'] = 0x05D8;
  t['afii57673'] = 0x05D9;
  t['afii57674'] = 0x05DA;
  t['afii57675'] = 0x05DB;
  t['afii57676'] = 0x05DC;
  t['afii57677'] = 0x05DD;
  t['afii57678'] = 0x05DE;
  t['afii57679'] = 0x05DF;
  t['afii57680'] = 0x05E0;
  t['afii57681'] = 0x05E1;
  t['afii57682'] = 0x05E2;
  t['afii57683'] = 0x05E3;
  t['afii57684'] = 0x05E4;
  t['afii57685'] = 0x05E5;
  t['afii57686'] = 0x05E6;
  t['afii57687'] = 0x05E7;
  t['afii57688'] = 0x05E8;
  t['afii57689'] = 0x05E9;
  t['afii57690'] = 0x05EA;
  t['afii57694'] = 0xFB2A;
  t['afii57695'] = 0xFB2B;
  t['afii57700'] = 0xFB4B;
  t['afii57705'] = 0xFB1F;
  t['afii57716'] = 0x05F0;
  t['afii57717'] = 0x05F1;
  t['afii57718'] = 0x05F2;
  t['afii57723'] = 0xFB35;
  t['afii57793'] = 0x05B4;
  t['afii57794'] = 0x05B5;
  t['afii57795'] = 0x05B6;
  t['afii57796'] = 0x05BB;
  t['afii57797'] = 0x05B8;
  t['afii57798'] = 0x05B7;
  t['afii57799'] = 0x05B0;
  t['afii57800'] = 0x05B2;
  t['afii57801'] = 0x05B1;
  t['afii57802'] = 0x05B3;
  t['afii57803'] = 0x05C2;
  t['afii57804'] = 0x05C1;
  t['afii57806'] = 0x05B9;
  t['afii57807'] = 0x05BC;
  t['afii57839'] = 0x05BD;
  t['afii57841'] = 0x05BF;
  t['afii57842'] = 0x05C0;
  t['afii57929'] = 0x02BC;
  t['afii61248'] = 0x2105;
  t['afii61289'] = 0x2113;
  t['afii61352'] = 0x2116;
  t['afii61573'] = 0x202C;
  t['afii61574'] = 0x202D;
  t['afii61575'] = 0x202E;
  t['afii61664'] = 0x200C;
  t['afii63167'] = 0x066D;
  t['afii64937'] = 0x02BD;
  t['agrave'] = 0x00E0;
  t['agujarati'] = 0x0A85;
  t['agurmukhi'] = 0x0A05;
  t['ahiragana'] = 0x3042;
  t['ahookabove'] = 0x1EA3;
  t['aibengali'] = 0x0990;
  t['aibopomofo'] = 0x311E;
  t['aideva'] = 0x0910;
  t['aiecyrillic'] = 0x04D5;
  t['aigujarati'] = 0x0A90;
  t['aigurmukhi'] = 0x0A10;
  t['aimatragurmukhi'] = 0x0A48;
  t['ainarabic'] = 0x0639;
  t['ainfinalarabic'] = 0xFECA;
  t['aininitialarabic'] = 0xFECB;
  t['ainmedialarabic'] = 0xFECC;
  t['ainvertedbreve'] = 0x0203;
  t['aivowelsignbengali'] = 0x09C8;
  t['aivowelsigndeva'] = 0x0948;
  t['aivowelsigngujarati'] = 0x0AC8;
  t['akatakana'] = 0x30A2;
  t['akatakanahalfwidth'] = 0xFF71;
  t['akorean'] = 0x314F;
  t['alef'] = 0x05D0;
  t['alefarabic'] = 0x0627;
  t['alefdageshhebrew'] = 0xFB30;
  t['aleffinalarabic'] = 0xFE8E;
  t['alefhamzaabovearabic'] = 0x0623;
  t['alefhamzaabovefinalarabic'] = 0xFE84;
  t['alefhamzabelowarabic'] = 0x0625;
  t['alefhamzabelowfinalarabic'] = 0xFE88;
  t['alefhebrew'] = 0x05D0;
  t['aleflamedhebrew'] = 0xFB4F;
  t['alefmaddaabovearabic'] = 0x0622;
  t['alefmaddaabovefinalarabic'] = 0xFE82;
  t['alefmaksuraarabic'] = 0x0649;
  t['alefmaksurafinalarabic'] = 0xFEF0;
  t['alefmaksurainitialarabic'] = 0xFEF3;
  t['alefmaksuramedialarabic'] = 0xFEF4;
  t['alefpatahhebrew'] = 0xFB2E;
  t['alefqamatshebrew'] = 0xFB2F;
  t['aleph'] = 0x2135;
  t['allequal'] = 0x224C;
  t['alpha'] = 0x03B1;
  t['alphatonos'] = 0x03AC;
  t['amacron'] = 0x0101;
  t['amonospace'] = 0xFF41;
  t['ampersand'] = 0x0026;
  t['ampersandmonospace'] = 0xFF06;
  t['ampersandsmall'] = 0xF726;
  t['amsquare'] = 0x33C2;
  t['anbopomofo'] = 0x3122;
  t['angbopomofo'] = 0x3124;
  t['angbracketleft'] = 0x3008; // Glyph is missing from Adobe's original list.
  t['angbracketright'] = 0x3009; // Glyph is missing from Adobe's original list.
  t['angkhankhuthai'] = 0x0E5A;
  t['angle'] = 0x2220;
  t['anglebracketleft'] = 0x3008;
  t['anglebracketleftvertical'] = 0xFE3F;
  t['anglebracketright'] = 0x3009;
  t['anglebracketrightvertical'] = 0xFE40;
  t['angleleft'] = 0x2329;
  t['angleright'] = 0x232A;
  t['angstrom'] = 0x212B;
  t['anoteleia'] = 0x0387;
  t['anudattadeva'] = 0x0952;
  t['anusvarabengali'] = 0x0982;
  t['anusvaradeva'] = 0x0902;
  t['anusvaragujarati'] = 0x0A82;
  t['aogonek'] = 0x0105;
  t['apaatosquare'] = 0x3300;
  t['aparen'] = 0x249C;
  t['apostrophearmenian'] = 0x055A;
  t['apostrophemod'] = 0x02BC;
  t['apple'] = 0xF8FF;
  t['approaches'] = 0x2250;
  t['approxequal'] = 0x2248;
  t['approxequalorimage'] = 0x2252;
  t['approximatelyequal'] = 0x2245;
  t['araeaekorean'] = 0x318E;
  t['araeakorean'] = 0x318D;
  t['arc'] = 0x2312;
  t['arighthalfring'] = 0x1E9A;
  t['aring'] = 0x00E5;
  t['aringacute'] = 0x01FB;
  t['aringbelow'] = 0x1E01;
  t['arrowboth'] = 0x2194;
  t['arrowdashdown'] = 0x21E3;
  t['arrowdashleft'] = 0x21E0;
  t['arrowdashright'] = 0x21E2;
  t['arrowdashup'] = 0x21E1;
  t['arrowdblboth'] = 0x21D4;
  t['arrowdbldown'] = 0x21D3;
  t['arrowdblleft'] = 0x21D0;
  t['arrowdblright'] = 0x21D2;
  t['arrowdblup'] = 0x21D1;
  t['arrowdown'] = 0x2193;
  t['arrowdownleft'] = 0x2199;
  t['arrowdownright'] = 0x2198;
  t['arrowdownwhite'] = 0x21E9;
  t['arrowheaddownmod'] = 0x02C5;
  t['arrowheadleftmod'] = 0x02C2;
  t['arrowheadrightmod'] = 0x02C3;
  t['arrowheadupmod'] = 0x02C4;
  t['arrowhorizex'] = 0xF8E7;
  t['arrowleft'] = 0x2190;
  t['arrowleftdbl'] = 0x21D0;
  t['arrowleftdblstroke'] = 0x21CD;
  t['arrowleftoverright'] = 0x21C6;
  t['arrowleftwhite'] = 0x21E6;
  t['arrowright'] = 0x2192;
  t['arrowrightdblstroke'] = 0x21CF;
  t['arrowrightheavy'] = 0x279E;
  t['arrowrightoverleft'] = 0x21C4;
  t['arrowrightwhite'] = 0x21E8;
  t['arrowtableft'] = 0x21E4;
  t['arrowtabright'] = 0x21E5;
  t['arrowup'] = 0x2191;
  t['arrowupdn'] = 0x2195;
  t['arrowupdnbse'] = 0x21A8;
  t['arrowupdownbase'] = 0x21A8;
  t['arrowupleft'] = 0x2196;
  t['arrowupleftofdown'] = 0x21C5;
  t['arrowupright'] = 0x2197;
  t['arrowupwhite'] = 0x21E7;
  t['arrowvertex'] = 0xF8E6;
  t['asciicircum'] = 0x005E;
  t['asciicircummonospace'] = 0xFF3E;
  t['asciitilde'] = 0x007E;
  t['asciitildemonospace'] = 0xFF5E;
  t['ascript'] = 0x0251;
  t['ascriptturned'] = 0x0252;
  t['asmallhiragana'] = 0x3041;
  t['asmallkatakana'] = 0x30A1;
  t['asmallkatakanahalfwidth'] = 0xFF67;
  t['asterisk'] = 0x002A;
  t['asteriskaltonearabic'] = 0x066D;
  t['asteriskarabic'] = 0x066D;
  t['asteriskmath'] = 0x2217;
  t['asteriskmonospace'] = 0xFF0A;
  t['asterisksmall'] = 0xFE61;
  t['asterism'] = 0x2042;
  t['asuperior'] = 0xF6E9;
  t['asymptoticallyequal'] = 0x2243;
  t['at'] = 0x0040;
  t['atilde'] = 0x00E3;
  t['atmonospace'] = 0xFF20;
  t['atsmall'] = 0xFE6B;
  t['aturned'] = 0x0250;
  t['aubengali'] = 0x0994;
  t['aubopomofo'] = 0x3120;
  t['audeva'] = 0x0914;
  t['augujarati'] = 0x0A94;
  t['augurmukhi'] = 0x0A14;
  t['aulengthmarkbengali'] = 0x09D7;
  t['aumatragurmukhi'] = 0x0A4C;
  t['auvowelsignbengali'] = 0x09CC;
  t['auvowelsigndeva'] = 0x094C;
  t['auvowelsigngujarati'] = 0x0ACC;
  t['avagrahadeva'] = 0x093D;
  t['aybarmenian'] = 0x0561;
  t['ayin'] = 0x05E2;
  t['ayinaltonehebrew'] = 0xFB20;
  t['ayinhebrew'] = 0x05E2;
  t['b'] = 0x0062;
  t['babengali'] = 0x09AC;
  t['backslash'] = 0x005C;
  t['backslashmonospace'] = 0xFF3C;
  t['badeva'] = 0x092C;
  t['bagujarati'] = 0x0AAC;
  t['bagurmukhi'] = 0x0A2C;
  t['bahiragana'] = 0x3070;
  t['bahtthai'] = 0x0E3F;
  t['bakatakana'] = 0x30D0;
  t['bar'] = 0x007C;
  t['barmonospace'] = 0xFF5C;
  t['bbopomofo'] = 0x3105;
  t['bcircle'] = 0x24D1;
  t['bdotaccent'] = 0x1E03;
  t['bdotbelow'] = 0x1E05;
  t['beamedsixteenthnotes'] = 0x266C;
  t['because'] = 0x2235;
  t['becyrillic'] = 0x0431;
  t['beharabic'] = 0x0628;
  t['behfinalarabic'] = 0xFE90;
  t['behinitialarabic'] = 0xFE91;
  t['behiragana'] = 0x3079;
  t['behmedialarabic'] = 0xFE92;
  t['behmeeminitialarabic'] = 0xFC9F;
  t['behmeemisolatedarabic'] = 0xFC08;
  t['behnoonfinalarabic'] = 0xFC6D;
  t['bekatakana'] = 0x30D9;
  t['benarmenian'] = 0x0562;
  t['bet'] = 0x05D1;
  t['beta'] = 0x03B2;
  t['betasymbolgreek'] = 0x03D0;
  t['betdagesh'] = 0xFB31;
  t['betdageshhebrew'] = 0xFB31;
  t['bethebrew'] = 0x05D1;
  t['betrafehebrew'] = 0xFB4C;
  t['bhabengali'] = 0x09AD;
  t['bhadeva'] = 0x092D;
  t['bhagujarati'] = 0x0AAD;
  t['bhagurmukhi'] = 0x0A2D;
  t['bhook'] = 0x0253;
  t['bihiragana'] = 0x3073;
  t['bikatakana'] = 0x30D3;
  t['bilabialclick'] = 0x0298;
  t['bindigurmukhi'] = 0x0A02;
  t['birusquare'] = 0x3331;
  t['blackcircle'] = 0x25CF;
  t['blackdiamond'] = 0x25C6;
  t['blackdownpointingtriangle'] = 0x25BC;
  t['blackleftpointingpointer'] = 0x25C4;
  t['blackleftpointingtriangle'] = 0x25C0;
  t['blacklenticularbracketleft'] = 0x3010;
  t['blacklenticularbracketleftvertical'] = 0xFE3B;
  t['blacklenticularbracketright'] = 0x3011;
  t['blacklenticularbracketrightvertical'] = 0xFE3C;
  t['blacklowerlefttriangle'] = 0x25E3;
  t['blacklowerrighttriangle'] = 0x25E2;
  t['blackrectangle'] = 0x25AC;
  t['blackrightpointingpointer'] = 0x25BA;
  t['blackrightpointingtriangle'] = 0x25B6;
  t['blacksmallsquare'] = 0x25AA;
  t['blacksmilingface'] = 0x263B;
  t['blacksquare'] = 0x25A0;
  t['blackstar'] = 0x2605;
  t['blackupperlefttriangle'] = 0x25E4;
  t['blackupperrighttriangle'] = 0x25E5;
  t['blackuppointingsmalltriangle'] = 0x25B4;
  t['blackuppointingtriangle'] = 0x25B2;
  t['blank'] = 0x2423;
  t['blinebelow'] = 0x1E07;
  t['block'] = 0x2588;
  t['bmonospace'] = 0xFF42;
  t['bobaimaithai'] = 0x0E1A;
  t['bohiragana'] = 0x307C;
  t['bokatakana'] = 0x30DC;
  t['bparen'] = 0x249D;
  t['bqsquare'] = 0x33C3;
  t['braceex'] = 0xF8F4;
  t['braceleft'] = 0x007B;
  t['braceleftbt'] = 0xF8F3;
  t['braceleftmid'] = 0xF8F2;
  t['braceleftmonospace'] = 0xFF5B;
  t['braceleftsmall'] = 0xFE5B;
  t['bracelefttp'] = 0xF8F1;
  t['braceleftvertical'] = 0xFE37;
  t['braceright'] = 0x007D;
  t['bracerightbt'] = 0xF8FE;
  t['bracerightmid'] = 0xF8FD;
  t['bracerightmonospace'] = 0xFF5D;
  t['bracerightsmall'] = 0xFE5C;
  t['bracerighttp'] = 0xF8FC;
  t['bracerightvertical'] = 0xFE38;
  t['bracketleft'] = 0x005B;
  t['bracketleftbt'] = 0xF8F0;
  t['bracketleftex'] = 0xF8EF;
  t['bracketleftmonospace'] = 0xFF3B;
  t['bracketlefttp'] = 0xF8EE;
  t['bracketright'] = 0x005D;
  t['bracketrightbt'] = 0xF8FB;
  t['bracketrightex'] = 0xF8FA;
  t['bracketrightmonospace'] = 0xFF3D;
  t['bracketrighttp'] = 0xF8F9;
  t['breve'] = 0x02D8;
  t['brevebelowcmb'] = 0x032E;
  t['brevecmb'] = 0x0306;
  t['breveinvertedbelowcmb'] = 0x032F;
  t['breveinvertedcmb'] = 0x0311;
  t['breveinverteddoublecmb'] = 0x0361;
  t['bridgebelowcmb'] = 0x032A;
  t['bridgeinvertedbelowcmb'] = 0x033A;
  t['brokenbar'] = 0x00A6;
  t['bstroke'] = 0x0180;
  t['bsuperior'] = 0xF6EA;
  t['btopbar'] = 0x0183;
  t['buhiragana'] = 0x3076;
  t['bukatakana'] = 0x30D6;
  t['bullet'] = 0x2022;
  t['bulletinverse'] = 0x25D8;
  t['bulletoperator'] = 0x2219;
  t['bullseye'] = 0x25CE;
  t['c'] = 0x0063;
  t['caarmenian'] = 0x056E;
  t['cabengali'] = 0x099A;
  t['cacute'] = 0x0107;
  t['cadeva'] = 0x091A;
  t['cagujarati'] = 0x0A9A;
  t['cagurmukhi'] = 0x0A1A;
  t['calsquare'] = 0x3388;
  t['candrabindubengali'] = 0x0981;
  t['candrabinducmb'] = 0x0310;
  t['candrabindudeva'] = 0x0901;
  t['candrabindugujarati'] = 0x0A81;
  t['capslock'] = 0x21EA;
  t['careof'] = 0x2105;
  t['caron'] = 0x02C7;
  t['caronbelowcmb'] = 0x032C;
  t['caroncmb'] = 0x030C;
  t['carriagereturn'] = 0x21B5;
  t['cbopomofo'] = 0x3118;
  t['ccaron'] = 0x010D;
  t['ccedilla'] = 0x00E7;
  t['ccedillaacute'] = 0x1E09;
  t['ccircle'] = 0x24D2;
  t['ccircumflex'] = 0x0109;
  t['ccurl'] = 0x0255;
  t['cdot'] = 0x010B;
  t['cdotaccent'] = 0x010B;
  t['cdsquare'] = 0x33C5;
  t['cedilla'] = 0x00B8;
  t['cedillacmb'] = 0x0327;
  t['cent'] = 0x00A2;
  t['centigrade'] = 0x2103;
  t['centinferior'] = 0xF6DF;
  t['centmonospace'] = 0xFFE0;
  t['centoldstyle'] = 0xF7A2;
  t['centsuperior'] = 0xF6E0;
  t['chaarmenian'] = 0x0579;
  t['chabengali'] = 0x099B;
  t['chadeva'] = 0x091B;
  t['chagujarati'] = 0x0A9B;
  t['chagurmukhi'] = 0x0A1B;
  t['chbopomofo'] = 0x3114;
  t['cheabkhasiancyrillic'] = 0x04BD;
  t['checkmark'] = 0x2713;
  t['checyrillic'] = 0x0447;
  t['chedescenderabkhasiancyrillic'] = 0x04BF;
  t['chedescendercyrillic'] = 0x04B7;
  t['chedieresiscyrillic'] = 0x04F5;
  t['cheharmenian'] = 0x0573;
  t['chekhakassiancyrillic'] = 0x04CC;
  t['cheverticalstrokecyrillic'] = 0x04B9;
  t['chi'] = 0x03C7;
  t['chieuchacirclekorean'] = 0x3277;
  t['chieuchaparenkorean'] = 0x3217;
  t['chieuchcirclekorean'] = 0x3269;
  t['chieuchkorean'] = 0x314A;
  t['chieuchparenkorean'] = 0x3209;
  t['chochangthai'] = 0x0E0A;
  t['chochanthai'] = 0x0E08;
  t['chochingthai'] = 0x0E09;
  t['chochoethai'] = 0x0E0C;
  t['chook'] = 0x0188;
  t['cieucacirclekorean'] = 0x3276;
  t['cieucaparenkorean'] = 0x3216;
  t['cieuccirclekorean'] = 0x3268;
  t['cieuckorean'] = 0x3148;
  t['cieucparenkorean'] = 0x3208;
  t['cieucuparenkorean'] = 0x321C;
  t['circle'] = 0x25CB;
  t['circlecopyrt'] = 0x00A9; // Glyph is missing from Adobe's original list.
  t['circlemultiply'] = 0x2297;
  t['circleot'] = 0x2299;
  t['circleplus'] = 0x2295;
  t['circlepostalmark'] = 0x3036;
  t['circlewithlefthalfblack'] = 0x25D0;
  t['circlewithrighthalfblack'] = 0x25D1;
  t['circumflex'] = 0x02C6;
  t['circumflexbelowcmb'] = 0x032D;
  t['circumflexcmb'] = 0x0302;
  t['clear'] = 0x2327;
  t['clickalveolar'] = 0x01C2;
  t['clickdental'] = 0x01C0;
  t['clicklateral'] = 0x01C1;
  t['clickretroflex'] = 0x01C3;
  t['club'] = 0x2663;
  t['clubsuitblack'] = 0x2663;
  t['clubsuitwhite'] = 0x2667;
  t['cmcubedsquare'] = 0x33A4;
  t['cmonospace'] = 0xFF43;
  t['cmsquaredsquare'] = 0x33A0;
  t['coarmenian'] = 0x0581;
  t['colon'] = 0x003A;
  t['colonmonetary'] = 0x20A1;
  t['colonmonospace'] = 0xFF1A;
  t['colonsign'] = 0x20A1;
  t['colonsmall'] = 0xFE55;
  t['colontriangularhalfmod'] = 0x02D1;
  t['colontriangularmod'] = 0x02D0;
  t['comma'] = 0x002C;
  t['commaabovecmb'] = 0x0313;
  t['commaaboverightcmb'] = 0x0315;
  t['commaaccent'] = 0xF6C3;
  t['commaarabic'] = 0x060C;
  t['commaarmenian'] = 0x055D;
  t['commainferior'] = 0xF6E1;
  t['commamonospace'] = 0xFF0C;
  t['commareversedabovecmb'] = 0x0314;
  t['commareversedmod'] = 0x02BD;
  t['commasmall'] = 0xFE50;
  t['commasuperior'] = 0xF6E2;
  t['commaturnedabovecmb'] = 0x0312;
  t['commaturnedmod'] = 0x02BB;
  t['compass'] = 0x263C;
  t['congruent'] = 0x2245;
  t['contourintegral'] = 0x222E;
  t['control'] = 0x2303;
  t['controlACK'] = 0x0006;
  t['controlBEL'] = 0x0007;
  t['controlBS'] = 0x0008;
  t['controlCAN'] = 0x0018;
  t['controlCR'] = 0x000D;
  t['controlDC1'] = 0x0011;
  t['controlDC2'] = 0x0012;
  t['controlDC3'] = 0x0013;
  t['controlDC4'] = 0x0014;
  t['controlDEL'] = 0x007F;
  t['controlDLE'] = 0x0010;
  t['controlEM'] = 0x0019;
  t['controlENQ'] = 0x0005;
  t['controlEOT'] = 0x0004;
  t['controlESC'] = 0x001B;
  t['controlETB'] = 0x0017;
  t['controlETX'] = 0x0003;
  t['controlFF'] = 0x000C;
  t['controlFS'] = 0x001C;
  t['controlGS'] = 0x001D;
  t['controlHT'] = 0x0009;
  t['controlLF'] = 0x000A;
  t['controlNAK'] = 0x0015;
  t['controlRS'] = 0x001E;
  t['controlSI'] = 0x000F;
  t['controlSO'] = 0x000E;
  t['controlSOT'] = 0x0002;
  t['controlSTX'] = 0x0001;
  t['controlSUB'] = 0x001A;
  t['controlSYN'] = 0x0016;
  t['controlUS'] = 0x001F;
  t['controlVT'] = 0x000B;
  t['copyright'] = 0x00A9;
  t['copyrightsans'] = 0xF8E9;
  t['copyrightserif'] = 0xF6D9;
  t['cornerbracketleft'] = 0x300C;
  t['cornerbracketlefthalfwidth'] = 0xFF62;
  t['cornerbracketleftvertical'] = 0xFE41;
  t['cornerbracketright'] = 0x300D;
  t['cornerbracketrighthalfwidth'] = 0xFF63;
  t['cornerbracketrightvertical'] = 0xFE42;
  t['corporationsquare'] = 0x337F;
  t['cosquare'] = 0x33C7;
  t['coverkgsquare'] = 0x33C6;
  t['cparen'] = 0x249E;
  t['cruzeiro'] = 0x20A2;
  t['cstretched'] = 0x0297;
  t['curlyand'] = 0x22CF;
  t['curlyor'] = 0x22CE;
  t['currency'] = 0x00A4;
  t['cyrBreve'] = 0xF6D1;
  t['cyrFlex'] = 0xF6D2;
  t['cyrbreve'] = 0xF6D4;
  t['cyrflex'] = 0xF6D5;
  t['d'] = 0x0064;
  t['daarmenian'] = 0x0564;
  t['dabengali'] = 0x09A6;
  t['dadarabic'] = 0x0636;
  t['dadeva'] = 0x0926;
  t['dadfinalarabic'] = 0xFEBE;
  t['dadinitialarabic'] = 0xFEBF;
  t['dadmedialarabic'] = 0xFEC0;
  t['dagesh'] = 0x05BC;
  t['dageshhebrew'] = 0x05BC;
  t['dagger'] = 0x2020;
  t['daggerdbl'] = 0x2021;
  t['dagujarati'] = 0x0AA6;
  t['dagurmukhi'] = 0x0A26;
  t['dahiragana'] = 0x3060;
  t['dakatakana'] = 0x30C0;
  t['dalarabic'] = 0x062F;
  t['dalet'] = 0x05D3;
  t['daletdagesh'] = 0xFB33;
  t['daletdageshhebrew'] = 0xFB33;
  t['dalethebrew'] = 0x05D3;
  t['dalfinalarabic'] = 0xFEAA;
  t['dammaarabic'] = 0x064F;
  t['dammalowarabic'] = 0x064F;
  t['dammatanaltonearabic'] = 0x064C;
  t['dammatanarabic'] = 0x064C;
  t['danda'] = 0x0964;
  t['dargahebrew'] = 0x05A7;
  t['dargalefthebrew'] = 0x05A7;
  t['dasiapneumatacyrilliccmb'] = 0x0485;
  t['dblGrave'] = 0xF6D3;
  t['dblanglebracketleft'] = 0x300A;
  t['dblanglebracketleftvertical'] = 0xFE3D;
  t['dblanglebracketright'] = 0x300B;
  t['dblanglebracketrightvertical'] = 0xFE3E;
  t['dblarchinvertedbelowcmb'] = 0x032B;
  t['dblarrowleft'] = 0x21D4;
  t['dblarrowright'] = 0x21D2;
  t['dbldanda'] = 0x0965;
  t['dblgrave'] = 0xF6D6;
  t['dblgravecmb'] = 0x030F;
  t['dblintegral'] = 0x222C;
  t['dbllowline'] = 0x2017;
  t['dbllowlinecmb'] = 0x0333;
  t['dbloverlinecmb'] = 0x033F;
  t['dblprimemod'] = 0x02BA;
  t['dblverticalbar'] = 0x2016;
  t['dblverticallineabovecmb'] = 0x030E;
  t['dbopomofo'] = 0x3109;
  t['dbsquare'] = 0x33C8;
  t['dcaron'] = 0x010F;
  t['dcedilla'] = 0x1E11;
  t['dcircle'] = 0x24D3;
  t['dcircumflexbelow'] = 0x1E13;
  t['dcroat'] = 0x0111;
  t['ddabengali'] = 0x09A1;
  t['ddadeva'] = 0x0921;
  t['ddagujarati'] = 0x0AA1;
  t['ddagurmukhi'] = 0x0A21;
  t['ddalarabic'] = 0x0688;
  t['ddalfinalarabic'] = 0xFB89;
  t['dddhadeva'] = 0x095C;
  t['ddhabengali'] = 0x09A2;
  t['ddhadeva'] = 0x0922;
  t['ddhagujarati'] = 0x0AA2;
  t['ddhagurmukhi'] = 0x0A22;
  t['ddotaccent'] = 0x1E0B;
  t['ddotbelow'] = 0x1E0D;
  t['decimalseparatorarabic'] = 0x066B;
  t['decimalseparatorpersian'] = 0x066B;
  t['decyrillic'] = 0x0434;
  t['degree'] = 0x00B0;
  t['dehihebrew'] = 0x05AD;
  t['dehiragana'] = 0x3067;
  t['deicoptic'] = 0x03EF;
  t['dekatakana'] = 0x30C7;
  t['deleteleft'] = 0x232B;
  t['deleteright'] = 0x2326;
  t['delta'] = 0x03B4;
  t['deltaturned'] = 0x018D;
  t['denominatorminusonenumeratorbengali'] = 0x09F8;
  t['dezh'] = 0x02A4;
  t['dhabengali'] = 0x09A7;
  t['dhadeva'] = 0x0927;
  t['dhagujarati'] = 0x0AA7;
  t['dhagurmukhi'] = 0x0A27;
  t['dhook'] = 0x0257;
  t['dialytikatonos'] = 0x0385;
  t['dialytikatonoscmb'] = 0x0344;
  t['diamond'] = 0x2666;
  t['diamondsuitwhite'] = 0x2662;
  t['dieresis'] = 0x00A8;
  t['dieresisacute'] = 0xF6D7;
  t['dieresisbelowcmb'] = 0x0324;
  t['dieresiscmb'] = 0x0308;
  t['dieresisgrave'] = 0xF6D8;
  t['dieresistonos'] = 0x0385;
  t['dihiragana'] = 0x3062;
  t['dikatakana'] = 0x30C2;
  t['dittomark'] = 0x3003;
  t['divide'] = 0x00F7;
  t['divides'] = 0x2223;
  t['divisionslash'] = 0x2215;
  t['djecyrillic'] = 0x0452;
  t['dkshade'] = 0x2593;
  t['dlinebelow'] = 0x1E0F;
  t['dlsquare'] = 0x3397;
  t['dmacron'] = 0x0111;
  t['dmonospace'] = 0xFF44;
  t['dnblock'] = 0x2584;
  t['dochadathai'] = 0x0E0E;
  t['dodekthai'] = 0x0E14;
  t['dohiragana'] = 0x3069;
  t['dokatakana'] = 0x30C9;
  t['dollar'] = 0x0024;
  t['dollarinferior'] = 0xF6E3;
  t['dollarmonospace'] = 0xFF04;
  t['dollaroldstyle'] = 0xF724;
  t['dollarsmall'] = 0xFE69;
  t['dollarsuperior'] = 0xF6E4;
  t['dong'] = 0x20AB;
  t['dorusquare'] = 0x3326;
  t['dotaccent'] = 0x02D9;
  t['dotaccentcmb'] = 0x0307;
  t['dotbelowcmb'] = 0x0323;
  t['dotbelowcomb'] = 0x0323;
  t['dotkatakana'] = 0x30FB;
  t['dotlessi'] = 0x0131;
  t['dotlessj'] = 0xF6BE;
  t['dotlessjstrokehook'] = 0x0284;
  t['dotmath'] = 0x22C5;
  t['dottedcircle'] = 0x25CC;
  t['doubleyodpatah'] = 0xFB1F;
  t['doubleyodpatahhebrew'] = 0xFB1F;
  t['downtackbelowcmb'] = 0x031E;
  t['downtackmod'] = 0x02D5;
  t['dparen'] = 0x249F;
  t['dsuperior'] = 0xF6EB;
  t['dtail'] = 0x0256;
  t['dtopbar'] = 0x018C;
  t['duhiragana'] = 0x3065;
  t['dukatakana'] = 0x30C5;
  t['dz'] = 0x01F3;
  t['dzaltone'] = 0x02A3;
  t['dzcaron'] = 0x01C6;
  t['dzcurl'] = 0x02A5;
  t['dzeabkhasiancyrillic'] = 0x04E1;
  t['dzecyrillic'] = 0x0455;
  t['dzhecyrillic'] = 0x045F;
  t['e'] = 0x0065;
  t['eacute'] = 0x00E9;
  t['earth'] = 0x2641;
  t['ebengali'] = 0x098F;
  t['ebopomofo'] = 0x311C;
  t['ebreve'] = 0x0115;
  t['ecandradeva'] = 0x090D;
  t['ecandragujarati'] = 0x0A8D;
  t['ecandravowelsigndeva'] = 0x0945;
  t['ecandravowelsigngujarati'] = 0x0AC5;
  t['ecaron'] = 0x011B;
  t['ecedillabreve'] = 0x1E1D;
  t['echarmenian'] = 0x0565;
  t['echyiwnarmenian'] = 0x0587;
  t['ecircle'] = 0x24D4;
  t['ecircumflex'] = 0x00EA;
  t['ecircumflexacute'] = 0x1EBF;
  t['ecircumflexbelow'] = 0x1E19;
  t['ecircumflexdotbelow'] = 0x1EC7;
  t['ecircumflexgrave'] = 0x1EC1;
  t['ecircumflexhookabove'] = 0x1EC3;
  t['ecircumflextilde'] = 0x1EC5;
  t['ecyrillic'] = 0x0454;
  t['edblgrave'] = 0x0205;
  t['edeva'] = 0x090F;
  t['edieresis'] = 0x00EB;
  t['edot'] = 0x0117;
  t['edotaccent'] = 0x0117;
  t['edotbelow'] = 0x1EB9;
  t['eegurmukhi'] = 0x0A0F;
  t['eematragurmukhi'] = 0x0A47;
  t['efcyrillic'] = 0x0444;
  t['egrave'] = 0x00E8;
  t['egujarati'] = 0x0A8F;
  t['eharmenian'] = 0x0567;
  t['ehbopomofo'] = 0x311D;
  t['ehiragana'] = 0x3048;
  t['ehookabove'] = 0x1EBB;
  t['eibopomofo'] = 0x311F;
  t['eight'] = 0x0038;
  t['eightarabic'] = 0x0668;
  t['eightbengali'] = 0x09EE;
  t['eightcircle'] = 0x2467;
  t['eightcircleinversesansserif'] = 0x2791;
  t['eightdeva'] = 0x096E;
  t['eighteencircle'] = 0x2471;
  t['eighteenparen'] = 0x2485;
  t['eighteenperiod'] = 0x2499;
  t['eightgujarati'] = 0x0AEE;
  t['eightgurmukhi'] = 0x0A6E;
  t['eighthackarabic'] = 0x0668;
  t['eighthangzhou'] = 0x3028;
  t['eighthnotebeamed'] = 0x266B;
  t['eightideographicparen'] = 0x3227;
  t['eightinferior'] = 0x2088;
  t['eightmonospace'] = 0xFF18;
  t['eightoldstyle'] = 0xF738;
  t['eightparen'] = 0x247B;
  t['eightperiod'] = 0x248F;
  t['eightpersian'] = 0x06F8;
  t['eightroman'] = 0x2177;
  t['eightsuperior'] = 0x2078;
  t['eightthai'] = 0x0E58;
  t['einvertedbreve'] = 0x0207;
  t['eiotifiedcyrillic'] = 0x0465;
  t['ekatakana'] = 0x30A8;
  t['ekatakanahalfwidth'] = 0xFF74;
  t['ekonkargurmukhi'] = 0x0A74;
  t['ekorean'] = 0x3154;
  t['elcyrillic'] = 0x043B;
  t['element'] = 0x2208;
  t['elevencircle'] = 0x246A;
  t['elevenparen'] = 0x247E;
  t['elevenperiod'] = 0x2492;
  t['elevenroman'] = 0x217A;
  t['ellipsis'] = 0x2026;
  t['ellipsisvertical'] = 0x22EE;
  t['emacron'] = 0x0113;
  t['emacronacute'] = 0x1E17;
  t['emacrongrave'] = 0x1E15;
  t['emcyrillic'] = 0x043C;
  t['emdash'] = 0x2014;
  t['emdashvertical'] = 0xFE31;
  t['emonospace'] = 0xFF45;
  t['emphasismarkarmenian'] = 0x055B;
  t['emptyset'] = 0x2205;
  t['enbopomofo'] = 0x3123;
  t['encyrillic'] = 0x043D;
  t['endash'] = 0x2013;
  t['endashvertical'] = 0xFE32;
  t['endescendercyrillic'] = 0x04A3;
  t['eng'] = 0x014B;
  t['engbopomofo'] = 0x3125;
  t['enghecyrillic'] = 0x04A5;
  t['enhookcyrillic'] = 0x04C8;
  t['enspace'] = 0x2002;
  t['eogonek'] = 0x0119;
  t['eokorean'] = 0x3153;
  t['eopen'] = 0x025B;
  t['eopenclosed'] = 0x029A;
  t['eopenreversed'] = 0x025C;
  t['eopenreversedclosed'] = 0x025E;
  t['eopenreversedhook'] = 0x025D;
  t['eparen'] = 0x24A0;
  t['epsilon'] = 0x03B5;
  t['epsilontonos'] = 0x03AD;
  t['equal'] = 0x003D;
  t['equalmonospace'] = 0xFF1D;
  t['equalsmall'] = 0xFE66;
  t['equalsuperior'] = 0x207C;
  t['equivalence'] = 0x2261;
  t['erbopomofo'] = 0x3126;
  t['ercyrillic'] = 0x0440;
  t['ereversed'] = 0x0258;
  t['ereversedcyrillic'] = 0x044D;
  t['escyrillic'] = 0x0441;
  t['esdescendercyrillic'] = 0x04AB;
  t['esh'] = 0x0283;
  t['eshcurl'] = 0x0286;
  t['eshortdeva'] = 0x090E;
  t['eshortvowelsigndeva'] = 0x0946;
  t['eshreversedloop'] = 0x01AA;
  t['eshsquatreversed'] = 0x0285;
  t['esmallhiragana'] = 0x3047;
  t['esmallkatakana'] = 0x30A7;
  t['esmallkatakanahalfwidth'] = 0xFF6A;
  t['estimated'] = 0x212E;
  t['esuperior'] = 0xF6EC;
  t['eta'] = 0x03B7;
  t['etarmenian'] = 0x0568;
  t['etatonos'] = 0x03AE;
  t['eth'] = 0x00F0;
  t['etilde'] = 0x1EBD;
  t['etildebelow'] = 0x1E1B;
  t['etnahtafoukhhebrew'] = 0x0591;
  t['etnahtafoukhlefthebrew'] = 0x0591;
  t['etnahtahebrew'] = 0x0591;
  t['etnahtalefthebrew'] = 0x0591;
  t['eturned'] = 0x01DD;
  t['eukorean'] = 0x3161;
  t['euro'] = 0x20AC;
  t['evowelsignbengali'] = 0x09C7;
  t['evowelsigndeva'] = 0x0947;
  t['evowelsigngujarati'] = 0x0AC7;
  t['exclam'] = 0x0021;
  t['exclamarmenian'] = 0x055C;
  t['exclamdbl'] = 0x203C;
  t['exclamdown'] = 0x00A1;
  t['exclamdownsmall'] = 0xF7A1;
  t['exclammonospace'] = 0xFF01;
  t['exclamsmall'] = 0xF721;
  t['existential'] = 0x2203;
  t['ezh'] = 0x0292;
  t['ezhcaron'] = 0x01EF;
  t['ezhcurl'] = 0x0293;
  t['ezhreversed'] = 0x01B9;
  t['ezhtail'] = 0x01BA;
  t['f'] = 0x0066;
  t['fadeva'] = 0x095E;
  t['fagurmukhi'] = 0x0A5E;
  t['fahrenheit'] = 0x2109;
  t['fathaarabic'] = 0x064E;
  t['fathalowarabic'] = 0x064E;
  t['fathatanarabic'] = 0x064B;
  t['fbopomofo'] = 0x3108;
  t['fcircle'] = 0x24D5;
  t['fdotaccent'] = 0x1E1F;
  t['feharabic'] = 0x0641;
  t['feharmenian'] = 0x0586;
  t['fehfinalarabic'] = 0xFED2;
  t['fehinitialarabic'] = 0xFED3;
  t['fehmedialarabic'] = 0xFED4;
  t['feicoptic'] = 0x03E5;
  t['female'] = 0x2640;
  t['ff'] = 0xFB00;
  t['ffi'] = 0xFB03;
  t['ffl'] = 0xFB04;
  t['fi'] = 0xFB01;
  t['fifteencircle'] = 0x246E;
  t['fifteenparen'] = 0x2482;
  t['fifteenperiod'] = 0x2496;
  t['figuredash'] = 0x2012;
  t['filledbox'] = 0x25A0;
  t['filledrect'] = 0x25AC;
  t['finalkaf'] = 0x05DA;
  t['finalkafdagesh'] = 0xFB3A;
  t['finalkafdageshhebrew'] = 0xFB3A;
  t['finalkafhebrew'] = 0x05DA;
  t['finalmem'] = 0x05DD;
  t['finalmemhebrew'] = 0x05DD;
  t['finalnun'] = 0x05DF;
  t['finalnunhebrew'] = 0x05DF;
  t['finalpe'] = 0x05E3;
  t['finalpehebrew'] = 0x05E3;
  t['finaltsadi'] = 0x05E5;
  t['finaltsadihebrew'] = 0x05E5;
  t['firsttonechinese'] = 0x02C9;
  t['fisheye'] = 0x25C9;
  t['fitacyrillic'] = 0x0473;
  t['five'] = 0x0035;
  t['fivearabic'] = 0x0665;
  t['fivebengali'] = 0x09EB;
  t['fivecircle'] = 0x2464;
  t['fivecircleinversesansserif'] = 0x278E;
  t['fivedeva'] = 0x096B;
  t['fiveeighths'] = 0x215D;
  t['fivegujarati'] = 0x0AEB;
  t['fivegurmukhi'] = 0x0A6B;
  t['fivehackarabic'] = 0x0665;
  t['fivehangzhou'] = 0x3025;
  t['fiveideographicparen'] = 0x3224;
  t['fiveinferior'] = 0x2085;
  t['fivemonospace'] = 0xFF15;
  t['fiveoldstyle'] = 0xF735;
  t['fiveparen'] = 0x2478;
  t['fiveperiod'] = 0x248C;
  t['fivepersian'] = 0x06F5;
  t['fiveroman'] = 0x2174;
  t['fivesuperior'] = 0x2075;
  t['fivethai'] = 0x0E55;
  t['fl'] = 0xFB02;
  t['florin'] = 0x0192;
  t['fmonospace'] = 0xFF46;
  t['fmsquare'] = 0x3399;
  t['fofanthai'] = 0x0E1F;
  t['fofathai'] = 0x0E1D;
  t['fongmanthai'] = 0x0E4F;
  t['forall'] = 0x2200;
  t['four'] = 0x0034;
  t['fourarabic'] = 0x0664;
  t['fourbengali'] = 0x09EA;
  t['fourcircle'] = 0x2463;
  t['fourcircleinversesansserif'] = 0x278D;
  t['fourdeva'] = 0x096A;
  t['fourgujarati'] = 0x0AEA;
  t['fourgurmukhi'] = 0x0A6A;
  t['fourhackarabic'] = 0x0664;
  t['fourhangzhou'] = 0x3024;
  t['fourideographicparen'] = 0x3223;
  t['fourinferior'] = 0x2084;
  t['fourmonospace'] = 0xFF14;
  t['fournumeratorbengali'] = 0x09F7;
  t['fouroldstyle'] = 0xF734;
  t['fourparen'] = 0x2477;
  t['fourperiod'] = 0x248B;
  t['fourpersian'] = 0x06F4;
  t['fourroman'] = 0x2173;
  t['foursuperior'] = 0x2074;
  t['fourteencircle'] = 0x246D;
  t['fourteenparen'] = 0x2481;
  t['fourteenperiod'] = 0x2495;
  t['fourthai'] = 0x0E54;
  t['fourthtonechinese'] = 0x02CB;
  t['fparen'] = 0x24A1;
  t['fraction'] = 0x2044;
  t['franc'] = 0x20A3;
  t['g'] = 0x0067;
  t['gabengali'] = 0x0997;
  t['gacute'] = 0x01F5;
  t['gadeva'] = 0x0917;
  t['gafarabic'] = 0x06AF;
  t['gaffinalarabic'] = 0xFB93;
  t['gafinitialarabic'] = 0xFB94;
  t['gafmedialarabic'] = 0xFB95;
  t['gagujarati'] = 0x0A97;
  t['gagurmukhi'] = 0x0A17;
  t['gahiragana'] = 0x304C;
  t['gakatakana'] = 0x30AC;
  t['gamma'] = 0x03B3;
  t['gammalatinsmall'] = 0x0263;
  t['gammasuperior'] = 0x02E0;
  t['gangiacoptic'] = 0x03EB;
  t['gbopomofo'] = 0x310D;
  t['gbreve'] = 0x011F;
  t['gcaron'] = 0x01E7;
  t['gcedilla'] = 0x0123;
  t['gcircle'] = 0x24D6;
  t['gcircumflex'] = 0x011D;
  t['gcommaaccent'] = 0x0123;
  t['gdot'] = 0x0121;
  t['gdotaccent'] = 0x0121;
  t['gecyrillic'] = 0x0433;
  t['gehiragana'] = 0x3052;
  t['gekatakana'] = 0x30B2;
  t['geometricallyequal'] = 0x2251;
  t['gereshaccenthebrew'] = 0x059C;
  t['gereshhebrew'] = 0x05F3;
  t['gereshmuqdamhebrew'] = 0x059D;
  t['germandbls'] = 0x00DF;
  t['gershayimaccenthebrew'] = 0x059E;
  t['gershayimhebrew'] = 0x05F4;
  t['getamark'] = 0x3013;
  t['ghabengali'] = 0x0998;
  t['ghadarmenian'] = 0x0572;
  t['ghadeva'] = 0x0918;
  t['ghagujarati'] = 0x0A98;
  t['ghagurmukhi'] = 0x0A18;
  t['ghainarabic'] = 0x063A;
  t['ghainfinalarabic'] = 0xFECE;
  t['ghaininitialarabic'] = 0xFECF;
  t['ghainmedialarabic'] = 0xFED0;
  t['ghemiddlehookcyrillic'] = 0x0495;
  t['ghestrokecyrillic'] = 0x0493;
  t['gheupturncyrillic'] = 0x0491;
  t['ghhadeva'] = 0x095A;
  t['ghhagurmukhi'] = 0x0A5A;
  t['ghook'] = 0x0260;
  t['ghzsquare'] = 0x3393;
  t['gihiragana'] = 0x304E;
  t['gikatakana'] = 0x30AE;
  t['gimarmenian'] = 0x0563;
  t['gimel'] = 0x05D2;
  t['gimeldagesh'] = 0xFB32;
  t['gimeldageshhebrew'] = 0xFB32;
  t['gimelhebrew'] = 0x05D2;
  t['gjecyrillic'] = 0x0453;
  t['glottalinvertedstroke'] = 0x01BE;
  t['glottalstop'] = 0x0294;
  t['glottalstopinverted'] = 0x0296;
  t['glottalstopmod'] = 0x02C0;
  t['glottalstopreversed'] = 0x0295;
  t['glottalstopreversedmod'] = 0x02C1;
  t['glottalstopreversedsuperior'] = 0x02E4;
  t['glottalstopstroke'] = 0x02A1;
  t['glottalstopstrokereversed'] = 0x02A2;
  t['gmacron'] = 0x1E21;
  t['gmonospace'] = 0xFF47;
  t['gohiragana'] = 0x3054;
  t['gokatakana'] = 0x30B4;
  t['gparen'] = 0x24A2;
  t['gpasquare'] = 0x33AC;
  t['gradient'] = 0x2207;
  t['grave'] = 0x0060;
  t['gravebelowcmb'] = 0x0316;
  t['gravecmb'] = 0x0300;
  t['gravecomb'] = 0x0300;
  t['gravedeva'] = 0x0953;
  t['gravelowmod'] = 0x02CE;
  t['gravemonospace'] = 0xFF40;
  t['gravetonecmb'] = 0x0340;
  t['greater'] = 0x003E;
  t['greaterequal'] = 0x2265;
  t['greaterequalorless'] = 0x22DB;
  t['greatermonospace'] = 0xFF1E;
  t['greaterorequivalent'] = 0x2273;
  t['greaterorless'] = 0x2277;
  t['greateroverequal'] = 0x2267;
  t['greatersmall'] = 0xFE65;
  t['gscript'] = 0x0261;
  t['gstroke'] = 0x01E5;
  t['guhiragana'] = 0x3050;
  t['guillemotleft'] = 0x00AB;
  t['guillemotright'] = 0x00BB;
  t['guilsinglleft'] = 0x2039;
  t['guilsinglright'] = 0x203A;
  t['gukatakana'] = 0x30B0;
  t['guramusquare'] = 0x3318;
  t['gysquare'] = 0x33C9;
  t['h'] = 0x0068;
  t['haabkhasiancyrillic'] = 0x04A9;
  t['haaltonearabic'] = 0x06C1;
  t['habengali'] = 0x09B9;
  t['hadescendercyrillic'] = 0x04B3;
  t['hadeva'] = 0x0939;
  t['hagujarati'] = 0x0AB9;
  t['hagurmukhi'] = 0x0A39;
  t['haharabic'] = 0x062D;
  t['hahfinalarabic'] = 0xFEA2;
  t['hahinitialarabic'] = 0xFEA3;
  t['hahiragana'] = 0x306F;
  t['hahmedialarabic'] = 0xFEA4;
  t['haitusquare'] = 0x332A;
  t['hakatakana'] = 0x30CF;
  t['hakatakanahalfwidth'] = 0xFF8A;
  t['halantgurmukhi'] = 0x0A4D;
  t['hamzaarabic'] = 0x0621;
  t['hamzalowarabic'] = 0x0621;
  t['hangulfiller'] = 0x3164;
  t['hardsigncyrillic'] = 0x044A;
  t['harpoonleftbarbup'] = 0x21BC;
  t['harpoonrightbarbup'] = 0x21C0;
  t['hasquare'] = 0x33CA;
  t['hatafpatah'] = 0x05B2;
  t['hatafpatah16'] = 0x05B2;
  t['hatafpatah23'] = 0x05B2;
  t['hatafpatah2f'] = 0x05B2;
  t['hatafpatahhebrew'] = 0x05B2;
  t['hatafpatahnarrowhebrew'] = 0x05B2;
  t['hatafpatahquarterhebrew'] = 0x05B2;
  t['hatafpatahwidehebrew'] = 0x05B2;
  t['hatafqamats'] = 0x05B3;
  t['hatafqamats1b'] = 0x05B3;
  t['hatafqamats28'] = 0x05B3;
  t['hatafqamats34'] = 0x05B3;
  t['hatafqamatshebrew'] = 0x05B3;
  t['hatafqamatsnarrowhebrew'] = 0x05B3;
  t['hatafqamatsquarterhebrew'] = 0x05B3;
  t['hatafqamatswidehebrew'] = 0x05B3;
  t['hatafsegol'] = 0x05B1;
  t['hatafsegol17'] = 0x05B1;
  t['hatafsegol24'] = 0x05B1;
  t['hatafsegol30'] = 0x05B1;
  t['hatafsegolhebrew'] = 0x05B1;
  t['hatafsegolnarrowhebrew'] = 0x05B1;
  t['hatafsegolquarterhebrew'] = 0x05B1;
  t['hatafsegolwidehebrew'] = 0x05B1;
  t['hbar'] = 0x0127;
  t['hbopomofo'] = 0x310F;
  t['hbrevebelow'] = 0x1E2B;
  t['hcedilla'] = 0x1E29;
  t['hcircle'] = 0x24D7;
  t['hcircumflex'] = 0x0125;
  t['hdieresis'] = 0x1E27;
  t['hdotaccent'] = 0x1E23;
  t['hdotbelow'] = 0x1E25;
  t['he'] = 0x05D4;
  t['heart'] = 0x2665;
  t['heartsuitblack'] = 0x2665;
  t['heartsuitwhite'] = 0x2661;
  t['hedagesh'] = 0xFB34;
  t['hedageshhebrew'] = 0xFB34;
  t['hehaltonearabic'] = 0x06C1;
  t['heharabic'] = 0x0647;
  t['hehebrew'] = 0x05D4;
  t['hehfinalaltonearabic'] = 0xFBA7;
  t['hehfinalalttwoarabic'] = 0xFEEA;
  t['hehfinalarabic'] = 0xFEEA;
  t['hehhamzaabovefinalarabic'] = 0xFBA5;
  t['hehhamzaaboveisolatedarabic'] = 0xFBA4;
  t['hehinitialaltonearabic'] = 0xFBA8;
  t['hehinitialarabic'] = 0xFEEB;
  t['hehiragana'] = 0x3078;
  t['hehmedialaltonearabic'] = 0xFBA9;
  t['hehmedialarabic'] = 0xFEEC;
  t['heiseierasquare'] = 0x337B;
  t['hekatakana'] = 0x30D8;
  t['hekatakanahalfwidth'] = 0xFF8D;
  t['hekutaarusquare'] = 0x3336;
  t['henghook'] = 0x0267;
  t['herutusquare'] = 0x3339;
  t['het'] = 0x05D7;
  t['hethebrew'] = 0x05D7;
  t['hhook'] = 0x0266;
  t['hhooksuperior'] = 0x02B1;
  t['hieuhacirclekorean'] = 0x327B;
  t['hieuhaparenkorean'] = 0x321B;
  t['hieuhcirclekorean'] = 0x326D;
  t['hieuhkorean'] = 0x314E;
  t['hieuhparenkorean'] = 0x320D;
  t['hihiragana'] = 0x3072;
  t['hikatakana'] = 0x30D2;
  t['hikatakanahalfwidth'] = 0xFF8B;
  t['hiriq'] = 0x05B4;
  t['hiriq14'] = 0x05B4;
  t['hiriq21'] = 0x05B4;
  t['hiriq2d'] = 0x05B4;
  t['hiriqhebrew'] = 0x05B4;
  t['hiriqnarrowhebrew'] = 0x05B4;
  t['hiriqquarterhebrew'] = 0x05B4;
  t['hiriqwidehebrew'] = 0x05B4;
  t['hlinebelow'] = 0x1E96;
  t['hmonospace'] = 0xFF48;
  t['hoarmenian'] = 0x0570;
  t['hohipthai'] = 0x0E2B;
  t['hohiragana'] = 0x307B;
  t['hokatakana'] = 0x30DB;
  t['hokatakanahalfwidth'] = 0xFF8E;
  t['holam'] = 0x05B9;
  t['holam19'] = 0x05B9;
  t['holam26'] = 0x05B9;
  t['holam32'] = 0x05B9;
  t['holamhebrew'] = 0x05B9;
  t['holamnarrowhebrew'] = 0x05B9;
  t['holamquarterhebrew'] = 0x05B9;
  t['holamwidehebrew'] = 0x05B9;
  t['honokhukthai'] = 0x0E2E;
  t['hookabovecomb'] = 0x0309;
  t['hookcmb'] = 0x0309;
  t['hookpalatalizedbelowcmb'] = 0x0321;
  t['hookretroflexbelowcmb'] = 0x0322;
  t['hoonsquare'] = 0x3342;
  t['horicoptic'] = 0x03E9;
  t['horizontalbar'] = 0x2015;
  t['horncmb'] = 0x031B;
  t['hotsprings'] = 0x2668;
  t['house'] = 0x2302;
  t['hparen'] = 0x24A3;
  t['hsuperior'] = 0x02B0;
  t['hturned'] = 0x0265;
  t['huhiragana'] = 0x3075;
  t['huiitosquare'] = 0x3333;
  t['hukatakana'] = 0x30D5;
  t['hukatakanahalfwidth'] = 0xFF8C;
  t['hungarumlaut'] = 0x02DD;
  t['hungarumlautcmb'] = 0x030B;
  t['hv'] = 0x0195;
  t['hyphen'] = 0x002D;
  t['hypheninferior'] = 0xF6E5;
  t['hyphenmonospace'] = 0xFF0D;
  t['hyphensmall'] = 0xFE63;
  t['hyphensuperior'] = 0xF6E6;
  t['hyphentwo'] = 0x2010;
  t['i'] = 0x0069;
  t['iacute'] = 0x00ED;
  t['iacyrillic'] = 0x044F;
  t['ibengali'] = 0x0987;
  t['ibopomofo'] = 0x3127;
  t['ibreve'] = 0x012D;
  t['icaron'] = 0x01D0;
  t['icircle'] = 0x24D8;
  t['icircumflex'] = 0x00EE;
  t['icyrillic'] = 0x0456;
  t['idblgrave'] = 0x0209;
  t['ideographearthcircle'] = 0x328F;
  t['ideographfirecircle'] = 0x328B;
  t['ideographicallianceparen'] = 0x323F;
  t['ideographiccallparen'] = 0x323A;
  t['ideographiccentrecircle'] = 0x32A5;
  t['ideographicclose'] = 0x3006;
  t['ideographiccomma'] = 0x3001;
  t['ideographiccommaleft'] = 0xFF64;
  t['ideographiccongratulationparen'] = 0x3237;
  t['ideographiccorrectcircle'] = 0x32A3;
  t['ideographicearthparen'] = 0x322F;
  t['ideographicenterpriseparen'] = 0x323D;
  t['ideographicexcellentcircle'] = 0x329D;
  t['ideographicfestivalparen'] = 0x3240;
  t['ideographicfinancialcircle'] = 0x3296;
  t['ideographicfinancialparen'] = 0x3236;
  t['ideographicfireparen'] = 0x322B;
  t['ideographichaveparen'] = 0x3232;
  t['ideographichighcircle'] = 0x32A4;
  t['ideographiciterationmark'] = 0x3005;
  t['ideographiclaborcircle'] = 0x3298;
  t['ideographiclaborparen'] = 0x3238;
  t['ideographicleftcircle'] = 0x32A7;
  t['ideographiclowcircle'] = 0x32A6;
  t['ideographicmedicinecircle'] = 0x32A9;
  t['ideographicmetalparen'] = 0x322E;
  t['ideographicmoonparen'] = 0x322A;
  t['ideographicnameparen'] = 0x3234;
  t['ideographicperiod'] = 0x3002;
  t['ideographicprintcircle'] = 0x329E;
  t['ideographicreachparen'] = 0x3243;
  t['ideographicrepresentparen'] = 0x3239;
  t['ideographicresourceparen'] = 0x323E;
  t['ideographicrightcircle'] = 0x32A8;
  t['ideographicsecretcircle'] = 0x3299;
  t['ideographicselfparen'] = 0x3242;
  t['ideographicsocietyparen'] = 0x3233;
  t['ideographicspace'] = 0x3000;
  t['ideographicspecialparen'] = 0x3235;
  t['ideographicstockparen'] = 0x3231;
  t['ideographicstudyparen'] = 0x323B;
  t['ideographicsunparen'] = 0x3230;
  t['ideographicsuperviseparen'] = 0x323C;
  t['ideographicwaterparen'] = 0x322C;
  t['ideographicwoodparen'] = 0x322D;
  t['ideographiczero'] = 0x3007;
  t['ideographmetalcircle'] = 0x328E;
  t['ideographmooncircle'] = 0x328A;
  t['ideographnamecircle'] = 0x3294;
  t['ideographsuncircle'] = 0x3290;
  t['ideographwatercircle'] = 0x328C;
  t['ideographwoodcircle'] = 0x328D;
  t['ideva'] = 0x0907;
  t['idieresis'] = 0x00EF;
  t['idieresisacute'] = 0x1E2F;
  t['idieresiscyrillic'] = 0x04E5;
  t['idotbelow'] = 0x1ECB;
  t['iebrevecyrillic'] = 0x04D7;
  t['iecyrillic'] = 0x0435;
  t['ieungacirclekorean'] = 0x3275;
  t['ieungaparenkorean'] = 0x3215;
  t['ieungcirclekorean'] = 0x3267;
  t['ieungkorean'] = 0x3147;
  t['ieungparenkorean'] = 0x3207;
  t['igrave'] = 0x00EC;
  t['igujarati'] = 0x0A87;
  t['igurmukhi'] = 0x0A07;
  t['ihiragana'] = 0x3044;
  t['ihookabove'] = 0x1EC9;
  t['iibengali'] = 0x0988;
  t['iicyrillic'] = 0x0438;
  t['iideva'] = 0x0908;
  t['iigujarati'] = 0x0A88;
  t['iigurmukhi'] = 0x0A08;
  t['iimatragurmukhi'] = 0x0A40;
  t['iinvertedbreve'] = 0x020B;
  t['iishortcyrillic'] = 0x0439;
  t['iivowelsignbengali'] = 0x09C0;
  t['iivowelsigndeva'] = 0x0940;
  t['iivowelsigngujarati'] = 0x0AC0;
  t['ij'] = 0x0133;
  t['ikatakana'] = 0x30A4;
  t['ikatakanahalfwidth'] = 0xFF72;
  t['ikorean'] = 0x3163;
  t['ilde'] = 0x02DC;
  t['iluyhebrew'] = 0x05AC;
  t['imacron'] = 0x012B;
  t['imacroncyrillic'] = 0x04E3;
  t['imageorapproximatelyequal'] = 0x2253;
  t['imatragurmukhi'] = 0x0A3F;
  t['imonospace'] = 0xFF49;
  t['increment'] = 0x2206;
  t['infinity'] = 0x221E;
  t['iniarmenian'] = 0x056B;
  t['integral'] = 0x222B;
  t['integralbottom'] = 0x2321;
  t['integralbt'] = 0x2321;
  t['integralex'] = 0xF8F5;
  t['integraltop'] = 0x2320;
  t['integraltp'] = 0x2320;
  t['intersection'] = 0x2229;
  t['intisquare'] = 0x3305;
  t['invbullet'] = 0x25D8;
  t['invcircle'] = 0x25D9;
  t['invsmileface'] = 0x263B;
  t['iocyrillic'] = 0x0451;
  t['iogonek'] = 0x012F;
  t['iota'] = 0x03B9;
  t['iotadieresis'] = 0x03CA;
  t['iotadieresistonos'] = 0x0390;
  t['iotalatin'] = 0x0269;
  t['iotatonos'] = 0x03AF;
  t['iparen'] = 0x24A4;
  t['irigurmukhi'] = 0x0A72;
  t['ismallhiragana'] = 0x3043;
  t['ismallkatakana'] = 0x30A3;
  t['ismallkatakanahalfwidth'] = 0xFF68;
  t['issharbengali'] = 0x09FA;
  t['istroke'] = 0x0268;
  t['isuperior'] = 0xF6ED;
  t['iterationhiragana'] = 0x309D;
  t['iterationkatakana'] = 0x30FD;
  t['itilde'] = 0x0129;
  t['itildebelow'] = 0x1E2D;
  t['iubopomofo'] = 0x3129;
  t['iucyrillic'] = 0x044E;
  t['ivowelsignbengali'] = 0x09BF;
  t['ivowelsigndeva'] = 0x093F;
  t['ivowelsigngujarati'] = 0x0ABF;
  t['izhitsacyrillic'] = 0x0475;
  t['izhitsadblgravecyrillic'] = 0x0477;
  t['j'] = 0x006A;
  t['jaarmenian'] = 0x0571;
  t['jabengali'] = 0x099C;
  t['jadeva'] = 0x091C;
  t['jagujarati'] = 0x0A9C;
  t['jagurmukhi'] = 0x0A1C;
  t['jbopomofo'] = 0x3110;
  t['jcaron'] = 0x01F0;
  t['jcircle'] = 0x24D9;
  t['jcircumflex'] = 0x0135;
  t['jcrossedtail'] = 0x029D;
  t['jdotlessstroke'] = 0x025F;
  t['jecyrillic'] = 0x0458;
  t['jeemarabic'] = 0x062C;
  t['jeemfinalarabic'] = 0xFE9E;
  t['jeeminitialarabic'] = 0xFE9F;
  t['jeemmedialarabic'] = 0xFEA0;
  t['jeharabic'] = 0x0698;
  t['jehfinalarabic'] = 0xFB8B;
  t['jhabengali'] = 0x099D;
  t['jhadeva'] = 0x091D;
  t['jhagujarati'] = 0x0A9D;
  t['jhagurmukhi'] = 0x0A1D;
  t['jheharmenian'] = 0x057B;
  t['jis'] = 0x3004;
  t['jmonospace'] = 0xFF4A;
  t['jparen'] = 0x24A5;
  t['jsuperior'] = 0x02B2;
  t['k'] = 0x006B;
  t['kabashkircyrillic'] = 0x04A1;
  t['kabengali'] = 0x0995;
  t['kacute'] = 0x1E31;
  t['kacyrillic'] = 0x043A;
  t['kadescendercyrillic'] = 0x049B;
  t['kadeva'] = 0x0915;
  t['kaf'] = 0x05DB;
  t['kafarabic'] = 0x0643;
  t['kafdagesh'] = 0xFB3B;
  t['kafdageshhebrew'] = 0xFB3B;
  t['kaffinalarabic'] = 0xFEDA;
  t['kafhebrew'] = 0x05DB;
  t['kafinitialarabic'] = 0xFEDB;
  t['kafmedialarabic'] = 0xFEDC;
  t['kafrafehebrew'] = 0xFB4D;
  t['kagujarati'] = 0x0A95;
  t['kagurmukhi'] = 0x0A15;
  t['kahiragana'] = 0x304B;
  t['kahookcyrillic'] = 0x04C4;
  t['kakatakana'] = 0x30AB;
  t['kakatakanahalfwidth'] = 0xFF76;
  t['kappa'] = 0x03BA;
  t['kappasymbolgreek'] = 0x03F0;
  t['kapyeounmieumkorean'] = 0x3171;
  t['kapyeounphieuphkorean'] = 0x3184;
  t['kapyeounpieupkorean'] = 0x3178;
  t['kapyeounssangpieupkorean'] = 0x3179;
  t['karoriisquare'] = 0x330D;
  t['kashidaautoarabic'] = 0x0640;
  t['kashidaautonosidebearingarabic'] = 0x0640;
  t['kasmallkatakana'] = 0x30F5;
  t['kasquare'] = 0x3384;
  t['kasraarabic'] = 0x0650;
  t['kasratanarabic'] = 0x064D;
  t['kastrokecyrillic'] = 0x049F;
  t['katahiraprolongmarkhalfwidth'] = 0xFF70;
  t['kaverticalstrokecyrillic'] = 0x049D;
  t['kbopomofo'] = 0x310E;
  t['kcalsquare'] = 0x3389;
  t['kcaron'] = 0x01E9;
  t['kcedilla'] = 0x0137;
  t['kcircle'] = 0x24DA;
  t['kcommaaccent'] = 0x0137;
  t['kdotbelow'] = 0x1E33;
  t['keharmenian'] = 0x0584;
  t['kehiragana'] = 0x3051;
  t['kekatakana'] = 0x30B1;
  t['kekatakanahalfwidth'] = 0xFF79;
  t['kenarmenian'] = 0x056F;
  t['kesmallkatakana'] = 0x30F6;
  t['kgreenlandic'] = 0x0138;
  t['khabengali'] = 0x0996;
  t['khacyrillic'] = 0x0445;
  t['khadeva'] = 0x0916;
  t['khagujarati'] = 0x0A96;
  t['khagurmukhi'] = 0x0A16;
  t['khaharabic'] = 0x062E;
  t['khahfinalarabic'] = 0xFEA6;
  t['khahinitialarabic'] = 0xFEA7;
  t['khahmedialarabic'] = 0xFEA8;
  t['kheicoptic'] = 0x03E7;
  t['khhadeva'] = 0x0959;
  t['khhagurmukhi'] = 0x0A59;
  t['khieukhacirclekorean'] = 0x3278;
  t['khieukhaparenkorean'] = 0x3218;
  t['khieukhcirclekorean'] = 0x326A;
  t['khieukhkorean'] = 0x314B;
  t['khieukhparenkorean'] = 0x320A;
  t['khokhaithai'] = 0x0E02;
  t['khokhonthai'] = 0x0E05;
  t['khokhuatthai'] = 0x0E03;
  t['khokhwaithai'] = 0x0E04;
  t['khomutthai'] = 0x0E5B;
  t['khook'] = 0x0199;
  t['khorakhangthai'] = 0x0E06;
  t['khzsquare'] = 0x3391;
  t['kihiragana'] = 0x304D;
  t['kikatakana'] = 0x30AD;
  t['kikatakanahalfwidth'] = 0xFF77;
  t['kiroguramusquare'] = 0x3315;
  t['kiromeetorusquare'] = 0x3316;
  t['kirosquare'] = 0x3314;
  t['kiyeokacirclekorean'] = 0x326E;
  t['kiyeokaparenkorean'] = 0x320E;
  t['kiyeokcirclekorean'] = 0x3260;
  t['kiyeokkorean'] = 0x3131;
  t['kiyeokparenkorean'] = 0x3200;
  t['kiyeoksioskorean'] = 0x3133;
  t['kjecyrillic'] = 0x045C;
  t['klinebelow'] = 0x1E35;
  t['klsquare'] = 0x3398;
  t['kmcubedsquare'] = 0x33A6;
  t['kmonospace'] = 0xFF4B;
  t['kmsquaredsquare'] = 0x33A2;
  t['kohiragana'] = 0x3053;
  t['kohmsquare'] = 0x33C0;
  t['kokaithai'] = 0x0E01;
  t['kokatakana'] = 0x30B3;
  t['kokatakanahalfwidth'] = 0xFF7A;
  t['kooposquare'] = 0x331E;
  t['koppacyrillic'] = 0x0481;
  t['koreanstandardsymbol'] = 0x327F;
  t['koroniscmb'] = 0x0343;
  t['kparen'] = 0x24A6;
  t['kpasquare'] = 0x33AA;
  t['ksicyrillic'] = 0x046F;
  t['ktsquare'] = 0x33CF;
  t['kturned'] = 0x029E;
  t['kuhiragana'] = 0x304F;
  t['kukatakana'] = 0x30AF;
  t['kukatakanahalfwidth'] = 0xFF78;
  t['kvsquare'] = 0x33B8;
  t['kwsquare'] = 0x33BE;
  t['l'] = 0x006C;
  t['labengali'] = 0x09B2;
  t['lacute'] = 0x013A;
  t['ladeva'] = 0x0932;
  t['lagujarati'] = 0x0AB2;
  t['lagurmukhi'] = 0x0A32;
  t['lakkhangyaothai'] = 0x0E45;
  t['lamaleffinalarabic'] = 0xFEFC;
  t['lamalefhamzaabovefinalarabic'] = 0xFEF8;
  t['lamalefhamzaaboveisolatedarabic'] = 0xFEF7;
  t['lamalefhamzabelowfinalarabic'] = 0xFEFA;
  t['lamalefhamzabelowisolatedarabic'] = 0xFEF9;
  t['lamalefisolatedarabic'] = 0xFEFB;
  t['lamalefmaddaabovefinalarabic'] = 0xFEF6;
  t['lamalefmaddaaboveisolatedarabic'] = 0xFEF5;
  t['lamarabic'] = 0x0644;
  t['lambda'] = 0x03BB;
  t['lambdastroke'] = 0x019B;
  t['lamed'] = 0x05DC;
  t['lameddagesh'] = 0xFB3C;
  t['lameddageshhebrew'] = 0xFB3C;
  t['lamedhebrew'] = 0x05DC;
  t['lamfinalarabic'] = 0xFEDE;
  t['lamhahinitialarabic'] = 0xFCCA;
  t['laminitialarabic'] = 0xFEDF;
  t['lamjeeminitialarabic'] = 0xFCC9;
  t['lamkhahinitialarabic'] = 0xFCCB;
  t['lamlamhehisolatedarabic'] = 0xFDF2;
  t['lammedialarabic'] = 0xFEE0;
  t['lammeemhahinitialarabic'] = 0xFD88;
  t['lammeeminitialarabic'] = 0xFCCC;
  t['largecircle'] = 0x25EF;
  t['lbar'] = 0x019A;
  t['lbelt'] = 0x026C;
  t['lbopomofo'] = 0x310C;
  t['lcaron'] = 0x013E;
  t['lcedilla'] = 0x013C;
  t['lcircle'] = 0x24DB;
  t['lcircumflexbelow'] = 0x1E3D;
  t['lcommaaccent'] = 0x013C;
  t['ldot'] = 0x0140;
  t['ldotaccent'] = 0x0140;
  t['ldotbelow'] = 0x1E37;
  t['ldotbelowmacron'] = 0x1E39;
  t['leftangleabovecmb'] = 0x031A;
  t['lefttackbelowcmb'] = 0x0318;
  t['less'] = 0x003C;
  t['lessequal'] = 0x2264;
  t['lessequalorgreater'] = 0x22DA;
  t['lessmonospace'] = 0xFF1C;
  t['lessorequivalent'] = 0x2272;
  t['lessorgreater'] = 0x2276;
  t['lessoverequal'] = 0x2266;
  t['lesssmall'] = 0xFE64;
  t['lezh'] = 0x026E;
  t['lfblock'] = 0x258C;
  t['lhookretroflex'] = 0x026D;
  t['lira'] = 0x20A4;
  t['liwnarmenian'] = 0x056C;
  t['lj'] = 0x01C9;
  t['ljecyrillic'] = 0x0459;
  t['ll'] = 0xF6C0;
  t['lladeva'] = 0x0933;
  t['llagujarati'] = 0x0AB3;
  t['llinebelow'] = 0x1E3B;
  t['llladeva'] = 0x0934;
  t['llvocalicbengali'] = 0x09E1;
  t['llvocalicdeva'] = 0x0961;
  t['llvocalicvowelsignbengali'] = 0x09E3;
  t['llvocalicvowelsigndeva'] = 0x0963;
  t['lmiddletilde'] = 0x026B;
  t['lmonospace'] = 0xFF4C;
  t['lmsquare'] = 0x33D0;
  t['lochulathai'] = 0x0E2C;
  t['logicaland'] = 0x2227;
  t['logicalnot'] = 0x00AC;
  t['logicalnotreversed'] = 0x2310;
  t['logicalor'] = 0x2228;
  t['lolingthai'] = 0x0E25;
  t['longs'] = 0x017F;
  t['lowlinecenterline'] = 0xFE4E;
  t['lowlinecmb'] = 0x0332;
  t['lowlinedashed'] = 0xFE4D;
  t['lozenge'] = 0x25CA;
  t['lparen'] = 0x24A7;
  t['lslash'] = 0x0142;
  t['lsquare'] = 0x2113;
  t['lsuperior'] = 0xF6EE;
  t['ltshade'] = 0x2591;
  t['luthai'] = 0x0E26;
  t['lvocalicbengali'] = 0x098C;
  t['lvocalicdeva'] = 0x090C;
  t['lvocalicvowelsignbengali'] = 0x09E2;
  t['lvocalicvowelsigndeva'] = 0x0962;
  t['lxsquare'] = 0x33D3;
  t['m'] = 0x006D;
  t['mabengali'] = 0x09AE;
  t['macron'] = 0x00AF;
  t['macronbelowcmb'] = 0x0331;
  t['macroncmb'] = 0x0304;
  t['macronlowmod'] = 0x02CD;
  t['macronmonospace'] = 0xFFE3;
  t['macute'] = 0x1E3F;
  t['madeva'] = 0x092E;
  t['magujarati'] = 0x0AAE;
  t['magurmukhi'] = 0x0A2E;
  t['mahapakhhebrew'] = 0x05A4;
  t['mahapakhlefthebrew'] = 0x05A4;
  t['mahiragana'] = 0x307E;
  t['maichattawalowleftthai'] = 0xF895;
  t['maichattawalowrightthai'] = 0xF894;
  t['maichattawathai'] = 0x0E4B;
  t['maichattawaupperleftthai'] = 0xF893;
  t['maieklowleftthai'] = 0xF88C;
  t['maieklowrightthai'] = 0xF88B;
  t['maiekthai'] = 0x0E48;
  t['maiekupperleftthai'] = 0xF88A;
  t['maihanakatleftthai'] = 0xF884;
  t['maihanakatthai'] = 0x0E31;
  t['maitaikhuleftthai'] = 0xF889;
  t['maitaikhuthai'] = 0x0E47;
  t['maitholowleftthai'] = 0xF88F;
  t['maitholowrightthai'] = 0xF88E;
  t['maithothai'] = 0x0E49;
  t['maithoupperleftthai'] = 0xF88D;
  t['maitrilowleftthai'] = 0xF892;
  t['maitrilowrightthai'] = 0xF891;
  t['maitrithai'] = 0x0E4A;
  t['maitriupperleftthai'] = 0xF890;
  t['maiyamokthai'] = 0x0E46;
  t['makatakana'] = 0x30DE;
  t['makatakanahalfwidth'] = 0xFF8F;
  t['male'] = 0x2642;
  t['mansyonsquare'] = 0x3347;
  t['maqafhebrew'] = 0x05BE;
  t['mars'] = 0x2642;
  t['masoracirclehebrew'] = 0x05AF;
  t['masquare'] = 0x3383;
  t['mbopomofo'] = 0x3107;
  t['mbsquare'] = 0x33D4;
  t['mcircle'] = 0x24DC;
  t['mcubedsquare'] = 0x33A5;
  t['mdotaccent'] = 0x1E41;
  t['mdotbelow'] = 0x1E43;
  t['meemarabic'] = 0x0645;
  t['meemfinalarabic'] = 0xFEE2;
  t['meeminitialarabic'] = 0xFEE3;
  t['meemmedialarabic'] = 0xFEE4;
  t['meemmeeminitialarabic'] = 0xFCD1;
  t['meemmeemisolatedarabic'] = 0xFC48;
  t['meetorusquare'] = 0x334D;
  t['mehiragana'] = 0x3081;
  t['meizierasquare'] = 0x337E;
  t['mekatakana'] = 0x30E1;
  t['mekatakanahalfwidth'] = 0xFF92;
  t['mem'] = 0x05DE;
  t['memdagesh'] = 0xFB3E;
  t['memdageshhebrew'] = 0xFB3E;
  t['memhebrew'] = 0x05DE;
  t['menarmenian'] = 0x0574;
  t['merkhahebrew'] = 0x05A5;
  t['merkhakefulahebrew'] = 0x05A6;
  t['merkhakefulalefthebrew'] = 0x05A6;
  t['merkhalefthebrew'] = 0x05A5;
  t['mhook'] = 0x0271;
  t['mhzsquare'] = 0x3392;
  t['middledotkatakanahalfwidth'] = 0xFF65;
  t['middot'] = 0x00B7;
  t['mieumacirclekorean'] = 0x3272;
  t['mieumaparenkorean'] = 0x3212;
  t['mieumcirclekorean'] = 0x3264;
  t['mieumkorean'] = 0x3141;
  t['mieumpansioskorean'] = 0x3170;
  t['mieumparenkorean'] = 0x3204;
  t['mieumpieupkorean'] = 0x316E;
  t['mieumsioskorean'] = 0x316F;
  t['mihiragana'] = 0x307F;
  t['mikatakana'] = 0x30DF;
  t['mikatakanahalfwidth'] = 0xFF90;
  t['minus'] = 0x2212;
  t['minusbelowcmb'] = 0x0320;
  t['minuscircle'] = 0x2296;
  t['minusmod'] = 0x02D7;
  t['minusplus'] = 0x2213;
  t['minute'] = 0x2032;
  t['miribaarusquare'] = 0x334A;
  t['mirisquare'] = 0x3349;
  t['mlonglegturned'] = 0x0270;
  t['mlsquare'] = 0x3396;
  t['mmcubedsquare'] = 0x33A3;
  t['mmonospace'] = 0xFF4D;
  t['mmsquaredsquare'] = 0x339F;
  t['mohiragana'] = 0x3082;
  t['mohmsquare'] = 0x33C1;
  t['mokatakana'] = 0x30E2;
  t['mokatakanahalfwidth'] = 0xFF93;
  t['molsquare'] = 0x33D6;
  t['momathai'] = 0x0E21;
  t['moverssquare'] = 0x33A7;
  t['moverssquaredsquare'] = 0x33A8;
  t['mparen'] = 0x24A8;
  t['mpasquare'] = 0x33AB;
  t['mssquare'] = 0x33B3;
  t['msuperior'] = 0xF6EF;
  t['mturned'] = 0x026F;
  t['mu'] = 0x00B5;
  t['mu1'] = 0x00B5;
  t['muasquare'] = 0x3382;
  t['muchgreater'] = 0x226B;
  t['muchless'] = 0x226A;
  t['mufsquare'] = 0x338C;
  t['mugreek'] = 0x03BC;
  t['mugsquare'] = 0x338D;
  t['muhiragana'] = 0x3080;
  t['mukatakana'] = 0x30E0;
  t['mukatakanahalfwidth'] = 0xFF91;
  t['mulsquare'] = 0x3395;
  t['multiply'] = 0x00D7;
  t['mumsquare'] = 0x339B;
  t['munahhebrew'] = 0x05A3;
  t['munahlefthebrew'] = 0x05A3;
  t['musicalnote'] = 0x266A;
  t['musicalnotedbl'] = 0x266B;
  t['musicflatsign'] = 0x266D;
  t['musicsharpsign'] = 0x266F;
  t['mussquare'] = 0x33B2;
  t['muvsquare'] = 0x33B6;
  t['muwsquare'] = 0x33BC;
  t['mvmegasquare'] = 0x33B9;
  t['mvsquare'] = 0x33B7;
  t['mwmegasquare'] = 0x33BF;
  t['mwsquare'] = 0x33BD;
  t['n'] = 0x006E;
  t['nabengali'] = 0x09A8;
  t['nabla'] = 0x2207;
  t['nacute'] = 0x0144;
  t['nadeva'] = 0x0928;
  t['nagujarati'] = 0x0AA8;
  t['nagurmukhi'] = 0x0A28;
  t['nahiragana'] = 0x306A;
  t['nakatakana'] = 0x30CA;
  t['nakatakanahalfwidth'] = 0xFF85;
  t['napostrophe'] = 0x0149;
  t['nasquare'] = 0x3381;
  t['nbopomofo'] = 0x310B;
  t['nbspace'] = 0x00A0;
  t['ncaron'] = 0x0148;
  t['ncedilla'] = 0x0146;
  t['ncircle'] = 0x24DD;
  t['ncircumflexbelow'] = 0x1E4B;
  t['ncommaaccent'] = 0x0146;
  t['ndotaccent'] = 0x1E45;
  t['ndotbelow'] = 0x1E47;
  t['nehiragana'] = 0x306D;
  t['nekatakana'] = 0x30CD;
  t['nekatakanahalfwidth'] = 0xFF88;
  t['newsheqelsign'] = 0x20AA;
  t['nfsquare'] = 0x338B;
  t['ngabengali'] = 0x0999;
  t['ngadeva'] = 0x0919;
  t['ngagujarati'] = 0x0A99;
  t['ngagurmukhi'] = 0x0A19;
  t['ngonguthai'] = 0x0E07;
  t['nhiragana'] = 0x3093;
  t['nhookleft'] = 0x0272;
  t['nhookretroflex'] = 0x0273;
  t['nieunacirclekorean'] = 0x326F;
  t['nieunaparenkorean'] = 0x320F;
  t['nieuncieuckorean'] = 0x3135;
  t['nieuncirclekorean'] = 0x3261;
  t['nieunhieuhkorean'] = 0x3136;
  t['nieunkorean'] = 0x3134;
  t['nieunpansioskorean'] = 0x3168;
  t['nieunparenkorean'] = 0x3201;
  t['nieunsioskorean'] = 0x3167;
  t['nieuntikeutkorean'] = 0x3166;
  t['nihiragana'] = 0x306B;
  t['nikatakana'] = 0x30CB;
  t['nikatakanahalfwidth'] = 0xFF86;
  t['nikhahitleftthai'] = 0xF899;
  t['nikhahitthai'] = 0x0E4D;
  t['nine'] = 0x0039;
  t['ninearabic'] = 0x0669;
  t['ninebengali'] = 0x09EF;
  t['ninecircle'] = 0x2468;
  t['ninecircleinversesansserif'] = 0x2792;
  t['ninedeva'] = 0x096F;
  t['ninegujarati'] = 0x0AEF;
  t['ninegurmukhi'] = 0x0A6F;
  t['ninehackarabic'] = 0x0669;
  t['ninehangzhou'] = 0x3029;
  t['nineideographicparen'] = 0x3228;
  t['nineinferior'] = 0x2089;
  t['ninemonospace'] = 0xFF19;
  t['nineoldstyle'] = 0xF739;
  t['nineparen'] = 0x247C;
  t['nineperiod'] = 0x2490;
  t['ninepersian'] = 0x06F9;
  t['nineroman'] = 0x2178;
  t['ninesuperior'] = 0x2079;
  t['nineteencircle'] = 0x2472;
  t['nineteenparen'] = 0x2486;
  t['nineteenperiod'] = 0x249A;
  t['ninethai'] = 0x0E59;
  t['nj'] = 0x01CC;
  t['njecyrillic'] = 0x045A;
  t['nkatakana'] = 0x30F3;
  t['nkatakanahalfwidth'] = 0xFF9D;
  t['nlegrightlong'] = 0x019E;
  t['nlinebelow'] = 0x1E49;
  t['nmonospace'] = 0xFF4E;
  t['nmsquare'] = 0x339A;
  t['nnabengali'] = 0x09A3;
  t['nnadeva'] = 0x0923;
  t['nnagujarati'] = 0x0AA3;
  t['nnagurmukhi'] = 0x0A23;
  t['nnnadeva'] = 0x0929;
  t['nohiragana'] = 0x306E;
  t['nokatakana'] = 0x30CE;
  t['nokatakanahalfwidth'] = 0xFF89;
  t['nonbreakingspace'] = 0x00A0;
  t['nonenthai'] = 0x0E13;
  t['nonuthai'] = 0x0E19;
  t['noonarabic'] = 0x0646;
  t['noonfinalarabic'] = 0xFEE6;
  t['noonghunnaarabic'] = 0x06BA;
  t['noonghunnafinalarabic'] = 0xFB9F;
  t['nooninitialarabic'] = 0xFEE7;
  t['noonjeeminitialarabic'] = 0xFCD2;
  t['noonjeemisolatedarabic'] = 0xFC4B;
  t['noonmedialarabic'] = 0xFEE8;
  t['noonmeeminitialarabic'] = 0xFCD5;
  t['noonmeemisolatedarabic'] = 0xFC4E;
  t['noonnoonfinalarabic'] = 0xFC8D;
  t['notcontains'] = 0x220C;
  t['notelement'] = 0x2209;
  t['notelementof'] = 0x2209;
  t['notequal'] = 0x2260;
  t['notgreater'] = 0x226F;
  t['notgreaternorequal'] = 0x2271;
  t['notgreaternorless'] = 0x2279;
  t['notidentical'] = 0x2262;
  t['notless'] = 0x226E;
  t['notlessnorequal'] = 0x2270;
  t['notparallel'] = 0x2226;
  t['notprecedes'] = 0x2280;
  t['notsubset'] = 0x2284;
  t['notsucceeds'] = 0x2281;
  t['notsuperset'] = 0x2285;
  t['nowarmenian'] = 0x0576;
  t['nparen'] = 0x24A9;
  t['nssquare'] = 0x33B1;
  t['nsuperior'] = 0x207F;
  t['ntilde'] = 0x00F1;
  t['nu'] = 0x03BD;
  t['nuhiragana'] = 0x306C;
  t['nukatakana'] = 0x30CC;
  t['nukatakanahalfwidth'] = 0xFF87;
  t['nuktabengali'] = 0x09BC;
  t['nuktadeva'] = 0x093C;
  t['nuktagujarati'] = 0x0ABC;
  t['nuktagurmukhi'] = 0x0A3C;
  t['numbersign'] = 0x0023;
  t['numbersignmonospace'] = 0xFF03;
  t['numbersignsmall'] = 0xFE5F;
  t['numeralsigngreek'] = 0x0374;
  t['numeralsignlowergreek'] = 0x0375;
  t['numero'] = 0x2116;
  t['nun'] = 0x05E0;
  t['nundagesh'] = 0xFB40;
  t['nundageshhebrew'] = 0xFB40;
  t['nunhebrew'] = 0x05E0;
  t['nvsquare'] = 0x33B5;
  t['nwsquare'] = 0x33BB;
  t['nyabengali'] = 0x099E;
  t['nyadeva'] = 0x091E;
  t['nyagujarati'] = 0x0A9E;
  t['nyagurmukhi'] = 0x0A1E;
  t['o'] = 0x006F;
  t['oacute'] = 0x00F3;
  t['oangthai'] = 0x0E2D;
  t['obarred'] = 0x0275;
  t['obarredcyrillic'] = 0x04E9;
  t['obarreddieresiscyrillic'] = 0x04EB;
  t['obengali'] = 0x0993;
  t['obopomofo'] = 0x311B;
  t['obreve'] = 0x014F;
  t['ocandradeva'] = 0x0911;
  t['ocandragujarati'] = 0x0A91;
  t['ocandravowelsigndeva'] = 0x0949;
  t['ocandravowelsigngujarati'] = 0x0AC9;
  t['ocaron'] = 0x01D2;
  t['ocircle'] = 0x24DE;
  t['ocircumflex'] = 0x00F4;
  t['ocircumflexacute'] = 0x1ED1;
  t['ocircumflexdotbelow'] = 0x1ED9;
  t['ocircumflexgrave'] = 0x1ED3;
  t['ocircumflexhookabove'] = 0x1ED5;
  t['ocircumflextilde'] = 0x1ED7;
  t['ocyrillic'] = 0x043E;
  t['odblacute'] = 0x0151;
  t['odblgrave'] = 0x020D;
  t['odeva'] = 0x0913;
  t['odieresis'] = 0x00F6;
  t['odieresiscyrillic'] = 0x04E7;
  t['odotbelow'] = 0x1ECD;
  t['oe'] = 0x0153;
  t['oekorean'] = 0x315A;
  t['ogonek'] = 0x02DB;
  t['ogonekcmb'] = 0x0328;
  t['ograve'] = 0x00F2;
  t['ogujarati'] = 0x0A93;
  t['oharmenian'] = 0x0585;
  t['ohiragana'] = 0x304A;
  t['ohookabove'] = 0x1ECF;
  t['ohorn'] = 0x01A1;
  t['ohornacute'] = 0x1EDB;
  t['ohorndotbelow'] = 0x1EE3;
  t['ohorngrave'] = 0x1EDD;
  t['ohornhookabove'] = 0x1EDF;
  t['ohorntilde'] = 0x1EE1;
  t['ohungarumlaut'] = 0x0151;
  t['oi'] = 0x01A3;
  t['oinvertedbreve'] = 0x020F;
  t['okatakana'] = 0x30AA;
  t['okatakanahalfwidth'] = 0xFF75;
  t['okorean'] = 0x3157;
  t['olehebrew'] = 0x05AB;
  t['omacron'] = 0x014D;
  t['omacronacute'] = 0x1E53;
  t['omacrongrave'] = 0x1E51;
  t['omdeva'] = 0x0950;
  t['omega'] = 0x03C9;
  t['omega1'] = 0x03D6;
  t['omegacyrillic'] = 0x0461;
  t['omegalatinclosed'] = 0x0277;
  t['omegaroundcyrillic'] = 0x047B;
  t['omegatitlocyrillic'] = 0x047D;
  t['omegatonos'] = 0x03CE;
  t['omgujarati'] = 0x0AD0;
  t['omicron'] = 0x03BF;
  t['omicrontonos'] = 0x03CC;
  t['omonospace'] = 0xFF4F;
  t['one'] = 0x0031;
  t['onearabic'] = 0x0661;
  t['onebengali'] = 0x09E7;
  t['onecircle'] = 0x2460;
  t['onecircleinversesansserif'] = 0x278A;
  t['onedeva'] = 0x0967;
  t['onedotenleader'] = 0x2024;
  t['oneeighth'] = 0x215B;
  t['onefitted'] = 0xF6DC;
  t['onegujarati'] = 0x0AE7;
  t['onegurmukhi'] = 0x0A67;
  t['onehackarabic'] = 0x0661;
  t['onehalf'] = 0x00BD;
  t['onehangzhou'] = 0x3021;
  t['oneideographicparen'] = 0x3220;
  t['oneinferior'] = 0x2081;
  t['onemonospace'] = 0xFF11;
  t['onenumeratorbengali'] = 0x09F4;
  t['oneoldstyle'] = 0xF731;
  t['oneparen'] = 0x2474;
  t['oneperiod'] = 0x2488;
  t['onepersian'] = 0x06F1;
  t['onequarter'] = 0x00BC;
  t['oneroman'] = 0x2170;
  t['onesuperior'] = 0x00B9;
  t['onethai'] = 0x0E51;
  t['onethird'] = 0x2153;
  t['oogonek'] = 0x01EB;
  t['oogonekmacron'] = 0x01ED;
  t['oogurmukhi'] = 0x0A13;
  t['oomatragurmukhi'] = 0x0A4B;
  t['oopen'] = 0x0254;
  t['oparen'] = 0x24AA;
  t['openbullet'] = 0x25E6;
  t['option'] = 0x2325;
  t['ordfeminine'] = 0x00AA;
  t['ordmasculine'] = 0x00BA;
  t['orthogonal'] = 0x221F;
  t['oshortdeva'] = 0x0912;
  t['oshortvowelsigndeva'] = 0x094A;
  t['oslash'] = 0x00F8;
  t['oslashacute'] = 0x01FF;
  t['osmallhiragana'] = 0x3049;
  t['osmallkatakana'] = 0x30A9;
  t['osmallkatakanahalfwidth'] = 0xFF6B;
  t['ostrokeacute'] = 0x01FF;
  t['osuperior'] = 0xF6F0;
  t['otcyrillic'] = 0x047F;
  t['otilde'] = 0x00F5;
  t['otildeacute'] = 0x1E4D;
  t['otildedieresis'] = 0x1E4F;
  t['oubopomofo'] = 0x3121;
  t['overline'] = 0x203E;
  t['overlinecenterline'] = 0xFE4A;
  t['overlinecmb'] = 0x0305;
  t['overlinedashed'] = 0xFE49;
  t['overlinedblwavy'] = 0xFE4C;
  t['overlinewavy'] = 0xFE4B;
  t['overscore'] = 0x00AF;
  t['ovowelsignbengali'] = 0x09CB;
  t['ovowelsigndeva'] = 0x094B;
  t['ovowelsigngujarati'] = 0x0ACB;
  t['p'] = 0x0070;
  t['paampssquare'] = 0x3380;
  t['paasentosquare'] = 0x332B;
  t['pabengali'] = 0x09AA;
  t['pacute'] = 0x1E55;
  t['padeva'] = 0x092A;
  t['pagedown'] = 0x21DF;
  t['pageup'] = 0x21DE;
  t['pagujarati'] = 0x0AAA;
  t['pagurmukhi'] = 0x0A2A;
  t['pahiragana'] = 0x3071;
  t['paiyannoithai'] = 0x0E2F;
  t['pakatakana'] = 0x30D1;
  t['palatalizationcyrilliccmb'] = 0x0484;
  t['palochkacyrillic'] = 0x04C0;
  t['pansioskorean'] = 0x317F;
  t['paragraph'] = 0x00B6;
  t['parallel'] = 0x2225;
  t['parenleft'] = 0x0028;
  t['parenleftaltonearabic'] = 0xFD3E;
  t['parenleftbt'] = 0xF8ED;
  t['parenleftex'] = 0xF8EC;
  t['parenleftinferior'] = 0x208D;
  t['parenleftmonospace'] = 0xFF08;
  t['parenleftsmall'] = 0xFE59;
  t['parenleftsuperior'] = 0x207D;
  t['parenlefttp'] = 0xF8EB;
  t['parenleftvertical'] = 0xFE35;
  t['parenright'] = 0x0029;
  t['parenrightaltonearabic'] = 0xFD3F;
  t['parenrightbt'] = 0xF8F8;
  t['parenrightex'] = 0xF8F7;
  t['parenrightinferior'] = 0x208E;
  t['parenrightmonospace'] = 0xFF09;
  t['parenrightsmall'] = 0xFE5A;
  t['parenrightsuperior'] = 0x207E;
  t['parenrighttp'] = 0xF8F6;
  t['parenrightvertical'] = 0xFE36;
  t['partialdiff'] = 0x2202;
  t['paseqhebrew'] = 0x05C0;
  t['pashtahebrew'] = 0x0599;
  t['pasquare'] = 0x33A9;
  t['patah'] = 0x05B7;
  t['patah11'] = 0x05B7;
  t['patah1d'] = 0x05B7;
  t['patah2a'] = 0x05B7;
  t['patahhebrew'] = 0x05B7;
  t['patahnarrowhebrew'] = 0x05B7;
  t['patahquarterhebrew'] = 0x05B7;
  t['patahwidehebrew'] = 0x05B7;
  t['pazerhebrew'] = 0x05A1;
  t['pbopomofo'] = 0x3106;
  t['pcircle'] = 0x24DF;
  t['pdotaccent'] = 0x1E57;
  t['pe'] = 0x05E4;
  t['pecyrillic'] = 0x043F;
  t['pedagesh'] = 0xFB44;
  t['pedageshhebrew'] = 0xFB44;
  t['peezisquare'] = 0x333B;
  t['pefinaldageshhebrew'] = 0xFB43;
  t['peharabic'] = 0x067E;
  t['peharmenian'] = 0x057A;
  t['pehebrew'] = 0x05E4;
  t['pehfinalarabic'] = 0xFB57;
  t['pehinitialarabic'] = 0xFB58;
  t['pehiragana'] = 0x307A;
  t['pehmedialarabic'] = 0xFB59;
  t['pekatakana'] = 0x30DA;
  t['pemiddlehookcyrillic'] = 0x04A7;
  t['perafehebrew'] = 0xFB4E;
  t['percent'] = 0x0025;
  t['percentarabic'] = 0x066A;
  t['percentmonospace'] = 0xFF05;
  t['percentsmall'] = 0xFE6A;
  t['period'] = 0x002E;
  t['periodarmenian'] = 0x0589;
  t['periodcentered'] = 0x00B7;
  t['periodhalfwidth'] = 0xFF61;
  t['periodinferior'] = 0xF6E7;
  t['periodmonospace'] = 0xFF0E;
  t['periodsmall'] = 0xFE52;
  t['periodsuperior'] = 0xF6E8;
  t['perispomenigreekcmb'] = 0x0342;
  t['perpendicular'] = 0x22A5;
  t['perthousand'] = 0x2030;
  t['peseta'] = 0x20A7;
  t['pfsquare'] = 0x338A;
  t['phabengali'] = 0x09AB;
  t['phadeva'] = 0x092B;
  t['phagujarati'] = 0x0AAB;
  t['phagurmukhi'] = 0x0A2B;
  t['phi'] = 0x03C6;
  t['phi1'] = 0x03D5;
  t['phieuphacirclekorean'] = 0x327A;
  t['phieuphaparenkorean'] = 0x321A;
  t['phieuphcirclekorean'] = 0x326C;
  t['phieuphkorean'] = 0x314D;
  t['phieuphparenkorean'] = 0x320C;
  t['philatin'] = 0x0278;
  t['phinthuthai'] = 0x0E3A;
  t['phisymbolgreek'] = 0x03D5;
  t['phook'] = 0x01A5;
  t['phophanthai'] = 0x0E1E;
  t['phophungthai'] = 0x0E1C;
  t['phosamphaothai'] = 0x0E20;
  t['pi'] = 0x03C0;
  t['pieupacirclekorean'] = 0x3273;
  t['pieupaparenkorean'] = 0x3213;
  t['pieupcieuckorean'] = 0x3176;
  t['pieupcirclekorean'] = 0x3265;
  t['pieupkiyeokkorean'] = 0x3172;
  t['pieupkorean'] = 0x3142;
  t['pieupparenkorean'] = 0x3205;
  t['pieupsioskiyeokkorean'] = 0x3174;
  t['pieupsioskorean'] = 0x3144;
  t['pieupsiostikeutkorean'] = 0x3175;
  t['pieupthieuthkorean'] = 0x3177;
  t['pieuptikeutkorean'] = 0x3173;
  t['pihiragana'] = 0x3074;
  t['pikatakana'] = 0x30D4;
  t['pisymbolgreek'] = 0x03D6;
  t['piwrarmenian'] = 0x0583;
  t['plus'] = 0x002B;
  t['plusbelowcmb'] = 0x031F;
  t['pluscircle'] = 0x2295;
  t['plusminus'] = 0x00B1;
  t['plusmod'] = 0x02D6;
  t['plusmonospace'] = 0xFF0B;
  t['plussmall'] = 0xFE62;
  t['plussuperior'] = 0x207A;
  t['pmonospace'] = 0xFF50;
  t['pmsquare'] = 0x33D8;
  t['pohiragana'] = 0x307D;
  t['pointingindexdownwhite'] = 0x261F;
  t['pointingindexleftwhite'] = 0x261C;
  t['pointingindexrightwhite'] = 0x261E;
  t['pointingindexupwhite'] = 0x261D;
  t['pokatakana'] = 0x30DD;
  t['poplathai'] = 0x0E1B;
  t['postalmark'] = 0x3012;
  t['postalmarkface'] = 0x3020;
  t['pparen'] = 0x24AB;
  t['precedes'] = 0x227A;
  t['prescription'] = 0x211E;
  t['primemod'] = 0x02B9;
  t['primereversed'] = 0x2035;
  t['product'] = 0x220F;
  t['projective'] = 0x2305;
  t['prolongedkana'] = 0x30FC;
  t['propellor'] = 0x2318;
  t['propersubset'] = 0x2282;
  t['propersuperset'] = 0x2283;
  t['proportion'] = 0x2237;
  t['proportional'] = 0x221D;
  t['psi'] = 0x03C8;
  t['psicyrillic'] = 0x0471;
  t['psilipneumatacyrilliccmb'] = 0x0486;
  t['pssquare'] = 0x33B0;
  t['puhiragana'] = 0x3077;
  t['pukatakana'] = 0x30D7;
  t['pvsquare'] = 0x33B4;
  t['pwsquare'] = 0x33BA;
  t['q'] = 0x0071;
  t['qadeva'] = 0x0958;
  t['qadmahebrew'] = 0x05A8;
  t['qafarabic'] = 0x0642;
  t['qaffinalarabic'] = 0xFED6;
  t['qafinitialarabic'] = 0xFED7;
  t['qafmedialarabic'] = 0xFED8;
  t['qamats'] = 0x05B8;
  t['qamats10'] = 0x05B8;
  t['qamats1a'] = 0x05B8;
  t['qamats1c'] = 0x05B8;
  t['qamats27'] = 0x05B8;
  t['qamats29'] = 0x05B8;
  t['qamats33'] = 0x05B8;
  t['qamatsde'] = 0x05B8;
  t['qamatshebrew'] = 0x05B8;
  t['qamatsnarrowhebrew'] = 0x05B8;
  t['qamatsqatanhebrew'] = 0x05B8;
  t['qamatsqatannarrowhebrew'] = 0x05B8;
  t['qamatsqatanquarterhebrew'] = 0x05B8;
  t['qamatsqatanwidehebrew'] = 0x05B8;
  t['qamatsquarterhebrew'] = 0x05B8;
  t['qamatswidehebrew'] = 0x05B8;
  t['qarneyparahebrew'] = 0x059F;
  t['qbopomofo'] = 0x3111;
  t['qcircle'] = 0x24E0;
  t['qhook'] = 0x02A0;
  t['qmonospace'] = 0xFF51;
  t['qof'] = 0x05E7;
  t['qofdagesh'] = 0xFB47;
  t['qofdageshhebrew'] = 0xFB47;
  t['qofhebrew'] = 0x05E7;
  t['qparen'] = 0x24AC;
  t['quarternote'] = 0x2669;
  t['qubuts'] = 0x05BB;
  t['qubuts18'] = 0x05BB;
  t['qubuts25'] = 0x05BB;
  t['qubuts31'] = 0x05BB;
  t['qubutshebrew'] = 0x05BB;
  t['qubutsnarrowhebrew'] = 0x05BB;
  t['qubutsquarterhebrew'] = 0x05BB;
  t['qubutswidehebrew'] = 0x05BB;
  t['question'] = 0x003F;
  t['questionarabic'] = 0x061F;
  t['questionarmenian'] = 0x055E;
  t['questiondown'] = 0x00BF;
  t['questiondownsmall'] = 0xF7BF;
  t['questiongreek'] = 0x037E;
  t['questionmonospace'] = 0xFF1F;
  t['questionsmall'] = 0xF73F;
  t['quotedbl'] = 0x0022;
  t['quotedblbase'] = 0x201E;
  t['quotedblleft'] = 0x201C;
  t['quotedblmonospace'] = 0xFF02;
  t['quotedblprime'] = 0x301E;
  t['quotedblprimereversed'] = 0x301D;
  t['quotedblright'] = 0x201D;
  t['quoteleft'] = 0x2018;
  t['quoteleftreversed'] = 0x201B;
  t['quotereversed'] = 0x201B;
  t['quoteright'] = 0x2019;
  t['quoterightn'] = 0x0149;
  t['quotesinglbase'] = 0x201A;
  t['quotesingle'] = 0x0027;
  t['quotesinglemonospace'] = 0xFF07;
  t['r'] = 0x0072;
  t['raarmenian'] = 0x057C;
  t['rabengali'] = 0x09B0;
  t['racute'] = 0x0155;
  t['radeva'] = 0x0930;
  t['radical'] = 0x221A;
  t['radicalex'] = 0xF8E5;
  t['radoverssquare'] = 0x33AE;
  t['radoverssquaredsquare'] = 0x33AF;
  t['radsquare'] = 0x33AD;
  t['rafe'] = 0x05BF;
  t['rafehebrew'] = 0x05BF;
  t['ragujarati'] = 0x0AB0;
  t['ragurmukhi'] = 0x0A30;
  t['rahiragana'] = 0x3089;
  t['rakatakana'] = 0x30E9;
  t['rakatakanahalfwidth'] = 0xFF97;
  t['ralowerdiagonalbengali'] = 0x09F1;
  t['ramiddlediagonalbengali'] = 0x09F0;
  t['ramshorn'] = 0x0264;
  t['ratio'] = 0x2236;
  t['rbopomofo'] = 0x3116;
  t['rcaron'] = 0x0159;
  t['rcedilla'] = 0x0157;
  t['rcircle'] = 0x24E1;
  t['rcommaaccent'] = 0x0157;
  t['rdblgrave'] = 0x0211;
  t['rdotaccent'] = 0x1E59;
  t['rdotbelow'] = 0x1E5B;
  t['rdotbelowmacron'] = 0x1E5D;
  t['referencemark'] = 0x203B;
  t['reflexsubset'] = 0x2286;
  t['reflexsuperset'] = 0x2287;
  t['registered'] = 0x00AE;
  t['registersans'] = 0xF8E8;
  t['registerserif'] = 0xF6DA;
  t['reharabic'] = 0x0631;
  t['reharmenian'] = 0x0580;
  t['rehfinalarabic'] = 0xFEAE;
  t['rehiragana'] = 0x308C;
  t['rekatakana'] = 0x30EC;
  t['rekatakanahalfwidth'] = 0xFF9A;
  t['resh'] = 0x05E8;
  t['reshdageshhebrew'] = 0xFB48;
  t['reshhebrew'] = 0x05E8;
  t['reversedtilde'] = 0x223D;
  t['reviahebrew'] = 0x0597;
  t['reviamugrashhebrew'] = 0x0597;
  t['revlogicalnot'] = 0x2310;
  t['rfishhook'] = 0x027E;
  t['rfishhookreversed'] = 0x027F;
  t['rhabengali'] = 0x09DD;
  t['rhadeva'] = 0x095D;
  t['rho'] = 0x03C1;
  t['rhook'] = 0x027D;
  t['rhookturned'] = 0x027B;
  t['rhookturnedsuperior'] = 0x02B5;
  t['rhosymbolgreek'] = 0x03F1;
  t['rhotichookmod'] = 0x02DE;
  t['rieulacirclekorean'] = 0x3271;
  t['rieulaparenkorean'] = 0x3211;
  t['rieulcirclekorean'] = 0x3263;
  t['rieulhieuhkorean'] = 0x3140;
  t['rieulkiyeokkorean'] = 0x313A;
  t['rieulkiyeoksioskorean'] = 0x3169;
  t['rieulkorean'] = 0x3139;
  t['rieulmieumkorean'] = 0x313B;
  t['rieulpansioskorean'] = 0x316C;
  t['rieulparenkorean'] = 0x3203;
  t['rieulphieuphkorean'] = 0x313F;
  t['rieulpieupkorean'] = 0x313C;
  t['rieulpieupsioskorean'] = 0x316B;
  t['rieulsioskorean'] = 0x313D;
  t['rieulthieuthkorean'] = 0x313E;
  t['rieultikeutkorean'] = 0x316A;
  t['rieulyeorinhieuhkorean'] = 0x316D;
  t['rightangle'] = 0x221F;
  t['righttackbelowcmb'] = 0x0319;
  t['righttriangle'] = 0x22BF;
  t['rihiragana'] = 0x308A;
  t['rikatakana'] = 0x30EA;
  t['rikatakanahalfwidth'] = 0xFF98;
  t['ring'] = 0x02DA;
  t['ringbelowcmb'] = 0x0325;
  t['ringcmb'] = 0x030A;
  t['ringhalfleft'] = 0x02BF;
  t['ringhalfleftarmenian'] = 0x0559;
  t['ringhalfleftbelowcmb'] = 0x031C;
  t['ringhalfleftcentered'] = 0x02D3;
  t['ringhalfright'] = 0x02BE;
  t['ringhalfrightbelowcmb'] = 0x0339;
  t['ringhalfrightcentered'] = 0x02D2;
  t['rinvertedbreve'] = 0x0213;
  t['rittorusquare'] = 0x3351;
  t['rlinebelow'] = 0x1E5F;
  t['rlongleg'] = 0x027C;
  t['rlonglegturned'] = 0x027A;
  t['rmonospace'] = 0xFF52;
  t['rohiragana'] = 0x308D;
  t['rokatakana'] = 0x30ED;
  t['rokatakanahalfwidth'] = 0xFF9B;
  t['roruathai'] = 0x0E23;
  t['rparen'] = 0x24AD;
  t['rrabengali'] = 0x09DC;
  t['rradeva'] = 0x0931;
  t['rragurmukhi'] = 0x0A5C;
  t['rreharabic'] = 0x0691;
  t['rrehfinalarabic'] = 0xFB8D;
  t['rrvocalicbengali'] = 0x09E0;
  t['rrvocalicdeva'] = 0x0960;
  t['rrvocalicgujarati'] = 0x0AE0;
  t['rrvocalicvowelsignbengali'] = 0x09C4;
  t['rrvocalicvowelsigndeva'] = 0x0944;
  t['rrvocalicvowelsigngujarati'] = 0x0AC4;
  t['rsuperior'] = 0xF6F1;
  t['rtblock'] = 0x2590;
  t['rturned'] = 0x0279;
  t['rturnedsuperior'] = 0x02B4;
  t['ruhiragana'] = 0x308B;
  t['rukatakana'] = 0x30EB;
  t['rukatakanahalfwidth'] = 0xFF99;
  t['rupeemarkbengali'] = 0x09F2;
  t['rupeesignbengali'] = 0x09F3;
  t['rupiah'] = 0xF6DD;
  t['ruthai'] = 0x0E24;
  t['rvocalicbengali'] = 0x098B;
  t['rvocalicdeva'] = 0x090B;
  t['rvocalicgujarati'] = 0x0A8B;
  t['rvocalicvowelsignbengali'] = 0x09C3;
  t['rvocalicvowelsigndeva'] = 0x0943;
  t['rvocalicvowelsigngujarati'] = 0x0AC3;
  t['s'] = 0x0073;
  t['sabengali'] = 0x09B8;
  t['sacute'] = 0x015B;
  t['sacutedotaccent'] = 0x1E65;
  t['sadarabic'] = 0x0635;
  t['sadeva'] = 0x0938;
  t['sadfinalarabic'] = 0xFEBA;
  t['sadinitialarabic'] = 0xFEBB;
  t['sadmedialarabic'] = 0xFEBC;
  t['sagujarati'] = 0x0AB8;
  t['sagurmukhi'] = 0x0A38;
  t['sahiragana'] = 0x3055;
  t['sakatakana'] = 0x30B5;
  t['sakatakanahalfwidth'] = 0xFF7B;
  t['sallallahoualayhewasallamarabic'] = 0xFDFA;
  t['samekh'] = 0x05E1;
  t['samekhdagesh'] = 0xFB41;
  t['samekhdageshhebrew'] = 0xFB41;
  t['samekhhebrew'] = 0x05E1;
  t['saraaathai'] = 0x0E32;
  t['saraaethai'] = 0x0E41;
  t['saraaimaimalaithai'] = 0x0E44;
  t['saraaimaimuanthai'] = 0x0E43;
  t['saraamthai'] = 0x0E33;
  t['saraathai'] = 0x0E30;
  t['saraethai'] = 0x0E40;
  t['saraiileftthai'] = 0xF886;
  t['saraiithai'] = 0x0E35;
  t['saraileftthai'] = 0xF885;
  t['saraithai'] = 0x0E34;
  t['saraothai'] = 0x0E42;
  t['saraueeleftthai'] = 0xF888;
  t['saraueethai'] = 0x0E37;
  t['saraueleftthai'] = 0xF887;
  t['sarauethai'] = 0x0E36;
  t['sarauthai'] = 0x0E38;
  t['sarauuthai'] = 0x0E39;
  t['sbopomofo'] = 0x3119;
  t['scaron'] = 0x0161;
  t['scarondotaccent'] = 0x1E67;
  t['scedilla'] = 0x015F;
  t['schwa'] = 0x0259;
  t['schwacyrillic'] = 0x04D9;
  t['schwadieresiscyrillic'] = 0x04DB;
  t['schwahook'] = 0x025A;
  t['scircle'] = 0x24E2;
  t['scircumflex'] = 0x015D;
  t['scommaaccent'] = 0x0219;
  t['sdotaccent'] = 0x1E61;
  t['sdotbelow'] = 0x1E63;
  t['sdotbelowdotaccent'] = 0x1E69;
  t['seagullbelowcmb'] = 0x033C;
  t['second'] = 0x2033;
  t['secondtonechinese'] = 0x02CA;
  t['section'] = 0x00A7;
  t['seenarabic'] = 0x0633;
  t['seenfinalarabic'] = 0xFEB2;
  t['seeninitialarabic'] = 0xFEB3;
  t['seenmedialarabic'] = 0xFEB4;
  t['segol'] = 0x05B6;
  t['segol13'] = 0x05B6;
  t['segol1f'] = 0x05B6;
  t['segol2c'] = 0x05B6;
  t['segolhebrew'] = 0x05B6;
  t['segolnarrowhebrew'] = 0x05B6;
  t['segolquarterhebrew'] = 0x05B6;
  t['segoltahebrew'] = 0x0592;
  t['segolwidehebrew'] = 0x05B6;
  t['seharmenian'] = 0x057D;
  t['sehiragana'] = 0x305B;
  t['sekatakana'] = 0x30BB;
  t['sekatakanahalfwidth'] = 0xFF7E;
  t['semicolon'] = 0x003B;
  t['semicolonarabic'] = 0x061B;
  t['semicolonmonospace'] = 0xFF1B;
  t['semicolonsmall'] = 0xFE54;
  t['semivoicedmarkkana'] = 0x309C;
  t['semivoicedmarkkanahalfwidth'] = 0xFF9F;
  t['sentisquare'] = 0x3322;
  t['sentosquare'] = 0x3323;
  t['seven'] = 0x0037;
  t['sevenarabic'] = 0x0667;
  t['sevenbengali'] = 0x09ED;
  t['sevencircle'] = 0x2466;
  t['sevencircleinversesansserif'] = 0x2790;
  t['sevendeva'] = 0x096D;
  t['seveneighths'] = 0x215E;
  t['sevengujarati'] = 0x0AED;
  t['sevengurmukhi'] = 0x0A6D;
  t['sevenhackarabic'] = 0x0667;
  t['sevenhangzhou'] = 0x3027;
  t['sevenideographicparen'] = 0x3226;
  t['seveninferior'] = 0x2087;
  t['sevenmonospace'] = 0xFF17;
  t['sevenoldstyle'] = 0xF737;
  t['sevenparen'] = 0x247A;
  t['sevenperiod'] = 0x248E;
  t['sevenpersian'] = 0x06F7;
  t['sevenroman'] = 0x2176;
  t['sevensuperior'] = 0x2077;
  t['seventeencircle'] = 0x2470;
  t['seventeenparen'] = 0x2484;
  t['seventeenperiod'] = 0x2498;
  t['seventhai'] = 0x0E57;
  t['sfthyphen'] = 0x00AD;
  t['shaarmenian'] = 0x0577;
  t['shabengali'] = 0x09B6;
  t['shacyrillic'] = 0x0448;
  t['shaddaarabic'] = 0x0651;
  t['shaddadammaarabic'] = 0xFC61;
  t['shaddadammatanarabic'] = 0xFC5E;
  t['shaddafathaarabic'] = 0xFC60;
  t['shaddakasraarabic'] = 0xFC62;
  t['shaddakasratanarabic'] = 0xFC5F;
  t['shade'] = 0x2592;
  t['shadedark'] = 0x2593;
  t['shadelight'] = 0x2591;
  t['shademedium'] = 0x2592;
  t['shadeva'] = 0x0936;
  t['shagujarati'] = 0x0AB6;
  t['shagurmukhi'] = 0x0A36;
  t['shalshelethebrew'] = 0x0593;
  t['shbopomofo'] = 0x3115;
  t['shchacyrillic'] = 0x0449;
  t['sheenarabic'] = 0x0634;
  t['sheenfinalarabic'] = 0xFEB6;
  t['sheeninitialarabic'] = 0xFEB7;
  t['sheenmedialarabic'] = 0xFEB8;
  t['sheicoptic'] = 0x03E3;
  t['sheqel'] = 0x20AA;
  t['sheqelhebrew'] = 0x20AA;
  t['sheva'] = 0x05B0;
  t['sheva115'] = 0x05B0;
  t['sheva15'] = 0x05B0;
  t['sheva22'] = 0x05B0;
  t['sheva2e'] = 0x05B0;
  t['shevahebrew'] = 0x05B0;
  t['shevanarrowhebrew'] = 0x05B0;
  t['shevaquarterhebrew'] = 0x05B0;
  t['shevawidehebrew'] = 0x05B0;
  t['shhacyrillic'] = 0x04BB;
  t['shimacoptic'] = 0x03ED;
  t['shin'] = 0x05E9;
  t['shindagesh'] = 0xFB49;
  t['shindageshhebrew'] = 0xFB49;
  t['shindageshshindot'] = 0xFB2C;
  t['shindageshshindothebrew'] = 0xFB2C;
  t['shindageshsindot'] = 0xFB2D;
  t['shindageshsindothebrew'] = 0xFB2D;
  t['shindothebrew'] = 0x05C1;
  t['shinhebrew'] = 0x05E9;
  t['shinshindot'] = 0xFB2A;
  t['shinshindothebrew'] = 0xFB2A;
  t['shinsindot'] = 0xFB2B;
  t['shinsindothebrew'] = 0xFB2B;
  t['shook'] = 0x0282;
  t['sigma'] = 0x03C3;
  t['sigma1'] = 0x03C2;
  t['sigmafinal'] = 0x03C2;
  t['sigmalunatesymbolgreek'] = 0x03F2;
  t['sihiragana'] = 0x3057;
  t['sikatakana'] = 0x30B7;
  t['sikatakanahalfwidth'] = 0xFF7C;
  t['siluqhebrew'] = 0x05BD;
  t['siluqlefthebrew'] = 0x05BD;
  t['similar'] = 0x223C;
  t['sindothebrew'] = 0x05C2;
  t['siosacirclekorean'] = 0x3274;
  t['siosaparenkorean'] = 0x3214;
  t['sioscieuckorean'] = 0x317E;
  t['sioscirclekorean'] = 0x3266;
  t['sioskiyeokkorean'] = 0x317A;
  t['sioskorean'] = 0x3145;
  t['siosnieunkorean'] = 0x317B;
  t['siosparenkorean'] = 0x3206;
  t['siospieupkorean'] = 0x317D;
  t['siostikeutkorean'] = 0x317C;
  t['six'] = 0x0036;
  t['sixarabic'] = 0x0666;
  t['sixbengali'] = 0x09EC;
  t['sixcircle'] = 0x2465;
  t['sixcircleinversesansserif'] = 0x278F;
  t['sixdeva'] = 0x096C;
  t['sixgujarati'] = 0x0AEC;
  t['sixgurmukhi'] = 0x0A6C;
  t['sixhackarabic'] = 0x0666;
  t['sixhangzhou'] = 0x3026;
  t['sixideographicparen'] = 0x3225;
  t['sixinferior'] = 0x2086;
  t['sixmonospace'] = 0xFF16;
  t['sixoldstyle'] = 0xF736;
  t['sixparen'] = 0x2479;
  t['sixperiod'] = 0x248D;
  t['sixpersian'] = 0x06F6;
  t['sixroman'] = 0x2175;
  t['sixsuperior'] = 0x2076;
  t['sixteencircle'] = 0x246F;
  t['sixteencurrencydenominatorbengali'] = 0x09F9;
  t['sixteenparen'] = 0x2483;
  t['sixteenperiod'] = 0x2497;
  t['sixthai'] = 0x0E56;
  t['slash'] = 0x002F;
  t['slashmonospace'] = 0xFF0F;
  t['slong'] = 0x017F;
  t['slongdotaccent'] = 0x1E9B;
  t['smileface'] = 0x263A;
  t['smonospace'] = 0xFF53;
  t['sofpasuqhebrew'] = 0x05C3;
  t['softhyphen'] = 0x00AD;
  t['softsigncyrillic'] = 0x044C;
  t['sohiragana'] = 0x305D;
  t['sokatakana'] = 0x30BD;
  t['sokatakanahalfwidth'] = 0xFF7F;
  t['soliduslongoverlaycmb'] = 0x0338;
  t['solidusshortoverlaycmb'] = 0x0337;
  t['sorusithai'] = 0x0E29;
  t['sosalathai'] = 0x0E28;
  t['sosothai'] = 0x0E0B;
  t['sosuathai'] = 0x0E2A;
  t['space'] = 0x0020;
  t['spacehackarabic'] = 0x0020;
  t['spade'] = 0x2660;
  t['spadesuitblack'] = 0x2660;
  t['spadesuitwhite'] = 0x2664;
  t['sparen'] = 0x24AE;
  t['squarebelowcmb'] = 0x033B;
  t['squarecc'] = 0x33C4;
  t['squarecm'] = 0x339D;
  t['squarediagonalcrosshatchfill'] = 0x25A9;
  t['squarehorizontalfill'] = 0x25A4;
  t['squarekg'] = 0x338F;
  t['squarekm'] = 0x339E;
  t['squarekmcapital'] = 0x33CE;
  t['squareln'] = 0x33D1;
  t['squarelog'] = 0x33D2;
  t['squaremg'] = 0x338E;
  t['squaremil'] = 0x33D5;
  t['squaremm'] = 0x339C;
  t['squaremsquared'] = 0x33A1;
  t['squareorthogonalcrosshatchfill'] = 0x25A6;
  t['squareupperlefttolowerrightfill'] = 0x25A7;
  t['squareupperrighttolowerleftfill'] = 0x25A8;
  t['squareverticalfill'] = 0x25A5;
  t['squarewhitewithsmallblack'] = 0x25A3;
  t['srsquare'] = 0x33DB;
  t['ssabengali'] = 0x09B7;
  t['ssadeva'] = 0x0937;
  t['ssagujarati'] = 0x0AB7;
  t['ssangcieuckorean'] = 0x3149;
  t['ssanghieuhkorean'] = 0x3185;
  t['ssangieungkorean'] = 0x3180;
  t['ssangkiyeokkorean'] = 0x3132;
  t['ssangnieunkorean'] = 0x3165;
  t['ssangpieupkorean'] = 0x3143;
  t['ssangsioskorean'] = 0x3146;
  t['ssangtikeutkorean'] = 0x3138;
  t['ssuperior'] = 0xF6F2;
  t['sterling'] = 0x00A3;
  t['sterlingmonospace'] = 0xFFE1;
  t['strokelongoverlaycmb'] = 0x0336;
  t['strokeshortoverlaycmb'] = 0x0335;
  t['subset'] = 0x2282;
  t['subsetnotequal'] = 0x228A;
  t['subsetorequal'] = 0x2286;
  t['succeeds'] = 0x227B;
  t['suchthat'] = 0x220B;
  t['suhiragana'] = 0x3059;
  t['sukatakana'] = 0x30B9;
  t['sukatakanahalfwidth'] = 0xFF7D;
  t['sukunarabic'] = 0x0652;
  t['summation'] = 0x2211;
  t['sun'] = 0x263C;
  t['superset'] = 0x2283;
  t['supersetnotequal'] = 0x228B;
  t['supersetorequal'] = 0x2287;
  t['svsquare'] = 0x33DC;
  t['syouwaerasquare'] = 0x337C;
  t['t'] = 0x0074;
  t['tabengali'] = 0x09A4;
  t['tackdown'] = 0x22A4;
  t['tackleft'] = 0x22A3;
  t['tadeva'] = 0x0924;
  t['tagujarati'] = 0x0AA4;
  t['tagurmukhi'] = 0x0A24;
  t['taharabic'] = 0x0637;
  t['tahfinalarabic'] = 0xFEC2;
  t['tahinitialarabic'] = 0xFEC3;
  t['tahiragana'] = 0x305F;
  t['tahmedialarabic'] = 0xFEC4;
  t['taisyouerasquare'] = 0x337D;
  t['takatakana'] = 0x30BF;
  t['takatakanahalfwidth'] = 0xFF80;
  t['tatweelarabic'] = 0x0640;
  t['tau'] = 0x03C4;
  t['tav'] = 0x05EA;
  t['tavdages'] = 0xFB4A;
  t['tavdagesh'] = 0xFB4A;
  t['tavdageshhebrew'] = 0xFB4A;
  t['tavhebrew'] = 0x05EA;
  t['tbar'] = 0x0167;
  t['tbopomofo'] = 0x310A;
  t['tcaron'] = 0x0165;
  t['tccurl'] = 0x02A8;
  t['tcedilla'] = 0x0163;
  t['tcheharabic'] = 0x0686;
  t['tchehfinalarabic'] = 0xFB7B;
  t['tchehinitialarabic'] = 0xFB7C;
  t['tchehmedialarabic'] = 0xFB7D;
  t['tcircle'] = 0x24E3;
  t['tcircumflexbelow'] = 0x1E71;
  t['tcommaaccent'] = 0x0163;
  t['tdieresis'] = 0x1E97;
  t['tdotaccent'] = 0x1E6B;
  t['tdotbelow'] = 0x1E6D;
  t['tecyrillic'] = 0x0442;
  t['tedescendercyrillic'] = 0x04AD;
  t['teharabic'] = 0x062A;
  t['tehfinalarabic'] = 0xFE96;
  t['tehhahinitialarabic'] = 0xFCA2;
  t['tehhahisolatedarabic'] = 0xFC0C;
  t['tehinitialarabic'] = 0xFE97;
  t['tehiragana'] = 0x3066;
  t['tehjeeminitialarabic'] = 0xFCA1;
  t['tehjeemisolatedarabic'] = 0xFC0B;
  t['tehmarbutaarabic'] = 0x0629;
  t['tehmarbutafinalarabic'] = 0xFE94;
  t['tehmedialarabic'] = 0xFE98;
  t['tehmeeminitialarabic'] = 0xFCA4;
  t['tehmeemisolatedarabic'] = 0xFC0E;
  t['tehnoonfinalarabic'] = 0xFC73;
  t['tekatakana'] = 0x30C6;
  t['tekatakanahalfwidth'] = 0xFF83;
  t['telephone'] = 0x2121;
  t['telephoneblack'] = 0x260E;
  t['telishagedolahebrew'] = 0x05A0;
  t['telishaqetanahebrew'] = 0x05A9;
  t['tencircle'] = 0x2469;
  t['tenideographicparen'] = 0x3229;
  t['tenparen'] = 0x247D;
  t['tenperiod'] = 0x2491;
  t['tenroman'] = 0x2179;
  t['tesh'] = 0x02A7;
  t['tet'] = 0x05D8;
  t['tetdagesh'] = 0xFB38;
  t['tetdageshhebrew'] = 0xFB38;
  t['tethebrew'] = 0x05D8;
  t['tetsecyrillic'] = 0x04B5;
  t['tevirhebrew'] = 0x059B;
  t['tevirlefthebrew'] = 0x059B;
  t['thabengali'] = 0x09A5;
  t['thadeva'] = 0x0925;
  t['thagujarati'] = 0x0AA5;
  t['thagurmukhi'] = 0x0A25;
  t['thalarabic'] = 0x0630;
  t['thalfinalarabic'] = 0xFEAC;
  t['thanthakhatlowleftthai'] = 0xF898;
  t['thanthakhatlowrightthai'] = 0xF897;
  t['thanthakhatthai'] = 0x0E4C;
  t['thanthakhatupperleftthai'] = 0xF896;
  t['theharabic'] = 0x062B;
  t['thehfinalarabic'] = 0xFE9A;
  t['thehinitialarabic'] = 0xFE9B;
  t['thehmedialarabic'] = 0xFE9C;
  t['thereexists'] = 0x2203;
  t['therefore'] = 0x2234;
  t['theta'] = 0x03B8;
  t['theta1'] = 0x03D1;
  t['thetasymbolgreek'] = 0x03D1;
  t['thieuthacirclekorean'] = 0x3279;
  t['thieuthaparenkorean'] = 0x3219;
  t['thieuthcirclekorean'] = 0x326B;
  t['thieuthkorean'] = 0x314C;
  t['thieuthparenkorean'] = 0x320B;
  t['thirteencircle'] = 0x246C;
  t['thirteenparen'] = 0x2480;
  t['thirteenperiod'] = 0x2494;
  t['thonangmonthothai'] = 0x0E11;
  t['thook'] = 0x01AD;
  t['thophuthaothai'] = 0x0E12;
  t['thorn'] = 0x00FE;
  t['thothahanthai'] = 0x0E17;
  t['thothanthai'] = 0x0E10;
  t['thothongthai'] = 0x0E18;
  t['thothungthai'] = 0x0E16;
  t['thousandcyrillic'] = 0x0482;
  t['thousandsseparatorarabic'] = 0x066C;
  t['thousandsseparatorpersian'] = 0x066C;
  t['three'] = 0x0033;
  t['threearabic'] = 0x0663;
  t['threebengali'] = 0x09E9;
  t['threecircle'] = 0x2462;
  t['threecircleinversesansserif'] = 0x278C;
  t['threedeva'] = 0x0969;
  t['threeeighths'] = 0x215C;
  t['threegujarati'] = 0x0AE9;
  t['threegurmukhi'] = 0x0A69;
  t['threehackarabic'] = 0x0663;
  t['threehangzhou'] = 0x3023;
  t['threeideographicparen'] = 0x3222;
  t['threeinferior'] = 0x2083;
  t['threemonospace'] = 0xFF13;
  t['threenumeratorbengali'] = 0x09F6;
  t['threeoldstyle'] = 0xF733;
  t['threeparen'] = 0x2476;
  t['threeperiod'] = 0x248A;
  t['threepersian'] = 0x06F3;
  t['threequarters'] = 0x00BE;
  t['threequartersemdash'] = 0xF6DE;
  t['threeroman'] = 0x2172;
  t['threesuperior'] = 0x00B3;
  t['threethai'] = 0x0E53;
  t['thzsquare'] = 0x3394;
  t['tihiragana'] = 0x3061;
  t['tikatakana'] = 0x30C1;
  t['tikatakanahalfwidth'] = 0xFF81;
  t['tikeutacirclekorean'] = 0x3270;
  t['tikeutaparenkorean'] = 0x3210;
  t['tikeutcirclekorean'] = 0x3262;
  t['tikeutkorean'] = 0x3137;
  t['tikeutparenkorean'] = 0x3202;
  t['tilde'] = 0x02DC;
  t['tildebelowcmb'] = 0x0330;
  t['tildecmb'] = 0x0303;
  t['tildecomb'] = 0x0303;
  t['tildedoublecmb'] = 0x0360;
  t['tildeoperator'] = 0x223C;
  t['tildeoverlaycmb'] = 0x0334;
  t['tildeverticalcmb'] = 0x033E;
  t['timescircle'] = 0x2297;
  t['tipehahebrew'] = 0x0596;
  t['tipehalefthebrew'] = 0x0596;
  t['tippigurmukhi'] = 0x0A70;
  t['titlocyrilliccmb'] = 0x0483;
  t['tiwnarmenian'] = 0x057F;
  t['tlinebelow'] = 0x1E6F;
  t['tmonospace'] = 0xFF54;
  t['toarmenian'] = 0x0569;
  t['tohiragana'] = 0x3068;
  t['tokatakana'] = 0x30C8;
  t['tokatakanahalfwidth'] = 0xFF84;
  t['tonebarextrahighmod'] = 0x02E5;
  t['tonebarextralowmod'] = 0x02E9;
  t['tonebarhighmod'] = 0x02E6;
  t['tonebarlowmod'] = 0x02E8;
  t['tonebarmidmod'] = 0x02E7;
  t['tonefive'] = 0x01BD;
  t['tonesix'] = 0x0185;
  t['tonetwo'] = 0x01A8;
  t['tonos'] = 0x0384;
  t['tonsquare'] = 0x3327;
  t['topatakthai'] = 0x0E0F;
  t['tortoiseshellbracketleft'] = 0x3014;
  t['tortoiseshellbracketleftsmall'] = 0xFE5D;
  t['tortoiseshellbracketleftvertical'] = 0xFE39;
  t['tortoiseshellbracketright'] = 0x3015;
  t['tortoiseshellbracketrightsmall'] = 0xFE5E;
  t['tortoiseshellbracketrightvertical'] = 0xFE3A;
  t['totaothai'] = 0x0E15;
  t['tpalatalhook'] = 0x01AB;
  t['tparen'] = 0x24AF;
  t['trademark'] = 0x2122;
  t['trademarksans'] = 0xF8EA;
  t['trademarkserif'] = 0xF6DB;
  t['tretroflexhook'] = 0x0288;
  t['triagdn'] = 0x25BC;
  t['triaglf'] = 0x25C4;
  t['triagrt'] = 0x25BA;
  t['triagup'] = 0x25B2;
  t['ts'] = 0x02A6;
  t['tsadi'] = 0x05E6;
  t['tsadidagesh'] = 0xFB46;
  t['tsadidageshhebrew'] = 0xFB46;
  t['tsadihebrew'] = 0x05E6;
  t['tsecyrillic'] = 0x0446;
  t['tsere'] = 0x05B5;
  t['tsere12'] = 0x05B5;
  t['tsere1e'] = 0x05B5;
  t['tsere2b'] = 0x05B5;
  t['tserehebrew'] = 0x05B5;
  t['tserenarrowhebrew'] = 0x05B5;
  t['tserequarterhebrew'] = 0x05B5;
  t['tserewidehebrew'] = 0x05B5;
  t['tshecyrillic'] = 0x045B;
  t['tsuperior'] = 0xF6F3;
  t['ttabengali'] = 0x099F;
  t['ttadeva'] = 0x091F;
  t['ttagujarati'] = 0x0A9F;
  t['ttagurmukhi'] = 0x0A1F;
  t['tteharabic'] = 0x0679;
  t['ttehfinalarabic'] = 0xFB67;
  t['ttehinitialarabic'] = 0xFB68;
  t['ttehmedialarabic'] = 0xFB69;
  t['tthabengali'] = 0x09A0;
  t['tthadeva'] = 0x0920;
  t['tthagujarati'] = 0x0AA0;
  t['tthagurmukhi'] = 0x0A20;
  t['tturned'] = 0x0287;
  t['tuhiragana'] = 0x3064;
  t['tukatakana'] = 0x30C4;
  t['tukatakanahalfwidth'] = 0xFF82;
  t['tusmallhiragana'] = 0x3063;
  t['tusmallkatakana'] = 0x30C3;
  t['tusmallkatakanahalfwidth'] = 0xFF6F;
  t['twelvecircle'] = 0x246B;
  t['twelveparen'] = 0x247F;
  t['twelveperiod'] = 0x2493;
  t['twelveroman'] = 0x217B;
  t['twentycircle'] = 0x2473;
  t['twentyhangzhou'] = 0x5344;
  t['twentyparen'] = 0x2487;
  t['twentyperiod'] = 0x249B;
  t['two'] = 0x0032;
  t['twoarabic'] = 0x0662;
  t['twobengali'] = 0x09E8;
  t['twocircle'] = 0x2461;
  t['twocircleinversesansserif'] = 0x278B;
  t['twodeva'] = 0x0968;
  t['twodotenleader'] = 0x2025;
  t['twodotleader'] = 0x2025;
  t['twodotleadervertical'] = 0xFE30;
  t['twogujarati'] = 0x0AE8;
  t['twogurmukhi'] = 0x0A68;
  t['twohackarabic'] = 0x0662;
  t['twohangzhou'] = 0x3022;
  t['twoideographicparen'] = 0x3221;
  t['twoinferior'] = 0x2082;
  t['twomonospace'] = 0xFF12;
  t['twonumeratorbengali'] = 0x09F5;
  t['twooldstyle'] = 0xF732;
  t['twoparen'] = 0x2475;
  t['twoperiod'] = 0x2489;
  t['twopersian'] = 0x06F2;
  t['tworoman'] = 0x2171;
  t['twostroke'] = 0x01BB;
  t['twosuperior'] = 0x00B2;
  t['twothai'] = 0x0E52;
  t['twothirds'] = 0x2154;
  t['u'] = 0x0075;
  t['uacute'] = 0x00FA;
  t['ubar'] = 0x0289;
  t['ubengali'] = 0x0989;
  t['ubopomofo'] = 0x3128;
  t['ubreve'] = 0x016D;
  t['ucaron'] = 0x01D4;
  t['ucircle'] = 0x24E4;
  t['ucircumflex'] = 0x00FB;
  t['ucircumflexbelow'] = 0x1E77;
  t['ucyrillic'] = 0x0443;
  t['udattadeva'] = 0x0951;
  t['udblacute'] = 0x0171;
  t['udblgrave'] = 0x0215;
  t['udeva'] = 0x0909;
  t['udieresis'] = 0x00FC;
  t['udieresisacute'] = 0x01D8;
  t['udieresisbelow'] = 0x1E73;
  t['udieresiscaron'] = 0x01DA;
  t['udieresiscyrillic'] = 0x04F1;
  t['udieresisgrave'] = 0x01DC;
  t['udieresismacron'] = 0x01D6;
  t['udotbelow'] = 0x1EE5;
  t['ugrave'] = 0x00F9;
  t['ugujarati'] = 0x0A89;
  t['ugurmukhi'] = 0x0A09;
  t['uhiragana'] = 0x3046;
  t['uhookabove'] = 0x1EE7;
  t['uhorn'] = 0x01B0;
  t['uhornacute'] = 0x1EE9;
  t['uhorndotbelow'] = 0x1EF1;
  t['uhorngrave'] = 0x1EEB;
  t['uhornhookabove'] = 0x1EED;
  t['uhorntilde'] = 0x1EEF;
  t['uhungarumlaut'] = 0x0171;
  t['uhungarumlautcyrillic'] = 0x04F3;
  t['uinvertedbreve'] = 0x0217;
  t['ukatakana'] = 0x30A6;
  t['ukatakanahalfwidth'] = 0xFF73;
  t['ukcyrillic'] = 0x0479;
  t['ukorean'] = 0x315C;
  t['umacron'] = 0x016B;
  t['umacroncyrillic'] = 0x04EF;
  t['umacrondieresis'] = 0x1E7B;
  t['umatragurmukhi'] = 0x0A41;
  t['umonospace'] = 0xFF55;
  t['underscore'] = 0x005F;
  t['underscoredbl'] = 0x2017;
  t['underscoremonospace'] = 0xFF3F;
  t['underscorevertical'] = 0xFE33;
  t['underscorewavy'] = 0xFE4F;
  t['union'] = 0x222A;
  t['universal'] = 0x2200;
  t['uogonek'] = 0x0173;
  t['uparen'] = 0x24B0;
  t['upblock'] = 0x2580;
  t['upperdothebrew'] = 0x05C4;
  t['upsilon'] = 0x03C5;
  t['upsilondieresis'] = 0x03CB;
  t['upsilondieresistonos'] = 0x03B0;
  t['upsilonlatin'] = 0x028A;
  t['upsilontonos'] = 0x03CD;
  t['uptackbelowcmb'] = 0x031D;
  t['uptackmod'] = 0x02D4;
  t['uragurmukhi'] = 0x0A73;
  t['uring'] = 0x016F;
  t['ushortcyrillic'] = 0x045E;
  t['usmallhiragana'] = 0x3045;
  t['usmallkatakana'] = 0x30A5;
  t['usmallkatakanahalfwidth'] = 0xFF69;
  t['ustraightcyrillic'] = 0x04AF;
  t['ustraightstrokecyrillic'] = 0x04B1;
  t['utilde'] = 0x0169;
  t['utildeacute'] = 0x1E79;
  t['utildebelow'] = 0x1E75;
  t['uubengali'] = 0x098A;
  t['uudeva'] = 0x090A;
  t['uugujarati'] = 0x0A8A;
  t['uugurmukhi'] = 0x0A0A;
  t['uumatragurmukhi'] = 0x0A42;
  t['uuvowelsignbengali'] = 0x09C2;
  t['uuvowelsigndeva'] = 0x0942;
  t['uuvowelsigngujarati'] = 0x0AC2;
  t['uvowelsignbengali'] = 0x09C1;
  t['uvowelsigndeva'] = 0x0941;
  t['uvowelsigngujarati'] = 0x0AC1;
  t['v'] = 0x0076;
  t['vadeva'] = 0x0935;
  t['vagujarati'] = 0x0AB5;
  t['vagurmukhi'] = 0x0A35;
  t['vakatakana'] = 0x30F7;
  t['vav'] = 0x05D5;
  t['vavdagesh'] = 0xFB35;
  t['vavdagesh65'] = 0xFB35;
  t['vavdageshhebrew'] = 0xFB35;
  t['vavhebrew'] = 0x05D5;
  t['vavholam'] = 0xFB4B;
  t['vavholamhebrew'] = 0xFB4B;
  t['vavvavhebrew'] = 0x05F0;
  t['vavyodhebrew'] = 0x05F1;
  t['vcircle'] = 0x24E5;
  t['vdotbelow'] = 0x1E7F;
  t['vecyrillic'] = 0x0432;
  t['veharabic'] = 0x06A4;
  t['vehfinalarabic'] = 0xFB6B;
  t['vehinitialarabic'] = 0xFB6C;
  t['vehmedialarabic'] = 0xFB6D;
  t['vekatakana'] = 0x30F9;
  t['venus'] = 0x2640;
  t['verticalbar'] = 0x007C;
  t['verticallineabovecmb'] = 0x030D;
  t['verticallinebelowcmb'] = 0x0329;
  t['verticallinelowmod'] = 0x02CC;
  t['verticallinemod'] = 0x02C8;
  t['vewarmenian'] = 0x057E;
  t['vhook'] = 0x028B;
  t['vikatakana'] = 0x30F8;
  t['viramabengali'] = 0x09CD;
  t['viramadeva'] = 0x094D;
  t['viramagujarati'] = 0x0ACD;
  t['visargabengali'] = 0x0983;
  t['visargadeva'] = 0x0903;
  t['visargagujarati'] = 0x0A83;
  t['vmonospace'] = 0xFF56;
  t['voarmenian'] = 0x0578;
  t['voicediterationhiragana'] = 0x309E;
  t['voicediterationkatakana'] = 0x30FE;
  t['voicedmarkkana'] = 0x309B;
  t['voicedmarkkanahalfwidth'] = 0xFF9E;
  t['vokatakana'] = 0x30FA;
  t['vparen'] = 0x24B1;
  t['vtilde'] = 0x1E7D;
  t['vturned'] = 0x028C;
  t['vuhiragana'] = 0x3094;
  t['vukatakana'] = 0x30F4;
  t['w'] = 0x0077;
  t['wacute'] = 0x1E83;
  t['waekorean'] = 0x3159;
  t['wahiragana'] = 0x308F;
  t['wakatakana'] = 0x30EF;
  t['wakatakanahalfwidth'] = 0xFF9C;
  t['wakorean'] = 0x3158;
  t['wasmallhiragana'] = 0x308E;
  t['wasmallkatakana'] = 0x30EE;
  t['wattosquare'] = 0x3357;
  t['wavedash'] = 0x301C;
  t['wavyunderscorevertical'] = 0xFE34;
  t['wawarabic'] = 0x0648;
  t['wawfinalarabic'] = 0xFEEE;
  t['wawhamzaabovearabic'] = 0x0624;
  t['wawhamzaabovefinalarabic'] = 0xFE86;
  t['wbsquare'] = 0x33DD;
  t['wcircle'] = 0x24E6;
  t['wcircumflex'] = 0x0175;
  t['wdieresis'] = 0x1E85;
  t['wdotaccent'] = 0x1E87;
  t['wdotbelow'] = 0x1E89;
  t['wehiragana'] = 0x3091;
  t['weierstrass'] = 0x2118;
  t['wekatakana'] = 0x30F1;
  t['wekorean'] = 0x315E;
  t['weokorean'] = 0x315D;
  t['wgrave'] = 0x1E81;
  t['whitebullet'] = 0x25E6;
  t['whitecircle'] = 0x25CB;
  t['whitecircleinverse'] = 0x25D9;
  t['whitecornerbracketleft'] = 0x300E;
  t['whitecornerbracketleftvertical'] = 0xFE43;
  t['whitecornerbracketright'] = 0x300F;
  t['whitecornerbracketrightvertical'] = 0xFE44;
  t['whitediamond'] = 0x25C7;
  t['whitediamondcontainingblacksmalldiamond'] = 0x25C8;
  t['whitedownpointingsmalltriangle'] = 0x25BF;
  t['whitedownpointingtriangle'] = 0x25BD;
  t['whiteleftpointingsmalltriangle'] = 0x25C3;
  t['whiteleftpointingtriangle'] = 0x25C1;
  t['whitelenticularbracketleft'] = 0x3016;
  t['whitelenticularbracketright'] = 0x3017;
  t['whiterightpointingsmalltriangle'] = 0x25B9;
  t['whiterightpointingtriangle'] = 0x25B7;
  t['whitesmallsquare'] = 0x25AB;
  t['whitesmilingface'] = 0x263A;
  t['whitesquare'] = 0x25A1;
  t['whitestar'] = 0x2606;
  t['whitetelephone'] = 0x260F;
  t['whitetortoiseshellbracketleft'] = 0x3018;
  t['whitetortoiseshellbracketright'] = 0x3019;
  t['whiteuppointingsmalltriangle'] = 0x25B5;
  t['whiteuppointingtriangle'] = 0x25B3;
  t['wihiragana'] = 0x3090;
  t['wikatakana'] = 0x30F0;
  t['wikorean'] = 0x315F;
  t['wmonospace'] = 0xFF57;
  t['wohiragana'] = 0x3092;
  t['wokatakana'] = 0x30F2;
  t['wokatakanahalfwidth'] = 0xFF66;
  t['won'] = 0x20A9;
  t['wonmonospace'] = 0xFFE6;
  t['wowaenthai'] = 0x0E27;
  t['wparen'] = 0x24B2;
  t['wring'] = 0x1E98;
  t['wsuperior'] = 0x02B7;
  t['wturned'] = 0x028D;
  t['wynn'] = 0x01BF;
  t['x'] = 0x0078;
  t['xabovecmb'] = 0x033D;
  t['xbopomofo'] = 0x3112;
  t['xcircle'] = 0x24E7;
  t['xdieresis'] = 0x1E8D;
  t['xdotaccent'] = 0x1E8B;
  t['xeharmenian'] = 0x056D;
  t['xi'] = 0x03BE;
  t['xmonospace'] = 0xFF58;
  t['xparen'] = 0x24B3;
  t['xsuperior'] = 0x02E3;
  t['y'] = 0x0079;
  t['yaadosquare'] = 0x334E;
  t['yabengali'] = 0x09AF;
  t['yacute'] = 0x00FD;
  t['yadeva'] = 0x092F;
  t['yaekorean'] = 0x3152;
  t['yagujarati'] = 0x0AAF;
  t['yagurmukhi'] = 0x0A2F;
  t['yahiragana'] = 0x3084;
  t['yakatakana'] = 0x30E4;
  t['yakatakanahalfwidth'] = 0xFF94;
  t['yakorean'] = 0x3151;
  t['yamakkanthai'] = 0x0E4E;
  t['yasmallhiragana'] = 0x3083;
  t['yasmallkatakana'] = 0x30E3;
  t['yasmallkatakanahalfwidth'] = 0xFF6C;
  t['yatcyrillic'] = 0x0463;
  t['ycircle'] = 0x24E8;
  t['ycircumflex'] = 0x0177;
  t['ydieresis'] = 0x00FF;
  t['ydotaccent'] = 0x1E8F;
  t['ydotbelow'] = 0x1EF5;
  t['yeharabic'] = 0x064A;
  t['yehbarreearabic'] = 0x06D2;
  t['yehbarreefinalarabic'] = 0xFBAF;
  t['yehfinalarabic'] = 0xFEF2;
  t['yehhamzaabovearabic'] = 0x0626;
  t['yehhamzaabovefinalarabic'] = 0xFE8A;
  t['yehhamzaaboveinitialarabic'] = 0xFE8B;
  t['yehhamzaabovemedialarabic'] = 0xFE8C;
  t['yehinitialarabic'] = 0xFEF3;
  t['yehmedialarabic'] = 0xFEF4;
  t['yehmeeminitialarabic'] = 0xFCDD;
  t['yehmeemisolatedarabic'] = 0xFC58;
  t['yehnoonfinalarabic'] = 0xFC94;
  t['yehthreedotsbelowarabic'] = 0x06D1;
  t['yekorean'] = 0x3156;
  t['yen'] = 0x00A5;
  t['yenmonospace'] = 0xFFE5;
  t['yeokorean'] = 0x3155;
  t['yeorinhieuhkorean'] = 0x3186;
  t['yerahbenyomohebrew'] = 0x05AA;
  t['yerahbenyomolefthebrew'] = 0x05AA;
  t['yericyrillic'] = 0x044B;
  t['yerudieresiscyrillic'] = 0x04F9;
  t['yesieungkorean'] = 0x3181;
  t['yesieungpansioskorean'] = 0x3183;
  t['yesieungsioskorean'] = 0x3182;
  t['yetivhebrew'] = 0x059A;
  t['ygrave'] = 0x1EF3;
  t['yhook'] = 0x01B4;
  t['yhookabove'] = 0x1EF7;
  t['yiarmenian'] = 0x0575;
  t['yicyrillic'] = 0x0457;
  t['yikorean'] = 0x3162;
  t['yinyang'] = 0x262F;
  t['yiwnarmenian'] = 0x0582;
  t['ymonospace'] = 0xFF59;
  t['yod'] = 0x05D9;
  t['yoddagesh'] = 0xFB39;
  t['yoddageshhebrew'] = 0xFB39;
  t['yodhebrew'] = 0x05D9;
  t['yodyodhebrew'] = 0x05F2;
  t['yodyodpatahhebrew'] = 0xFB1F;
  t['yohiragana'] = 0x3088;
  t['yoikorean'] = 0x3189;
  t['yokatakana'] = 0x30E8;
  t['yokatakanahalfwidth'] = 0xFF96;
  t['yokorean'] = 0x315B;
  t['yosmallhiragana'] = 0x3087;
  t['yosmallkatakana'] = 0x30E7;
  t['yosmallkatakanahalfwidth'] = 0xFF6E;
  t['yotgreek'] = 0x03F3;
  t['yoyaekorean'] = 0x3188;
  t['yoyakorean'] = 0x3187;
  t['yoyakthai'] = 0x0E22;
  t['yoyingthai'] = 0x0E0D;
  t['yparen'] = 0x24B4;
  t['ypogegrammeni'] = 0x037A;
  t['ypogegrammenigreekcmb'] = 0x0345;
  t['yr'] = 0x01A6;
  t['yring'] = 0x1E99;
  t['ysuperior'] = 0x02B8;
  t['ytilde'] = 0x1EF9;
  t['yturned'] = 0x028E;
  t['yuhiragana'] = 0x3086;
  t['yuikorean'] = 0x318C;
  t['yukatakana'] = 0x30E6;
  t['yukatakanahalfwidth'] = 0xFF95;
  t['yukorean'] = 0x3160;
  t['yusbigcyrillic'] = 0x046B;
  t['yusbigiotifiedcyrillic'] = 0x046D;
  t['yuslittlecyrillic'] = 0x0467;
  t['yuslittleiotifiedcyrillic'] = 0x0469;
  t['yusmallhiragana'] = 0x3085;
  t['yusmallkatakana'] = 0x30E5;
  t['yusmallkatakanahalfwidth'] = 0xFF6D;
  t['yuyekorean'] = 0x318B;
  t['yuyeokorean'] = 0x318A;
  t['yyabengali'] = 0x09DF;
  t['yyadeva'] = 0x095F;
  t['z'] = 0x007A;
  t['zaarmenian'] = 0x0566;
  t['zacute'] = 0x017A;
  t['zadeva'] = 0x095B;
  t['zagurmukhi'] = 0x0A5B;
  t['zaharabic'] = 0x0638;
  t['zahfinalarabic'] = 0xFEC6;
  t['zahinitialarabic'] = 0xFEC7;
  t['zahiragana'] = 0x3056;
  t['zahmedialarabic'] = 0xFEC8;
  t['zainarabic'] = 0x0632;
  t['zainfinalarabic'] = 0xFEB0;
  t['zakatakana'] = 0x30B6;
  t['zaqefgadolhebrew'] = 0x0595;
  t['zaqefqatanhebrew'] = 0x0594;
  t['zarqahebrew'] = 0x0598;
  t['zayin'] = 0x05D6;
  t['zayindagesh'] = 0xFB36;
  t['zayindageshhebrew'] = 0xFB36;
  t['zayinhebrew'] = 0x05D6;
  t['zbopomofo'] = 0x3117;
  t['zcaron'] = 0x017E;
  t['zcircle'] = 0x24E9;
  t['zcircumflex'] = 0x1E91;
  t['zcurl'] = 0x0291;
  t['zdot'] = 0x017C;
  t['zdotaccent'] = 0x017C;
  t['zdotbelow'] = 0x1E93;
  t['zecyrillic'] = 0x0437;
  t['zedescendercyrillic'] = 0x0499;
  t['zedieresiscyrillic'] = 0x04DF;
  t['zehiragana'] = 0x305C;
  t['zekatakana'] = 0x30BC;
  t['zero'] = 0x0030;
  t['zeroarabic'] = 0x0660;
  t['zerobengali'] = 0x09E6;
  t['zerodeva'] = 0x0966;
  t['zerogujarati'] = 0x0AE6;
  t['zerogurmukhi'] = 0x0A66;
  t['zerohackarabic'] = 0x0660;
  t['zeroinferior'] = 0x2080;
  t['zeromonospace'] = 0xFF10;
  t['zerooldstyle'] = 0xF730;
  t['zeropersian'] = 0x06F0;
  t['zerosuperior'] = 0x2070;
  t['zerothai'] = 0x0E50;
  t['zerowidthjoiner'] = 0xFEFF;
  t['zerowidthnonjoiner'] = 0x200C;
  t['zerowidthspace'] = 0x200B;
  t['zeta'] = 0x03B6;
  t['zhbopomofo'] = 0x3113;
  t['zhearmenian'] = 0x056A;
  t['zhebrevecyrillic'] = 0x04C2;
  t['zhecyrillic'] = 0x0436;
  t['zhedescendercyrillic'] = 0x0497;
  t['zhedieresiscyrillic'] = 0x04DD;
  t['zihiragana'] = 0x3058;
  t['zikatakana'] = 0x30B8;
  t['zinorhebrew'] = 0x05AE;
  t['zlinebelow'] = 0x1E95;
  t['zmonospace'] = 0xFF5A;
  t['zohiragana'] = 0x305E;
  t['zokatakana'] = 0x30BE;
  t['zparen'] = 0x24B5;
  t['zretroflexhook'] = 0x0290;
  t['zstroke'] = 0x01B6;
  t['zuhiragana'] = 0x305A;
  t['zukatakana'] = 0x30BA;
  t['.notdef'] = 0x0000;
});

var getDingbatsGlyphsUnicode = getLookupTableFactory(function (t) {
  t['space'] = 0x0020;
  t['a1'] = 0x2701;
  t['a2'] = 0x2702;
  t['a202'] = 0x2703;
  t['a3'] = 0x2704;
  t['a4'] = 0x260E;
  t['a5'] = 0x2706;
  t['a119'] = 0x2707;
  t['a118'] = 0x2708;
  t['a117'] = 0x2709;
  t['a11'] = 0x261B;
  t['a12'] = 0x261E;
  t['a13'] = 0x270C;
  t['a14'] = 0x270D;
  t['a15'] = 0x270E;
  t['a16'] = 0x270F;
  t['a105'] = 0x2710;
  t['a17'] = 0x2711;
  t['a18'] = 0x2712;
  t['a19'] = 0x2713;
  t['a20'] = 0x2714;
  t['a21'] = 0x2715;
  t['a22'] = 0x2716;
  t['a23'] = 0x2717;
  t['a24'] = 0x2718;
  t['a25'] = 0x2719;
  t['a26'] = 0x271A;
  t['a27'] = 0x271B;
  t['a28'] = 0x271C;
  t['a6'] = 0x271D;
  t['a7'] = 0x271E;
  t['a8'] = 0x271F;
  t['a9'] = 0x2720;
  t['a10'] = 0x2721;
  t['a29'] = 0x2722;
  t['a30'] = 0x2723;
  t['a31'] = 0x2724;
  t['a32'] = 0x2725;
  t['a33'] = 0x2726;
  t['a34'] = 0x2727;
  t['a35'] = 0x2605;
  t['a36'] = 0x2729;
  t['a37'] = 0x272A;
  t['a38'] = 0x272B;
  t['a39'] = 0x272C;
  t['a40'] = 0x272D;
  t['a41'] = 0x272E;
  t['a42'] = 0x272F;
  t['a43'] = 0x2730;
  t['a44'] = 0x2731;
  t['a45'] = 0x2732;
  t['a46'] = 0x2733;
  t['a47'] = 0x2734;
  t['a48'] = 0x2735;
  t['a49'] = 0x2736;
  t['a50'] = 0x2737;
  t['a51'] = 0x2738;
  t['a52'] = 0x2739;
  t['a53'] = 0x273A;
  t['a54'] = 0x273B;
  t['a55'] = 0x273C;
  t['a56'] = 0x273D;
  t['a57'] = 0x273E;
  t['a58'] = 0x273F;
  t['a59'] = 0x2740;
  t['a60'] = 0x2741;
  t['a61'] = 0x2742;
  t['a62'] = 0x2743;
  t['a63'] = 0x2744;
  t['a64'] = 0x2745;
  t['a65'] = 0x2746;
  t['a66'] = 0x2747;
  t['a67'] = 0x2748;
  t['a68'] = 0x2749;
  t['a69'] = 0x274A;
  t['a70'] = 0x274B;
  t['a71'] = 0x25CF;
  t['a72'] = 0x274D;
  t['a73'] = 0x25A0;
  t['a74'] = 0x274F;
  t['a203'] = 0x2750;
  t['a75'] = 0x2751;
  t['a204'] = 0x2752;
  t['a76'] = 0x25B2;
  t['a77'] = 0x25BC;
  t['a78'] = 0x25C6;
  t['a79'] = 0x2756;
  t['a81'] = 0x25D7;
  t['a82'] = 0x2758;
  t['a83'] = 0x2759;
  t['a84'] = 0x275A;
  t['a97'] = 0x275B;
  t['a98'] = 0x275C;
  t['a99'] = 0x275D;
  t['a100'] = 0x275E;
  t['a101'] = 0x2761;
  t['a102'] = 0x2762;
  t['a103'] = 0x2763;
  t['a104'] = 0x2764;
  t['a106'] = 0x2765;
  t['a107'] = 0x2766;
  t['a108'] = 0x2767;
  t['a112'] = 0x2663;
  t['a111'] = 0x2666;
  t['a110'] = 0x2665;
  t['a109'] = 0x2660;
  t['a120'] = 0x2460;
  t['a121'] = 0x2461;
  t['a122'] = 0x2462;
  t['a123'] = 0x2463;
  t['a124'] = 0x2464;
  t['a125'] = 0x2465;
  t['a126'] = 0x2466;
  t['a127'] = 0x2467;
  t['a128'] = 0x2468;
  t['a129'] = 0x2469;
  t['a130'] = 0x2776;
  t['a131'] = 0x2777;
  t['a132'] = 0x2778;
  t['a133'] = 0x2779;
  t['a134'] = 0x277A;
  t['a135'] = 0x277B;
  t['a136'] = 0x277C;
  t['a137'] = 0x277D;
  t['a138'] = 0x277E;
  t['a139'] = 0x277F;
  t['a140'] = 0x2780;
  t['a141'] = 0x2781;
  t['a142'] = 0x2782;
  t['a143'] = 0x2783;
  t['a144'] = 0x2784;
  t['a145'] = 0x2785;
  t['a146'] = 0x2786;
  t['a147'] = 0x2787;
  t['a148'] = 0x2788;
  t['a149'] = 0x2789;
  t['a150'] = 0x278A;
  t['a151'] = 0x278B;
  t['a152'] = 0x278C;
  t['a153'] = 0x278D;
  t['a154'] = 0x278E;
  t['a155'] = 0x278F;
  t['a156'] = 0x2790;
  t['a157'] = 0x2791;
  t['a158'] = 0x2792;
  t['a159'] = 0x2793;
  t['a160'] = 0x2794;
  t['a161'] = 0x2192;
  t['a163'] = 0x2194;
  t['a164'] = 0x2195;
  t['a196'] = 0x2798;
  t['a165'] = 0x2799;
  t['a192'] = 0x279A;
  t['a166'] = 0x279B;
  t['a167'] = 0x279C;
  t['a168'] = 0x279D;
  t['a169'] = 0x279E;
  t['a170'] = 0x279F;
  t['a171'] = 0x27A0;
  t['a172'] = 0x27A1;
  t['a173'] = 0x27A2;
  t['a162'] = 0x27A3;
  t['a174'] = 0x27A4;
  t['a175'] = 0x27A5;
  t['a176'] = 0x27A6;
  t['a177'] = 0x27A7;
  t['a178'] = 0x27A8;
  t['a179'] = 0x27A9;
  t['a193'] = 0x27AA;
  t['a180'] = 0x27AB;
  t['a199'] = 0x27AC;
  t['a181'] = 0x27AD;
  t['a200'] = 0x27AE;
  t['a182'] = 0x27AF;
  t['a201'] = 0x27B1;
  t['a183'] = 0x27B2;
  t['a184'] = 0x27B3;
  t['a197'] = 0x27B4;
  t['a185'] = 0x27B5;
  t['a194'] = 0x27B6;
  t['a198'] = 0x27B7;
  t['a186'] = 0x27B8;
  t['a195'] = 0x27B9;
  t['a187'] = 0x27BA;
  t['a188'] = 0x27BB;
  t['a189'] = 0x27BC;
  t['a190'] = 0x27BD;
  t['a191'] = 0x27BE;
  t['a89'] = 0x2768; // 0xF8D7
  t['a90'] = 0x2769; // 0xF8D8
  t['a93'] = 0x276A; // 0xF8D9
  t['a94'] = 0x276B; // 0xF8DA
  t['a91'] = 0x276C; // 0xF8DB
  t['a92'] = 0x276D; // 0xF8DC
  t['a205'] = 0x276E; // 0xF8DD
  t['a85'] = 0x276F; // 0xF8DE
  t['a206'] = 0x2770; // 0xF8DF
  t['a86'] = 0x2771; // 0xF8E0
  t['a87'] = 0x2772; // 0xF8E1
  t['a88'] = 0x2773; // 0xF8E2
  t['a95'] = 0x2774; // 0xF8E3
  t['a96'] = 0x2775; // 0xF8E4
  t['.notdef'] = 0x0000;
});

exports.getGlyphsUnicode = getGlyphsUnicode;
exports.getDingbatsGlyphsUnicode = getDingbatsGlyphsUnicode;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreJbig2 = {}), root.pdfjsSharedUtil,
      root.pdfjsCoreArithmeticDecoder);
  }
}(this, function (exports, sharedUtil, coreArithmeticDecoder) {

var error = sharedUtil.error;
var log2 = sharedUtil.log2;
var readInt8 = sharedUtil.readInt8;
var readUint16 = sharedUtil.readUint16;
var readUint32 = sharedUtil.readUint32;
var shadow = sharedUtil.shadow;
var ArithmeticDecoder = coreArithmeticDecoder.ArithmeticDecoder;

var Jbig2Image = (function Jbig2ImageClosure() {
  // Utility data structures
  function ContextCache() {}

  ContextCache.prototype = {
    getContexts: function(id) {
      if (id in this) {
        return this[id];
      }
      return (this[id] = new Int8Array(1 << 16));
    }
  };

  function DecodingContext(data, start, end) {
    this.data = data;
    this.start = start;
    this.end = end;
  }

  DecodingContext.prototype = {
    get decoder() {
      var decoder = new ArithmeticDecoder(this.data, this.start, this.end);
      return shadow(this, 'decoder', decoder);
    },
    get contextCache() {
      var cache = new ContextCache();
      return shadow(this, 'contextCache', cache);
    }
  };

  // Annex A. Arithmetic Integer Decoding Procedure
  // A.2 Procedure for decoding values
  function decodeInteger(contextCache, procedure, decoder) {
    var contexts = contextCache.getContexts(procedure);
    var prev = 1;

    function readBits(length) {
      var v = 0;
      for (var i = 0; i < length; i++) {
        var bit = decoder.readBit(contexts, prev);
        prev = (prev < 256 ? (prev << 1) | bit :
                (((prev << 1) | bit) & 511) | 256);
        v = (v << 1) | bit;
      }
      return v >>> 0;
    }

    var sign = readBits(1);
    var value = readBits(1) ?
                  (readBits(1) ?
                    (readBits(1) ?
                      (readBits(1) ?
                        (readBits(1) ?
                          (readBits(32) + 4436) :
                        readBits(12) + 340) :
                      readBits(8) + 84) :
                    readBits(6) + 20) :
                  readBits(4) + 4) :
                readBits(2);
    return (sign === 0 ? value : (value > 0 ? -value : null));
  }

  // A.3 The IAID decoding procedure
  function decodeIAID(contextCache, decoder, codeLength) {
    var contexts = contextCache.getContexts('IAID');

    var prev = 1;
    for (var i = 0; i < codeLength; i++) {
      var bit = decoder.readBit(contexts, prev);
      prev = (prev << 1) | bit;
    }
    if (codeLength < 31) {
      return prev & ((1 << codeLength) - 1);
    }
    return prev & 0x7FFFFFFF;
  }

  // 7.3 Segment types
  var SegmentTypes = [
    'SymbolDictionary', null, null, null, 'IntermediateTextRegion', null,
    'ImmediateTextRegion', 'ImmediateLosslessTextRegion', null, null, null,
    null, null, null, null, null, 'patternDictionary', null, null, null,
    'IntermediateHalftoneRegion', null, 'ImmediateHalftoneRegion',
    'ImmediateLosslessHalftoneRegion', null, null, null, null, null, null, null,
    null, null, null, null, null, 'IntermediateGenericRegion', null,
    'ImmediateGenericRegion', 'ImmediateLosslessGenericRegion',
    'IntermediateGenericRefinementRegion', null,
    'ImmediateGenericRefinementRegion',
    'ImmediateLosslessGenericRefinementRegion', null, null, null, null,
    'PageInformation', 'EndOfPage', 'EndOfStripe', 'EndOfFile', 'Profiles',
    'Tables', null, null, null, null, null, null, null, null,
    'Extension'
  ];

  var CodingTemplates = [
    [{x: -1, y: -2}, {x: 0, y: -2}, {x: 1, y: -2}, {x: -2, y: -1},
     {x: -1, y: -1}, {x: 0, y: -1}, {x: 1, y: -1}, {x: 2, y: -1},
     {x: -4, y: 0}, {x: -3, y: 0}, {x: -2, y: 0}, {x: -1, y: 0}],
    [{x: -1, y: -2}, {x: 0, y: -2}, {x: 1, y: -2}, {x: 2, y: -2},
     {x: -2, y: -1}, {x: -1, y: -1}, {x: 0, y: -1}, {x: 1, y: -1},
     {x: 2, y: -1}, {x: -3, y: 0}, {x: -2, y: 0}, {x: -1, y: 0}],
    [{x: -1, y: -2}, {x: 0, y: -2}, {x: 1, y: -2}, {x: -2, y: -1},
     {x: -1, y: -1}, {x: 0, y: -1}, {x: 1, y: -1}, {x: -2, y: 0},
     {x: -1, y: 0}],
    [{x: -3, y: -1}, {x: -2, y: -1}, {x: -1, y: -1}, {x: 0, y: -1},
     {x: 1, y: -1}, {x: -4, y: 0}, {x: -3, y: 0}, {x: -2, y: 0}, {x: -1, y: 0}]
  ];

  var RefinementTemplates = [
    {
      coding: [{x: 0, y: -1}, {x: 1, y: -1}, {x: -1, y: 0}],
      reference: [{x: 0, y: -1}, {x: 1, y: -1}, {x: -1, y: 0}, {x: 0, y: 0},
                  {x: 1, y: 0}, {x: -1, y: 1}, {x: 0, y: 1}, {x: 1, y: 1}]
    },
    {
      coding: [{x: -1, y: -1}, {x: 0, y: -1}, {x: 1, y: -1}, {x: -1, y: 0}],
      reference: [{x: 0, y: -1}, {x: -1, y: 0}, {x: 0, y: 0}, {x: 1, y: 0},
                  {x: 0, y: 1}, {x: 1, y: 1}]
    }
  ];

  // See 6.2.5.7 Decoding the bitmap.
  var ReusedContexts = [
    0x9B25, // 10011 0110010 0101
    0x0795, // 0011 110010 101
    0x00E5, // 001 11001 01
    0x0195  // 011001 0101
  ];

  var RefinementReusedContexts = [
    0x0020, // '000' + '0' (coding) + '00010000' + '0' (reference)
    0x0008  // '0000' + '001000'
  ];

  function decodeBitmapTemplate0(width, height, decodingContext) {
    var decoder = decodingContext.decoder;
    var contexts = decodingContext.contextCache.getContexts('GB');
    var contextLabel, i, j, pixel, row, row1, row2, bitmap = [];

    // ...ooooo....
    // ..ooooooo... Context template for current pixel (X)
    // .ooooX...... (concatenate values of 'o'-pixels to get contextLabel)
    var OLD_PIXEL_MASK = 0x7BF7; // 01111 0111111 0111

    for (i = 0; i < height; i++) {
      row = bitmap[i] = new Uint8Array(width);
      row1 = (i < 1) ? row : bitmap[i - 1];
      row2 = (i < 2) ? row : bitmap[i - 2];

      // At the beginning of each row:
      // Fill contextLabel with pixels that are above/right of (X)
      contextLabel = (row2[0] << 13) | (row2[1] << 12) | (row2[2] << 11) |
                     (row1[0] << 7) | (row1[1] << 6) | (row1[2] << 5) |
                     (row1[3] << 4);

      for (j = 0; j < width; j++) {
        row[j] = pixel = decoder.readBit(contexts, contextLabel);

        // At each pixel: Clear contextLabel pixels that are shifted
        // out of the context, then add new ones.
        contextLabel = ((contextLabel & OLD_PIXEL_MASK) << 1) |
                       (j + 3 < width ? row2[j + 3] << 11 : 0) |
                       (j + 4 < width ? row1[j + 4] << 4 : 0) | pixel;
      }
    }

    return bitmap;
  }

  // 6.2 Generic Region Decoding Procedure
  function decodeBitmap(mmr, width, height, templateIndex, prediction, skip, at,
                        decodingContext) {
    if (mmr) {
      error('JBIG2 error: MMR encoding is not supported');
    }

    // Use optimized version for the most common case
    if (templateIndex === 0 && !skip && !prediction && at.length === 4 &&
        at[0].x === 3 && at[0].y === -1 && at[1].x === -3 && at[1].y === -1 &&
        at[2].x === 2 && at[2].y === -2 && at[3].x === -2 && at[3].y === -2) {
      return decodeBitmapTemplate0(width, height, decodingContext);
    }

    var useskip = !!skip;
    var template = CodingTemplates[templateIndex].concat(at);

    // Sorting is non-standard, and it is not required. But sorting increases
    // the number of template bits that can be reused from the previous
    // contextLabel in the main loop.
    template.sort(function (a, b) {
      return (a.y - b.y) || (a.x - b.x);
    });

    var templateLength = template.length;
    var templateX = new Int8Array(templateLength);
    var templateY = new Int8Array(templateLength);
    var changingTemplateEntries = [];
    var reuseMask = 0, minX = 0, maxX = 0, minY = 0;
    var c, k;

    for (k = 0; k < templateLength; k++) {
      templateX[k] = template[k].x;
      templateY[k] = template[k].y;
      minX = Math.min(minX, template[k].x);
      maxX = Math.max(maxX, template[k].x);
      minY = Math.min(minY, template[k].y);
      // Check if the template pixel appears in two consecutive context labels,
      // so it can be reused. Otherwise, we add it to the list of changing
      // template entries.
      if (k < templateLength - 1 &&
          template[k].y === template[k + 1].y &&
          template[k].x === template[k + 1].x - 1) {
        reuseMask |= 1 << (templateLength - 1 - k);
      } else {
        changingTemplateEntries.push(k);
      }
    }
    var changingEntriesLength = changingTemplateEntries.length;

    var changingTemplateX = new Int8Array(changingEntriesLength);
    var changingTemplateY = new Int8Array(changingEntriesLength);
    var changingTemplateBit = new Uint16Array(changingEntriesLength);
    for (c = 0; c < changingEntriesLength; c++) {
      k = changingTemplateEntries[c];
      changingTemplateX[c] = template[k].x;
      changingTemplateY[c] = template[k].y;
      changingTemplateBit[c] = 1 << (templateLength - 1 - k);
    }

    // Get the safe bounding box edges from the width, height, minX, maxX, minY
    var sbb_left = -minX;
    var sbb_top = -minY;
    var sbb_right = width - maxX;

    var pseudoPixelContext = ReusedContexts[templateIndex];
    var row = new Uint8Array(width);
    var bitmap = [];

    var decoder = decodingContext.decoder;
    var contexts = decodingContext.contextCache.getContexts('GB');

    var ltp = 0, j, i0, j0, contextLabel = 0, bit, shift;
    for (var i = 0; i < height; i++) {
      if (prediction) {
        var sltp = decoder.readBit(contexts, pseudoPixelContext);
        ltp ^= sltp;
        if (ltp) {
          bitmap.push(row); // duplicate previous row
          continue;
        }
      }
      row = new Uint8Array(row);
      bitmap.push(row);
      for (j = 0; j < width; j++) {
        if (useskip && skip[i][j]) {
          row[j] = 0;
          continue;
        }
        // Are we in the middle of a scanline, so we can reuse contextLabel
        // bits?
        if (j >= sbb_left && j < sbb_right && i >= sbb_top) {
          // If yes, we can just shift the bits that are reusable and only
          // fetch the remaining ones.
          contextLabel = (contextLabel << 1) & reuseMask;
          for (k = 0; k < changingEntriesLength; k++) {
            i0 = i + changingTemplateY[k];
            j0 = j + changingTemplateX[k];
            bit = bitmap[i0][j0];
            if (bit) {
              bit = changingTemplateBit[k];
              contextLabel |= bit;
            }
          }
        } else {
          // compute the contextLabel from scratch
          contextLabel = 0;
          shift = templateLength - 1;
          for (k = 0; k < templateLength; k++, shift--) {
            j0 = j + templateX[k];
            if (j0 >= 0 && j0 < width) {
              i0 = i + templateY[k];
              if (i0 >= 0) {
                bit = bitmap[i0][j0];
                if (bit) {
                  contextLabel |= bit << shift;
                }
              }
            }
          }
        }
        var pixel = decoder.readBit(contexts, contextLabel);
        row[j] = pixel;
      }
    }
    return bitmap;
  }

  // 6.3.2 Generic Refinement Region Decoding Procedure
  function decodeRefinement(width, height, templateIndex, referenceBitmap,
                            offsetX, offsetY, prediction, at,
                            decodingContext) {
    var codingTemplate = RefinementTemplates[templateIndex].coding;
    if (templateIndex === 0) {
      codingTemplate = codingTemplate.concat([at[0]]);
    }
    var codingTemplateLength = codingTemplate.length;
    var codingTemplateX = new Int32Array(codingTemplateLength);
    var codingTemplateY = new Int32Array(codingTemplateLength);
    var k;
    for (k = 0; k < codingTemplateLength; k++) {
      codingTemplateX[k] = codingTemplate[k].x;
      codingTemplateY[k] = codingTemplate[k].y;
    }

    var referenceTemplate = RefinementTemplates[templateIndex].reference;
    if (templateIndex === 0) {
      referenceTemplate = referenceTemplate.concat([at[1]]);
    }
    var referenceTemplateLength = referenceTemplate.length;
    var referenceTemplateX = new Int32Array(referenceTemplateLength);
    var referenceTemplateY = new Int32Array(referenceTemplateLength);
    for (k = 0; k < referenceTemplateLength; k++) {
      referenceTemplateX[k] = referenceTemplate[k].x;
      referenceTemplateY[k] = referenceTemplate[k].y;
    }
    var referenceWidth = referenceBitmap[0].length;
    var referenceHeight = referenceBitmap.length;

    var pseudoPixelContext = RefinementReusedContexts[templateIndex];
    var bitmap = [];

    var decoder = decodingContext.decoder;
    var contexts = decodingContext.contextCache.getContexts('GR');

    var ltp = 0;
    for (var i = 0; i < height; i++) {
      if (prediction) {
        var sltp = decoder.readBit(contexts, pseudoPixelContext);
        ltp ^= sltp;
        if (ltp) {
          error('JBIG2 error: prediction is not supported');
        }
      }
      var row = new Uint8Array(width);
      bitmap.push(row);
      for (var j = 0; j < width; j++) {
        var i0, j0;
        var contextLabel = 0;
        for (k = 0; k < codingTemplateLength; k++) {
          i0 = i + codingTemplateY[k];
          j0 = j + codingTemplateX[k];
          if (i0 < 0 || j0 < 0 || j0 >= width) {
            contextLabel <<= 1; // out of bound pixel
          } else {
            contextLabel = (contextLabel << 1) | bitmap[i0][j0];
          }
        }
        for (k = 0; k < referenceTemplateLength; k++) {
          i0 = i + referenceTemplateY[k] + offsetY;
          j0 = j + referenceTemplateX[k] + offsetX;
          if (i0 < 0 || i0 >= referenceHeight || j0 < 0 ||
              j0 >= referenceWidth) {
            contextLabel <<= 1; // out of bound pixel
          } else {
            contextLabel = (contextLabel << 1) | referenceBitmap[i0][j0];
          }
        }
        var pixel = decoder.readBit(contexts, contextLabel);
        row[j] = pixel;
      }
    }

    return bitmap;
  }

  // 6.5.5 Decoding the symbol dictionary
  function decodeSymbolDictionary(huffman, refinement, symbols,
                                  numberOfNewSymbols, numberOfExportedSymbols,
                                  huffmanTables, templateIndex, at,
                                  refinementTemplateIndex, refinementAt,
                                  decodingContext) {
    if (huffman) {
      error('JBIG2 error: huffman is not supported');
    }

    var newSymbols = [];
    var currentHeight = 0;
    var symbolCodeLength = log2(symbols.length + numberOfNewSymbols);

    var decoder = decodingContext.decoder;
    var contextCache = decodingContext.contextCache;

    while (newSymbols.length < numberOfNewSymbols) {
      var deltaHeight = decodeInteger(contextCache, 'IADH', decoder); // 6.5.6
      currentHeight += deltaHeight;
      var currentWidth = 0;
      var totalWidth = 0;
      while (true) {
        var deltaWidth = decodeInteger(contextCache, 'IADW', decoder); // 6.5.7
        if (deltaWidth === null) {
          break; // OOB
        }
        currentWidth += deltaWidth;
        totalWidth += currentWidth;
        var bitmap;
        if (refinement) {
          // 6.5.8.2 Refinement/aggregate-coded symbol bitmap
          var numberOfInstances = decodeInteger(contextCache, 'IAAI', decoder);
          if (numberOfInstances > 1) {
            bitmap = decodeTextRegion(huffman, refinement,
                                      currentWidth, currentHeight, 0,
                                      numberOfInstances, 1, //strip size
                                      symbols.concat(newSymbols),
                                      symbolCodeLength,
                                      0, //transposed
                                      0, //ds offset
                                      1, //top left 7.4.3.1.1
                                      0, //OR operator
                                      huffmanTables,
                                      refinementTemplateIndex, refinementAt,
                                      decodingContext);
          } else {
            var symbolId = decodeIAID(contextCache, decoder, symbolCodeLength);
            var rdx = decodeInteger(contextCache, 'IARDX', decoder); // 6.4.11.3
            var rdy = decodeInteger(contextCache, 'IARDY', decoder); // 6.4.11.4
            var symbol = (symbolId < symbols.length ? symbols[symbolId] :
                          newSymbols[symbolId - symbols.length]);
            bitmap = decodeRefinement(currentWidth, currentHeight,
            refinementTemplateIndex, symbol, rdx, rdy, false, refinementAt,
            decodingContext);
          }
        } else {
          // 6.5.8.1 Direct-coded symbol bitmap
          bitmap = decodeBitmap(false, currentWidth, currentHeight,
            templateIndex, false, null, at, decodingContext);
        }
        newSymbols.push(bitmap);
      }
    }
    // 6.5.10 Exported symbols
    var exportedSymbols = [];
    var flags = [], currentFlag = false;
    var totalSymbolsLength = symbols.length + numberOfNewSymbols;
    while (flags.length < totalSymbolsLength) {
      var runLength = decodeInteger(contextCache, 'IAEX', decoder);
      while (runLength--) {
        flags.push(currentFlag);
      }
      currentFlag = !currentFlag;
    }
    for (var i = 0, ii = symbols.length; i < ii; i++) {
      if (flags[i]) {
        exportedSymbols.push(symbols[i]);
      }
    }
    for (var j = 0; j < numberOfNewSymbols; i++, j++) {
      if (flags[i]) {
        exportedSymbols.push(newSymbols[j]);
      }
    }
    return exportedSymbols;
  }

  function decodeTextRegion(huffman, refinement, width, height,
                            defaultPixelValue, numberOfSymbolInstances,
                            stripSize, inputSymbols, symbolCodeLength,
                            transposed, dsOffset, referenceCorner,
                            combinationOperator, huffmanTables,
                            refinementTemplateIndex, refinementAt,
                            decodingContext) {
    if (huffman) {
      error('JBIG2 error: huffman is not supported');
    }

    // Prepare bitmap
    var bitmap = [];
    var i, row;
    for (i = 0; i < height; i++) {
      row = new Uint8Array(width);
      if (defaultPixelValue) {
        for (var j = 0; j < width; j++) {
          row[j] = defaultPixelValue;
        }
      }
      bitmap.push(row);
    }

    var decoder = decodingContext.decoder;
    var contextCache = decodingContext.contextCache;
    var stripT = -decodeInteger(contextCache, 'IADT', decoder); // 6.4.6
    var firstS = 0;
    i = 0;
    while (i < numberOfSymbolInstances) {
      var deltaT = decodeInteger(contextCache, 'IADT', decoder); // 6.4.6
      stripT += deltaT;

      var deltaFirstS = decodeInteger(contextCache, 'IAFS', decoder); // 6.4.7
      firstS += deltaFirstS;
      var currentS = firstS;
      do {
        var currentT = (stripSize === 1 ? 0 :
                        decodeInteger(contextCache, 'IAIT', decoder)); // 6.4.9
        var t = stripSize * stripT + currentT;
        var symbolId = decodeIAID(contextCache, decoder, symbolCodeLength);
        var applyRefinement = (refinement &&
                               decodeInteger(contextCache, 'IARI', decoder));
        var symbolBitmap = inputSymbols[symbolId];
        var symbolWidth = symbolBitmap[0].length;
        var symbolHeight = symbolBitmap.length;
        if (applyRefinement) {
          var rdw = decodeInteger(contextCache, 'IARDW', decoder); // 6.4.11.1
          var rdh = decodeInteger(contextCache, 'IARDH', decoder); // 6.4.11.2
          var rdx = decodeInteger(contextCache, 'IARDX', decoder); // 6.4.11.3
          var rdy = decodeInteger(contextCache, 'IARDY', decoder); // 6.4.11.4
          symbolWidth += rdw;
          symbolHeight += rdh;
          symbolBitmap = decodeRefinement(symbolWidth, symbolHeight,
            refinementTemplateIndex, symbolBitmap, (rdw >> 1) + rdx,
            (rdh >> 1) + rdy, false, refinementAt,
            decodingContext);
        }
        var offsetT = t - ((referenceCorner & 1) ? 0 : symbolHeight);
        var offsetS = currentS - ((referenceCorner & 2) ? symbolWidth : 0);
        var s2, t2, symbolRow;
        if (transposed) {
          // Place Symbol Bitmap from T1,S1
          for (s2 = 0; s2 < symbolHeight; s2++) {
            row = bitmap[offsetS + s2];
            if (!row) {
              continue;
            }
            symbolRow = symbolBitmap[s2];
            // To ignore Parts of Symbol bitmap which goes
            // outside bitmap region
            var maxWidth = Math.min(width - offsetT, symbolWidth);
            switch (combinationOperator) {
              case 0: // OR
                for (t2 = 0; t2 < maxWidth; t2++) {
                  row[offsetT + t2] |= symbolRow[t2];
                }
                break;
              case 2: // XOR
                for (t2 = 0; t2 < maxWidth; t2++) {
                  row[offsetT + t2] ^= symbolRow[t2];
                }
                break;
              default:
                error('JBIG2 error: operator ' + combinationOperator +
                      ' is not supported');
            }
          }
          currentS += symbolHeight - 1;
        } else {
          for (t2 = 0; t2 < symbolHeight; t2++) {
            row = bitmap[offsetT + t2];
            if (!row) {
              continue;
            }
            symbolRow = symbolBitmap[t2];
            switch (combinationOperator) {
              case 0: // OR
                for (s2 = 0; s2 < symbolWidth; s2++) {
                  row[offsetS + s2] |= symbolRow[s2];
                }
                break;
              case 2: // XOR
                for (s2 = 0; s2 < symbolWidth; s2++) {
                  row[offsetS + s2] ^= symbolRow[s2];
                }
                break;
              default:
                error('JBIG2 error: operator ' + combinationOperator +
                      ' is not supported');
            }
          }
          currentS += symbolWidth - 1;
        }
        i++;
        var deltaS = decodeInteger(contextCache, 'IADS', decoder); // 6.4.8
        if (deltaS === null) {
          break; // OOB
        }
        currentS += deltaS + dsOffset;
      } while (true);
    }
    return bitmap;
  }

  function readSegmentHeader(data, start) {
    var segmentHeader = {};
    segmentHeader.number = readUint32(data, start);
    var flags = data[start + 4];
    var segmentType = flags & 0x3F;
    if (!SegmentTypes[segmentType]) {
      error('JBIG2 error: invalid segment type: ' + segmentType);
    }
    segmentHeader.type = segmentType;
    segmentHeader.typeName = SegmentTypes[segmentType];
    segmentHeader.deferredNonRetain = !!(flags & 0x80);

    var pageAssociationFieldSize = !!(flags & 0x40);
    var referredFlags = data[start + 5];
    var referredToCount = (referredFlags >> 5) & 7;
    var retainBits = [referredFlags & 31];
    var position = start + 6;
    if (referredFlags === 7) {
      referredToCount = readUint32(data, position - 1) & 0x1FFFFFFF;
      position += 3;
      var bytes = (referredToCount + 7) >> 3;
      retainBits[0] = data[position++];
      while (--bytes > 0) {
        retainBits.push(data[position++]);
      }
    } else if (referredFlags === 5 || referredFlags === 6) {
      error('JBIG2 error: invalid referred-to flags');
    }

    segmentHeader.retainBits = retainBits;
    var referredToSegmentNumberSize = (segmentHeader.number <= 256 ? 1 :
      (segmentHeader.number <= 65536 ? 2 : 4));
    var referredTo = [];
    var i, ii;
    for (i = 0; i < referredToCount; i++) {
      var number = (referredToSegmentNumberSize === 1 ? data[position] :
        (referredToSegmentNumberSize === 2 ? readUint16(data, position) :
        readUint32(data, position)));
      referredTo.push(number);
      position += referredToSegmentNumberSize;
    }
    segmentHeader.referredTo = referredTo;
    if (!pageAssociationFieldSize) {
      segmentHeader.pageAssociation = data[position++];
    } else {
      segmentHeader.pageAssociation = readUint32(data, position);
      position += 4;
    }
    segmentHeader.length = readUint32(data, position);
    position += 4;

    if (segmentHeader.length === 0xFFFFFFFF) {
      // 7.2.7 Segment data length, unknown segment length
      if (segmentType === 38) { // ImmediateGenericRegion
        var genericRegionInfo = readRegionSegmentInformation(data, position);
        var genericRegionSegmentFlags = data[position +
          RegionSegmentInformationFieldLength];
        var genericRegionMmr = !!(genericRegionSegmentFlags & 1);
        // searching for the segment end
        var searchPatternLength = 6;
        var searchPattern = new Uint8Array(searchPatternLength);
        if (!genericRegionMmr) {
          searchPattern[0] = 0xFF;
          searchPattern[1] = 0xAC;
        }
        searchPattern[2] = (genericRegionInfo.height >>> 24) & 0xFF;
        searchPattern[3] = (genericRegionInfo.height >> 16) & 0xFF;
        searchPattern[4] = (genericRegionInfo.height >> 8) & 0xFF;
        searchPattern[5] = genericRegionInfo.height & 0xFF;
        for (i = position, ii = data.length; i < ii; i++) {
          var j = 0;
          while (j < searchPatternLength && searchPattern[j] === data[i + j]) {
            j++;
          }
          if (j === searchPatternLength) {
            segmentHeader.length = i + searchPatternLength;
            break;
          }
        }
        if (segmentHeader.length === 0xFFFFFFFF) {
          error('JBIG2 error: segment end was not found');
        }
      } else {
        error('JBIG2 error: invalid unknown segment length');
      }
    }
    segmentHeader.headerEnd = position;
    return segmentHeader;
  }

  function readSegments(header, data, start, end) {
    var segments = [];
    var position = start;
    while (position < end) {
      var segmentHeader = readSegmentHeader(data, position);
      position = segmentHeader.headerEnd;
      var segment = {
        header: segmentHeader,
        data: data
      };
      if (!header.randomAccess) {
        segment.start = position;
        position += segmentHeader.length;
        segment.end = position;
      }
      segments.push(segment);
      if (segmentHeader.type === 51) {
        break; // end of file is found
      }
    }
    if (header.randomAccess) {
      for (var i = 0, ii = segments.length; i < ii; i++) {
        segments[i].start = position;
        position += segments[i].header.length;
        segments[i].end = position;
      }
    }
    return segments;
  }

  // 7.4.1 Region segment information field
  function readRegionSegmentInformation(data, start) {
    return {
      width: readUint32(data, start),
      height: readUint32(data, start + 4),
      x: readUint32(data, start + 8),
      y: readUint32(data, start + 12),
      combinationOperator: data[start + 16] & 7
    };
  }
  var RegionSegmentInformationFieldLength = 17;

  function processSegment(segment, visitor) {
    var header = segment.header;

    var data = segment.data, position = segment.start, end = segment.end;
    var args, at, i, atLength;
    switch (header.type) {
      case 0: // SymbolDictionary
        // 7.4.2 Symbol dictionary segment syntax
        var dictionary = {};
        var dictionaryFlags = readUint16(data, position); // 7.4.2.1.1
        dictionary.huffman = !!(dictionaryFlags & 1);
        dictionary.refinement = !!(dictionaryFlags & 2);
        dictionary.huffmanDHSelector = (dictionaryFlags >> 2) & 3;
        dictionary.huffmanDWSelector = (dictionaryFlags >> 4) & 3;
        dictionary.bitmapSizeSelector = (dictionaryFlags >> 6) & 1;
        dictionary.aggregationInstancesSelector = (dictionaryFlags >> 7) & 1;
        dictionary.bitmapCodingContextUsed = !!(dictionaryFlags & 256);
        dictionary.bitmapCodingContextRetained = !!(dictionaryFlags & 512);
        dictionary.template = (dictionaryFlags >> 10) & 3;
        dictionary.refinementTemplate = (dictionaryFlags >> 12) & 1;
        position += 2;
        if (!dictionary.huffman) {
          atLength = dictionary.template === 0 ? 4 : 1;
          at = [];
          for (i = 0; i < atLength; i++) {
            at.push({
              x: readInt8(data, position),
              y: readInt8(data, position + 1)
            });
            position += 2;
          }
          dictionary.at = at;
        }
        if (dictionary.refinement && !dictionary.refinementTemplate) {
          at = [];
          for (i = 0; i < 2; i++) {
            at.push({
              x: readInt8(data, position),
              y: readInt8(data, position + 1)
            });
            position += 2;
          }
          dictionary.refinementAt = at;
        }
        dictionary.numberOfExportedSymbols = readUint32(data, position);
        position += 4;
        dictionary.numberOfNewSymbols = readUint32(data, position);
        position += 4;
        args = [dictionary, header.number, header.referredTo,
                data, position, end];
        break;
      case 6: // ImmediateTextRegion
      case 7: // ImmediateLosslessTextRegion
        var textRegion = {};
        textRegion.info = readRegionSegmentInformation(data, position);
        position += RegionSegmentInformationFieldLength;
        var textRegionSegmentFlags = readUint16(data, position);
        position += 2;
        textRegion.huffman = !!(textRegionSegmentFlags & 1);
        textRegion.refinement = !!(textRegionSegmentFlags & 2);
        textRegion.stripSize = 1 << ((textRegionSegmentFlags >> 2) & 3);
        textRegion.referenceCorner = (textRegionSegmentFlags >> 4) & 3;
        textRegion.transposed = !!(textRegionSegmentFlags & 64);
        textRegion.combinationOperator = (textRegionSegmentFlags >> 7) & 3;
        textRegion.defaultPixelValue = (textRegionSegmentFlags >> 9) & 1;
        textRegion.dsOffset = (textRegionSegmentFlags << 17) >> 27;
        textRegion.refinementTemplate = (textRegionSegmentFlags >> 15) & 1;
        if (textRegion.huffman) {
          var textRegionHuffmanFlags = readUint16(data, position);
          position += 2;
          textRegion.huffmanFS = (textRegionHuffmanFlags) & 3;
          textRegion.huffmanDS = (textRegionHuffmanFlags >> 2) & 3;
          textRegion.huffmanDT = (textRegionHuffmanFlags >> 4) & 3;
          textRegion.huffmanRefinementDW = (textRegionHuffmanFlags >> 6) & 3;
          textRegion.huffmanRefinementDH = (textRegionHuffmanFlags >> 8) & 3;
          textRegion.huffmanRefinementDX = (textRegionHuffmanFlags >> 10) & 3;
          textRegion.huffmanRefinementDY = (textRegionHuffmanFlags >> 12) & 3;
          textRegion.huffmanRefinementSizeSelector =
            !!(textRegionHuffmanFlags & 14);
        }
        if (textRegion.refinement && !textRegion.refinementTemplate) {
          at = [];
          for (i = 0; i < 2; i++) {
            at.push({
              x: readInt8(data, position),
              y: readInt8(data, position + 1)
            });
            position += 2;
          }
          textRegion.refinementAt = at;
        }
        textRegion.numberOfSymbolInstances = readUint32(data, position);
        position += 4;
        // TODO 7.4.3.1.7 Symbol ID Huffman table decoding
        if (textRegion.huffman) {
          error('JBIG2 error: huffman is not supported');
        }
        args = [textRegion, header.referredTo, data, position, end];
        break;
      case 38: // ImmediateGenericRegion
      case 39: // ImmediateLosslessGenericRegion
        var genericRegion = {};
        genericRegion.info = readRegionSegmentInformation(data, position);
        position += RegionSegmentInformationFieldLength;
        var genericRegionSegmentFlags = data[position++];
        genericRegion.mmr = !!(genericRegionSegmentFlags & 1);
        genericRegion.template = (genericRegionSegmentFlags >> 1) & 3;
        genericRegion.prediction = !!(genericRegionSegmentFlags & 8);
        if (!genericRegion.mmr) {
          atLength = genericRegion.template === 0 ? 4 : 1;
          at = [];
          for (i = 0; i < atLength; i++) {
            at.push({
              x: readInt8(data, position),
              y: readInt8(data, position + 1)
            });
            position += 2;
          }
          genericRegion.at = at;
        }
        args = [genericRegion, data, position, end];
        break;
      case 48: // PageInformation
        var pageInfo = {
          width: readUint32(data, position),
          height: readUint32(data, position + 4),
          resolutionX: readUint32(data, position + 8),
          resolutionY: readUint32(data, position + 12)
        };
        if (pageInfo.height === 0xFFFFFFFF) {
          delete pageInfo.height;
        }
        var pageSegmentFlags = data[position + 16];
        var pageStripingInformation = readUint16(data, position + 17);
        pageInfo.lossless = !!(pageSegmentFlags & 1);
        pageInfo.refinement = !!(pageSegmentFlags & 2);
        pageInfo.defaultPixelValue = (pageSegmentFlags >> 2) & 1;
        pageInfo.combinationOperator = (pageSegmentFlags >> 3) & 3;
        pageInfo.requiresBuffer = !!(pageSegmentFlags & 32);
        pageInfo.combinationOperatorOverride = !!(pageSegmentFlags & 64);
        args = [pageInfo];
        break;
      case 49: // EndOfPage
        break;
      case 50: // EndOfStripe
        break;
      case 51: // EndOfFile
        break;
      case 62: // 7.4.15 defines 2 extension types which
               // are comments and can be ignored.
        break;
      default:
        error('JBIG2 error: segment type ' + header.typeName + '(' +
              header.type + ') is not implemented');
    }
    var callbackName = 'on' + header.typeName;
    if (callbackName in visitor) {
      visitor[callbackName].apply(visitor, args);
    }
  }

  function processSegments(segments, visitor) {
    for (var i = 0, ii = segments.length; i < ii; i++) {
      processSegment(segments[i], visitor);
    }
  }

  function parseJbig2(data, start, end) {
    var position = start;
    if (data[position] !== 0x97 || data[position + 1] !== 0x4A ||
        data[position + 2] !== 0x42 || data[position + 3] !== 0x32 ||
        data[position + 4] !== 0x0D || data[position + 5] !== 0x0A ||
        data[position + 6] !== 0x1A || data[position + 7] !== 0x0A) {
      error('JBIG2 error: invalid header');
    }
    var header = {};
    position += 8;
    var flags = data[position++];
    header.randomAccess = !(flags & 1);
    if (!(flags & 2)) {
      header.numberOfPages = readUint32(data, position);
      position += 4;
    }
    var segments = readSegments(header, data, position, end);
    error('Not implemented');
    // processSegments(segments, new SimpleSegmentVisitor());
  }

  function parseJbig2Chunks(chunks) {
    var visitor = new SimpleSegmentVisitor();
    for (var i = 0, ii = chunks.length; i < ii; i++) {
      var chunk = chunks[i];
      var segments = readSegments({}, chunk.data, chunk.start, chunk.end);
      processSegments(segments, visitor);
    }
    return visitor.buffer;
  }

  function SimpleSegmentVisitor() {}

  SimpleSegmentVisitor.prototype = {
    onPageInformation: function SimpleSegmentVisitor_onPageInformation(info) {
      this.currentPageInfo = info;
      var rowSize = (info.width + 7) >> 3;
      var buffer = new Uint8Array(rowSize * info.height);
      // The contents of ArrayBuffers are initialized to 0.
      // Fill the buffer with 0xFF only if info.defaultPixelValue is set
      if (info.defaultPixelValue) {
        for (var i = 0, ii = buffer.length; i < ii; i++) {
          buffer[i] = 0xFF;
        }
      }
      this.buffer = buffer;
    },
    drawBitmap: function SimpleSegmentVisitor_drawBitmap(regionInfo, bitmap) {
      var pageInfo = this.currentPageInfo;
      var width = regionInfo.width, height = regionInfo.height;
      var rowSize = (pageInfo.width + 7) >> 3;
      var combinationOperator = pageInfo.combinationOperatorOverride ?
        regionInfo.combinationOperator : pageInfo.combinationOperator;
      var buffer = this.buffer;
      var mask0 =  128 >> (regionInfo.x & 7);
      var offset0 = regionInfo.y * rowSize + (regionInfo.x >> 3);
      var i, j, mask, offset;
      switch (combinationOperator) {
        case 0: // OR
          for (i = 0; i < height; i++) {
            mask = mask0;
            offset = offset0;
            for (j = 0; j < width; j++) {
              if (bitmap[i][j]) {
                buffer[offset] |= mask;
              }
              mask >>= 1;
              if (!mask) {
                mask = 128;
                offset++;
              }
            }
            offset0 += rowSize;
          }
        break;
        case 2: // XOR
          for (i = 0; i < height; i++) {
            mask = mask0;
            offset = offset0;
            for (j = 0; j < width; j++) {
              if (bitmap[i][j]) {
                buffer[offset] ^= mask;
              }
              mask >>= 1;
              if (!mask) {
                mask = 128;
                offset++;
              }
            }
            offset0 += rowSize;
          }
          break;
        default:
          error('JBIG2 error: operator ' + combinationOperator +
                ' is not supported');
      }
    },
    onImmediateGenericRegion:
      function SimpleSegmentVisitor_onImmediateGenericRegion(region, data,
                                                             start, end) {
      var regionInfo = region.info;
      var decodingContext = new DecodingContext(data, start, end);
      var bitmap = decodeBitmap(region.mmr, regionInfo.width, regionInfo.height,
                                region.template, region.prediction, null,
                                region.at, decodingContext);
      this.drawBitmap(regionInfo, bitmap);
    },
    onImmediateLosslessGenericRegion:
      function SimpleSegmentVisitor_onImmediateLosslessGenericRegion() {
      this.onImmediateGenericRegion.apply(this, arguments);
    },
    onSymbolDictionary:
      function SimpleSegmentVisitor_onSymbolDictionary(dictionary,
                                                       currentSegment,
                                                       referredSegments,
                                                       data, start, end) {
      var huffmanTables;
      if (dictionary.huffman) {
        error('JBIG2 error: huffman is not supported');
      }

      // Combines exported symbols from all referred segments
      var symbols = this.symbols;
      if (!symbols) {
        this.symbols = symbols = {};
      }

      var inputSymbols = [];
      for (var i = 0, ii = referredSegments.length; i < ii; i++) {
        inputSymbols = inputSymbols.concat(symbols[referredSegments[i]]);
      }

      var decodingContext = new DecodingContext(data, start, end);
      symbols[currentSegment] = decodeSymbolDictionary(dictionary.huffman,
        dictionary.refinement, inputSymbols, dictionary.numberOfNewSymbols,
        dictionary.numberOfExportedSymbols, huffmanTables,
        dictionary.template, dictionary.at,
        dictionary.refinementTemplate, dictionary.refinementAt,
        decodingContext);
    },
    onImmediateTextRegion:
      function SimpleSegmentVisitor_onImmediateTextRegion(region,
                                                          referredSegments,
                                                          data, start, end) {
      var regionInfo = region.info;
      var huffmanTables;

      // Combines exported symbols from all referred segments
      var symbols = this.symbols;
      var inputSymbols = [];
      for (var i = 0, ii = referredSegments.length; i < ii; i++) {
        inputSymbols = inputSymbols.concat(symbols[referredSegments[i]]);
      }
      var symbolCodeLength = log2(inputSymbols.length);

      var decodingContext = new DecodingContext(data, start, end);
      var bitmap = decodeTextRegion(region.huffman, region.refinement,
        regionInfo.width, regionInfo.height, region.defaultPixelValue,
        region.numberOfSymbolInstances, region.stripSize, inputSymbols,
        symbolCodeLength, region.transposed, region.dsOffset,
        region.referenceCorner, region.combinationOperator, huffmanTables,
        region.refinementTemplate, region.refinementAt, decodingContext);
      this.drawBitmap(regionInfo, bitmap);
    },
    onImmediateLosslessTextRegion:
      function SimpleSegmentVisitor_onImmediateLosslessTextRegion() {
      this.onImmediateTextRegion.apply(this, arguments);
    }
  };

  function Jbig2Image() {}

  Jbig2Image.prototype = {
    parseChunks: function Jbig2Image_parseChunks(chunks) {
      return parseJbig2Chunks(chunks);
    }
  };

  return Jbig2Image;
})();

exports.Jbig2Image = Jbig2Image;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreJpx = {}), root.pdfjsSharedUtil,
      root.pdfjsCoreArithmeticDecoder);
  }
}(this, function (exports, sharedUtil, coreArithmeticDecoder) {

var info = sharedUtil.info;
var log2 = sharedUtil.log2;
var readUint16 = sharedUtil.readUint16;
var readUint32 = sharedUtil.readUint32;
var warn = sharedUtil.warn;
var ArithmeticDecoder = coreArithmeticDecoder.ArithmeticDecoder;

var JpxImage = (function JpxImageClosure() {
  // Table E.1
  var SubbandsGainLog2 = {
    'LL': 0,
    'LH': 1,
    'HL': 1,
    'HH': 2
  };
  function JpxImage() {
    this.failOnCorruptedImage = false;
  }
  JpxImage.prototype = {
    parse: function JpxImage_parse(data) {

      var head = readUint16(data, 0);
      // No box header, immediate start of codestream (SOC)
      if (head === 0xFF4F) {
        this.parseCodestream(data, 0, data.length);
        return;
      }

      var position = 0, length = data.length;
      while (position < length) {
        var headerSize = 8;
        var lbox = readUint32(data, position);
        var tbox = readUint32(data, position + 4);
        position += headerSize;
        if (lbox === 1) {
          // XLBox: read UInt64 according to spec.
          // JavaScript's int precision of 53 bit should be sufficient here.
          lbox = readUint32(data, position) * 4294967296 +
                 readUint32(data, position + 4);
          position += 8;
          headerSize += 8;
        }
        if (lbox === 0) {
          lbox = length - position + headerSize;
        }
        if (lbox < headerSize) {
          throw new Error('JPX Error: Invalid box field size');
        }
        var dataLength = lbox - headerSize;
        var jumpDataLength = true;
        switch (tbox) {
          case 0x6A703268: // 'jp2h'
            jumpDataLength = false; // parsing child boxes
            break;
          case 0x636F6C72: // 'colr'
            // Colorspaces are not used, the CS from the PDF is used.
            var method = data[position];
            if (method === 1) {
              // enumerated colorspace
              var colorspace = readUint32(data, position + 3);
              switch (colorspace) {
                case 16: // this indicates a sRGB colorspace
                case 17: // this indicates a grayscale colorspace
                case 18: // this indicates a YUV colorspace
                  break;
                default:
                  warn('Unknown colorspace ' + colorspace);
                  break;
              }
            } else if (method === 2) {
              info('ICC profile not supported');
            }
            break;
          case 0x6A703263: // 'jp2c'
            this.parseCodestream(data, position, position + dataLength);
            break;
          case 0x6A502020: // 'jP\024\024'
            if (0x0d0a870a !== readUint32(data, position)) {
              warn('Invalid JP2 signature');
            }
            break;
          // The following header types are valid but currently not used:
          case 0x6A501A1A: // 'jP\032\032'
          case 0x66747970: // 'ftyp'
          case 0x72726571: // 'rreq'
          case 0x72657320: // 'res '
          case 0x69686472: // 'ihdr'
            break;
          default:
            var headerType = String.fromCharCode((tbox >> 24) & 0xFF,
                                                 (tbox >> 16) & 0xFF,
                                                 (tbox >> 8) & 0xFF,
                                                 tbox & 0xFF);
            warn('Unsupported header type ' + tbox + ' (' + headerType + ')');
            break;
        }
        if (jumpDataLength) {
          position += dataLength;
        }
      }
    },
    parseImageProperties: function JpxImage_parseImageProperties(stream) {
      var newByte = stream.getByte();
      while (newByte >= 0) {
        var oldByte = newByte;
        newByte = stream.getByte();
        var code = (oldByte << 8) | newByte;
        // Image and tile size (SIZ)
        if (code === 0xFF51) {
          stream.skip(4);
          var Xsiz = stream.getInt32() >>> 0; // Byte 4
          var Ysiz = stream.getInt32() >>> 0; // Byte 8
          var XOsiz = stream.getInt32() >>> 0; // Byte 12
          var YOsiz = stream.getInt32() >>> 0; // Byte 16
          stream.skip(16);
          var Csiz = stream.getUint16(); // Byte 36
          this.width = Xsiz - XOsiz;
          this.height = Ysiz - YOsiz;
          this.componentsCount = Csiz;
          // Results are always returned as Uint8Arrays
          this.bitsPerComponent = 8;
          return;
        }
      }
      throw new Error('JPX Error: No size marker found in JPX stream');
    },
    parseCodestream: function JpxImage_parseCodestream(data, start, end) {
      var context = {};
      try {
        var doNotRecover = false;
        var position = start;
        while (position + 1 < end) {
          var code = readUint16(data, position);
          position += 2;

          var length = 0, j, sqcd, spqcds, spqcdSize, scalarExpounded, tile;
          switch (code) {
            case 0xFF4F: // Start of codestream (SOC)
              context.mainHeader = true;
              break;
            case 0xFFD9: // End of codestream (EOC)
              break;
            case 0xFF51: // Image and tile size (SIZ)
              length = readUint16(data, position);
              var siz = {};
              siz.Xsiz = readUint32(data, position + 4);
              siz.Ysiz = readUint32(data, position + 8);
              siz.XOsiz = readUint32(data, position + 12);
              siz.YOsiz = readUint32(data, position + 16);
              siz.XTsiz = readUint32(data, position + 20);
              siz.YTsiz = readUint32(data, position + 24);
              siz.XTOsiz = readUint32(data, position + 28);
              siz.YTOsiz = readUint32(data, position + 32);
              var componentsCount = readUint16(data, position + 36);
              siz.Csiz = componentsCount;
              var components = [];
              j = position + 38;
              for (var i = 0; i < componentsCount; i++) {
                var component = {
                  precision: (data[j] & 0x7F) + 1,
                  isSigned: !!(data[j] & 0x80),
                  XRsiz: data[j + 1],
                  YRsiz: data[j + 1]
                };
                calculateComponentDimensions(component, siz);
                components.push(component);
              }
              context.SIZ = siz;
              context.components = components;
              calculateTileGrids(context, components);
              context.QCC = [];
              context.COC = [];
              break;
            case 0xFF5C: // Quantization default (QCD)
              length = readUint16(data, position);
              var qcd = {};
              j = position + 2;
              sqcd = data[j++];
              switch (sqcd & 0x1F) {
                case 0:
                  spqcdSize = 8;
                  scalarExpounded = true;
                  break;
                case 1:
                  spqcdSize = 16;
                  scalarExpounded = false;
                  break;
                case 2:
                  spqcdSize = 16;
                  scalarExpounded = true;
                  break;
                default:
                  throw new Error('JPX Error: Invalid SQcd value ' + sqcd);
              }
              qcd.noQuantization = (spqcdSize === 8);
              qcd.scalarExpounded = scalarExpounded;
              qcd.guardBits = sqcd >> 5;
              spqcds = [];
              while (j < length + position) {
                var spqcd = {};
                if (spqcdSize === 8) {
                  spqcd.epsilon = data[j++] >> 3;
                  spqcd.mu = 0;
                } else {
                  spqcd.epsilon = data[j] >> 3;
                  spqcd.mu = ((data[j] & 0x7) << 8) | data[j + 1];
                  j += 2;
                }
                spqcds.push(spqcd);
              }
              qcd.SPqcds = spqcds;
              if (context.mainHeader) {
                context.QCD = qcd;
              } else {
                context.currentTile.QCD = qcd;
                context.currentTile.QCC = [];
              }
              break;
            case 0xFF5D: // Quantization component (QCC)
              length = readUint16(data, position);
              var qcc = {};
              j = position + 2;
              var cqcc;
              if (context.SIZ.Csiz < 257) {
                cqcc = data[j++];
              } else {
                cqcc = readUint16(data, j);
                j += 2;
              }
              sqcd = data[j++];
              switch (sqcd & 0x1F) {
                case 0:
                  spqcdSize = 8;
                  scalarExpounded = true;
                  break;
                case 1:
                  spqcdSize = 16;
                  scalarExpounded = false;
                  break;
                case 2:
                  spqcdSize = 16;
                  scalarExpounded = true;
                  break;
                default:
                  throw new Error('JPX Error: Invalid SQcd value ' + sqcd);
              }
              qcc.noQuantization = (spqcdSize === 8);
              qcc.scalarExpounded = scalarExpounded;
              qcc.guardBits = sqcd >> 5;
              spqcds = [];
              while (j < (length + position)) {
                spqcd = {};
                if (spqcdSize === 8) {
                  spqcd.epsilon = data[j++] >> 3;
                  spqcd.mu = 0;
                } else {
                  spqcd.epsilon = data[j] >> 3;
                  spqcd.mu = ((data[j] & 0x7) << 8) | data[j + 1];
                  j += 2;
                }
                spqcds.push(spqcd);
              }
              qcc.SPqcds = spqcds;
              if (context.mainHeader) {
                context.QCC[cqcc] = qcc;
              } else {
                context.currentTile.QCC[cqcc] = qcc;
              }
              break;
            case 0xFF52: // Coding style default (COD)
              length = readUint16(data, position);
              var cod = {};
              j = position + 2;
              var scod = data[j++];
              cod.entropyCoderWithCustomPrecincts = !!(scod & 1);
              cod.sopMarkerUsed = !!(scod & 2);
              cod.ephMarkerUsed = !!(scod & 4);
              cod.progressionOrder = data[j++];
              cod.layersCount = readUint16(data, j);
              j += 2;
              cod.multipleComponentTransform = data[j++];

              cod.decompositionLevelsCount = data[j++];
              cod.xcb = (data[j++] & 0xF) + 2;
              cod.ycb = (data[j++] & 0xF) + 2;
              var blockStyle = data[j++];
              cod.selectiveArithmeticCodingBypass = !!(blockStyle & 1);
              cod.resetContextProbabilities = !!(blockStyle & 2);
              cod.terminationOnEachCodingPass = !!(blockStyle & 4);
              cod.verticalyStripe = !!(blockStyle & 8);
              cod.predictableTermination = !!(blockStyle & 16);
              cod.segmentationSymbolUsed = !!(blockStyle & 32);
              cod.reversibleTransformation = data[j++];
              if (cod.entropyCoderWithCustomPrecincts) {
                var precinctsSizes = [];
                while (j < length + position) {
                  var precinctsSize = data[j++];
                  precinctsSizes.push({
                    PPx: precinctsSize & 0xF,
                    PPy: precinctsSize >> 4
                  });
                }
                cod.precinctsSizes = precinctsSizes;
              }
              var unsupported = [];
              if (cod.selectiveArithmeticCodingBypass) {
                unsupported.push('selectiveArithmeticCodingBypass');
              }
              if (cod.resetContextProbabilities) {
                unsupported.push('resetContextProbabilities');
              }
              if (cod.terminationOnEachCodingPass) {
                unsupported.push('terminationOnEachCodingPass');
              }
              if (cod.verticalyStripe) {
                unsupported.push('verticalyStripe');
              }
              if (cod.predictableTermination) {
                unsupported.push('predictableTermination');
              }
              if (unsupported.length > 0) {
                doNotRecover = true;
                throw new Error('JPX Error: Unsupported COD options (' +
                                unsupported.join(', ') + ')');
              }
              if (context.mainHeader) {
                context.COD = cod;
              } else {
                context.currentTile.COD = cod;
                context.currentTile.COC = [];
              }
              break;
            case 0xFF90: // Start of tile-part (SOT)
              length = readUint16(data, position);
              tile = {};
              tile.index = readUint16(data, position + 2);
              tile.length = readUint32(data, position + 4);
              tile.dataEnd = tile.length + position - 2;
              tile.partIndex = data[position + 8];
              tile.partsCount = data[position + 9];

              context.mainHeader = false;
              if (tile.partIndex === 0) {
                // reset component specific settings
                tile.COD = context.COD;
                tile.COC = context.COC.slice(0); // clone of the global COC
                tile.QCD = context.QCD;
                tile.QCC = context.QCC.slice(0); // clone of the global COC
              }
              context.currentTile = tile;
              break;
            case 0xFF93: // Start of data (SOD)
              tile = context.currentTile;
              if (tile.partIndex === 0) {
                initializeTile(context, tile.index);
                buildPackets(context);
              }

              // moving to the end of the data
              length = tile.dataEnd - position;
              parseTilePackets(context, data, position, length);
              break;
            case 0xFF55: // Tile-part lengths, main header (TLM)
            case 0xFF57: // Packet length, main header (PLM)
            case 0xFF58: // Packet length, tile-part header (PLT)
            case 0xFF64: // Comment (COM)
              length = readUint16(data, position);
              // skipping content
              break;
            case 0xFF53: // Coding style component (COC)
              throw new Error('JPX Error: Codestream code 0xFF53 (COC) is ' +
                              'not implemented');
            default:
              throw new Error('JPX Error: Unknown codestream code: ' +
                              code.toString(16));
          }
          position += length;
        }
      } catch (e) {
        if (doNotRecover || this.failOnCorruptedImage) {
          throw e;
        } else {
          warn('Trying to recover from ' + e.message);
        }
      }
      this.tiles = transformComponents(context);
      this.width = context.SIZ.Xsiz - context.SIZ.XOsiz;
      this.height = context.SIZ.Ysiz - context.SIZ.YOsiz;
      this.componentsCount = context.SIZ.Csiz;
    }
  };
  function calculateComponentDimensions(component, siz) {
    // Section B.2 Component mapping
    component.x0 = Math.ceil(siz.XOsiz / component.XRsiz);
    component.x1 = Math.ceil(siz.Xsiz / component.XRsiz);
    component.y0 = Math.ceil(siz.YOsiz / component.YRsiz);
    component.y1 = Math.ceil(siz.Ysiz / component.YRsiz);
    component.width = component.x1 - component.x0;
    component.height = component.y1 - component.y0;
  }
  function calculateTileGrids(context, components) {
    var siz = context.SIZ;
    // Section B.3 Division into tile and tile-components
    var tile, tiles = [];
    var numXtiles = Math.ceil((siz.Xsiz - siz.XTOsiz) / siz.XTsiz);
    var numYtiles = Math.ceil((siz.Ysiz - siz.YTOsiz) / siz.YTsiz);
    for (var q = 0; q < numYtiles; q++) {
      for (var p = 0; p < numXtiles; p++) {
        tile = {};
        tile.tx0 = Math.max(siz.XTOsiz + p * siz.XTsiz, siz.XOsiz);
        tile.ty0 = Math.max(siz.YTOsiz + q * siz.YTsiz, siz.YOsiz);
        tile.tx1 = Math.min(siz.XTOsiz + (p + 1) * siz.XTsiz, siz.Xsiz);
        tile.ty1 = Math.min(siz.YTOsiz + (q + 1) * siz.YTsiz, siz.Ysiz);
        tile.width = tile.tx1 - tile.tx0;
        tile.height = tile.ty1 - tile.ty0;
        tile.components = [];
        tiles.push(tile);
      }
    }
    context.tiles = tiles;

    var componentsCount = siz.Csiz;
    for (var i = 0, ii = componentsCount; i < ii; i++) {
      var component = components[i];
      for (var j = 0, jj = tiles.length; j < jj; j++) {
        var tileComponent = {};
        tile = tiles[j];
        tileComponent.tcx0 = Math.ceil(tile.tx0 / component.XRsiz);
        tileComponent.tcy0 = Math.ceil(tile.ty0 / component.YRsiz);
        tileComponent.tcx1 = Math.ceil(tile.tx1 / component.XRsiz);
        tileComponent.tcy1 = Math.ceil(tile.ty1 / component.YRsiz);
        tileComponent.width = tileComponent.tcx1 - tileComponent.tcx0;
        tileComponent.height = tileComponent.tcy1 - tileComponent.tcy0;
        tile.components[i] = tileComponent;
      }
    }
  }
  function getBlocksDimensions(context, component, r) {
    var codOrCoc = component.codingStyleParameters;
    var result = {};
    if (!codOrCoc.entropyCoderWithCustomPrecincts) {
      result.PPx = 15;
      result.PPy = 15;
    } else {
      result.PPx = codOrCoc.precinctsSizes[r].PPx;
      result.PPy = codOrCoc.precinctsSizes[r].PPy;
    }
    // calculate codeblock size as described in section B.7
    result.xcb_ = (r > 0 ? Math.min(codOrCoc.xcb, result.PPx - 1) :
                   Math.min(codOrCoc.xcb, result.PPx));
    result.ycb_ = (r > 0 ? Math.min(codOrCoc.ycb, result.PPy - 1) :
                   Math.min(codOrCoc.ycb, result.PPy));
    return result;
  }
  function buildPrecincts(context, resolution, dimensions) {
    // Section B.6 Division resolution to precincts
    var precinctWidth = 1 << dimensions.PPx;
    var precinctHeight = 1 << dimensions.PPy;
    // Jasper introduces codeblock groups for mapping each subband codeblocks
    // to precincts. Precinct partition divides a resolution according to width
    // and height parameters. The subband that belongs to the resolution level
    // has a different size than the level, unless it is the zero resolution.

    // From Jasper documentation: jpeg2000.pdf, section K: Tier-2 coding:
    // The precinct partitioning for a particular subband is derived from a
    // partitioning of its parent LL band (i.e., the LL band at the next higher
    // resolution level)... The LL band associated with each resolution level is
    // divided into precincts... Each of the resulting precinct regions is then
    // mapped into its child subbands (if any) at the next lower resolution
    // level. This is accomplished by using the coordinate transformation
    // (u, v) = (ceil(x/2), ceil(y/2)) where (x, y) and (u, v) are the
    // coordinates of a point in the LL band and child subband, respectively.
    var isZeroRes = resolution.resLevel === 0;
    var precinctWidthInSubband = 1 << (dimensions.PPx + (isZeroRes ? 0 : -1));
    var precinctHeightInSubband = 1 << (dimensions.PPy + (isZeroRes ? 0 : -1));
    var numprecinctswide = (resolution.trx1 > resolution.trx0 ?
      Math.ceil(resolution.trx1 / precinctWidth) -
      Math.floor(resolution.trx0 / precinctWidth) : 0);
    var numprecinctshigh = (resolution.try1 > resolution.try0 ?
      Math.ceil(resolution.try1 / precinctHeight) -
      Math.floor(resolution.try0 / precinctHeight) : 0);
    var numprecincts = numprecinctswide * numprecinctshigh;

    resolution.precinctParameters = {
      precinctWidth: precinctWidth,
      precinctHeight: precinctHeight,
      numprecinctswide: numprecinctswide,
      numprecinctshigh: numprecinctshigh,
      numprecincts: numprecincts,
      precinctWidthInSubband: precinctWidthInSubband,
      precinctHeightInSubband: precinctHeightInSubband
    };
  }
  function buildCodeblocks(context, subband, dimensions) {
    // Section B.7 Division sub-band into code-blocks
    var xcb_ = dimensions.xcb_;
    var ycb_ = dimensions.ycb_;
    var codeblockWidth = 1 << xcb_;
    var codeblockHeight = 1 << ycb_;
    var cbx0 = subband.tbx0 >> xcb_;
    var cby0 = subband.tby0 >> ycb_;
    var cbx1 = (subband.tbx1 + codeblockWidth - 1) >> xcb_;
    var cby1 = (subband.tby1 + codeblockHeight - 1) >> ycb_;
    var precinctParameters = subband.resolution.precinctParameters;
    var codeblocks = [];
    var precincts = [];
    var i, j, codeblock, precinctNumber;
    for (j = cby0; j < cby1; j++) {
      for (i = cbx0; i < cbx1; i++) {
        codeblock = {
          cbx: i,
          cby: j,
          tbx0: codeblockWidth * i,
          tby0: codeblockHeight * j,
          tbx1: codeblockWidth * (i + 1),
          tby1: codeblockHeight * (j + 1)
        };

        codeblock.tbx0_ = Math.max(subband.tbx0, codeblock.tbx0);
        codeblock.tby0_ = Math.max(subband.tby0, codeblock.tby0);
        codeblock.tbx1_ = Math.min(subband.tbx1, codeblock.tbx1);
        codeblock.tby1_ = Math.min(subband.tby1, codeblock.tby1);

        // Calculate precinct number for this codeblock, codeblock position
        // should be relative to its subband, use actual dimension and position
        // See comment about codeblock group width and height
        var pi = Math.floor((codeblock.tbx0_ - subband.tbx0) /
          precinctParameters.precinctWidthInSubband);
        var pj = Math.floor((codeblock.tby0_ - subband.tby0) /
          precinctParameters.precinctHeightInSubband);
        precinctNumber = pi + (pj * precinctParameters.numprecinctswide);

        codeblock.precinctNumber = precinctNumber;
        codeblock.subbandType = subband.type;
        codeblock.Lblock = 3;

        if (codeblock.tbx1_ <= codeblock.tbx0_ ||
            codeblock.tby1_ <= codeblock.tby0_) {
          continue;
        }
        codeblocks.push(codeblock);
        // building precinct for the sub-band
        var precinct = precincts[precinctNumber];
        if (precinct !== undefined) {
          if (i < precinct.cbxMin) {
            precinct.cbxMin = i;
          } else if (i > precinct.cbxMax) {
            precinct.cbxMax = i;
          }
          if (j < precinct.cbyMin) {
            precinct.cbxMin = j;
          } else if (j > precinct.cbyMax) {
            precinct.cbyMax = j;
          }
        } else {
          precincts[precinctNumber] = precinct = {
            cbxMin: i,
            cbyMin: j,
            cbxMax: i,
            cbyMax: j
          };
        }
        codeblock.precinct = precinct;
      }
    }
    subband.codeblockParameters = {
      codeblockWidth: xcb_,
      codeblockHeight: ycb_,
      numcodeblockwide: cbx1 - cbx0 + 1,
      numcodeblockhigh: cby1 - cby0 + 1
    };
    subband.codeblocks = codeblocks;
    subband.precincts = precincts;
  }
  function createPacket(resolution, precinctNumber, layerNumber) {
    var precinctCodeblocks = [];
    // Section B.10.8 Order of info in packet
    var subbands = resolution.subbands;
    // sub-bands already ordered in 'LL', 'HL', 'LH', and 'HH' sequence
    for (var i = 0, ii = subbands.length; i < ii; i++) {
      var subband = subbands[i];
      var codeblocks = subband.codeblocks;
      for (var j = 0, jj = codeblocks.length; j < jj; j++) {
        var codeblock = codeblocks[j];
        if (codeblock.precinctNumber !== precinctNumber) {
          continue;
        }
        precinctCodeblocks.push(codeblock);
      }
    }
    return {
      layerNumber: layerNumber,
      codeblocks: precinctCodeblocks
    };
  }
  function LayerResolutionComponentPositionIterator(context) {
    var siz = context.SIZ;
    var tileIndex = context.currentTile.index;
    var tile = context.tiles[tileIndex];
    var layersCount = tile.codingStyleDefaultParameters.layersCount;
    var componentsCount = siz.Csiz;
    var maxDecompositionLevelsCount = 0;
    for (var q = 0; q < componentsCount; q++) {
      maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount,
        tile.components[q].codingStyleParameters.decompositionLevelsCount);
    }

    var l = 0, r = 0, i = 0, k = 0;

    this.nextPacket = function JpxImage_nextPacket() {
      // Section B.12.1.1 Layer-resolution-component-position
      for (; l < layersCount; l++) {
        for (; r <= maxDecompositionLevelsCount; r++) {
          for (; i < componentsCount; i++) {
            var component = tile.components[i];
            if (r > component.codingStyleParameters.decompositionLevelsCount) {
              continue;
            }

            var resolution = component.resolutions[r];
            var numprecincts = resolution.precinctParameters.numprecincts;
            for (; k < numprecincts;) {
              var packet = createPacket(resolution, k, l);
              k++;
              return packet;
            }
            k = 0;
          }
          i = 0;
        }
        r = 0;
      }
      throw new Error('JPX Error: Out of packets');
    };
  }
  function ResolutionLayerComponentPositionIterator(context) {
    var siz = context.SIZ;
    var tileIndex = context.currentTile.index;
    var tile = context.tiles[tileIndex];
    var layersCount = tile.codingStyleDefaultParameters.layersCount;
    var componentsCount = siz.Csiz;
    var maxDecompositionLevelsCount = 0;
    for (var q = 0; q < componentsCount; q++) {
      maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount,
        tile.components[q].codingStyleParameters.decompositionLevelsCount);
    }

    var r = 0, l = 0, i = 0, k = 0;

    this.nextPacket = function JpxImage_nextPacket() {
      // Section B.12.1.2 Resolution-layer-component-position
      for (; r <= maxDecompositionLevelsCount; r++) {
        for (; l < layersCount; l++) {
          for (; i < componentsCount; i++) {
            var component = tile.components[i];
            if (r > component.codingStyleParameters.decompositionLevelsCount) {
              continue;
            }

            var resolution = component.resolutions[r];
            var numprecincts = resolution.precinctParameters.numprecincts;
            for (; k < numprecincts;) {
              var packet = createPacket(resolution, k, l);
              k++;
              return packet;
            }
            k = 0;
          }
          i = 0;
        }
        l = 0;
      }
      throw new Error('JPX Error: Out of packets');
    };
  }
  function ResolutionPositionComponentLayerIterator(context) {
    var siz = context.SIZ;
    var tileIndex = context.currentTile.index;
    var tile = context.tiles[tileIndex];
    var layersCount = tile.codingStyleDefaultParameters.layersCount;
    var componentsCount = siz.Csiz;
    var l, r, c, p;
    var maxDecompositionLevelsCount = 0;
    for (c = 0; c < componentsCount; c++) {
      var component = tile.components[c];
      maxDecompositionLevelsCount = Math.max(maxDecompositionLevelsCount,
        component.codingStyleParameters.decompositionLevelsCount);
    }
    var maxNumPrecinctsInLevel = new Int32Array(
      maxDecompositionLevelsCount + 1);
    for (r = 0; r <= maxDecompositionLevelsCount; ++r) {
      var maxNumPrecincts = 0;
      for (c = 0; c < componentsCount; ++c) {
        var resolutions = tile.components[c].resolutions;
        if (r < resolutions.length) {
          maxNumPrecincts = Math.max(maxNumPrecincts,
            resolutions[r].precinctParameters.numprecincts);
        }
      }
      maxNumPrecinctsInLevel[r] = maxNumPrecincts;
    }
    l = 0;
    r = 0;
    c = 0;
    p = 0;

    this.nextPacket = function JpxImage_nextPacket() {
      // Section B.12.1.3 Resolution-position-component-layer
      for (; r <= maxDecompositionLevelsCount; r++) {
        for (; p < maxNumPrecinctsInLevel[r]; p++) {
          for (; c < componentsCount; c++) {
            var component = tile.components[c];
            if (r > component.codingStyleParameters.decompositionLevelsCount) {
              continue;
            }
            var resolution = component.resolutions[r];
            var numprecincts = resolution.precinctParameters.numprecincts;
            if (p >= numprecincts) {
              continue;
            }
            for (; l < layersCount;) {
              var packet = createPacket(resolution, p, l);
              l++;
              return packet;
            }
            l = 0;
          }
          c = 0;
        }
        p = 0;
      }
      throw new Error('JPX Error: Out of packets');
    };
  }
  function PositionComponentResolutionLayerIterator(context) {
    var siz = context.SIZ;
    var tileIndex = context.currentTile.index;
    var tile = context.tiles[tileIndex];
    var layersCount = tile.codingStyleDefaultParameters.layersCount;
    var componentsCount = siz.Csiz;
    var precinctsSizes = getPrecinctSizesInImageScale(tile);
    var precinctsIterationSizes = precinctsSizes;
    var l = 0, r = 0, c = 0, px = 0, py = 0;

    this.nextPacket = function JpxImage_nextPacket() {
      // Section B.12.1.4 Position-component-resolution-layer
      for (; py < precinctsIterationSizes.maxNumHigh; py++) {
        for (; px < precinctsIterationSizes.maxNumWide; px++) {
          for (; c < componentsCount; c++) {
            var component = tile.components[c];
            var decompositionLevelsCount =
              component.codingStyleParameters.decompositionLevelsCount;
            for (; r <= decompositionLevelsCount; r++) {
              var resolution = component.resolutions[r];
              var sizeInImageScale =
                precinctsSizes.components[c].resolutions[r];
              var k = getPrecinctIndexIfExist(
                px,
                py,
                sizeInImageScale,
                precinctsIterationSizes,
                resolution);
              if (k === null) {
                continue;
              }
              for (; l < layersCount;) {
                var packet = createPacket(resolution, k, l);
                l++;
                return packet;
              }
              l = 0;
            }
            r = 0;
          }
          c = 0;
        }
        px = 0;
      }
      throw new Error('JPX Error: Out of packets');
    };
  }
  function ComponentPositionResolutionLayerIterator(context) {
    var siz = context.SIZ;
    var tileIndex = context.currentTile.index;
    var tile = context.tiles[tileIndex];
    var layersCount = tile.codingStyleDefaultParameters.layersCount;
    var componentsCount = siz.Csiz;
    var precinctsSizes = getPrecinctSizesInImageScale(tile);
    var l = 0, r = 0, c = 0, px = 0, py = 0;

    this.nextPacket = function JpxImage_nextPacket() {
      // Section B.12.1.5 Component-position-resolution-layer
      for (; c < componentsCount; ++c) {
        var component = tile.components[c];
        var precinctsIterationSizes = precinctsSizes.components[c];
        var decompositionLevelsCount =
          component.codingStyleParameters.decompositionLevelsCount;
        for (; py < precinctsIterationSizes.maxNumHigh; py++) {
          for (; px < precinctsIterationSizes.maxNumWide; px++) {
            for (; r <= decompositionLevelsCount; r++) {
              var resolution = component.resolutions[r];
              var sizeInImageScale = precinctsIterationSizes.resolutions[r];
              var k = getPrecinctIndexIfExist(
                px,
                py,
                sizeInImageScale,
                precinctsIterationSizes,
                resolution);
              if (k === null) {
                continue;
              }
              for (; l < layersCount;) {
                var packet = createPacket(resolution, k, l);
                l++;
                return packet;
              }
              l = 0;
            }
            r = 0;
          }
          px = 0;
        }
        py = 0;
      }
      throw new Error('JPX Error: Out of packets');
    };
  }
  function getPrecinctIndexIfExist(
    pxIndex, pyIndex, sizeInImageScale, precinctIterationSizes, resolution) {
    var posX = pxIndex * precinctIterationSizes.minWidth;
    var posY = pyIndex * precinctIterationSizes.minHeight;
    if (posX % sizeInImageScale.width !== 0 ||
        posY % sizeInImageScale.height !== 0) {
      return null;
    }
    var startPrecinctRowIndex =
      (posY / sizeInImageScale.width) *
      resolution.precinctParameters.numprecinctswide;
    return (posX / sizeInImageScale.height) + startPrecinctRowIndex;
  }
  function getPrecinctSizesInImageScale(tile) {
    var componentsCount = tile.components.length;
    var minWidth = Number.MAX_VALUE;
    var minHeight = Number.MAX_VALUE;
    var maxNumWide = 0;
    var maxNumHigh = 0;
    var sizePerComponent = new Array(componentsCount);
    for (var c = 0; c < componentsCount; c++) {
      var component = tile.components[c];
      var decompositionLevelsCount =
        component.codingStyleParameters.decompositionLevelsCount;
      var sizePerResolution = new Array(decompositionLevelsCount + 1);
      var minWidthCurrentComponent = Number.MAX_VALUE;
      var minHeightCurrentComponent = Number.MAX_VALUE;
      var maxNumWideCurrentComponent = 0;
      var maxNumHighCurrentComponent = 0;
      var scale = 1;
      for (var r = decompositionLevelsCount; r >= 0; --r) {
        var resolution = component.resolutions[r];
        var widthCurrentResolution =
          scale * resolution.precinctParameters.precinctWidth;
        var heightCurrentResolution =
          scale * resolution.precinctParameters.precinctHeight;
        minWidthCurrentComponent = Math.min(
          minWidthCurrentComponent,
          widthCurrentResolution);
        minHeightCurrentComponent = Math.min(
          minHeightCurrentComponent,
          heightCurrentResolution);
        maxNumWideCurrentComponent = Math.max(maxNumWideCurrentComponent,
          resolution.precinctParameters.numprecinctswide);
        maxNumHighCurrentComponent = Math.max(maxNumHighCurrentComponent,
          resolution.precinctParameters.numprecinctshigh);
        sizePerResolution[r] = {
          width: widthCurrentResolution,
          height: heightCurrentResolution
        };
        scale <<= 1;
      }
      minWidth = Math.min(minWidth, minWidthCurrentComponent);
      minHeight = Math.min(minHeight, minHeightCurrentComponent);
      maxNumWide = Math.max(maxNumWide, maxNumWideCurrentComponent);
      maxNumHigh = Math.max(maxNumHigh, maxNumHighCurrentComponent);
      sizePerComponent[c] = {
        resolutions: sizePerResolution,
        minWidth: minWidthCurrentComponent,
        minHeight: minHeightCurrentComponent,
        maxNumWide: maxNumWideCurrentComponent,
        maxNumHigh: maxNumHighCurrentComponent
      };
    }
    return {
      components: sizePerComponent,
      minWidth: minWidth,
      minHeight: minHeight,
      maxNumWide: maxNumWide,
      maxNumHigh: maxNumHigh
    };
  }
  function buildPackets(context) {
    var siz = context.SIZ;
    var tileIndex = context.currentTile.index;
    var tile = context.tiles[tileIndex];
    var componentsCount = siz.Csiz;
    // Creating resolutions and sub-bands for each component
    for (var c = 0; c < componentsCount; c++) {
      var component = tile.components[c];
      var decompositionLevelsCount =
        component.codingStyleParameters.decompositionLevelsCount;
      // Section B.5 Resolution levels and sub-bands
      var resolutions = [];
      var subbands = [];
      for (var r = 0; r <= decompositionLevelsCount; r++) {
        var blocksDimensions = getBlocksDimensions(context, component, r);
        var resolution = {};
        var scale = 1 << (decompositionLevelsCount - r);
        resolution.trx0 = Math.ceil(component.tcx0 / scale);
        resolution.try0 = Math.ceil(component.tcy0 / scale);
        resolution.trx1 = Math.ceil(component.tcx1 / scale);
        resolution.try1 = Math.ceil(component.tcy1 / scale);
        resolution.resLevel = r;
        buildPrecincts(context, resolution, blocksDimensions);
        resolutions.push(resolution);

        var subband;
        if (r === 0) {
          // one sub-band (LL) with last decomposition
          subband = {};
          subband.type = 'LL';
          subband.tbx0 = Math.ceil(component.tcx0 / scale);
          subband.tby0 = Math.ceil(component.tcy0 / scale);
          subband.tbx1 = Math.ceil(component.tcx1 / scale);
          subband.tby1 = Math.ceil(component.tcy1 / scale);
          subband.resolution = resolution;
          buildCodeblocks(context, subband, blocksDimensions);
          subbands.push(subband);
          resolution.subbands = [subband];
        } else {
          var bscale = 1 << (decompositionLevelsCount - r + 1);
          var resolutionSubbands = [];
          // three sub-bands (HL, LH and HH) with rest of decompositions
          subband = {};
          subband.type = 'HL';
          subband.tbx0 = Math.ceil(component.tcx0 / bscale - 0.5);
          subband.tby0 = Math.ceil(component.tcy0 / bscale);
          subband.tbx1 = Math.ceil(component.tcx1 / bscale - 0.5);
          subband.tby1 = Math.ceil(component.tcy1 / bscale);
          subband.resolution = resolution;
          buildCodeblocks(context, subband, blocksDimensions);
          subbands.push(subband);
          resolutionSubbands.push(subband);

          subband = {};
          subband.type = 'LH';
          subband.tbx0 = Math.ceil(component.tcx0 / bscale);
          subband.tby0 = Math.ceil(component.tcy0 / bscale - 0.5);
          subband.tbx1 = Math.ceil(component.tcx1 / bscale);
          subband.tby1 = Math.ceil(component.tcy1 / bscale - 0.5);
          subband.resolution = resolution;
          buildCodeblocks(context, subband, blocksDimensions);
          subbands.push(subband);
          resolutionSubbands.push(subband);

          subband = {};
          subband.type = 'HH';
          subband.tbx0 = Math.ceil(component.tcx0 / bscale - 0.5);
          subband.tby0 = Math.ceil(component.tcy0 / bscale - 0.5);
          subband.tbx1 = Math.ceil(component.tcx1 / bscale - 0.5);
          subband.tby1 = Math.ceil(component.tcy1 / bscale - 0.5);
          subband.resolution = resolution;
          buildCodeblocks(context, subband, blocksDimensions);
          subbands.push(subband);
          resolutionSubbands.push(subband);

          resolution.subbands = resolutionSubbands;
        }
      }
      component.resolutions = resolutions;
      component.subbands = subbands;
    }
    // Generate the packets sequence
    var progressionOrder = tile.codingStyleDefaultParameters.progressionOrder;
    switch (progressionOrder) {
      case 0:
        tile.packetsIterator =
          new LayerResolutionComponentPositionIterator(context);
        break;
      case 1:
        tile.packetsIterator =
          new ResolutionLayerComponentPositionIterator(context);
        break;
      case 2:
        tile.packetsIterator =
          new ResolutionPositionComponentLayerIterator(context);
        break;
      case 3:
        tile.packetsIterator =
          new PositionComponentResolutionLayerIterator(context);
        break;
      case 4:
        tile.packetsIterator =
          new ComponentPositionResolutionLayerIterator(context);
        break;
      default:
        throw new Error('JPX Error: Unsupported progression order ' +
                        progressionOrder);
    }
  }
  function parseTilePackets(context, data, offset, dataLength) {
    var position = 0;
    var buffer, bufferSize = 0, skipNextBit = false;
    function readBits(count) {
      while (bufferSize < count) {
        var b = data[offset + position];
        position++;
        if (skipNextBit) {
          buffer = (buffer << 7) | b;
          bufferSize += 7;
          skipNextBit = false;
        } else {
          buffer = (buffer << 8) | b;
          bufferSize += 8;
        }
        if (b === 0xFF) {
          skipNextBit = true;
        }
      }
      bufferSize -= count;
      return (buffer >>> bufferSize) & ((1 << count) - 1);
    }
    function skipMarkerIfEqual(value) {
      if (data[offset + position - 1] === 0xFF &&
          data[offset + position] === value) {
        skipBytes(1);
        return true;
      } else if (data[offset + position] === 0xFF &&
                 data[offset + position + 1] === value) {
        skipBytes(2);
        return true;
      }
      return false;
    }
    function skipBytes(count) {
      position += count;
    }
    function alignToByte() {
      bufferSize = 0;
      if (skipNextBit) {
        position++;
        skipNextBit = false;
      }
    }
    function readCodingpasses() {
      if (readBits(1) === 0) {
        return 1;
      }
      if (readBits(1) === 0) {
        return 2;
      }
      var value = readBits(2);
      if (value < 3) {
        return value + 3;
      }
      value = readBits(5);
      if (value < 31) {
        return value + 6;
      }
      value = readBits(7);
      return value + 37;
    }
    var tileIndex = context.currentTile.index;
    var tile = context.tiles[tileIndex];
    var sopMarkerUsed = context.COD.sopMarkerUsed;
    var ephMarkerUsed = context.COD.ephMarkerUsed;
    var packetsIterator = tile.packetsIterator;
    while (position < dataLength) {
      alignToByte();
      if (sopMarkerUsed && skipMarkerIfEqual(0x91)) {
        // Skip also marker segment length and packet sequence ID
        skipBytes(4);
      }
      var packet = packetsIterator.nextPacket();
      if (!readBits(1)) {
        continue;
      }
      var layerNumber = packet.layerNumber;
      var queue = [], codeblock;
      for (var i = 0, ii = packet.codeblocks.length; i < ii; i++) {
        codeblock = packet.codeblocks[i];
        var precinct = codeblock.precinct;
        var codeblockColumn = codeblock.cbx - precinct.cbxMin;
        var codeblockRow = codeblock.cby - precinct.cbyMin;
        var codeblockIncluded = false;
        var firstTimeInclusion = false;
        var valueReady;
        if (codeblock['included'] !== undefined) {
          codeblockIncluded = !!readBits(1);
        } else {
          // reading inclusion tree
          precinct = codeblock.precinct;
          var inclusionTree, zeroBitPlanesTree;
          if (precinct['inclusionTree'] !== undefined) {
            inclusionTree = precinct.inclusionTree;
          } else {
            // building inclusion and zero bit-planes trees
            var width = precinct.cbxMax - precinct.cbxMin + 1;
            var height = precinct.cbyMax - precinct.cbyMin + 1;
            inclusionTree = new InclusionTree(width, height, layerNumber);
            zeroBitPlanesTree = new TagTree(width, height);
            precinct.inclusionTree = inclusionTree;
            precinct.zeroBitPlanesTree = zeroBitPlanesTree;
          }

          if (inclusionTree.reset(codeblockColumn, codeblockRow, layerNumber)) {
            while (true) {
              if (readBits(1)) {
                valueReady = !inclusionTree.nextLevel();
                if (valueReady) {
                  codeblock.included = true;
                  codeblockIncluded = firstTimeInclusion = true;
                  break;
                }
              } else {
                inclusionTree.incrementValue(layerNumber);
                break;
              }
            }
          }
        }
        if (!codeblockIncluded) {
          continue;
        }
        if (firstTimeInclusion) {
          zeroBitPlanesTree = precinct.zeroBitPlanesTree;
          zeroBitPlanesTree.reset(codeblockColumn, codeblockRow);
          while (true) {
            if (readBits(1)) {
              valueReady = !zeroBitPlanesTree.nextLevel();
              if (valueReady) {
                break;
              }
            } else {
              zeroBitPlanesTree.incrementValue();
            }
          }
          codeblock.zeroBitPlanes = zeroBitPlanesTree.value;
        }
        var codingpasses = readCodingpasses();
        while (readBits(1)) {
          codeblock.Lblock++;
        }
        var codingpassesLog2 = log2(codingpasses);
        // rounding down log2
        var bits = ((codingpasses < (1 << codingpassesLog2)) ?
          codingpassesLog2 - 1 : codingpassesLog2) + codeblock.Lblock;
        var codedDataLength = readBits(bits);
        queue.push({
          codeblock: codeblock,
          codingpasses: codingpasses,
          dataLength: codedDataLength
        });
      }
      alignToByte();
      if (ephMarkerUsed) {
        skipMarkerIfEqual(0x92);
      }
      while (queue.length > 0) {
        var packetItem = queue.shift();
        codeblock = packetItem.codeblock;
        if (codeblock['data'] === undefined) {
          codeblock.data = [];
        }
        codeblock.data.push({
          data: data,
          start: offset + position,
          end: offset + position + packetItem.dataLength,
          codingpasses: packetItem.codingpasses
        });
        position += packetItem.dataLength;
      }
    }
    return position;
  }
  function copyCoefficients(coefficients, levelWidth, levelHeight, subband,
                            delta, mb, reversible, segmentationSymbolUsed) {
    var x0 = subband.tbx0;
    var y0 = subband.tby0;
    var width = subband.tbx1 - subband.tbx0;
    var codeblocks = subband.codeblocks;
    var right = subband.type.charAt(0) === 'H' ? 1 : 0;
    var bottom = subband.type.charAt(1) === 'H' ? levelWidth : 0;

    for (var i = 0, ii = codeblocks.length; i < ii; ++i) {
      var codeblock = codeblocks[i];
      var blockWidth = codeblock.tbx1_ - codeblock.tbx0_;
      var blockHeight = codeblock.tby1_ - codeblock.tby0_;
      if (blockWidth === 0 || blockHeight === 0) {
        continue;
      }
      if (codeblock['data'] === undefined) {
        continue;
      }

      var bitModel, currentCodingpassType;
      bitModel = new BitModel(blockWidth, blockHeight, codeblock.subbandType,
                              codeblock.zeroBitPlanes, mb);
      currentCodingpassType = 2; // first bit plane starts from cleanup

      // collect data
      var data = codeblock.data, totalLength = 0, codingpasses = 0;
      var j, jj, dataItem;
      for (j = 0, jj = data.length; j < jj; j++) {
        dataItem = data[j];
        totalLength += dataItem.end - dataItem.start;
        codingpasses += dataItem.codingpasses;
      }
      var encodedData = new Uint8Array(totalLength);
      var position = 0;
      for (j = 0, jj = data.length; j < jj; j++) {
        dataItem = data[j];
        var chunk = dataItem.data.subarray(dataItem.start, dataItem.end);
        encodedData.set(chunk, position);
        position += chunk.length;
      }
      // decoding the item
      var decoder = new ArithmeticDecoder(encodedData, 0, totalLength);
      bitModel.setDecoder(decoder);

      for (j = 0; j < codingpasses; j++) {
        switch (currentCodingpassType) {
          case 0:
            bitModel.runSignificancePropagationPass();
            break;
          case 1:
            bitModel.runMagnitudeRefinementPass();
            break;
          case 2:
            bitModel.runCleanupPass();
            if (segmentationSymbolUsed) {
              bitModel.checkSegmentationSymbol();
            }
            break;
        }
        currentCodingpassType = (currentCodingpassType + 1) % 3;
      }

      var offset = (codeblock.tbx0_ - x0) + (codeblock.tby0_ - y0) * width;
      var sign = bitModel.coefficentsSign;
      var magnitude = bitModel.coefficentsMagnitude;
      var bitsDecoded = bitModel.bitsDecoded;
      var magnitudeCorrection = reversible ? 0 : 0.5;
      var k, n, nb;
      position = 0;
      // Do the interleaving of Section F.3.3 here, so we do not need
      // to copy later. LL level is not interleaved, just copied.
      var interleave = (subband.type !== 'LL');
      for (j = 0; j < blockHeight; j++) {
        var row = (offset / width) | 0; // row in the non-interleaved subband
        var levelOffset = 2 * row * (levelWidth - width) + right + bottom;
        for (k = 0; k < blockWidth; k++) {
          n = magnitude[position];
          if (n !== 0) {
            n = (n + magnitudeCorrection) * delta;
            if (sign[position] !== 0) {
              n = -n;
            }
            nb = bitsDecoded[position];
            var pos = interleave ? (levelOffset + (offset << 1)) : offset;
            if (reversible && (nb >= mb)) {
              coefficients[pos] = n;
            } else {
              coefficients[pos] = n * (1 << (mb - nb));
            }
          }
          offset++;
          position++;
        }
        offset += width - blockWidth;
      }
    }
  }
  function transformTile(context, tile, c) {
    var component = tile.components[c];
    var codingStyleParameters = component.codingStyleParameters;
    var quantizationParameters = component.quantizationParameters;
    var decompositionLevelsCount =
      codingStyleParameters.decompositionLevelsCount;
    var spqcds = quantizationParameters.SPqcds;
    var scalarExpounded = quantizationParameters.scalarExpounded;
    var guardBits = quantizationParameters.guardBits;
    var segmentationSymbolUsed = codingStyleParameters.segmentationSymbolUsed;
    var precision = context.components[c].precision;

    var reversible = codingStyleParameters.reversibleTransformation;
    var transform = (reversible ? new ReversibleTransform() :
                                  new IrreversibleTransform());

    var subbandCoefficients = [];
    var b = 0;
    for (var i = 0; i <= decompositionLevelsCount; i++) {
      var resolution = component.resolutions[i];

      var width = resolution.trx1 - resolution.trx0;
      var height = resolution.try1 - resolution.try0;
      // Allocate space for the whole sublevel.
      var coefficients = new Float32Array(width * height);

      for (var j = 0, jj = resolution.subbands.length; j < jj; j++) {
        var mu, epsilon;
        if (!scalarExpounded) {
          // formula E-5
          mu = spqcds[0].mu;
          epsilon = spqcds[0].epsilon + (i > 0 ? 1 - i : 0);
        } else {
          mu = spqcds[b].mu;
          epsilon = spqcds[b].epsilon;
          b++;
        }

        var subband = resolution.subbands[j];
        var gainLog2 = SubbandsGainLog2[subband.type];

        // calculate quantization coefficient (Section E.1.1.1)
        var delta = (reversible ? 1 :
          Math.pow(2, precision + gainLog2 - epsilon) * (1 + mu / 2048));
        var mb = (guardBits + epsilon - 1);

        // In the first resolution level, copyCoefficients will fill the
        // whole array with coefficients. In the succeeding passes,
        // copyCoefficients will consecutively fill in the values that belong
        // to the interleaved positions of the HL, LH, and HH coefficients.
        // The LL coefficients will then be interleaved in Transform.iterate().
        copyCoefficients(coefficients, width, height, subband, delta, mb,
                         reversible, segmentationSymbolUsed);
      }
      subbandCoefficients.push({
        width: width,
        height: height,
        items: coefficients
      });
    }

    var result = transform.calculate(subbandCoefficients,
                                     component.tcx0, component.tcy0);
    return {
      left: component.tcx0,
      top: component.tcy0,
      width: result.width,
      height: result.height,
      items: result.items
    };
  }
  function transformComponents(context) {
    var siz = context.SIZ;
    var components = context.components;
    var componentsCount = siz.Csiz;
    var resultImages = [];
    for (var i = 0, ii = context.tiles.length; i < ii; i++) {
      var tile = context.tiles[i];
      var transformedTiles = [];
      var c;
      for (c = 0; c < componentsCount; c++) {
        transformedTiles[c] = transformTile(context, tile, c);
      }
      var tile0 = transformedTiles[0];
      var out = new Uint8Array(tile0.items.length * componentsCount);
      var result = {
        left: tile0.left,
        top: tile0.top,
        width: tile0.width,
        height: tile0.height,
        items: out
      };

      // Section G.2.2 Inverse multi component transform
      var shift, offset, max, min, maxK;
      var pos = 0, j, jj, y0, y1, y2, r, g, b, k, val;
      if (tile.codingStyleDefaultParameters.multipleComponentTransform) {
        var fourComponents = componentsCount === 4;
        var y0items = transformedTiles[0].items;
        var y1items = transformedTiles[1].items;
        var y2items = transformedTiles[2].items;
        var y3items = fourComponents ? transformedTiles[3].items : null;

        // HACK: The multiple component transform formulas below assume that
        // all components have the same precision. With this in mind, we
        // compute shift and offset only once.
        shift = components[0].precision - 8;
        offset = (128 << shift) + 0.5;
        max = 255 * (1 << shift);
        maxK = max * 0.5;
        min = -maxK;

        var component0 = tile.components[0];
        var alpha01 = componentsCount - 3;
        jj = y0items.length;
        if (!component0.codingStyleParameters.reversibleTransformation) {
          // inverse irreversible multiple component transform
          for (j = 0; j < jj; j++, pos += alpha01) {
            y0 = y0items[j] + offset;
            y1 = y1items[j];
            y2 = y2items[j];
            r = y0 + 1.402 * y2;
            g = y0 - 0.34413 * y1 - 0.71414 * y2;
            b = y0 + 1.772 * y1;
            out[pos++] = r <= 0 ? 0 : r >= max ? 255 : r >> shift;
            out[pos++] = g <= 0 ? 0 : g >= max ? 255 : g >> shift;
            out[pos++] = b <= 0 ? 0 : b >= max ? 255 : b >> shift;
          }
        } else {
          // inverse reversible multiple component transform
          for (j = 0; j < jj; j++, pos += alpha01) {
            y0 = y0items[j] + offset;
            y1 = y1items[j];
            y2 = y2items[j];
            g = y0 - ((y2 + y1) >> 2);
            r = g + y2;
            b = g + y1;
            out[pos++] = r <= 0 ? 0 : r >= max ? 255 : r >> shift;
            out[pos++] = g <= 0 ? 0 : g >= max ? 255 : g >> shift;
            out[pos++] = b <= 0 ? 0 : b >= max ? 255 : b >> shift;
          }
        }
        if (fourComponents) {
          for (j = 0, pos = 3; j < jj; j++, pos += 4) {
            k = y3items[j];
            out[pos] = k <= min ? 0 : k >= maxK ? 255 : (k + offset) >> shift;
          }
        }
      } else { // no multi-component transform
        for (c = 0; c < componentsCount; c++) {
          var items = transformedTiles[c].items;
          shift = components[c].precision - 8;
          offset = (128 << shift) + 0.5;
          max = (127.5 * (1 << shift));
          min = -max;
          for (pos = c, j = 0, jj = items.length; j < jj; j++) {
            val = items[j];
            out[pos] = val <= min ? 0 :
                       val >= max ? 255 : (val + offset) >> shift;
            pos += componentsCount;
          }
        }
      }
      resultImages.push(result);
    }
    return resultImages;
  }
  function initializeTile(context, tileIndex) {
    var siz = context.SIZ;
    var componentsCount = siz.Csiz;
    var tile = context.tiles[tileIndex];
    for (var c = 0; c < componentsCount; c++) {
      var component = tile.components[c];
      var qcdOrQcc = (context.currentTile.QCC[c] !== undefined ?
        context.currentTile.QCC[c] : context.currentTile.QCD);
      component.quantizationParameters = qcdOrQcc;
      var codOrCoc = (context.currentTile.COC[c] !== undefined  ?
        context.currentTile.COC[c] : context.currentTile.COD);
      component.codingStyleParameters = codOrCoc;
    }
    tile.codingStyleDefaultParameters = context.currentTile.COD;
  }

  // Section B.10.2 Tag trees
  var TagTree = (function TagTreeClosure() {
    function TagTree(width, height) {
      var levelsLength = log2(Math.max(width, height)) + 1;
      this.levels = [];
      for (var i = 0; i < levelsLength; i++) {
        var level = {
          width: width,
          height: height,
          items: []
        };
        this.levels.push(level);
        width = Math.ceil(width / 2);
        height = Math.ceil(height / 2);
      }
    }
    TagTree.prototype = {
      reset: function TagTree_reset(i, j) {
        var currentLevel = 0, value = 0, level;
        while (currentLevel < this.levels.length) {
          level = this.levels[currentLevel];
          var index = i + j * level.width;
          if (level.items[index] !== undefined) {
            value = level.items[index];
            break;
          }
          level.index = index;
          i >>= 1;
          j >>= 1;
          currentLevel++;
        }
        currentLevel--;
        level = this.levels[currentLevel];
        level.items[level.index] = value;
        this.currentLevel = currentLevel;
        delete this.value;
      },
      incrementValue: function TagTree_incrementValue() {
        var level = this.levels[this.currentLevel];
        level.items[level.index]++;
      },
      nextLevel: function TagTree_nextLevel() {
        var currentLevel = this.currentLevel;
        var level = this.levels[currentLevel];
        var value = level.items[level.index];
        currentLevel--;
        if (currentLevel < 0) {
          this.value = value;
          return false;
        }

        this.currentLevel = currentLevel;
        level = this.levels[currentLevel];
        level.items[level.index] = value;
        return true;
      }
    };
    return TagTree;
  })();

  var InclusionTree = (function InclusionTreeClosure() {
    function InclusionTree(width, height,  defaultValue) {
      var levelsLength = log2(Math.max(width, height)) + 1;
      this.levels = [];
      for (var i = 0; i < levelsLength; i++) {
        var items = new Uint8Array(width * height);
        for (var j = 0, jj = items.length; j < jj; j++) {
          items[j] = defaultValue;
        }

        var level = {
          width: width,
          height: height,
          items: items
        };
        this.levels.push(level);

        width = Math.ceil(width / 2);
        height = Math.ceil(height / 2);
      }
    }
    InclusionTree.prototype = {
      reset: function InclusionTree_reset(i, j, stopValue) {
        var currentLevel = 0;
        while (currentLevel < this.levels.length) {
          var level = this.levels[currentLevel];
          var index = i + j * level.width;
          level.index = index;
          var value = level.items[index];

          if (value === 0xFF) {
            break;
          }

          if (value > stopValue) {
            this.currentLevel = currentLevel;
            // already know about this one, propagating the value to top levels
            this.propagateValues();
            return false;
          }

          i >>= 1;
          j >>= 1;
          currentLevel++;
        }
        this.currentLevel = currentLevel - 1;
        return true;
      },
      incrementValue: function InclusionTree_incrementValue(stopValue) {
        var level = this.levels[this.currentLevel];
        level.items[level.index] = stopValue + 1;
        this.propagateValues();
      },
      propagateValues: function InclusionTree_propagateValues() {
        var levelIndex = this.currentLevel;
        var level = this.levels[levelIndex];
        var currentValue = level.items[level.index];
        while (--levelIndex >= 0) {
          level = this.levels[levelIndex];
          level.items[level.index] = currentValue;
        }
      },
      nextLevel: function InclusionTree_nextLevel() {
        var currentLevel = this.currentLevel;
        var level = this.levels[currentLevel];
        var value = level.items[level.index];
        level.items[level.index] = 0xFF;
        currentLevel--;
        if (currentLevel < 0) {
          return false;
        }

        this.currentLevel = currentLevel;
        level = this.levels[currentLevel];
        level.items[level.index] = value;
        return true;
      }
    };
    return InclusionTree;
  })();

  // Section D. Coefficient bit modeling
  var BitModel = (function BitModelClosure() {
    var UNIFORM_CONTEXT = 17;
    var RUNLENGTH_CONTEXT = 18;
    // Table D-1
    // The index is binary presentation: 0dddvvhh, ddd - sum of Di (0..4),
    // vv - sum of Vi (0..2), and hh - sum of Hi (0..2)
    var LLAndLHContextsLabel = new Uint8Array([
      0, 5, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 1, 6, 8, 0, 3, 7, 8, 0, 4,
      7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6,
      8, 0, 3, 7, 8, 0, 4, 7, 8, 0, 0, 0, 0, 0, 2, 6, 8, 0, 3, 7, 8, 0, 4, 7, 8
    ]);
    var HLContextLabel = new Uint8Array([
      0, 3, 4, 0, 5, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 1, 3, 4, 0, 6, 7, 7, 0, 8,
      8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3,
      4, 0, 6, 7, 7, 0, 8, 8, 8, 0, 0, 0, 0, 0, 2, 3, 4, 0, 6, 7, 7, 0, 8, 8, 8
    ]);
    var HHContextLabel = new Uint8Array([
      0, 1, 2, 0, 1, 2, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 3, 4, 5, 0, 4, 5, 5, 0, 5,
      5, 5, 0, 0, 0, 0, 0, 6, 7, 7, 0, 7, 7, 7, 0, 7, 7, 7, 0, 0, 0, 0, 0, 8, 8,
      8, 0, 8, 8, 8, 0, 8, 8, 8, 0, 0, 0, 0, 0, 8, 8, 8, 0, 8, 8, 8, 0, 8, 8, 8
    ]);

    function BitModel(width, height, subband, zeroBitPlanes, mb) {
      this.width = width;
      this.height = height;

      this.contextLabelTable = (subband === 'HH' ? HHContextLabel :
        (subband === 'HL' ? HLContextLabel : LLAndLHContextsLabel));

      var coefficientCount = width * height;

      // coefficients outside the encoding region treated as insignificant
      // add border state cells for significanceState
      this.neighborsSignificance = new Uint8Array(coefficientCount);
      this.coefficentsSign = new Uint8Array(coefficientCount);
      this.coefficentsMagnitude = mb > 14 ? new Uint32Array(coefficientCount) :
                                  mb > 6 ? new Uint16Array(coefficientCount) :
                                  new Uint8Array(coefficientCount);
      this.processingFlags = new Uint8Array(coefficientCount);

      var bitsDecoded = new Uint8Array(coefficientCount);
      if (zeroBitPlanes !== 0) {
        for (var i = 0; i < coefficientCount; i++) {
          bitsDecoded[i] = zeroBitPlanes;
        }
      }
      this.bitsDecoded = bitsDecoded;

      this.reset();
    }

    BitModel.prototype = {
      setDecoder: function BitModel_setDecoder(decoder) {
        this.decoder = decoder;
      },
      reset: function BitModel_reset() {
        // We have 17 contexts that are accessed via context labels,
        // plus the uniform and runlength context.
        this.contexts = new Int8Array(19);

        // Contexts are packed into 1 byte:
        // highest 7 bits carry the index, lowest bit carries mps
        this.contexts[0] = (4 << 1) | 0;
        this.contexts[UNIFORM_CONTEXT] = (46 << 1) | 0;
        this.contexts[RUNLENGTH_CONTEXT] = (3 << 1) | 0;
      },
      setNeighborsSignificance:
        function BitModel_setNeighborsSignificance(row, column, index) {
        var neighborsSignificance = this.neighborsSignificance;
        var width = this.width, height = this.height;
        var left = (column > 0);
        var right = (column + 1 < width);
        var i;

        if (row > 0) {
          i = index - width;
          if (left) {
            neighborsSignificance[i - 1] += 0x10;
          }
          if (right) {
            neighborsSignificance[i + 1] += 0x10;
          }
          neighborsSignificance[i] += 0x04;
        }

        if (row + 1 < height) {
          i = index + width;
          if (left) {
            neighborsSignificance[i - 1] += 0x10;
          }
          if (right) {
            neighborsSignificance[i + 1] += 0x10;
          }
          neighborsSignificance[i] += 0x04;
        }

        if (left) {
          neighborsSignificance[index - 1] += 0x01;
        }
        if (right) {
          neighborsSignificance[index + 1] += 0x01;
        }
        neighborsSignificance[index] |= 0x80;
      },
      runSignificancePropagationPass:
        function BitModel_runSignificancePropagationPass() {
        var decoder = this.decoder;
        var width = this.width, height = this.height;
        var coefficentsMagnitude = this.coefficentsMagnitude;
        var coefficentsSign = this.coefficentsSign;
        var neighborsSignificance = this.neighborsSignificance;
        var processingFlags = this.processingFlags;
        var contexts = this.contexts;
        var labels = this.contextLabelTable;
        var bitsDecoded = this.bitsDecoded;
        var processedInverseMask = ~1;
        var processedMask = 1;
        var firstMagnitudeBitMask = 2;

        for (var i0 = 0; i0 < height; i0 += 4) {
          for (var j = 0; j < width; j++) {
            var index = i0 * width + j;
            for (var i1 = 0; i1 < 4; i1++, index += width) {
              var i = i0 + i1;
              if (i >= height) {
                break;
              }
              // clear processed flag first
              processingFlags[index] &= processedInverseMask;

              if (coefficentsMagnitude[index] ||
                  !neighborsSignificance[index]) {
                continue;
              }

              var contextLabel = labels[neighborsSignificance[index]];
              var decision = decoder.readBit(contexts, contextLabel);
              if (decision) {
                var sign = this.decodeSignBit(i, j, index);
                coefficentsSign[index] = sign;
                coefficentsMagnitude[index] = 1;
                this.setNeighborsSignificance(i, j, index);
                processingFlags[index] |= firstMagnitudeBitMask;
              }
              bitsDecoded[index]++;
              processingFlags[index] |= processedMask;
            }
          }
        }
      },
      decodeSignBit: function BitModel_decodeSignBit(row, column, index) {
        var width = this.width, height = this.height;
        var coefficentsMagnitude = this.coefficentsMagnitude;
        var coefficentsSign = this.coefficentsSign;
        var contribution, sign0, sign1, significance1;
        var contextLabel, decoded;

        // calculate horizontal contribution
        significance1 = (column > 0 && coefficentsMagnitude[index - 1] !== 0);
        if (column + 1 < width && coefficentsMagnitude[index + 1] !== 0) {
          sign1 = coefficentsSign[index + 1];
          if (significance1) {
            sign0 = coefficentsSign[index - 1];
            contribution = 1 - sign1 - sign0;
          } else {
            contribution = 1 - sign1 - sign1;
          }
        } else if (significance1) {
          sign0 = coefficentsSign[index - 1];
          contribution = 1 - sign0 - sign0;
        } else {
          contribution = 0;
        }
        var horizontalContribution = 3 * contribution;

        // calculate vertical contribution and combine with the horizontal
        significance1 = (row > 0 && coefficentsMagnitude[index - width] !== 0);
        if (row + 1 < height && coefficentsMagnitude[index + width] !== 0) {
          sign1 = coefficentsSign[index + width];
          if (significance1) {
            sign0 = coefficentsSign[index - width];
            contribution = 1 - sign1 - sign0 + horizontalContribution;
          } else {
            contribution = 1 - sign1 - sign1 + horizontalContribution;
          }
        } else if (significance1) {
          sign0 = coefficentsSign[index - width];
          contribution = 1 - sign0 - sign0 + horizontalContribution;
        } else {
          contribution = horizontalContribution;
        }

        if (contribution >= 0) {
          contextLabel = 9 + contribution;
          decoded = this.decoder.readBit(this.contexts, contextLabel);
        } else {
          contextLabel = 9 - contribution;
          decoded = this.decoder.readBit(this.contexts, contextLabel) ^ 1;
        }
        return decoded;
      },
      runMagnitudeRefinementPass:
        function BitModel_runMagnitudeRefinementPass() {
        var decoder = this.decoder;
        var width = this.width, height = this.height;
        var coefficentsMagnitude = this.coefficentsMagnitude;
        var neighborsSignificance = this.neighborsSignificance;
        var contexts = this.contexts;
        var bitsDecoded = this.bitsDecoded;
        var processingFlags = this.processingFlags;
        var processedMask = 1;
        var firstMagnitudeBitMask = 2;
        var length = width * height;
        var width4 = width * 4;

        for (var index0 = 0, indexNext; index0 < length; index0 = indexNext) {
          indexNext = Math.min(length, index0 + width4);
          for (var j = 0; j < width; j++) {
            for (var index = index0 + j; index < indexNext; index += width) {

              // significant but not those that have just become
              if (!coefficentsMagnitude[index] ||
                (processingFlags[index] & processedMask) !== 0) {
                continue;
              }

              var contextLabel = 16;
              if ((processingFlags[index] & firstMagnitudeBitMask) !== 0) {
                processingFlags[index] ^= firstMagnitudeBitMask;
                // first refinement
               var significance = neighborsSignificance[index] & 127;
               contextLabel = significance === 0 ? 15 : 14;
              }

              var bit = decoder.readBit(contexts, contextLabel);
              coefficentsMagnitude[index] =
                (coefficentsMagnitude[index] << 1) | bit;
              bitsDecoded[index]++;
              processingFlags[index] |= processedMask;
            }
          }
        }
      },
      runCleanupPass: function BitModel_runCleanupPass() {
        var decoder = this.decoder;
        var width = this.width, height = this.height;
        var neighborsSignificance = this.neighborsSignificance;
        var coefficentsMagnitude = this.coefficentsMagnitude;
        var coefficentsSign = this.coefficentsSign;
        var contexts = this.contexts;
        var labels = this.contextLabelTable;
        var bitsDecoded = this.bitsDecoded;
        var processingFlags = this.processingFlags;
        var processedMask = 1;
        var firstMagnitudeBitMask = 2;
        var oneRowDown = width;
        var twoRowsDown = width * 2;
        var threeRowsDown = width * 3;
        var iNext;
        for (var i0 = 0; i0 < height; i0 = iNext) {
          iNext = Math.min(i0 + 4, height);
          var indexBase = i0 * width;
          var checkAllEmpty = i0 + 3 < height;
          for (var j = 0; j < width; j++) {
            var index0 = indexBase + j;
            // using the property: labels[neighborsSignificance[index]] === 0
            // when neighborsSignificance[index] === 0
            var allEmpty = (checkAllEmpty &&
              processingFlags[index0] === 0 &&
              processingFlags[index0 + oneRowDown] === 0 &&
              processingFlags[index0 + twoRowsDown] === 0 &&
              processingFlags[index0 + threeRowsDown] === 0 &&
              neighborsSignificance[index0] === 0 &&
              neighborsSignificance[index0 + oneRowDown] === 0 &&
              neighborsSignificance[index0 + twoRowsDown] === 0 &&
              neighborsSignificance[index0 + threeRowsDown] === 0);
            var i1 = 0, index = index0;
            var i = i0, sign;
            if (allEmpty) {
              var hasSignificantCoefficent =
                decoder.readBit(contexts, RUNLENGTH_CONTEXT);
              if (!hasSignificantCoefficent) {
                bitsDecoded[index0]++;
                bitsDecoded[index0 + oneRowDown]++;
                bitsDecoded[index0 + twoRowsDown]++;
                bitsDecoded[index0 + threeRowsDown]++;
                continue; // next column
              }
              i1 = (decoder.readBit(contexts, UNIFORM_CONTEXT) << 1) |
                    decoder.readBit(contexts, UNIFORM_CONTEXT);
              if (i1 !== 0) {
                i = i0 + i1;
                index += i1 * width;
              }

              sign = this.decodeSignBit(i, j, index);
              coefficentsSign[index] = sign;
              coefficentsMagnitude[index] = 1;
              this.setNeighborsSignificance(i, j, index);
              processingFlags[index] |= firstMagnitudeBitMask;

              index = index0;
              for (var i2 = i0; i2 <= i; i2++, index += width) {
                bitsDecoded[index]++;
              }

              i1++;
            }
            for (i = i0 + i1; i < iNext; i++, index += width) {
              if (coefficentsMagnitude[index] ||
                (processingFlags[index] & processedMask) !== 0) {
                continue;
              }

              var contextLabel = labels[neighborsSignificance[index]];
              var decision = decoder.readBit(contexts, contextLabel);
              if (decision === 1) {
                sign = this.decodeSignBit(i, j, index);
                coefficentsSign[index] = sign;
                coefficentsMagnitude[index] = 1;
                this.setNeighborsSignificance(i, j, index);
                processingFlags[index] |= firstMagnitudeBitMask;
              }
              bitsDecoded[index]++;
            }
          }
        }
      },
      checkSegmentationSymbol: function BitModel_checkSegmentationSymbol() {
        var decoder = this.decoder;
        var contexts = this.contexts;
        var symbol = (decoder.readBit(contexts, UNIFORM_CONTEXT) << 3) |
                     (decoder.readBit(contexts, UNIFORM_CONTEXT) << 2) |
                     (decoder.readBit(contexts, UNIFORM_CONTEXT) << 1) |
                      decoder.readBit(contexts, UNIFORM_CONTEXT);
        if (symbol !== 0xA) {
          throw new Error('JPX Error: Invalid segmentation symbol');
        }
      }
    };

    return BitModel;
  })();

  // Section F, Discrete wavelet transformation
  var Transform = (function TransformClosure() {
    function Transform() {}

    Transform.prototype.calculate =
      function transformCalculate(subbands, u0, v0) {
      var ll = subbands[0];
      for (var i = 1, ii = subbands.length; i < ii; i++) {
        ll = this.iterate(ll, subbands[i], u0, v0);
      }
      return ll;
    };
    Transform.prototype.extend = function extend(buffer, offset, size) {
      // Section F.3.7 extending... using max extension of 4
      var i1 = offset - 1, j1 = offset + 1;
      var i2 = offset + size - 2, j2 = offset + size;
      buffer[i1--] = buffer[j1++];
      buffer[j2++] = buffer[i2--];
      buffer[i1--] = buffer[j1++];
      buffer[j2++] = buffer[i2--];
      buffer[i1--] = buffer[j1++];
      buffer[j2++] = buffer[i2--];
      buffer[i1] = buffer[j1];
      buffer[j2] = buffer[i2];
    };
    Transform.prototype.iterate = function Transform_iterate(ll, hl_lh_hh,
                                                             u0, v0) {
      var llWidth = ll.width, llHeight = ll.height, llItems = ll.items;
      var width = hl_lh_hh.width;
      var height = hl_lh_hh.height;
      var items = hl_lh_hh.items;
      var i, j, k, l, u, v;

      // Interleave LL according to Section F.3.3
      for (k = 0, i = 0; i < llHeight; i++) {
        l = i * 2 * width;
        for (j = 0; j < llWidth; j++, k++, l += 2) {
          items[l] = llItems[k];
        }
      }
      // The LL band is not needed anymore.
      llItems = ll.items = null;

      var bufferPadding = 4;
      var rowBuffer = new Float32Array(width + 2 * bufferPadding);

      // Section F.3.4 HOR_SR
      if (width === 1) {
        // if width = 1, when u0 even keep items as is, when odd divide by 2
        if ((u0 & 1) !== 0) {
          for (v = 0, k = 0; v < height; v++, k += width) {
            items[k] *= 0.5;
          }
        }
      } else {
        for (v = 0, k = 0; v < height; v++, k += width) {
          rowBuffer.set(items.subarray(k, k + width), bufferPadding);

          this.extend(rowBuffer, bufferPadding, width);
          this.filter(rowBuffer, bufferPadding, width);

          items.set(
            rowBuffer.subarray(bufferPadding, bufferPadding + width),
            k);
        }
      }

      // Accesses to the items array can take long, because it may not fit into
      // CPU cache and has to be fetched from main memory. Since subsequent
      // accesses to the items array are not local when reading columns, we
      // have a cache miss every time. To reduce cache misses, get up to
      // 'numBuffers' items at a time and store them into the individual
      // buffers. The colBuffers should be small enough to fit into CPU cache.
      var numBuffers = 16;
      var colBuffers = [];
      for (i = 0; i < numBuffers; i++) {
        colBuffers.push(new Float32Array(height + 2 * bufferPadding));
      }
      var b, currentBuffer = 0;
      ll = bufferPadding + height;

      // Section F.3.5 VER_SR
      if (height === 1) {
          // if height = 1, when v0 even keep items as is, when odd divide by 2
        if ((v0 & 1) !== 0) {
          for (u = 0; u < width; u++) {
            items[u] *= 0.5;
          }
        }
      } else {
        for (u = 0; u < width; u++) {
          // if we ran out of buffers, copy several image columns at once
          if (currentBuffer === 0) {
            numBuffers = Math.min(width - u, numBuffers);
            for (k = u, l = bufferPadding; l < ll; k += width, l++) {
              for (b = 0; b < numBuffers; b++) {
                colBuffers[b][l] = items[k + b];
              }
            }
            currentBuffer = numBuffers;
          }

          currentBuffer--;
          var buffer = colBuffers[currentBuffer];
          this.extend(buffer, bufferPadding, height);
          this.filter(buffer, bufferPadding, height);

          // If this is last buffer in this group of buffers, flush all buffers.
          if (currentBuffer === 0) {
            k = u - numBuffers + 1;
            for (l = bufferPadding; l < ll; k += width, l++) {
              for (b = 0; b < numBuffers; b++) {
                items[k + b] = colBuffers[b][l];
              }
            }
          }
        }
      }

      return {
        width: width,
        height: height,
        items: items
      };
    };
    return Transform;
  })();

  // Section 3.8.2 Irreversible 9-7 filter
  var IrreversibleTransform = (function IrreversibleTransformClosure() {
    function IrreversibleTransform() {
      Transform.call(this);
    }

    IrreversibleTransform.prototype = Object.create(Transform.prototype);
    IrreversibleTransform.prototype.filter =
      function irreversibleTransformFilter(x, offset, length) {
      var len = length >> 1;
      offset = offset | 0;
      var j, n, current, next;

      var alpha = -1.586134342059924;
      var beta = -0.052980118572961;
      var gamma = 0.882911075530934;
      var delta = 0.443506852043971;
      var K = 1.230174104914001;
      var K_ = 1 / K;

      // step 1 is combined with step 3

      // step 2
      j = offset - 3;
      for (n = len + 4; n--; j += 2) {
        x[j] *= K_;
      }

      // step 1 & 3
      j = offset - 2;
      current = delta * x[j -1];
      for (n = len + 3; n--; j += 2) {
        next = delta * x[j + 1];
        x[j] = K * x[j] - current - next;
        if (n--) {
          j += 2;
          current = delta * x[j + 1];
          x[j] = K * x[j] - current - next;
        } else {
          break;
        }
      }

      // step 4
      j = offset - 1;
      current = gamma * x[j - 1];
      for (n = len + 2; n--; j += 2) {
        next = gamma * x[j + 1];
        x[j] -= current + next;
        if (n--) {
          j += 2;
          current = gamma * x[j + 1];
          x[j] -= current + next;
        } else {
          break;
        }
      }

      // step 5
      j = offset;
      current = beta * x[j - 1];
      for (n = len + 1; n--; j += 2) {
        next = beta * x[j + 1];
        x[j] -= current + next;
        if (n--) {
          j += 2;
          current = beta * x[j + 1];
          x[j] -= current + next;
        } else {
          break;
        }
      }

      // step 6
      if (len !== 0) {
        j = offset + 1;
        current = alpha * x[j - 1];
        for (n = len; n--; j += 2) {
          next = alpha * x[j + 1];
          x[j] -= current + next;
          if (n--) {
            j += 2;
            current = alpha * x[j + 1];
            x[j] -= current + next;
          } else {
            break;
          }
        }
      }
    };

    return IrreversibleTransform;
  })();

  // Section 3.8.1 Reversible 5-3 filter
  var ReversibleTransform = (function ReversibleTransformClosure() {
    function ReversibleTransform() {
      Transform.call(this);
    }

    ReversibleTransform.prototype = Object.create(Transform.prototype);
    ReversibleTransform.prototype.filter =
      function reversibleTransformFilter(x, offset, length) {
      var len = length >> 1;
      offset = offset | 0;
      var j, n;

      for (j = offset, n = len + 1; n--; j += 2) {
        x[j] -= (x[j - 1] + x[j + 1] + 2) >> 2;
      }

      for (j = offset + 1, n = len; n--; j += 2) {
        x[j] += (x[j - 1] + x[j + 1]) >> 1;
      }
    };

    return ReversibleTransform;
  })();

  return JpxImage;
})();

exports.JpxImage = JpxImage;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreMetrics = {}), root.pdfjsSharedUtil);
  }
}(this, function (exports, sharedUtil) {
var getLookupTableFactory = sharedUtil.getLookupTableFactory;

// The Metrics object contains glyph widths (in glyph space units).
// As per PDF spec, for most fonts (Type 3 being an exception) a glyph
// space unit corresponds to 1/1000th of text space unit.
var getMetrics = getLookupTableFactory(function (t) {
  t['Courier'] = 600;
  t['Courier-Bold'] = 600;
  t['Courier-BoldOblique'] = 600;
  t['Courier-Oblique'] = 600;
  t['Helvetica'] = getLookupTableFactory(function (t) {
    t['space'] = 278;
    t['exclam'] = 278;
    t['quotedbl'] = 355;
    t['numbersign'] = 556;
    t['dollar'] = 556;
    t['percent'] = 889;
    t['ampersand'] = 667;
    t['quoteright'] = 222;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 389;
    t['plus'] = 584;
    t['comma'] = 278;
    t['hyphen'] = 333;
    t['period'] = 278;
    t['slash'] = 278;
    t['zero'] = 556;
    t['one'] = 556;
    t['two'] = 556;
    t['three'] = 556;
    t['four'] = 556;
    t['five'] = 556;
    t['six'] = 556;
    t['seven'] = 556;
    t['eight'] = 556;
    t['nine'] = 556;
    t['colon'] = 278;
    t['semicolon'] = 278;
    t['less'] = 584;
    t['equal'] = 584;
    t['greater'] = 584;
    t['question'] = 556;
    t['at'] = 1015;
    t['A'] = 667;
    t['B'] = 667;
    t['C'] = 722;
    t['D'] = 722;
    t['E'] = 667;
    t['F'] = 611;
    t['G'] = 778;
    t['H'] = 722;
    t['I'] = 278;
    t['J'] = 500;
    t['K'] = 667;
    t['L'] = 556;
    t['M'] = 833;
    t['N'] = 722;
    t['O'] = 778;
    t['P'] = 667;
    t['Q'] = 778;
    t['R'] = 722;
    t['S'] = 667;
    t['T'] = 611;
    t['U'] = 722;
    t['V'] = 667;
    t['W'] = 944;
    t['X'] = 667;
    t['Y'] = 667;
    t['Z'] = 611;
    t['bracketleft'] = 278;
    t['backslash'] = 278;
    t['bracketright'] = 278;
    t['asciicircum'] = 469;
    t['underscore'] = 556;
    t['quoteleft'] = 222;
    t['a'] = 556;
    t['b'] = 556;
    t['c'] = 500;
    t['d'] = 556;
    t['e'] = 556;
    t['f'] = 278;
    t['g'] = 556;
    t['h'] = 556;
    t['i'] = 222;
    t['j'] = 222;
    t['k'] = 500;
    t['l'] = 222;
    t['m'] = 833;
    t['n'] = 556;
    t['o'] = 556;
    t['p'] = 556;
    t['q'] = 556;
    t['r'] = 333;
    t['s'] = 500;
    t['t'] = 278;
    t['u'] = 556;
    t['v'] = 500;
    t['w'] = 722;
    t['x'] = 500;
    t['y'] = 500;
    t['z'] = 500;
    t['braceleft'] = 334;
    t['bar'] = 260;
    t['braceright'] = 334;
    t['asciitilde'] = 584;
    t['exclamdown'] = 333;
    t['cent'] = 556;
    t['sterling'] = 556;
    t['fraction'] = 167;
    t['yen'] = 556;
    t['florin'] = 556;
    t['section'] = 556;
    t['currency'] = 556;
    t['quotesingle'] = 191;
    t['quotedblleft'] = 333;
    t['guillemotleft'] = 556;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 500;
    t['fl'] = 500;
    t['endash'] = 556;
    t['dagger'] = 556;
    t['daggerdbl'] = 556;
    t['periodcentered'] = 278;
    t['paragraph'] = 537;
    t['bullet'] = 350;
    t['quotesinglbase'] = 222;
    t['quotedblbase'] = 333;
    t['quotedblright'] = 333;
    t['guillemotright'] = 556;
    t['ellipsis'] = 1000;
    t['perthousand'] = 1000;
    t['questiondown'] = 611;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 1000;
    t['AE'] = 1000;
    t['ordfeminine'] = 370;
    t['Lslash'] = 556;
    t['Oslash'] = 778;
    t['OE'] = 1000;
    t['ordmasculine'] = 365;
    t['ae'] = 889;
    t['dotlessi'] = 278;
    t['lslash'] = 222;
    t['oslash'] = 611;
    t['oe'] = 944;
    t['germandbls'] = 611;
    t['Idieresis'] = 278;
    t['eacute'] = 556;
    t['abreve'] = 556;
    t['uhungarumlaut'] = 556;
    t['ecaron'] = 556;
    t['Ydieresis'] = 667;
    t['divide'] = 584;
    t['Yacute'] = 667;
    t['Acircumflex'] = 667;
    t['aacute'] = 556;
    t['Ucircumflex'] = 722;
    t['yacute'] = 500;
    t['scommaaccent'] = 500;
    t['ecircumflex'] = 556;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 556;
    t['Uacute'] = 722;
    t['uogonek'] = 556;
    t['Edieresis'] = 667;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 737;
    t['Emacron'] = 667;
    t['ccaron'] = 500;
    t['aring'] = 556;
    t['Ncommaaccent'] = 722;
    t['lacute'] = 222;
    t['agrave'] = 556;
    t['Tcommaaccent'] = 611;
    t['Cacute'] = 722;
    t['atilde'] = 556;
    t['Edotaccent'] = 667;
    t['scaron'] = 500;
    t['scedilla'] = 500;
    t['iacute'] = 278;
    t['lozenge'] = 471;
    t['Rcaron'] = 722;
    t['Gcommaaccent'] = 778;
    t['ucircumflex'] = 556;
    t['acircumflex'] = 556;
    t['Amacron'] = 667;
    t['rcaron'] = 333;
    t['ccedilla'] = 500;
    t['Zdotaccent'] = 611;
    t['Thorn'] = 667;
    t['Omacron'] = 778;
    t['Racute'] = 722;
    t['Sacute'] = 667;
    t['dcaron'] = 643;
    t['Umacron'] = 722;
    t['uring'] = 556;
    t['threesuperior'] = 333;
    t['Ograve'] = 778;
    t['Agrave'] = 667;
    t['Abreve'] = 667;
    t['multiply'] = 584;
    t['uacute'] = 556;
    t['Tcaron'] = 611;
    t['partialdiff'] = 476;
    t['ydieresis'] = 500;
    t['Nacute'] = 722;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 667;
    t['adieresis'] = 556;
    t['edieresis'] = 556;
    t['cacute'] = 500;
    t['nacute'] = 556;
    t['umacron'] = 556;
    t['Ncaron'] = 722;
    t['Iacute'] = 278;
    t['plusminus'] = 584;
    t['brokenbar'] = 260;
    t['registered'] = 737;
    t['Gbreve'] = 778;
    t['Idotaccent'] = 278;
    t['summation'] = 600;
    t['Egrave'] = 667;
    t['racute'] = 333;
    t['omacron'] = 556;
    t['Zacute'] = 611;
    t['Zcaron'] = 611;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 722;
    t['lcommaaccent'] = 222;
    t['tcaron'] = 317;
    t['eogonek'] = 556;
    t['Uogonek'] = 722;
    t['Aacute'] = 667;
    t['Adieresis'] = 667;
    t['egrave'] = 556;
    t['zacute'] = 500;
    t['iogonek'] = 222;
    t['Oacute'] = 778;
    t['oacute'] = 556;
    t['amacron'] = 556;
    t['sacute'] = 500;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 778;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 556;
    t['twosuperior'] = 333;
    t['Odieresis'] = 778;
    t['mu'] = 556;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 556;
    t['Eogonek'] = 667;
    t['dcroat'] = 556;
    t['threequarters'] = 834;
    t['Scedilla'] = 667;
    t['lcaron'] = 299;
    t['Kcommaaccent'] = 667;
    t['Lacute'] = 556;
    t['trademark'] = 1000;
    t['edotaccent'] = 556;
    t['Igrave'] = 278;
    t['Imacron'] = 278;
    t['Lcaron'] = 556;
    t['onehalf'] = 834;
    t['lessequal'] = 549;
    t['ocircumflex'] = 556;
    t['ntilde'] = 556;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 667;
    t['emacron'] = 556;
    t['gbreve'] = 556;
    t['onequarter'] = 834;
    t['Scaron'] = 667;
    t['Scommaaccent'] = 667;
    t['Ohungarumlaut'] = 778;
    t['degree'] = 400;
    t['ograve'] = 556;
    t['Ccaron'] = 722;
    t['ugrave'] = 556;
    t['radical'] = 453;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 333;
    t['Ntilde'] = 722;
    t['otilde'] = 556;
    t['Rcommaaccent'] = 722;
    t['Lcommaaccent'] = 556;
    t['Atilde'] = 667;
    t['Aogonek'] = 667;
    t['Aring'] = 667;
    t['Otilde'] = 778;
    t['zdotaccent'] = 500;
    t['Ecaron'] = 667;
    t['Iogonek'] = 278;
    t['kcommaaccent'] = 500;
    t['minus'] = 584;
    t['Icircumflex'] = 278;
    t['ncaron'] = 556;
    t['tcommaaccent'] = 278;
    t['logicalnot'] = 584;
    t['odieresis'] = 556;
    t['udieresis'] = 556;
    t['notequal'] = 549;
    t['gcommaaccent'] = 556;
    t['eth'] = 556;
    t['zcaron'] = 500;
    t['ncommaaccent'] = 556;
    t['onesuperior'] = 333;
    t['imacron'] = 278;
    t['Euro'] = 556;
  });
  t['Helvetica-Bold'] = getLookupTableFactory(function (t) {
    t['space'] = 278;
    t['exclam'] = 333;
    t['quotedbl'] = 474;
    t['numbersign'] = 556;
    t['dollar'] = 556;
    t['percent'] = 889;
    t['ampersand'] = 722;
    t['quoteright'] = 278;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 389;
    t['plus'] = 584;
    t['comma'] = 278;
    t['hyphen'] = 333;
    t['period'] = 278;
    t['slash'] = 278;
    t['zero'] = 556;
    t['one'] = 556;
    t['two'] = 556;
    t['three'] = 556;
    t['four'] = 556;
    t['five'] = 556;
    t['six'] = 556;
    t['seven'] = 556;
    t['eight'] = 556;
    t['nine'] = 556;
    t['colon'] = 333;
    t['semicolon'] = 333;
    t['less'] = 584;
    t['equal'] = 584;
    t['greater'] = 584;
    t['question'] = 611;
    t['at'] = 975;
    t['A'] = 722;
    t['B'] = 722;
    t['C'] = 722;
    t['D'] = 722;
    t['E'] = 667;
    t['F'] = 611;
    t['G'] = 778;
    t['H'] = 722;
    t['I'] = 278;
    t['J'] = 556;
    t['K'] = 722;
    t['L'] = 611;
    t['M'] = 833;
    t['N'] = 722;
    t['O'] = 778;
    t['P'] = 667;
    t['Q'] = 778;
    t['R'] = 722;
    t['S'] = 667;
    t['T'] = 611;
    t['U'] = 722;
    t['V'] = 667;
    t['W'] = 944;
    t['X'] = 667;
    t['Y'] = 667;
    t['Z'] = 611;
    t['bracketleft'] = 333;
    t['backslash'] = 278;
    t['bracketright'] = 333;
    t['asciicircum'] = 584;
    t['underscore'] = 556;
    t['quoteleft'] = 278;
    t['a'] = 556;
    t['b'] = 611;
    t['c'] = 556;
    t['d'] = 611;
    t['e'] = 556;
    t['f'] = 333;
    t['g'] = 611;
    t['h'] = 611;
    t['i'] = 278;
    t['j'] = 278;
    t['k'] = 556;
    t['l'] = 278;
    t['m'] = 889;
    t['n'] = 611;
    t['o'] = 611;
    t['p'] = 611;
    t['q'] = 611;
    t['r'] = 389;
    t['s'] = 556;
    t['t'] = 333;
    t['u'] = 611;
    t['v'] = 556;
    t['w'] = 778;
    t['x'] = 556;
    t['y'] = 556;
    t['z'] = 500;
    t['braceleft'] = 389;
    t['bar'] = 280;
    t['braceright'] = 389;
    t['asciitilde'] = 584;
    t['exclamdown'] = 333;
    t['cent'] = 556;
    t['sterling'] = 556;
    t['fraction'] = 167;
    t['yen'] = 556;
    t['florin'] = 556;
    t['section'] = 556;
    t['currency'] = 556;
    t['quotesingle'] = 238;
    t['quotedblleft'] = 500;
    t['guillemotleft'] = 556;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 611;
    t['fl'] = 611;
    t['endash'] = 556;
    t['dagger'] = 556;
    t['daggerdbl'] = 556;
    t['periodcentered'] = 278;
    t['paragraph'] = 556;
    t['bullet'] = 350;
    t['quotesinglbase'] = 278;
    t['quotedblbase'] = 500;
    t['quotedblright'] = 500;
    t['guillemotright'] = 556;
    t['ellipsis'] = 1000;
    t['perthousand'] = 1000;
    t['questiondown'] = 611;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 1000;
    t['AE'] = 1000;
    t['ordfeminine'] = 370;
    t['Lslash'] = 611;
    t['Oslash'] = 778;
    t['OE'] = 1000;
    t['ordmasculine'] = 365;
    t['ae'] = 889;
    t['dotlessi'] = 278;
    t['lslash'] = 278;
    t['oslash'] = 611;
    t['oe'] = 944;
    t['germandbls'] = 611;
    t['Idieresis'] = 278;
    t['eacute'] = 556;
    t['abreve'] = 556;
    t['uhungarumlaut'] = 611;
    t['ecaron'] = 556;
    t['Ydieresis'] = 667;
    t['divide'] = 584;
    t['Yacute'] = 667;
    t['Acircumflex'] = 722;
    t['aacute'] = 556;
    t['Ucircumflex'] = 722;
    t['yacute'] = 556;
    t['scommaaccent'] = 556;
    t['ecircumflex'] = 556;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 556;
    t['Uacute'] = 722;
    t['uogonek'] = 611;
    t['Edieresis'] = 667;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 737;
    t['Emacron'] = 667;
    t['ccaron'] = 556;
    t['aring'] = 556;
    t['Ncommaaccent'] = 722;
    t['lacute'] = 278;
    t['agrave'] = 556;
    t['Tcommaaccent'] = 611;
    t['Cacute'] = 722;
    t['atilde'] = 556;
    t['Edotaccent'] = 667;
    t['scaron'] = 556;
    t['scedilla'] = 556;
    t['iacute'] = 278;
    t['lozenge'] = 494;
    t['Rcaron'] = 722;
    t['Gcommaaccent'] = 778;
    t['ucircumflex'] = 611;
    t['acircumflex'] = 556;
    t['Amacron'] = 722;
    t['rcaron'] = 389;
    t['ccedilla'] = 556;
    t['Zdotaccent'] = 611;
    t['Thorn'] = 667;
    t['Omacron'] = 778;
    t['Racute'] = 722;
    t['Sacute'] = 667;
    t['dcaron'] = 743;
    t['Umacron'] = 722;
    t['uring'] = 611;
    t['threesuperior'] = 333;
    t['Ograve'] = 778;
    t['Agrave'] = 722;
    t['Abreve'] = 722;
    t['multiply'] = 584;
    t['uacute'] = 611;
    t['Tcaron'] = 611;
    t['partialdiff'] = 494;
    t['ydieresis'] = 556;
    t['Nacute'] = 722;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 667;
    t['adieresis'] = 556;
    t['edieresis'] = 556;
    t['cacute'] = 556;
    t['nacute'] = 611;
    t['umacron'] = 611;
    t['Ncaron'] = 722;
    t['Iacute'] = 278;
    t['plusminus'] = 584;
    t['brokenbar'] = 280;
    t['registered'] = 737;
    t['Gbreve'] = 778;
    t['Idotaccent'] = 278;
    t['summation'] = 600;
    t['Egrave'] = 667;
    t['racute'] = 389;
    t['omacron'] = 611;
    t['Zacute'] = 611;
    t['Zcaron'] = 611;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 722;
    t['lcommaaccent'] = 278;
    t['tcaron'] = 389;
    t['eogonek'] = 556;
    t['Uogonek'] = 722;
    t['Aacute'] = 722;
    t['Adieresis'] = 722;
    t['egrave'] = 556;
    t['zacute'] = 500;
    t['iogonek'] = 278;
    t['Oacute'] = 778;
    t['oacute'] = 611;
    t['amacron'] = 556;
    t['sacute'] = 556;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 778;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 611;
    t['twosuperior'] = 333;
    t['Odieresis'] = 778;
    t['mu'] = 611;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 611;
    t['Eogonek'] = 667;
    t['dcroat'] = 611;
    t['threequarters'] = 834;
    t['Scedilla'] = 667;
    t['lcaron'] = 400;
    t['Kcommaaccent'] = 722;
    t['Lacute'] = 611;
    t['trademark'] = 1000;
    t['edotaccent'] = 556;
    t['Igrave'] = 278;
    t['Imacron'] = 278;
    t['Lcaron'] = 611;
    t['onehalf'] = 834;
    t['lessequal'] = 549;
    t['ocircumflex'] = 611;
    t['ntilde'] = 611;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 667;
    t['emacron'] = 556;
    t['gbreve'] = 611;
    t['onequarter'] = 834;
    t['Scaron'] = 667;
    t['Scommaaccent'] = 667;
    t['Ohungarumlaut'] = 778;
    t['degree'] = 400;
    t['ograve'] = 611;
    t['Ccaron'] = 722;
    t['ugrave'] = 611;
    t['radical'] = 549;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 389;
    t['Ntilde'] = 722;
    t['otilde'] = 611;
    t['Rcommaaccent'] = 722;
    t['Lcommaaccent'] = 611;
    t['Atilde'] = 722;
    t['Aogonek'] = 722;
    t['Aring'] = 722;
    t['Otilde'] = 778;
    t['zdotaccent'] = 500;
    t['Ecaron'] = 667;
    t['Iogonek'] = 278;
    t['kcommaaccent'] = 556;
    t['minus'] = 584;
    t['Icircumflex'] = 278;
    t['ncaron'] = 611;
    t['tcommaaccent'] = 333;
    t['logicalnot'] = 584;
    t['odieresis'] = 611;
    t['udieresis'] = 611;
    t['notequal'] = 549;
    t['gcommaaccent'] = 611;
    t['eth'] = 611;
    t['zcaron'] = 500;
    t['ncommaaccent'] = 611;
    t['onesuperior'] = 333;
    t['imacron'] = 278;
    t['Euro'] = 556;
  });
  t['Helvetica-BoldOblique'] = getLookupTableFactory(function (t) {
    t['space'] = 278;
    t['exclam'] = 333;
    t['quotedbl'] = 474;
    t['numbersign'] = 556;
    t['dollar'] = 556;
    t['percent'] = 889;
    t['ampersand'] = 722;
    t['quoteright'] = 278;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 389;
    t['plus'] = 584;
    t['comma'] = 278;
    t['hyphen'] = 333;
    t['period'] = 278;
    t['slash'] = 278;
    t['zero'] = 556;
    t['one'] = 556;
    t['two'] = 556;
    t['three'] = 556;
    t['four'] = 556;
    t['five'] = 556;
    t['six'] = 556;
    t['seven'] = 556;
    t['eight'] = 556;
    t['nine'] = 556;
    t['colon'] = 333;
    t['semicolon'] = 333;
    t['less'] = 584;
    t['equal'] = 584;
    t['greater'] = 584;
    t['question'] = 611;
    t['at'] = 975;
    t['A'] = 722;
    t['B'] = 722;
    t['C'] = 722;
    t['D'] = 722;
    t['E'] = 667;
    t['F'] = 611;
    t['G'] = 778;
    t['H'] = 722;
    t['I'] = 278;
    t['J'] = 556;
    t['K'] = 722;
    t['L'] = 611;
    t['M'] = 833;
    t['N'] = 722;
    t['O'] = 778;
    t['P'] = 667;
    t['Q'] = 778;
    t['R'] = 722;
    t['S'] = 667;
    t['T'] = 611;
    t['U'] = 722;
    t['V'] = 667;
    t['W'] = 944;
    t['X'] = 667;
    t['Y'] = 667;
    t['Z'] = 611;
    t['bracketleft'] = 333;
    t['backslash'] = 278;
    t['bracketright'] = 333;
    t['asciicircum'] = 584;
    t['underscore'] = 556;
    t['quoteleft'] = 278;
    t['a'] = 556;
    t['b'] = 611;
    t['c'] = 556;
    t['d'] = 611;
    t['e'] = 556;
    t['f'] = 333;
    t['g'] = 611;
    t['h'] = 611;
    t['i'] = 278;
    t['j'] = 278;
    t['k'] = 556;
    t['l'] = 278;
    t['m'] = 889;
    t['n'] = 611;
    t['o'] = 611;
    t['p'] = 611;
    t['q'] = 611;
    t['r'] = 389;
    t['s'] = 556;
    t['t'] = 333;
    t['u'] = 611;
    t['v'] = 556;
    t['w'] = 778;
    t['x'] = 556;
    t['y'] = 556;
    t['z'] = 500;
    t['braceleft'] = 389;
    t['bar'] = 280;
    t['braceright'] = 389;
    t['asciitilde'] = 584;
    t['exclamdown'] = 333;
    t['cent'] = 556;
    t['sterling'] = 556;
    t['fraction'] = 167;
    t['yen'] = 556;
    t['florin'] = 556;
    t['section'] = 556;
    t['currency'] = 556;
    t['quotesingle'] = 238;
    t['quotedblleft'] = 500;
    t['guillemotleft'] = 556;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 611;
    t['fl'] = 611;
    t['endash'] = 556;
    t['dagger'] = 556;
    t['daggerdbl'] = 556;
    t['periodcentered'] = 278;
    t['paragraph'] = 556;
    t['bullet'] = 350;
    t['quotesinglbase'] = 278;
    t['quotedblbase'] = 500;
    t['quotedblright'] = 500;
    t['guillemotright'] = 556;
    t['ellipsis'] = 1000;
    t['perthousand'] = 1000;
    t['questiondown'] = 611;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 1000;
    t['AE'] = 1000;
    t['ordfeminine'] = 370;
    t['Lslash'] = 611;
    t['Oslash'] = 778;
    t['OE'] = 1000;
    t['ordmasculine'] = 365;
    t['ae'] = 889;
    t['dotlessi'] = 278;
    t['lslash'] = 278;
    t['oslash'] = 611;
    t['oe'] = 944;
    t['germandbls'] = 611;
    t['Idieresis'] = 278;
    t['eacute'] = 556;
    t['abreve'] = 556;
    t['uhungarumlaut'] = 611;
    t['ecaron'] = 556;
    t['Ydieresis'] = 667;
    t['divide'] = 584;
    t['Yacute'] = 667;
    t['Acircumflex'] = 722;
    t['aacute'] = 556;
    t['Ucircumflex'] = 722;
    t['yacute'] = 556;
    t['scommaaccent'] = 556;
    t['ecircumflex'] = 556;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 556;
    t['Uacute'] = 722;
    t['uogonek'] = 611;
    t['Edieresis'] = 667;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 737;
    t['Emacron'] = 667;
    t['ccaron'] = 556;
    t['aring'] = 556;
    t['Ncommaaccent'] = 722;
    t['lacute'] = 278;
    t['agrave'] = 556;
    t['Tcommaaccent'] = 611;
    t['Cacute'] = 722;
    t['atilde'] = 556;
    t['Edotaccent'] = 667;
    t['scaron'] = 556;
    t['scedilla'] = 556;
    t['iacute'] = 278;
    t['lozenge'] = 494;
    t['Rcaron'] = 722;
    t['Gcommaaccent'] = 778;
    t['ucircumflex'] = 611;
    t['acircumflex'] = 556;
    t['Amacron'] = 722;
    t['rcaron'] = 389;
    t['ccedilla'] = 556;
    t['Zdotaccent'] = 611;
    t['Thorn'] = 667;
    t['Omacron'] = 778;
    t['Racute'] = 722;
    t['Sacute'] = 667;
    t['dcaron'] = 743;
    t['Umacron'] = 722;
    t['uring'] = 611;
    t['threesuperior'] = 333;
    t['Ograve'] = 778;
    t['Agrave'] = 722;
    t['Abreve'] = 722;
    t['multiply'] = 584;
    t['uacute'] = 611;
    t['Tcaron'] = 611;
    t['partialdiff'] = 494;
    t['ydieresis'] = 556;
    t['Nacute'] = 722;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 667;
    t['adieresis'] = 556;
    t['edieresis'] = 556;
    t['cacute'] = 556;
    t['nacute'] = 611;
    t['umacron'] = 611;
    t['Ncaron'] = 722;
    t['Iacute'] = 278;
    t['plusminus'] = 584;
    t['brokenbar'] = 280;
    t['registered'] = 737;
    t['Gbreve'] = 778;
    t['Idotaccent'] = 278;
    t['summation'] = 600;
    t['Egrave'] = 667;
    t['racute'] = 389;
    t['omacron'] = 611;
    t['Zacute'] = 611;
    t['Zcaron'] = 611;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 722;
    t['lcommaaccent'] = 278;
    t['tcaron'] = 389;
    t['eogonek'] = 556;
    t['Uogonek'] = 722;
    t['Aacute'] = 722;
    t['Adieresis'] = 722;
    t['egrave'] = 556;
    t['zacute'] = 500;
    t['iogonek'] = 278;
    t['Oacute'] = 778;
    t['oacute'] = 611;
    t['amacron'] = 556;
    t['sacute'] = 556;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 778;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 611;
    t['twosuperior'] = 333;
    t['Odieresis'] = 778;
    t['mu'] = 611;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 611;
    t['Eogonek'] = 667;
    t['dcroat'] = 611;
    t['threequarters'] = 834;
    t['Scedilla'] = 667;
    t['lcaron'] = 400;
    t['Kcommaaccent'] = 722;
    t['Lacute'] = 611;
    t['trademark'] = 1000;
    t['edotaccent'] = 556;
    t['Igrave'] = 278;
    t['Imacron'] = 278;
    t['Lcaron'] = 611;
    t['onehalf'] = 834;
    t['lessequal'] = 549;
    t['ocircumflex'] = 611;
    t['ntilde'] = 611;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 667;
    t['emacron'] = 556;
    t['gbreve'] = 611;
    t['onequarter'] = 834;
    t['Scaron'] = 667;
    t['Scommaaccent'] = 667;
    t['Ohungarumlaut'] = 778;
    t['degree'] = 400;
    t['ograve'] = 611;
    t['Ccaron'] = 722;
    t['ugrave'] = 611;
    t['radical'] = 549;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 389;
    t['Ntilde'] = 722;
    t['otilde'] = 611;
    t['Rcommaaccent'] = 722;
    t['Lcommaaccent'] = 611;
    t['Atilde'] = 722;
    t['Aogonek'] = 722;
    t['Aring'] = 722;
    t['Otilde'] = 778;
    t['zdotaccent'] = 500;
    t['Ecaron'] = 667;
    t['Iogonek'] = 278;
    t['kcommaaccent'] = 556;
    t['minus'] = 584;
    t['Icircumflex'] = 278;
    t['ncaron'] = 611;
    t['tcommaaccent'] = 333;
    t['logicalnot'] = 584;
    t['odieresis'] = 611;
    t['udieresis'] = 611;
    t['notequal'] = 549;
    t['gcommaaccent'] = 611;
    t['eth'] = 611;
    t['zcaron'] = 500;
    t['ncommaaccent'] = 611;
    t['onesuperior'] = 333;
    t['imacron'] = 278;
    t['Euro'] = 556;
  });
  t['Helvetica-Oblique'] = getLookupTableFactory(function (t) {
    t['space'] = 278;
    t['exclam'] = 278;
    t['quotedbl'] = 355;
    t['numbersign'] = 556;
    t['dollar'] = 556;
    t['percent'] = 889;
    t['ampersand'] = 667;
    t['quoteright'] = 222;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 389;
    t['plus'] = 584;
    t['comma'] = 278;
    t['hyphen'] = 333;
    t['period'] = 278;
    t['slash'] = 278;
    t['zero'] = 556;
    t['one'] = 556;
    t['two'] = 556;
    t['three'] = 556;
    t['four'] = 556;
    t['five'] = 556;
    t['six'] = 556;
    t['seven'] = 556;
    t['eight'] = 556;
    t['nine'] = 556;
    t['colon'] = 278;
    t['semicolon'] = 278;
    t['less'] = 584;
    t['equal'] = 584;
    t['greater'] = 584;
    t['question'] = 556;
    t['at'] = 1015;
    t['A'] = 667;
    t['B'] = 667;
    t['C'] = 722;
    t['D'] = 722;
    t['E'] = 667;
    t['F'] = 611;
    t['G'] = 778;
    t['H'] = 722;
    t['I'] = 278;
    t['J'] = 500;
    t['K'] = 667;
    t['L'] = 556;
    t['M'] = 833;
    t['N'] = 722;
    t['O'] = 778;
    t['P'] = 667;
    t['Q'] = 778;
    t['R'] = 722;
    t['S'] = 667;
    t['T'] = 611;
    t['U'] = 722;
    t['V'] = 667;
    t['W'] = 944;
    t['X'] = 667;
    t['Y'] = 667;
    t['Z'] = 611;
    t['bracketleft'] = 278;
    t['backslash'] = 278;
    t['bracketright'] = 278;
    t['asciicircum'] = 469;
    t['underscore'] = 556;
    t['quoteleft'] = 222;
    t['a'] = 556;
    t['b'] = 556;
    t['c'] = 500;
    t['d'] = 556;
    t['e'] = 556;
    t['f'] = 278;
    t['g'] = 556;
    t['h'] = 556;
    t['i'] = 222;
    t['j'] = 222;
    t['k'] = 500;
    t['l'] = 222;
    t['m'] = 833;
    t['n'] = 556;
    t['o'] = 556;
    t['p'] = 556;
    t['q'] = 556;
    t['r'] = 333;
    t['s'] = 500;
    t['t'] = 278;
    t['u'] = 556;
    t['v'] = 500;
    t['w'] = 722;
    t['x'] = 500;
    t['y'] = 500;
    t['z'] = 500;
    t['braceleft'] = 334;
    t['bar'] = 260;
    t['braceright'] = 334;
    t['asciitilde'] = 584;
    t['exclamdown'] = 333;
    t['cent'] = 556;
    t['sterling'] = 556;
    t['fraction'] = 167;
    t['yen'] = 556;
    t['florin'] = 556;
    t['section'] = 556;
    t['currency'] = 556;
    t['quotesingle'] = 191;
    t['quotedblleft'] = 333;
    t['guillemotleft'] = 556;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 500;
    t['fl'] = 500;
    t['endash'] = 556;
    t['dagger'] = 556;
    t['daggerdbl'] = 556;
    t['periodcentered'] = 278;
    t['paragraph'] = 537;
    t['bullet'] = 350;
    t['quotesinglbase'] = 222;
    t['quotedblbase'] = 333;
    t['quotedblright'] = 333;
    t['guillemotright'] = 556;
    t['ellipsis'] = 1000;
    t['perthousand'] = 1000;
    t['questiondown'] = 611;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 1000;
    t['AE'] = 1000;
    t['ordfeminine'] = 370;
    t['Lslash'] = 556;
    t['Oslash'] = 778;
    t['OE'] = 1000;
    t['ordmasculine'] = 365;
    t['ae'] = 889;
    t['dotlessi'] = 278;
    t['lslash'] = 222;
    t['oslash'] = 611;
    t['oe'] = 944;
    t['germandbls'] = 611;
    t['Idieresis'] = 278;
    t['eacute'] = 556;
    t['abreve'] = 556;
    t['uhungarumlaut'] = 556;
    t['ecaron'] = 556;
    t['Ydieresis'] = 667;
    t['divide'] = 584;
    t['Yacute'] = 667;
    t['Acircumflex'] = 667;
    t['aacute'] = 556;
    t['Ucircumflex'] = 722;
    t['yacute'] = 500;
    t['scommaaccent'] = 500;
    t['ecircumflex'] = 556;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 556;
    t['Uacute'] = 722;
    t['uogonek'] = 556;
    t['Edieresis'] = 667;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 737;
    t['Emacron'] = 667;
    t['ccaron'] = 500;
    t['aring'] = 556;
    t['Ncommaaccent'] = 722;
    t['lacute'] = 222;
    t['agrave'] = 556;
    t['Tcommaaccent'] = 611;
    t['Cacute'] = 722;
    t['atilde'] = 556;
    t['Edotaccent'] = 667;
    t['scaron'] = 500;
    t['scedilla'] = 500;
    t['iacute'] = 278;
    t['lozenge'] = 471;
    t['Rcaron'] = 722;
    t['Gcommaaccent'] = 778;
    t['ucircumflex'] = 556;
    t['acircumflex'] = 556;
    t['Amacron'] = 667;
    t['rcaron'] = 333;
    t['ccedilla'] = 500;
    t['Zdotaccent'] = 611;
    t['Thorn'] = 667;
    t['Omacron'] = 778;
    t['Racute'] = 722;
    t['Sacute'] = 667;
    t['dcaron'] = 643;
    t['Umacron'] = 722;
    t['uring'] = 556;
    t['threesuperior'] = 333;
    t['Ograve'] = 778;
    t['Agrave'] = 667;
    t['Abreve'] = 667;
    t['multiply'] = 584;
    t['uacute'] = 556;
    t['Tcaron'] = 611;
    t['partialdiff'] = 476;
    t['ydieresis'] = 500;
    t['Nacute'] = 722;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 667;
    t['adieresis'] = 556;
    t['edieresis'] = 556;
    t['cacute'] = 500;
    t['nacute'] = 556;
    t['umacron'] = 556;
    t['Ncaron'] = 722;
    t['Iacute'] = 278;
    t['plusminus'] = 584;
    t['brokenbar'] = 260;
    t['registered'] = 737;
    t['Gbreve'] = 778;
    t['Idotaccent'] = 278;
    t['summation'] = 600;
    t['Egrave'] = 667;
    t['racute'] = 333;
    t['omacron'] = 556;
    t['Zacute'] = 611;
    t['Zcaron'] = 611;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 722;
    t['lcommaaccent'] = 222;
    t['tcaron'] = 317;
    t['eogonek'] = 556;
    t['Uogonek'] = 722;
    t['Aacute'] = 667;
    t['Adieresis'] = 667;
    t['egrave'] = 556;
    t['zacute'] = 500;
    t['iogonek'] = 222;
    t['Oacute'] = 778;
    t['oacute'] = 556;
    t['amacron'] = 556;
    t['sacute'] = 500;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 778;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 556;
    t['twosuperior'] = 333;
    t['Odieresis'] = 778;
    t['mu'] = 556;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 556;
    t['Eogonek'] = 667;
    t['dcroat'] = 556;
    t['threequarters'] = 834;
    t['Scedilla'] = 667;
    t['lcaron'] = 299;
    t['Kcommaaccent'] = 667;
    t['Lacute'] = 556;
    t['trademark'] = 1000;
    t['edotaccent'] = 556;
    t['Igrave'] = 278;
    t['Imacron'] = 278;
    t['Lcaron'] = 556;
    t['onehalf'] = 834;
    t['lessequal'] = 549;
    t['ocircumflex'] = 556;
    t['ntilde'] = 556;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 667;
    t['emacron'] = 556;
    t['gbreve'] = 556;
    t['onequarter'] = 834;
    t['Scaron'] = 667;
    t['Scommaaccent'] = 667;
    t['Ohungarumlaut'] = 778;
    t['degree'] = 400;
    t['ograve'] = 556;
    t['Ccaron'] = 722;
    t['ugrave'] = 556;
    t['radical'] = 453;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 333;
    t['Ntilde'] = 722;
    t['otilde'] = 556;
    t['Rcommaaccent'] = 722;
    t['Lcommaaccent'] = 556;
    t['Atilde'] = 667;
    t['Aogonek'] = 667;
    t['Aring'] = 667;
    t['Otilde'] = 778;
    t['zdotaccent'] = 500;
    t['Ecaron'] = 667;
    t['Iogonek'] = 278;
    t['kcommaaccent'] = 500;
    t['minus'] = 584;
    t['Icircumflex'] = 278;
    t['ncaron'] = 556;
    t['tcommaaccent'] = 278;
    t['logicalnot'] = 584;
    t['odieresis'] = 556;
    t['udieresis'] = 556;
    t['notequal'] = 549;
    t['gcommaaccent'] = 556;
    t['eth'] = 556;
    t['zcaron'] = 500;
    t['ncommaaccent'] = 556;
    t['onesuperior'] = 333;
    t['imacron'] = 278;
    t['Euro'] = 556;
  });
  t['Symbol'] = getLookupTableFactory(function (t) {
    t['space'] = 250;
    t['exclam'] = 333;
    t['universal'] = 713;
    t['numbersign'] = 500;
    t['existential'] = 549;
    t['percent'] = 833;
    t['ampersand'] = 778;
    t['suchthat'] = 439;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asteriskmath'] = 500;
    t['plus'] = 549;
    t['comma'] = 250;
    t['minus'] = 549;
    t['period'] = 250;
    t['slash'] = 278;
    t['zero'] = 500;
    t['one'] = 500;
    t['two'] = 500;
    t['three'] = 500;
    t['four'] = 500;
    t['five'] = 500;
    t['six'] = 500;
    t['seven'] = 500;
    t['eight'] = 500;
    t['nine'] = 500;
    t['colon'] = 278;
    t['semicolon'] = 278;
    t['less'] = 549;
    t['equal'] = 549;
    t['greater'] = 549;
    t['question'] = 444;
    t['congruent'] = 549;
    t['Alpha'] = 722;
    t['Beta'] = 667;
    t['Chi'] = 722;
    t['Delta'] = 612;
    t['Epsilon'] = 611;
    t['Phi'] = 763;
    t['Gamma'] = 603;
    t['Eta'] = 722;
    t['Iota'] = 333;
    t['theta1'] = 631;
    t['Kappa'] = 722;
    t['Lambda'] = 686;
    t['Mu'] = 889;
    t['Nu'] = 722;
    t['Omicron'] = 722;
    t['Pi'] = 768;
    t['Theta'] = 741;
    t['Rho'] = 556;
    t['Sigma'] = 592;
    t['Tau'] = 611;
    t['Upsilon'] = 690;
    t['sigma1'] = 439;
    t['Omega'] = 768;
    t['Xi'] = 645;
    t['Psi'] = 795;
    t['Zeta'] = 611;
    t['bracketleft'] = 333;
    t['therefore'] = 863;
    t['bracketright'] = 333;
    t['perpendicular'] = 658;
    t['underscore'] = 500;
    t['radicalex'] = 500;
    t['alpha'] = 631;
    t['beta'] = 549;
    t['chi'] = 549;
    t['delta'] = 494;
    t['epsilon'] = 439;
    t['phi'] = 521;
    t['gamma'] = 411;
    t['eta'] = 603;
    t['iota'] = 329;
    t['phi1'] = 603;
    t['kappa'] = 549;
    t['lambda'] = 549;
    t['mu'] = 576;
    t['nu'] = 521;
    t['omicron'] = 549;
    t['pi'] = 549;
    t['theta'] = 521;
    t['rho'] = 549;
    t['sigma'] = 603;
    t['tau'] = 439;
    t['upsilon'] = 576;
    t['omega1'] = 713;
    t['omega'] = 686;
    t['xi'] = 493;
    t['psi'] = 686;
    t['zeta'] = 494;
    t['braceleft'] = 480;
    t['bar'] = 200;
    t['braceright'] = 480;
    t['similar'] = 549;
    t['Euro'] = 750;
    t['Upsilon1'] = 620;
    t['minute'] = 247;
    t['lessequal'] = 549;
    t['fraction'] = 167;
    t['infinity'] = 713;
    t['florin'] = 500;
    t['club'] = 753;
    t['diamond'] = 753;
    t['heart'] = 753;
    t['spade'] = 753;
    t['arrowboth'] = 1042;
    t['arrowleft'] = 987;
    t['arrowup'] = 603;
    t['arrowright'] = 987;
    t['arrowdown'] = 603;
    t['degree'] = 400;
    t['plusminus'] = 549;
    t['second'] = 411;
    t['greaterequal'] = 549;
    t['multiply'] = 549;
    t['proportional'] = 713;
    t['partialdiff'] = 494;
    t['bullet'] = 460;
    t['divide'] = 549;
    t['notequal'] = 549;
    t['equivalence'] = 549;
    t['approxequal'] = 549;
    t['ellipsis'] = 1000;
    t['arrowvertex'] = 603;
    t['arrowhorizex'] = 1000;
    t['carriagereturn'] = 658;
    t['aleph'] = 823;
    t['Ifraktur'] = 686;
    t['Rfraktur'] = 795;
    t['weierstrass'] = 987;
    t['circlemultiply'] = 768;
    t['circleplus'] = 768;
    t['emptyset'] = 823;
    t['intersection'] = 768;
    t['union'] = 768;
    t['propersuperset'] = 713;
    t['reflexsuperset'] = 713;
    t['notsubset'] = 713;
    t['propersubset'] = 713;
    t['reflexsubset'] = 713;
    t['element'] = 713;
    t['notelement'] = 713;
    t['angle'] = 768;
    t['gradient'] = 713;
    t['registerserif'] = 790;
    t['copyrightserif'] = 790;
    t['trademarkserif'] = 890;
    t['product'] = 823;
    t['radical'] = 549;
    t['dotmath'] = 250;
    t['logicalnot'] = 713;
    t['logicaland'] = 603;
    t['logicalor'] = 603;
    t['arrowdblboth'] = 1042;
    t['arrowdblleft'] = 987;
    t['arrowdblup'] = 603;
    t['arrowdblright'] = 987;
    t['arrowdbldown'] = 603;
    t['lozenge'] = 494;
    t['angleleft'] = 329;
    t['registersans'] = 790;
    t['copyrightsans'] = 790;
    t['trademarksans'] = 786;
    t['summation'] = 713;
    t['parenlefttp'] = 384;
    t['parenleftex'] = 384;
    t['parenleftbt'] = 384;
    t['bracketlefttp'] = 384;
    t['bracketleftex'] = 384;
    t['bracketleftbt'] = 384;
    t['bracelefttp'] = 494;
    t['braceleftmid'] = 494;
    t['braceleftbt'] = 494;
    t['braceex'] = 494;
    t['angleright'] = 329;
    t['integral'] = 274;
    t['integraltp'] = 686;
    t['integralex'] = 686;
    t['integralbt'] = 686;
    t['parenrighttp'] = 384;
    t['parenrightex'] = 384;
    t['parenrightbt'] = 384;
    t['bracketrighttp'] = 384;
    t['bracketrightex'] = 384;
    t['bracketrightbt'] = 384;
    t['bracerighttp'] = 494;
    t['bracerightmid'] = 494;
    t['bracerightbt'] = 494;
    t['apple'] = 790;
  });
  t['Times-Roman'] = getLookupTableFactory(function (t) {
    t['space'] = 250;
    t['exclam'] = 333;
    t['quotedbl'] = 408;
    t['numbersign'] = 500;
    t['dollar'] = 500;
    t['percent'] = 833;
    t['ampersand'] = 778;
    t['quoteright'] = 333;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 500;
    t['plus'] = 564;
    t['comma'] = 250;
    t['hyphen'] = 333;
    t['period'] = 250;
    t['slash'] = 278;
    t['zero'] = 500;
    t['one'] = 500;
    t['two'] = 500;
    t['three'] = 500;
    t['four'] = 500;
    t['five'] = 500;
    t['six'] = 500;
    t['seven'] = 500;
    t['eight'] = 500;
    t['nine'] = 500;
    t['colon'] = 278;
    t['semicolon'] = 278;
    t['less'] = 564;
    t['equal'] = 564;
    t['greater'] = 564;
    t['question'] = 444;
    t['at'] = 921;
    t['A'] = 722;
    t['B'] = 667;
    t['C'] = 667;
    t['D'] = 722;
    t['E'] = 611;
    t['F'] = 556;
    t['G'] = 722;
    t['H'] = 722;
    t['I'] = 333;
    t['J'] = 389;
    t['K'] = 722;
    t['L'] = 611;
    t['M'] = 889;
    t['N'] = 722;
    t['O'] = 722;
    t['P'] = 556;
    t['Q'] = 722;
    t['R'] = 667;
    t['S'] = 556;
    t['T'] = 611;
    t['U'] = 722;
    t['V'] = 722;
    t['W'] = 944;
    t['X'] = 722;
    t['Y'] = 722;
    t['Z'] = 611;
    t['bracketleft'] = 333;
    t['backslash'] = 278;
    t['bracketright'] = 333;
    t['asciicircum'] = 469;
    t['underscore'] = 500;
    t['quoteleft'] = 333;
    t['a'] = 444;
    t['b'] = 500;
    t['c'] = 444;
    t['d'] = 500;
    t['e'] = 444;
    t['f'] = 333;
    t['g'] = 500;
    t['h'] = 500;
    t['i'] = 278;
    t['j'] = 278;
    t['k'] = 500;
    t['l'] = 278;
    t['m'] = 778;
    t['n'] = 500;
    t['o'] = 500;
    t['p'] = 500;
    t['q'] = 500;
    t['r'] = 333;
    t['s'] = 389;
    t['t'] = 278;
    t['u'] = 500;
    t['v'] = 500;
    t['w'] = 722;
    t['x'] = 500;
    t['y'] = 500;
    t['z'] = 444;
    t['braceleft'] = 480;
    t['bar'] = 200;
    t['braceright'] = 480;
    t['asciitilde'] = 541;
    t['exclamdown'] = 333;
    t['cent'] = 500;
    t['sterling'] = 500;
    t['fraction'] = 167;
    t['yen'] = 500;
    t['florin'] = 500;
    t['section'] = 500;
    t['currency'] = 500;
    t['quotesingle'] = 180;
    t['quotedblleft'] = 444;
    t['guillemotleft'] = 500;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 556;
    t['fl'] = 556;
    t['endash'] = 500;
    t['dagger'] = 500;
    t['daggerdbl'] = 500;
    t['periodcentered'] = 250;
    t['paragraph'] = 453;
    t['bullet'] = 350;
    t['quotesinglbase'] = 333;
    t['quotedblbase'] = 444;
    t['quotedblright'] = 444;
    t['guillemotright'] = 500;
    t['ellipsis'] = 1000;
    t['perthousand'] = 1000;
    t['questiondown'] = 444;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 1000;
    t['AE'] = 889;
    t['ordfeminine'] = 276;
    t['Lslash'] = 611;
    t['Oslash'] = 722;
    t['OE'] = 889;
    t['ordmasculine'] = 310;
    t['ae'] = 667;
    t['dotlessi'] = 278;
    t['lslash'] = 278;
    t['oslash'] = 500;
    t['oe'] = 722;
    t['germandbls'] = 500;
    t['Idieresis'] = 333;
    t['eacute'] = 444;
    t['abreve'] = 444;
    t['uhungarumlaut'] = 500;
    t['ecaron'] = 444;
    t['Ydieresis'] = 722;
    t['divide'] = 564;
    t['Yacute'] = 722;
    t['Acircumflex'] = 722;
    t['aacute'] = 444;
    t['Ucircumflex'] = 722;
    t['yacute'] = 500;
    t['scommaaccent'] = 389;
    t['ecircumflex'] = 444;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 444;
    t['Uacute'] = 722;
    t['uogonek'] = 500;
    t['Edieresis'] = 611;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 760;
    t['Emacron'] = 611;
    t['ccaron'] = 444;
    t['aring'] = 444;
    t['Ncommaaccent'] = 722;
    t['lacute'] = 278;
    t['agrave'] = 444;
    t['Tcommaaccent'] = 611;
    t['Cacute'] = 667;
    t['atilde'] = 444;
    t['Edotaccent'] = 611;
    t['scaron'] = 389;
    t['scedilla'] = 389;
    t['iacute'] = 278;
    t['lozenge'] = 471;
    t['Rcaron'] = 667;
    t['Gcommaaccent'] = 722;
    t['ucircumflex'] = 500;
    t['acircumflex'] = 444;
    t['Amacron'] = 722;
    t['rcaron'] = 333;
    t['ccedilla'] = 444;
    t['Zdotaccent'] = 611;
    t['Thorn'] = 556;
    t['Omacron'] = 722;
    t['Racute'] = 667;
    t['Sacute'] = 556;
    t['dcaron'] = 588;
    t['Umacron'] = 722;
    t['uring'] = 500;
    t['threesuperior'] = 300;
    t['Ograve'] = 722;
    t['Agrave'] = 722;
    t['Abreve'] = 722;
    t['multiply'] = 564;
    t['uacute'] = 500;
    t['Tcaron'] = 611;
    t['partialdiff'] = 476;
    t['ydieresis'] = 500;
    t['Nacute'] = 722;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 611;
    t['adieresis'] = 444;
    t['edieresis'] = 444;
    t['cacute'] = 444;
    t['nacute'] = 500;
    t['umacron'] = 500;
    t['Ncaron'] = 722;
    t['Iacute'] = 333;
    t['plusminus'] = 564;
    t['brokenbar'] = 200;
    t['registered'] = 760;
    t['Gbreve'] = 722;
    t['Idotaccent'] = 333;
    t['summation'] = 600;
    t['Egrave'] = 611;
    t['racute'] = 333;
    t['omacron'] = 500;
    t['Zacute'] = 611;
    t['Zcaron'] = 611;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 667;
    t['lcommaaccent'] = 278;
    t['tcaron'] = 326;
    t['eogonek'] = 444;
    t['Uogonek'] = 722;
    t['Aacute'] = 722;
    t['Adieresis'] = 722;
    t['egrave'] = 444;
    t['zacute'] = 444;
    t['iogonek'] = 278;
    t['Oacute'] = 722;
    t['oacute'] = 500;
    t['amacron'] = 444;
    t['sacute'] = 389;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 722;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 500;
    t['twosuperior'] = 300;
    t['Odieresis'] = 722;
    t['mu'] = 500;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 500;
    t['Eogonek'] = 611;
    t['dcroat'] = 500;
    t['threequarters'] = 750;
    t['Scedilla'] = 556;
    t['lcaron'] = 344;
    t['Kcommaaccent'] = 722;
    t['Lacute'] = 611;
    t['trademark'] = 980;
    t['edotaccent'] = 444;
    t['Igrave'] = 333;
    t['Imacron'] = 333;
    t['Lcaron'] = 611;
    t['onehalf'] = 750;
    t['lessequal'] = 549;
    t['ocircumflex'] = 500;
    t['ntilde'] = 500;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 611;
    t['emacron'] = 444;
    t['gbreve'] = 500;
    t['onequarter'] = 750;
    t['Scaron'] = 556;
    t['Scommaaccent'] = 556;
    t['Ohungarumlaut'] = 722;
    t['degree'] = 400;
    t['ograve'] = 500;
    t['Ccaron'] = 667;
    t['ugrave'] = 500;
    t['radical'] = 453;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 333;
    t['Ntilde'] = 722;
    t['otilde'] = 500;
    t['Rcommaaccent'] = 667;
    t['Lcommaaccent'] = 611;
    t['Atilde'] = 722;
    t['Aogonek'] = 722;
    t['Aring'] = 722;
    t['Otilde'] = 722;
    t['zdotaccent'] = 444;
    t['Ecaron'] = 611;
    t['Iogonek'] = 333;
    t['kcommaaccent'] = 500;
    t['minus'] = 564;
    t['Icircumflex'] = 333;
    t['ncaron'] = 500;
    t['tcommaaccent'] = 278;
    t['logicalnot'] = 564;
    t['odieresis'] = 500;
    t['udieresis'] = 500;
    t['notequal'] = 549;
    t['gcommaaccent'] = 500;
    t['eth'] = 500;
    t['zcaron'] = 444;
    t['ncommaaccent'] = 500;
    t['onesuperior'] = 300;
    t['imacron'] = 278;
    t['Euro'] = 500;
  });
  t['Times-Bold'] = getLookupTableFactory(function (t) {
    t['space'] = 250;
    t['exclam'] = 333;
    t['quotedbl'] = 555;
    t['numbersign'] = 500;
    t['dollar'] = 500;
    t['percent'] = 1000;
    t['ampersand'] = 833;
    t['quoteright'] = 333;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 500;
    t['plus'] = 570;
    t['comma'] = 250;
    t['hyphen'] = 333;
    t['period'] = 250;
    t['slash'] = 278;
    t['zero'] = 500;
    t['one'] = 500;
    t['two'] = 500;
    t['three'] = 500;
    t['four'] = 500;
    t['five'] = 500;
    t['six'] = 500;
    t['seven'] = 500;
    t['eight'] = 500;
    t['nine'] = 500;
    t['colon'] = 333;
    t['semicolon'] = 333;
    t['less'] = 570;
    t['equal'] = 570;
    t['greater'] = 570;
    t['question'] = 500;
    t['at'] = 930;
    t['A'] = 722;
    t['B'] = 667;
    t['C'] = 722;
    t['D'] = 722;
    t['E'] = 667;
    t['F'] = 611;
    t['G'] = 778;
    t['H'] = 778;
    t['I'] = 389;
    t['J'] = 500;
    t['K'] = 778;
    t['L'] = 667;
    t['M'] = 944;
    t['N'] = 722;
    t['O'] = 778;
    t['P'] = 611;
    t['Q'] = 778;
    t['R'] = 722;
    t['S'] = 556;
    t['T'] = 667;
    t['U'] = 722;
    t['V'] = 722;
    t['W'] = 1000;
    t['X'] = 722;
    t['Y'] = 722;
    t['Z'] = 667;
    t['bracketleft'] = 333;
    t['backslash'] = 278;
    t['bracketright'] = 333;
    t['asciicircum'] = 581;
    t['underscore'] = 500;
    t['quoteleft'] = 333;
    t['a'] = 500;
    t['b'] = 556;
    t['c'] = 444;
    t['d'] = 556;
    t['e'] = 444;
    t['f'] = 333;
    t['g'] = 500;
    t['h'] = 556;
    t['i'] = 278;
    t['j'] = 333;
    t['k'] = 556;
    t['l'] = 278;
    t['m'] = 833;
    t['n'] = 556;
    t['o'] = 500;
    t['p'] = 556;
    t['q'] = 556;
    t['r'] = 444;
    t['s'] = 389;
    t['t'] = 333;
    t['u'] = 556;
    t['v'] = 500;
    t['w'] = 722;
    t['x'] = 500;
    t['y'] = 500;
    t['z'] = 444;
    t['braceleft'] = 394;
    t['bar'] = 220;
    t['braceright'] = 394;
    t['asciitilde'] = 520;
    t['exclamdown'] = 333;
    t['cent'] = 500;
    t['sterling'] = 500;
    t['fraction'] = 167;
    t['yen'] = 500;
    t['florin'] = 500;
    t['section'] = 500;
    t['currency'] = 500;
    t['quotesingle'] = 278;
    t['quotedblleft'] = 500;
    t['guillemotleft'] = 500;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 556;
    t['fl'] = 556;
    t['endash'] = 500;
    t['dagger'] = 500;
    t['daggerdbl'] = 500;
    t['periodcentered'] = 250;
    t['paragraph'] = 540;
    t['bullet'] = 350;
    t['quotesinglbase'] = 333;
    t['quotedblbase'] = 500;
    t['quotedblright'] = 500;
    t['guillemotright'] = 500;
    t['ellipsis'] = 1000;
    t['perthousand'] = 1000;
    t['questiondown'] = 500;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 1000;
    t['AE'] = 1000;
    t['ordfeminine'] = 300;
    t['Lslash'] = 667;
    t['Oslash'] = 778;
    t['OE'] = 1000;
    t['ordmasculine'] = 330;
    t['ae'] = 722;
    t['dotlessi'] = 278;
    t['lslash'] = 278;
    t['oslash'] = 500;
    t['oe'] = 722;
    t['germandbls'] = 556;
    t['Idieresis'] = 389;
    t['eacute'] = 444;
    t['abreve'] = 500;
    t['uhungarumlaut'] = 556;
    t['ecaron'] = 444;
    t['Ydieresis'] = 722;
    t['divide'] = 570;
    t['Yacute'] = 722;
    t['Acircumflex'] = 722;
    t['aacute'] = 500;
    t['Ucircumflex'] = 722;
    t['yacute'] = 500;
    t['scommaaccent'] = 389;
    t['ecircumflex'] = 444;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 500;
    t['Uacute'] = 722;
    t['uogonek'] = 556;
    t['Edieresis'] = 667;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 747;
    t['Emacron'] = 667;
    t['ccaron'] = 444;
    t['aring'] = 500;
    t['Ncommaaccent'] = 722;
    t['lacute'] = 278;
    t['agrave'] = 500;
    t['Tcommaaccent'] = 667;
    t['Cacute'] = 722;
    t['atilde'] = 500;
    t['Edotaccent'] = 667;
    t['scaron'] = 389;
    t['scedilla'] = 389;
    t['iacute'] = 278;
    t['lozenge'] = 494;
    t['Rcaron'] = 722;
    t['Gcommaaccent'] = 778;
    t['ucircumflex'] = 556;
    t['acircumflex'] = 500;
    t['Amacron'] = 722;
    t['rcaron'] = 444;
    t['ccedilla'] = 444;
    t['Zdotaccent'] = 667;
    t['Thorn'] = 611;
    t['Omacron'] = 778;
    t['Racute'] = 722;
    t['Sacute'] = 556;
    t['dcaron'] = 672;
    t['Umacron'] = 722;
    t['uring'] = 556;
    t['threesuperior'] = 300;
    t['Ograve'] = 778;
    t['Agrave'] = 722;
    t['Abreve'] = 722;
    t['multiply'] = 570;
    t['uacute'] = 556;
    t['Tcaron'] = 667;
    t['partialdiff'] = 494;
    t['ydieresis'] = 500;
    t['Nacute'] = 722;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 667;
    t['adieresis'] = 500;
    t['edieresis'] = 444;
    t['cacute'] = 444;
    t['nacute'] = 556;
    t['umacron'] = 556;
    t['Ncaron'] = 722;
    t['Iacute'] = 389;
    t['plusminus'] = 570;
    t['brokenbar'] = 220;
    t['registered'] = 747;
    t['Gbreve'] = 778;
    t['Idotaccent'] = 389;
    t['summation'] = 600;
    t['Egrave'] = 667;
    t['racute'] = 444;
    t['omacron'] = 500;
    t['Zacute'] = 667;
    t['Zcaron'] = 667;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 722;
    t['lcommaaccent'] = 278;
    t['tcaron'] = 416;
    t['eogonek'] = 444;
    t['Uogonek'] = 722;
    t['Aacute'] = 722;
    t['Adieresis'] = 722;
    t['egrave'] = 444;
    t['zacute'] = 444;
    t['iogonek'] = 278;
    t['Oacute'] = 778;
    t['oacute'] = 500;
    t['amacron'] = 500;
    t['sacute'] = 389;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 778;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 556;
    t['twosuperior'] = 300;
    t['Odieresis'] = 778;
    t['mu'] = 556;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 500;
    t['Eogonek'] = 667;
    t['dcroat'] = 556;
    t['threequarters'] = 750;
    t['Scedilla'] = 556;
    t['lcaron'] = 394;
    t['Kcommaaccent'] = 778;
    t['Lacute'] = 667;
    t['trademark'] = 1000;
    t['edotaccent'] = 444;
    t['Igrave'] = 389;
    t['Imacron'] = 389;
    t['Lcaron'] = 667;
    t['onehalf'] = 750;
    t['lessequal'] = 549;
    t['ocircumflex'] = 500;
    t['ntilde'] = 556;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 667;
    t['emacron'] = 444;
    t['gbreve'] = 500;
    t['onequarter'] = 750;
    t['Scaron'] = 556;
    t['Scommaaccent'] = 556;
    t['Ohungarumlaut'] = 778;
    t['degree'] = 400;
    t['ograve'] = 500;
    t['Ccaron'] = 722;
    t['ugrave'] = 556;
    t['radical'] = 549;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 444;
    t['Ntilde'] = 722;
    t['otilde'] = 500;
    t['Rcommaaccent'] = 722;
    t['Lcommaaccent'] = 667;
    t['Atilde'] = 722;
    t['Aogonek'] = 722;
    t['Aring'] = 722;
    t['Otilde'] = 778;
    t['zdotaccent'] = 444;
    t['Ecaron'] = 667;
    t['Iogonek'] = 389;
    t['kcommaaccent'] = 556;
    t['minus'] = 570;
    t['Icircumflex'] = 389;
    t['ncaron'] = 556;
    t['tcommaaccent'] = 333;
    t['logicalnot'] = 570;
    t['odieresis'] = 500;
    t['udieresis'] = 556;
    t['notequal'] = 549;
    t['gcommaaccent'] = 500;
    t['eth'] = 500;
    t['zcaron'] = 444;
    t['ncommaaccent'] = 556;
    t['onesuperior'] = 300;
    t['imacron'] = 278;
    t['Euro'] = 500;
  });
  t['Times-BoldItalic'] = getLookupTableFactory(function (t) {
    t['space'] = 250;
    t['exclam'] = 389;
    t['quotedbl'] = 555;
    t['numbersign'] = 500;
    t['dollar'] = 500;
    t['percent'] = 833;
    t['ampersand'] = 778;
    t['quoteright'] = 333;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 500;
    t['plus'] = 570;
    t['comma'] = 250;
    t['hyphen'] = 333;
    t['period'] = 250;
    t['slash'] = 278;
    t['zero'] = 500;
    t['one'] = 500;
    t['two'] = 500;
    t['three'] = 500;
    t['four'] = 500;
    t['five'] = 500;
    t['six'] = 500;
    t['seven'] = 500;
    t['eight'] = 500;
    t['nine'] = 500;
    t['colon'] = 333;
    t['semicolon'] = 333;
    t['less'] = 570;
    t['equal'] = 570;
    t['greater'] = 570;
    t['question'] = 500;
    t['at'] = 832;
    t['A'] = 667;
    t['B'] = 667;
    t['C'] = 667;
    t['D'] = 722;
    t['E'] = 667;
    t['F'] = 667;
    t['G'] = 722;
    t['H'] = 778;
    t['I'] = 389;
    t['J'] = 500;
    t['K'] = 667;
    t['L'] = 611;
    t['M'] = 889;
    t['N'] = 722;
    t['O'] = 722;
    t['P'] = 611;
    t['Q'] = 722;
    t['R'] = 667;
    t['S'] = 556;
    t['T'] = 611;
    t['U'] = 722;
    t['V'] = 667;
    t['W'] = 889;
    t['X'] = 667;
    t['Y'] = 611;
    t['Z'] = 611;
    t['bracketleft'] = 333;
    t['backslash'] = 278;
    t['bracketright'] = 333;
    t['asciicircum'] = 570;
    t['underscore'] = 500;
    t['quoteleft'] = 333;
    t['a'] = 500;
    t['b'] = 500;
    t['c'] = 444;
    t['d'] = 500;
    t['e'] = 444;
    t['f'] = 333;
    t['g'] = 500;
    t['h'] = 556;
    t['i'] = 278;
    t['j'] = 278;
    t['k'] = 500;
    t['l'] = 278;
    t['m'] = 778;
    t['n'] = 556;
    t['o'] = 500;
    t['p'] = 500;
    t['q'] = 500;
    t['r'] = 389;
    t['s'] = 389;
    t['t'] = 278;
    t['u'] = 556;
    t['v'] = 444;
    t['w'] = 667;
    t['x'] = 500;
    t['y'] = 444;
    t['z'] = 389;
    t['braceleft'] = 348;
    t['bar'] = 220;
    t['braceright'] = 348;
    t['asciitilde'] = 570;
    t['exclamdown'] = 389;
    t['cent'] = 500;
    t['sterling'] = 500;
    t['fraction'] = 167;
    t['yen'] = 500;
    t['florin'] = 500;
    t['section'] = 500;
    t['currency'] = 500;
    t['quotesingle'] = 278;
    t['quotedblleft'] = 500;
    t['guillemotleft'] = 500;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 556;
    t['fl'] = 556;
    t['endash'] = 500;
    t['dagger'] = 500;
    t['daggerdbl'] = 500;
    t['periodcentered'] = 250;
    t['paragraph'] = 500;
    t['bullet'] = 350;
    t['quotesinglbase'] = 333;
    t['quotedblbase'] = 500;
    t['quotedblright'] = 500;
    t['guillemotright'] = 500;
    t['ellipsis'] = 1000;
    t['perthousand'] = 1000;
    t['questiondown'] = 500;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 1000;
    t['AE'] = 944;
    t['ordfeminine'] = 266;
    t['Lslash'] = 611;
    t['Oslash'] = 722;
    t['OE'] = 944;
    t['ordmasculine'] = 300;
    t['ae'] = 722;
    t['dotlessi'] = 278;
    t['lslash'] = 278;
    t['oslash'] = 500;
    t['oe'] = 722;
    t['germandbls'] = 500;
    t['Idieresis'] = 389;
    t['eacute'] = 444;
    t['abreve'] = 500;
    t['uhungarumlaut'] = 556;
    t['ecaron'] = 444;
    t['Ydieresis'] = 611;
    t['divide'] = 570;
    t['Yacute'] = 611;
    t['Acircumflex'] = 667;
    t['aacute'] = 500;
    t['Ucircumflex'] = 722;
    t['yacute'] = 444;
    t['scommaaccent'] = 389;
    t['ecircumflex'] = 444;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 500;
    t['Uacute'] = 722;
    t['uogonek'] = 556;
    t['Edieresis'] = 667;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 747;
    t['Emacron'] = 667;
    t['ccaron'] = 444;
    t['aring'] = 500;
    t['Ncommaaccent'] = 722;
    t['lacute'] = 278;
    t['agrave'] = 500;
    t['Tcommaaccent'] = 611;
    t['Cacute'] = 667;
    t['atilde'] = 500;
    t['Edotaccent'] = 667;
    t['scaron'] = 389;
    t['scedilla'] = 389;
    t['iacute'] = 278;
    t['lozenge'] = 494;
    t['Rcaron'] = 667;
    t['Gcommaaccent'] = 722;
    t['ucircumflex'] = 556;
    t['acircumflex'] = 500;
    t['Amacron'] = 667;
    t['rcaron'] = 389;
    t['ccedilla'] = 444;
    t['Zdotaccent'] = 611;
    t['Thorn'] = 611;
    t['Omacron'] = 722;
    t['Racute'] = 667;
    t['Sacute'] = 556;
    t['dcaron'] = 608;
    t['Umacron'] = 722;
    t['uring'] = 556;
    t['threesuperior'] = 300;
    t['Ograve'] = 722;
    t['Agrave'] = 667;
    t['Abreve'] = 667;
    t['multiply'] = 570;
    t['uacute'] = 556;
    t['Tcaron'] = 611;
    t['partialdiff'] = 494;
    t['ydieresis'] = 444;
    t['Nacute'] = 722;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 667;
    t['adieresis'] = 500;
    t['edieresis'] = 444;
    t['cacute'] = 444;
    t['nacute'] = 556;
    t['umacron'] = 556;
    t['Ncaron'] = 722;
    t['Iacute'] = 389;
    t['plusminus'] = 570;
    t['brokenbar'] = 220;
    t['registered'] = 747;
    t['Gbreve'] = 722;
    t['Idotaccent'] = 389;
    t['summation'] = 600;
    t['Egrave'] = 667;
    t['racute'] = 389;
    t['omacron'] = 500;
    t['Zacute'] = 611;
    t['Zcaron'] = 611;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 667;
    t['lcommaaccent'] = 278;
    t['tcaron'] = 366;
    t['eogonek'] = 444;
    t['Uogonek'] = 722;
    t['Aacute'] = 667;
    t['Adieresis'] = 667;
    t['egrave'] = 444;
    t['zacute'] = 389;
    t['iogonek'] = 278;
    t['Oacute'] = 722;
    t['oacute'] = 500;
    t['amacron'] = 500;
    t['sacute'] = 389;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 722;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 500;
    t['twosuperior'] = 300;
    t['Odieresis'] = 722;
    t['mu'] = 576;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 500;
    t['Eogonek'] = 667;
    t['dcroat'] = 500;
    t['threequarters'] = 750;
    t['Scedilla'] = 556;
    t['lcaron'] = 382;
    t['Kcommaaccent'] = 667;
    t['Lacute'] = 611;
    t['trademark'] = 1000;
    t['edotaccent'] = 444;
    t['Igrave'] = 389;
    t['Imacron'] = 389;
    t['Lcaron'] = 611;
    t['onehalf'] = 750;
    t['lessequal'] = 549;
    t['ocircumflex'] = 500;
    t['ntilde'] = 556;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 667;
    t['emacron'] = 444;
    t['gbreve'] = 500;
    t['onequarter'] = 750;
    t['Scaron'] = 556;
    t['Scommaaccent'] = 556;
    t['Ohungarumlaut'] = 722;
    t['degree'] = 400;
    t['ograve'] = 500;
    t['Ccaron'] = 667;
    t['ugrave'] = 556;
    t['radical'] = 549;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 389;
    t['Ntilde'] = 722;
    t['otilde'] = 500;
    t['Rcommaaccent'] = 667;
    t['Lcommaaccent'] = 611;
    t['Atilde'] = 667;
    t['Aogonek'] = 667;
    t['Aring'] = 667;
    t['Otilde'] = 722;
    t['zdotaccent'] = 389;
    t['Ecaron'] = 667;
    t['Iogonek'] = 389;
    t['kcommaaccent'] = 500;
    t['minus'] = 606;
    t['Icircumflex'] = 389;
    t['ncaron'] = 556;
    t['tcommaaccent'] = 278;
    t['logicalnot'] = 606;
    t['odieresis'] = 500;
    t['udieresis'] = 556;
    t['notequal'] = 549;
    t['gcommaaccent'] = 500;
    t['eth'] = 500;
    t['zcaron'] = 389;
    t['ncommaaccent'] = 556;
    t['onesuperior'] = 300;
    t['imacron'] = 278;
    t['Euro'] = 500;
  });
  t['Times-Italic'] = getLookupTableFactory(function (t) {
    t['space'] = 250;
    t['exclam'] = 333;
    t['quotedbl'] = 420;
    t['numbersign'] = 500;
    t['dollar'] = 500;
    t['percent'] = 833;
    t['ampersand'] = 778;
    t['quoteright'] = 333;
    t['parenleft'] = 333;
    t['parenright'] = 333;
    t['asterisk'] = 500;
    t['plus'] = 675;
    t['comma'] = 250;
    t['hyphen'] = 333;
    t['period'] = 250;
    t['slash'] = 278;
    t['zero'] = 500;
    t['one'] = 500;
    t['two'] = 500;
    t['three'] = 500;
    t['four'] = 500;
    t['five'] = 500;
    t['six'] = 500;
    t['seven'] = 500;
    t['eight'] = 500;
    t['nine'] = 500;
    t['colon'] = 333;
    t['semicolon'] = 333;
    t['less'] = 675;
    t['equal'] = 675;
    t['greater'] = 675;
    t['question'] = 500;
    t['at'] = 920;
    t['A'] = 611;
    t['B'] = 611;
    t['C'] = 667;
    t['D'] = 722;
    t['E'] = 611;
    t['F'] = 611;
    t['G'] = 722;
    t['H'] = 722;
    t['I'] = 333;
    t['J'] = 444;
    t['K'] = 667;
    t['L'] = 556;
    t['M'] = 833;
    t['N'] = 667;
    t['O'] = 722;
    t['P'] = 611;
    t['Q'] = 722;
    t['R'] = 611;
    t['S'] = 500;
    t['T'] = 556;
    t['U'] = 722;
    t['V'] = 611;
    t['W'] = 833;
    t['X'] = 611;
    t['Y'] = 556;
    t['Z'] = 556;
    t['bracketleft'] = 389;
    t['backslash'] = 278;
    t['bracketright'] = 389;
    t['asciicircum'] = 422;
    t['underscore'] = 500;
    t['quoteleft'] = 333;
    t['a'] = 500;
    t['b'] = 500;
    t['c'] = 444;
    t['d'] = 500;
    t['e'] = 444;
    t['f'] = 278;
    t['g'] = 500;
    t['h'] = 500;
    t['i'] = 278;
    t['j'] = 278;
    t['k'] = 444;
    t['l'] = 278;
    t['m'] = 722;
    t['n'] = 500;
    t['o'] = 500;
    t['p'] = 500;
    t['q'] = 500;
    t['r'] = 389;
    t['s'] = 389;
    t['t'] = 278;
    t['u'] = 500;
    t['v'] = 444;
    t['w'] = 667;
    t['x'] = 444;
    t['y'] = 444;
    t['z'] = 389;
    t['braceleft'] = 400;
    t['bar'] = 275;
    t['braceright'] = 400;
    t['asciitilde'] = 541;
    t['exclamdown'] = 389;
    t['cent'] = 500;
    t['sterling'] = 500;
    t['fraction'] = 167;
    t['yen'] = 500;
    t['florin'] = 500;
    t['section'] = 500;
    t['currency'] = 500;
    t['quotesingle'] = 214;
    t['quotedblleft'] = 556;
    t['guillemotleft'] = 500;
    t['guilsinglleft'] = 333;
    t['guilsinglright'] = 333;
    t['fi'] = 500;
    t['fl'] = 500;
    t['endash'] = 500;
    t['dagger'] = 500;
    t['daggerdbl'] = 500;
    t['periodcentered'] = 250;
    t['paragraph'] = 523;
    t['bullet'] = 350;
    t['quotesinglbase'] = 333;
    t['quotedblbase'] = 556;
    t['quotedblright'] = 556;
    t['guillemotright'] = 500;
    t['ellipsis'] = 889;
    t['perthousand'] = 1000;
    t['questiondown'] = 500;
    t['grave'] = 333;
    t['acute'] = 333;
    t['circumflex'] = 333;
    t['tilde'] = 333;
    t['macron'] = 333;
    t['breve'] = 333;
    t['dotaccent'] = 333;
    t['dieresis'] = 333;
    t['ring'] = 333;
    t['cedilla'] = 333;
    t['hungarumlaut'] = 333;
    t['ogonek'] = 333;
    t['caron'] = 333;
    t['emdash'] = 889;
    t['AE'] = 889;
    t['ordfeminine'] = 276;
    t['Lslash'] = 556;
    t['Oslash'] = 722;
    t['OE'] = 944;
    t['ordmasculine'] = 310;
    t['ae'] = 667;
    t['dotlessi'] = 278;
    t['lslash'] = 278;
    t['oslash'] = 500;
    t['oe'] = 667;
    t['germandbls'] = 500;
    t['Idieresis'] = 333;
    t['eacute'] = 444;
    t['abreve'] = 500;
    t['uhungarumlaut'] = 500;
    t['ecaron'] = 444;
    t['Ydieresis'] = 556;
    t['divide'] = 675;
    t['Yacute'] = 556;
    t['Acircumflex'] = 611;
    t['aacute'] = 500;
    t['Ucircumflex'] = 722;
    t['yacute'] = 444;
    t['scommaaccent'] = 389;
    t['ecircumflex'] = 444;
    t['Uring'] = 722;
    t['Udieresis'] = 722;
    t['aogonek'] = 500;
    t['Uacute'] = 722;
    t['uogonek'] = 500;
    t['Edieresis'] = 611;
    t['Dcroat'] = 722;
    t['commaaccent'] = 250;
    t['copyright'] = 760;
    t['Emacron'] = 611;
    t['ccaron'] = 444;
    t['aring'] = 500;
    t['Ncommaaccent'] = 667;
    t['lacute'] = 278;
    t['agrave'] = 500;
    t['Tcommaaccent'] = 556;
    t['Cacute'] = 667;
    t['atilde'] = 500;
    t['Edotaccent'] = 611;
    t['scaron'] = 389;
    t['scedilla'] = 389;
    t['iacute'] = 278;
    t['lozenge'] = 471;
    t['Rcaron'] = 611;
    t['Gcommaaccent'] = 722;
    t['ucircumflex'] = 500;
    t['acircumflex'] = 500;
    t['Amacron'] = 611;
    t['rcaron'] = 389;
    t['ccedilla'] = 444;
    t['Zdotaccent'] = 556;
    t['Thorn'] = 611;
    t['Omacron'] = 722;
    t['Racute'] = 611;
    t['Sacute'] = 500;
    t['dcaron'] = 544;
    t['Umacron'] = 722;
    t['uring'] = 500;
    t['threesuperior'] = 300;
    t['Ograve'] = 722;
    t['Agrave'] = 611;
    t['Abreve'] = 611;
    t['multiply'] = 675;
    t['uacute'] = 500;
    t['Tcaron'] = 556;
    t['partialdiff'] = 476;
    t['ydieresis'] = 444;
    t['Nacute'] = 667;
    t['icircumflex'] = 278;
    t['Ecircumflex'] = 611;
    t['adieresis'] = 500;
    t['edieresis'] = 444;
    t['cacute'] = 444;
    t['nacute'] = 500;
    t['umacron'] = 500;
    t['Ncaron'] = 667;
    t['Iacute'] = 333;
    t['plusminus'] = 675;
    t['brokenbar'] = 275;
    t['registered'] = 760;
    t['Gbreve'] = 722;
    t['Idotaccent'] = 333;
    t['summation'] = 600;
    t['Egrave'] = 611;
    t['racute'] = 389;
    t['omacron'] = 500;
    t['Zacute'] = 556;
    t['Zcaron'] = 556;
    t['greaterequal'] = 549;
    t['Eth'] = 722;
    t['Ccedilla'] = 667;
    t['lcommaaccent'] = 278;
    t['tcaron'] = 300;
    t['eogonek'] = 444;
    t['Uogonek'] = 722;
    t['Aacute'] = 611;
    t['Adieresis'] = 611;
    t['egrave'] = 444;
    t['zacute'] = 389;
    t['iogonek'] = 278;
    t['Oacute'] = 722;
    t['oacute'] = 500;
    t['amacron'] = 500;
    t['sacute'] = 389;
    t['idieresis'] = 278;
    t['Ocircumflex'] = 722;
    t['Ugrave'] = 722;
    t['Delta'] = 612;
    t['thorn'] = 500;
    t['twosuperior'] = 300;
    t['Odieresis'] = 722;
    t['mu'] = 500;
    t['igrave'] = 278;
    t['ohungarumlaut'] = 500;
    t['Eogonek'] = 611;
    t['dcroat'] = 500;
    t['threequarters'] = 750;
    t['Scedilla'] = 500;
    t['lcaron'] = 300;
    t['Kcommaaccent'] = 667;
    t['Lacute'] = 556;
    t['trademark'] = 980;
    t['edotaccent'] = 444;
    t['Igrave'] = 333;
    t['Imacron'] = 333;
    t['Lcaron'] = 611;
    t['onehalf'] = 750;
    t['lessequal'] = 549;
    t['ocircumflex'] = 500;
    t['ntilde'] = 500;
    t['Uhungarumlaut'] = 722;
    t['Eacute'] = 611;
    t['emacron'] = 444;
    t['gbreve'] = 500;
    t['onequarter'] = 750;
    t['Scaron'] = 500;
    t['Scommaaccent'] = 500;
    t['Ohungarumlaut'] = 722;
    t['degree'] = 400;
    t['ograve'] = 500;
    t['Ccaron'] = 667;
    t['ugrave'] = 500;
    t['radical'] = 453;
    t['Dcaron'] = 722;
    t['rcommaaccent'] = 389;
    t['Ntilde'] = 667;
    t['otilde'] = 500;
    t['Rcommaaccent'] = 611;
    t['Lcommaaccent'] = 556;
    t['Atilde'] = 611;
    t['Aogonek'] = 611;
    t['Aring'] = 611;
    t['Otilde'] = 722;
    t['zdotaccent'] = 389;
    t['Ecaron'] = 611;
    t['Iogonek'] = 333;
    t['kcommaaccent'] = 444;
    t['minus'] = 675;
    t['Icircumflex'] = 333;
    t['ncaron'] = 500;
    t['tcommaaccent'] = 278;
    t['logicalnot'] = 675;
    t['odieresis'] = 500;
    t['udieresis'] = 500;
    t['notequal'] = 549;
    t['gcommaaccent'] = 500;
    t['eth'] = 500;
    t['zcaron'] = 389;
    t['ncommaaccent'] = 500;
    t['onesuperior'] = 300;
    t['imacron'] = 278;
    t['Euro'] = 500;
  });
  t['ZapfDingbats'] = getLookupTableFactory(function (t) {
    t['space'] = 278;
    t['a1'] = 974;
    t['a2'] = 961;
    t['a202'] = 974;
    t['a3'] = 980;
    t['a4'] = 719;
    t['a5'] = 789;
    t['a119'] = 790;
    t['a118'] = 791;
    t['a117'] = 690;
    t['a11'] = 960;
    t['a12'] = 939;
    t['a13'] = 549;
    t['a14'] = 855;
    t['a15'] = 911;
    t['a16'] = 933;
    t['a105'] = 911;
    t['a17'] = 945;
    t['a18'] = 974;
    t['a19'] = 755;
    t['a20'] = 846;
    t['a21'] = 762;
    t['a22'] = 761;
    t['a23'] = 571;
    t['a24'] = 677;
    t['a25'] = 763;
    t['a26'] = 760;
    t['a27'] = 759;
    t['a28'] = 754;
    t['a6'] = 494;
    t['a7'] = 552;
    t['a8'] = 537;
    t['a9'] = 577;
    t['a10'] = 692;
    t['a29'] = 786;
    t['a30'] = 788;
    t['a31'] = 788;
    t['a32'] = 790;
    t['a33'] = 793;
    t['a34'] = 794;
    t['a35'] = 816;
    t['a36'] = 823;
    t['a37'] = 789;
    t['a38'] = 841;
    t['a39'] = 823;
    t['a40'] = 833;
    t['a41'] = 816;
    t['a42'] = 831;
    t['a43'] = 923;
    t['a44'] = 744;
    t['a45'] = 723;
    t['a46'] = 749;
    t['a47'] = 790;
    t['a48'] = 792;
    t['a49'] = 695;
    t['a50'] = 776;
    t['a51'] = 768;
    t['a52'] = 792;
    t['a53'] = 759;
    t['a54'] = 707;
    t['a55'] = 708;
    t['a56'] = 682;
    t['a57'] = 701;
    t['a58'] = 826;
    t['a59'] = 815;
    t['a60'] = 789;
    t['a61'] = 789;
    t['a62'] = 707;
    t['a63'] = 687;
    t['a64'] = 696;
    t['a65'] = 689;
    t['a66'] = 786;
    t['a67'] = 787;
    t['a68'] = 713;
    t['a69'] = 791;
    t['a70'] = 785;
    t['a71'] = 791;
    t['a72'] = 873;
    t['a73'] = 761;
    t['a74'] = 762;
    t['a203'] = 762;
    t['a75'] = 759;
    t['a204'] = 759;
    t['a76'] = 892;
    t['a77'] = 892;
    t['a78'] = 788;
    t['a79'] = 784;
    t['a81'] = 438;
    t['a82'] = 138;
    t['a83'] = 277;
    t['a84'] = 415;
    t['a97'] = 392;
    t['a98'] = 392;
    t['a99'] = 668;
    t['a100'] = 668;
    t['a89'] = 390;
    t['a90'] = 390;
    t['a93'] = 317;
    t['a94'] = 317;
    t['a91'] = 276;
    t['a92'] = 276;
    t['a205'] = 509;
    t['a85'] = 509;
    t['a206'] = 410;
    t['a86'] = 410;
    t['a87'] = 234;
    t['a88'] = 234;
    t['a95'] = 334;
    t['a96'] = 334;
    t['a101'] = 732;
    t['a102'] = 544;
    t['a103'] = 544;
    t['a104'] = 910;
    t['a106'] = 667;
    t['a107'] = 760;
    t['a108'] = 760;
    t['a112'] = 776;
    t['a111'] = 595;
    t['a110'] = 694;
    t['a109'] = 626;
    t['a120'] = 788;
    t['a121'] = 788;
    t['a122'] = 788;
    t['a123'] = 788;
    t['a124'] = 788;
    t['a125'] = 788;
    t['a126'] = 788;
    t['a127'] = 788;
    t['a128'] = 788;
    t['a129'] = 788;
    t['a130'] = 788;
    t['a131'] = 788;
    t['a132'] = 788;
    t['a133'] = 788;
    t['a134'] = 788;
    t['a135'] = 788;
    t['a136'] = 788;
    t['a137'] = 788;
    t['a138'] = 788;
    t['a139'] = 788;
    t['a140'] = 788;
    t['a141'] = 788;
    t['a142'] = 788;
    t['a143'] = 788;
    t['a144'] = 788;
    t['a145'] = 788;
    t['a146'] = 788;
    t['a147'] = 788;
    t['a148'] = 788;
    t['a149'] = 788;
    t['a150'] = 788;
    t['a151'] = 788;
    t['a152'] = 788;
    t['a153'] = 788;
    t['a154'] = 788;
    t['a155'] = 788;
    t['a156'] = 788;
    t['a157'] = 788;
    t['a158'] = 788;
    t['a159'] = 788;
    t['a160'] = 894;
    t['a161'] = 838;
    t['a163'] = 1016;
    t['a164'] = 458;
    t['a196'] = 748;
    t['a165'] = 924;
    t['a192'] = 748;
    t['a166'] = 918;
    t['a167'] = 927;
    t['a168'] = 928;
    t['a169'] = 928;
    t['a170'] = 834;
    t['a171'] = 873;
    t['a172'] = 828;
    t['a173'] = 924;
    t['a162'] = 924;
    t['a174'] = 917;
    t['a175'] = 930;
    t['a176'] = 931;
    t['a177'] = 463;
    t['a178'] = 883;
    t['a179'] = 836;
    t['a193'] = 836;
    t['a180'] = 867;
    t['a199'] = 867;
    t['a181'] = 696;
    t['a200'] = 696;
    t['a182'] = 874;
    t['a201'] = 874;
    t['a183'] = 760;
    t['a184'] = 946;
    t['a197'] = 771;
    t['a185'] = 865;
    t['a194'] = 771;
    t['a198'] = 888;
    t['a186'] = 967;
    t['a195'] = 888;
    t['a187'] = 831;
    t['a188'] = 873;
    t['a189'] = 927;
    t['a190'] = 970;
    t['a191'] = 918;
  });
});

exports.getMetrics = getMetrics;
}));



(function (root, factory) {
  {
    factory((root.pdfjsCoreMurmurHash3 = {}), root.pdfjsSharedUtil);
  }
}(this, function (exports, sharedUtil) {

var Uint32ArrayView = sharedUtil.Uint32ArrayView;

var MurmurHash3_64 = (function MurmurHash3_64Closure (seed) {
  // Workaround for missing math precision in JS.
  var MASK_HIGH = 0xffff0000;
  var MASK_LOW = 0xffff;

  function MurmurHash3_64 (seed) {
    var SEED = 0xc3d2e1f0;
    this.h1 = seed ? seed & 0xffffffff : SEED;
    this.h2 = seed ? seed & 0xffffffff : SEED;
  }

  var alwaysUseUint32ArrayView = false;
  // old webkits have issues with non-aligned arrays
  try {
    new Uint32Array(new Uint8Array(5).buffer, 0, 1);
  } catch (e) {
    alwaysUseUint32ArrayView = true;
  }

  MurmurHash3_64.prototype = {
    update: function MurmurHash3_64_update(input) {
      var useUint32ArrayView = alwaysUseUint32ArrayView;
      var i;
      if (typeof input === 'string') {
        var data = new Uint8Array(input.length * 2);
        var length = 0;
        for (i = 0; i < input.length; i++) {
          var code = input.charCodeAt(i);
          if (code <= 0xff) {
            data[length++] = code;
          }
          else {
            data[length++] = code >>> 8;
            data[length++] = code & 0xff;
          }
        }
      } else if (input instanceof Uint8Array) {
        data = input;
        length = data.length;
      } else if (typeof input === 'object' && ('length' in input)) {
        // processing regular arrays as well, e.g. for IE9
        data = input;
        length = data.length;
        useUint32ArrayView = true;
      } else {
        throw new Error('Wrong data format in MurmurHash3_64_update. ' +
                        'Input must be a string or array.');
      }

      var blockCounts = length >> 2;
      var tailLength = length - blockCounts * 4;
      // we don't care about endianness here
      var dataUint32 = useUint32ArrayView ?
        new Uint32ArrayView(data, blockCounts) :
        new Uint32Array(data.buffer, 0, blockCounts);
      var k1 = 0;
      var k2 = 0;
      var h1 = this.h1;
      var h2 = this.h2;
      var C1 = 0xcc9e2d51;
      var C2 = 0x1b873593;
      var C1_LOW = C1 & MASK_LOW;
      var C2_LOW = C2 & MASK_LOW;

      for (i = 0; i < blockCounts; i++) {
        if (i & 1) {
          k1 = dataUint32[i];
          k1 = (k1 * C1 & MASK_HIGH) | (k1 * C1_LOW & MASK_LOW);
          k1 = k1 << 15 | k1 >>> 17;
          k1 = (k1 * C2 & MASK_HIGH) | (k1 * C2_LOW & MASK_LOW);
          h1 ^= k1;
          h1 = h1 << 13 | h1 >>> 19;
          h1 = h1 * 5 + 0xe6546b64;
        } else {
          k2 = dataUint32[i];
          k2 = (k2 * C1 & MASK_HIGH) | (k2 * C1_LOW & MASK_LOW);
          k2 = k2 << 15 | k2 >>> 17;
          k2 = (k2 * C2 & MASK_HIGH) | (k2 * C2_LOW & MASK_LOW);
          h2 ^= k2;
          h2 = h2 << 13 | h2 >>> 19;
          h2 = h2 * 5 + 0xe6546b64;
        }
      }

      k1 = 0;

      switch (tailLength) {
        case 3:
          k1 ^= data[blockCounts * 4 + 2] << 16;
          /* falls through */
        case 2:
          k1 ^= data[blockCounts * 4 + 1] << 8;
          /* falls through */
        case 1:
          k1 ^= data[blockCounts * 4];
          /* falls through */
        k1 = (k1 * C1 & MASK_HIGH) | (k1 * C1_LOW & MASK_LOW);
        k1 = k1 << 15 | k1 >>> 17;
        k1 = (k1 * C2 & MASK_HIGH) | (k1 * C2_LOW & MASK_LOW);
        if (blockCounts & 1) {
          h1 ^= k1;
        } else {
          h2 ^= k1;
        }
      }

      this.h1 = h1;
      this.h2 = h2;
      return this;
    },

    hexdigest: function MurmurHash3_64_hexdigest () {
      var h1 = this.h1;
      var h2 = this.h2;

      h1 ^= h2 >>> 1;
      h1 = (h1 * 0xed558ccd & MASK_HIGH) | (h1 * 0x8ccd & MASK_LOW);
      h2 = (h2 * 0xff51afd7 & MASK_HIGH) |
           (((h2 << 16 | h1 >>> 16) * 0xafd7ed55 & MASK_HIGH) >>> 16);
      h1 ^= h2 >>> 1;
      h1 = (h1 * 0x1a85ec53 & MASK_HIGH) | (h1 * 0xec53 & MASK_LOW);
      h2 = (h2 * 0xc4ceb9fe & MASK_HIGH) |
           (((h2 << 16 | h1 >>> 16) * 0xb9fe1a85 & MASK_HIGH) >>> 16);
      h1 ^= h2 >>> 1;

      for (var i = 0, arr = [h1, h2], str = ''; i < arr.length; i++) {
        var hex = (arr[i] >>> 0).toString(16);
        while (hex.length < 8) {
          hex = '0' + hex;
        }
        str += hex;
      }

      return str;
    }
  };

  return MurmurHash3_64;
})();

exports.MurmurHash3_64 = MurmurHash3_64;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCorePrimitives = {}), root.pdfjsSharedUtil);
  }
}(this, function (exports, sharedUtil) {

var isArray = sharedUtil.isArray;

var Name = (function NameClosure() {
  function Name(name) {
    this.name = name;
  }

  Name.prototype = {};

  var nameCache = Object.create(null);

  Name.get = function Name_get(name) {
    var nameValue = nameCache[name];
    return (nameValue ? nameValue : (nameCache[name] = new Name(name)));
  };

  return Name;
})();

var Cmd = (function CmdClosure() {
  function Cmd(cmd) {
    this.cmd = cmd;
  }

  Cmd.prototype = {};

  var cmdCache = Object.create(null);

  Cmd.get = function Cmd_get(cmd) {
    var cmdValue = cmdCache[cmd];
    return (cmdValue ? cmdValue : (cmdCache[cmd] = new Cmd(cmd)));
  };

  return Cmd;
})();

var Dict = (function DictClosure() {
  var nonSerializable = function nonSerializableClosure() {
    return nonSerializable; // creating closure on some variable
  };

  // xref is optional
  function Dict(xref) {
    // Map should only be used internally, use functions below to access.
    this.map = Object.create(null);
    this.xref = xref;
    this.objId = null;
    this.__nonSerializable__ = nonSerializable; // disable cloning of the Dict
  }

  Dict.prototype = {
    assignXref: function Dict_assignXref(newXref) {
      this.xref = newXref;
    },

    // automatically dereferences Ref objects
    get: function Dict_get(key1, key2, key3) {
      var value;
      var xref = this.xref;
      if (typeof (value = this.map[key1]) !== 'undefined' || key1 in this.map ||
          typeof key2 === 'undefined') {
        return xref ? xref.fetchIfRef(value) : value;
      }
      if (typeof (value = this.map[key2]) !== 'undefined' || key2 in this.map ||
          typeof key3 === 'undefined') {
        return xref ? xref.fetchIfRef(value) : value;
      }
      value = this.map[key3] || null;
      return xref ? xref.fetchIfRef(value) : value;
    },

    // Same as get(), but returns a promise and uses fetchIfRefAsync().
    getAsync: function Dict_getAsync(key1, key2, key3) {
      var value;
      var xref = this.xref;
      if (typeof (value = this.map[key1]) !== 'undefined' || key1 in this.map ||
          typeof key2 === 'undefined') {
        if (xref) {
          return xref.fetchIfRefAsync(value);
        }
        return Promise.resolve(value);
      }
      if (typeof (value = this.map[key2]) !== 'undefined' || key2 in this.map ||
          typeof key3 === 'undefined') {
        if (xref) {
          return xref.fetchIfRefAsync(value);
        }
        return Promise.resolve(value);
      }
      value = this.map[key3] || null;
      if (xref) {
        return xref.fetchIfRefAsync(value);
      }
      return Promise.resolve(value);
    },

    // Same as get(), but dereferences all elements if the result is an Array.
    getArray: function Dict_getArray(key1, key2, key3) {
      var value = this.get(key1, key2, key3);
      var xref = this.xref;
      if (!isArray(value) || !xref) {
        return value;
      }
      value = value.slice(); // Ensure that we don't modify the Dict data.
      for (var i = 0, ii = value.length; i < ii; i++) {
        if (!isRef(value[i])) {
          continue;
        }
        value[i] = xref.fetch(value[i]);
      }
      return value;
    },

    // no dereferencing
    getRaw: function Dict_getRaw(key) {
      return this.map[key];
    },

    getKeys: function Dict_getKeys() {
      return Object.keys(this.map);
    },

    set: function Dict_set(key, value) {
      this.map[key] = value;
    },

    has: function Dict_has(key) {
      return key in this.map;
    },

    forEach: function Dict_forEach(callback) {
      for (var key in this.map) {
        callback(key, this.get(key));
      }
    }
  };

  Dict.empty = new Dict(null);

  Dict.merge = function Dict_merge(xref, dictArray) {
    var mergedDict = new Dict(xref);

    for (var i = 0, ii = dictArray.length; i < ii; i++) {
      var dict = dictArray[i];
      if (!isDict(dict)) {
        continue;
      }
      for (var keyName in dict.map) {
        if (mergedDict.map[keyName]) {
          continue;
        }
        mergedDict.map[keyName] = dict.map[keyName];
      }
    }
    return mergedDict;
  };

  return Dict;
})();

var Ref = (function RefClosure() {
  function Ref(num, gen) {
    this.num = num;
    this.gen = gen;
  }

  Ref.prototype = {
    toString: function Ref_toString() {
      // This function is hot, so we make the string as compact as possible.
      // |this.gen| is almost always zero, so we treat that case specially.
      var str = this.num + 'R';
      if (this.gen !== 0) {
        str += this.gen;
      }
      return str;
    }
  };

  return Ref;
})();

// The reference is identified by number and generation.
// This structure stores only one instance of the reference.
var RefSet = (function RefSetClosure() {
  function RefSet() {
    this.dict = Object.create(null);
  }

  RefSet.prototype = {
    has: function RefSet_has(ref) {
      return ref.toString() in this.dict;
    },

    put: function RefSet_put(ref) {
      this.dict[ref.toString()] = true;
    },

    remove: function RefSet_remove(ref) {
      delete this.dict[ref.toString()];
    }
  };

  return RefSet;
})();

var RefSetCache = (function RefSetCacheClosure() {
  function RefSetCache() {
    this.dict = Object.create(null);
  }

  RefSetCache.prototype = {
    get: function RefSetCache_get(ref) {
      return this.dict[ref.toString()];
    },

    has: function RefSetCache_has(ref) {
      return ref.toString() in this.dict;
    },

    put: function RefSetCache_put(ref, obj) {
      this.dict[ref.toString()] = obj;
    },

    putAlias: function RefSetCache_putAlias(ref, aliasRef) {
      this.dict[ref.toString()] = this.get(aliasRef);
    },

    forEach: function RefSetCache_forEach(fn, thisArg) {
      for (var i in this.dict) {
        fn.call(thisArg, this.dict[i]);
      }
    },

    clear: function RefSetCache_clear() {
      this.dict = Object.create(null);
    }
  };

  return RefSetCache;
})();

function isName(v, name) {
  return v instanceof Name && (name === undefined || v.name === name);
}

function isCmd(v, cmd) {
  return v instanceof Cmd && (cmd === undefined || v.cmd === cmd);
}

function isDict(v, type) {
  return v instanceof Dict &&
         (type === undefined || isName(v.get('Type'), type));
}

function isRef(v) {
  return v instanceof Ref;
}

function isRefsEqual(v1, v2) {
  return v1.num === v2.num && v1.gen === v2.gen;
}

function isStream(v) {
  return typeof v === 'object' && v !== null && v.getBytes !== undefined;
}

exports.Cmd = Cmd;
exports.Dict = Dict;
exports.Name = Name;
exports.Ref = Ref;
exports.RefSet = RefSet;
exports.RefSetCache = RefSetCache;
exports.isCmd = isCmd;
exports.isDict = isDict;
exports.isName = isName;
exports.isRef = isRef;
exports.isRefsEqual = isRefsEqual;
exports.isStream = isStream;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreStandardFonts = {}), root.pdfjsSharedUtil);
  }
}(this, function (exports, sharedUtil) {
  var getLookupTableFactory = sharedUtil.getLookupTableFactory;

  /**
   * Hold a map of decoded fonts and of the standard fourteen Type1
   * fonts and their acronyms.
   */
  var getStdFontMap = getLookupTableFactory(function (t) {
    t['ArialNarrow'] = 'Helvetica';
    t['ArialNarrow-Bold'] = 'Helvetica-Bold';
    t['ArialNarrow-BoldItalic'] = 'Helvetica-BoldOblique';
    t['ArialNarrow-Italic'] = 'Helvetica-Oblique';
    t['ArialBlack'] = 'Helvetica';
    t['ArialBlack-Bold'] = 'Helvetica-Bold';
    t['ArialBlack-BoldItalic'] = 'Helvetica-BoldOblique';
    t['ArialBlack-Italic'] = 'Helvetica-Oblique';
    t['Arial'] = 'Helvetica';
    t['Arial-Bold'] = 'Helvetica-Bold';
    t['Arial-BoldItalic'] = 'Helvetica-BoldOblique';
    t['Arial-Italic'] = 'Helvetica-Oblique';
    t['Arial-BoldItalicMT'] = 'Helvetica-BoldOblique';
    t['Arial-BoldMT'] = 'Helvetica-Bold';
    t['Arial-ItalicMT'] = 'Helvetica-Oblique';
    t['ArialMT'] = 'Helvetica';
    t['Courier-Bold'] = 'Courier-Bold';
    t['Courier-BoldItalic'] = 'Courier-BoldOblique';
    t['Courier-Italic'] = 'Courier-Oblique';
    t['CourierNew'] = 'Courier';
    t['CourierNew-Bold'] = 'Courier-Bold';
    t['CourierNew-BoldItalic'] = 'Courier-BoldOblique';
    t['CourierNew-Italic'] = 'Courier-Oblique';
    t['CourierNewPS-BoldItalicMT'] = 'Courier-BoldOblique';
    t['CourierNewPS-BoldMT'] = 'Courier-Bold';
    t['CourierNewPS-ItalicMT'] = 'Courier-Oblique';
    t['CourierNewPSMT'] = 'Courier';
    t['Helvetica'] = 'Helvetica';
    t['Helvetica-Bold'] = 'Helvetica-Bold';
    t['Helvetica-BoldItalic'] = 'Helvetica-BoldOblique';
    t['Helvetica-BoldOblique'] = 'Helvetica-BoldOblique';
    t['Helvetica-Italic'] = 'Helvetica-Oblique';
    t['Helvetica-Oblique'] = 'Helvetica-Oblique';
    t['Symbol-Bold'] = 'Symbol';
    t['Symbol-BoldItalic'] = 'Symbol';
    t['Symbol-Italic'] = 'Symbol';
    t['TimesNewRoman'] = 'Times-Roman';
    t['TimesNewRoman-Bold'] = 'Times-Bold';
    t['TimesNewRoman-BoldItalic'] = 'Times-BoldItalic';
    t['TimesNewRoman-Italic'] = 'Times-Italic';
    t['TimesNewRomanPS'] = 'Times-Roman';
    t['TimesNewRomanPS-Bold'] = 'Times-Bold';
    t['TimesNewRomanPS-BoldItalic'] = 'Times-BoldItalic';
    t['TimesNewRomanPS-BoldItalicMT'] = 'Times-BoldItalic';
    t['TimesNewRomanPS-BoldMT'] = 'Times-Bold';
    t['TimesNewRomanPS-Italic'] = 'Times-Italic';
    t['TimesNewRomanPS-ItalicMT'] = 'Times-Italic';
    t['TimesNewRomanPSMT'] = 'Times-Roman';
    t['TimesNewRomanPSMT-Bold'] = 'Times-Bold';
    t['TimesNewRomanPSMT-BoldItalic'] = 'Times-BoldItalic';
    t['TimesNewRomanPSMT-Italic'] = 'Times-Italic';
  });

  /**
   * Holds the map of the non-standard fonts that might be included as
   * a standard fonts without glyph data.
   */
  var getNonStdFontMap = getLookupTableFactory(function (t) {
    t['CenturyGothic'] = 'Helvetica';
    t['CenturyGothic-Bold'] = 'Helvetica-Bold';
    t['CenturyGothic-BoldItalic'] = 'Helvetica-BoldOblique';
    t['CenturyGothic-Italic'] = 'Helvetica-Oblique';
    t['ComicSansMS'] = 'Comic Sans MS';
    t['ComicSansMS-Bold'] = 'Comic Sans MS-Bold';
    t['ComicSansMS-BoldItalic'] = 'Comic Sans MS-BoldItalic';
    t['ComicSansMS-Italic'] = 'Comic Sans MS-Italic';
    t['LucidaConsole'] = 'Courier';
    t['LucidaConsole-Bold'] = 'Courier-Bold';
    t['LucidaConsole-BoldItalic'] = 'Courier-BoldOblique';
    t['LucidaConsole-Italic'] = 'Courier-Oblique';
    t['MS-Gothic'] = 'MS Gothic';
    t['MS-Gothic-Bold'] = 'MS Gothic-Bold';
    t['MS-Gothic-BoldItalic'] = 'MS Gothic-BoldItalic';
    t['MS-Gothic-Italic'] = 'MS Gothic-Italic';
    t['MS-Mincho'] = 'MS Mincho';
    t['MS-Mincho-Bold'] = 'MS Mincho-Bold';
    t['MS-Mincho-BoldItalic'] = 'MS Mincho-BoldItalic';
    t['MS-Mincho-Italic'] = 'MS Mincho-Italic';
    t['MS-PGothic'] = 'MS PGothic';
    t['MS-PGothic-Bold'] = 'MS PGothic-Bold';
    t['MS-PGothic-BoldItalic'] = 'MS PGothic-BoldItalic';
    t['MS-PGothic-Italic'] = 'MS PGothic-Italic';
    t['MS-PMincho'] = 'MS PMincho';
    t['MS-PMincho-Bold'] = 'MS PMincho-Bold';
    t['MS-PMincho-BoldItalic'] = 'MS PMincho-BoldItalic';
    t['MS-PMincho-Italic'] = 'MS PMincho-Italic';
    t['Wingdings'] = 'ZapfDingbats';
  });

  var getSerifFonts = getLookupTableFactory(function (t) {
    t['Adobe Jenson'] = true;
    t['Adobe Text'] = true;
    t['Albertus'] = true;
    t['Aldus'] = true;
    t['Alexandria'] = true;
    t['Algerian'] = true;
    t['American Typewriter'] = true;
    t['Antiqua'] = true;
    t['Apex'] = true;
    t['Arno'] = true;
    t['Aster'] = true;
    t['Aurora'] = true;
    t['Baskerville'] = true;
    t['Bell'] = true;
    t['Bembo'] = true;
    t['Bembo Schoolbook'] = true;
    t['Benguiat'] = true;
    t['Berkeley Old Style'] = true;
    t['Bernhard Modern'] = true;
    t['Berthold City'] = true;
    t['Bodoni'] = true;
    t['Bauer Bodoni'] = true;
    t['Book Antiqua'] = true;
    t['Bookman'] = true;
    t['Bordeaux Roman'] = true;
    t['Californian FB'] = true;
    t['Calisto'] = true;
    t['Calvert'] = true;
    t['Capitals'] = true;
    t['Cambria'] = true;
    t['Cartier'] = true;
    t['Caslon'] = true;
    t['Catull'] = true;
    t['Centaur'] = true;
    t['Century Old Style'] = true;
    t['Century Schoolbook'] = true;
    t['Chaparral'] = true;
    t['Charis SIL'] = true;
    t['Cheltenham'] = true;
    t['Cholla Slab'] = true;
    t['Clarendon'] = true;
    t['Clearface'] = true;
    t['Cochin'] = true;
    t['Colonna'] = true;
    t['Computer Modern'] = true;
    t['Concrete Roman'] = true;
    t['Constantia'] = true;
    t['Cooper Black'] = true;
    t['Corona'] = true;
    t['Ecotype'] = true;
    t['Egyptienne'] = true;
    t['Elephant'] = true;
    t['Excelsior'] = true;
    t['Fairfield'] = true;
    t['FF Scala'] = true;
    t['Folkard'] = true;
    t['Footlight'] = true;
    t['FreeSerif'] = true;
    t['Friz Quadrata'] = true;
    t['Garamond'] = true;
    t['Gentium'] = true;
    t['Georgia'] = true;
    t['Gloucester'] = true;
    t['Goudy Old Style'] = true;
    t['Goudy Schoolbook'] = true;
    t['Goudy Pro Font'] = true;
    t['Granjon'] = true;
    t['Guardian Egyptian'] = true;
    t['Heather'] = true;
    t['Hercules'] = true;
    t['High Tower Text'] = true;
    t['Hiroshige'] = true;
    t['Hoefler Text'] = true;
    t['Humana Serif'] = true;
    t['Imprint'] = true;
    t['Ionic No. 5'] = true;
    t['Janson'] = true;
    t['Joanna'] = true;
    t['Korinna'] = true;
    t['Lexicon'] = true;
    t['Liberation Serif'] = true;
    t['Linux Libertine'] = true;
    t['Literaturnaya'] = true;
    t['Lucida'] = true;
    t['Lucida Bright'] = true;
    t['Melior'] = true;
    t['Memphis'] = true;
    t['Miller'] = true;
    t['Minion'] = true;
    t['Modern'] = true;
    t['Mona Lisa'] = true;
    t['Mrs Eaves'] = true;
    t['MS Serif'] = true;
    t['Museo Slab'] = true;
    t['New York'] = true;
    t['Nimbus Roman'] = true;
    t['NPS Rawlinson Roadway'] = true;
    t['Palatino'] = true;
    t['Perpetua'] = true;
    t['Plantin'] = true;
    t['Plantin Schoolbook'] = true;
    t['Playbill'] = true;
    t['Poor Richard'] = true;
    t['Rawlinson Roadway'] = true;
    t['Renault'] = true;
    t['Requiem'] = true;
    t['Rockwell'] = true;
    t['Roman'] = true;
    t['Rotis Serif'] = true;
    t['Sabon'] = true;
    t['Scala'] = true;
    t['Seagull'] = true;
    t['Sistina'] = true;
    t['Souvenir'] = true;
    t['STIX'] = true;
    t['Stone Informal'] = true;
    t['Stone Serif'] = true;
    t['Sylfaen'] = true;
    t['Times'] = true;
    t['Trajan'] = true;
    t['Trinité'] = true;
    t['Trump Mediaeval'] = true;
    t['Utopia'] = true;
    t['Vale Type'] = true;
    t['Bitstream Vera'] = true;
    t['Vera Serif'] = true;
    t['Versailles'] = true;
    t['Wanted'] = true;
    t['Weiss'] = true;
    t['Wide Latin'] = true;
    t['Windsor'] = true;
    t['XITS'] = true;
  });

  var getSymbolsFonts = getLookupTableFactory(function (t) {
    t['Dingbats'] = true;
    t['Symbol'] = true;
    t['ZapfDingbats'] = true;
  });

  // Glyph map for well-known standard fonts. Sometimes Ghostscript uses CID
  // fonts, but does not embed the CID to GID mapping. The mapping is incomplete
  // for all glyphs, but common for some set of the standard fonts.
  var getGlyphMapForStandardFonts = getLookupTableFactory(function (t) {
    t[2] = 10; t[3] = 32; t[4] = 33; t[5] = 34; t[6] = 35; t[7] = 36; t[8] = 37;
    t[9] = 38; t[10] = 39; t[11] = 40; t[12] = 41; t[13] = 42; t[14] = 43;
    t[15] = 44; t[16] = 45; t[17] = 46; t[18] = 47; t[19] = 48; t[20] = 49;
    t[21] = 50; t[22] = 51; t[23] = 52; t[24] = 53; t[25] = 54; t[26] = 55;
    t[27] = 56; t[28] = 57; t[29] = 58; t[30] = 894; t[31] = 60; t[32] = 61;
    t[33] = 62; t[34] = 63; t[35] = 64; t[36] = 65; t[37] = 66; t[38] = 67;
    t[39] = 68; t[40] = 69; t[41] = 70; t[42] = 71; t[43] = 72; t[44] = 73;
    t[45] = 74; t[46] = 75; t[47] = 76; t[48] = 77; t[49] = 78; t[50] = 79;
    t[51] = 80; t[52] = 81; t[53] = 82; t[54] = 83; t[55] = 84; t[56] = 85;
    t[57] = 86; t[58] = 87; t[59] = 88; t[60] = 89; t[61] = 90; t[62] = 91;
    t[63] = 92; t[64] = 93; t[65] = 94; t[66] = 95; t[67] = 96; t[68] = 97;
    t[69] = 98; t[70] = 99; t[71] = 100; t[72] = 101; t[73] = 102; t[74] = 103;
    t[75] = 104; t[76] = 105; t[77] = 106; t[78] = 107; t[79] = 108;
    t[80] = 109; t[81] = 110; t[82] = 111; t[83] = 112; t[84] = 113;
    t[85] = 114; t[86] = 115; t[87] = 116; t[88] = 117; t[89] = 118;
    t[90] = 119; t[91] = 120; t[92] = 121; t[93] = 122; t[94] = 123;
    t[95] = 124; t[96] = 125; t[97] = 126; t[98] = 196; t[99] = 197;
    t[100] = 199; t[101] = 201; t[102] = 209; t[103] = 214; t[104] = 220;
    t[105] = 225; t[106] = 224; t[107] = 226; t[108] = 228; t[109] = 227;
    t[110] = 229; t[111] = 231; t[112] = 233; t[113] = 232; t[114] = 234;
    t[115] = 235; t[116] = 237; t[117] = 236; t[118] = 238; t[119] = 239;
    t[120] = 241; t[121] = 243; t[122] = 242; t[123] = 244; t[124] = 246;
    t[125] = 245; t[126] = 250; t[127] = 249; t[128] = 251; t[129] = 252;
    t[130] = 8224; t[131] = 176; t[132] = 162; t[133] = 163; t[134] = 167;
    t[135] = 8226; t[136] = 182; t[137] = 223; t[138] = 174; t[139] = 169;
    t[140] = 8482; t[141] = 180; t[142] = 168; t[143] = 8800; t[144] = 198;
    t[145] = 216; t[146] = 8734; t[147] = 177; t[148] = 8804; t[149] = 8805;
    t[150] = 165; t[151] = 181; t[152] = 8706; t[153] = 8721; t[154] = 8719;
    t[156] = 8747; t[157] = 170; t[158] = 186; t[159] = 8486; t[160] = 230;
    t[161] = 248; t[162] = 191; t[163] = 161; t[164] = 172; t[165] = 8730;
    t[166] = 402; t[167] = 8776; t[168] = 8710; t[169] = 171; t[170] = 187;
    t[171] = 8230; t[210] = 218; t[223] = 711; t[224] = 321; t[225] = 322;
    t[227] = 353; t[229] = 382; t[234] = 253; t[252] = 263; t[253] = 268;
    t[254] = 269; t[258] = 258; t[260] = 260; t[261] = 261; t[265] = 280;
    t[266] = 281; t[268] = 283; t[269] = 313; t[275] = 323; t[276] = 324;
    t[278] = 328; t[284] = 345; t[285] = 346; t[286] = 347; t[292] = 367;
    t[295] = 377; t[296] = 378; t[298] = 380; t[305] = 963; t[306] = 964;
    t[307] = 966; t[308] = 8215; t[309] = 8252; t[310] = 8319; t[311] = 8359;
    t[312] = 8592; t[313] = 8593; t[337] = 9552; t[493] = 1039;
    t[494] = 1040; t[705] = 1524; t[706] = 8362; t[710] = 64288; t[711] = 64298;
    t[759] = 1617; t[761] = 1776; t[763] = 1778; t[775] = 1652; t[777] = 1764;
    t[778] = 1780; t[779] = 1781; t[780] = 1782; t[782] = 771; t[783] = 64726;
    t[786] = 8363; t[788] = 8532; t[790] = 768; t[791] = 769; t[792] = 768;
    t[795] = 803; t[797] = 64336; t[798] = 64337; t[799] = 64342;
    t[800] = 64343; t[801] = 64344; t[802] = 64345; t[803] = 64362;
    t[804] = 64363; t[805] = 64364; t[2424] = 7821; t[2425] = 7822;
    t[2426] = 7823; t[2427] = 7824; t[2428] = 7825; t[2429] = 7826;
    t[2430] = 7827; t[2433] = 7682; t[2678] = 8045; t[2679] = 8046;
    t[2830] = 1552; t[2838] = 686; t[2840] = 751; t[2842] = 753; t[2843] = 754;
    t[2844] = 755; t[2846] = 757; t[2856] = 767; t[2857] = 848; t[2858] = 849;
    t[2862] = 853; t[2863] = 854; t[2864] = 855; t[2865] = 861; t[2866] = 862;
    t[2906] = 7460; t[2908] = 7462; t[2909] = 7463; t[2910] = 7464;
    t[2912] = 7466; t[2913] = 7467; t[2914] = 7468; t[2916] = 7470;
    t[2917] = 7471; t[2918] = 7472; t[2920] = 7474; t[2921] = 7475;
    t[2922] = 7476; t[2924] = 7478; t[2925] = 7479; t[2926] = 7480;
    t[2928] = 7482; t[2929] = 7483; t[2930] = 7484; t[2932] = 7486;
    t[2933] = 7487; t[2934] = 7488; t[2936] = 7490; t[2937] = 7491;
    t[2938] = 7492; t[2940] = 7494; t[2941] = 7495; t[2942] = 7496;
    t[2944] = 7498; t[2946] = 7500; t[2948] = 7502; t[2950] = 7504;
    t[2951] = 7505; t[2952] = 7506; t[2954] = 7508; t[2955] = 7509;
    t[2956] = 7510; t[2958] = 7512; t[2959] = 7513; t[2960] = 7514;
    t[2962] = 7516; t[2963] = 7517; t[2964] = 7518; t[2966] = 7520;
    t[2967] = 7521; t[2968] = 7522; t[2970] = 7524; t[2971] = 7525;
    t[2972] = 7526; t[2974] = 7528; t[2975] = 7529; t[2976] = 7530;
    t[2978] = 1537; t[2979] = 1538; t[2980] = 1539; t[2982] = 1549;
    t[2983] = 1551; t[2984] = 1552; t[2986] = 1554; t[2987] = 1555;
    t[2988] = 1556; t[2990] = 1623; t[2991] = 1624; t[2995] = 1775;
    t[2999] = 1791; t[3002] = 64290; t[3003] = 64291; t[3004] = 64292;
    t[3006] = 64294; t[3007] = 64295; t[3008] = 64296; t[3011] = 1900;
    t[3014] = 8223; t[3015] = 8244; t[3017] = 7532; t[3018] = 7533;
    t[3019] = 7534; t[3075] = 7590; t[3076] = 7591; t[3079] = 7594;
    t[3080] = 7595; t[3083] = 7598; t[3084] = 7599; t[3087] = 7602;
    t[3088] = 7603; t[3091] = 7606; t[3092] = 7607; t[3095] = 7610;
    t[3096] = 7611; t[3099] = 7614; t[3100] = 7615; t[3103] = 7618;
    t[3104] = 7619; t[3107] = 8337; t[3108] = 8338; t[3116] = 1884;
    t[3119] = 1885; t[3120] = 1885; t[3123] = 1886; t[3124] = 1886;
    t[3127] = 1887; t[3128] = 1887; t[3131] = 1888; t[3132] = 1888;
    t[3135] = 1889; t[3136] = 1889; t[3139] = 1890; t[3140] = 1890;
    t[3143] = 1891; t[3144] = 1891; t[3147] = 1892; t[3148] = 1892;
    t[3153] = 580; t[3154] = 581; t[3157] = 584; t[3158] = 585; t[3161] = 588;
    t[3162] = 589; t[3165] = 891; t[3166] = 892; t[3169] = 1274; t[3170] = 1275;
    t[3173] = 1278; t[3174] = 1279; t[3181] = 7622; t[3182] = 7623;
    t[3282] = 11799; t[3316] = 578; t[3379] = 42785; t[3393] = 1159;
    t[3416] = 8377;
  });

  // The glyph map for ArialBlack differs slightly from the glyph map used for
  // other well-known standard fonts. Hence we use this (incomplete) CID to GID
  // mapping to adjust the glyph map for non-embedded ArialBlack fonts.
  var getSupplementalGlyphMapForArialBlack =
      getLookupTableFactory(function (t) {
    t[227] = 322; t[264] = 261; t[291] = 346;
  });

  exports.getStdFontMap = getStdFontMap;
  exports.getNonStdFontMap = getNonStdFontMap;
  exports.getSerifFonts = getSerifFonts;
  exports.getSymbolsFonts = getSymbolsFonts;
  exports.getGlyphMapForStandardFonts = getGlyphMapForStandardFonts;
  exports.getSupplementalGlyphMapForArialBlack =
    getSupplementalGlyphMapForArialBlack;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreUnicode = {}), root.pdfjsSharedUtil);
  }
}(this, function (exports, sharedUtil) {
  var getLookupTableFactory = sharedUtil.getLookupTableFactory;

  // Some characters, e.g. copyrightserif, are mapped to the private use area
  // and might not be displayed using standard fonts. Mapping/hacking well-known
  // chars to the similar equivalents in the normal characters range.
  var getSpecialPUASymbols = getLookupTableFactory(function (t) {
    t[63721] = 0x00A9; // copyrightsans (0xF8E9) => copyright
    t[63193] = 0x00A9; // copyrightserif (0xF6D9) => copyright
    t[63720] = 0x00AE; // registersans (0xF8E8) => registered
    t[63194] = 0x00AE; // registerserif (0xF6DA) => registered
    t[63722] = 0x2122; // trademarksans (0xF8EA) => trademark
    t[63195] = 0x2122; // trademarkserif (0xF6DB) => trademark
    t[63729] = 0x23A7; // bracelefttp (0xF8F1)
    t[63730] = 0x23A8; // braceleftmid (0xF8F2)
    t[63731] = 0x23A9; // braceleftbt (0xF8F3)
    t[63740] = 0x23AB; // bracerighttp (0xF8FC)
    t[63741] = 0x23AC; // bracerightmid (0xF8FD)
    t[63742] = 0x23AD; // bracerightbt (0xF8FE)
    t[63726] = 0x23A1; // bracketlefttp (0xF8EE)
    t[63727] = 0x23A2; // bracketleftex (0xF8EF)
    t[63728] = 0x23A3; // bracketleftbt (0xF8F0)
    t[63737] = 0x23A4; // bracketrighttp (0xF8F9)
    t[63738] = 0x23A5; // bracketrightex (0xF8FA)
    t[63739] = 0x23A6; // bracketrightbt (0xF8FB)
    t[63723] = 0x239B; // parenlefttp (0xF8EB)
    t[63724] = 0x239C; // parenleftex (0xF8EC)
    t[63725] = 0x239D; // parenleftbt (0xF8ED)
    t[63734] = 0x239E; // parenrighttp (0xF8F6)
    t[63735] = 0x239F; // parenrightex (0xF8F7)
    t[63736] = 0x23A0; // parenrightbt (0xF8F8)
  });

  function mapSpecialUnicodeValues(code) {
    if (code >= 0xFFF0 && code <= 0xFFFF) { // Specials unicode block.
      return 0;
    } else if (code >= 0xF600 && code <= 0xF8FF) {
      return (getSpecialPUASymbols()[code] || code);
    }
    return code;
  }

  function getUnicodeForGlyph(name, glyphsUnicodeMap) {
    var unicode = glyphsUnicodeMap[name];
    if (unicode !== undefined) {
      return unicode;
    }
    if (!name) {
      return -1;
    }
    // Try to recover valid Unicode values from 'uniXXXX'/'uXXXX{XX}' glyphs.
    if (name[0] === 'u') {
      var nameLen = name.length, hexStr;

      if (nameLen === 7 && name[1] === 'n' && name[2] === 'i') { // 'uniXXXX'
        hexStr = name.substr(3);
      } else if (nameLen >= 5 && nameLen <= 7) { // 'uXXXX{XX}'
        hexStr = name.substr(1);
      } else {
        return -1;
      }
      // Check for upper-case hexadecimal characters, to avoid false positives.
      if (hexStr === hexStr.toUpperCase()) {
        unicode = parseInt(hexStr, 16);
        if (unicode >= 0) {
          return unicode;
        }
      }
    }
    return -1;
  }

  var UnicodeRanges = [
    { 'begin': 0x0000, 'end': 0x007F }, // Basic Latin
    { 'begin': 0x0080, 'end': 0x00FF }, // Latin-1 Supplement
    { 'begin': 0x0100, 'end': 0x017F }, // Latin Extended-A
    { 'begin': 0x0180, 'end': 0x024F }, // Latin Extended-B
    { 'begin': 0x0250, 'end': 0x02AF }, // IPA Extensions
    { 'begin': 0x02B0, 'end': 0x02FF }, // Spacing Modifier Letters
    { 'begin': 0x0300, 'end': 0x036F }, // Combining Diacritical Marks
    { 'begin': 0x0370, 'end': 0x03FF }, // Greek and Coptic
    { 'begin': 0x2C80, 'end': 0x2CFF }, // Coptic
    { 'begin': 0x0400, 'end': 0x04FF }, // Cyrillic
    { 'begin': 0x0530, 'end': 0x058F }, // Armenian
    { 'begin': 0x0590, 'end': 0x05FF }, // Hebrew
    { 'begin': 0xA500, 'end': 0xA63F }, // Vai
    { 'begin': 0x0600, 'end': 0x06FF }, // Arabic
    { 'begin': 0x07C0, 'end': 0x07FF }, // NKo
    { 'begin': 0x0900, 'end': 0x097F }, // Devanagari
    { 'begin': 0x0980, 'end': 0x09FF }, // Bengali
    { 'begin': 0x0A00, 'end': 0x0A7F }, // Gurmukhi
    { 'begin': 0x0A80, 'end': 0x0AFF }, // Gujarati
    { 'begin': 0x0B00, 'end': 0x0B7F }, // Oriya
    { 'begin': 0x0B80, 'end': 0x0BFF }, // Tamil
    { 'begin': 0x0C00, 'end': 0x0C7F }, // Telugu
    { 'begin': 0x0C80, 'end': 0x0CFF }, // Kannada
    { 'begin': 0x0D00, 'end': 0x0D7F }, // Malayalam
    { 'begin': 0x0E00, 'end': 0x0E7F }, // Thai
    { 'begin': 0x0E80, 'end': 0x0EFF }, // Lao
    { 'begin': 0x10A0, 'end': 0x10FF }, // Georgian
    { 'begin': 0x1B00, 'end': 0x1B7F }, // Balinese
    { 'begin': 0x1100, 'end': 0x11FF }, // Hangul Jamo
    { 'begin': 0x1E00, 'end': 0x1EFF }, // Latin Extended Additional
    { 'begin': 0x1F00, 'end': 0x1FFF }, // Greek Extended
    { 'begin': 0x2000, 'end': 0x206F }, // General Punctuation
    { 'begin': 0x2070, 'end': 0x209F }, // Superscripts And Subscripts
    { 'begin': 0x20A0, 'end': 0x20CF }, // Currency Symbol
    { 'begin': 0x20D0, 'end': 0x20FF }, // Combining Diacritical Marks
    { 'begin': 0x2100, 'end': 0x214F }, // Letterlike Symbols
    { 'begin': 0x2150, 'end': 0x218F }, // Number Forms
    { 'begin': 0x2190, 'end': 0x21FF }, // Arrows
    { 'begin': 0x2200, 'end': 0x22FF }, // Mathematical Operators
    { 'begin': 0x2300, 'end': 0x23FF }, // Miscellaneous Technical
    { 'begin': 0x2400, 'end': 0x243F }, // Control Pictures
    { 'begin': 0x2440, 'end': 0x245F }, // Optical Character Recognition
    { 'begin': 0x2460, 'end': 0x24FF }, // Enclosed Alphanumerics
    { 'begin': 0x2500, 'end': 0x257F }, // Box Drawing
    { 'begin': 0x2580, 'end': 0x259F }, // Block Elements
    { 'begin': 0x25A0, 'end': 0x25FF }, // Geometric Shapes
    { 'begin': 0x2600, 'end': 0x26FF }, // Miscellaneous Symbols
    { 'begin': 0x2700, 'end': 0x27BF }, // Dingbats
    { 'begin': 0x3000, 'end': 0x303F }, // CJK Symbols And Punctuation
    { 'begin': 0x3040, 'end': 0x309F }, // Hiragana
    { 'begin': 0x30A0, 'end': 0x30FF }, // Katakana
    { 'begin': 0x3100, 'end': 0x312F }, // Bopomofo
    { 'begin': 0x3130, 'end': 0x318F }, // Hangul Compatibility Jamo
    { 'begin': 0xA840, 'end': 0xA87F }, // Phags-pa
    { 'begin': 0x3200, 'end': 0x32FF }, // Enclosed CJK Letters And Months
    { 'begin': 0x3300, 'end': 0x33FF }, // CJK Compatibility
    { 'begin': 0xAC00, 'end': 0xD7AF }, // Hangul Syllables
    { 'begin': 0xD800, 'end': 0xDFFF }, // Non-Plane 0 *
    { 'begin': 0x10900, 'end': 0x1091F }, // Phoenicia
    { 'begin': 0x4E00, 'end': 0x9FFF }, // CJK Unified Ideographs
    { 'begin': 0xE000, 'end': 0xF8FF }, // Private Use Area (plane 0)
    { 'begin': 0x31C0, 'end': 0x31EF }, // CJK Strokes
    { 'begin': 0xFB00, 'end': 0xFB4F }, // Alphabetic Presentation Forms
    { 'begin': 0xFB50, 'end': 0xFDFF }, // Arabic Presentation Forms-A
    { 'begin': 0xFE20, 'end': 0xFE2F }, // Combining Half Marks
    { 'begin': 0xFE10, 'end': 0xFE1F }, // Vertical Forms
    { 'begin': 0xFE50, 'end': 0xFE6F }, // Small Form Variants
    { 'begin': 0xFE70, 'end': 0xFEFF }, // Arabic Presentation Forms-B
    { 'begin': 0xFF00, 'end': 0xFFEF }, // Halfwidth And Fullwidth Forms
    { 'begin': 0xFFF0, 'end': 0xFFFF }, // Specials
    { 'begin': 0x0F00, 'end': 0x0FFF }, // Tibetan
    { 'begin': 0x0700, 'end': 0x074F }, // Syriac
    { 'begin': 0x0780, 'end': 0x07BF }, // Thaana
    { 'begin': 0x0D80, 'end': 0x0DFF }, // Sinhala
    { 'begin': 0x1000, 'end': 0x109F }, // Myanmar
    { 'begin': 0x1200, 'end': 0x137F }, // Ethiopic
    { 'begin': 0x13A0, 'end': 0x13FF }, // Cherokee
    { 'begin': 0x1400, 'end': 0x167F }, // Unified Canadian Aboriginal Syllabics
    { 'begin': 0x1680, 'end': 0x169F }, // Ogham
    { 'begin': 0x16A0, 'end': 0x16FF }, // Runic
    { 'begin': 0x1780, 'end': 0x17FF }, // Khmer
    { 'begin': 0x1800, 'end': 0x18AF }, // Mongolian
    { 'begin': 0x2800, 'end': 0x28FF }, // Braille Patterns
    { 'begin': 0xA000, 'end': 0xA48F }, // Yi Syllables
    { 'begin': 0x1700, 'end': 0x171F }, // Tagalog
    { 'begin': 0x10300, 'end': 0x1032F }, // Old Italic
    { 'begin': 0x10330, 'end': 0x1034F }, // Gothic
    { 'begin': 0x10400, 'end': 0x1044F }, // Deseret
    { 'begin': 0x1D000, 'end': 0x1D0FF }, // Byzantine Musical Symbols
    { 'begin': 0x1D400, 'end': 0x1D7FF }, // Mathematical Alphanumeric Symbols
    { 'begin': 0xFF000, 'end': 0xFFFFD }, // Private Use (plane 15)
    { 'begin': 0xFE00, 'end': 0xFE0F }, // Variation Selectors
    { 'begin': 0xE0000, 'end': 0xE007F }, // Tags
    { 'begin': 0x1900, 'end': 0x194F }, // Limbu
    { 'begin': 0x1950, 'end': 0x197F }, // Tai Le
    { 'begin': 0x1980, 'end': 0x19DF }, // New Tai Lue
    { 'begin': 0x1A00, 'end': 0x1A1F }, // Buginese
    { 'begin': 0x2C00, 'end': 0x2C5F }, // Glagolitic
    { 'begin': 0x2D30, 'end': 0x2D7F }, // Tifinagh
    { 'begin': 0x4DC0, 'end': 0x4DFF }, // Yijing Hexagram Symbols
    { 'begin': 0xA800, 'end': 0xA82F }, // Syloti Nagri
    { 'begin': 0x10000, 'end': 0x1007F }, // Linear B Syllabary
    { 'begin': 0x10140, 'end': 0x1018F }, // Ancient Greek Numbers
    { 'begin': 0x10380, 'end': 0x1039F }, // Ugaritic
    { 'begin': 0x103A0, 'end': 0x103DF }, // Old Persian
    { 'begin': 0x10450, 'end': 0x1047F }, // Shavian
    { 'begin': 0x10480, 'end': 0x104AF }, // Osmanya
    { 'begin': 0x10800, 'end': 0x1083F }, // Cypriot Syllabary
    { 'begin': 0x10A00, 'end': 0x10A5F }, // Kharoshthi
    { 'begin': 0x1D300, 'end': 0x1D35F }, // Tai Xuan Jing Symbols
    { 'begin': 0x12000, 'end': 0x123FF }, // Cuneiform
    { 'begin': 0x1D360, 'end': 0x1D37F }, // Counting Rod Numerals
    { 'begin': 0x1B80, 'end': 0x1BBF }, // Sundanese
    { 'begin': 0x1C00, 'end': 0x1C4F }, // Lepcha
    { 'begin': 0x1C50, 'end': 0x1C7F }, // Ol Chiki
    { 'begin': 0xA880, 'end': 0xA8DF }, // Saurashtra
    { 'begin': 0xA900, 'end': 0xA92F }, // Kayah Li
    { 'begin': 0xA930, 'end': 0xA95F }, // Rejang
    { 'begin': 0xAA00, 'end': 0xAA5F }, // Cham
    { 'begin': 0x10190, 'end': 0x101CF }, // Ancient Symbols
    { 'begin': 0x101D0, 'end': 0x101FF }, // Phaistos Disc
    { 'begin': 0x102A0, 'end': 0x102DF }, // Carian
    { 'begin': 0x1F030, 'end': 0x1F09F }  // Domino Tiles
  ];

  function getUnicodeRangeFor(value) {
    for (var i = 0, ii = UnicodeRanges.length; i < ii; i++) {
      var range = UnicodeRanges[i];
      if (value >= range.begin && value < range.end) {
        return i;
      }
    }
    return -1;
  }

  function isRTLRangeFor(value) {
    var range = UnicodeRanges[13];
    if (value >= range.begin && value < range.end) {
      return true;
    }
    range = UnicodeRanges[11];
    if (value >= range.begin && value < range.end) {
      return true;
    }
    return false;
  }

  // The normalization table is obtained by filtering the Unicode characters
  // database with <compat> entries.
  var getNormalizedUnicodes = getLookupTableFactory(function (t) {
    t['\u00A8'] = '\u0020\u0308';
    t['\u00AF'] = '\u0020\u0304';
    t['\u00B4'] = '\u0020\u0301';
    t['\u00B5'] = '\u03BC';
    t['\u00B8'] = '\u0020\u0327';
    t['\u0132'] = '\u0049\u004A';
    t['\u0133'] = '\u0069\u006A';
    t['\u013F'] = '\u004C\u00B7';
    t['\u0140'] = '\u006C\u00B7';
    t['\u0149'] = '\u02BC\u006E';
    t['\u017F'] = '\u0073';
    t['\u01C4'] = '\u0044\u017D';
    t['\u01C5'] = '\u0044\u017E';
    t['\u01C6'] = '\u0064\u017E';
    t['\u01C7'] = '\u004C\u004A';
    t['\u01C8'] = '\u004C\u006A';
    t['\u01C9'] = '\u006C\u006A';
    t['\u01CA'] = '\u004E\u004A';
    t['\u01CB'] = '\u004E\u006A';
    t['\u01CC'] = '\u006E\u006A';
    t['\u01F1'] = '\u0044\u005A';
    t['\u01F2'] = '\u0044\u007A';
    t['\u01F3'] = '\u0064\u007A';
    t['\u02D8'] = '\u0020\u0306';
    t['\u02D9'] = '\u0020\u0307';
    t['\u02DA'] = '\u0020\u030A';
    t['\u02DB'] = '\u0020\u0328';
    t['\u02DC'] = '\u0020\u0303';
    t['\u02DD'] = '\u0020\u030B';
    t['\u037A'] = '\u0020\u0345';
    t['\u0384'] = '\u0020\u0301';
    t['\u03D0'] = '\u03B2';
    t['\u03D1'] = '\u03B8';
    t['\u03D2'] = '\u03A5';
    t['\u03D5'] = '\u03C6';
    t['\u03D6'] = '\u03C0';
    t['\u03F0'] = '\u03BA';
    t['\u03F1'] = '\u03C1';
    t['\u03F2'] = '\u03C2';
    t['\u03F4'] = '\u0398';
    t['\u03F5'] = '\u03B5';
    t['\u03F9'] = '\u03A3';
    t['\u0587'] = '\u0565\u0582';
    t['\u0675'] = '\u0627\u0674';
    t['\u0676'] = '\u0648\u0674';
    t['\u0677'] = '\u06C7\u0674';
    t['\u0678'] = '\u064A\u0674';
    t['\u0E33'] = '\u0E4D\u0E32';
    t['\u0EB3'] = '\u0ECD\u0EB2';
    t['\u0EDC'] = '\u0EAB\u0E99';
    t['\u0EDD'] = '\u0EAB\u0EA1';
    t['\u0F77'] = '\u0FB2\u0F81';
    t['\u0F79'] = '\u0FB3\u0F81';
    t['\u1E9A'] = '\u0061\u02BE';
    t['\u1FBD'] = '\u0020\u0313';
    t['\u1FBF'] = '\u0020\u0313';
    t['\u1FC0'] = '\u0020\u0342';
    t['\u1FFE'] = '\u0020\u0314';
    t['\u2002'] = '\u0020';
    t['\u2003'] = '\u0020';
    t['\u2004'] = '\u0020';
    t['\u2005'] = '\u0020';
    t['\u2006'] = '\u0020';
    t['\u2008'] = '\u0020';
    t['\u2009'] = '\u0020';
    t['\u200A'] = '\u0020';
    t['\u2017'] = '\u0020\u0333';
    t['\u2024'] = '\u002E';
    t['\u2025'] = '\u002E\u002E';
    t['\u2026'] = '\u002E\u002E\u002E';
    t['\u2033'] = '\u2032\u2032';
    t['\u2034'] = '\u2032\u2032\u2032';
    t['\u2036'] = '\u2035\u2035';
    t['\u2037'] = '\u2035\u2035\u2035';
    t['\u203C'] = '\u0021\u0021';
    t['\u203E'] = '\u0020\u0305';
    t['\u2047'] = '\u003F\u003F';
    t['\u2048'] = '\u003F\u0021';
    t['\u2049'] = '\u0021\u003F';
    t['\u2057'] = '\u2032\u2032\u2032\u2032';
    t['\u205F'] = '\u0020';
    t['\u20A8'] = '\u0052\u0073';
    t['\u2100'] = '\u0061\u002F\u0063';
    t['\u2101'] = '\u0061\u002F\u0073';
    t['\u2103'] = '\u00B0\u0043';
    t['\u2105'] = '\u0063\u002F\u006F';
    t['\u2106'] = '\u0063\u002F\u0075';
    t['\u2107'] = '\u0190';
    t['\u2109'] = '\u00B0\u0046';
    t['\u2116'] = '\u004E\u006F';
    t['\u2121'] = '\u0054\u0045\u004C';
    t['\u2135'] = '\u05D0';
    t['\u2136'] = '\u05D1';
    t['\u2137'] = '\u05D2';
    t['\u2138'] = '\u05D3';
    t['\u213B'] = '\u0046\u0041\u0058';
    t['\u2160'] = '\u0049';
    t['\u2161'] = '\u0049\u0049';
    t['\u2162'] = '\u0049\u0049\u0049';
    t['\u2163'] = '\u0049\u0056';
    t['\u2164'] = '\u0056';
    t['\u2165'] = '\u0056\u0049';
    t['\u2166'] = '\u0056\u0049\u0049';
    t['\u2167'] = '\u0056\u0049\u0049\u0049';
    t['\u2168'] = '\u0049\u0058';
    t['\u2169'] = '\u0058';
    t['\u216A'] = '\u0058\u0049';
    t['\u216B'] = '\u0058\u0049\u0049';
    t['\u216C'] = '\u004C';
    t['\u216D'] = '\u0043';
    t['\u216E'] = '\u0044';
    t['\u216F'] = '\u004D';
    t['\u2170'] = '\u0069';
    t['\u2171'] = '\u0069\u0069';
    t['\u2172'] = '\u0069\u0069\u0069';
    t['\u2173'] = '\u0069\u0076';
    t['\u2174'] = '\u0076';
    t['\u2175'] = '\u0076\u0069';
    t['\u2176'] = '\u0076\u0069\u0069';
    t['\u2177'] = '\u0076\u0069\u0069\u0069';
    t['\u2178'] = '\u0069\u0078';
    t['\u2179'] = '\u0078';
    t['\u217A'] = '\u0078\u0069';
    t['\u217B'] = '\u0078\u0069\u0069';
    t['\u217C'] = '\u006C';
    t['\u217D'] = '\u0063';
    t['\u217E'] = '\u0064';
    t['\u217F'] = '\u006D';
    t['\u222C'] = '\u222B\u222B';
    t['\u222D'] = '\u222B\u222B\u222B';
    t['\u222F'] = '\u222E\u222E';
    t['\u2230'] = '\u222E\u222E\u222E';
    t['\u2474'] = '\u0028\u0031\u0029';
    t['\u2475'] = '\u0028\u0032\u0029';
    t['\u2476'] = '\u0028\u0033\u0029';
    t['\u2477'] = '\u0028\u0034\u0029';
    t['\u2478'] = '\u0028\u0035\u0029';
    t['\u2479'] = '\u0028\u0036\u0029';
    t['\u247A'] = '\u0028\u0037\u0029';
    t['\u247B'] = '\u0028\u0038\u0029';
    t['\u247C'] = '\u0028\u0039\u0029';
    t['\u247D'] = '\u0028\u0031\u0030\u0029';
    t['\u247E'] = '\u0028\u0031\u0031\u0029';
    t['\u247F'] = '\u0028\u0031\u0032\u0029';
    t['\u2480'] = '\u0028\u0031\u0033\u0029';
    t['\u2481'] = '\u0028\u0031\u0034\u0029';
    t['\u2482'] = '\u0028\u0031\u0035\u0029';
    t['\u2483'] = '\u0028\u0031\u0036\u0029';
    t['\u2484'] = '\u0028\u0031\u0037\u0029';
    t['\u2485'] = '\u0028\u0031\u0038\u0029';
    t['\u2486'] = '\u0028\u0031\u0039\u0029';
    t['\u2487'] = '\u0028\u0032\u0030\u0029';
    t['\u2488'] = '\u0031\u002E';
    t['\u2489'] = '\u0032\u002E';
    t['\u248A'] = '\u0033\u002E';
    t['\u248B'] = '\u0034\u002E';
    t['\u248C'] = '\u0035\u002E';
    t['\u248D'] = '\u0036\u002E';
    t['\u248E'] = '\u0037\u002E';
    t['\u248F'] = '\u0038\u002E';
    t['\u2490'] = '\u0039\u002E';
    t['\u2491'] = '\u0031\u0030\u002E';
    t['\u2492'] = '\u0031\u0031\u002E';
    t['\u2493'] = '\u0031\u0032\u002E';
    t['\u2494'] = '\u0031\u0033\u002E';
    t['\u2495'] = '\u0031\u0034\u002E';
    t['\u2496'] = '\u0031\u0035\u002E';
    t['\u2497'] = '\u0031\u0036\u002E';
    t['\u2498'] = '\u0031\u0037\u002E';
    t['\u2499'] = '\u0031\u0038\u002E';
    t['\u249A'] = '\u0031\u0039\u002E';
    t['\u249B'] = '\u0032\u0030\u002E';
    t['\u249C'] = '\u0028\u0061\u0029';
    t['\u249D'] = '\u0028\u0062\u0029';
    t['\u249E'] = '\u0028\u0063\u0029';
    t['\u249F'] = '\u0028\u0064\u0029';
    t['\u24A0'] = '\u0028\u0065\u0029';
    t['\u24A1'] = '\u0028\u0066\u0029';
    t['\u24A2'] = '\u0028\u0067\u0029';
    t['\u24A3'] = '\u0028\u0068\u0029';
    t['\u24A4'] = '\u0028\u0069\u0029';
    t['\u24A5'] = '\u0028\u006A\u0029';
    t['\u24A6'] = '\u0028\u006B\u0029';
    t['\u24A7'] = '\u0028\u006C\u0029';
    t['\u24A8'] = '\u0028\u006D\u0029';
    t['\u24A9'] = '\u0028\u006E\u0029';
    t['\u24AA'] = '\u0028\u006F\u0029';
    t['\u24AB'] = '\u0028\u0070\u0029';
    t['\u24AC'] = '\u0028\u0071\u0029';
    t['\u24AD'] = '\u0028\u0072\u0029';
    t['\u24AE'] = '\u0028\u0073\u0029';
    t['\u24AF'] = '\u0028\u0074\u0029';
    t['\u24B0'] = '\u0028\u0075\u0029';
    t['\u24B1'] = '\u0028\u0076\u0029';
    t['\u24B2'] = '\u0028\u0077\u0029';
    t['\u24B3'] = '\u0028\u0078\u0029';
    t['\u24B4'] = '\u0028\u0079\u0029';
    t['\u24B5'] = '\u0028\u007A\u0029';
    t['\u2A0C'] = '\u222B\u222B\u222B\u222B';
    t['\u2A74'] = '\u003A\u003A\u003D';
    t['\u2A75'] = '\u003D\u003D';
    t['\u2A76'] = '\u003D\u003D\u003D';
    t['\u2E9F'] = '\u6BCD';
    t['\u2EF3'] = '\u9F9F';
    t['\u2F00'] = '\u4E00';
    t['\u2F01'] = '\u4E28';
    t['\u2F02'] = '\u4E36';
    t['\u2F03'] = '\u4E3F';
    t['\u2F04'] = '\u4E59';
    t['\u2F05'] = '\u4E85';
    t['\u2F06'] = '\u4E8C';
    t['\u2F07'] = '\u4EA0';
    t['\u2F08'] = '\u4EBA';
    t['\u2F09'] = '\u513F';
    t['\u2F0A'] = '\u5165';
    t['\u2F0B'] = '\u516B';
    t['\u2F0C'] = '\u5182';
    t['\u2F0D'] = '\u5196';
    t['\u2F0E'] = '\u51AB';
    t['\u2F0F'] = '\u51E0';
    t['\u2F10'] = '\u51F5';
    t['\u2F11'] = '\u5200';
    t['\u2F12'] = '\u529B';
    t['\u2F13'] = '\u52F9';
    t['\u2F14'] = '\u5315';
    t['\u2F15'] = '\u531A';
    t['\u2F16'] = '\u5338';
    t['\u2F17'] = '\u5341';
    t['\u2F18'] = '\u535C';
    t['\u2F19'] = '\u5369';
    t['\u2F1A'] = '\u5382';
    t['\u2F1B'] = '\u53B6';
    t['\u2F1C'] = '\u53C8';
    t['\u2F1D'] = '\u53E3';
    t['\u2F1E'] = '\u56D7';
    t['\u2F1F'] = '\u571F';
    t['\u2F20'] = '\u58EB';
    t['\u2F21'] = '\u5902';
    t['\u2F22'] = '\u590A';
    t['\u2F23'] = '\u5915';
    t['\u2F24'] = '\u5927';
    t['\u2F25'] = '\u5973';
    t['\u2F26'] = '\u5B50';
    t['\u2F27'] = '\u5B80';
    t['\u2F28'] = '\u5BF8';
    t['\u2F29'] = '\u5C0F';
    t['\u2F2A'] = '\u5C22';
    t['\u2F2B'] = '\u5C38';
    t['\u2F2C'] = '\u5C6E';
    t['\u2F2D'] = '\u5C71';
    t['\u2F2E'] = '\u5DDB';
    t['\u2F2F'] = '\u5DE5';
    t['\u2F30'] = '\u5DF1';
    t['\u2F31'] = '\u5DFE';
    t['\u2F32'] = '\u5E72';
    t['\u2F33'] = '\u5E7A';
    t['\u2F34'] = '\u5E7F';
    t['\u2F35'] = '\u5EF4';
    t['\u2F36'] = '\u5EFE';
    t['\u2F37'] = '\u5F0B';
    t['\u2F38'] = '\u5F13';
    t['\u2F39'] = '\u5F50';
    t['\u2F3A'] = '\u5F61';
    t['\u2F3B'] = '\u5F73';
    t['\u2F3C'] = '\u5FC3';
    t['\u2F3D'] = '\u6208';
    t['\u2F3E'] = '\u6236';
    t['\u2F3F'] = '\u624B';
    t['\u2F40'] = '\u652F';
    t['\u2F41'] = '\u6534';
    t['\u2F42'] = '\u6587';
    t['\u2F43'] = '\u6597';
    t['\u2F44'] = '\u65A4';
    t['\u2F45'] = '\u65B9';
    t['\u2F46'] = '\u65E0';
    t['\u2F47'] = '\u65E5';
    t['\u2F48'] = '\u66F0';
    t['\u2F49'] = '\u6708';
    t['\u2F4A'] = '\u6728';
    t['\u2F4B'] = '\u6B20';
    t['\u2F4C'] = '\u6B62';
    t['\u2F4D'] = '\u6B79';
    t['\u2F4E'] = '\u6BB3';
    t['\u2F4F'] = '\u6BCB';
    t['\u2F50'] = '\u6BD4';
    t['\u2F51'] = '\u6BDB';
    t['\u2F52'] = '\u6C0F';
    t['\u2F53'] = '\u6C14';
    t['\u2F54'] = '\u6C34';
    t['\u2F55'] = '\u706B';
    t['\u2F56'] = '\u722A';
    t['\u2F57'] = '\u7236';
    t['\u2F58'] = '\u723B';
    t['\u2F59'] = '\u723F';
    t['\u2F5A'] = '\u7247';
    t['\u2F5B'] = '\u7259';
    t['\u2F5C'] = '\u725B';
    t['\u2F5D'] = '\u72AC';
    t['\u2F5E'] = '\u7384';
    t['\u2F5F'] = '\u7389';
    t['\u2F60'] = '\u74DC';
    t['\u2F61'] = '\u74E6';
    t['\u2F62'] = '\u7518';
    t['\u2F63'] = '\u751F';
    t['\u2F64'] = '\u7528';
    t['\u2F65'] = '\u7530';
    t['\u2F66'] = '\u758B';
    t['\u2F67'] = '\u7592';
    t['\u2F68'] = '\u7676';
    t['\u2F69'] = '\u767D';
    t['\u2F6A'] = '\u76AE';
    t['\u2F6B'] = '\u76BF';
    t['\u2F6C'] = '\u76EE';
    t['\u2F6D'] = '\u77DB';
    t['\u2F6E'] = '\u77E2';
    t['\u2F6F'] = '\u77F3';
    t['\u2F70'] = '\u793A';
    t['\u2F71'] = '\u79B8';
    t['\u2F72'] = '\u79BE';
    t['\u2F73'] = '\u7A74';
    t['\u2F74'] = '\u7ACB';
    t['\u2F75'] = '\u7AF9';
    t['\u2F76'] = '\u7C73';
    t['\u2F77'] = '\u7CF8';
    t['\u2F78'] = '\u7F36';
    t['\u2F79'] = '\u7F51';
    t['\u2F7A'] = '\u7F8A';
    t['\u2F7B'] = '\u7FBD';
    t['\u2F7C'] = '\u8001';
    t['\u2F7D'] = '\u800C';
    t['\u2F7E'] = '\u8012';
    t['\u2F7F'] = '\u8033';
    t['\u2F80'] = '\u807F';
    t['\u2F81'] = '\u8089';
    t['\u2F82'] = '\u81E3';
    t['\u2F83'] = '\u81EA';
    t['\u2F84'] = '\u81F3';
    t['\u2F85'] = '\u81FC';
    t['\u2F86'] = '\u820C';
    t['\u2F87'] = '\u821B';
    t['\u2F88'] = '\u821F';
    t['\u2F89'] = '\u826E';
    t['\u2F8A'] = '\u8272';
    t['\u2F8B'] = '\u8278';
    t['\u2F8C'] = '\u864D';
    t['\u2F8D'] = '\u866B';
    t['\u2F8E'] = '\u8840';
    t['\u2F8F'] = '\u884C';
    t['\u2F90'] = '\u8863';
    t['\u2F91'] = '\u897E';
    t['\u2F92'] = '\u898B';
    t['\u2F93'] = '\u89D2';
    t['\u2F94'] = '\u8A00';
    t['\u2F95'] = '\u8C37';
    t['\u2F96'] = '\u8C46';
    t['\u2F97'] = '\u8C55';
    t['\u2F98'] = '\u8C78';
    t['\u2F99'] = '\u8C9D';
    t['\u2F9A'] = '\u8D64';
    t['\u2F9B'] = '\u8D70';
    t['\u2F9C'] = '\u8DB3';
    t['\u2F9D'] = '\u8EAB';
    t['\u2F9E'] = '\u8ECA';
    t['\u2F9F'] = '\u8F9B';
    t['\u2FA0'] = '\u8FB0';
    t['\u2FA1'] = '\u8FB5';
    t['\u2FA2'] = '\u9091';
    t['\u2FA3'] = '\u9149';
    t['\u2FA4'] = '\u91C6';
    t['\u2FA5'] = '\u91CC';
    t['\u2FA6'] = '\u91D1';
    t['\u2FA7'] = '\u9577';
    t['\u2FA8'] = '\u9580';
    t['\u2FA9'] = '\u961C';
    t['\u2FAA'] = '\u96B6';
    t['\u2FAB'] = '\u96B9';
    t['\u2FAC'] = '\u96E8';
    t['\u2FAD'] = '\u9751';
    t['\u2FAE'] = '\u975E';
    t['\u2FAF'] = '\u9762';
    t['\u2FB0'] = '\u9769';
    t['\u2FB1'] = '\u97CB';
    t['\u2FB2'] = '\u97ED';
    t['\u2FB3'] = '\u97F3';
    t['\u2FB4'] = '\u9801';
    t['\u2FB5'] = '\u98A8';
    t['\u2FB6'] = '\u98DB';
    t['\u2FB7'] = '\u98DF';
    t['\u2FB8'] = '\u9996';
    t['\u2FB9'] = '\u9999';
    t['\u2FBA'] = '\u99AC';
    t['\u2FBB'] = '\u9AA8';
    t['\u2FBC'] = '\u9AD8';
    t['\u2FBD'] = '\u9ADF';
    t['\u2FBE'] = '\u9B25';
    t['\u2FBF'] = '\u9B2F';
    t['\u2FC0'] = '\u9B32';
    t['\u2FC1'] = '\u9B3C';
    t['\u2FC2'] = '\u9B5A';
    t['\u2FC3'] = '\u9CE5';
    t['\u2FC4'] = '\u9E75';
    t['\u2FC5'] = '\u9E7F';
    t['\u2FC6'] = '\u9EA5';
    t['\u2FC7'] = '\u9EBB';
    t['\u2FC8'] = '\u9EC3';
    t['\u2FC9'] = '\u9ECD';
    t['\u2FCA'] = '\u9ED1';
    t['\u2FCB'] = '\u9EF9';
    t['\u2FCC'] = '\u9EFD';
    t['\u2FCD'] = '\u9F0E';
    t['\u2FCE'] = '\u9F13';
    t['\u2FCF'] = '\u9F20';
    t['\u2FD0'] = '\u9F3B';
    t['\u2FD1'] = '\u9F4A';
    t['\u2FD2'] = '\u9F52';
    t['\u2FD3'] = '\u9F8D';
    t['\u2FD4'] = '\u9F9C';
    t['\u2FD5'] = '\u9FA0';
    t['\u3036'] = '\u3012';
    t['\u3038'] = '\u5341';
    t['\u3039'] = '\u5344';
    t['\u303A'] = '\u5345';
    t['\u309B'] = '\u0020\u3099';
    t['\u309C'] = '\u0020\u309A';
    t['\u3131'] = '\u1100';
    t['\u3132'] = '\u1101';
    t['\u3133'] = '\u11AA';
    t['\u3134'] = '\u1102';
    t['\u3135'] = '\u11AC';
    t['\u3136'] = '\u11AD';
    t['\u3137'] = '\u1103';
    t['\u3138'] = '\u1104';
    t['\u3139'] = '\u1105';
    t['\u313A'] = '\u11B0';
    t['\u313B'] = '\u11B1';
    t['\u313C'] = '\u11B2';
    t['\u313D'] = '\u11B3';
    t['\u313E'] = '\u11B4';
    t['\u313F'] = '\u11B5';
    t['\u3140'] = '\u111A';
    t['\u3141'] = '\u1106';
    t['\u3142'] = '\u1107';
    t['\u3143'] = '\u1108';
    t['\u3144'] = '\u1121';
    t['\u3145'] = '\u1109';
    t['\u3146'] = '\u110A';
    t['\u3147'] = '\u110B';
    t['\u3148'] = '\u110C';
    t['\u3149'] = '\u110D';
    t['\u314A'] = '\u110E';
    t['\u314B'] = '\u110F';
    t['\u314C'] = '\u1110';
    t['\u314D'] = '\u1111';
    t['\u314E'] = '\u1112';
    t['\u314F'] = '\u1161';
    t['\u3150'] = '\u1162';
    t['\u3151'] = '\u1163';
    t['\u3152'] = '\u1164';
    t['\u3153'] = '\u1165';
    t['\u3154'] = '\u1166';
    t['\u3155'] = '\u1167';
    t['\u3156'] = '\u1168';
    t['\u3157'] = '\u1169';
    t['\u3158'] = '\u116A';
    t['\u3159'] = '\u116B';
    t['\u315A'] = '\u116C';
    t['\u315B'] = '\u116D';
    t['\u315C'] = '\u116E';
    t['\u315D'] = '\u116F';
    t['\u315E'] = '\u1170';
    t['\u315F'] = '\u1171';
    t['\u3160'] = '\u1172';
    t['\u3161'] = '\u1173';
    t['\u3162'] = '\u1174';
    t['\u3163'] = '\u1175';
    t['\u3164'] = '\u1160';
    t['\u3165'] = '\u1114';
    t['\u3166'] = '\u1115';
    t['\u3167'] = '\u11C7';
    t['\u3168'] = '\u11C8';
    t['\u3169'] = '\u11CC';
    t['\u316A'] = '\u11CE';
    t['\u316B'] = '\u11D3';
    t['\u316C'] = '\u11D7';
    t['\u316D'] = '\u11D9';
    t['\u316E'] = '\u111C';
    t['\u316F'] = '\u11DD';
    t['\u3170'] = '\u11DF';
    t['\u3171'] = '\u111D';
    t['\u3172'] = '\u111E';
    t['\u3173'] = '\u1120';
    t['\u3174'] = '\u1122';
    t['\u3175'] = '\u1123';
    t['\u3176'] = '\u1127';
    t['\u3177'] = '\u1129';
    t['\u3178'] = '\u112B';
    t['\u3179'] = '\u112C';
    t['\u317A'] = '\u112D';
    t['\u317B'] = '\u112E';
    t['\u317C'] = '\u112F';
    t['\u317D'] = '\u1132';
    t['\u317E'] = '\u1136';
    t['\u317F'] = '\u1140';
    t['\u3180'] = '\u1147';
    t['\u3181'] = '\u114C';
    t['\u3182'] = '\u11F1';
    t['\u3183'] = '\u11F2';
    t['\u3184'] = '\u1157';
    t['\u3185'] = '\u1158';
    t['\u3186'] = '\u1159';
    t['\u3187'] = '\u1184';
    t['\u3188'] = '\u1185';
    t['\u3189'] = '\u1188';
    t['\u318A'] = '\u1191';
    t['\u318B'] = '\u1192';
    t['\u318C'] = '\u1194';
    t['\u318D'] = '\u119E';
    t['\u318E'] = '\u11A1';
    t['\u3200'] = '\u0028\u1100\u0029';
    t['\u3201'] = '\u0028\u1102\u0029';
    t['\u3202'] = '\u0028\u1103\u0029';
    t['\u3203'] = '\u0028\u1105\u0029';
    t['\u3204'] = '\u0028\u1106\u0029';
    t['\u3205'] = '\u0028\u1107\u0029';
    t['\u3206'] = '\u0028\u1109\u0029';
    t['\u3207'] = '\u0028\u110B\u0029';
    t['\u3208'] = '\u0028\u110C\u0029';
    t['\u3209'] = '\u0028\u110E\u0029';
    t['\u320A'] = '\u0028\u110F\u0029';
    t['\u320B'] = '\u0028\u1110\u0029';
    t['\u320C'] = '\u0028\u1111\u0029';
    t['\u320D'] = '\u0028\u1112\u0029';
    t['\u320E'] = '\u0028\u1100\u1161\u0029';
    t['\u320F'] = '\u0028\u1102\u1161\u0029';
    t['\u3210'] = '\u0028\u1103\u1161\u0029';
    t['\u3211'] = '\u0028\u1105\u1161\u0029';
    t['\u3212'] = '\u0028\u1106\u1161\u0029';
    t['\u3213'] = '\u0028\u1107\u1161\u0029';
    t['\u3214'] = '\u0028\u1109\u1161\u0029';
    t['\u3215'] = '\u0028\u110B\u1161\u0029';
    t['\u3216'] = '\u0028\u110C\u1161\u0029';
    t['\u3217'] = '\u0028\u110E\u1161\u0029';
    t['\u3218'] = '\u0028\u110F\u1161\u0029';
    t['\u3219'] = '\u0028\u1110\u1161\u0029';
    t['\u321A'] = '\u0028\u1111\u1161\u0029';
    t['\u321B'] = '\u0028\u1112\u1161\u0029';
    t['\u321C'] = '\u0028\u110C\u116E\u0029';
    t['\u321D'] = '\u0028\u110B\u1169\u110C\u1165\u11AB\u0029';
    t['\u321E'] = '\u0028\u110B\u1169\u1112\u116E\u0029';
    t['\u3220'] = '\u0028\u4E00\u0029';
    t['\u3221'] = '\u0028\u4E8C\u0029';
    t['\u3222'] = '\u0028\u4E09\u0029';
    t['\u3223'] = '\u0028\u56DB\u0029';
    t['\u3224'] = '\u0028\u4E94\u0029';
    t['\u3225'] = '\u0028\u516D\u0029';
    t['\u3226'] = '\u0028\u4E03\u0029';
    t['\u3227'] = '\u0028\u516B\u0029';
    t['\u3228'] = '\u0028\u4E5D\u0029';
    t['\u3229'] = '\u0028\u5341\u0029';
    t['\u322A'] = '\u0028\u6708\u0029';
    t['\u322B'] = '\u0028\u706B\u0029';
    t['\u322C'] = '\u0028\u6C34\u0029';
    t['\u322D'] = '\u0028\u6728\u0029';
    t['\u322E'] = '\u0028\u91D1\u0029';
    t['\u322F'] = '\u0028\u571F\u0029';
    t['\u3230'] = '\u0028\u65E5\u0029';
    t['\u3231'] = '\u0028\u682A\u0029';
    t['\u3232'] = '\u0028\u6709\u0029';
    t['\u3233'] = '\u0028\u793E\u0029';
    t['\u3234'] = '\u0028\u540D\u0029';
    t['\u3235'] = '\u0028\u7279\u0029';
    t['\u3236'] = '\u0028\u8CA1\u0029';
    t['\u3237'] = '\u0028\u795D\u0029';
    t['\u3238'] = '\u0028\u52B4\u0029';
    t['\u3239'] = '\u0028\u4EE3\u0029';
    t['\u323A'] = '\u0028\u547C\u0029';
    t['\u323B'] = '\u0028\u5B66\u0029';
    t['\u323C'] = '\u0028\u76E3\u0029';
    t['\u323D'] = '\u0028\u4F01\u0029';
    t['\u323E'] = '\u0028\u8CC7\u0029';
    t['\u323F'] = '\u0028\u5354\u0029';
    t['\u3240'] = '\u0028\u796D\u0029';
    t['\u3241'] = '\u0028\u4F11\u0029';
    t['\u3242'] = '\u0028\u81EA\u0029';
    t['\u3243'] = '\u0028\u81F3\u0029';
    t['\u32C0'] = '\u0031\u6708';
    t['\u32C1'] = '\u0032\u6708';
    t['\u32C2'] = '\u0033\u6708';
    t['\u32C3'] = '\u0034\u6708';
    t['\u32C4'] = '\u0035\u6708';
    t['\u32C5'] = '\u0036\u6708';
    t['\u32C6'] = '\u0037\u6708';
    t['\u32C7'] = '\u0038\u6708';
    t['\u32C8'] = '\u0039\u6708';
    t['\u32C9'] = '\u0031\u0030\u6708';
    t['\u32CA'] = '\u0031\u0031\u6708';
    t['\u32CB'] = '\u0031\u0032\u6708';
    t['\u3358'] = '\u0030\u70B9';
    t['\u3359'] = '\u0031\u70B9';
    t['\u335A'] = '\u0032\u70B9';
    t['\u335B'] = '\u0033\u70B9';
    t['\u335C'] = '\u0034\u70B9';
    t['\u335D'] = '\u0035\u70B9';
    t['\u335E'] = '\u0036\u70B9';
    t['\u335F'] = '\u0037\u70B9';
    t['\u3360'] = '\u0038\u70B9';
    t['\u3361'] = '\u0039\u70B9';
    t['\u3362'] = '\u0031\u0030\u70B9';
    t['\u3363'] = '\u0031\u0031\u70B9';
    t['\u3364'] = '\u0031\u0032\u70B9';
    t['\u3365'] = '\u0031\u0033\u70B9';
    t['\u3366'] = '\u0031\u0034\u70B9';
    t['\u3367'] = '\u0031\u0035\u70B9';
    t['\u3368'] = '\u0031\u0036\u70B9';
    t['\u3369'] = '\u0031\u0037\u70B9';
    t['\u336A'] = '\u0031\u0038\u70B9';
    t['\u336B'] = '\u0031\u0039\u70B9';
    t['\u336C'] = '\u0032\u0030\u70B9';
    t['\u336D'] = '\u0032\u0031\u70B9';
    t['\u336E'] = '\u0032\u0032\u70B9';
    t['\u336F'] = '\u0032\u0033\u70B9';
    t['\u3370'] = '\u0032\u0034\u70B9';
    t['\u33E0'] = '\u0031\u65E5';
    t['\u33E1'] = '\u0032\u65E5';
    t['\u33E2'] = '\u0033\u65E5';
    t['\u33E3'] = '\u0034\u65E5';
    t['\u33E4'] = '\u0035\u65E5';
    t['\u33E5'] = '\u0036\u65E5';
    t['\u33E6'] = '\u0037\u65E5';
    t['\u33E7'] = '\u0038\u65E5';
    t['\u33E8'] = '\u0039\u65E5';
    t['\u33E9'] = '\u0031\u0030\u65E5';
    t['\u33EA'] = '\u0031\u0031\u65E5';
    t['\u33EB'] = '\u0031\u0032\u65E5';
    t['\u33EC'] = '\u0031\u0033\u65E5';
    t['\u33ED'] = '\u0031\u0034\u65E5';
    t['\u33EE'] = '\u0031\u0035\u65E5';
    t['\u33EF'] = '\u0031\u0036\u65E5';
    t['\u33F0'] = '\u0031\u0037\u65E5';
    t['\u33F1'] = '\u0031\u0038\u65E5';
    t['\u33F2'] = '\u0031\u0039\u65E5';
    t['\u33F3'] = '\u0032\u0030\u65E5';
    t['\u33F4'] = '\u0032\u0031\u65E5';
    t['\u33F5'] = '\u0032\u0032\u65E5';
    t['\u33F6'] = '\u0032\u0033\u65E5';
    t['\u33F7'] = '\u0032\u0034\u65E5';
    t['\u33F8'] = '\u0032\u0035\u65E5';
    t['\u33F9'] = '\u0032\u0036\u65E5';
    t['\u33FA'] = '\u0032\u0037\u65E5';
    t['\u33FB'] = '\u0032\u0038\u65E5';
    t['\u33FC'] = '\u0032\u0039\u65E5';
    t['\u33FD'] = '\u0033\u0030\u65E5';
    t['\u33FE'] = '\u0033\u0031\u65E5';
    t['\uFB00'] = '\u0066\u0066';
    t['\uFB01'] = '\u0066\u0069';
    t['\uFB02'] = '\u0066\u006C';
    t['\uFB03'] = '\u0066\u0066\u0069';
    t['\uFB04'] = '\u0066\u0066\u006C';
    t['\uFB05'] = '\u017F\u0074';
    t['\uFB06'] = '\u0073\u0074';
    t['\uFB13'] = '\u0574\u0576';
    t['\uFB14'] = '\u0574\u0565';
    t['\uFB15'] = '\u0574\u056B';
    t['\uFB16'] = '\u057E\u0576';
    t['\uFB17'] = '\u0574\u056D';
    t['\uFB4F'] = '\u05D0\u05DC';
    t['\uFB50'] = '\u0671';
    t['\uFB51'] = '\u0671';
    t['\uFB52'] = '\u067B';
    t['\uFB53'] = '\u067B';
    t['\uFB54'] = '\u067B';
    t['\uFB55'] = '\u067B';
    t['\uFB56'] = '\u067E';
    t['\uFB57'] = '\u067E';
    t['\uFB58'] = '\u067E';
    t['\uFB59'] = '\u067E';
    t['\uFB5A'] = '\u0680';
    t['\uFB5B'] = '\u0680';
    t['\uFB5C'] = '\u0680';
    t['\uFB5D'] = '\u0680';
    t['\uFB5E'] = '\u067A';
    t['\uFB5F'] = '\u067A';
    t['\uFB60'] = '\u067A';
    t['\uFB61'] = '\u067A';
    t['\uFB62'] = '\u067F';
    t['\uFB63'] = '\u067F';
    t['\uFB64'] = '\u067F';
    t['\uFB65'] = '\u067F';
    t['\uFB66'] = '\u0679';
    t['\uFB67'] = '\u0679';
    t['\uFB68'] = '\u0679';
    t['\uFB69'] = '\u0679';
    t['\uFB6A'] = '\u06A4';
    t['\uFB6B'] = '\u06A4';
    t['\uFB6C'] = '\u06A4';
    t['\uFB6D'] = '\u06A4';
    t['\uFB6E'] = '\u06A6';
    t['\uFB6F'] = '\u06A6';
    t['\uFB70'] = '\u06A6';
    t['\uFB71'] = '\u06A6';
    t['\uFB72'] = '\u0684';
    t['\uFB73'] = '\u0684';
    t['\uFB74'] = '\u0684';
    t['\uFB75'] = '\u0684';
    t['\uFB76'] = '\u0683';
    t['\uFB77'] = '\u0683';
    t['\uFB78'] = '\u0683';
    t['\uFB79'] = '\u0683';
    t['\uFB7A'] = '\u0686';
    t['\uFB7B'] = '\u0686';
    t['\uFB7C'] = '\u0686';
    t['\uFB7D'] = '\u0686';
    t['\uFB7E'] = '\u0687';
    t['\uFB7F'] = '\u0687';
    t['\uFB80'] = '\u0687';
    t['\uFB81'] = '\u0687';
    t['\uFB82'] = '\u068D';
    t['\uFB83'] = '\u068D';
    t['\uFB84'] = '\u068C';
    t['\uFB85'] = '\u068C';
    t['\uFB86'] = '\u068E';
    t['\uFB87'] = '\u068E';
    t['\uFB88'] = '\u0688';
    t['\uFB89'] = '\u0688';
    t['\uFB8A'] = '\u0698';
    t['\uFB8B'] = '\u0698';
    t['\uFB8C'] = '\u0691';
    t['\uFB8D'] = '\u0691';
    t['\uFB8E'] = '\u06A9';
    t['\uFB8F'] = '\u06A9';
    t['\uFB90'] = '\u06A9';
    t['\uFB91'] = '\u06A9';
    t['\uFB92'] = '\u06AF';
    t['\uFB93'] = '\u06AF';
    t['\uFB94'] = '\u06AF';
    t['\uFB95'] = '\u06AF';
    t['\uFB96'] = '\u06B3';
    t['\uFB97'] = '\u06B3';
    t['\uFB98'] = '\u06B3';
    t['\uFB99'] = '\u06B3';
    t['\uFB9A'] = '\u06B1';
    t['\uFB9B'] = '\u06B1';
    t['\uFB9C'] = '\u06B1';
    t['\uFB9D'] = '\u06B1';
    t['\uFB9E'] = '\u06BA';
    t['\uFB9F'] = '\u06BA';
    t['\uFBA0'] = '\u06BB';
    t['\uFBA1'] = '\u06BB';
    t['\uFBA2'] = '\u06BB';
    t['\uFBA3'] = '\u06BB';
    t['\uFBA4'] = '\u06C0';
    t['\uFBA5'] = '\u06C0';
    t['\uFBA6'] = '\u06C1';
    t['\uFBA7'] = '\u06C1';
    t['\uFBA8'] = '\u06C1';
    t['\uFBA9'] = '\u06C1';
    t['\uFBAA'] = '\u06BE';
    t['\uFBAB'] = '\u06BE';
    t['\uFBAC'] = '\u06BE';
    t['\uFBAD'] = '\u06BE';
    t['\uFBAE'] = '\u06D2';
    t['\uFBAF'] = '\u06D2';
    t['\uFBB0'] = '\u06D3';
    t['\uFBB1'] = '\u06D3';
    t['\uFBD3'] = '\u06AD';
    t['\uFBD4'] = '\u06AD';
    t['\uFBD5'] = '\u06AD';
    t['\uFBD6'] = '\u06AD';
    t['\uFBD7'] = '\u06C7';
    t['\uFBD8'] = '\u06C7';
    t['\uFBD9'] = '\u06C6';
    t['\uFBDA'] = '\u06C6';
    t['\uFBDB'] = '\u06C8';
    t['\uFBDC'] = '\u06C8';
    t['\uFBDD'] = '\u0677';
    t['\uFBDE'] = '\u06CB';
    t['\uFBDF'] = '\u06CB';
    t['\uFBE0'] = '\u06C5';
    t['\uFBE1'] = '\u06C5';
    t['\uFBE2'] = '\u06C9';
    t['\uFBE3'] = '\u06C9';
    t['\uFBE4'] = '\u06D0';
    t['\uFBE5'] = '\u06D0';
    t['\uFBE6'] = '\u06D0';
    t['\uFBE7'] = '\u06D0';
    t['\uFBE8'] = '\u0649';
    t['\uFBE9'] = '\u0649';
    t['\uFBEA'] = '\u0626\u0627';
    t['\uFBEB'] = '\u0626\u0627';
    t['\uFBEC'] = '\u0626\u06D5';
    t['\uFBED'] = '\u0626\u06D5';
    t['\uFBEE'] = '\u0626\u0648';
    t['\uFBEF'] = '\u0626\u0648';
    t['\uFBF0'] = '\u0626\u06C7';
    t['\uFBF1'] = '\u0626\u06C7';
    t['\uFBF2'] = '\u0626\u06C6';
    t['\uFBF3'] = '\u0626\u06C6';
    t['\uFBF4'] = '\u0626\u06C8';
    t['\uFBF5'] = '\u0626\u06C8';
    t['\uFBF6'] = '\u0626\u06D0';
    t['\uFBF7'] = '\u0626\u06D0';
    t['\uFBF8'] = '\u0626\u06D0';
    t['\uFBF9'] = '\u0626\u0649';
    t['\uFBFA'] = '\u0626\u0649';
    t['\uFBFB'] = '\u0626\u0649';
    t['\uFBFC'] = '\u06CC';
    t['\uFBFD'] = '\u06CC';
    t['\uFBFE'] = '\u06CC';
    t['\uFBFF'] = '\u06CC';
    t['\uFC00'] = '\u0626\u062C';
    t['\uFC01'] = '\u0626\u062D';
    t['\uFC02'] = '\u0626\u0645';
    t['\uFC03'] = '\u0626\u0649';
    t['\uFC04'] = '\u0626\u064A';
    t['\uFC05'] = '\u0628\u062C';
    t['\uFC06'] = '\u0628\u062D';
    t['\uFC07'] = '\u0628\u062E';
    t['\uFC08'] = '\u0628\u0645';
    t['\uFC09'] = '\u0628\u0649';
    t['\uFC0A'] = '\u0628\u064A';
    t['\uFC0B'] = '\u062A\u062C';
    t['\uFC0C'] = '\u062A\u062D';
    t['\uFC0D'] = '\u062A\u062E';
    t['\uFC0E'] = '\u062A\u0645';
    t['\uFC0F'] = '\u062A\u0649';
    t['\uFC10'] = '\u062A\u064A';
    t['\uFC11'] = '\u062B\u062C';
    t['\uFC12'] = '\u062B\u0645';
    t['\uFC13'] = '\u062B\u0649';
    t['\uFC14'] = '\u062B\u064A';
    t['\uFC15'] = '\u062C\u062D';
    t['\uFC16'] = '\u062C\u0645';
    t['\uFC17'] = '\u062D\u062C';
    t['\uFC18'] = '\u062D\u0645';
    t['\uFC19'] = '\u062E\u062C';
    t['\uFC1A'] = '\u062E\u062D';
    t['\uFC1B'] = '\u062E\u0645';
    t['\uFC1C'] = '\u0633\u062C';
    t['\uFC1D'] = '\u0633\u062D';
    t['\uFC1E'] = '\u0633\u062E';
    t['\uFC1F'] = '\u0633\u0645';
    t['\uFC20'] = '\u0635\u062D';
    t['\uFC21'] = '\u0635\u0645';
    t['\uFC22'] = '\u0636\u062C';
    t['\uFC23'] = '\u0636\u062D';
    t['\uFC24'] = '\u0636\u062E';
    t['\uFC25'] = '\u0636\u0645';
    t['\uFC26'] = '\u0637\u062D';
    t['\uFC27'] = '\u0637\u0645';
    t['\uFC28'] = '\u0638\u0645';
    t['\uFC29'] = '\u0639\u062C';
    t['\uFC2A'] = '\u0639\u0645';
    t['\uFC2B'] = '\u063A\u062C';
    t['\uFC2C'] = '\u063A\u0645';
    t['\uFC2D'] = '\u0641\u062C';
    t['\uFC2E'] = '\u0641\u062D';
    t['\uFC2F'] = '\u0641\u062E';
    t['\uFC30'] = '\u0641\u0645';
    t['\uFC31'] = '\u0641\u0649';
    t['\uFC32'] = '\u0641\u064A';
    t['\uFC33'] = '\u0642\u062D';
    t['\uFC34'] = '\u0642\u0645';
    t['\uFC35'] = '\u0642\u0649';
    t['\uFC36'] = '\u0642\u064A';
    t['\uFC37'] = '\u0643\u0627';
    t['\uFC38'] = '\u0643\u062C';
    t['\uFC39'] = '\u0643\u062D';
    t['\uFC3A'] = '\u0643\u062E';
    t['\uFC3B'] = '\u0643\u0644';
    t['\uFC3C'] = '\u0643\u0645';
    t['\uFC3D'] = '\u0643\u0649';
    t['\uFC3E'] = '\u0643\u064A';
    t['\uFC3F'] = '\u0644\u062C';
    t['\uFC40'] = '\u0644\u062D';
    t['\uFC41'] = '\u0644\u062E';
    t['\uFC42'] = '\u0644\u0645';
    t['\uFC43'] = '\u0644\u0649';
    t['\uFC44'] = '\u0644\u064A';
    t['\uFC45'] = '\u0645\u062C';
    t['\uFC46'] = '\u0645\u062D';
    t['\uFC47'] = '\u0645\u062E';
    t['\uFC48'] = '\u0645\u0645';
    t['\uFC49'] = '\u0645\u0649';
    t['\uFC4A'] = '\u0645\u064A';
    t['\uFC4B'] = '\u0646\u062C';
    t['\uFC4C'] = '\u0646\u062D';
    t['\uFC4D'] = '\u0646\u062E';
    t['\uFC4E'] = '\u0646\u0645';
    t['\uFC4F'] = '\u0646\u0649';
    t['\uFC50'] = '\u0646\u064A';
    t['\uFC51'] = '\u0647\u062C';
    t['\uFC52'] = '\u0647\u0645';
    t['\uFC53'] = '\u0647\u0649';
    t['\uFC54'] = '\u0647\u064A';
    t['\uFC55'] = '\u064A\u062C';
    t['\uFC56'] = '\u064A\u062D';
    t['\uFC57'] = '\u064A\u062E';
    t['\uFC58'] = '\u064A\u0645';
    t['\uFC59'] = '\u064A\u0649';
    t['\uFC5A'] = '\u064A\u064A';
    t['\uFC5B'] = '\u0630\u0670';
    t['\uFC5C'] = '\u0631\u0670';
    t['\uFC5D'] = '\u0649\u0670';
    t['\uFC5E'] = '\u0020\u064C\u0651';
    t['\uFC5F'] = '\u0020\u064D\u0651';
    t['\uFC60'] = '\u0020\u064E\u0651';
    t['\uFC61'] = '\u0020\u064F\u0651';
    t['\uFC62'] = '\u0020\u0650\u0651';
    t['\uFC63'] = '\u0020\u0651\u0670';
    t['\uFC64'] = '\u0626\u0631';
    t['\uFC65'] = '\u0626\u0632';
    t['\uFC66'] = '\u0626\u0645';
    t['\uFC67'] = '\u0626\u0646';
    t['\uFC68'] = '\u0626\u0649';
    t['\uFC69'] = '\u0626\u064A';
    t['\uFC6A'] = '\u0628\u0631';
    t['\uFC6B'] = '\u0628\u0632';
    t['\uFC6C'] = '\u0628\u0645';
    t['\uFC6D'] = '\u0628\u0646';
    t['\uFC6E'] = '\u0628\u0649';
    t['\uFC6F'] = '\u0628\u064A';
    t['\uFC70'] = '\u062A\u0631';
    t['\uFC71'] = '\u062A\u0632';
    t['\uFC72'] = '\u062A\u0645';
    t['\uFC73'] = '\u062A\u0646';
    t['\uFC74'] = '\u062A\u0649';
    t['\uFC75'] = '\u062A\u064A';
    t['\uFC76'] = '\u062B\u0631';
    t['\uFC77'] = '\u062B\u0632';
    t['\uFC78'] = '\u062B\u0645';
    t['\uFC79'] = '\u062B\u0646';
    t['\uFC7A'] = '\u062B\u0649';
    t['\uFC7B'] = '\u062B\u064A';
    t['\uFC7C'] = '\u0641\u0649';
    t['\uFC7D'] = '\u0641\u064A';
    t['\uFC7E'] = '\u0642\u0649';
    t['\uFC7F'] = '\u0642\u064A';
    t['\uFC80'] = '\u0643\u0627';
    t['\uFC81'] = '\u0643\u0644';
    t['\uFC82'] = '\u0643\u0645';
    t['\uFC83'] = '\u0643\u0649';
    t['\uFC84'] = '\u0643\u064A';
    t['\uFC85'] = '\u0644\u0645';
    t['\uFC86'] = '\u0644\u0649';
    t['\uFC87'] = '\u0644\u064A';
    t['\uFC88'] = '\u0645\u0627';
    t['\uFC89'] = '\u0645\u0645';
    t['\uFC8A'] = '\u0646\u0631';
    t['\uFC8B'] = '\u0646\u0632';
    t['\uFC8C'] = '\u0646\u0645';
    t['\uFC8D'] = '\u0646\u0646';
    t['\uFC8E'] = '\u0646\u0649';
    t['\uFC8F'] = '\u0646\u064A';
    t['\uFC90'] = '\u0649\u0670';
    t['\uFC91'] = '\u064A\u0631';
    t['\uFC92'] = '\u064A\u0632';
    t['\uFC93'] = '\u064A\u0645';
    t['\uFC94'] = '\u064A\u0646';
    t['\uFC95'] = '\u064A\u0649';
    t['\uFC96'] = '\u064A\u064A';
    t['\uFC97'] = '\u0626\u062C';
    t['\uFC98'] = '\u0626\u062D';
    t['\uFC99'] = '\u0626\u062E';
    t['\uFC9A'] = '\u0626\u0645';
    t['\uFC9B'] = '\u0626\u0647';
    t['\uFC9C'] = '\u0628\u062C';
    t['\uFC9D'] = '\u0628\u062D';
    t['\uFC9E'] = '\u0628\u062E';
    t['\uFC9F'] = '\u0628\u0645';
    t['\uFCA0'] = '\u0628\u0647';
    t['\uFCA1'] = '\u062A\u062C';
    t['\uFCA2'] = '\u062A\u062D';
    t['\uFCA3'] = '\u062A\u062E';
    t['\uFCA4'] = '\u062A\u0645';
    t['\uFCA5'] = '\u062A\u0647';
    t['\uFCA6'] = '\u062B\u0645';
    t['\uFCA7'] = '\u062C\u062D';
    t['\uFCA8'] = '\u062C\u0645';
    t['\uFCA9'] = '\u062D\u062C';
    t['\uFCAA'] = '\u062D\u0645';
    t['\uFCAB'] = '\u062E\u062C';
    t['\uFCAC'] = '\u062E\u0645';
    t['\uFCAD'] = '\u0633\u062C';
    t['\uFCAE'] = '\u0633\u062D';
    t['\uFCAF'] = '\u0633\u062E';
    t['\uFCB0'] = '\u0633\u0645';
    t['\uFCB1'] = '\u0635\u062D';
    t['\uFCB2'] = '\u0635\u062E';
    t['\uFCB3'] = '\u0635\u0645';
    t['\uFCB4'] = '\u0636\u062C';
    t['\uFCB5'] = '\u0636\u062D';
    t['\uFCB6'] = '\u0636\u062E';
    t['\uFCB7'] = '\u0636\u0645';
    t['\uFCB8'] = '\u0637\u062D';
    t['\uFCB9'] = '\u0638\u0645';
    t['\uFCBA'] = '\u0639\u062C';
    t['\uFCBB'] = '\u0639\u0645';
    t['\uFCBC'] = '\u063A\u062C';
    t['\uFCBD'] = '\u063A\u0645';
    t['\uFCBE'] = '\u0641\u062C';
    t['\uFCBF'] = '\u0641\u062D';
    t['\uFCC0'] = '\u0641\u062E';
    t['\uFCC1'] = '\u0641\u0645';
    t['\uFCC2'] = '\u0642\u062D';
    t['\uFCC3'] = '\u0642\u0645';
    t['\uFCC4'] = '\u0643\u062C';
    t['\uFCC5'] = '\u0643\u062D';
    t['\uFCC6'] = '\u0643\u062E';
    t['\uFCC7'] = '\u0643\u0644';
    t['\uFCC8'] = '\u0643\u0645';
    t['\uFCC9'] = '\u0644\u062C';
    t['\uFCCA'] = '\u0644\u062D';
    t['\uFCCB'] = '\u0644\u062E';
    t['\uFCCC'] = '\u0644\u0645';
    t['\uFCCD'] = '\u0644\u0647';
    t['\uFCCE'] = '\u0645\u062C';
    t['\uFCCF'] = '\u0645\u062D';
    t['\uFCD0'] = '\u0645\u062E';
    t['\uFCD1'] = '\u0645\u0645';
    t['\uFCD2'] = '\u0646\u062C';
    t['\uFCD3'] = '\u0646\u062D';
    t['\uFCD4'] = '\u0646\u062E';
    t['\uFCD5'] = '\u0646\u0645';
    t['\uFCD6'] = '\u0646\u0647';
    t['\uFCD7'] = '\u0647\u062C';
    t['\uFCD8'] = '\u0647\u0645';
    t['\uFCD9'] = '\u0647\u0670';
    t['\uFCDA'] = '\u064A\u062C';
    t['\uFCDB'] = '\u064A\u062D';
    t['\uFCDC'] = '\u064A\u062E';
    t['\uFCDD'] = '\u064A\u0645';
    t['\uFCDE'] = '\u064A\u0647';
    t['\uFCDF'] = '\u0626\u0645';
    t['\uFCE0'] = '\u0626\u0647';
    t['\uFCE1'] = '\u0628\u0645';
    t['\uFCE2'] = '\u0628\u0647';
    t['\uFCE3'] = '\u062A\u0645';
    t['\uFCE4'] = '\u062A\u0647';
    t['\uFCE5'] = '\u062B\u0645';
    t['\uFCE6'] = '\u062B\u0647';
    t['\uFCE7'] = '\u0633\u0645';
    t['\uFCE8'] = '\u0633\u0647';
    t['\uFCE9'] = '\u0634\u0645';
    t['\uFCEA'] = '\u0634\u0647';
    t['\uFCEB'] = '\u0643\u0644';
    t['\uFCEC'] = '\u0643\u0645';
    t['\uFCED'] = '\u0644\u0645';
    t['\uFCEE'] = '\u0646\u0645';
    t['\uFCEF'] = '\u0646\u0647';
    t['\uFCF0'] = '\u064A\u0645';
    t['\uFCF1'] = '\u064A\u0647';
    t['\uFCF2'] = '\u0640\u064E\u0651';
    t['\uFCF3'] = '\u0640\u064F\u0651';
    t['\uFCF4'] = '\u0640\u0650\u0651';
    t['\uFCF5'] = '\u0637\u0649';
    t['\uFCF6'] = '\u0637\u064A';
    t['\uFCF7'] = '\u0639\u0649';
    t['\uFCF8'] = '\u0639\u064A';
    t['\uFCF9'] = '\u063A\u0649';
    t['\uFCFA'] = '\u063A\u064A';
    t['\uFCFB'] = '\u0633\u0649';
    t['\uFCFC'] = '\u0633\u064A';
    t['\uFCFD'] = '\u0634\u0649';
    t['\uFCFE'] = '\u0634\u064A';
    t['\uFCFF'] = '\u062D\u0649';
    t['\uFD00'] = '\u062D\u064A';
    t['\uFD01'] = '\u062C\u0649';
    t['\uFD02'] = '\u062C\u064A';
    t['\uFD03'] = '\u062E\u0649';
    t['\uFD04'] = '\u062E\u064A';
    t['\uFD05'] = '\u0635\u0649';
    t['\uFD06'] = '\u0635\u064A';
    t['\uFD07'] = '\u0636\u0649';
    t['\uFD08'] = '\u0636\u064A';
    t['\uFD09'] = '\u0634\u062C';
    t['\uFD0A'] = '\u0634\u062D';
    t['\uFD0B'] = '\u0634\u062E';
    t['\uFD0C'] = '\u0634\u0645';
    t['\uFD0D'] = '\u0634\u0631';
    t['\uFD0E'] = '\u0633\u0631';
    t['\uFD0F'] = '\u0635\u0631';
    t['\uFD10'] = '\u0636\u0631';
    t['\uFD11'] = '\u0637\u0649';
    t['\uFD12'] = '\u0637\u064A';
    t['\uFD13'] = '\u0639\u0649';
    t['\uFD14'] = '\u0639\u064A';
    t['\uFD15'] = '\u063A\u0649';
    t['\uFD16'] = '\u063A\u064A';
    t['\uFD17'] = '\u0633\u0649';
    t['\uFD18'] = '\u0633\u064A';
    t['\uFD19'] = '\u0634\u0649';
    t['\uFD1A'] = '\u0634\u064A';
    t['\uFD1B'] = '\u062D\u0649';
    t['\uFD1C'] = '\u062D\u064A';
    t['\uFD1D'] = '\u062C\u0649';
    t['\uFD1E'] = '\u062C\u064A';
    t['\uFD1F'] = '\u062E\u0649';
    t['\uFD20'] = '\u062E\u064A';
    t['\uFD21'] = '\u0635\u0649';
    t['\uFD22'] = '\u0635\u064A';
    t['\uFD23'] = '\u0636\u0649';
    t['\uFD24'] = '\u0636\u064A';
    t['\uFD25'] = '\u0634\u062C';
    t['\uFD26'] = '\u0634\u062D';
    t['\uFD27'] = '\u0634\u062E';
    t['\uFD28'] = '\u0634\u0645';
    t['\uFD29'] = '\u0634\u0631';
    t['\uFD2A'] = '\u0633\u0631';
    t['\uFD2B'] = '\u0635\u0631';
    t['\uFD2C'] = '\u0636\u0631';
    t['\uFD2D'] = '\u0634\u062C';
    t['\uFD2E'] = '\u0634\u062D';
    t['\uFD2F'] = '\u0634\u062E';
    t['\uFD30'] = '\u0634\u0645';
    t['\uFD31'] = '\u0633\u0647';
    t['\uFD32'] = '\u0634\u0647';
    t['\uFD33'] = '\u0637\u0645';
    t['\uFD34'] = '\u0633\u062C';
    t['\uFD35'] = '\u0633\u062D';
    t['\uFD36'] = '\u0633\u062E';
    t['\uFD37'] = '\u0634\u062C';
    t['\uFD38'] = '\u0634\u062D';
    t['\uFD39'] = '\u0634\u062E';
    t['\uFD3A'] = '\u0637\u0645';
    t['\uFD3B'] = '\u0638\u0645';
    t['\uFD3C'] = '\u0627\u064B';
    t['\uFD3D'] = '\u0627\u064B';
    t['\uFD50'] = '\u062A\u062C\u0645';
    t['\uFD51'] = '\u062A\u062D\u062C';
    t['\uFD52'] = '\u062A\u062D\u062C';
    t['\uFD53'] = '\u062A\u062D\u0645';
    t['\uFD54'] = '\u062A\u062E\u0645';
    t['\uFD55'] = '\u062A\u0645\u062C';
    t['\uFD56'] = '\u062A\u0645\u062D';
    t['\uFD57'] = '\u062A\u0645\u062E';
    t['\uFD58'] = '\u062C\u0645\u062D';
    t['\uFD59'] = '\u062C\u0645\u062D';
    t['\uFD5A'] = '\u062D\u0645\u064A';
    t['\uFD5B'] = '\u062D\u0645\u0649';
    t['\uFD5C'] = '\u0633\u062D\u062C';
    t['\uFD5D'] = '\u0633\u062C\u062D';
    t['\uFD5E'] = '\u0633\u062C\u0649';
    t['\uFD5F'] = '\u0633\u0645\u062D';
    t['\uFD60'] = '\u0633\u0645\u062D';
    t['\uFD61'] = '\u0633\u0645\u062C';
    t['\uFD62'] = '\u0633\u0645\u0645';
    t['\uFD63'] = '\u0633\u0645\u0645';
    t['\uFD64'] = '\u0635\u062D\u062D';
    t['\uFD65'] = '\u0635\u062D\u062D';
    t['\uFD66'] = '\u0635\u0645\u0645';
    t['\uFD67'] = '\u0634\u062D\u0645';
    t['\uFD68'] = '\u0634\u062D\u0645';
    t['\uFD69'] = '\u0634\u062C\u064A';
    t['\uFD6A'] = '\u0634\u0645\u062E';
    t['\uFD6B'] = '\u0634\u0645\u062E';
    t['\uFD6C'] = '\u0634\u0645\u0645';
    t['\uFD6D'] = '\u0634\u0645\u0645';
    t['\uFD6E'] = '\u0636\u062D\u0649';
    t['\uFD6F'] = '\u0636\u062E\u0645';
    t['\uFD70'] = '\u0636\u062E\u0645';
    t['\uFD71'] = '\u0637\u0645\u062D';
    t['\uFD72'] = '\u0637\u0645\u062D';
    t['\uFD73'] = '\u0637\u0645\u0645';
    t['\uFD74'] = '\u0637\u0645\u064A';
    t['\uFD75'] = '\u0639\u062C\u0645';
    t['\uFD76'] = '\u0639\u0645\u0645';
    t['\uFD77'] = '\u0639\u0645\u0645';
    t['\uFD78'] = '\u0639\u0645\u0649';
    t['\uFD79'] = '\u063A\u0645\u0645';
    t['\uFD7A'] = '\u063A\u0645\u064A';
    t['\uFD7B'] = '\u063A\u0645\u0649';
    t['\uFD7C'] = '\u0641\u062E\u0645';
    t['\uFD7D'] = '\u0641\u062E\u0645';
    t['\uFD7E'] = '\u0642\u0645\u062D';
    t['\uFD7F'] = '\u0642\u0645\u0645';
    t['\uFD80'] = '\u0644\u062D\u0645';
    t['\uFD81'] = '\u0644\u062D\u064A';
    t['\uFD82'] = '\u0644\u062D\u0649';
    t['\uFD83'] = '\u0644\u062C\u062C';
    t['\uFD84'] = '\u0644\u062C\u062C';
    t['\uFD85'] = '\u0644\u062E\u0645';
    t['\uFD86'] = '\u0644\u062E\u0645';
    t['\uFD87'] = '\u0644\u0645\u062D';
    t['\uFD88'] = '\u0644\u0645\u062D';
    t['\uFD89'] = '\u0645\u062D\u062C';
    t['\uFD8A'] = '\u0645\u062D\u0645';
    t['\uFD8B'] = '\u0645\u062D\u064A';
    t['\uFD8C'] = '\u0645\u062C\u062D';
    t['\uFD8D'] = '\u0645\u062C\u0645';
    t['\uFD8E'] = '\u0645\u062E\u062C';
    t['\uFD8F'] = '\u0645\u062E\u0645';
    t['\uFD92'] = '\u0645\u062C\u062E';
    t['\uFD93'] = '\u0647\u0645\u062C';
    t['\uFD94'] = '\u0647\u0645\u0645';
    t['\uFD95'] = '\u0646\u062D\u0645';
    t['\uFD96'] = '\u0646\u062D\u0649';
    t['\uFD97'] = '\u0646\u062C\u0645';
    t['\uFD98'] = '\u0646\u062C\u0645';
    t['\uFD99'] = '\u0646\u062C\u0649';
    t['\uFD9A'] = '\u0646\u0645\u064A';
    t['\uFD9B'] = '\u0646\u0645\u0649';
    t['\uFD9C'] = '\u064A\u0645\u0645';
    t['\uFD9D'] = '\u064A\u0645\u0645';
    t['\uFD9E'] = '\u0628\u062E\u064A';
    t['\uFD9F'] = '\u062A\u062C\u064A';
    t['\uFDA0'] = '\u062A\u062C\u0649';
    t['\uFDA1'] = '\u062A\u062E\u064A';
    t['\uFDA2'] = '\u062A\u062E\u0649';
    t['\uFDA3'] = '\u062A\u0645\u064A';
    t['\uFDA4'] = '\u062A\u0645\u0649';
    t['\uFDA5'] = '\u062C\u0645\u064A';
    t['\uFDA6'] = '\u062C\u062D\u0649';
    t['\uFDA7'] = '\u062C\u0645\u0649';
    t['\uFDA8'] = '\u0633\u062E\u0649';
    t['\uFDA9'] = '\u0635\u062D\u064A';
    t['\uFDAA'] = '\u0634\u062D\u064A';
    t['\uFDAB'] = '\u0636\u062D\u064A';
    t['\uFDAC'] = '\u0644\u062C\u064A';
    t['\uFDAD'] = '\u0644\u0645\u064A';
    t['\uFDAE'] = '\u064A\u062D\u064A';
    t['\uFDAF'] = '\u064A\u062C\u064A';
    t['\uFDB0'] = '\u064A\u0645\u064A';
    t['\uFDB1'] = '\u0645\u0645\u064A';
    t['\uFDB2'] = '\u0642\u0645\u064A';
    t['\uFDB3'] = '\u0646\u062D\u064A';
    t['\uFDB4'] = '\u0642\u0645\u062D';
    t['\uFDB5'] = '\u0644\u062D\u0645';
    t['\uFDB6'] = '\u0639\u0645\u064A';
    t['\uFDB7'] = '\u0643\u0645\u064A';
    t['\uFDB8'] = '\u0646\u062C\u062D';
    t['\uFDB9'] = '\u0645\u062E\u064A';
    t['\uFDBA'] = '\u0644\u062C\u0645';
    t['\uFDBB'] = '\u0643\u0645\u0645';
    t['\uFDBC'] = '\u0644\u062C\u0645';
    t['\uFDBD'] = '\u0646\u062C\u062D';
    t['\uFDBE'] = '\u062C\u062D\u064A';
    t['\uFDBF'] = '\u062D\u062C\u064A';
    t['\uFDC0'] = '\u0645\u062C\u064A';
    t['\uFDC1'] = '\u0641\u0645\u064A';
    t['\uFDC2'] = '\u0628\u062D\u064A';
    t['\uFDC3'] = '\u0643\u0645\u0645';
    t['\uFDC4'] = '\u0639\u062C\u0645';
    t['\uFDC5'] = '\u0635\u0645\u0645';
    t['\uFDC6'] = '\u0633\u062E\u064A';
    t['\uFDC7'] = '\u0646\u062C\u064A';
    t['\uFE49'] = '\u203E';
    t['\uFE4A'] = '\u203E';
    t['\uFE4B'] = '\u203E';
    t['\uFE4C'] = '\u203E';
    t['\uFE4D'] = '\u005F';
    t['\uFE4E'] = '\u005F';
    t['\uFE4F'] = '\u005F';
    t['\uFE80'] = '\u0621';
    t['\uFE81'] = '\u0622';
    t['\uFE82'] = '\u0622';
    t['\uFE83'] = '\u0623';
    t['\uFE84'] = '\u0623';
    t['\uFE85'] = '\u0624';
    t['\uFE86'] = '\u0624';
    t['\uFE87'] = '\u0625';
    t['\uFE88'] = '\u0625';
    t['\uFE89'] = '\u0626';
    t['\uFE8A'] = '\u0626';
    t['\uFE8B'] = '\u0626';
    t['\uFE8C'] = '\u0626';
    t['\uFE8D'] = '\u0627';
    t['\uFE8E'] = '\u0627';
    t['\uFE8F'] = '\u0628';
    t['\uFE90'] = '\u0628';
    t['\uFE91'] = '\u0628';
    t['\uFE92'] = '\u0628';
    t['\uFE93'] = '\u0629';
    t['\uFE94'] = '\u0629';
    t['\uFE95'] = '\u062A';
    t['\uFE96'] = '\u062A';
    t['\uFE97'] = '\u062A';
    t['\uFE98'] = '\u062A';
    t['\uFE99'] = '\u062B';
    t['\uFE9A'] = '\u062B';
    t['\uFE9B'] = '\u062B';
    t['\uFE9C'] = '\u062B';
    t['\uFE9D'] = '\u062C';
    t['\uFE9E'] = '\u062C';
    t['\uFE9F'] = '\u062C';
    t['\uFEA0'] = '\u062C';
    t['\uFEA1'] = '\u062D';
    t['\uFEA2'] = '\u062D';
    t['\uFEA3'] = '\u062D';
    t['\uFEA4'] = '\u062D';
    t['\uFEA5'] = '\u062E';
    t['\uFEA6'] = '\u062E';
    t['\uFEA7'] = '\u062E';
    t['\uFEA8'] = '\u062E';
    t['\uFEA9'] = '\u062F';
    t['\uFEAA'] = '\u062F';
    t['\uFEAB'] = '\u0630';
    t['\uFEAC'] = '\u0630';
    t['\uFEAD'] = '\u0631';
    t['\uFEAE'] = '\u0631';
    t['\uFEAF'] = '\u0632';
    t['\uFEB0'] = '\u0632';
    t['\uFEB1'] = '\u0633';
    t['\uFEB2'] = '\u0633';
    t['\uFEB3'] = '\u0633';
    t['\uFEB4'] = '\u0633';
    t['\uFEB5'] = '\u0634';
    t['\uFEB6'] = '\u0634';
    t['\uFEB7'] = '\u0634';
    t['\uFEB8'] = '\u0634';
    t['\uFEB9'] = '\u0635';
    t['\uFEBA'] = '\u0635';
    t['\uFEBB'] = '\u0635';
    t['\uFEBC'] = '\u0635';
    t['\uFEBD'] = '\u0636';
    t['\uFEBE'] = '\u0636';
    t['\uFEBF'] = '\u0636';
    t['\uFEC0'] = '\u0636';
    t['\uFEC1'] = '\u0637';
    t['\uFEC2'] = '\u0637';
    t['\uFEC3'] = '\u0637';
    t['\uFEC4'] = '\u0637';
    t['\uFEC5'] = '\u0638';
    t['\uFEC6'] = '\u0638';
    t['\uFEC7'] = '\u0638';
    t['\uFEC8'] = '\u0638';
    t['\uFEC9'] = '\u0639';
    t['\uFECA'] = '\u0639';
    t['\uFECB'] = '\u0639';
    t['\uFECC'] = '\u0639';
    t['\uFECD'] = '\u063A';
    t['\uFECE'] = '\u063A';
    t['\uFECF'] = '\u063A';
    t['\uFED0'] = '\u063A';
    t['\uFED1'] = '\u0641';
    t['\uFED2'] = '\u0641';
    t['\uFED3'] = '\u0641';
    t['\uFED4'] = '\u0641';
    t['\uFED5'] = '\u0642';
    t['\uFED6'] = '\u0642';
    t['\uFED7'] = '\u0642';
    t['\uFED8'] = '\u0642';
    t['\uFED9'] = '\u0643';
    t['\uFEDA'] = '\u0643';
    t['\uFEDB'] = '\u0643';
    t['\uFEDC'] = '\u0643';
    t['\uFEDD'] = '\u0644';
    t['\uFEDE'] = '\u0644';
    t['\uFEDF'] = '\u0644';
    t['\uFEE0'] = '\u0644';
    t['\uFEE1'] = '\u0645';
    t['\uFEE2'] = '\u0645';
    t['\uFEE3'] = '\u0645';
    t['\uFEE4'] = '\u0645';
    t['\uFEE5'] = '\u0646';
    t['\uFEE6'] = '\u0646';
    t['\uFEE7'] = '\u0646';
    t['\uFEE8'] = '\u0646';
    t['\uFEE9'] = '\u0647';
    t['\uFEEA'] = '\u0647';
    t['\uFEEB'] = '\u0647';
    t['\uFEEC'] = '\u0647';
    t['\uFEED'] = '\u0648';
    t['\uFEEE'] = '\u0648';
    t['\uFEEF'] = '\u0649';
    t['\uFEF0'] = '\u0649';
    t['\uFEF1'] = '\u064A';
    t['\uFEF2'] = '\u064A';
    t['\uFEF3'] = '\u064A';
    t['\uFEF4'] = '\u064A';
    t['\uFEF5'] = '\u0644\u0622';
    t['\uFEF6'] = '\u0644\u0622';
    t['\uFEF7'] = '\u0644\u0623';
    t['\uFEF8'] = '\u0644\u0623';
    t['\uFEF9'] = '\u0644\u0625';
    t['\uFEFA'] = '\u0644\u0625';
    t['\uFEFB'] = '\u0644\u0627';
    t['\uFEFC'] = '\u0644\u0627';
  });

  function reverseIfRtl(chars) {
    var charsLength = chars.length;
    //reverse an arabic ligature
    if (charsLength <= 1 || !isRTLRangeFor(chars.charCodeAt(0))) {
      return chars;
    }
    var s = '';
    for (var ii = charsLength - 1; ii >= 0; ii--) {
      s += chars[ii];
    }
    return s;
  }

  exports.mapSpecialUnicodeValues = mapSpecialUnicodeValues;
  exports.reverseIfRtl = reverseIfRtl;
  exports.getUnicodeRangeFor = getUnicodeRangeFor;
  exports.getNormalizedUnicodes = getNormalizedUnicodes;
  exports.getUnicodeForGlyph = getUnicodeForGlyph;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreStream = {}), root.pdfjsSharedUtil,
      root.pdfjsCorePrimitives, root.pdfjsCoreJbig2, root.pdfjsCoreJpg,
      root.pdfjsCoreJpx);
  }
}(this, function (exports, sharedUtil, corePrimitives, coreJbig2, coreJpg,
                  coreJpx) {

var Util = sharedUtil.Util;
var error = sharedUtil.error;
var info = sharedUtil.info;
var isArray = sharedUtil.isArray;
var createObjectURL = sharedUtil.createObjectURL;
var shadow = sharedUtil.shadow;
var warn = sharedUtil.warn;
var isSpace = sharedUtil.isSpace;
var Dict = corePrimitives.Dict;
var isDict = corePrimitives.isDict;
var Jbig2Image = coreJbig2.Jbig2Image;
var JpegImage = coreJpg.JpegImage;
var JpxImage = coreJpx.JpxImage;

var Stream = (function StreamClosure() {
  function Stream(arrayBuffer, start, length, dict) {
    this.bytes = (arrayBuffer instanceof Uint8Array ?
                  arrayBuffer : new Uint8Array(arrayBuffer));
    this.start = start || 0;
    this.pos = this.start;
    this.end = (start + length) || this.bytes.length;
    this.dict = dict;
  }

  // required methods for a stream. if a particular stream does not
  // implement these, an error should be thrown
  Stream.prototype = {
    get length() {
      return this.end - this.start;
    },
    get isEmpty() {
      return this.length === 0;
    },
    getByte: function Stream_getByte() {
      if (this.pos >= this.end) {
        return -1;
      }
      return this.bytes[this.pos++];
    },
    getUint16: function Stream_getUint16() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      if (b0 === -1 || b1 === -1) {
        return -1;
      }
      return (b0 << 8) + b1;
    },
    getInt32: function Stream_getInt32() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      var b2 = this.getByte();
      var b3 = this.getByte();
      return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    },
    // returns subarray of original buffer
    // should only be read
    getBytes: function Stream_getBytes(length) {
      var bytes = this.bytes;
      var pos = this.pos;
      var strEnd = this.end;

      if (!length) {
        return bytes.subarray(pos, strEnd);
      }
      var end = pos + length;
      if (end > strEnd) {
        end = strEnd;
      }
      this.pos = end;
      return bytes.subarray(pos, end);
    },
    peekByte: function Stream_peekByte() {
      var peekedByte = this.getByte();
      this.pos--;
      return peekedByte;
    },
    peekBytes: function Stream_peekBytes(length) {
      var bytes = this.getBytes(length);
      this.pos -= bytes.length;
      return bytes;
    },
    skip: function Stream_skip(n) {
      if (!n) {
        n = 1;
      }
      this.pos += n;
    },
    reset: function Stream_reset() {
      this.pos = this.start;
    },
    moveStart: function Stream_moveStart() {
      this.start = this.pos;
    },
    makeSubStream: function Stream_makeSubStream(start, length, dict) {
      return new Stream(this.bytes.buffer, start, length, dict);
    },
    isStream: true
  };

  return Stream;
})();

var StringStream = (function StringStreamClosure() {
  function StringStream(str) {
    var length = str.length;
    var bytes = new Uint8Array(length);
    for (var n = 0; n < length; ++n) {
      bytes[n] = str.charCodeAt(n);
    }
    Stream.call(this, bytes);
  }

  StringStream.prototype = Stream.prototype;

  return StringStream;
})();

// super class for the decoding streams
var DecodeStream = (function DecodeStreamClosure() {
  // Lots of DecodeStreams are created whose buffers are never used.  For these
  // we share a single empty buffer. This is (a) space-efficient and (b) avoids
  // having special cases that would be required if we used |null| for an empty
  // buffer.
  var emptyBuffer = new Uint8Array(0);

  function DecodeStream(maybeMinBufferLength) {
    this.pos = 0;
    this.bufferLength = 0;
    this.eof = false;
    this.buffer = emptyBuffer;
    this.minBufferLength = 512;
    if (maybeMinBufferLength) {
      // Compute the first power of two that is as big as maybeMinBufferLength.
      while (this.minBufferLength < maybeMinBufferLength) {
        this.minBufferLength *= 2;
      }
    }
  }

  DecodeStream.prototype = {
    get isEmpty() {
      while (!this.eof && this.bufferLength === 0) {
        this.readBlock();
      }
      return this.bufferLength === 0;
    },
    ensureBuffer: function DecodeStream_ensureBuffer(requested) {
      var buffer = this.buffer;
      if (requested <= buffer.byteLength) {
        return buffer;
      }
      var size = this.minBufferLength;
      while (size < requested) {
        size *= 2;
      }
      var buffer2 = new Uint8Array(size);
      buffer2.set(buffer);
      return (this.buffer = buffer2);
    },
    getByte: function DecodeStream_getByte() {
      var pos = this.pos;
      while (this.bufferLength <= pos) {
        if (this.eof) {
          return -1;
        }
        this.readBlock();
      }
      return this.buffer[this.pos++];
    },
    getUint16: function DecodeStream_getUint16() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      if (b0 === -1 || b1 === -1) {
        return -1;
      }
      return (b0 << 8) + b1;
    },
    getInt32: function DecodeStream_getInt32() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      var b2 = this.getByte();
      var b3 = this.getByte();
      return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    },
    getBytes: function DecodeStream_getBytes(length) {
      var end, pos = this.pos;

      if (length) {
        this.ensureBuffer(pos + length);
        end = pos + length;

        while (!this.eof && this.bufferLength < end) {
          this.readBlock();
        }
        var bufEnd = this.bufferLength;
        if (end > bufEnd) {
          end = bufEnd;
        }
      } else {
        while (!this.eof) {
          this.readBlock();
        }
        end = this.bufferLength;
      }

      this.pos = end;
      return this.buffer.subarray(pos, end);
    },
    peekByte: function DecodeStream_peekByte() {
      var peekedByte = this.getByte();
      this.pos--;
      return peekedByte;
    },
    peekBytes: function DecodeStream_peekBytes(length) {
      var bytes = this.getBytes(length);
      this.pos -= bytes.length;
      return bytes;
    },
    makeSubStream: function DecodeStream_makeSubStream(start, length, dict) {
      var end = start + length;
      while (this.bufferLength <= end && !this.eof) {
        this.readBlock();
      }
      return new Stream(this.buffer, start, length, dict);
    },
    skip: function DecodeStream_skip(n) {
      if (!n) {
        n = 1;
      }
      this.pos += n;
    },
    reset: function DecodeStream_reset() {
      this.pos = 0;
    },
    getBaseStreams: function DecodeStream_getBaseStreams() {
      if (this.str && this.str.getBaseStreams) {
        return this.str.getBaseStreams();
      }
      return [];
    }
  };

  return DecodeStream;
})();

var StreamsSequenceStream = (function StreamsSequenceStreamClosure() {
  function StreamsSequenceStream(streams) {
    this.streams = streams;
    DecodeStream.call(this, /* maybeLength = */ null);
  }

  StreamsSequenceStream.prototype = Object.create(DecodeStream.prototype);

  StreamsSequenceStream.prototype.readBlock =
      function streamSequenceStreamReadBlock() {

    var streams = this.streams;
    if (streams.length === 0) {
      this.eof = true;
      return;
    }
    var stream = streams.shift();
    var chunk = stream.getBytes();
    var bufferLength = this.bufferLength;
    var newLength = bufferLength + chunk.length;
    var buffer = this.ensureBuffer(newLength);
    buffer.set(chunk, bufferLength);
    this.bufferLength = newLength;
  };

  StreamsSequenceStream.prototype.getBaseStreams =
    function StreamsSequenceStream_getBaseStreams() {

    var baseStreams = [];
    for (var i = 0, ii = this.streams.length; i < ii; i++) {
      var stream = this.streams[i];
      if (stream.getBaseStreams) {
        Util.appendToArray(baseStreams, stream.getBaseStreams());
      }
    }
    return baseStreams;
  };

  return StreamsSequenceStream;
})();

var FlateStream = (function FlateStreamClosure() {
  var codeLenCodeMap = new Int32Array([
    16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15
  ]);

  var lengthDecode = new Int32Array([
    0x00003, 0x00004, 0x00005, 0x00006, 0x00007, 0x00008, 0x00009, 0x0000a,
    0x1000b, 0x1000d, 0x1000f, 0x10011, 0x20013, 0x20017, 0x2001b, 0x2001f,
    0x30023, 0x3002b, 0x30033, 0x3003b, 0x40043, 0x40053, 0x40063, 0x40073,
    0x50083, 0x500a3, 0x500c3, 0x500e3, 0x00102, 0x00102, 0x00102
  ]);

  var distDecode = new Int32Array([
    0x00001, 0x00002, 0x00003, 0x00004, 0x10005, 0x10007, 0x20009, 0x2000d,
    0x30011, 0x30019, 0x40021, 0x40031, 0x50041, 0x50061, 0x60081, 0x600c1,
    0x70101, 0x70181, 0x80201, 0x80301, 0x90401, 0x90601, 0xa0801, 0xa0c01,
    0xb1001, 0xb1801, 0xc2001, 0xc3001, 0xd4001, 0xd6001
  ]);

  var fixedLitCodeTab = [new Int32Array([
    0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c0,
    0x70108, 0x80060, 0x80020, 0x900a0, 0x80000, 0x80080, 0x80040, 0x900e0,
    0x70104, 0x80058, 0x80018, 0x90090, 0x70114, 0x80078, 0x80038, 0x900d0,
    0x7010c, 0x80068, 0x80028, 0x900b0, 0x80008, 0x80088, 0x80048, 0x900f0,
    0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c8,
    0x7010a, 0x80064, 0x80024, 0x900a8, 0x80004, 0x80084, 0x80044, 0x900e8,
    0x70106, 0x8005c, 0x8001c, 0x90098, 0x70116, 0x8007c, 0x8003c, 0x900d8,
    0x7010e, 0x8006c, 0x8002c, 0x900b8, 0x8000c, 0x8008c, 0x8004c, 0x900f8,
    0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c4,
    0x70109, 0x80062, 0x80022, 0x900a4, 0x80002, 0x80082, 0x80042, 0x900e4,
    0x70105, 0x8005a, 0x8001a, 0x90094, 0x70115, 0x8007a, 0x8003a, 0x900d4,
    0x7010d, 0x8006a, 0x8002a, 0x900b4, 0x8000a, 0x8008a, 0x8004a, 0x900f4,
    0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cc,
    0x7010b, 0x80066, 0x80026, 0x900ac, 0x80006, 0x80086, 0x80046, 0x900ec,
    0x70107, 0x8005e, 0x8001e, 0x9009c, 0x70117, 0x8007e, 0x8003e, 0x900dc,
    0x7010f, 0x8006e, 0x8002e, 0x900bc, 0x8000e, 0x8008e, 0x8004e, 0x900fc,
    0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c2,
    0x70108, 0x80061, 0x80021, 0x900a2, 0x80001, 0x80081, 0x80041, 0x900e2,
    0x70104, 0x80059, 0x80019, 0x90092, 0x70114, 0x80079, 0x80039, 0x900d2,
    0x7010c, 0x80069, 0x80029, 0x900b2, 0x80009, 0x80089, 0x80049, 0x900f2,
    0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900ca,
    0x7010a, 0x80065, 0x80025, 0x900aa, 0x80005, 0x80085, 0x80045, 0x900ea,
    0x70106, 0x8005d, 0x8001d, 0x9009a, 0x70116, 0x8007d, 0x8003d, 0x900da,
    0x7010e, 0x8006d, 0x8002d, 0x900ba, 0x8000d, 0x8008d, 0x8004d, 0x900fa,
    0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c6,
    0x70109, 0x80063, 0x80023, 0x900a6, 0x80003, 0x80083, 0x80043, 0x900e6,
    0x70105, 0x8005b, 0x8001b, 0x90096, 0x70115, 0x8007b, 0x8003b, 0x900d6,
    0x7010d, 0x8006b, 0x8002b, 0x900b6, 0x8000b, 0x8008b, 0x8004b, 0x900f6,
    0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900ce,
    0x7010b, 0x80067, 0x80027, 0x900ae, 0x80007, 0x80087, 0x80047, 0x900ee,
    0x70107, 0x8005f, 0x8001f, 0x9009e, 0x70117, 0x8007f, 0x8003f, 0x900de,
    0x7010f, 0x8006f, 0x8002f, 0x900be, 0x8000f, 0x8008f, 0x8004f, 0x900fe,
    0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c1,
    0x70108, 0x80060, 0x80020, 0x900a1, 0x80000, 0x80080, 0x80040, 0x900e1,
    0x70104, 0x80058, 0x80018, 0x90091, 0x70114, 0x80078, 0x80038, 0x900d1,
    0x7010c, 0x80068, 0x80028, 0x900b1, 0x80008, 0x80088, 0x80048, 0x900f1,
    0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c9,
    0x7010a, 0x80064, 0x80024, 0x900a9, 0x80004, 0x80084, 0x80044, 0x900e9,
    0x70106, 0x8005c, 0x8001c, 0x90099, 0x70116, 0x8007c, 0x8003c, 0x900d9,
    0x7010e, 0x8006c, 0x8002c, 0x900b9, 0x8000c, 0x8008c, 0x8004c, 0x900f9,
    0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c5,
    0x70109, 0x80062, 0x80022, 0x900a5, 0x80002, 0x80082, 0x80042, 0x900e5,
    0x70105, 0x8005a, 0x8001a, 0x90095, 0x70115, 0x8007a, 0x8003a, 0x900d5,
    0x7010d, 0x8006a, 0x8002a, 0x900b5, 0x8000a, 0x8008a, 0x8004a, 0x900f5,
    0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cd,
    0x7010b, 0x80066, 0x80026, 0x900ad, 0x80006, 0x80086, 0x80046, 0x900ed,
    0x70107, 0x8005e, 0x8001e, 0x9009d, 0x70117, 0x8007e, 0x8003e, 0x900dd,
    0x7010f, 0x8006e, 0x8002e, 0x900bd, 0x8000e, 0x8008e, 0x8004e, 0x900fd,
    0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c3,
    0x70108, 0x80061, 0x80021, 0x900a3, 0x80001, 0x80081, 0x80041, 0x900e3,
    0x70104, 0x80059, 0x80019, 0x90093, 0x70114, 0x80079, 0x80039, 0x900d3,
    0x7010c, 0x80069, 0x80029, 0x900b3, 0x80009, 0x80089, 0x80049, 0x900f3,
    0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900cb,
    0x7010a, 0x80065, 0x80025, 0x900ab, 0x80005, 0x80085, 0x80045, 0x900eb,
    0x70106, 0x8005d, 0x8001d, 0x9009b, 0x70116, 0x8007d, 0x8003d, 0x900db,
    0x7010e, 0x8006d, 0x8002d, 0x900bb, 0x8000d, 0x8008d, 0x8004d, 0x900fb,
    0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c7,
    0x70109, 0x80063, 0x80023, 0x900a7, 0x80003, 0x80083, 0x80043, 0x900e7,
    0x70105, 0x8005b, 0x8001b, 0x90097, 0x70115, 0x8007b, 0x8003b, 0x900d7,
    0x7010d, 0x8006b, 0x8002b, 0x900b7, 0x8000b, 0x8008b, 0x8004b, 0x900f7,
    0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900cf,
    0x7010b, 0x80067, 0x80027, 0x900af, 0x80007, 0x80087, 0x80047, 0x900ef,
    0x70107, 0x8005f, 0x8001f, 0x9009f, 0x70117, 0x8007f, 0x8003f, 0x900df,
    0x7010f, 0x8006f, 0x8002f, 0x900bf, 0x8000f, 0x8008f, 0x8004f, 0x900ff
  ]), 9];

  var fixedDistCodeTab = [new Int32Array([
    0x50000, 0x50010, 0x50008, 0x50018, 0x50004, 0x50014, 0x5000c, 0x5001c,
    0x50002, 0x50012, 0x5000a, 0x5001a, 0x50006, 0x50016, 0x5000e, 0x00000,
    0x50001, 0x50011, 0x50009, 0x50019, 0x50005, 0x50015, 0x5000d, 0x5001d,
    0x50003, 0x50013, 0x5000b, 0x5001b, 0x50007, 0x50017, 0x5000f, 0x00000
  ]), 5];

  function FlateStream(str, maybeLength) {
    this.str = str;
    this.dict = str.dict;

    var cmf = str.getByte();
    var flg = str.getByte();
    if (cmf === -1 || flg === -1) {
      error('Invalid header in flate stream: ' + cmf + ', ' + flg);
    }
    if ((cmf & 0x0f) !== 0x08) {
      error('Unknown compression method in flate stream: ' + cmf + ', ' + flg);
    }
    if ((((cmf << 8) + flg) % 31) !== 0) {
      error('Bad FCHECK in flate stream: ' + cmf + ', ' + flg);
    }
    if (flg & 0x20) {
      error('FDICT bit set in flate stream: ' + cmf + ', ' + flg);
    }

    this.codeSize = 0;
    this.codeBuf = 0;

    DecodeStream.call(this, maybeLength);
  }

  FlateStream.prototype = Object.create(DecodeStream.prototype);

  FlateStream.prototype.getBits = function FlateStream_getBits(bits) {
    var str = this.str;
    var codeSize = this.codeSize;
    var codeBuf = this.codeBuf;

    var b;
    while (codeSize < bits) {
      if ((b = str.getByte()) === -1) {
        error('Bad encoding in flate stream');
      }
      codeBuf |= b << codeSize;
      codeSize += 8;
    }
    b = codeBuf & ((1 << bits) - 1);
    this.codeBuf = codeBuf >> bits;
    this.codeSize = codeSize -= bits;

    return b;
  };

  FlateStream.prototype.getCode = function FlateStream_getCode(table) {
    var str = this.str;
    var codes = table[0];
    var maxLen = table[1];
    var codeSize = this.codeSize;
    var codeBuf = this.codeBuf;

    var b;
    while (codeSize < maxLen) {
      if ((b = str.getByte()) === -1) {
        // premature end of stream. code might however still be valid.
        // codeSize < codeLen check below guards against incomplete codeVal.
        break;
      }
      codeBuf |= (b << codeSize);
      codeSize += 8;
    }
    var code = codes[codeBuf & ((1 << maxLen) - 1)];
    var codeLen = code >> 16;
    var codeVal = code & 0xffff;
    if (codeLen < 1 || codeSize < codeLen) {
      error('Bad encoding in flate stream');
    }
    this.codeBuf = (codeBuf >> codeLen);
    this.codeSize = (codeSize - codeLen);
    return codeVal;
  };

  FlateStream.prototype.generateHuffmanTable =
      function flateStreamGenerateHuffmanTable(lengths) {
    var n = lengths.length;

    // find max code length
    var maxLen = 0;
    var i;
    for (i = 0; i < n; ++i) {
      if (lengths[i] > maxLen) {
        maxLen = lengths[i];
      }
    }

    // build the table
    var size = 1 << maxLen;
    var codes = new Int32Array(size);
    for (var len = 1, code = 0, skip = 2;
         len <= maxLen;
         ++len, code <<= 1, skip <<= 1) {
      for (var val = 0; val < n; ++val) {
        if (lengths[val] === len) {
          // bit-reverse the code
          var code2 = 0;
          var t = code;
          for (i = 0; i < len; ++i) {
            code2 = (code2 << 1) | (t & 1);
            t >>= 1;
          }

          // fill the table entries
          for (i = code2; i < size; i += skip) {
            codes[i] = (len << 16) | val;
          }
          ++code;
        }
      }
    }

    return [codes, maxLen];
  };

  FlateStream.prototype.readBlock = function FlateStream_readBlock() {
    var buffer, len;
    var str = this.str;
    // read block header
    var hdr = this.getBits(3);
    if (hdr & 1) {
      this.eof = true;
    }
    hdr >>= 1;

    if (hdr === 0) { // uncompressed block
      var b;

      if ((b = str.getByte()) === -1) {
        error('Bad block header in flate stream');
      }
      var blockLen = b;
      if ((b = str.getByte()) === -1) {
        error('Bad block header in flate stream');
      }
      blockLen |= (b << 8);
      if ((b = str.getByte()) === -1) {
        error('Bad block header in flate stream');
      }
      var check = b;
      if ((b = str.getByte()) === -1) {
        error('Bad block header in flate stream');
      }
      check |= (b << 8);
      if (check !== (~blockLen & 0xffff) &&
          (blockLen !== 0 || check !== 0)) {
        // Ignoring error for bad "empty" block (see issue 1277)
        error('Bad uncompressed block length in flate stream');
      }

      this.codeBuf = 0;
      this.codeSize = 0;

      var bufferLength = this.bufferLength;
      buffer = this.ensureBuffer(bufferLength + blockLen);
      var end = bufferLength + blockLen;
      this.bufferLength = end;
      if (blockLen === 0) {
        if (str.peekByte() === -1) {
          this.eof = true;
        }
      } else {
        for (var n = bufferLength; n < end; ++n) {
          if ((b = str.getByte()) === -1) {
            this.eof = true;
            break;
          }
          buffer[n] = b;
        }
      }
      return;
    }

    var litCodeTable;
    var distCodeTable;
    if (hdr === 1) { // compressed block, fixed codes
      litCodeTable = fixedLitCodeTab;
      distCodeTable = fixedDistCodeTab;
    } else if (hdr === 2) { // compressed block, dynamic codes
      var numLitCodes = this.getBits(5) + 257;
      var numDistCodes = this.getBits(5) + 1;
      var numCodeLenCodes = this.getBits(4) + 4;

      // build the code lengths code table
      var codeLenCodeLengths = new Uint8Array(codeLenCodeMap.length);

      var i;
      for (i = 0; i < numCodeLenCodes; ++i) {
        codeLenCodeLengths[codeLenCodeMap[i]] = this.getBits(3);
      }
      var codeLenCodeTab = this.generateHuffmanTable(codeLenCodeLengths);

      // build the literal and distance code tables
      len = 0;
      i = 0;
      var codes = numLitCodes + numDistCodes;
      var codeLengths = new Uint8Array(codes);
      var bitsLength, bitsOffset, what;
      while (i < codes) {
        var code = this.getCode(codeLenCodeTab);
        if (code === 16) {
          bitsLength = 2; bitsOffset = 3; what = len;
        } else if (code === 17) {
          bitsLength = 3; bitsOffset = 3; what = (len = 0);
        } else if (code === 18) {
          bitsLength = 7; bitsOffset = 11; what = (len = 0);
        } else {
          codeLengths[i++] = len = code;
          continue;
        }

        var repeatLength = this.getBits(bitsLength) + bitsOffset;
        while (repeatLength-- > 0) {
          codeLengths[i++] = what;
        }
      }

      litCodeTable =
        this.generateHuffmanTable(codeLengths.subarray(0, numLitCodes));
      distCodeTable =
        this.generateHuffmanTable(codeLengths.subarray(numLitCodes, codes));
    } else {
      error('Unknown block type in flate stream');
    }

    buffer = this.buffer;
    var limit = buffer ? buffer.length : 0;
    var pos = this.bufferLength;
    while (true) {
      var code1 = this.getCode(litCodeTable);
      if (code1 < 256) {
        if (pos + 1 >= limit) {
          buffer = this.ensureBuffer(pos + 1);
          limit = buffer.length;
        }
        buffer[pos++] = code1;
        continue;
      }
      if (code1 === 256) {
        this.bufferLength = pos;
        return;
      }
      code1 -= 257;
      code1 = lengthDecode[code1];
      var code2 = code1 >> 16;
      if (code2 > 0) {
        code2 = this.getBits(code2);
      }
      len = (code1 & 0xffff) + code2;
      code1 = this.getCode(distCodeTable);
      code1 = distDecode[code1];
      code2 = code1 >> 16;
      if (code2 > 0) {
        code2 = this.getBits(code2);
      }
      var dist = (code1 & 0xffff) + code2;
      if (pos + len >= limit) {
        buffer = this.ensureBuffer(pos + len);
        limit = buffer.length;
      }
      for (var k = 0; k < len; ++k, ++pos) {
        buffer[pos] = buffer[pos - dist];
      }
    }
  };

  return FlateStream;
})();

var PredictorStream = (function PredictorStreamClosure() {
  function PredictorStream(str, maybeLength, params) {
    if (!isDict(params)) {
      return str; // no prediction
    }
    var predictor = this.predictor = params.get('Predictor') || 1;

    if (predictor <= 1) {
      return str; // no prediction
    }
    if (predictor !== 2 && (predictor < 10 || predictor > 15)) {
      error('Unsupported predictor: ' + predictor);
    }

    if (predictor === 2) {
      this.readBlock = this.readBlockTiff;
    } else {
      this.readBlock = this.readBlockPng;
    }

    this.str = str;
    this.dict = str.dict;

    var colors = this.colors = params.get('Colors') || 1;
    var bits = this.bits = params.get('BitsPerComponent') || 8;
    var columns = this.columns = params.get('Columns') || 1;

    this.pixBytes = (colors * bits + 7) >> 3;
    this.rowBytes = (columns * colors * bits + 7) >> 3;

    DecodeStream.call(this, maybeLength);
    return this;
  }

  PredictorStream.prototype = Object.create(DecodeStream.prototype);

  PredictorStream.prototype.readBlockTiff =
      function predictorStreamReadBlockTiff() {
    var rowBytes = this.rowBytes;

    var bufferLength = this.bufferLength;
    var buffer = this.ensureBuffer(bufferLength + rowBytes);

    var bits = this.bits;
    var colors = this.colors;

    var rawBytes = this.str.getBytes(rowBytes);
    this.eof = !rawBytes.length;
    if (this.eof) {
      return;
    }

    var inbuf = 0, outbuf = 0;
    var inbits = 0, outbits = 0;
    var pos = bufferLength;
    var i;

    if (bits === 1) {
      for (i = 0; i < rowBytes; ++i) {
        var c = rawBytes[i];
        inbuf = (inbuf << 8) | c;
        // bitwise addition is exclusive or
        // first shift inbuf and then add
        buffer[pos++] = (c ^ (inbuf >> colors)) & 0xFF;
        // truncate inbuf (assumes colors < 16)
        inbuf &= 0xFFFF;
      }
    } else if (bits === 8) {
      for (i = 0; i < colors; ++i) {
        buffer[pos++] = rawBytes[i];
      }
      for (; i < rowBytes; ++i) {
        buffer[pos] = buffer[pos - colors] + rawBytes[i];
        pos++;
      }
    } else {
      var compArray = new Uint8Array(colors + 1);
      var bitMask = (1 << bits) - 1;
      var j = 0, k = bufferLength;
      var columns = this.columns;
      for (i = 0; i < columns; ++i) {
        for (var kk = 0; kk < colors; ++kk) {
          if (inbits < bits) {
            inbuf = (inbuf << 8) | (rawBytes[j++] & 0xFF);
            inbits += 8;
          }
          compArray[kk] = (compArray[kk] +
                           (inbuf >> (inbits - bits))) & bitMask;
          inbits -= bits;
          outbuf = (outbuf << bits) | compArray[kk];
          outbits += bits;
          if (outbits >= 8) {
            buffer[k++] = (outbuf >> (outbits - 8)) & 0xFF;
            outbits -= 8;
          }
        }
      }
      if (outbits > 0) {
        buffer[k++] = (outbuf << (8 - outbits)) +
                      (inbuf & ((1 << (8 - outbits)) - 1));
      }
    }
    this.bufferLength += rowBytes;
  };

  PredictorStream.prototype.readBlockPng =
      function predictorStreamReadBlockPng() {

    var rowBytes = this.rowBytes;
    var pixBytes = this.pixBytes;

    var predictor = this.str.getByte();
    var rawBytes = this.str.getBytes(rowBytes);
    this.eof = !rawBytes.length;
    if (this.eof) {
      return;
    }

    var bufferLength = this.bufferLength;
    var buffer = this.ensureBuffer(bufferLength + rowBytes);

    var prevRow = buffer.subarray(bufferLength - rowBytes, bufferLength);
    if (prevRow.length === 0) {
      prevRow = new Uint8Array(rowBytes);
    }

    var i, j = bufferLength, up, c;
    switch (predictor) {
      case 0:
        for (i = 0; i < rowBytes; ++i) {
          buffer[j++] = rawBytes[i];
        }
        break;
      case 1:
        for (i = 0; i < pixBytes; ++i) {
          buffer[j++] = rawBytes[i];
        }
        for (; i < rowBytes; ++i) {
          buffer[j] = (buffer[j - pixBytes] + rawBytes[i]) & 0xFF;
          j++;
        }
        break;
      case 2:
        for (i = 0; i < rowBytes; ++i) {
          buffer[j++] = (prevRow[i] + rawBytes[i]) & 0xFF;
        }
        break;
      case 3:
        for (i = 0; i < pixBytes; ++i) {
          buffer[j++] = (prevRow[i] >> 1) + rawBytes[i];
        }
        for (; i < rowBytes; ++i) {
          buffer[j] = (((prevRow[i] + buffer[j - pixBytes]) >> 1) +
                           rawBytes[i]) & 0xFF;
          j++;
        }
        break;
      case 4:
        // we need to save the up left pixels values. the simplest way
        // is to create a new buffer
        for (i = 0; i < pixBytes; ++i) {
          up = prevRow[i];
          c = rawBytes[i];
          buffer[j++] = up + c;
        }
        for (; i < rowBytes; ++i) {
          up = prevRow[i];
          var upLeft = prevRow[i - pixBytes];
          var left = buffer[j - pixBytes];
          var p = left + up - upLeft;

          var pa = p - left;
          if (pa < 0) {
            pa = -pa;
          }
          var pb = p - up;
          if (pb < 0) {
            pb = -pb;
          }
          var pc = p - upLeft;
          if (pc < 0) {
            pc = -pc;
          }

          c = rawBytes[i];
          if (pa <= pb && pa <= pc) {
            buffer[j++] = left + c;
          } else if (pb <= pc) {
            buffer[j++] = up + c;
          } else {
            buffer[j++] = upLeft + c;
          }
        }
        break;
      default:
        error('Unsupported predictor: ' + predictor);
    }
    this.bufferLength += rowBytes;
  };

  return PredictorStream;
})();

/**
 * Depending on the type of JPEG a JpegStream is handled in different ways. For
 * JPEG's that are supported natively such as DeviceGray and DeviceRGB the image
 * data is stored and then loaded by the browser.  For unsupported JPEG's we use
 * a library to decode these images and the stream behaves like all the other
 * DecodeStreams.
 */
var JpegStream = (function JpegStreamClosure() {
  function JpegStream(stream, maybeLength, dict, xref) {
    // Some images may contain 'junk' before the SOI (start-of-image) marker.
    // Note: this seems to mainly affect inline images.
    var ch;
    while ((ch = stream.getByte()) !== -1) {
      if (ch === 0xFF) { // Find the first byte of the SOI marker (0xFFD8).
        stream.skip(-1); // Reset the stream position to the SOI.
        break;
      }
    }
    this.stream = stream;
    this.maybeLength = maybeLength;
    this.dict = dict;

    DecodeStream.call(this, maybeLength);
  }

  JpegStream.prototype = Object.create(DecodeStream.prototype);

  Object.defineProperty(JpegStream.prototype, 'bytes', {
    get: function JpegStream_bytes() {
      // If this.maybeLength is null, we'll get the entire stream.
      return shadow(this, 'bytes', this.stream.getBytes(this.maybeLength));
    },
    configurable: true
  });

  JpegStream.prototype.ensureBuffer = function JpegStream_ensureBuffer(req) {
    if (this.bufferLength) {
      return;
    }
    try {
      var jpegImage = new JpegImage();

      // checking if values needs to be transformed before conversion
      if (this.forceRGB && this.dict && isArray(this.dict.get('Decode'))) {
        var decodeArr = this.dict.getArray('Decode');
        var bitsPerComponent = this.dict.get('BitsPerComponent') || 8;
        var decodeArrLength = decodeArr.length;
        var transform = new Int32Array(decodeArrLength);
        var transformNeeded = false;
        var maxValue = (1 << bitsPerComponent) - 1;
        for (var i = 0; i < decodeArrLength; i += 2) {
          transform[i] = ((decodeArr[i + 1] - decodeArr[i]) * 256) | 0;
          transform[i + 1] = (decodeArr[i] * maxValue) | 0;
          if (transform[i] !== 256 || transform[i + 1] !== 0) {
            transformNeeded = true;
          }
        }
        if (transformNeeded) {
          jpegImage.decodeTransform = transform;
        }
      }

      jpegImage.parse(this.bytes);
      var data = jpegImage.getData(this.drawWidth, this.drawHeight,
                                   this.forceRGB);
      this.buffer = data;
      this.bufferLength = data.length;
      this.eof = true;
    } catch (e) {
      error('JPEG error: ' + e);
    }
  };

  JpegStream.prototype.getBytes = function JpegStream_getBytes(length) {
    this.ensureBuffer();
    return this.buffer;
  };

  JpegStream.prototype.getIR = function JpegStream_getIR(forceDataSchema) {
    return createObjectURL(this.bytes, 'image/jpeg', forceDataSchema);
  };

  return JpegStream;
})();

/**
 * For JPEG 2000's we use a library to decode these images and
 * the stream behaves like all the other DecodeStreams.
 */
var JpxStream = (function JpxStreamClosure() {
  function JpxStream(stream, maybeLength, dict) {
    this.stream = stream;
    this.maybeLength = maybeLength;
    this.dict = dict;

    DecodeStream.call(this, maybeLength);
  }

  JpxStream.prototype = Object.create(DecodeStream.prototype);

  Object.defineProperty(JpxStream.prototype, 'bytes', {
    get: function JpxStream_bytes() {
      // If this.maybeLength is null, we'll get the entire stream.
      return shadow(this, 'bytes', this.stream.getBytes(this.maybeLength));
    },
    configurable: true
  });

  JpxStream.prototype.ensureBuffer = function JpxStream_ensureBuffer(req) {
    if (this.bufferLength) {
      return;
    }

    var jpxImage = new JpxImage();
    jpxImage.parse(this.bytes);

    var width = jpxImage.width;
    var height = jpxImage.height;
    var componentsCount = jpxImage.componentsCount;
    var tileCount = jpxImage.tiles.length;
    if (tileCount === 1) {
      this.buffer = jpxImage.tiles[0].items;
    } else {
      var data = new Uint8Array(width * height * componentsCount);

      for (var k = 0; k < tileCount; k++) {
        var tileComponents = jpxImage.tiles[k];
        var tileWidth = tileComponents.width;
        var tileHeight = tileComponents.height;
        var tileLeft = tileComponents.left;
        var tileTop = tileComponents.top;

        var src = tileComponents.items;
        var srcPosition = 0;
        var dataPosition = (width * tileTop + tileLeft) * componentsCount;
        var imgRowSize = width * componentsCount;
        var tileRowSize = tileWidth * componentsCount;

        for (var j = 0; j < tileHeight; j++) {
          var rowBytes = src.subarray(srcPosition, srcPosition + tileRowSize);
          data.set(rowBytes, dataPosition);
          srcPosition += tileRowSize;
          dataPosition += imgRowSize;
        }
      }
      this.buffer = data;
    }
    this.bufferLength = this.buffer.length;
    this.eof = true;
  };

  return JpxStream;
})();

/**
 * For JBIG2's we use a library to decode these images and
 * the stream behaves like all the other DecodeStreams.
 */
var Jbig2Stream = (function Jbig2StreamClosure() {
  function Jbig2Stream(stream, maybeLength, dict) {
    this.stream = stream;
    this.maybeLength = maybeLength;
    this.dict = dict;

    DecodeStream.call(this, maybeLength);
  }

  Jbig2Stream.prototype = Object.create(DecodeStream.prototype);

  Object.defineProperty(Jbig2Stream.prototype, 'bytes', {
    get: function Jbig2Stream_bytes() {
      // If this.maybeLength is null, we'll get the entire stream.
      return shadow(this, 'bytes', this.stream.getBytes(this.maybeLength));
    },
    configurable: true
  });

  Jbig2Stream.prototype.ensureBuffer = function Jbig2Stream_ensureBuffer(req) {
    if (this.bufferLength) {
      return;
    }

    var jbig2Image = new Jbig2Image();

    var chunks = [];
    var decodeParams = this.dict.getArray('DecodeParms');

    // According to the PDF specification, DecodeParms can be either
    // a dictionary, or an array whose elements are dictionaries.
    if (isArray(decodeParams)) {
      if (decodeParams.length > 1) {
        warn('JBIG2 - \'DecodeParms\' array with multiple elements ' +
             'not supported.');
      }
      decodeParams = decodeParams[0];
    }
    if (decodeParams && decodeParams.has('JBIG2Globals')) {
      var globalsStream = decodeParams.get('JBIG2Globals');
      var globals = globalsStream.getBytes();
      chunks.push({data: globals, start: 0, end: globals.length});
    }
    chunks.push({data: this.bytes, start: 0, end: this.bytes.length});
    var data = jbig2Image.parseChunks(chunks);
    var dataLength = data.length;

    // JBIG2 had black as 1 and white as 0, inverting the colors
    for (var i = 0; i < dataLength; i++) {
      data[i] ^= 0xFF;
    }

    this.buffer = data;
    this.bufferLength = dataLength;
    this.eof = true;
  };

  return Jbig2Stream;
})();

var DecryptStream = (function DecryptStreamClosure() {
  function DecryptStream(str, maybeLength, decrypt) {
    this.str = str;
    this.dict = str.dict;
    this.decrypt = decrypt;
    this.nextChunk = null;
    this.initialized = false;

    DecodeStream.call(this, maybeLength);
  }

  var chunkSize = 512;

  DecryptStream.prototype = Object.create(DecodeStream.prototype);

  DecryptStream.prototype.readBlock = function DecryptStream_readBlock() {
    var chunk;
    if (this.initialized) {
      chunk = this.nextChunk;
    } else {
      chunk = this.str.getBytes(chunkSize);
      this.initialized = true;
    }
    if (!chunk || chunk.length === 0) {
      this.eof = true;
      return;
    }
    this.nextChunk = this.str.getBytes(chunkSize);
    var hasMoreData = this.nextChunk && this.nextChunk.length > 0;

    var decrypt = this.decrypt;
    chunk = decrypt(chunk, !hasMoreData);

    var bufferLength = this.bufferLength;
    var i, n = chunk.length;
    var buffer = this.ensureBuffer(bufferLength + n);
    for (i = 0; i < n; i++) {
      buffer[bufferLength++] = chunk[i];
    }
    this.bufferLength = bufferLength;
  };

  return DecryptStream;
})();

var Ascii85Stream = (function Ascii85StreamClosure() {
  function Ascii85Stream(str, maybeLength) {
    this.str = str;
    this.dict = str.dict;
    this.input = new Uint8Array(5);

    // Most streams increase in size when decoded, but Ascii85 streams
    // typically shrink by ~20%.
    if (maybeLength) {
      maybeLength = 0.8 * maybeLength;
    }
    DecodeStream.call(this, maybeLength);
  }

  Ascii85Stream.prototype = Object.create(DecodeStream.prototype);

  Ascii85Stream.prototype.readBlock = function Ascii85Stream_readBlock() {
    var TILDA_CHAR = 0x7E; // '~'
    var Z_LOWER_CHAR = 0x7A; // 'z'
    var EOF = -1;

    var str = this.str;

    var c = str.getByte();
    while (isSpace(c)) {
      c = str.getByte();
    }

    if (c === EOF || c === TILDA_CHAR) {
      this.eof = true;
      return;
    }

    var bufferLength = this.bufferLength, buffer;
    var i;

    // special code for z
    if (c === Z_LOWER_CHAR) {
      buffer = this.ensureBuffer(bufferLength + 4);
      for (i = 0; i < 4; ++i) {
        buffer[bufferLength + i] = 0;
      }
      this.bufferLength += 4;
    } else {
      var input = this.input;
      input[0] = c;
      for (i = 1; i < 5; ++i) {
        c = str.getByte();
        while (isSpace(c)) {
          c = str.getByte();
        }

        input[i] = c;

        if (c === EOF || c === TILDA_CHAR) {
          break;
        }
      }
      buffer = this.ensureBuffer(bufferLength + i - 1);
      this.bufferLength += i - 1;

      // partial ending;
      if (i < 5) {
        for (; i < 5; ++i) {
          input[i] = 0x21 + 84;
        }
        this.eof = true;
      }
      var t = 0;
      for (i = 0; i < 5; ++i) {
        t = t * 85 + (input[i] - 0x21);
      }

      for (i = 3; i >= 0; --i) {
        buffer[bufferLength + i] = t & 0xFF;
        t >>= 8;
      }
    }
  };

  return Ascii85Stream;
})();

var AsciiHexStream = (function AsciiHexStreamClosure() {
  function AsciiHexStream(str, maybeLength) {
    this.str = str;
    this.dict = str.dict;

    this.firstDigit = -1;

    // Most streams increase in size when decoded, but AsciiHex streams shrink
    // by 50%.
    if (maybeLength) {
      maybeLength = 0.5 * maybeLength;
    }
    DecodeStream.call(this, maybeLength);
  }

  AsciiHexStream.prototype = Object.create(DecodeStream.prototype);

  AsciiHexStream.prototype.readBlock = function AsciiHexStream_readBlock() {
    var UPSTREAM_BLOCK_SIZE = 8000;
    var bytes = this.str.getBytes(UPSTREAM_BLOCK_SIZE);
    if (!bytes.length) {
      this.eof = true;
      return;
    }

    var maxDecodeLength = (bytes.length + 1) >> 1;
    var buffer = this.ensureBuffer(this.bufferLength + maxDecodeLength);
    var bufferLength = this.bufferLength;

    var firstDigit = this.firstDigit;
    for (var i = 0, ii = bytes.length; i < ii; i++) {
      var ch = bytes[i], digit;
      if (ch >= 0x30 && ch <= 0x39) { // '0'-'9'
        digit = ch & 0x0F;
      } else if ((ch >= 0x41 && ch <= 0x46) || (ch >= 0x61 && ch <= 0x66)) {
        // 'A'-'Z', 'a'-'z'
        digit = (ch & 0x0F) + 9;
      } else if (ch === 0x3E) { // '>'
        this.eof = true;
        break;
      } else { // probably whitespace
        continue; // ignoring
      }
      if (firstDigit < 0) {
        firstDigit = digit;
      } else {
        buffer[bufferLength++] = (firstDigit << 4) | digit;
        firstDigit = -1;
      }
    }
    if (firstDigit >= 0 && this.eof) {
      // incomplete byte
      buffer[bufferLength++] = (firstDigit << 4);
      firstDigit = -1;
    }
    this.firstDigit = firstDigit;
    this.bufferLength = bufferLength;
  };

  return AsciiHexStream;
})();

var RunLengthStream = (function RunLengthStreamClosure() {
  function RunLengthStream(str, maybeLength) {
    this.str = str;
    this.dict = str.dict;

    DecodeStream.call(this, maybeLength);
  }

  RunLengthStream.prototype = Object.create(DecodeStream.prototype);

  RunLengthStream.prototype.readBlock = function RunLengthStream_readBlock() {
    // The repeatHeader has following format. The first byte defines type of run
    // and amount of bytes to repeat/copy: n = 0 through 127 - copy next n bytes
    // (in addition to the second byte from the header), n = 129 through 255 -
    // duplicate the second byte from the header (257 - n) times, n = 128 - end.
    var repeatHeader = this.str.getBytes(2);
    if (!repeatHeader || repeatHeader.length < 2 || repeatHeader[0] === 128) {
      this.eof = true;
      return;
    }

    var buffer;
    var bufferLength = this.bufferLength;
    var n = repeatHeader[0];
    if (n < 128) {
      // copy n bytes
      buffer = this.ensureBuffer(bufferLength + n + 1);
      buffer[bufferLength++] = repeatHeader[1];
      if (n > 0) {
        var source = this.str.getBytes(n);
        buffer.set(source, bufferLength);
        bufferLength += n;
      }
    } else {
      n = 257 - n;
      var b = repeatHeader[1];
      buffer = this.ensureBuffer(bufferLength + n + 1);
      for (var i = 0; i < n; i++) {
        buffer[bufferLength++] = b;
      }
    }
    this.bufferLength = bufferLength;
  };

  return RunLengthStream;
})();

var CCITTFaxStream = (function CCITTFaxStreamClosure() {

  var ccittEOL = -2;
  var ccittEOF = -1;
  var twoDimPass = 0;
  var twoDimHoriz = 1;
  var twoDimVert0 = 2;
  var twoDimVertR1 = 3;
  var twoDimVertL1 = 4;
  var twoDimVertR2 = 5;
  var twoDimVertL2 = 6;
  var twoDimVertR3 = 7;
  var twoDimVertL3 = 8;

  var twoDimTable = [
    [-1, -1], [-1, -1],                   // 000000x
    [7, twoDimVertL3],                    // 0000010
    [7, twoDimVertR3],                    // 0000011
    [6, twoDimVertL2], [6, twoDimVertL2], // 000010x
    [6, twoDimVertR2], [6, twoDimVertR2], // 000011x
    [4, twoDimPass], [4, twoDimPass],     // 0001xxx
    [4, twoDimPass], [4, twoDimPass],
    [4, twoDimPass], [4, twoDimPass],
    [4, twoDimPass], [4, twoDimPass],
    [3, twoDimHoriz], [3, twoDimHoriz],   // 001xxxx
    [3, twoDimHoriz], [3, twoDimHoriz],
    [3, twoDimHoriz], [3, twoDimHoriz],
    [3, twoDimHoriz], [3, twoDimHoriz],
    [3, twoDimHoriz], [3, twoDimHoriz],
    [3, twoDimHoriz], [3, twoDimHoriz],
    [3, twoDimHoriz], [3, twoDimHoriz],
    [3, twoDimHoriz], [3, twoDimHoriz],
    [3, twoDimVertL1], [3, twoDimVertL1], // 010xxxx
    [3, twoDimVertL1], [3, twoDimVertL1],
    [3, twoDimVertL1], [3, twoDimVertL1],
    [3, twoDimVertL1], [3, twoDimVertL1],
    [3, twoDimVertL1], [3, twoDimVertL1],
    [3, twoDimVertL1], [3, twoDimVertL1],
    [3, twoDimVertL1], [3, twoDimVertL1],
    [3, twoDimVertL1], [3, twoDimVertL1],
    [3, twoDimVertR1], [3, twoDimVertR1], // 011xxxx
    [3, twoDimVertR1], [3, twoDimVertR1],
    [3, twoDimVertR1], [3, twoDimVertR1],
    [3, twoDimVertR1], [3, twoDimVertR1],
    [3, twoDimVertR1], [3, twoDimVertR1],
    [3, twoDimVertR1], [3, twoDimVertR1],
    [3, twoDimVertR1], [3, twoDimVertR1],
    [3, twoDimVertR1], [3, twoDimVertR1],
    [1, twoDimVert0], [1, twoDimVert0],   // 1xxxxxx
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0],
    [1, twoDimVert0], [1, twoDimVert0]
  ];

  var whiteTable1 = [
    [-1, -1],                               // 00000
    [12, ccittEOL],                         // 00001
    [-1, -1], [-1, -1],                     // 0001x
    [-1, -1], [-1, -1], [-1, -1], [-1, -1], // 001xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1], // 010xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1], // 011xx
    [11, 1792], [11, 1792],                 // 1000x
    [12, 1984],                             // 10010
    [12, 2048],                             // 10011
    [12, 2112],                             // 10100
    [12, 2176],                             // 10101
    [12, 2240],                             // 10110
    [12, 2304],                             // 10111
    [11, 1856], [11, 1856],                 // 1100x
    [11, 1920], [11, 1920],                 // 1101x
    [12, 2368],                             // 11100
    [12, 2432],                             // 11101
    [12, 2496],                             // 11110
    [12, 2560]                              // 11111
  ];

  var whiteTable2 = [
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],     // 0000000xx
    [8, 29], [8, 29],                           // 00000010x
    [8, 30], [8, 30],                           // 00000011x
    [8, 45], [8, 45],                           // 00000100x
    [8, 46], [8, 46],                           // 00000101x
    [7, 22], [7, 22], [7, 22], [7, 22],         // 0000011xx
    [7, 23], [7, 23], [7, 23], [7, 23],         // 0000100xx
    [8, 47], [8, 47],                           // 00001010x
    [8, 48], [8, 48],                           // 00001011x
    [6, 13], [6, 13], [6, 13], [6, 13],         // 000011xxx
    [6, 13], [6, 13], [6, 13], [6, 13],
    [7, 20], [7, 20], [7, 20], [7, 20],         // 0001000xx
    [8, 33], [8, 33],                           // 00010010x
    [8, 34], [8, 34],                           // 00010011x
    [8, 35], [8, 35],                           // 00010100x
    [8, 36], [8, 36],                           // 00010101x
    [8, 37], [8, 37],                           // 00010110x
    [8, 38], [8, 38],                           // 00010111x
    [7, 19], [7, 19], [7, 19], [7, 19],         // 0001100xx
    [8, 31], [8, 31],                           // 00011010x
    [8, 32], [8, 32],                           // 00011011x
    [6, 1], [6, 1], [6, 1], [6, 1],             // 000111xxx
    [6, 1], [6, 1], [6, 1], [6, 1],
    [6, 12], [6, 12], [6, 12], [6, 12],         // 001000xxx
    [6, 12], [6, 12], [6, 12], [6, 12],
    [8, 53], [8, 53],                           // 00100100x
    [8, 54], [8, 54],                           // 00100101x
    [7, 26], [7, 26], [7, 26], [7, 26],         // 0010011xx
    [8, 39], [8, 39],                           // 00101000x
    [8, 40], [8, 40],                           // 00101001x
    [8, 41], [8, 41],                           // 00101010x
    [8, 42], [8, 42],                           // 00101011x
    [8, 43], [8, 43],                           // 00101100x
    [8, 44], [8, 44],                           // 00101101x
    [7, 21], [7, 21], [7, 21], [7, 21],         // 0010111xx
    [7, 28], [7, 28], [7, 28], [7, 28],         // 0011000xx
    [8, 61], [8, 61],                           // 00110010x
    [8, 62], [8, 62],                           // 00110011x
    [8, 63], [8, 63],                           // 00110100x
    [8, 0], [8, 0],                             // 00110101x
    [8, 320], [8, 320],                         // 00110110x
    [8, 384], [8, 384],                         // 00110111x
    [5, 10], [5, 10], [5, 10], [5, 10],         // 00111xxxx
    [5, 10], [5, 10], [5, 10], [5, 10],
    [5, 10], [5, 10], [5, 10], [5, 10],
    [5, 10], [5, 10], [5, 10], [5, 10],
    [5, 11], [5, 11], [5, 11], [5, 11],         // 01000xxxx
    [5, 11], [5, 11], [5, 11], [5, 11],
    [5, 11], [5, 11], [5, 11], [5, 11],
    [5, 11], [5, 11], [5, 11], [5, 11],
    [7, 27], [7, 27], [7, 27], [7, 27],         // 0100100xx
    [8, 59], [8, 59],                           // 01001010x
    [8, 60], [8, 60],                           // 01001011x
    [9, 1472],                                  // 010011000
    [9, 1536],                                  // 010011001
    [9, 1600],                                  // 010011010
    [9, 1728],                                  // 010011011
    [7, 18], [7, 18], [7, 18], [7, 18],         // 0100111xx
    [7, 24], [7, 24], [7, 24], [7, 24],         // 0101000xx
    [8, 49], [8, 49],                           // 01010010x
    [8, 50], [8, 50],                           // 01010011x
    [8, 51], [8, 51],                           // 01010100x
    [8, 52], [8, 52],                           // 01010101x
    [7, 25], [7, 25], [7, 25], [7, 25],         // 0101011xx
    [8, 55], [8, 55],                           // 01011000x
    [8, 56], [8, 56],                           // 01011001x
    [8, 57], [8, 57],                           // 01011010x
    [8, 58], [8, 58],                           // 01011011x
    [6, 192], [6, 192], [6, 192], [6, 192],     // 010111xxx
    [6, 192], [6, 192], [6, 192], [6, 192],
    [6, 1664], [6, 1664], [6, 1664], [6, 1664], // 011000xxx
    [6, 1664], [6, 1664], [6, 1664], [6, 1664],
    [8, 448], [8, 448],                         // 01100100x
    [8, 512], [8, 512],                         // 01100101x
    [9, 704],                                   // 011001100
    [9, 768],                                   // 011001101
    [8, 640], [8, 640],                         // 01100111x
    [8, 576], [8, 576],                         // 01101000x
    [9, 832],                                   // 011010010
    [9, 896],                                   // 011010011
    [9, 960],                                   // 011010100
    [9, 1024],                                  // 011010101
    [9, 1088],                                  // 011010110
    [9, 1152],                                  // 011010111
    [9, 1216],                                  // 011011000
    [9, 1280],                                  // 011011001
    [9, 1344],                                  // 011011010
    [9, 1408],                                  // 011011011
    [7, 256], [7, 256], [7, 256], [7, 256],     // 0110111xx
    [4, 2], [4, 2], [4, 2], [4, 2],             // 0111xxxxx
    [4, 2], [4, 2], [4, 2], [4, 2],
    [4, 2], [4, 2], [4, 2], [4, 2],
    [4, 2], [4, 2], [4, 2], [4, 2],
    [4, 2], [4, 2], [4, 2], [4, 2],
    [4, 2], [4, 2], [4, 2], [4, 2],
    [4, 2], [4, 2], [4, 2], [4, 2],
    [4, 2], [4, 2], [4, 2], [4, 2],
    [4, 3], [4, 3], [4, 3], [4, 3],             // 1000xxxxx
    [4, 3], [4, 3], [4, 3], [4, 3],
    [4, 3], [4, 3], [4, 3], [4, 3],
    [4, 3], [4, 3], [4, 3], [4, 3],
    [4, 3], [4, 3], [4, 3], [4, 3],
    [4, 3], [4, 3], [4, 3], [4, 3],
    [4, 3], [4, 3], [4, 3], [4, 3],
    [4, 3], [4, 3], [4, 3], [4, 3],
    [5, 128], [5, 128], [5, 128], [5, 128],     // 10010xxxx
    [5, 128], [5, 128], [5, 128], [5, 128],
    [5, 128], [5, 128], [5, 128], [5, 128],
    [5, 128], [5, 128], [5, 128], [5, 128],
    [5, 8], [5, 8], [5, 8], [5, 8],             // 10011xxxx
    [5, 8], [5, 8], [5, 8], [5, 8],
    [5, 8], [5, 8], [5, 8], [5, 8],
    [5, 8], [5, 8], [5, 8], [5, 8],
    [5, 9], [5, 9], [5, 9], [5, 9],             // 10100xxxx
    [5, 9], [5, 9], [5, 9], [5, 9],
    [5, 9], [5, 9], [5, 9], [5, 9],
    [5, 9], [5, 9], [5, 9], [5, 9],
    [6, 16], [6, 16], [6, 16], [6, 16],         // 101010xxx
    [6, 16], [6, 16], [6, 16], [6, 16],
    [6, 17], [6, 17], [6, 17], [6, 17],         // 101011xxx
    [6, 17], [6, 17], [6, 17], [6, 17],
    [4, 4], [4, 4], [4, 4], [4, 4],             // 1011xxxxx
    [4, 4], [4, 4], [4, 4], [4, 4],
    [4, 4], [4, 4], [4, 4], [4, 4],
    [4, 4], [4, 4], [4, 4], [4, 4],
    [4, 4], [4, 4], [4, 4], [4, 4],
    [4, 4], [4, 4], [4, 4], [4, 4],
    [4, 4], [4, 4], [4, 4], [4, 4],
    [4, 4], [4, 4], [4, 4], [4, 4],
    [4, 5], [4, 5], [4, 5], [4, 5],             // 1100xxxxx
    [4, 5], [4, 5], [4, 5], [4, 5],
    [4, 5], [4, 5], [4, 5], [4, 5],
    [4, 5], [4, 5], [4, 5], [4, 5],
    [4, 5], [4, 5], [4, 5], [4, 5],
    [4, 5], [4, 5], [4, 5], [4, 5],
    [4, 5], [4, 5], [4, 5], [4, 5],
    [4, 5], [4, 5], [4, 5], [4, 5],
    [6, 14], [6, 14], [6, 14], [6, 14],         // 110100xxx
    [6, 14], [6, 14], [6, 14], [6, 14],
    [6, 15], [6, 15], [6, 15], [6, 15],         // 110101xxx
    [6, 15], [6, 15], [6, 15], [6, 15],
    [5, 64], [5, 64], [5, 64], [5, 64],         // 11011xxxx
    [5, 64], [5, 64], [5, 64], [5, 64],
    [5, 64], [5, 64], [5, 64], [5, 64],
    [5, 64], [5, 64], [5, 64], [5, 64],
    [4, 6], [4, 6], [4, 6], [4, 6],             // 1110xxxxx
    [4, 6], [4, 6], [4, 6], [4, 6],
    [4, 6], [4, 6], [4, 6], [4, 6],
    [4, 6], [4, 6], [4, 6], [4, 6],
    [4, 6], [4, 6], [4, 6], [4, 6],
    [4, 6], [4, 6], [4, 6], [4, 6],
    [4, 6], [4, 6], [4, 6], [4, 6],
    [4, 6], [4, 6], [4, 6], [4, 6],
    [4, 7], [4, 7], [4, 7], [4, 7],             // 1111xxxxx
    [4, 7], [4, 7], [4, 7], [4, 7],
    [4, 7], [4, 7], [4, 7], [4, 7],
    [4, 7], [4, 7], [4, 7], [4, 7],
    [4, 7], [4, 7], [4, 7], [4, 7],
    [4, 7], [4, 7], [4, 7], [4, 7],
    [4, 7], [4, 7], [4, 7], [4, 7],
    [4, 7], [4, 7], [4, 7], [4, 7]
  ];

  var blackTable1 = [
    [-1, -1], [-1, -1],                             // 000000000000x
    [12, ccittEOL], [12, ccittEOL],                 // 000000000001x
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],         // 00000000001xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],         // 00000000010xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],         // 00000000011xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],         // 00000000100xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],         // 00000000101xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],         // 00000000110xx
    [-1, -1], [-1, -1], [-1, -1], [-1, -1],         // 00000000111xx
    [11, 1792], [11, 1792], [11, 1792], [11, 1792], // 00000001000xx
    [12, 1984], [12, 1984],                         // 000000010010x
    [12, 2048], [12, 2048],                         // 000000010011x
    [12, 2112], [12, 2112],                         // 000000010100x
    [12, 2176], [12, 2176],                         // 000000010101x
    [12, 2240], [12, 2240],                         // 000000010110x
    [12, 2304], [12, 2304],                         // 000000010111x
    [11, 1856], [11, 1856], [11, 1856], [11, 1856], // 00000001100xx
    [11, 1920], [11, 1920], [11, 1920], [11, 1920], // 00000001101xx
    [12, 2368], [12, 2368],                         // 000000011100x
    [12, 2432], [12, 2432],                         // 000000011101x
    [12, 2496], [12, 2496],                         // 000000011110x
    [12, 2560], [12, 2560],                         // 000000011111x
    [10, 18], [10, 18], [10, 18], [10, 18],         // 0000001000xxx
    [10, 18], [10, 18], [10, 18], [10, 18],
    [12, 52], [12, 52],                             // 000000100100x
    [13, 640],                                      // 0000001001010
    [13, 704],                                      // 0000001001011
    [13, 768],                                      // 0000001001100
    [13, 832],                                      // 0000001001101
    [12, 55], [12, 55],                             // 000000100111x
    [12, 56], [12, 56],                             // 000000101000x
    [13, 1280],                                     // 0000001010010
    [13, 1344],                                     // 0000001010011
    [13, 1408],                                     // 0000001010100
    [13, 1472],                                     // 0000001010101
    [12, 59], [12, 59],                             // 000000101011x
    [12, 60], [12, 60],                             // 000000101100x
    [13, 1536],                                     // 0000001011010
    [13, 1600],                                     // 0000001011011
    [11, 24], [11, 24], [11, 24], [11, 24],         // 00000010111xx
    [11, 25], [11, 25], [11, 25], [11, 25],         // 00000011000xx
    [13, 1664],                                     // 0000001100100
    [13, 1728],                                     // 0000001100101
    [12, 320], [12, 320],                           // 000000110011x
    [12, 384], [12, 384],                           // 000000110100x
    [12, 448], [12, 448],                           // 000000110101x
    [13, 512],                                      // 0000001101100
    [13, 576],                                      // 0000001101101
    [12, 53], [12, 53],                             // 000000110111x
    [12, 54], [12, 54],                             // 000000111000x
    [13, 896],                                      // 0000001110010
    [13, 960],                                      // 0000001110011
    [13, 1024],                                     // 0000001110100
    [13, 1088],                                     // 0000001110101
    [13, 1152],                                     // 0000001110110
    [13, 1216],                                     // 0000001110111
    [10, 64], [10, 64], [10, 64], [10, 64],         // 0000001111xxx
    [10, 64], [10, 64], [10, 64], [10, 64]
  ];

  var blackTable2 = [
    [8, 13], [8, 13], [8, 13], [8, 13],     // 00000100xxxx
    [8, 13], [8, 13], [8, 13], [8, 13],
    [8, 13], [8, 13], [8, 13], [8, 13],
    [8, 13], [8, 13], [8, 13], [8, 13],
    [11, 23], [11, 23],                     // 00000101000x
    [12, 50],                               // 000001010010
    [12, 51],                               // 000001010011
    [12, 44],                               // 000001010100
    [12, 45],                               // 000001010101
    [12, 46],                               // 000001010110
    [12, 47],                               // 000001010111
    [12, 57],                               // 000001011000
    [12, 58],                               // 000001011001
    [12, 61],                               // 000001011010
    [12, 256],                              // 000001011011
    [10, 16], [10, 16], [10, 16], [10, 16], // 0000010111xx
    [10, 17], [10, 17], [10, 17], [10, 17], // 0000011000xx
    [12, 48],                               // 000001100100
    [12, 49],                               // 000001100101
    [12, 62],                               // 000001100110
    [12, 63],                               // 000001100111
    [12, 30],                               // 000001101000
    [12, 31],                               // 000001101001
    [12, 32],                               // 000001101010
    [12, 33],                               // 000001101011
    [12, 40],                               // 000001101100
    [12, 41],                               // 000001101101
    [11, 22], [11, 22],                     // 00000110111x
    [8, 14], [8, 14], [8, 14], [8, 14],     // 00000111xxxx
    [8, 14], [8, 14], [8, 14], [8, 14],
    [8, 14], [8, 14], [8, 14], [8, 14],
    [8, 14], [8, 14], [8, 14], [8, 14],
    [7, 10], [7, 10], [7, 10], [7, 10],     // 0000100xxxxx
    [7, 10], [7, 10], [7, 10], [7, 10],
    [7, 10], [7, 10], [7, 10], [7, 10],
    [7, 10], [7, 10], [7, 10], [7, 10],
    [7, 10], [7, 10], [7, 10], [7, 10],
    [7, 10], [7, 10], [7, 10], [7, 10],
    [7, 10], [7, 10], [7, 10], [7, 10],
    [7, 10], [7, 10], [7, 10], [7, 10],
    [7, 11], [7, 11], [7, 11], [7, 11],     // 0000101xxxxx
    [7, 11], [7, 11], [7, 11], [7, 11],
    [7, 11], [7, 11], [7, 11], [7, 11],
    [7, 11], [7, 11], [7, 11], [7, 11],
    [7, 11], [7, 11], [7, 11], [7, 11],
    [7, 11], [7, 11], [7, 11], [7, 11],
    [7, 11], [7, 11], [7, 11], [7, 11],
    [7, 11], [7, 11], [7, 11], [7, 11],
    [9, 15], [9, 15], [9, 15], [9, 15],     // 000011000xxx
    [9, 15], [9, 15], [9, 15], [9, 15],
    [12, 128],                              // 000011001000
    [12, 192],                              // 000011001001
    [12, 26],                               // 000011001010
    [12, 27],                               // 000011001011
    [12, 28],                               // 000011001100
    [12, 29],                               // 000011001101
    [11, 19], [11, 19],                     // 00001100111x
    [11, 20], [11, 20],                     // 00001101000x
    [12, 34],                               // 000011010010
    [12, 35],                               // 000011010011
    [12, 36],                               // 000011010100
    [12, 37],                               // 000011010101
    [12, 38],                               // 000011010110
    [12, 39],                               // 000011010111
    [11, 21], [11, 21],                     // 00001101100x
    [12, 42],                               // 000011011010
    [12, 43],                               // 000011011011
    [10, 0], [10, 0], [10, 0], [10, 0],     // 0000110111xx
    [7, 12], [7, 12], [7, 12], [7, 12],     // 0000111xxxxx
    [7, 12], [7, 12], [7, 12], [7, 12],
    [7, 12], [7, 12], [7, 12], [7, 12],
    [7, 12], [7, 12], [7, 12], [7, 12],
    [7, 12], [7, 12], [7, 12], [7, 12],
    [7, 12], [7, 12], [7, 12], [7, 12],
    [7, 12], [7, 12], [7, 12], [7, 12],
    [7, 12], [7, 12], [7, 12], [7, 12]
  ];

  var blackTable3 = [
    [-1, -1], [-1, -1], [-1, -1], [-1, -1], // 0000xx
    [6, 9],                                 // 000100
    [6, 8],                                 // 000101
    [5, 7], [5, 7],                         // 00011x
    [4, 6], [4, 6], [4, 6], [4, 6],         // 0010xx
    [4, 5], [4, 5], [4, 5], [4, 5],         // 0011xx
    [3, 1], [3, 1], [3, 1], [3, 1],         // 010xxx
    [3, 1], [3, 1], [3, 1], [3, 1],
    [3, 4], [3, 4], [3, 4], [3, 4],         // 011xxx
    [3, 4], [3, 4], [3, 4], [3, 4],
    [2, 3], [2, 3], [2, 3], [2, 3],         // 10xxxx
    [2, 3], [2, 3], [2, 3], [2, 3],
    [2, 3], [2, 3], [2, 3], [2, 3],
    [2, 3], [2, 3], [2, 3], [2, 3],
    [2, 2], [2, 2], [2, 2], [2, 2],         // 11xxxx
    [2, 2], [2, 2], [2, 2], [2, 2],
    [2, 2], [2, 2], [2, 2], [2, 2],
    [2, 2], [2, 2], [2, 2], [2, 2]
  ];

  function CCITTFaxStream(str, maybeLength, params) {
    this.str = str;
    this.dict = str.dict;

    params = params || Dict.empty;

    this.encoding = params.get('K') || 0;
    this.eoline = params.get('EndOfLine') || false;
    this.byteAlign = params.get('EncodedByteAlign') || false;
    this.columns = params.get('Columns') || 1728;
    this.rows = params.get('Rows') || 0;
    var eoblock = params.get('EndOfBlock');
    if (eoblock === null || eoblock === undefined) {
      eoblock = true;
    }
    this.eoblock = eoblock;
    this.black = params.get('BlackIs1') || false;

    this.codingLine = new Uint32Array(this.columns + 1);
    this.refLine = new Uint32Array(this.columns + 2);

    this.codingLine[0] = this.columns;
    this.codingPos = 0;

    this.row = 0;
    this.nextLine2D = this.encoding < 0;
    this.inputBits = 0;
    this.inputBuf = 0;
    this.outputBits = 0;

    var code1;
    while ((code1 = this.lookBits(12)) === 0) {
      this.eatBits(1);
    }
    if (code1 === 1) {
      this.eatBits(12);
    }
    if (this.encoding > 0) {
      this.nextLine2D = !this.lookBits(1);
      this.eatBits(1);
    }

    DecodeStream.call(this, maybeLength);
  }

  CCITTFaxStream.prototype = Object.create(DecodeStream.prototype);

  CCITTFaxStream.prototype.readBlock = function CCITTFaxStream_readBlock() {
    while (!this.eof) {
      var c = this.lookChar();
      this.ensureBuffer(this.bufferLength + 1);
      this.buffer[this.bufferLength++] = c;
    }
  };

  CCITTFaxStream.prototype.addPixels =
      function ccittFaxStreamAddPixels(a1, blackPixels) {
    var codingLine = this.codingLine;
    var codingPos = this.codingPos;

    if (a1 > codingLine[codingPos]) {
      if (a1 > this.columns) {
        info('row is wrong length');
        this.err = true;
        a1 = this.columns;
      }
      if ((codingPos & 1) ^ blackPixels) {
        ++codingPos;
      }

      codingLine[codingPos] = a1;
    }
    this.codingPos = codingPos;
  };

  CCITTFaxStream.prototype.addPixelsNeg =
      function ccittFaxStreamAddPixelsNeg(a1, blackPixels) {
    var codingLine = this.codingLine;
    var codingPos = this.codingPos;

    if (a1 > codingLine[codingPos]) {
      if (a1 > this.columns) {
        info('row is wrong length');
        this.err = true;
        a1 = this.columns;
      }
      if ((codingPos & 1) ^ blackPixels) {
        ++codingPos;
      }

      codingLine[codingPos] = a1;
    } else if (a1 < codingLine[codingPos]) {
      if (a1 < 0) {
        info('invalid code');
        this.err = true;
        a1 = 0;
      }
      while (codingPos > 0 && a1 < codingLine[codingPos - 1]) {
        --codingPos;
      }
      codingLine[codingPos] = a1;
    }

    this.codingPos = codingPos;
  };

  CCITTFaxStream.prototype.lookChar = function CCITTFaxStream_lookChar() {
    var refLine = this.refLine;
    var codingLine = this.codingLine;
    var columns = this.columns;

    var refPos, blackPixels, bits, i;

    if (this.outputBits === 0) {
      if (this.eof) {
        return null;
      }
      this.err = false;

      var code1, code2, code3;
      if (this.nextLine2D) {
        for (i = 0; codingLine[i] < columns; ++i) {
          refLine[i] = codingLine[i];
        }
        refLine[i++] = columns;
        refLine[i] = columns;
        codingLine[0] = 0;
        this.codingPos = 0;
        refPos = 0;
        blackPixels = 0;

        while (codingLine[this.codingPos] < columns) {
          code1 = this.getTwoDimCode();
          switch (code1) {
            case twoDimPass:
              this.addPixels(refLine[refPos + 1], blackPixels);
              if (refLine[refPos + 1] < columns) {
                refPos += 2;
              }
              break;
            case twoDimHoriz:
              code1 = code2 = 0;
              if (blackPixels) {
                do {
                  code1 += (code3 = this.getBlackCode());
                } while (code3 >= 64);
                do {
                  code2 += (code3 = this.getWhiteCode());
                } while (code3 >= 64);
              } else {
                do {
                  code1 += (code3 = this.getWhiteCode());
                } while (code3 >= 64);
                do {
                  code2 += (code3 = this.getBlackCode());
                } while (code3 >= 64);
              }
              this.addPixels(codingLine[this.codingPos] +
                             code1, blackPixels);
              if (codingLine[this.codingPos] < columns) {
                this.addPixels(codingLine[this.codingPos] + code2,
                               blackPixels ^ 1);
              }
              while (refLine[refPos] <= codingLine[this.codingPos] &&
                     refLine[refPos] < columns) {
                refPos += 2;
              }
              break;
            case twoDimVertR3:
              this.addPixels(refLine[refPos] + 3, blackPixels);
              blackPixels ^= 1;
              if (codingLine[this.codingPos] < columns) {
                ++refPos;
                while (refLine[refPos] <= codingLine[this.codingPos] &&
                       refLine[refPos] < columns) {
                  refPos += 2;
                }
              }
              break;
            case twoDimVertR2:
              this.addPixels(refLine[refPos] + 2, blackPixels);
              blackPixels ^= 1;
              if (codingLine[this.codingPos] < columns) {
                ++refPos;
                while (refLine[refPos] <= codingLine[this.codingPos] &&
                       refLine[refPos] < columns) {
                  refPos += 2;
                }
              }
              break;
            case twoDimVertR1:
              this.addPixels(refLine[refPos] + 1, blackPixels);
              blackPixels ^= 1;
              if (codingLine[this.codingPos] < columns) {
                ++refPos;
                while (refLine[refPos] <= codingLine[this.codingPos] &&
                       refLine[refPos] < columns) {
                  refPos += 2;
                }
              }
              break;
            case twoDimVert0:
              this.addPixels(refLine[refPos], blackPixels);
              blackPixels ^= 1;
              if (codingLine[this.codingPos] < columns) {
                ++refPos;
                while (refLine[refPos] <= codingLine[this.codingPos] &&
                       refLine[refPos] < columns) {
                  refPos += 2;
                }
              }
              break;
            case twoDimVertL3:
              this.addPixelsNeg(refLine[refPos] - 3, blackPixels);
              blackPixels ^= 1;
              if (codingLine[this.codingPos] < columns) {
                if (refPos > 0) {
                  --refPos;
                } else {
                  ++refPos;
                }
                while (refLine[refPos] <= codingLine[this.codingPos] &&
                       refLine[refPos] < columns) {
                  refPos += 2;
                }
              }
              break;
            case twoDimVertL2:
              this.addPixelsNeg(refLine[refPos] - 2, blackPixels);
              blackPixels ^= 1;
              if (codingLine[this.codingPos] < columns) {
                if (refPos > 0) {
                  --refPos;
                } else {
                  ++refPos;
                }
                while (refLine[refPos] <= codingLine[this.codingPos] &&
                       refLine[refPos] < columns) {
                  refPos += 2;
                }
              }
              break;
            case twoDimVertL1:
              this.addPixelsNeg(refLine[refPos] - 1, blackPixels);
              blackPixels ^= 1;
              if (codingLine[this.codingPos] < columns) {
                if (refPos > 0) {
                  --refPos;
                } else {
                  ++refPos;
                }
                while (refLine[refPos] <= codingLine[this.codingPos] &&
                       refLine[refPos] < columns) {
                  refPos += 2;
                }
              }
              break;
            case ccittEOF:
              this.addPixels(columns, 0);
              this.eof = true;
              break;
            default:
              info('bad 2d code');
              this.addPixels(columns, 0);
              this.err = true;
          }
        }
      } else {
        codingLine[0] = 0;
        this.codingPos = 0;
        blackPixels = 0;
        while (codingLine[this.codingPos] < columns) {
          code1 = 0;
          if (blackPixels) {
            do {
              code1 += (code3 = this.getBlackCode());
            } while (code3 >= 64);
          } else {
            do {
              code1 += (code3 = this.getWhiteCode());
            } while (code3 >= 64);
          }
          this.addPixels(codingLine[this.codingPos] + code1, blackPixels);
          blackPixels ^= 1;
        }
      }

      var gotEOL = false;

      if (this.byteAlign) {
        this.inputBits &= ~7;
      }

      if (!this.eoblock && this.row === this.rows - 1) {
        this.eof = true;
      } else {
        code1 = this.lookBits(12);
        if (this.eoline) {
          while (code1 !== ccittEOF && code1 !== 1) {
            this.eatBits(1);
            code1 = this.lookBits(12);
          }
        } else {
          while (code1 === 0) {
            this.eatBits(1);
            code1 = this.lookBits(12);
          }
        }
        if (code1 === 1) {
          this.eatBits(12);
          gotEOL = true;
        } else if (code1 === ccittEOF) {
          this.eof = true;
        }
      }

      if (!this.eof && this.encoding > 0) {
        this.nextLine2D = !this.lookBits(1);
        this.eatBits(1);
      }

      if (this.eoblock && gotEOL && this.byteAlign) {
        code1 = this.lookBits(12);
        if (code1 === 1) {
          this.eatBits(12);
          if (this.encoding > 0) {
            this.lookBits(1);
            this.eatBits(1);
          }
          if (this.encoding >= 0) {
            for (i = 0; i < 4; ++i) {
              code1 = this.lookBits(12);
              if (code1 !== 1) {
                info('bad rtc code: ' + code1);
              }
              this.eatBits(12);
              if (this.encoding > 0) {
                this.lookBits(1);
                this.eatBits(1);
              }
            }
          }
          this.eof = true;
        }
      } else if (this.err && this.eoline) {
        while (true) {
          code1 = this.lookBits(13);
          if (code1 === ccittEOF) {
            this.eof = true;
            return null;
          }
          if ((code1 >> 1) === 1) {
            break;
          }
          this.eatBits(1);
        }
        this.eatBits(12);
        if (this.encoding > 0) {
          this.eatBits(1);
          this.nextLine2D = !(code1 & 1);
        }
      }

      if (codingLine[0] > 0) {
        this.outputBits = codingLine[this.codingPos = 0];
      } else {
        this.outputBits = codingLine[this.codingPos = 1];
      }
      this.row++;
    }

    var c;
    if (this.outputBits >= 8) {
      c = (this.codingPos & 1) ? 0 : 0xFF;
      this.outputBits -= 8;
      if (this.outputBits === 0 && codingLine[this.codingPos] < columns) {
        this.codingPos++;
        this.outputBits = (codingLine[this.codingPos] -
                           codingLine[this.codingPos - 1]);
      }
    } else {
      bits = 8;
      c = 0;
      do {
        if (this.outputBits > bits) {
          c <<= bits;
          if (!(this.codingPos & 1)) {
            c |= 0xFF >> (8 - bits);
          }
          this.outputBits -= bits;
          bits = 0;
        } else {
          c <<= this.outputBits;
          if (!(this.codingPos & 1)) {
            c |= 0xFF >> (8 - this.outputBits);
          }
          bits -= this.outputBits;
          this.outputBits = 0;
          if (codingLine[this.codingPos] < columns) {
            this.codingPos++;
            this.outputBits = (codingLine[this.codingPos] -
                               codingLine[this.codingPos - 1]);
          } else if (bits > 0) {
            c <<= bits;
            bits = 0;
          }
        }
      } while (bits);
    }
    if (this.black) {
      c ^= 0xFF;
    }
    return c;
  };

  // This functions returns the code found from the table.
  // The start and end parameters set the boundaries for searching the table.
  // The limit parameter is optional. Function returns an array with three
  // values. The first array element indicates whether a valid code is being
  // returned. The second array element is the actual code. The third array
  // element indicates whether EOF was reached.
  CCITTFaxStream.prototype.findTableCode =
      function ccittFaxStreamFindTableCode(start, end, table, limit) {

    var limitValue = limit || 0;
    for (var i = start; i <= end; ++i) {
      var code = this.lookBits(i);
      if (code === ccittEOF) {
        return [true, 1, false];
      }
      if (i < end) {
        code <<= end - i;
      }
      if (!limitValue || code >= limitValue) {
        var p = table[code - limitValue];
        if (p[0] === i) {
          this.eatBits(i);
          return [true, p[1], true];
        }
      }
    }
    return [false, 0, false];
  };

  CCITTFaxStream.prototype.getTwoDimCode =
      function ccittFaxStreamGetTwoDimCode() {

    var code = 0;
    var p;
    if (this.eoblock) {
      code = this.lookBits(7);
      p = twoDimTable[code];
      if (p && p[0] > 0) {
        this.eatBits(p[0]);
        return p[1];
      }
    } else {
      var result = this.findTableCode(1, 7, twoDimTable);
      if (result[0] && result[2]) {
        return result[1];
      }
    }
    info('Bad two dim code');
    return ccittEOF;
  };

  CCITTFaxStream.prototype.getWhiteCode =
      function ccittFaxStreamGetWhiteCode() {

    var code = 0;
    var p;
    if (this.eoblock) {
      code = this.lookBits(12);
      if (code === ccittEOF) {
        return 1;
      }

      if ((code >> 5) === 0) {
        p = whiteTable1[code];
      } else {
        p = whiteTable2[code >> 3];
      }

      if (p[0] > 0) {
        this.eatBits(p[0]);
        return p[1];
      }
    } else {
      var result = this.findTableCode(1, 9, whiteTable2);
      if (result[0]) {
        return result[1];
      }

      result = this.findTableCode(11, 12, whiteTable1);
      if (result[0]) {
        return result[1];
      }
    }
    info('bad white code');
    this.eatBits(1);
    return 1;
  };

  CCITTFaxStream.prototype.getBlackCode =
      function ccittFaxStreamGetBlackCode() {

    var code, p;
    if (this.eoblock) {
      code = this.lookBits(13);
      if (code === ccittEOF) {
        return 1;
      }
      if ((code >> 7) === 0) {
        p = blackTable1[code];
      } else if ((code >> 9) === 0 && (code >> 7) !== 0) {
        p = blackTable2[(code >> 1) - 64];
      } else {
        p = blackTable3[code >> 7];
      }

      if (p[0] > 0) {
        this.eatBits(p[0]);
        return p[1];
      }
    } else {
      var result = this.findTableCode(2, 6, blackTable3);
      if (result[0]) {
        return result[1];
      }

      result = this.findTableCode(7, 12, blackTable2, 64);
      if (result[0]) {
        return result[1];
      }

      result = this.findTableCode(10, 13, blackTable1);
      if (result[0]) {
        return result[1];
      }
    }
    info('bad black code');
    this.eatBits(1);
    return 1;
  };

  CCITTFaxStream.prototype.lookBits = function CCITTFaxStream_lookBits(n) {
    var c;
    while (this.inputBits < n) {
      if ((c = this.str.getByte()) === -1) {
        if (this.inputBits === 0) {
          return ccittEOF;
        }
        return ((this.inputBuf << (n - this.inputBits)) &
                (0xFFFF >> (16 - n)));
      }
      this.inputBuf = (this.inputBuf << 8) | c;
      this.inputBits += 8;
    }
    return (this.inputBuf >> (this.inputBits - n)) & (0xFFFF >> (16 - n));
  };

  CCITTFaxStream.prototype.eatBits = function CCITTFaxStream_eatBits(n) {
    if ((this.inputBits -= n) < 0) {
      this.inputBits = 0;
    }
  };

  return CCITTFaxStream;
})();

var LZWStream = (function LZWStreamClosure() {
  function LZWStream(str, maybeLength, earlyChange) {
    this.str = str;
    this.dict = str.dict;
    this.cachedData = 0;
    this.bitsCached = 0;

    var maxLzwDictionarySize = 4096;
    var lzwState = {
      earlyChange: earlyChange,
      codeLength: 9,
      nextCode: 258,
      dictionaryValues: new Uint8Array(maxLzwDictionarySize),
      dictionaryLengths: new Uint16Array(maxLzwDictionarySize),
      dictionaryPrevCodes: new Uint16Array(maxLzwDictionarySize),
      currentSequence: new Uint8Array(maxLzwDictionarySize),
      currentSequenceLength: 0
    };
    for (var i = 0; i < 256; ++i) {
      lzwState.dictionaryValues[i] = i;
      lzwState.dictionaryLengths[i] = 1;
    }
    this.lzwState = lzwState;

    DecodeStream.call(this, maybeLength);
  }

  LZWStream.prototype = Object.create(DecodeStream.prototype);

  LZWStream.prototype.readBits = function LZWStream_readBits(n) {
    var bitsCached = this.bitsCached;
    var cachedData = this.cachedData;
    while (bitsCached < n) {
      var c = this.str.getByte();
      if (c === -1) {
        this.eof = true;
        return null;
      }
      cachedData = (cachedData << 8) | c;
      bitsCached += 8;
    }
    this.bitsCached = (bitsCached -= n);
    this.cachedData = cachedData;
    this.lastCode = null;
    return (cachedData >>> bitsCached) & ((1 << n) - 1);
  };

  LZWStream.prototype.readBlock = function LZWStream_readBlock() {
    var blockSize = 512;
    var estimatedDecodedSize = blockSize * 2, decodedSizeDelta = blockSize;
    var i, j, q;

    var lzwState = this.lzwState;
    if (!lzwState) {
      return; // eof was found
    }

    var earlyChange = lzwState.earlyChange;
    var nextCode = lzwState.nextCode;
    var dictionaryValues = lzwState.dictionaryValues;
    var dictionaryLengths = lzwState.dictionaryLengths;
    var dictionaryPrevCodes = lzwState.dictionaryPrevCodes;
    var codeLength = lzwState.codeLength;
    var prevCode = lzwState.prevCode;
    var currentSequence = lzwState.currentSequence;
    var currentSequenceLength = lzwState.currentSequenceLength;

    var decodedLength = 0;
    var currentBufferLength = this.bufferLength;
    var buffer = this.ensureBuffer(this.bufferLength + estimatedDecodedSize);

    for (i = 0; i < blockSize; i++) {
      var code = this.readBits(codeLength);
      var hasPrev = currentSequenceLength > 0;
      if (code < 256) {
        currentSequence[0] = code;
        currentSequenceLength = 1;
      } else if (code >= 258) {
        if (code < nextCode) {
          currentSequenceLength = dictionaryLengths[code];
          for (j = currentSequenceLength - 1, q = code; j >= 0; j--) {
            currentSequence[j] = dictionaryValues[q];
            q = dictionaryPrevCodes[q];
          }
        } else {
          currentSequence[currentSequenceLength++] = currentSequence[0];
        }
      } else if (code === 256) {
        codeLength = 9;
        nextCode = 258;
        currentSequenceLength = 0;
        continue;
      } else {
        this.eof = true;
        delete this.lzwState;
        break;
      }

      if (hasPrev) {
        dictionaryPrevCodes[nextCode] = prevCode;
        dictionaryLengths[nextCode] = dictionaryLengths[prevCode] + 1;
        dictionaryValues[nextCode] = currentSequence[0];
        nextCode++;
        codeLength = (nextCode + earlyChange) & (nextCode + earlyChange - 1) ?
          codeLength : Math.min(Math.log(nextCode + earlyChange) /
          0.6931471805599453 + 1, 12) | 0;
      }
      prevCode = code;

      decodedLength += currentSequenceLength;
      if (estimatedDecodedSize < decodedLength) {
        do {
          estimatedDecodedSize += decodedSizeDelta;
        } while (estimatedDecodedSize < decodedLength);
        buffer = this.ensureBuffer(this.bufferLength + estimatedDecodedSize);
      }
      for (j = 0; j < currentSequenceLength; j++) {
        buffer[currentBufferLength++] = currentSequence[j];
      }
    }
    lzwState.nextCode = nextCode;
    lzwState.codeLength = codeLength;
    lzwState.prevCode = prevCode;
    lzwState.currentSequenceLength = currentSequenceLength;

    this.bufferLength = currentBufferLength;
  };

  return LZWStream;
})();

var NullStream = (function NullStreamClosure() {
  function NullStream() {
    Stream.call(this, new Uint8Array(0));
  }

  NullStream.prototype = Stream.prototype;

  return NullStream;
})();

exports.Ascii85Stream = Ascii85Stream;
exports.AsciiHexStream = AsciiHexStream;
exports.CCITTFaxStream = CCITTFaxStream;
exports.DecryptStream = DecryptStream;
exports.DecodeStream = DecodeStream;
exports.FlateStream = FlateStream;
exports.Jbig2Stream = Jbig2Stream;
exports.JpegStream = JpegStream;
exports.JpxStream = JpxStream;
exports.NullStream = NullStream;
exports.PredictorStream = PredictorStream;
exports.RunLengthStream = RunLengthStream;
exports.Stream = Stream;
exports.StreamsSequenceStream = StreamsSequenceStream;
exports.StringStream = StringStream;
exports.LZWStream = LZWStream;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreCrypto = {}), root.pdfjsSharedUtil,
      root.pdfjsCorePrimitives, root.pdfjsCoreStream);
  }
}(this, function (exports, sharedUtil, corePrimitives, coreStream) {

var PasswordException = sharedUtil.PasswordException;
var PasswordResponses = sharedUtil.PasswordResponses;
var bytesToString = sharedUtil.bytesToString;
var error = sharedUtil.error;
var isInt = sharedUtil.isInt;
var stringToBytes = sharedUtil.stringToBytes;
var utf8StringToString = sharedUtil.utf8StringToString;
var warn = sharedUtil.warn;
var Name = corePrimitives.Name;
var isName = corePrimitives.isName;
var isDict = corePrimitives.isDict;
var DecryptStream = coreStream.DecryptStream;

var ARCFourCipher = (function ARCFourCipherClosure() {
  function ARCFourCipher(key) {
    this.a = 0;
    this.b = 0;
    var s = new Uint8Array(256);
    var i, j = 0, tmp, keyLength = key.length;
    for (i = 0; i < 256; ++i) {
      s[i] = i;
    }
    for (i = 0; i < 256; ++i) {
      tmp = s[i];
      j = (j + tmp + key[i % keyLength]) & 0xFF;
      s[i] = s[j];
      s[j] = tmp;
    }
    this.s = s;
  }

  ARCFourCipher.prototype = {
    encryptBlock: function ARCFourCipher_encryptBlock(data) {
      var i, n = data.length, tmp, tmp2;
      var a = this.a, b = this.b, s = this.s;
      var output = new Uint8Array(n);
      for (i = 0; i < n; ++i) {
        a = (a + 1) & 0xFF;
        tmp = s[a];
        b = (b + tmp) & 0xFF;
        tmp2 = s[b];
        s[a] = tmp2;
        s[b] = tmp;
        output[i] = data[i] ^ s[(tmp + tmp2) & 0xFF];
      }
      this.a = a;
      this.b = b;
      return output;
    }
  };
  ARCFourCipher.prototype.decryptBlock = ARCFourCipher.prototype.encryptBlock;

  return ARCFourCipher;
})();

var calculateMD5 = (function calculateMD5Closure() {
  var r = new Uint8Array([
    7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22, 7, 12, 17, 22,
    5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20, 5, 9, 14, 20,
    4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23, 4, 11, 16, 23,
    6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21, 6, 10, 15, 21]);

  var k = new Int32Array([
    -680876936, -389564586, 606105819, -1044525330, -176418897, 1200080426,
    -1473231341, -45705983, 1770035416, -1958414417, -42063, -1990404162,
    1804603682, -40341101, -1502002290, 1236535329, -165796510, -1069501632,
    643717713, -373897302, -701558691, 38016083, -660478335, -405537848,
    568446438, -1019803690, -187363961, 1163531501, -1444681467, -51403784,
    1735328473, -1926607734, -378558, -2022574463, 1839030562, -35309556,
    -1530992060, 1272893353, -155497632, -1094730640, 681279174, -358537222,
    -722521979, 76029189, -640364487, -421815835, 530742520, -995338651,
    -198630844, 1126891415, -1416354905, -57434055, 1700485571, -1894986606,
    -1051523, -2054922799, 1873313359, -30611744, -1560198380, 1309151649,
    -145523070, -1120210379, 718787259, -343485551]);

  function hash(data, offset, length) {
    var h0 = 1732584193, h1 = -271733879, h2 = -1732584194, h3 = 271733878;
    // pre-processing
    var paddedLength = (length + 72) & ~63; // data + 9 extra bytes
    var padded = new Uint8Array(paddedLength);
    var i, j, n;
    for (i = 0; i < length; ++i) {
      padded[i] = data[offset++];
    }
    padded[i++] = 0x80;
    n = paddedLength - 8;
    while (i < n) {
      padded[i++] = 0;
    }
    padded[i++] = (length << 3) & 0xFF;
    padded[i++] = (length >> 5) & 0xFF;
    padded[i++] = (length >> 13) & 0xFF;
    padded[i++] = (length >> 21) & 0xFF;
    padded[i++] = (length >>> 29) & 0xFF;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    var w = new Int32Array(16);
    for (i = 0; i < paddedLength;) {
      for (j = 0; j < 16; ++j, i += 4) {
        w[j] = (padded[i] | (padded[i + 1] << 8) |
               (padded[i + 2] << 16) | (padded[i + 3] << 24));
      }
      var a = h0, b = h1, c = h2, d = h3, f, g;
      for (j = 0; j < 64; ++j) {
        if (j < 16) {
          f = (b & c) | ((~b) & d);
          g = j;
        } else if (j < 32) {
          f = (d & b) | ((~d) & c);
          g = (5 * j + 1) & 15;
        } else if (j < 48) {
          f = b ^ c ^ d;
          g = (3 * j + 5) & 15;
        } else {
          f = c ^ (b | (~d));
          g = (7 * j) & 15;
        }
        var tmp = d, rotateArg = (a + f + k[j] + w[g]) | 0, rotate = r[j];
        d = c;
        c = b;
        b = (b + ((rotateArg << rotate) | (rotateArg >>> (32 - rotate)))) | 0;
        a = tmp;
      }
      h0 = (h0 + a) | 0;
      h1 = (h1 + b) | 0;
      h2 = (h2 + c) | 0;
      h3 = (h3 + d) | 0;
    }
    return new Uint8Array([
      h0 & 0xFF, (h0 >> 8) & 0xFF, (h0 >> 16) & 0xFF, (h0 >>> 24) & 0xFF,
      h1 & 0xFF, (h1 >> 8) & 0xFF, (h1 >> 16) & 0xFF, (h1 >>> 24) & 0xFF,
      h2 & 0xFF, (h2 >> 8) & 0xFF, (h2 >> 16) & 0xFF, (h2 >>> 24) & 0xFF,
      h3 & 0xFF, (h3 >> 8) & 0xFF, (h3 >> 16) & 0xFF, (h3 >>> 24) & 0xFF
    ]);
  }

  return hash;
})();
var Word64 = (function Word64Closure() {
  function Word64(highInteger, lowInteger) {
    this.high = highInteger | 0;
    this.low = lowInteger | 0;
  }
  Word64.prototype = {
    and: function Word64_and(word) {
      this.high &= word.high;
      this.low &= word.low;
    },
    xor: function Word64_xor(word) {
     this.high ^= word.high;
     this.low ^= word.low;
    },

    or: function Word64_or(word) {
      this.high |= word.high;
      this.low |= word.low;
    },

    shiftRight: function Word64_shiftRight(places) {
      if (places >= 32) {
        this.low = (this.high >>> (places - 32)) | 0;
        this.high = 0;
      } else {
        this.low = (this.low >>> places) | (this.high << (32 - places));
        this.high = (this.high >>> places) | 0;
      }
    },

    shiftLeft: function Word64_shiftLeft(places) {
      if (places >= 32) {
        this.high = this.low << (places - 32);
        this.low = 0;
      } else {
        this.high = (this.high << places) | (this.low >>> (32 - places));
        this.low = this.low << places;
      }
    },

    rotateRight: function Word64_rotateRight(places) {
      var low, high;
      if (places & 32) {
        high = this.low;
        low = this.high;
      } else {
        low = this.low;
        high = this.high;
      }
      places &= 31;
      this.low = (low >>> places) | (high << (32 - places));
      this.high = (high >>> places) | (low << (32 - places));
    },

    not: function Word64_not() {
      this.high = ~this.high;
      this.low = ~this.low;
    },

    add: function Word64_add(word) {
      var lowAdd = (this.low >>> 0) + (word.low >>> 0);
      var highAdd = (this.high >>> 0) + (word.high >>> 0);
      if (lowAdd > 0xFFFFFFFF) {
        highAdd += 1;
      }
      this.low = lowAdd | 0;
      this.high = highAdd | 0;
    },

    copyTo: function Word64_copyTo(bytes, offset) {
      bytes[offset] = (this.high >>> 24) & 0xFF;
      bytes[offset + 1] = (this.high >> 16) & 0xFF;
      bytes[offset + 2] = (this.high >> 8) & 0xFF;
      bytes[offset + 3] = this.high & 0xFF;
      bytes[offset + 4] = (this.low >>> 24) & 0xFF;
      bytes[offset + 5] = (this.low >> 16) & 0xFF;
      bytes[offset + 6] = (this.low >> 8) & 0xFF;
      bytes[offset + 7] = this.low & 0xFF;
    },

    assign: function Word64_assign(word) {
      this.high = word.high;
      this.low = word.low;
    }
  };
  return Word64;
})();

var calculateSHA256 = (function calculateSHA256Closure() {
  function rotr(x, n) {
    return (x >>> n) | (x << 32 - n);
  }

  function ch(x, y, z) {
    return (x & y) ^ (~x & z);
  }

  function maj(x, y, z) {
    return (x & y) ^ (x & z) ^ (y & z);
  }

  function sigma(x) {
    return rotr(x, 2) ^ rotr(x, 13) ^ rotr(x, 22);
  }

  function sigmaPrime(x) {
    return rotr(x, 6) ^ rotr(x, 11) ^ rotr(x, 25);
  }

  function littleSigma(x) {
    return rotr(x, 7) ^ rotr(x, 18) ^ x >>> 3;
  }

  function littleSigmaPrime(x) {
    return rotr(x, 17) ^ rotr(x, 19) ^ x >>> 10;
  }

  var k = [0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
           0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
           0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
           0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
           0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
           0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
           0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
           0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
           0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
           0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
           0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
           0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
           0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
           0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
           0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
           0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2];

  function hash(data, offset, length) {
    // initial hash values
    var h0 = 0x6a09e667, h1 = 0xbb67ae85, h2 = 0x3c6ef372,
        h3 = 0xa54ff53a, h4 = 0x510e527f, h5 = 0x9b05688c,
        h6 = 0x1f83d9ab, h7 = 0x5be0cd19;
    // pre-processing
    var paddedLength = Math.ceil((length + 9) / 64) * 64;
    var padded = new Uint8Array(paddedLength);
    var i, j, n;
    for (i = 0; i < length; ++i) {
      padded[i] = data[offset++];
    }
    padded[i++] = 0x80;
    n = paddedLength - 8;
    while (i < n) {
      padded[i++] = 0;
    }
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = (length >>> 29) & 0xFF;
    padded[i++] = (length >> 21) & 0xFF;
    padded[i++] = (length >> 13) & 0xFF;
    padded[i++] = (length >> 5) & 0xFF;
    padded[i++] = (length << 3) & 0xFF;
    var w = new Uint32Array(64);
    // for each 512 bit block
    for (i = 0; i < paddedLength;) {
      for (j = 0; j < 16; ++j) {
        w[j] = (padded[i] << 24 | (padded[i + 1] << 16) |
               (padded[i + 2] << 8) | (padded[i + 3]));
        i += 4;
      }

      for (j = 16; j < 64; ++j) {
        w[j] = littleSigmaPrime(w[j - 2]) + w[j - 7] +
               littleSigma(w[j - 15]) + w[j - 16] | 0;
      }
      var a = h0, b = h1, c = h2, d = h3, e = h4,
          f = h5, g = h6, h = h7, t1, t2;
      for (j = 0; j < 64; ++j) {
        t1 = h + sigmaPrime(e) + ch(e, f, g) + k[j] + w[j];
        t2 = sigma(a) + maj(a, b, c);
        h = g;
        g = f;
        f = e;
        e = (d + t1) | 0;
        d = c;
        c = b;
        b = a;
        a = (t1 + t2) | 0;
      }
      h0 = (h0 + a) | 0;
      h1 = (h1 + b) | 0;
      h2 = (h2 + c) | 0;
      h3 = (h3 + d) | 0;
      h4 = (h4 + e) | 0;
      h5 = (h5 + f) | 0;
      h6 = (h6 + g) | 0;
      h7 = (h7 + h) | 0;
    }
    return new Uint8Array([
      (h0 >> 24) & 0xFF, (h0 >> 16) & 0xFF, (h0 >> 8) & 0xFF, (h0) & 0xFF,
      (h1 >> 24) & 0xFF, (h1 >> 16) & 0xFF, (h1 >> 8) & 0xFF, (h1) & 0xFF,
      (h2 >> 24) & 0xFF, (h2 >> 16) & 0xFF, (h2 >> 8) & 0xFF, (h2) & 0xFF,
      (h3 >> 24) & 0xFF, (h3 >> 16) & 0xFF, (h3 >> 8) & 0xFF, (h3) & 0xFF,
      (h4 >> 24) & 0xFF, (h4 >> 16) & 0xFF, (h4 >> 8) & 0xFF, (h4) & 0xFF,
      (h5 >> 24) & 0xFF, (h5 >> 16) & 0xFF, (h5 >> 8) & 0xFF, (h5) & 0xFF,
      (h6 >> 24) & 0xFF, (h6 >> 16) & 0xFF, (h6 >> 8) & 0xFF, (h6) & 0xFF,
      (h7 >> 24) & 0xFF, (h7 >> 16) & 0xFF, (h7 >> 8) & 0xFF, (h7) & 0xFF
    ]);
  }

  return hash;
})();

var calculateSHA512 = (function calculateSHA512Closure() {
  function ch(result, x, y, z, tmp) {
    result.assign(x);
    result.and(y);
    tmp.assign(x);
    tmp.not();
    tmp.and(z);
    result.xor(tmp);
  }

  function maj(result, x, y, z, tmp) {
    result.assign(x);
    result.and(y);
    tmp.assign(x);
    tmp.and(z);
    result.xor(tmp);
    tmp.assign(y);
    tmp.and(z);
    result.xor(tmp);
  }

  function sigma(result, x, tmp) {
    result.assign(x);
    result.rotateRight(28);
    tmp.assign(x);
    tmp.rotateRight(34);
    result.xor(tmp);
    tmp.assign(x);
    tmp.rotateRight(39);
    result.xor(tmp);
  }

  function sigmaPrime(result, x, tmp) {
    result.assign(x);
    result.rotateRight(14);
    tmp.assign(x);
    tmp.rotateRight(18);
    result.xor(tmp);
    tmp.assign(x);
    tmp.rotateRight(41);
    result.xor(tmp);
  }

  function littleSigma(result, x, tmp) {
    result.assign(x);
    result.rotateRight(1);
    tmp.assign(x);
    tmp.rotateRight(8);
    result.xor(tmp);
    tmp.assign(x);
    tmp.shiftRight(7);
    result.xor(tmp);
  }

  function littleSigmaPrime(result, x, tmp) {
    result.assign(x);
    result.rotateRight(19);
    tmp.assign(x);
    tmp.rotateRight(61);
    result.xor(tmp);
    tmp.assign(x);
    tmp.shiftRight(6);
    result.xor(tmp);
  }

  var k = [
    new Word64(0x428a2f98, 0xd728ae22), new Word64(0x71374491, 0x23ef65cd),
    new Word64(0xb5c0fbcf, 0xec4d3b2f), new Word64(0xe9b5dba5, 0x8189dbbc),
    new Word64(0x3956c25b, 0xf348b538), new Word64(0x59f111f1, 0xb605d019),
    new Word64(0x923f82a4, 0xaf194f9b), new Word64(0xab1c5ed5, 0xda6d8118),
    new Word64(0xd807aa98, 0xa3030242), new Word64(0x12835b01, 0x45706fbe),
    new Word64(0x243185be, 0x4ee4b28c), new Word64(0x550c7dc3, 0xd5ffb4e2),
    new Word64(0x72be5d74, 0xf27b896f), new Word64(0x80deb1fe, 0x3b1696b1),
    new Word64(0x9bdc06a7, 0x25c71235), new Word64(0xc19bf174, 0xcf692694),
    new Word64(0xe49b69c1, 0x9ef14ad2), new Word64(0xefbe4786, 0x384f25e3),
    new Word64(0x0fc19dc6, 0x8b8cd5b5), new Word64(0x240ca1cc, 0x77ac9c65),
    new Word64(0x2de92c6f, 0x592b0275), new Word64(0x4a7484aa, 0x6ea6e483),
    new Word64(0x5cb0a9dc, 0xbd41fbd4), new Word64(0x76f988da, 0x831153b5),
    new Word64(0x983e5152, 0xee66dfab), new Word64(0xa831c66d, 0x2db43210),
    new Word64(0xb00327c8, 0x98fb213f), new Word64(0xbf597fc7, 0xbeef0ee4),
    new Word64(0xc6e00bf3, 0x3da88fc2), new Word64(0xd5a79147, 0x930aa725),
    new Word64(0x06ca6351, 0xe003826f), new Word64(0x14292967, 0x0a0e6e70),
    new Word64(0x27b70a85, 0x46d22ffc), new Word64(0x2e1b2138, 0x5c26c926),
    new Word64(0x4d2c6dfc, 0x5ac42aed), new Word64(0x53380d13, 0x9d95b3df),
    new Word64(0x650a7354, 0x8baf63de), new Word64(0x766a0abb, 0x3c77b2a8),
    new Word64(0x81c2c92e, 0x47edaee6), new Word64(0x92722c85, 0x1482353b),
    new Word64(0xa2bfe8a1, 0x4cf10364), new Word64(0xa81a664b, 0xbc423001),
    new Word64(0xc24b8b70, 0xd0f89791), new Word64(0xc76c51a3, 0x0654be30),
    new Word64(0xd192e819, 0xd6ef5218), new Word64(0xd6990624, 0x5565a910),
    new Word64(0xf40e3585, 0x5771202a), new Word64(0x106aa070, 0x32bbd1b8),
    new Word64(0x19a4c116, 0xb8d2d0c8), new Word64(0x1e376c08, 0x5141ab53),
    new Word64(0x2748774c, 0xdf8eeb99), new Word64(0x34b0bcb5, 0xe19b48a8),
    new Word64(0x391c0cb3, 0xc5c95a63), new Word64(0x4ed8aa4a, 0xe3418acb),
    new Word64(0x5b9cca4f, 0x7763e373), new Word64(0x682e6ff3, 0xd6b2b8a3),
    new Word64(0x748f82ee, 0x5defb2fc), new Word64(0x78a5636f, 0x43172f60),
    new Word64(0x84c87814, 0xa1f0ab72), new Word64(0x8cc70208, 0x1a6439ec),
    new Word64(0x90befffa, 0x23631e28), new Word64(0xa4506ceb, 0xde82bde9),
    new Word64(0xbef9a3f7, 0xb2c67915), new Word64(0xc67178f2, 0xe372532b),
    new Word64(0xca273ece, 0xea26619c), new Word64(0xd186b8c7, 0x21c0c207),
    new Word64(0xeada7dd6, 0xcde0eb1e), new Word64(0xf57d4f7f, 0xee6ed178),
    new Word64(0x06f067aa, 0x72176fba), new Word64(0x0a637dc5, 0xa2c898a6),
    new Word64(0x113f9804, 0xbef90dae), new Word64(0x1b710b35, 0x131c471b),
    new Word64(0x28db77f5, 0x23047d84), new Word64(0x32caab7b, 0x40c72493),
    new Word64(0x3c9ebe0a, 0x15c9bebc), new Word64(0x431d67c4, 0x9c100d4c),
    new Word64(0x4cc5d4be, 0xcb3e42b6), new Word64(0x597f299c, 0xfc657e2a),
    new Word64(0x5fcb6fab, 0x3ad6faec), new Word64(0x6c44198c, 0x4a475817)];

  function hash(data, offset, length, mode384) {
    mode384 = !!mode384;
    // initial hash values
    var h0, h1, h2, h3, h4, h5, h6, h7;
    if (!mode384) {
      h0 = new Word64(0x6a09e667, 0xf3bcc908);
      h1 = new Word64(0xbb67ae85, 0x84caa73b);
      h2 = new Word64(0x3c6ef372, 0xfe94f82b);
      h3 = new Word64(0xa54ff53a, 0x5f1d36f1);
      h4 = new Word64(0x510e527f, 0xade682d1);
      h5 = new Word64(0x9b05688c, 0x2b3e6c1f);
      h6 = new Word64(0x1f83d9ab, 0xfb41bd6b);
      h7 = new Word64(0x5be0cd19, 0x137e2179);
    }
    else {
      // SHA384 is exactly the same
      // except with different starting values and a trimmed result
      h0 = new Word64(0xcbbb9d5d, 0xc1059ed8);
      h1 = new Word64(0x629a292a, 0x367cd507);
      h2 = new Word64(0x9159015a, 0x3070dd17);
      h3 = new Word64(0x152fecd8, 0xf70e5939);
      h4 = new Word64(0x67332667, 0xffc00b31);
      h5 = new Word64(0x8eb44a87, 0x68581511);
      h6 = new Word64(0xdb0c2e0d, 0x64f98fa7);
      h7 = new Word64(0x47b5481d, 0xbefa4fa4);
    }

    // pre-processing
    var paddedLength = Math.ceil((length + 17) / 128) * 128;
    var padded = new Uint8Array(paddedLength);
    var i, j, n;
    for (i = 0; i < length; ++i) {
      padded[i] = data[offset++];
    }
    padded[i++] = 0x80;
    n = paddedLength - 16;
    while (i < n) {
      padded[i++] = 0;
    }
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = 0;
    padded[i++] = (length >>> 29) & 0xFF;
    padded[i++] = (length >> 21) & 0xFF;
    padded[i++] = (length >> 13) & 0xFF;
    padded[i++] = (length >> 5) & 0xFF;
    padded[i++] = (length << 3) & 0xFF;

    var w = new Array(80);
    for (i = 0; i < 80; i++) {
      w[i] = new Word64(0, 0);
    }
    var a = new Word64(0, 0), b = new Word64(0, 0), c = new Word64(0, 0);
    var d = new Word64(0, 0), e = new Word64(0, 0), f = new Word64(0, 0);
    var g = new Word64(0, 0), h = new Word64(0, 0);
    var t1 = new Word64(0, 0), t2 = new Word64(0, 0);
    var tmp1 = new Word64(0, 0), tmp2 = new Word64(0, 0), tmp3;

    // for each 1024 bit block
    for (i = 0; i < paddedLength;) {
      for (j = 0; j < 16; ++j) {
        w[j].high = (padded[i] << 24) | (padded[i + 1] << 16) |
                    (padded[i + 2] << 8) | (padded[i + 3]);
        w[j].low = (padded[i + 4]) << 24 | (padded[i + 5]) << 16 |
                   (padded[i + 6]) << 8 | (padded[i + 7]);
        i += 8;
      }
      for (j = 16; j < 80; ++j) {
        tmp3 = w[j];
        littleSigmaPrime(tmp3, w[j - 2], tmp2);
        tmp3.add(w[j - 7]);
        littleSigma(tmp1, w[j - 15], tmp2);
        tmp3.add(tmp1);
        tmp3.add(w[j - 16]);
      }

      a.assign(h0); b.assign(h1); c.assign(h2); d.assign(h3);
      e.assign(h4); f.assign(h5); g.assign(h6); h.assign(h7);
      for (j = 0; j < 80; ++j) {
        t1.assign(h);
        sigmaPrime(tmp1, e, tmp2);
        t1.add(tmp1);
        ch(tmp1, e, f, g, tmp2);
        t1.add(tmp1);
        t1.add(k[j]);
        t1.add(w[j]);

        sigma(t2, a, tmp2);
        maj(tmp1, a, b, c, tmp2);
        t2.add(tmp1);

        tmp3 = h;
        h = g;
        g = f;
        f = e;
        d.add(t1);
        e = d;
        d = c;
        c = b;
        b = a;
        tmp3.assign(t1);
        tmp3.add(t2);
        a = tmp3;
      }
      h0.add(a);
      h1.add(b);
      h2.add(c);
      h3.add(d);
      h4.add(e);
      h5.add(f);
      h6.add(g);
      h7.add(h);
    }

    var result;
    if (!mode384) {
      result = new Uint8Array(64);
      h0.copyTo(result,0);
      h1.copyTo(result,8);
      h2.copyTo(result,16);
      h3.copyTo(result,24);
      h4.copyTo(result,32);
      h5.copyTo(result,40);
      h6.copyTo(result,48);
      h7.copyTo(result,56);
    }
    else {
      result = new Uint8Array(48);
      h0.copyTo(result,0);
      h1.copyTo(result,8);
      h2.copyTo(result,16);
      h3.copyTo(result,24);
      h4.copyTo(result,32);
      h5.copyTo(result,40);
    }
    return result;
  }

  return hash;
})();
var calculateSHA384 = (function calculateSHA384Closure() {
  function hash(data, offset, length) {
    return calculateSHA512(data, offset, length, true);
  }

  return hash;
})();
var NullCipher = (function NullCipherClosure() {
  function NullCipher() {
  }

  NullCipher.prototype = {
    decryptBlock: function NullCipher_decryptBlock(data) {
      return data;
    }
  };

  return NullCipher;
})();

var AES128Cipher = (function AES128CipherClosure() {
  var rcon = new Uint8Array([
    0x8d, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c,
    0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a,
    0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd,
    0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a,
    0x74, 0xe8, 0xcb, 0x8d, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80,
    0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6,
    0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72,
    0xe4, 0xd3, 0xbd, 0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc,
    0x83, 0x1d, 0x3a, 0x74, 0xe8, 0xcb, 0x8d, 0x01, 0x02, 0x04, 0x08, 0x10,
    0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e,
    0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5,
    0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd, 0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94,
    0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a, 0x74, 0xe8, 0xcb, 0x8d, 0x01, 0x02,
    0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d,
    0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d,
    0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd, 0x61, 0xc2, 0x9f,
    0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a, 0x74, 0xe8, 0xcb,
    0x8d, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c,
    0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a,
    0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd,
    0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a,
    0x74, 0xe8, 0xcb, 0x8d]);

  var s = new Uint8Array([
    0x63, 0x7c, 0x77, 0x7b, 0xf2, 0x6b, 0x6f, 0xc5, 0x30, 0x01, 0x67, 0x2b,
    0xfe, 0xd7, 0xab, 0x76, 0xca, 0x82, 0xc9, 0x7d, 0xfa, 0x59, 0x47, 0xf0,
    0xad, 0xd4, 0xa2, 0xaf, 0x9c, 0xa4, 0x72, 0xc0, 0xb7, 0xfd, 0x93, 0x26,
    0x36, 0x3f, 0xf7, 0xcc, 0x34, 0xa5, 0xe5, 0xf1, 0x71, 0xd8, 0x31, 0x15,
    0x04, 0xc7, 0x23, 0xc3, 0x18, 0x96, 0x05, 0x9a, 0x07, 0x12, 0x80, 0xe2,
    0xeb, 0x27, 0xb2, 0x75, 0x09, 0x83, 0x2c, 0x1a, 0x1b, 0x6e, 0x5a, 0xa0,
    0x52, 0x3b, 0xd6, 0xb3, 0x29, 0xe3, 0x2f, 0x84, 0x53, 0xd1, 0x00, 0xed,
    0x20, 0xfc, 0xb1, 0x5b, 0x6a, 0xcb, 0xbe, 0x39, 0x4a, 0x4c, 0x58, 0xcf,
    0xd0, 0xef, 0xaa, 0xfb, 0x43, 0x4d, 0x33, 0x85, 0x45, 0xf9, 0x02, 0x7f,
    0x50, 0x3c, 0x9f, 0xa8, 0x51, 0xa3, 0x40, 0x8f, 0x92, 0x9d, 0x38, 0xf5,
    0xbc, 0xb6, 0xda, 0x21, 0x10, 0xff, 0xf3, 0xd2, 0xcd, 0x0c, 0x13, 0xec,
    0x5f, 0x97, 0x44, 0x17, 0xc4, 0xa7, 0x7e, 0x3d, 0x64, 0x5d, 0x19, 0x73,
    0x60, 0x81, 0x4f, 0xdc, 0x22, 0x2a, 0x90, 0x88, 0x46, 0xee, 0xb8, 0x14,
    0xde, 0x5e, 0x0b, 0xdb, 0xe0, 0x32, 0x3a, 0x0a, 0x49, 0x06, 0x24, 0x5c,
    0xc2, 0xd3, 0xac, 0x62, 0x91, 0x95, 0xe4, 0x79, 0xe7, 0xc8, 0x37, 0x6d,
    0x8d, 0xd5, 0x4e, 0xa9, 0x6c, 0x56, 0xf4, 0xea, 0x65, 0x7a, 0xae, 0x08,
    0xba, 0x78, 0x25, 0x2e, 0x1c, 0xa6, 0xb4, 0xc6, 0xe8, 0xdd, 0x74, 0x1f,
    0x4b, 0xbd, 0x8b, 0x8a, 0x70, 0x3e, 0xb5, 0x66, 0x48, 0x03, 0xf6, 0x0e,
    0x61, 0x35, 0x57, 0xb9, 0x86, 0xc1, 0x1d, 0x9e, 0xe1, 0xf8, 0x98, 0x11,
    0x69, 0xd9, 0x8e, 0x94, 0x9b, 0x1e, 0x87, 0xe9, 0xce, 0x55, 0x28, 0xdf,
    0x8c, 0xa1, 0x89, 0x0d, 0xbf, 0xe6, 0x42, 0x68, 0x41, 0x99, 0x2d, 0x0f,
    0xb0, 0x54, 0xbb, 0x16]);

  var inv_s = new Uint8Array([
    0x52, 0x09, 0x6a, 0xd5, 0x30, 0x36, 0xa5, 0x38, 0xbf, 0x40, 0xa3, 0x9e,
    0x81, 0xf3, 0xd7, 0xfb, 0x7c, 0xe3, 0x39, 0x82, 0x9b, 0x2f, 0xff, 0x87,
    0x34, 0x8e, 0x43, 0x44, 0xc4, 0xde, 0xe9, 0xcb, 0x54, 0x7b, 0x94, 0x32,
    0xa6, 0xc2, 0x23, 0x3d, 0xee, 0x4c, 0x95, 0x0b, 0x42, 0xfa, 0xc3, 0x4e,
    0x08, 0x2e, 0xa1, 0x66, 0x28, 0xd9, 0x24, 0xb2, 0x76, 0x5b, 0xa2, 0x49,
    0x6d, 0x8b, 0xd1, 0x25, 0x72, 0xf8, 0xf6, 0x64, 0x86, 0x68, 0x98, 0x16,
    0xd4, 0xa4, 0x5c, 0xcc, 0x5d, 0x65, 0xb6, 0x92, 0x6c, 0x70, 0x48, 0x50,
    0xfd, 0xed, 0xb9, 0xda, 0x5e, 0x15, 0x46, 0x57, 0xa7, 0x8d, 0x9d, 0x84,
    0x90, 0xd8, 0xab, 0x00, 0x8c, 0xbc, 0xd3, 0x0a, 0xf7, 0xe4, 0x58, 0x05,
    0xb8, 0xb3, 0x45, 0x06, 0xd0, 0x2c, 0x1e, 0x8f, 0xca, 0x3f, 0x0f, 0x02,
    0xc1, 0xaf, 0xbd, 0x03, 0x01, 0x13, 0x8a, 0x6b, 0x3a, 0x91, 0x11, 0x41,
    0x4f, 0x67, 0xdc, 0xea, 0x97, 0xf2, 0xcf, 0xce, 0xf0, 0xb4, 0xe6, 0x73,
    0x96, 0xac, 0x74, 0x22, 0xe7, 0xad, 0x35, 0x85, 0xe2, 0xf9, 0x37, 0xe8,
    0x1c, 0x75, 0xdf, 0x6e, 0x47, 0xf1, 0x1a, 0x71, 0x1d, 0x29, 0xc5, 0x89,
    0x6f, 0xb7, 0x62, 0x0e, 0xaa, 0x18, 0xbe, 0x1b, 0xfc, 0x56, 0x3e, 0x4b,
    0xc6, 0xd2, 0x79, 0x20, 0x9a, 0xdb, 0xc0, 0xfe, 0x78, 0xcd, 0x5a, 0xf4,
    0x1f, 0xdd, 0xa8, 0x33, 0x88, 0x07, 0xc7, 0x31, 0xb1, 0x12, 0x10, 0x59,
    0x27, 0x80, 0xec, 0x5f, 0x60, 0x51, 0x7f, 0xa9, 0x19, 0xb5, 0x4a, 0x0d,
    0x2d, 0xe5, 0x7a, 0x9f, 0x93, 0xc9, 0x9c, 0xef, 0xa0, 0xe0, 0x3b, 0x4d,
    0xae, 0x2a, 0xf5, 0xb0, 0xc8, 0xeb, 0xbb, 0x3c, 0x83, 0x53, 0x99, 0x61,
    0x17, 0x2b, 0x04, 0x7e, 0xba, 0x77, 0xd6, 0x26, 0xe1, 0x69, 0x14, 0x63,
    0x55, 0x21, 0x0c, 0x7d]);
  var mixCol = new Uint8Array(256);
  for (var i = 0; i < 256; i++) {
    if (i < 128) {
      mixCol[i] = i << 1;
    } else {
      mixCol[i] = (i << 1) ^ 0x1b;
    }
  }
  var mix = new Uint32Array([
    0x00000000, 0x0e090d0b, 0x1c121a16, 0x121b171d, 0x3824342c, 0x362d3927,
    0x24362e3a, 0x2a3f2331, 0x70486858, 0x7e416553, 0x6c5a724e, 0x62537f45,
    0x486c5c74, 0x4665517f, 0x547e4662, 0x5a774b69, 0xe090d0b0, 0xee99ddbb,
    0xfc82caa6, 0xf28bc7ad, 0xd8b4e49c, 0xd6bde997, 0xc4a6fe8a, 0xcaaff381,
    0x90d8b8e8, 0x9ed1b5e3, 0x8ccaa2fe, 0x82c3aff5, 0xa8fc8cc4, 0xa6f581cf,
    0xb4ee96d2, 0xbae79bd9, 0xdb3bbb7b, 0xd532b670, 0xc729a16d, 0xc920ac66,
    0xe31f8f57, 0xed16825c, 0xff0d9541, 0xf104984a, 0xab73d323, 0xa57ade28,
    0xb761c935, 0xb968c43e, 0x9357e70f, 0x9d5eea04, 0x8f45fd19, 0x814cf012,
    0x3bab6bcb, 0x35a266c0, 0x27b971dd, 0x29b07cd6, 0x038f5fe7, 0x0d8652ec,
    0x1f9d45f1, 0x119448fa, 0x4be30393, 0x45ea0e98, 0x57f11985, 0x59f8148e,
    0x73c737bf, 0x7dce3ab4, 0x6fd52da9, 0x61dc20a2, 0xad766df6, 0xa37f60fd,
    0xb16477e0, 0xbf6d7aeb, 0x955259da, 0x9b5b54d1, 0x894043cc, 0x87494ec7,
    0xdd3e05ae, 0xd33708a5, 0xc12c1fb8, 0xcf2512b3, 0xe51a3182, 0xeb133c89,
    0xf9082b94, 0xf701269f, 0x4de6bd46, 0x43efb04d, 0x51f4a750, 0x5ffdaa5b,
    0x75c2896a, 0x7bcb8461, 0x69d0937c, 0x67d99e77, 0x3daed51e, 0x33a7d815,
    0x21bccf08, 0x2fb5c203, 0x058ae132, 0x0b83ec39, 0x1998fb24, 0x1791f62f,
    0x764dd68d, 0x7844db86, 0x6a5fcc9b, 0x6456c190, 0x4e69e2a1, 0x4060efaa,
    0x527bf8b7, 0x5c72f5bc, 0x0605bed5, 0x080cb3de, 0x1a17a4c3, 0x141ea9c8,
    0x3e218af9, 0x302887f2, 0x223390ef, 0x2c3a9de4, 0x96dd063d, 0x98d40b36,
    0x8acf1c2b, 0x84c61120, 0xaef93211, 0xa0f03f1a, 0xb2eb2807, 0xbce2250c,
    0xe6956e65, 0xe89c636e, 0xfa877473, 0xf48e7978, 0xdeb15a49, 0xd0b85742,
    0xc2a3405f, 0xccaa4d54, 0x41ecdaf7, 0x4fe5d7fc, 0x5dfec0e1, 0x53f7cdea,
    0x79c8eedb, 0x77c1e3d0, 0x65daf4cd, 0x6bd3f9c6, 0x31a4b2af, 0x3fadbfa4,
    0x2db6a8b9, 0x23bfa5b2, 0x09808683, 0x07898b88, 0x15929c95, 0x1b9b919e,
    0xa17c0a47, 0xaf75074c, 0xbd6e1051, 0xb3671d5a, 0x99583e6b, 0x97513360,
    0x854a247d, 0x8b432976, 0xd134621f, 0xdf3d6f14, 0xcd267809, 0xc32f7502,
    0xe9105633, 0xe7195b38, 0xf5024c25, 0xfb0b412e, 0x9ad7618c, 0x94de6c87,
    0x86c57b9a, 0x88cc7691, 0xa2f355a0, 0xacfa58ab, 0xbee14fb6, 0xb0e842bd,
    0xea9f09d4, 0xe49604df, 0xf68d13c2, 0xf8841ec9, 0xd2bb3df8, 0xdcb230f3,
    0xcea927ee, 0xc0a02ae5, 0x7a47b13c, 0x744ebc37, 0x6655ab2a, 0x685ca621,
    0x42638510, 0x4c6a881b, 0x5e719f06, 0x5078920d, 0x0a0fd964, 0x0406d46f,
    0x161dc372, 0x1814ce79, 0x322bed48, 0x3c22e043, 0x2e39f75e, 0x2030fa55,
    0xec9ab701, 0xe293ba0a, 0xf088ad17, 0xfe81a01c, 0xd4be832d, 0xdab78e26,
    0xc8ac993b, 0xc6a59430, 0x9cd2df59, 0x92dbd252, 0x80c0c54f, 0x8ec9c844,
    0xa4f6eb75, 0xaaffe67e, 0xb8e4f163, 0xb6edfc68, 0x0c0a67b1, 0x02036aba,
    0x10187da7, 0x1e1170ac, 0x342e539d, 0x3a275e96, 0x283c498b, 0x26354480,
    0x7c420fe9, 0x724b02e2, 0x605015ff, 0x6e5918f4, 0x44663bc5, 0x4a6f36ce,
    0x587421d3, 0x567d2cd8, 0x37a10c7a, 0x39a80171, 0x2bb3166c, 0x25ba1b67,
    0x0f853856, 0x018c355d, 0x13972240, 0x1d9e2f4b, 0x47e96422, 0x49e06929,
    0x5bfb7e34, 0x55f2733f, 0x7fcd500e, 0x71c45d05, 0x63df4a18, 0x6dd64713,
    0xd731dcca, 0xd938d1c1, 0xcb23c6dc, 0xc52acbd7, 0xef15e8e6, 0xe11ce5ed,
    0xf307f2f0, 0xfd0efffb, 0xa779b492, 0xa970b999, 0xbb6bae84, 0xb562a38f,
    0x9f5d80be, 0x91548db5, 0x834f9aa8, 0x8d4697a3]);

  function expandKey128(cipherKey) {
    var b = 176, result = new Uint8Array(b);
    result.set(cipherKey);
    for (var j = 16, i = 1; j < b; ++i) {
      // RotWord
      var t1 = result[j - 3], t2 = result[j - 2],
          t3 = result[j - 1], t4 = result[j - 4];
      // SubWord
      t1 = s[t1];
      t2 = s[t2];
      t3 = s[t3];
      t4 = s[t4];
      // Rcon
      t1 = t1 ^ rcon[i];
      for (var n = 0; n < 4; ++n) {
        result[j] = (t1 ^= result[j - 16]);
        j++;
        result[j] = (t2 ^= result[j - 16]);
        j++;
        result[j] = (t3 ^= result[j - 16]);
        j++;
        result[j] = (t4 ^= result[j - 16]);
        j++;
      }
    }
    return result;
  }

  function decrypt128(input, key) {
    var state = new Uint8Array(16);
    state.set(input);
    var i, j, k;
    var t, u, v;
    // AddRoundKey
    for (j = 0, k = 160; j < 16; ++j, ++k) {
      state[j] ^= key[k];
    }
    for (i = 9; i >= 1; --i) {
      // InvShiftRows
      t = state[13];
      state[13] = state[9];
      state[9] = state[5];
      state[5] = state[1];
      state[1] = t;
      t = state[14];
      u = state[10];
      state[14] = state[6];
      state[10] = state[2];
      state[6] = t;
      state[2] = u;
      t = state[15];
      u = state[11];
      v = state[7];
      state[15] = state[3];
      state[11] = t;
      state[7] = u;
      state[3] = v;
      // InvSubBytes
      for (j = 0; j < 16; ++j) {
        state[j] = inv_s[state[j]];
      }
      // AddRoundKey
      for (j = 0, k = i * 16; j < 16; ++j, ++k) {
        state[j] ^= key[k];
      }
      // InvMixColumns
      for (j = 0; j < 16; j += 4) {
        var s0 = mix[state[j]], s1 = mix[state[j + 1]],
          s2 = mix[state[j + 2]], s3 = mix[state[j + 3]];
        t = (s0 ^ (s1 >>> 8) ^ (s1 << 24) ^ (s2 >>> 16) ^ (s2 << 16) ^
          (s3 >>> 24) ^ (s3 << 8));
        state[j] = (t >>> 24) & 0xFF;
        state[j + 1] = (t >> 16) & 0xFF;
        state[j + 2] = (t >> 8) & 0xFF;
        state[j + 3] = t & 0xFF;
      }
    }
    // InvShiftRows
    t = state[13];
    state[13] = state[9];
    state[9] = state[5];
    state[5] = state[1];
    state[1] = t;
    t = state[14];
    u = state[10];
    state[14] = state[6];
    state[10] = state[2];
    state[6] = t;
    state[2] = u;
    t = state[15];
    u = state[11];
    v = state[7];
    state[15] = state[3];
    state[11] = t;
    state[7] = u;
    state[3] = v;
    for (j = 0; j < 16; ++j) {
      // InvSubBytes
      state[j] = inv_s[state[j]];
      // AddRoundKey
      state[j] ^= key[j];
    }
    return state;
  }

  function encrypt128(input, key) {
    var t, u, v, k;
    var state = new Uint8Array(16);
    state.set(input);
    for (j = 0; j < 16; ++j) {
      // AddRoundKey
      state[j] ^= key[j];
    }

    for (i = 1; i < 10; i++) {
      //SubBytes
      for (j = 0; j < 16; ++j) {
        state[j] = s[state[j]];
      }
      //ShiftRows
      v = state[1];
      state[1] = state[5];
      state[5] = state[9];
      state[9] = state[13];
      state[13] = v;
      v = state[2];
      u = state[6];
      state[2] = state[10];
      state[6] = state[14];
      state[10] = v;
      state[14] = u;
      v = state[3];
      u = state[7];
      t = state[11];
      state[3] = state[15];
      state[7] = v;
      state[11] = u;
      state[15] = t;
      //MixColumns
      for (var j = 0; j < 16; j += 4) {
        var s0 = state[j + 0], s1 = state[j + 1];
        var s2 = state[j + 2], s3 = state[j + 3];
        t = s0 ^ s1 ^ s2 ^ s3;
        state[j + 0] ^= t ^ mixCol[s0 ^ s1];
        state[j + 1] ^= t ^ mixCol[s1 ^ s2];
        state[j + 2] ^= t ^ mixCol[s2 ^ s3];
        state[j + 3] ^= t ^ mixCol[s3 ^ s0];
      }
      //AddRoundKey
      for (j = 0, k = i * 16; j < 16; ++j, ++k) {
        state[j] ^= key[k];
      }
    }

    //SubBytes
    for (j = 0; j < 16; ++j) {
      state[j] = s[state[j]];
    }
    //ShiftRows
    v = state[1];
    state[1] = state[5];
    state[5] = state[9];
    state[9] = state[13];
    state[13] = v;
    v = state[2];
    u = state[6];
    state[2] = state[10];
    state[6] = state[14];
    state[10] = v;
    state[14] = u;
    v = state[3];
    u = state[7];
    t = state[11];
    state[3] = state[15];
    state[7] = v;
    state[11] = u;
    state[15] = t;
    //AddRoundKey
    for (j = 0, k = 160; j < 16; ++j, ++k) {
      state[j] ^= key[k];
    }
    return state;
  }

  function AES128Cipher(key) {
    this.key = expandKey128(key);
    this.buffer = new Uint8Array(16);
    this.bufferPosition = 0;
  }

  function decryptBlock2(data, finalize) {
    var i, j, ii, sourceLength = data.length,
        buffer = this.buffer, bufferLength = this.bufferPosition,
        result = [], iv = this.iv;
    for (i = 0; i < sourceLength; ++i) {
      buffer[bufferLength] = data[i];
      ++bufferLength;
      if (bufferLength < 16) {
        continue;
      }
      // buffer is full, decrypting
      var plain = decrypt128(buffer, this.key);
      // xor-ing the IV vector to get plain text
      for (j = 0; j < 16; ++j) {
        plain[j] ^= iv[j];
      }
      iv = buffer;
      result.push(plain);
      buffer = new Uint8Array(16);
      bufferLength = 0;
    }
    // saving incomplete buffer
    this.buffer = buffer;
    this.bufferLength = bufferLength;
    this.iv = iv;
    if (result.length === 0) {
      return new Uint8Array([]);
    }
    // combining plain text blocks into one
    var outputLength = 16 * result.length;
    if (finalize) {
      // undo a padding that is described in RFC 2898
      var lastBlock = result[result.length - 1];
      var psLen = lastBlock[15];
      if (psLen <= 16) {
        for (i = 15, ii = 16 - psLen; i >= ii; --i) {
          if (lastBlock[i] !== psLen) {
            // Invalid padding, assume that the block has no padding.
            psLen = 0;
            break;
          }
        }
        outputLength -= psLen;
        result[result.length - 1] = lastBlock.subarray(0, 16 - psLen);
      }
    }
    var output = new Uint8Array(outputLength);
    for (i = 0, j = 0, ii = result.length; i < ii; ++i, j += 16) {
      output.set(result[i], j);
    }
    return output;
  }

  AES128Cipher.prototype = {
    decryptBlock: function AES128Cipher_decryptBlock(data, finalize) {
      var i, sourceLength = data.length;
      var buffer = this.buffer, bufferLength = this.bufferPosition;
      // waiting for IV values -- they are at the start of the stream
      for (i = 0; bufferLength < 16 && i < sourceLength; ++i, ++bufferLength) {
        buffer[bufferLength] = data[i];
      }
      if (bufferLength < 16) {
        // need more data
        this.bufferLength = bufferLength;
        return new Uint8Array([]);
      }
      this.iv = buffer;
      this.buffer = new Uint8Array(16);
      this.bufferLength = 0;
      // starting decryption
      this.decryptBlock = decryptBlock2;
      return this.decryptBlock(data.subarray(16), finalize);
    },
    encrypt: function AES128Cipher_encrypt(data, iv) {
      var i, j, ii, sourceLength = data.length,
          buffer = this.buffer, bufferLength = this.bufferPosition,
          result = [];
      if (!iv) {
        iv = new Uint8Array(16);
      }
      for (i = 0; i < sourceLength; ++i) {
        buffer[bufferLength] = data[i];
        ++bufferLength;
        if (bufferLength < 16) {
          continue;
        }
        for (j = 0; j < 16; ++j) {
          buffer[j] ^= iv[j];
        }

        // buffer is full, encrypting
        var cipher = encrypt128(buffer, this.key);
        iv = cipher;
        result.push(cipher);
        buffer = new Uint8Array(16);
        bufferLength = 0;
      }
      // saving incomplete buffer
      this.buffer = buffer;
      this.bufferLength = bufferLength;
      this.iv = iv;
      if (result.length === 0) {
        return new Uint8Array([]);
      }
      // combining plain text blocks into one
      var outputLength = 16 * result.length;
      var output = new Uint8Array(outputLength);
      for (i = 0, j = 0, ii = result.length; i < ii; ++i, j += 16) {
        output.set(result[i], j);
      }
      return output;
    }
  };

  return AES128Cipher;
})();

var AES256Cipher = (function AES256CipherClosure() {
  var rcon = new Uint8Array([
    0x8d, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c,
    0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a,
    0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd,
    0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a,
    0x74, 0xe8, 0xcb, 0x8d, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80,
    0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6,
    0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72,
    0xe4, 0xd3, 0xbd, 0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc,
    0x83, 0x1d, 0x3a, 0x74, 0xe8, 0xcb, 0x8d, 0x01, 0x02, 0x04, 0x08, 0x10,
    0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e,
    0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5,
    0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd, 0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94,
    0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a, 0x74, 0xe8, 0xcb, 0x8d, 0x01, 0x02,
    0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c, 0xd8, 0xab, 0x4d,
    0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a, 0xd4, 0xb3, 0x7d,
    0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd, 0x61, 0xc2, 0x9f,
    0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a, 0x74, 0xe8, 0xcb,
    0x8d, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36, 0x6c,
    0xd8, 0xab, 0x4d, 0x9a, 0x2f, 0x5e, 0xbc, 0x63, 0xc6, 0x97, 0x35, 0x6a,
    0xd4, 0xb3, 0x7d, 0xfa, 0xef, 0xc5, 0x91, 0x39, 0x72, 0xe4, 0xd3, 0xbd,
    0x61, 0xc2, 0x9f, 0x25, 0x4a, 0x94, 0x33, 0x66, 0xcc, 0x83, 0x1d, 0x3a,
    0x74, 0xe8, 0xcb, 0x8d]);

  var s = new Uint8Array([
    0x63, 0x7c, 0x77, 0x7b, 0xf2, 0x6b, 0x6f, 0xc5, 0x30, 0x01, 0x67, 0x2b,
    0xfe, 0xd7, 0xab, 0x76, 0xca, 0x82, 0xc9, 0x7d, 0xfa, 0x59, 0x47, 0xf0,
    0xad, 0xd4, 0xa2, 0xaf, 0x9c, 0xa4, 0x72, 0xc0, 0xb7, 0xfd, 0x93, 0x26,
    0x36, 0x3f, 0xf7, 0xcc, 0x34, 0xa5, 0xe5, 0xf1, 0x71, 0xd8, 0x31, 0x15,
    0x04, 0xc7, 0x23, 0xc3, 0x18, 0x96, 0x05, 0x9a, 0x07, 0x12, 0x80, 0xe2,
    0xeb, 0x27, 0xb2, 0x75, 0x09, 0x83, 0x2c, 0x1a, 0x1b, 0x6e, 0x5a, 0xa0,
    0x52, 0x3b, 0xd6, 0xb3, 0x29, 0xe3, 0x2f, 0x84, 0x53, 0xd1, 0x00, 0xed,
    0x20, 0xfc, 0xb1, 0x5b, 0x6a, 0xcb, 0xbe, 0x39, 0x4a, 0x4c, 0x58, 0xcf,
    0xd0, 0xef, 0xaa, 0xfb, 0x43, 0x4d, 0x33, 0x85, 0x45, 0xf9, 0x02, 0x7f,
    0x50, 0x3c, 0x9f, 0xa8, 0x51, 0xa3, 0x40, 0x8f, 0x92, 0x9d, 0x38, 0xf5,
    0xbc, 0xb6, 0xda, 0x21, 0x10, 0xff, 0xf3, 0xd2, 0xcd, 0x0c, 0x13, 0xec,
    0x5f, 0x97, 0x44, 0x17, 0xc4, 0xa7, 0x7e, 0x3d, 0x64, 0x5d, 0x19, 0x73,
    0x60, 0x81, 0x4f, 0xdc, 0x22, 0x2a, 0x90, 0x88, 0x46, 0xee, 0xb8, 0x14,
    0xde, 0x5e, 0x0b, 0xdb, 0xe0, 0x32, 0x3a, 0x0a, 0x49, 0x06, 0x24, 0x5c,
    0xc2, 0xd3, 0xac, 0x62, 0x91, 0x95, 0xe4, 0x79, 0xe7, 0xc8, 0x37, 0x6d,
    0x8d, 0xd5, 0x4e, 0xa9, 0x6c, 0x56, 0xf4, 0xea, 0x65, 0x7a, 0xae, 0x08,
    0xba, 0x78, 0x25, 0x2e, 0x1c, 0xa6, 0xb4, 0xc6, 0xe8, 0xdd, 0x74, 0x1f,
    0x4b, 0xbd, 0x8b, 0x8a, 0x70, 0x3e, 0xb5, 0x66, 0x48, 0x03, 0xf6, 0x0e,
    0x61, 0x35, 0x57, 0xb9, 0x86, 0xc1, 0x1d, 0x9e, 0xe1, 0xf8, 0x98, 0x11,
    0x69, 0xd9, 0x8e, 0x94, 0x9b, 0x1e, 0x87, 0xe9, 0xce, 0x55, 0x28, 0xdf,
    0x8c, 0xa1, 0x89, 0x0d, 0xbf, 0xe6, 0x42, 0x68, 0x41, 0x99, 0x2d, 0x0f,
    0xb0, 0x54, 0xbb, 0x16]);

  var inv_s = new Uint8Array([
    0x52, 0x09, 0x6a, 0xd5, 0x30, 0x36, 0xa5, 0x38, 0xbf, 0x40, 0xa3, 0x9e,
    0x81, 0xf3, 0xd7, 0xfb, 0x7c, 0xe3, 0x39, 0x82, 0x9b, 0x2f, 0xff, 0x87,
    0x34, 0x8e, 0x43, 0x44, 0xc4, 0xde, 0xe9, 0xcb, 0x54, 0x7b, 0x94, 0x32,
    0xa6, 0xc2, 0x23, 0x3d, 0xee, 0x4c, 0x95, 0x0b, 0x42, 0xfa, 0xc3, 0x4e,
    0x08, 0x2e, 0xa1, 0x66, 0x28, 0xd9, 0x24, 0xb2, 0x76, 0x5b, 0xa2, 0x49,
    0x6d, 0x8b, 0xd1, 0x25, 0x72, 0xf8, 0xf6, 0x64, 0x86, 0x68, 0x98, 0x16,
    0xd4, 0xa4, 0x5c, 0xcc, 0x5d, 0x65, 0xb6, 0x92, 0x6c, 0x70, 0x48, 0x50,
    0xfd, 0xed, 0xb9, 0xda, 0x5e, 0x15, 0x46, 0x57, 0xa7, 0x8d, 0x9d, 0x84,
    0x90, 0xd8, 0xab, 0x00, 0x8c, 0xbc, 0xd3, 0x0a, 0xf7, 0xe4, 0x58, 0x05,
    0xb8, 0xb3, 0x45, 0x06, 0xd0, 0x2c, 0x1e, 0x8f, 0xca, 0x3f, 0x0f, 0x02,
    0xc1, 0xaf, 0xbd, 0x03, 0x01, 0x13, 0x8a, 0x6b, 0x3a, 0x91, 0x11, 0x41,
    0x4f, 0x67, 0xdc, 0xea, 0x97, 0xf2, 0xcf, 0xce, 0xf0, 0xb4, 0xe6, 0x73,
    0x96, 0xac, 0x74, 0x22, 0xe7, 0xad, 0x35, 0x85, 0xe2, 0xf9, 0x37, 0xe8,
    0x1c, 0x75, 0xdf, 0x6e, 0x47, 0xf1, 0x1a, 0x71, 0x1d, 0x29, 0xc5, 0x89,
    0x6f, 0xb7, 0x62, 0x0e, 0xaa, 0x18, 0xbe, 0x1b, 0xfc, 0x56, 0x3e, 0x4b,
    0xc6, 0xd2, 0x79, 0x20, 0x9a, 0xdb, 0xc0, 0xfe, 0x78, 0xcd, 0x5a, 0xf4,
    0x1f, 0xdd, 0xa8, 0x33, 0x88, 0x07, 0xc7, 0x31, 0xb1, 0x12, 0x10, 0x59,
    0x27, 0x80, 0xec, 0x5f, 0x60, 0x51, 0x7f, 0xa9, 0x19, 0xb5, 0x4a, 0x0d,
    0x2d, 0xe5, 0x7a, 0x9f, 0x93, 0xc9, 0x9c, 0xef, 0xa0, 0xe0, 0x3b, 0x4d,
    0xae, 0x2a, 0xf5, 0xb0, 0xc8, 0xeb, 0xbb, 0x3c, 0x83, 0x53, 0x99, 0x61,
    0x17, 0x2b, 0x04, 0x7e, 0xba, 0x77, 0xd6, 0x26, 0xe1, 0x69, 0x14, 0x63,
    0x55, 0x21, 0x0c, 0x7d]);

  var mixCol = new Uint8Array(256);
  for (var i = 0; i < 256; i++) {
    if (i < 128) {
      mixCol[i] = i << 1;
    } else {
      mixCol[i] = (i << 1) ^ 0x1b;
    }
  }
  var mix = new Uint32Array([
    0x00000000, 0x0e090d0b, 0x1c121a16, 0x121b171d, 0x3824342c, 0x362d3927,
    0x24362e3a, 0x2a3f2331, 0x70486858, 0x7e416553, 0x6c5a724e, 0x62537f45,
    0x486c5c74, 0x4665517f, 0x547e4662, 0x5a774b69, 0xe090d0b0, 0xee99ddbb,
    0xfc82caa6, 0xf28bc7ad, 0xd8b4e49c, 0xd6bde997, 0xc4a6fe8a, 0xcaaff381,
    0x90d8b8e8, 0x9ed1b5e3, 0x8ccaa2fe, 0x82c3aff5, 0xa8fc8cc4, 0xa6f581cf,
    0xb4ee96d2, 0xbae79bd9, 0xdb3bbb7b, 0xd532b670, 0xc729a16d, 0xc920ac66,
    0xe31f8f57, 0xed16825c, 0xff0d9541, 0xf104984a, 0xab73d323, 0xa57ade28,
    0xb761c935, 0xb968c43e, 0x9357e70f, 0x9d5eea04, 0x8f45fd19, 0x814cf012,
    0x3bab6bcb, 0x35a266c0, 0x27b971dd, 0x29b07cd6, 0x038f5fe7, 0x0d8652ec,
    0x1f9d45f1, 0x119448fa, 0x4be30393, 0x45ea0e98, 0x57f11985, 0x59f8148e,
    0x73c737bf, 0x7dce3ab4, 0x6fd52da9, 0x61dc20a2, 0xad766df6, 0xa37f60fd,
    0xb16477e0, 0xbf6d7aeb, 0x955259da, 0x9b5b54d1, 0x894043cc, 0x87494ec7,
    0xdd3e05ae, 0xd33708a5, 0xc12c1fb8, 0xcf2512b3, 0xe51a3182, 0xeb133c89,
    0xf9082b94, 0xf701269f, 0x4de6bd46, 0x43efb04d, 0x51f4a750, 0x5ffdaa5b,
    0x75c2896a, 0x7bcb8461, 0x69d0937c, 0x67d99e77, 0x3daed51e, 0x33a7d815,
    0x21bccf08, 0x2fb5c203, 0x058ae132, 0x0b83ec39, 0x1998fb24, 0x1791f62f,
    0x764dd68d, 0x7844db86, 0x6a5fcc9b, 0x6456c190, 0x4e69e2a1, 0x4060efaa,
    0x527bf8b7, 0x5c72f5bc, 0x0605bed5, 0x080cb3de, 0x1a17a4c3, 0x141ea9c8,
    0x3e218af9, 0x302887f2, 0x223390ef, 0x2c3a9de4, 0x96dd063d, 0x98d40b36,
    0x8acf1c2b, 0x84c61120, 0xaef93211, 0xa0f03f1a, 0xb2eb2807, 0xbce2250c,
    0xe6956e65, 0xe89c636e, 0xfa877473, 0xf48e7978, 0xdeb15a49, 0xd0b85742,
    0xc2a3405f, 0xccaa4d54, 0x41ecdaf7, 0x4fe5d7fc, 0x5dfec0e1, 0x53f7cdea,
    0x79c8eedb, 0x77c1e3d0, 0x65daf4cd, 0x6bd3f9c6, 0x31a4b2af, 0x3fadbfa4,
    0x2db6a8b9, 0x23bfa5b2, 0x09808683, 0x07898b88, 0x15929c95, 0x1b9b919e,
    0xa17c0a47, 0xaf75074c, 0xbd6e1051, 0xb3671d5a, 0x99583e6b, 0x97513360,
    0x854a247d, 0x8b432976, 0xd134621f, 0xdf3d6f14, 0xcd267809, 0xc32f7502,
    0xe9105633, 0xe7195b38, 0xf5024c25, 0xfb0b412e, 0x9ad7618c, 0x94de6c87,
    0x86c57b9a, 0x88cc7691, 0xa2f355a0, 0xacfa58ab, 0xbee14fb6, 0xb0e842bd,
    0xea9f09d4, 0xe49604df, 0xf68d13c2, 0xf8841ec9, 0xd2bb3df8, 0xdcb230f3,
    0xcea927ee, 0xc0a02ae5, 0x7a47b13c, 0x744ebc37, 0x6655ab2a, 0x685ca621,
    0x42638510, 0x4c6a881b, 0x5e719f06, 0x5078920d, 0x0a0fd964, 0x0406d46f,
    0x161dc372, 0x1814ce79, 0x322bed48, 0x3c22e043, 0x2e39f75e, 0x2030fa55,
    0xec9ab701, 0xe293ba0a, 0xf088ad17, 0xfe81a01c, 0xd4be832d, 0xdab78e26,
    0xc8ac993b, 0xc6a59430, 0x9cd2df59, 0x92dbd252, 0x80c0c54f, 0x8ec9c844,
    0xa4f6eb75, 0xaaffe67e, 0xb8e4f163, 0xb6edfc68, 0x0c0a67b1, 0x02036aba,
    0x10187da7, 0x1e1170ac, 0x342e539d, 0x3a275e96, 0x283c498b, 0x26354480,
    0x7c420fe9, 0x724b02e2, 0x605015ff, 0x6e5918f4, 0x44663bc5, 0x4a6f36ce,
    0x587421d3, 0x567d2cd8, 0x37a10c7a, 0x39a80171, 0x2bb3166c, 0x25ba1b67,
    0x0f853856, 0x018c355d, 0x13972240, 0x1d9e2f4b, 0x47e96422, 0x49e06929,
    0x5bfb7e34, 0x55f2733f, 0x7fcd500e, 0x71c45d05, 0x63df4a18, 0x6dd64713,
    0xd731dcca, 0xd938d1c1, 0xcb23c6dc, 0xc52acbd7, 0xef15e8e6, 0xe11ce5ed,
    0xf307f2f0, 0xfd0efffb, 0xa779b492, 0xa970b999, 0xbb6bae84, 0xb562a38f,
    0x9f5d80be, 0x91548db5, 0x834f9aa8, 0x8d4697a3]);

  function expandKey256(cipherKey) {
    var b = 240, result = new Uint8Array(b);
    var r = 1;

    result.set(cipherKey);
    for (var j = 32, i = 1; j < b; ++i) {
      if (j % 32 === 16) {
        t1 = s[t1];
        t2 = s[t2];
        t3 = s[t3];
        t4 = s[t4];
      } else if (j % 32 === 0) {
        // RotWord
        var t1 = result[j - 3], t2 = result[j - 2],
          t3 = result[j - 1], t4 = result[j - 4];
        // SubWord
        t1 = s[t1];
        t2 = s[t2];
        t3 = s[t3];
        t4 = s[t4];
        // Rcon
        t1 = t1 ^ r;
        if ((r <<= 1) >= 256) {
          r = (r ^ 0x1b) & 0xFF;
        }
      }

      for (var n = 0; n < 4; ++n) {
        result[j] = (t1 ^= result[j - 32]);
        j++;
        result[j] = (t2 ^= result[j - 32]);
        j++;
        result[j] = (t3 ^= result[j - 32]);
        j++;
        result[j] = (t4 ^= result[j - 32]);
        j++;
      }
    }
    return result;
  }

  function decrypt256(input, key) {
    var state = new Uint8Array(16);
    state.set(input);
    var i, j, k;
    var t, u, v;
    // AddRoundKey
    for (j = 0, k = 224; j < 16; ++j, ++k) {
      state[j] ^= key[k];
    }
    for (i = 13; i >= 1; --i) {
      // InvShiftRows
      t = state[13];
      state[13] = state[9];
      state[9] = state[5];
      state[5] = state[1];
      state[1] = t;
      t = state[14];
      u = state[10];
      state[14] = state[6];
      state[10] = state[2];
      state[6] = t;
      state[2] = u;
      t = state[15];
      u = state[11];
      v = state[7];
      state[15] = state[3];
      state[11] = t;
      state[7] = u;
      state[3] = v;
      // InvSubBytes
      for (j = 0; j < 16; ++j) {
        state[j] = inv_s[state[j]];
      }
      // AddRoundKey
      for (j = 0, k = i * 16; j < 16; ++j, ++k) {
        state[j] ^= key[k];
      }
      // InvMixColumns
      for (j = 0; j < 16; j += 4) {
        var s0 = mix[state[j]], s1 = mix[state[j + 1]],
            s2 = mix[state[j + 2]], s3 = mix[state[j + 3]];
        t = (s0 ^ (s1 >>> 8) ^ (s1 << 24) ^ (s2 >>> 16) ^ (s2 << 16) ^
            (s3 >>> 24) ^ (s3 << 8));
        state[j] = (t >>> 24) & 0xFF;
        state[j + 1] = (t >> 16) & 0xFF;
        state[j + 2] = (t >> 8) & 0xFF;
        state[j + 3] = t & 0xFF;
      }
    }
    // InvShiftRows
    t = state[13];
    state[13] = state[9];
    state[9] = state[5];
    state[5] = state[1];
    state[1] = t;
    t = state[14];
    u = state[10];
    state[14] = state[6];
    state[10] = state[2];
    state[6] = t;
    state[2] = u;
    t = state[15];
    u = state[11];
    v = state[7];
    state[15] = state[3];
    state[11] = t;
    state[7] = u;
    state[3] = v;
    for (j = 0; j < 16; ++j) {
      // InvSubBytes
      state[j] = inv_s[state[j]];
      // AddRoundKey
      state[j] ^= key[j];
    }
    return state;
  }

  function encrypt256(input, key) {
    var t, u, v, k;
    var state = new Uint8Array(16);
    state.set(input);
    for (j = 0; j < 16; ++j) {
      // AddRoundKey
      state[j] ^= key[j];
    }

    for (i = 1; i < 14; i++) {
      //SubBytes
      for (j = 0; j < 16; ++j) {
        state[j] = s[state[j]];
      }
      //ShiftRows
      v = state[1];
      state[1] = state[5];
      state[5] = state[9];
      state[9] = state[13];
      state[13] = v;
      v = state[2];
      u = state[6];
      state[2] = state[10];
      state[6] = state[14];
      state[10] = v;
      state[14] = u;
      v = state[3];
      u = state[7];
      t = state[11];
      state[3] = state[15];
      state[7] = v;
      state[11] = u;
      state[15] = t;
      //MixColumns
      for (var j = 0; j < 16; j += 4) {
        var s0 = state[j + 0], s1 = state[j + 1];
        var s2 = state[j + 2], s3 = state[j + 3];
        t = s0 ^ s1 ^ s2 ^ s3;
        state[j + 0] ^= t ^ mixCol[s0 ^ s1];
        state[j + 1] ^= t ^ mixCol[s1 ^ s2];
        state[j + 2] ^= t ^ mixCol[s2 ^ s3];
        state[j + 3] ^= t ^ mixCol[s3 ^ s0];
      }
      //AddRoundKey
      for (j = 0, k = i * 16; j < 16; ++j, ++k) {
        state[j] ^= key[k];
      }
    }

    //SubBytes
    for (j = 0; j < 16; ++j) {
      state[j] = s[state[j]];
    }
    //ShiftRows
    v = state[1];
    state[1] = state[5];
    state[5] = state[9];
    state[9] = state[13];
    state[13] = v;
    v = state[2];
    u = state[6];
    state[2] = state[10];
    state[6] = state[14];
    state[10] = v;
    state[14] = u;
    v = state[3];
    u = state[7];
    t = state[11];
    state[3] = state[15];
    state[7] = v;
    state[11] = u;
    state[15] = t;
    //AddRoundKey
    for (j = 0, k = 224; j < 16; ++j, ++k) {
      state[j] ^= key[k];
    }

    return state;

  }

  function AES256Cipher(key) {
    this.key = expandKey256(key);
    this.buffer = new Uint8Array(16);
    this.bufferPosition = 0;
  }

  function decryptBlock2(data, finalize) {
    var i, j, ii, sourceLength = data.length,
        buffer = this.buffer, bufferLength = this.bufferPosition,
        result = [], iv = this.iv;

    for (i = 0; i < sourceLength; ++i) {
      buffer[bufferLength] = data[i];
      ++bufferLength;
      if (bufferLength < 16) {
        continue;
      }
      // buffer is full, decrypting
      var plain = decrypt256(buffer, this.key);
      // xor-ing the IV vector to get plain text
      for (j = 0; j < 16; ++j) {
        plain[j] ^= iv[j];
      }
      iv = buffer;
      result.push(plain);
      buffer = new Uint8Array(16);
      bufferLength = 0;
    }
    // saving incomplete buffer
    this.buffer = buffer;
    this.bufferLength = bufferLength;
    this.iv = iv;
    if (result.length === 0) {
      return new Uint8Array([]);
    }
    // combining plain text blocks into one
    var outputLength = 16 * result.length;
    if (finalize) {
      // undo a padding that is described in RFC 2898
      var lastBlock = result[result.length - 1];
      var psLen = lastBlock[15];
      if (psLen <= 16) {
        for (i = 15, ii = 16 - psLen; i >= ii; --i) {
          if (lastBlock[i] !== psLen) {
            // Invalid padding, assume that the block has no padding.
            psLen = 0;
            break;
          }
        }
        outputLength -= psLen;
        result[result.length - 1] = lastBlock.subarray(0, 16 - psLen);
      }
    }
    var output = new Uint8Array(outputLength);
    for (i = 0, j = 0, ii = result.length; i < ii; ++i, j += 16) {
      output.set(result[i], j);
    }
    return output;

  }

  AES256Cipher.prototype = {
    decryptBlock: function AES256Cipher_decryptBlock(data, finalize, iv) {
      var i, sourceLength = data.length;
      var buffer = this.buffer, bufferLength = this.bufferPosition;
      // if not supplied an IV wait for IV values
      // they are at the start of the stream
      if (iv) {
        this.iv = iv;
      } else {
        for (i = 0; bufferLength < 16 &&
             i < sourceLength; ++i, ++bufferLength) {
          buffer[bufferLength] = data[i];
        }
        if (bufferLength < 16) {
          //need more data
          this.bufferLength = bufferLength;
          return new Uint8Array([]);
        }
        this.iv = buffer;
        data = data.subarray(16);
      }
      this.buffer = new Uint8Array(16);
      this.bufferLength = 0;
      // starting decryption
      this.decryptBlock = decryptBlock2;
      return this.decryptBlock(data, finalize);
    },
    encrypt: function AES256Cipher_encrypt(data, iv) {
      var i, j, ii, sourceLength = data.length,
          buffer = this.buffer, bufferLength = this.bufferPosition,
          result = [];
      if (!iv) {
        iv = new Uint8Array(16);
      }
      for (i = 0; i < sourceLength; ++i) {
        buffer[bufferLength] = data[i];
        ++bufferLength;
        if (bufferLength < 16) {
          continue;
        }
        for (j = 0; j < 16; ++j) {
          buffer[j] ^= iv[j];
        }

        // buffer is full, encrypting
        var cipher = encrypt256(buffer, this.key);
        this.iv = cipher;
        result.push(cipher);
        buffer = new Uint8Array(16);
        bufferLength = 0;
      }
      // saving incomplete buffer
      this.buffer = buffer;
      this.bufferLength = bufferLength;
      this.iv = iv;
      if (result.length === 0) {
        return new Uint8Array([]);
      }
      // combining plain text blocks into one
      var outputLength = 16 * result.length;
      var output = new Uint8Array(outputLength);
      for (i = 0, j = 0, ii = result.length; i < ii; ++i, j += 16) {
        output.set(result[i], j);
      }
      return output;
    }
  };

  return AES256Cipher;
})();

var PDF17 = (function PDF17Closure() {

  function compareByteArrays(array1, array2) {
    if (array1.length !== array2.length) {
      return false;
    }
    for (var i = 0; i < array1.length; i++) {
      if (array1[i] !== array2[i]) {
        return false;
      }
    }
    return true;
  }

  function PDF17() {
  }

  PDF17.prototype = {
    checkOwnerPassword: function PDF17_checkOwnerPassword(password,
                                                          ownerValidationSalt,
                                                          userBytes,
                                                          ownerPassword) {
      var hashData = new Uint8Array(password.length + 56);
      hashData.set(password, 0);
      hashData.set(ownerValidationSalt, password.length);
      hashData.set(userBytes, password.length + ownerValidationSalt.length);
      var result = calculateSHA256(hashData, 0, hashData.length);
      return compareByteArrays(result, ownerPassword);
    },
    checkUserPassword: function PDF17_checkUserPassword(password,
                                                        userValidationSalt,
                                                        userPassword) {
      var hashData = new Uint8Array(password.length + 8);
      hashData.set(password, 0);
      hashData.set(userValidationSalt, password.length);
      var result = calculateSHA256(hashData, 0, hashData.length);
      return compareByteArrays(result, userPassword);
    },
    getOwnerKey: function PDF17_getOwnerKey(password, ownerKeySalt, userBytes,
                                            ownerEncryption) {
      var hashData = new Uint8Array(password.length + 56);
      hashData.set(password, 0);
      hashData.set(ownerKeySalt, password.length);
      hashData.set(userBytes, password.length + ownerKeySalt.length);
      var key = calculateSHA256(hashData, 0, hashData.length);
      var cipher = new AES256Cipher(key);
      return cipher.decryptBlock(ownerEncryption,
                                 false,
                                 new Uint8Array(16));

    },
    getUserKey: function PDF17_getUserKey(password, userKeySalt,
                                          userEncryption) {
      var hashData = new Uint8Array(password.length + 8);
      hashData.set(password, 0);
      hashData.set(userKeySalt, password.length);
      //key is the decryption key for the UE string
      var key = calculateSHA256(hashData, 0, hashData.length);
      var cipher = new AES256Cipher(key);
      return cipher.decryptBlock(userEncryption,
                                 false,
                                 new Uint8Array(16));
    }
  };
  return PDF17;
})();

var PDF20 = (function PDF20Closure() {

  function concatArrays(array1, array2) {
    var t = new Uint8Array(array1.length + array2.length);
    t.set(array1, 0);
    t.set(array2, array1.length);
    return t;
  }

  function calculatePDF20Hash(password, input, userBytes) {
    //This refers to Algorithm 2.B as defined in ISO 32000-2
    var k = calculateSHA256(input, 0, input.length).subarray(0, 32);
    var e = [0];
    var i = 0;
    while (i < 64 || e[e.length - 1] > i - 32) {
      var arrayLength = password.length + k.length + userBytes.length;

      var k1 = new Uint8Array(arrayLength * 64);
      var array = concatArrays(password, k);
      array = concatArrays(array, userBytes);
      for (var j = 0, pos = 0; j < 64; j++, pos += arrayLength) {
        k1.set(array, pos);
      }
      //AES128 CBC NO PADDING with
      //first 16 bytes of k as the key and the second 16 as the iv.
      var cipher = new AES128Cipher(k.subarray(0, 16));
      e = cipher.encrypt(k1, k.subarray(16, 32));
      //Now we have to take the first 16 bytes of an unsigned
      //big endian integer... and compute the remainder
      //modulo 3.... That is a fairly large number and
      //JavaScript isn't going to handle that well...
      //So we're using a trick that allows us to perform
      //modulo math byte by byte
      var remainder = 0;
      for (var z = 0; z < 16; z++) {
        remainder *= (256 % 3);
        remainder %= 3;
        remainder += ((e[z] >>> 0) % 3);
        remainder %= 3;
      }
      if (remainder === 0) {
        k = calculateSHA256(e, 0, e.length);
      }
      else if (remainder === 1) {
        k = calculateSHA384(e, 0, e.length);
      }
      else if (remainder === 2) {
        k = calculateSHA512(e, 0, e.length);
      }
      i++;
    }
    return k.subarray(0, 32);
  }

  function PDF20() {
  }

  function compareByteArrays(array1, array2) {
    if (array1.length !== array2.length) {
      return false;
    }
    for (var i = 0; i < array1.length; i++) {
      if (array1[i] !== array2[i]) {
        return false;
      }
    }
    return true;
  }

  PDF20.prototype = {
    hash: function PDF20_hash(password, concatBytes, userBytes) {
      return calculatePDF20Hash(password, concatBytes, userBytes);
    },
    checkOwnerPassword: function PDF20_checkOwnerPassword(password,
                                                          ownerValidationSalt,
                                                          userBytes,
                                                          ownerPassword) {
      var hashData = new Uint8Array(password.length + 56);
      hashData.set(password, 0);
      hashData.set(ownerValidationSalt, password.length);
      hashData.set(userBytes, password.length + ownerValidationSalt.length);
      var result = calculatePDF20Hash(password, hashData, userBytes);
      return compareByteArrays(result, ownerPassword);
    },
    checkUserPassword: function PDF20_checkUserPassword(password,
                                                        userValidationSalt,
                                                        userPassword) {
      var hashData = new Uint8Array(password.length + 8);
      hashData.set(password, 0);
      hashData.set(userValidationSalt, password.length);
      var result = calculatePDF20Hash(password, hashData, []);
      return compareByteArrays(result, userPassword);
    },
    getOwnerKey: function PDF20_getOwnerKey(password, ownerKeySalt, userBytes,
                                            ownerEncryption) {
      var hashData = new Uint8Array(password.length + 56);
      hashData.set(password, 0);
      hashData.set(ownerKeySalt, password.length);
      hashData.set(userBytes, password.length + ownerKeySalt.length);
      var key = calculatePDF20Hash(password, hashData, userBytes);
      var cipher = new AES256Cipher(key);
      return cipher.decryptBlock(ownerEncryption,
                                 false,
                                 new Uint8Array(16));

    },
    getUserKey: function PDF20_getUserKey(password, userKeySalt,
                                          userEncryption) {
      var hashData = new Uint8Array(password.length + 8);
      hashData.set(password, 0);
      hashData.set(userKeySalt, password.length);
      //key is the decryption key for the UE string
      var key = calculatePDF20Hash(password, hashData, []);
      var cipher = new AES256Cipher(key);
      return cipher.decryptBlock(userEncryption,
                                 false,
                                 new Uint8Array(16));
    }
  };
  return PDF20;
})();

var CipherTransform = (function CipherTransformClosure() {
  function CipherTransform(stringCipherConstructor, streamCipherConstructor) {
    this.stringCipherConstructor = stringCipherConstructor;
    this.streamCipherConstructor = streamCipherConstructor;
  }

  CipherTransform.prototype = {
    createStream: function CipherTransform_createStream(stream, length) {
      var cipher = new this.streamCipherConstructor();
      return new DecryptStream(stream, length,
        function cipherTransformDecryptStream(data, finalize) {
          return cipher.decryptBlock(data, finalize);
        }
      );
    },
    decryptString: function CipherTransform_decryptString(s) {
      var cipher = new this.stringCipherConstructor();
      var data = stringToBytes(s);
      data = cipher.decryptBlock(data, true);
      return bytesToString(data);
    }
  };
  return CipherTransform;
})();

var CipherTransformFactory = (function CipherTransformFactoryClosure() {
  var defaultPasswordBytes = new Uint8Array([
    0x28, 0xBF, 0x4E, 0x5E, 0x4E, 0x75, 0x8A, 0x41,
    0x64, 0x00, 0x4E, 0x56, 0xFF, 0xFA, 0x01, 0x08,
    0x2E, 0x2E, 0x00, 0xB6, 0xD0, 0x68, 0x3E, 0x80,
    0x2F, 0x0C, 0xA9, 0xFE, 0x64, 0x53, 0x69, 0x7A]);

  function createEncryptionKey20(revision, password, ownerPassword,
                                 ownerValidationSalt, ownerKeySalt, uBytes,
                                 userPassword, userValidationSalt, userKeySalt,
                                 ownerEncryption, userEncryption, perms) {
    if (password) {
      var passwordLength = Math.min(127, password.length);
      password = password.subarray(0, passwordLength);
    } else {
      password = [];
    }
    var pdfAlgorithm;
    if (revision === 6) {
      pdfAlgorithm = new PDF20();
    } else {
      pdfAlgorithm = new PDF17();
    }

    if (pdfAlgorithm.checkUserPassword(password, userValidationSalt,
                                        userPassword)) {
      return pdfAlgorithm.getUserKey(password, userKeySalt, userEncryption);
    } else if (password.length && pdfAlgorithm.checkOwnerPassword(password,
                                                  ownerValidationSalt,
                                                  uBytes,
                                                  ownerPassword)) {
      return pdfAlgorithm.getOwnerKey(password, ownerKeySalt, uBytes,
                                      ownerEncryption);
    }

    return null;
  }

  function prepareKeyData(fileId, password, ownerPassword, userPassword,
                          flags, revision, keyLength, encryptMetadata) {
    var hashDataSize = 40 + ownerPassword.length + fileId.length;
    var hashData = new Uint8Array(hashDataSize), i = 0, j, n;
    if (password) {
      n = Math.min(32, password.length);
      for (; i < n; ++i) {
        hashData[i] = password[i];
      }
    }
    j = 0;
    while (i < 32) {
      hashData[i++] = defaultPasswordBytes[j++];
    }
    // as now the padded password in the hashData[0..i]
    for (j = 0, n = ownerPassword.length; j < n; ++j) {
      hashData[i++] = ownerPassword[j];
    }
    hashData[i++] = flags & 0xFF;
    hashData[i++] = (flags >> 8) & 0xFF;
    hashData[i++] = (flags >> 16) & 0xFF;
    hashData[i++] = (flags >>> 24) & 0xFF;
    for (j = 0, n = fileId.length; j < n; ++j) {
      hashData[i++] = fileId[j];
    }
    if (revision >= 4 && !encryptMetadata) {
      hashData[i++] = 0xFF;
      hashData[i++] = 0xFF;
      hashData[i++] = 0xFF;
      hashData[i++] = 0xFF;
    }
    var hash = calculateMD5(hashData, 0, i);
    var keyLengthInBytes = keyLength >> 3;
    if (revision >= 3) {
      for (j = 0; j < 50; ++j) {
        hash = calculateMD5(hash, 0, keyLengthInBytes);
      }
    }
    var encryptionKey = hash.subarray(0, keyLengthInBytes);
    var cipher, checkData;

    if (revision >= 3) {
      for (i = 0; i < 32; ++i) {
        hashData[i] = defaultPasswordBytes[i];
      }
      for (j = 0, n = fileId.length; j < n; ++j) {
        hashData[i++] = fileId[j];
      }
      cipher = new ARCFourCipher(encryptionKey);
      checkData = cipher.encryptBlock(calculateMD5(hashData, 0, i));
      n = encryptionKey.length;
      var derivedKey = new Uint8Array(n), k;
      for (j = 1; j <= 19; ++j) {
        for (k = 0; k < n; ++k) {
          derivedKey[k] = encryptionKey[k] ^ j;
        }
        cipher = new ARCFourCipher(derivedKey);
        checkData = cipher.encryptBlock(checkData);
      }
      for (j = 0, n = checkData.length; j < n; ++j) {
        if (userPassword[j] !== checkData[j]) {
          return null;
        }
      }
    } else {
      cipher = new ARCFourCipher(encryptionKey);
      checkData = cipher.encryptBlock(defaultPasswordBytes);
      for (j = 0, n = checkData.length; j < n; ++j) {
        if (userPassword[j] !== checkData[j]) {
          return null;
        }
      }
    }
    return encryptionKey;
  }

  function decodeUserPassword(password, ownerPassword, revision, keyLength) {
    var hashData = new Uint8Array(32), i = 0, j, n;
    n = Math.min(32, password.length);
    for (; i < n; ++i) {
      hashData[i] = password[i];
    }
    j = 0;
    while (i < 32) {
      hashData[i++] = defaultPasswordBytes[j++];
    }
    var hash = calculateMD5(hashData, 0, i);
    var keyLengthInBytes = keyLength >> 3;
    if (revision >= 3) {
      for (j = 0; j < 50; ++j) {
        hash = calculateMD5(hash, 0, hash.length);
      }
    }

    var cipher, userPassword;
    if (revision >= 3) {
      userPassword = ownerPassword;
      var derivedKey = new Uint8Array(keyLengthInBytes), k;
      for (j = 19; j >= 0; j--) {
        for (k = 0; k < keyLengthInBytes; ++k) {
          derivedKey[k] = hash[k] ^ j;
        }
        cipher = new ARCFourCipher(derivedKey);
        userPassword = cipher.encryptBlock(userPassword);
      }
    } else {
      cipher = new ARCFourCipher(hash.subarray(0, keyLengthInBytes));
      userPassword = cipher.encryptBlock(ownerPassword);
    }
    return userPassword;
  }

  var identityName = Name.get('Identity');

  function CipherTransformFactory(dict, fileId, password) {
    var filter = dict.get('Filter');
    if (!isName(filter, 'Standard')) {
      error('unknown encryption method');
    }
    this.dict = dict;
    var algorithm = dict.get('V');
    if (!isInt(algorithm) ||
        (algorithm !== 1 && algorithm !== 2 && algorithm !== 4 &&
        algorithm !== 5)) {
      error('unsupported encryption algorithm');
    }
    this.algorithm = algorithm;
    var keyLength = dict.get('Length');
    if (!keyLength) {
      // Spec asks to rely on encryption dictionary's Length entry, however
      // some PDFs don't have it. Trying to recover.
      if (algorithm <= 3) {
        // For 1 and 2 it's fixed to 40-bit, for 3 40-bit is a minimal value.
        keyLength = 40;
      } else {
        // Trying to find default handler -- it usually has Length.
        var cfDict = dict.get('CF');
        var streamCryptoName = dict.get('StmF');
        if (isDict(cfDict) && isName(streamCryptoName)) {
          var handlerDict = cfDict.get(streamCryptoName.name);
          keyLength = (handlerDict && handlerDict.get('Length')) || 128;
          if (keyLength < 40) {
            // Sometimes it's incorrect value of bits, generators specify bytes.
            keyLength <<= 3;
          }
        }
      }
    }
    if (!isInt(keyLength) ||
        keyLength < 40 || (keyLength % 8) !== 0) {
      error('invalid key length');
    }

    // prepare keys
    var ownerPassword = stringToBytes(dict.get('O')).subarray(0, 32);
    var userPassword = stringToBytes(dict.get('U')).subarray(0, 32);
    var flags = dict.get('P');
    var revision = dict.get('R');
    // meaningful when V is 4 or 5
    var encryptMetadata = ((algorithm === 4 || algorithm === 5) &&
                           dict.get('EncryptMetadata') !== false);
    this.encryptMetadata = encryptMetadata;

    var fileIdBytes = stringToBytes(fileId);
    var passwordBytes;
    if (password) {
      if (revision === 6) {
        try {
          password = utf8StringToString(password);
        } catch (ex) {
          warn('CipherTransformFactory: ' +
               'Unable to convert UTF8 encoded password.');
        }
      }
      passwordBytes = stringToBytes(password);
    }

    var encryptionKey;
    if (algorithm !== 5) {
      encryptionKey = prepareKeyData(fileIdBytes, passwordBytes,
                                     ownerPassword, userPassword, flags,
                                     revision, keyLength, encryptMetadata);
    }
    else {
      var ownerValidationSalt = stringToBytes(dict.get('O')).subarray(32, 40);
      var ownerKeySalt = stringToBytes(dict.get('O')).subarray(40, 48);
      var uBytes = stringToBytes(dict.get('U')).subarray(0, 48);
      var userValidationSalt = stringToBytes(dict.get('U')).subarray(32, 40);
      var userKeySalt = stringToBytes(dict.get('U')).subarray(40, 48);
      var ownerEncryption = stringToBytes(dict.get('OE'));
      var userEncryption = stringToBytes(dict.get('UE'));
      var perms = stringToBytes(dict.get('Perms'));
      encryptionKey =
        createEncryptionKey20(revision, passwordBytes,
          ownerPassword, ownerValidationSalt,
          ownerKeySalt, uBytes,
          userPassword, userValidationSalt,
          userKeySalt, ownerEncryption,
          userEncryption, perms);
    }
    if (!encryptionKey && !password) {
      throw new PasswordException('No password given',
                                  PasswordResponses.NEED_PASSWORD);
    } else if (!encryptionKey && password) {
      // Attempting use the password as an owner password
      var decodedPassword = decodeUserPassword(passwordBytes, ownerPassword,
                                               revision, keyLength);
      encryptionKey = prepareKeyData(fileIdBytes, decodedPassword,
                                     ownerPassword, userPassword, flags,
                                     revision, keyLength, encryptMetadata);
    }

    if (!encryptionKey) {
      throw new PasswordException('Incorrect Password',
                                  PasswordResponses.INCORRECT_PASSWORD);
    }

    this.encryptionKey = encryptionKey;

    if (algorithm >= 4) {
      this.cf = dict.get('CF');
      this.stmf = dict.get('StmF') || identityName;
      this.strf = dict.get('StrF') || identityName;
      this.eff = dict.get('EFF') || this.stmf;
    }
  }

  function buildObjectKey(num, gen, encryptionKey, isAes) {
    var key = new Uint8Array(encryptionKey.length + 9), i, n;
    for (i = 0, n = encryptionKey.length; i < n; ++i) {
      key[i] = encryptionKey[i];
    }
    key[i++] = num & 0xFF;
    key[i++] = (num >> 8) & 0xFF;
    key[i++] = (num >> 16) & 0xFF;
    key[i++] = gen & 0xFF;
    key[i++] = (gen >> 8) & 0xFF;
    if (isAes) {
      key[i++] = 0x73;
      key[i++] = 0x41;
      key[i++] = 0x6C;
      key[i++] = 0x54;
    }
    var hash = calculateMD5(key, 0, i);
    return hash.subarray(0, Math.min(encryptionKey.length + 5, 16));
  }

  function buildCipherConstructor(cf, name, num, gen, key) {
    var cryptFilter = cf.get(name.name);
    var cfm;
    if (cryptFilter !== null && cryptFilter !== undefined) {
      cfm = cryptFilter.get('CFM');
    }
    if (!cfm || cfm.name === 'None') {
      return function cipherTransformFactoryBuildCipherConstructorNone() {
        return new NullCipher();
      };
    }
    if ('V2' === cfm.name) {
      return function cipherTransformFactoryBuildCipherConstructorV2() {
        return new ARCFourCipher(buildObjectKey(num, gen, key, false));
      };
    }
    if ('AESV2' === cfm.name) {
      return function cipherTransformFactoryBuildCipherConstructorAESV2() {
        return new AES128Cipher(buildObjectKey(num, gen, key, true));
      };
    }
    if ('AESV3' === cfm.name) {
      return function cipherTransformFactoryBuildCipherConstructorAESV3() {
        return new AES256Cipher(key);
      };
    }
    error('Unknown crypto method');
  }

  CipherTransformFactory.prototype = {
    createCipherTransform:
        function CipherTransformFactory_createCipherTransform(num, gen) {
      if (this.algorithm === 4 || this.algorithm === 5) {
        return new CipherTransform(
          buildCipherConstructor(this.cf, this.stmf,
                                 num, gen, this.encryptionKey),
          buildCipherConstructor(this.cf, this.strf,
                                 num, gen, this.encryptionKey));
      }
      // algorithms 1 and 2
      var key = buildObjectKey(num, gen, this.encryptionKey, false);
      var cipherConstructor = function buildCipherCipherConstructor() {
        return new ARCFourCipher(key);
      };
      return new CipherTransform(cipherConstructor, cipherConstructor);
    }
  };

  return CipherTransformFactory;
})();

exports.AES128Cipher = AES128Cipher;
exports.AES256Cipher = AES256Cipher;
exports.ARCFourCipher = ARCFourCipher;
exports.CipherTransformFactory = CipherTransformFactory;
exports.PDF17 = PDF17;
exports.PDF20 = PDF20;
exports.calculateMD5 = calculateMD5;
exports.calculateSHA256 = calculateSHA256;
exports.calculateSHA384 = calculateSHA384;
exports.calculateSHA512 = calculateSHA512;
}));

(function (root, factory) {
  {
    factory((root.pdfjsCoreFontRenderer = {}), root.pdfjsSharedUtil,
      root.pdfjsCoreStream, root.pdfjsCoreGlyphList, root.pdfjsCoreEncodings,
      root.pdfjsCoreCFFParser);
  }
}(this, function (exports, sharedUtil, coreStream, coreGlyphList,
                  coreEncodings, coreCFFParser) {

var Util = sharedUtil.Util;
var bytesToString = sharedUtil.bytesToString;
var error = sharedUtil.error;
var Stream = coreStream.Stream;
var getGlyphsUnicode = coreGlyphList.getGlyphsUnicode;
var StandardEncoding = coreEncodings.StandardEncoding;
var CFFParser = coreCFFParser.CFFParser;

var FontRendererFactory = (function FontRendererFactoryClosure() {
  function getLong(data, offset) {
    return (data[offset] << 24) | (data[offset + 1] << 16) |
           (data[offset + 2] << 8) | data[offset + 3];
  }

  function getUshort(data, offset) {
    return (data[offset] << 8) | data[offset + 1];
  }

  function parseCmap(data, start, end) {
    var offset = (getUshort(data, start + 2) === 1 ?
                  getLong(data, start + 8) : getLong(data, start + 16));
    var format = getUshort(data, start + offset);
    var length, ranges, p, i;
    if (format === 4) {
      length = getUshort(data, start + offset + 2);
      var segCount = getUshort(data, start + offset + 6) >> 1;
      p = start + offset + 14;
      ranges = [];
      for (i = 0; i < segCount; i++, p += 2) {
        ranges[i] = {end: getUshort(data, p)};
      }
      p += 2;
      for (i = 0; i < segCount; i++, p += 2) {
        ranges[i].start = getUshort(data, p);
      }
      for (i = 0; i < segCount; i++, p += 2) {
        ranges[i].idDelta = getUshort(data, p);
      }
      for (i = 0; i < segCount; i++, p += 2) {
        var idOffset = getUshort(data, p);
        if (idOffset === 0) {
          continue;
        }
        ranges[i].ids = [];
        for (var j = 0, jj = ranges[i].end - ranges[i].start + 1; j < jj; j++) {
          ranges[i].ids[j] = getUshort(data, p + idOffset);
          idOffset += 2;
        }
      }
      return ranges;
    } else if (format === 12) {
      length = getLong(data, start + offset + 4);
      var groups = getLong(data, start + offset + 12);
      p = start + offset + 16;
      ranges = [];
      for (i = 0; i < groups; i++) {
        ranges.push({
          start: getLong(data, p),
          end: getLong(data, p + 4),
          idDelta: getLong(data, p + 8) - getLong(data, p)
        });
        p += 12;
      }
      return ranges;
    }
    error('not supported cmap: ' + format);
  }

  function parseCff(data, start, end, seacAnalysisEnabled) {
    var properties = {};
    var parser = new CFFParser(new Stream(data, start, end - start),
                               properties, seacAnalysisEnabled);
    var cff = parser.parse();
    return {
      glyphs: cff.charStrings.objects,
      subrs: (cff.topDict.privateDict && cff.topDict.privateDict.subrsIndex &&
              cff.topDict.privateDict.subrsIndex.objects),
      gsubrs: cff.globalSubrIndex && cff.globalSubrIndex.objects
    };
  }

  function parseGlyfTable(glyf, loca, isGlyphLocationsLong) {
    var itemSize, itemDecode;
    if (isGlyphLocationsLong) {
      itemSize = 4;
      itemDecode = function fontItemDecodeLong(data, offset) {
        return (data[offset] << 24) | (data[offset + 1] << 16) |
               (data[offset + 2] << 8) | data[offset + 3];
      };
    } else {
      itemSize = 2;
      itemDecode = function fontItemDecode(data, offset) {
        return (data[offset] << 9) | (data[offset + 1] << 1);
      };
    }
    var glyphs = [];
    var startOffset = itemDecode(loca, 0);
    for (var j = itemSize; j < loca.length; j += itemSize) {
      var endOffset = itemDecode(loca, j);
      glyphs.push(glyf.subarray(startOffset, endOffset));
      startOffset = endOffset;
    }
    return glyphs;
  }

  function lookupCmap(ranges, unicode) {
    var code = unicode.charCodeAt(0), gid = 0;
    var l = 0, r = ranges.length - 1;
    while (l < r) {
      var c = (l + r + 1) >> 1;
      if (code < ranges[c].start) {
        r = c - 1;
      } else {
        l = c;
      }
    }
    if (ranges[l].start <= code && code <= ranges[l].end) {
      gid = (ranges[l].idDelta + (ranges[l].ids ?
             ranges[l].ids[code - ranges[l].start] : code)) & 0xFFFF;
    }
    return {
      charCode: code,
      glyphId: gid,
    };
  }

  function compileGlyf(code, cmds, font) {
    function moveTo(x, y) {
      cmds.push({cmd: 'moveTo', args: [x, y]});
    }
    function lineTo(x, y) {
      cmds.push({cmd: 'lineTo', args: [x, y]});
    }
    function quadraticCurveTo(xa, ya, x, y) {
      cmds.push({cmd: 'quadraticCurveTo', args: [xa, ya, x, y]});
    }

    var i = 0;
    var numberOfContours = ((code[i] << 24) | (code[i + 1] << 16)) >> 16;
    var flags;
    var x = 0, y = 0;
    i += 10;
    if (numberOfContours < 0) {
      // composite glyph
      do {
        flags = (code[i] << 8) | code[i + 1];
        var glyphIndex = (code[i + 2] << 8) | code[i + 3];
        i += 4;
        var arg1, arg2;
        if ((flags & 0x01)) {
          arg1 = ((code[i] << 24) | (code[i + 1] << 16)) >> 16;
          arg2 = ((code[i + 2] << 24) | (code[i + 3] << 16)) >> 16;
          i += 4;
        } else {
          arg1 = code[i++]; arg2 = code[i++];
        }
        if ((flags & 0x02)) {
           x = arg1;
           y = arg2;
        } else {
           x = 0; y = 0; // TODO "they are points" ?
        }
        var scaleX = 1, scaleY = 1, scale01 = 0, scale10 = 0;
        if ((flags & 0x08)) {
          scaleX =
          scaleY = ((code[i] << 24) | (code[i + 1] << 16)) / 1073741824;
          i += 2;
        } else if ((flags & 0x40)) {
          scaleX = ((code[i] << 24) | (code[i + 1] << 16)) / 1073741824;
          scaleY = ((code[i + 2] << 24) | (code[i + 3] << 16)) / 1073741824;
          i += 4;
        } else if ((flags & 0x80)) {
          scaleX = ((code[i] << 24) | (code[i + 1] << 16)) / 1073741824;
          scale01 = ((code[i + 2] << 24) | (code[i + 3] << 16)) / 1073741824;
          scale10 = ((code[i + 4] << 24) | (code[i + 5] << 16)) / 1073741824;
          scaleY = ((code[i + 6] << 24) | (code[i + 7] << 16)) / 1073741824;
          i += 8;
        }
        var subglyph = font.glyphs[glyphIndex];
        if (subglyph) {
          cmds.push({cmd: 'save'});
          cmds.push({cmd: 'transform',
                     args: [scaleX, scale01, scale10, scaleY, x, y]});
          compileGlyf(subglyph, cmds, font);
          cmds.push({cmd: 'restore'});
        }
      } while ((flags & 0x20));
    } else {
      // simple glyph
      var endPtsOfContours = [];
      var j, jj;
      for (j = 0; j < numberOfContours; j++) {
        endPtsOfContours.push((code[i] << 8) | code[i + 1]);
        i += 2;
      }
      var instructionLength = (code[i] << 8) | code[i + 1];
      i += 2 + instructionLength; // skipping the instructions
      var numberOfPoints = endPtsOfContours[endPtsOfContours.length - 1] + 1;
      var points = [];
      while (points.length < numberOfPoints) {
        flags = code[i++];
        var repeat = 1;
        if ((flags & 0x08)) {
          repeat += code[i++];
        }
        while (repeat-- > 0) {
          points.push({flags: flags});
        }
      }
      for (j = 0; j < numberOfPoints; j++) {
        switch (points[j].flags & 0x12) {
          case 0x00:
            x += ((code[i] << 24) | (code[i + 1] << 16)) >> 16;
            i += 2;
            break;
          case 0x02:
            x -= code[i++];
            break;
          case 0x12:
            x += code[i++];
            break;
        }
        points[j].x = x;
      }
      for (j = 0; j < numberOfPoints; j++) {
        switch (points[j].flags & 0x24) {
          case 0x00:
            y += ((code[i] << 24) | (code[i + 1] << 16)) >> 16;
            i += 2;
            break;
          case 0x04:
            y -= code[i++];
            break;
          case 0x24:
            y += code[i++];
            break;
        }
        points[j].y = y;
      }

      var startPoint = 0;
      for (i = 0; i < numberOfContours; i++) {
        var endPoint = endPtsOfContours[i];
        // contours might have implicit points, which is located in the middle
        // between two neighboring off-curve points
        var contour = points.slice(startPoint, endPoint + 1);
        if ((contour[0].flags & 1)) {
          contour.push(contour[0]); // using start point at the contour end
        } else if ((contour[contour.length - 1].flags & 1)) {
          // first is off-curve point, trying to use one from the end
          contour.unshift(contour[contour.length - 1]);
        } else {
          // start and end are off-curve points, creating implicit one
          var p = {
            flags: 1,
            x: (contour[0].x + contour[contour.length - 1].x) / 2,
            y: (contour[0].y + contour[contour.length - 1].y) / 2
          };
          contour.unshift(p);
          contour.push(p);
        }
        moveTo(contour[0].x, contour[0].y);
        for (j = 1, jj = contour.length; j < jj; j++) {
          if ((contour[j].flags & 1)) {
            lineTo(contour[j].x, contour[j].y);
          } else if ((contour[j + 1].flags & 1)){
            quadraticCurveTo(contour[j].x, contour[j].y,
                             contour[j + 1].x, contour[j + 1].y);
            j++;
          } else {
            quadraticCurveTo(contour[j].x, contour[j].y,
              (contour[j].x + contour[j + 1].x) / 2,
              (contour[j].y + contour[j + 1].y) / 2);
          }
        }
        startPoint = endPoint + 1;
      }
    }
  }

  function compileCharString(code, cmds, font) {
    var stack = [];
    var x = 0, y = 0;
    var stems = 0;

    function moveTo(x, y) {
      cmds.push({cmd: 'moveTo', args: [x, y]});
    }
    function lineTo(x, y) {
      cmds.push({cmd: 'lineTo', args: [x, y]});
    }
    function bezierCurveTo(x1, y1, x2, y2, x, y) {
      cmds.push({cmd: 'bezierCurveTo', args: [x1, y1, x2, y2, x, y]});
    }

    function parse(code) {
      var i = 0;
      while (i < code.length) {
        var stackClean = false;
        var v = code[i++];
        var xa, xb, ya, yb, y1, y2, y3, n, subrCode;
        switch (v) {
          case 1: // hstem
            stems += stack.length >> 1;
            stackClean = true;
            break;
          case 3: // vstem
            stems += stack.length >> 1;
            stackClean = true;
            break;
          case 4: // vmoveto
            y += stack.pop();
            moveTo(x, y);
            stackClean = true;
            break;
          case 5: // rlineto
            while (stack.length > 0) {
              x += stack.shift();
              y += stack.shift();
              lineTo(x, y);
            }
            break;
          case 6: // hlineto
            while (stack.length > 0) {
              x += stack.shift();
              lineTo(x, y);
              if (stack.length === 0) {
                break;
              }
              y += stack.shift();
              lineTo(x, y);
            }
            break;
          case 7: // vlineto
            while (stack.length > 0) {
              y += stack.shift();
              lineTo(x, y);
              if (stack.length === 0) {
                break;
              }
              x += stack.shift();
              lineTo(x, y);
            }
            break;
          case 8: // rrcurveto
            while (stack.length > 0) {
              xa = x + stack.shift(); ya = y + stack.shift();
              xb = xa + stack.shift(); yb = ya + stack.shift();
              x = xb + stack.shift(); y = yb + stack.shift();
              bezierCurveTo(xa, ya, xb, yb, x, y);
            }
            break;
          case 10: // callsubr
            n = stack.pop() + font.subrsBias;
            subrCode = font.subrs[n];
            if (subrCode) {
              parse(subrCode);
            }
            break;
          case 11: // return
            return;
          case 12:
            v = code[i++];
            switch (v) {
              case 34: // flex
                xa = x + stack.shift();
                xb = xa + stack.shift(); y1 = y + stack.shift();
                x = xb + stack.shift();
                bezierCurveTo(xa, y, xb, y1, x, y1);
                xa = x + stack.shift();
                xb = xa + stack.shift();
                x = xb + stack.shift();
                bezierCurveTo(xa, y1, xb, y, x, y);
                break;
              case 35: // flex
                xa = x + stack.shift(); ya = y + stack.shift();
                xb = xa + stack.shift(); yb = ya + stack.shift();
                x = xb + stack.shift(); y = yb + stack.shift();
                bezierCurveTo(xa, ya, xb, yb, x, y);
                xa = x + stack.shift(); ya = y + stack.shift();
                xb = xa + stack.shift(); yb = ya + stack.shift();
                x = xb + stack.shift(); y = yb + stack.shift();
                bezierCurveTo(xa, ya, xb, yb, x, y);
                stack.pop(); // fd
                break;
              case 36: // hflex1
                xa = x + stack.shift(); y1 = y + stack.shift();
                xb = xa + stack.shift(); y2 = y1 + stack.shift();
                x = xb + stack.shift();
                bezierCurveTo(xa, y1, xb, y2, x, y2);
                xa = x + stack.shift();
                xb = xa + stack.shift(); y3 = y2 + stack.shift();
                x = xb + stack.shift();
                bezierCurveTo(xa, y2, xb, y3, x, y);
                break;
              case 37: // flex1
                var x0 = x, y0 = y;
                xa = x + stack.shift(); ya = y + stack.shift();
                xb = xa + stack.shift(); yb = ya + stack.shift();
                x = xb + stack.shift(); y = yb + stack.shift();
                bezierCurveTo(xa, ya, xb, yb, x, y);
                xa = x + stack.shift(); ya = y + stack.shift();
                xb = xa + stack.shift(); yb = ya + stack.shift();
                x = xb; y = yb;
                if (Math.abs(x - x0) > Math.abs(y - y0)) {
                  x += stack.shift();
                } else  {
                  y += stack.shift();
                }
                bezierCurveTo(xa, ya, xb, yb, x, y);
                break;
              default:
                error('unknown operator: 12 ' + v);
            }
            break;
          case 14: // endchar
            if (stack.length >= 4) {
              var achar = stack.pop();
              var bchar = stack.pop();
              y = stack.pop();
              x = stack.pop();
              cmds.push({cmd: 'save'});
              cmds.push({cmd: 'translate', args: [x, y]});
              var cmap = lookupCmap(font.cmap, String.fromCharCode(
                font.glyphNameMap[StandardEncoding[achar]]));
              compileCharString(font.glyphs[cmap.glyphId], cmds, font);
              cmds.push({cmd: 'restore'});

              cmap = lookupCmap(font.cmap, String.fromCharCode(
                font.glyphNameMap[StandardEncoding[bchar]]));
              compileCharString(font.glyphs[cmap.glyphId], cmds, font);
            }
            return;
          case 18: // hstemhm
            stems += stack.length >> 1;
            stackClean = true;
            break;
          case 19: // hintmask
            stems += stack.length >> 1;
            i += (stems + 7) >> 3;
            stackClean = true;
            break;
          case 20: // cntrmask
            stems += stack.length >> 1;
            i += (stems + 7) >> 3;
            stackClean = true;
            break;
          case 21: // rmoveto
            y += stack.pop();
            x += stack.pop();
            moveTo(x, y);
            stackClean = true;
            break;
          case 22: // hmoveto
            x += stack.pop();
            moveTo(x, y);
            stackClean = true;
            break;
          case 23: // vstemhm
            stems += stack.length >> 1;
            stackClean = true;
            break;
          case 24: // rcurveline
            while (stack.length > 2) {
              xa = x + stack.shift(); ya = y + stack.shift();
              xb = xa + stack.shift(); yb = ya + stack.shift();
              x = xb + stack.shift(); y = yb + stack.shift();
              bezierCurveTo(xa, ya, xb, yb, x, y);
            }
            x += stack.shift();
            y += stack.shift();
            lineTo(x, y);
            break;
          case 25: // rlinecurve
            while (stack.length > 6) {
              x += stack.shift();
              y += stack.shift();
              lineTo(x, y);
            }
            xa = x + stack.shift(); ya = y + stack.shift();
            xb = xa + stack.shift(); yb = ya + stack.shift();
            x = xb + stack.shift(); y = yb + stack.shift();
            bezierCurveTo(xa, ya, xb, yb, x, y);
            break;
          case 26: // vvcurveto
            if (stack.length % 2) {
              x += stack.shift();
            }
            while (stack.length > 0) {
              xa = x; ya = y + stack.shift();
              xb = xa + stack.shift(); yb = ya + stack.shift();
              x = xb; y = yb + stack.shift();
              bezierCurveTo(xa, ya, xb, yb, x, y);
            }
            break;
          case 27: // hhcurveto
            if (stack.length % 2) {
              y += stack.shift();
            }
            while (stack.length > 0) {
              xa = x + stack.shift(); ya = y;
              xb = xa + stack.shift(); yb = ya + stack.shift();
              x = xb + stack.shift(); y = yb;
              bezierCurveTo(xa, ya, xb, yb, x, y);
            }
            break;
          case 28:
            stack.push(((code[i] << 24) | (code[i + 1] << 16)) >> 16);
            i += 2;
            break;
          case 29: // callgsubr
            n = stack.pop() + font.gsubrsBias;
            subrCode = font.gsubrs[n];
            if (subrCode) {
              parse(subrCode);
            }
            break;
          case 30: // vhcurveto
            while (stack.length > 0) {
              xa = x; ya = y + stack.shift();
              xb = xa + stack.shift(); yb = ya + stack.shift();
              x = xb + stack.shift();
              y = yb + (stack.length === 1 ? stack.shift() : 0);
              bezierCurveTo(xa, ya, xb, yb, x, y);
              if (stack.length === 0) {
                break;
              }

              xa = x + stack.shift(); ya = y;
              xb = xa + stack.shift(); yb = ya + stack.shift();
              y = yb + stack.shift();
              x = xb + (stack.length === 1 ? stack.shift() : 0);
              bezierCurveTo(xa, ya, xb, yb, x, y);
            }
            break;
          case 31: // hvcurveto
            while (stack.length > 0) {
              xa = x + stack.shift(); ya = y;
              xb = xa + stack.shift(); yb = ya + stack.shift();
              y = yb + stack.shift();
              x = xb + (stack.length === 1 ? stack.shift() : 0);
              bezierCurveTo(xa, ya, xb, yb, x, y);
              if (stack.length === 0) {
                break;
              }

              xa = x; ya = y + stack.shift();
              xb = xa + stack.shift(); yb = ya + stack.shift();
              x = xb + stack.shift();
              y = yb + (stack.length === 1 ? stack.shift() : 0);
              bezierCurveTo(xa, ya, xb, yb, x, y);
            }
            break;
          default:
            if (v < 32) {
              error('unknown operator: ' + v);
            }
            if (v < 247) {
              stack.push(v - 139);
            } else if (v < 251) {
              stack.push((v - 247) * 256 + code[i++] + 108);
            } else if (v < 255) {
              stack.push(-(v - 251) * 256 - code[i++] - 108);
            } else {
              stack.push(((code[i] << 24) | (code[i + 1] << 16) |
                         (code[i + 2] << 8) | code[i + 3]) / 65536);
              i += 4;
            }
            break;
        }
        if (stackClean) {
          stack.length = 0;
        }
      }
    }
    parse(code);
  }

  var noop = '';

  function CompiledFont(fontMatrix) {
    this.compiledGlyphs = Object.create(null);
    this.compiledCharCodeToGlyphId = Object.create(null);
    this.fontMatrix = fontMatrix;
  }
  CompiledFont.prototype = {
    getPathJs: function (unicode) {
      var cmap = lookupCmap(this.cmap, unicode);
      var fn = this.compiledGlyphs[cmap.glyphId];
      if (!fn) {
        fn = this.compileGlyph(this.glyphs[cmap.glyphId]);
        this.compiledGlyphs[cmap.glyphId] = fn;
      }
      if (this.compiledCharCodeToGlyphId[cmap.charCode] === undefined) {
        this.compiledCharCodeToGlyphId[cmap.charCode] = cmap.glyphId;
      }
      return fn;
    },

    compileGlyph: function (code) {
      if (!code || code.length === 0 || code[0] === 14) {
        return noop;
      }

      var cmds = [];
      cmds.push({cmd: 'save'});
      cmds.push({cmd: 'transform', args: this.fontMatrix.slice()});
      cmds.push({cmd: 'scale', args: ['size', '-size']});

      this.compileGlyphImpl(code, cmds);

      cmds.push({cmd: 'restore'});

      return cmds;
    },

    compileGlyphImpl: function () {
      error('Children classes should implement this.');
    },

    hasBuiltPath: function (unicode) {
      var cmap = lookupCmap(this.cmap, unicode);
      return (this.compiledGlyphs[cmap.glyphId] !== undefined &&
              this.compiledCharCodeToGlyphId[cmap.charCode] !== undefined);
    }
  };

  function TrueTypeCompiled(glyphs, cmap, fontMatrix) {
    fontMatrix = fontMatrix || [0.000488, 0, 0, 0.000488, 0, 0];
    CompiledFont.call(this, fontMatrix);

    this.glyphs = glyphs;
    this.cmap = cmap;
  }

  Util.inherit(TrueTypeCompiled, CompiledFont, {
    compileGlyphImpl: function (code, cmds) {
      compileGlyf(code, cmds, this);
    }
  });

  function Type2Compiled(cffInfo, cmap, fontMatrix, glyphNameMap) {
    fontMatrix = fontMatrix || [0.001, 0, 0, 0.001, 0, 0];
    CompiledFont.call(this, fontMatrix);

    this.glyphs = cffInfo.glyphs;
    this.gsubrs = cffInfo.gsubrs || [];
    this.subrs = cffInfo.subrs || [];
    this.cmap = cmap;
    this.glyphNameMap = glyphNameMap || getGlyphsUnicode();

    this.gsubrsBias = (this.gsubrs.length < 1240 ?
                       107 : (this.gsubrs.length < 33900 ? 1131 : 32768));
    this.subrsBias = (this.subrs.length < 1240 ?
                      107 : (this.subrs.length < 33900 ? 1131 : 32768));
  }

  Util.inherit(Type2Compiled, CompiledFont, {
    compileGlyphImpl: function (code, cmds) {
      compileCharString(code, cmds, this);
    }
  });


  return {
    create: function FontRendererFactory_create(font, seacAnalysisEnabled) {
      var data = new Uint8Array(font.data);
      var cmap, glyf, loca, cff, indexToLocFormat, unitsPerEm;
      var numTables = getUshort(data, 4);
      for (var i = 0, p = 12; i < numTables; i++, p += 16) {
        var tag = bytesToString(data.subarray(p, p + 4));
        var offset = getLong(data, p + 8);
        var length = getLong(data, p + 12);
        switch (tag) {
          case 'cmap':
            cmap = parseCmap(data, offset, offset + length);
            break;
          case 'glyf':
            glyf = data.subarray(offset, offset + length);
            break;
          case 'loca':
            loca = data.subarray(offset, offset + length);
            break;
          case 'head':
            unitsPerEm = getUshort(data, offset + 18);
            indexToLocFormat = getUshort(data, offset + 50);
            break;
          case 'CFF ':
            cff = parseCff(data, offset, offset + length, seacAnalysisEnabled);
            break;
        }
      }

      if (glyf) {
        var fontMatrix = (!unitsPerEm ? font.fontMatrix :
                          [1 / unitsPerEm, 0, 0, 1 / unitsPerEm, 0, 0]);
        return new TrueTypeCompiled(
          parseGlyfTable(glyf, loca, indexToLocFormat), cmap, fontMatrix);
      } else {
        return new Type2Compiled(cff, cmap, font.fontMatrix, font.glyphNameMap);
      }
    }
  };
})();

exports.FontRendererFactory = FontRendererFactory;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreParser = {}), root.pdfjsSharedUtil,
      root.pdfjsCorePrimitives, root.pdfjsCoreStream);
  }
}(this, function (exports, sharedUtil, corePrimitives, coreStream) {

var MissingDataException = sharedUtil.MissingDataException;
var StreamType = sharedUtil.StreamType;
var assert = sharedUtil.assert;
var error = sharedUtil.error;
var info = sharedUtil.info;
var isArray = sharedUtil.isArray;
var isInt = sharedUtil.isInt;
var isNum = sharedUtil.isNum;
var isString = sharedUtil.isString;
var warn = sharedUtil.warn;
var Cmd = corePrimitives.Cmd;
var Dict = corePrimitives.Dict;
var Name = corePrimitives.Name;
var Ref = corePrimitives.Ref;
var isCmd = corePrimitives.isCmd;
var isDict = corePrimitives.isDict;
var isName = corePrimitives.isName;
var Ascii85Stream = coreStream.Ascii85Stream;
var AsciiHexStream = coreStream.AsciiHexStream;
var CCITTFaxStream = coreStream.CCITTFaxStream;
var FlateStream = coreStream.FlateStream;
var Jbig2Stream = coreStream.Jbig2Stream;
var JpegStream = coreStream.JpegStream;
var JpxStream = coreStream.JpxStream;
var LZWStream = coreStream.LZWStream;
var NullStream = coreStream.NullStream;
var PredictorStream = coreStream.PredictorStream;
var RunLengthStream = coreStream.RunLengthStream;

var EOF = {};

function isEOF(v) {
  return (v === EOF);
}

var MAX_LENGTH_TO_CACHE = 1000;

var Parser = (function ParserClosure() {
  function Parser(lexer, allowStreams, xref, recoveryMode) {
    this.lexer = lexer;
    this.allowStreams = allowStreams;
    this.xref = xref;
    this.recoveryMode = recoveryMode || false;
    this.imageCache = Object.create(null);
    this.refill();
  }

  Parser.prototype = {
    refill: function Parser_refill() {
      this.buf1 = this.lexer.getObj();
      this.buf2 = this.lexer.getObj();
    },
    shift: function Parser_shift() {
      if (isCmd(this.buf2, 'ID')) {
        this.buf1 = this.buf2;
        this.buf2 = null;
      } else {
        this.buf1 = this.buf2;
        this.buf2 = this.lexer.getObj();
      }
    },
    tryShift: function Parser_tryShift() {
      try {
        this.shift();
        return true;
      } catch (e) {
        if (e instanceof MissingDataException) {
          throw e;
        }
        // Upon failure, the caller should reset this.lexer.pos to a known good
        // state and call this.shift() twice to reset the buffers.
        return false;
      }
    },
    getObj: function Parser_getObj(cipherTransform) {
      var buf1 = this.buf1;
      this.shift();

      if (buf1 instanceof Cmd) {
        switch (buf1.cmd) {
          case 'BI': // inline image
            return this.makeInlineImage(cipherTransform);
          case '[': // array
            var array = [];
            while (!isCmd(this.buf1, ']') && !isEOF(this.buf1)) {
              array.push(this.getObj(cipherTransform));
            }
            if (isEOF(this.buf1)) {
              if (!this.recoveryMode) {
                error('End of file inside array');
              }
              return array;
            }
            this.shift();
            return array;
          case '<<': // dictionary or stream
            var dict = new Dict(this.xref);
            while (!isCmd(this.buf1, '>>') && !isEOF(this.buf1)) {
              if (!isName(this.buf1)) {
                info('Malformed dictionary: key must be a name object');
                this.shift();
                continue;
              }

              var key = this.buf1.name;
              this.shift();
              if (isEOF(this.buf1)) {
                break;
              }
              dict.set(key, this.getObj(cipherTransform));
            }
            if (isEOF(this.buf1)) {
              if (!this.recoveryMode) {
                error('End of file inside dictionary');
              }
              return dict;
            }

            // Stream objects are not allowed inside content streams or
            // object streams.
            if (isCmd(this.buf2, 'stream')) {
              return (this.allowStreams ?
                      this.makeStream(dict, cipherTransform) : dict);
            }
            this.shift();
            return dict;
          default: // simple object
            return buf1;
        }
      }

      if (isInt(buf1)) { // indirect reference or integer
        var num = buf1;
        if (isInt(this.buf1) && isCmd(this.buf2, 'R')) {
          var ref = new Ref(num, this.buf1);
          this.shift();
          this.shift();
          return ref;
        }
        return num;
      }

      if (isString(buf1)) { // string
        var str = buf1;
        if (cipherTransform) {
          str = cipherTransform.decryptString(str);
        }
        return str;
      }

      // simple object
      return buf1;
    },
    /**
     * Find the end of the stream by searching for the /EI\s/.
     * @returns {number} The inline stream length.
     */
    findDefaultInlineStreamEnd:
        function Parser_findDefaultInlineStreamEnd(stream) {
      var E = 0x45, I = 0x49, SPACE = 0x20, LF = 0xA, CR = 0xD;
      var startPos = stream.pos, state = 0, ch, i, n, followingBytes;
      while ((ch = stream.getByte()) !== -1) {
        if (state === 0) {
          state = (ch === E) ? 1 : 0;
        } else if (state === 1) {
          state = (ch === I) ? 2 : 0;
        } else {
          assert(state === 2);
          if (ch === SPACE || ch === LF || ch === CR) {
            // Let's check the next five bytes are ASCII... just be sure.
            n = 5;
            followingBytes = stream.peekBytes(n);
            for (i = 0; i < n; i++) {
              ch = followingBytes[i];
              if (ch !== LF && ch !== CR && (ch < SPACE || ch > 0x7F)) {
                // Not a LF, CR, SPACE or any visible ASCII character, i.e.
                // it's binary stuff. Resetting the state.
                state = 0;
                break;
              }
            }
            if (state === 2) {
              break;  // Finished!
            }
          } else {
            state = 0;
          }
        }
      }
      return ((stream.pos - 4) - startPos);
    },
    /**
     * Find the EOI (end-of-image) marker 0xFFD9 of the stream.
     * @returns {number} The inline stream length.
     */
    findDCTDecodeInlineStreamEnd:
        function Parser_findDCTDecodeInlineStreamEnd(stream) {
      var startPos = stream.pos, foundEOI = false, b, markerLength, length;
      while ((b = stream.getByte()) !== -1) {
        if (b !== 0xFF) { // Not a valid marker.
          continue;
        }
        switch (stream.getByte()) {
          case 0x00: // Byte stuffing.
            // 0xFF00 appears to be a very common byte sequence in JPEG images.
            break;

          case 0xFF: // Fill byte.
            // Avoid skipping a valid marker, resetting the stream position.
            stream.skip(-1);
            break;

          case 0xD9: // EOI
            foundEOI = true;
            break;

          case 0xC0: // SOF0
          case 0xC1: // SOF1
          case 0xC2: // SOF2
          case 0xC3: // SOF3

          case 0xC5: // SOF5
          case 0xC6: // SOF6
          case 0xC7: // SOF7

          case 0xC9: // SOF9
          case 0xCA: // SOF10
          case 0xCB: // SOF11

          case 0xCD: // SOF13
          case 0xCE: // SOF14
          case 0xCF: // SOF15

          case 0xC4: // DHT
          case 0xCC: // DAC

          case 0xDA: // SOS
          case 0xDB: // DQT
          case 0xDC: // DNL
          case 0xDD: // DRI
          case 0xDE: // DHP
          case 0xDF: // EXP

          case 0xE0: // APP0
          case 0xE1: // APP1
          case 0xE2: // APP2
          case 0xE3: // APP3
          case 0xE4: // APP4
          case 0xE5: // APP5
          case 0xE6: // APP6
          case 0xE7: // APP7
          case 0xE8: // APP8
          case 0xE9: // APP9
          case 0xEA: // APP10
          case 0xEB: // APP11
          case 0xEC: // APP12
          case 0xED: // APP13
          case 0xEE: // APP14
          case 0xEF: // APP15

          case 0xFE: // COM
            // The marker should be followed by the length of the segment.
            markerLength = stream.getUint16();
            if (markerLength > 2) {
              // |markerLength| contains the byte length of the marker segment,
              // including its own length (2 bytes) and excluding the marker.
              stream.skip(markerLength - 2); // Jump to the next marker.
            } else {
              // The marker length is invalid, resetting the stream position.
              stream.skip(-2);
            }
            break;
        }
        if (foundEOI) {
          break;
        }
      }
      length = stream.pos - startPos;
      if (b === -1) {
        warn('Inline DCTDecode image stream: ' +
             'EOI marker not found, searching for /EI/ instead.');
        stream.skip(-length); // Reset the stream position.
        return this.findDefaultInlineStreamEnd(stream);
      }
      this.inlineStreamSkipEI(stream);
      return length;
    },
    /**
     * Find the EOD (end-of-data) marker '~>' (i.e. TILDE + GT) of the stream.
     * @returns {number} The inline stream length.
     */
    findASCII85DecodeInlineStreamEnd:
        function Parser_findASCII85DecodeInlineStreamEnd(stream) {
      var TILDE = 0x7E, GT = 0x3E;
      var startPos = stream.pos, ch, length;
      while ((ch = stream.getByte()) !== -1) {
        if (ch === TILDE && stream.peekByte() === GT) {
          stream.skip();
          break;
        }
      }
      length = stream.pos - startPos;
      if (ch === -1) {
        warn('Inline ASCII85Decode image stream: ' +
             'EOD marker not found, searching for /EI/ instead.');
        stream.skip(-length); // Reset the stream position.
        return this.findDefaultInlineStreamEnd(stream);
      }
      this.inlineStreamSkipEI(stream);
      return length;
    },
    /**
     * Find the EOD (end-of-data) marker '>' (i.e. GT) of the stream.
     * @returns {number} The inline stream length.
     */
    findASCIIHexDecodeInlineStreamEnd:
        function Parser_findASCIIHexDecodeInlineStreamEnd(stream) {
      var GT = 0x3E;
      var startPos = stream.pos, ch, length;
      while ((ch = stream.getByte()) !== -1) {
        if (ch === GT) {
          break;
        }
      }
      length = stream.pos - startPos;
      if (ch === -1) {
        warn('Inline ASCIIHexDecode image stream: ' +
             'EOD marker not found, searching for /EI/ instead.');
        stream.skip(-length); // Reset the stream position.
        return this.findDefaultInlineStreamEnd(stream);
      }
      this.inlineStreamSkipEI(stream);
      return length;
    },
    /**
     * Skip over the /EI/ for streams where we search for an EOD marker.
     */
    inlineStreamSkipEI: function Parser_inlineStreamSkipEI(stream) {
      var E = 0x45, I = 0x49;
      var state = 0, ch;
      while ((ch = stream.getByte()) !== -1) {
        if (state === 0) {
          state = (ch === E) ? 1 : 0;
        } else if (state === 1) {
          state = (ch === I) ? 2 : 0;
        } else if (state === 2) {
          break;
        }
      }
    },
    makeInlineImage: function Parser_makeInlineImage(cipherTransform) {
      var lexer = this.lexer;
      var stream = lexer.stream;

      // Parse dictionary.
      var dict = new Dict(this.xref);
      while (!isCmd(this.buf1, 'ID') && !isEOF(this.buf1)) {
        if (!isName(this.buf1)) {
          error('Dictionary key must be a name object');
        }
        var key = this.buf1.name;
        this.shift();
        if (isEOF(this.buf1)) {
          break;
        }
        dict.set(key, this.getObj(cipherTransform));
      }

      // Extract the name of the first (i.e. the current) image filter.
      var filter = dict.get('Filter', 'F'), filterName;
      if (isName(filter)) {
        filterName = filter.name;
      } else if (isArray(filter) && isName(filter[0])) {
        filterName = filter[0].name;
      }

      // Parse image stream.
      var startPos = stream.pos, length, i, ii;
      if (filterName === 'DCTDecode' || filterName === 'DCT') {
        length = this.findDCTDecodeInlineStreamEnd(stream);
      } else if (filterName === 'ASCII85Decide' || filterName === 'A85') {
        length = this.findASCII85DecodeInlineStreamEnd(stream);
      } else if (filterName === 'ASCIIHexDecode' || filterName === 'AHx') {
        length = this.findASCIIHexDecodeInlineStreamEnd(stream);
      } else {
        length = this.findDefaultInlineStreamEnd(stream);
      }
      var imageStream = stream.makeSubStream(startPos, length, dict);

      // Cache all images below the MAX_LENGTH_TO_CACHE threshold by their
      // adler32 checksum.
      var adler32;
      if (length < MAX_LENGTH_TO_CACHE) {
        var imageBytes = imageStream.getBytes();
        imageStream.reset();

        var a = 1;
        var b = 0;
        for (i = 0, ii = imageBytes.length; i < ii; ++i) {
          // No modulo required in the loop if imageBytes.length < 5552.
          a += imageBytes[i] & 0xff;
          b += a;
        }
        adler32 = ((b % 65521) << 16) | (a % 65521);

        if (this.imageCache.adler32 === adler32) {
          this.buf2 = Cmd.get('EI');
          this.shift();

          this.imageCache[adler32].reset();
          return this.imageCache[adler32];
        }
      }

      if (cipherTransform) {
        imageStream = cipherTransform.createStream(imageStream, length);
      }

      imageStream = this.filter(imageStream, dict, length);
      imageStream.dict = dict;
      if (adler32 !== undefined) {
        imageStream.cacheKey = 'inline_' + length + '_' + adler32;
        this.imageCache[adler32] = imageStream;
      }

      this.buf2 = Cmd.get('EI');
      this.shift();

      return imageStream;
    },
    makeStream: function Parser_makeStream(dict, cipherTransform) {
      var lexer = this.lexer;
      var stream = lexer.stream;

      // get stream start position
      lexer.skipToNextLine();
      var pos = stream.pos - 1;

      // get length
      var length = dict.get('Length');
      if (!isInt(length)) {
        info('Bad ' + length + ' attribute in stream');
        length = 0;
      }

      // skip over the stream data
      stream.pos = pos + length;
      lexer.nextChar();

      // Shift '>>' and check whether the new object marks the end of the stream
      if (this.tryShift() && isCmd(this.buf2, 'endstream')) {
        this.shift(); // 'stream'
      } else {
        // bad stream length, scanning for endstream
        stream.pos = pos;
        var SCAN_BLOCK_SIZE = 2048;
        var ENDSTREAM_SIGNATURE_LENGTH = 9;
        var ENDSTREAM_SIGNATURE = [0x65, 0x6E, 0x64, 0x73, 0x74, 0x72, 0x65,
                                   0x61, 0x6D];
        var skipped = 0, found = false, i, j;
        while (stream.pos < stream.end) {
          var scanBytes = stream.peekBytes(SCAN_BLOCK_SIZE);
          var scanLength = scanBytes.length - ENDSTREAM_SIGNATURE_LENGTH;
          if (scanLength <= 0) {
            break;
          }
          found = false;
          i = 0;
          while (i < scanLength) {
            j = 0;
            while (j < ENDSTREAM_SIGNATURE_LENGTH &&
                   scanBytes[i + j] === ENDSTREAM_SIGNATURE[j]) {
              j++;
            }
            if (j >= ENDSTREAM_SIGNATURE_LENGTH) {
              found = true;
              break;
            }
            i++;
          }
          if (found) {
            skipped += i;
            stream.pos += i;
            break;
          }
          skipped += scanLength;
          stream.pos += scanLength;
        }
        if (!found) {
          error('Missing endstream');
        }
        length = skipped;

        lexer.nextChar();
        this.shift();
        this.shift();
      }
      this.shift(); // 'endstream'

      stream = stream.makeSubStream(pos, length, dict);
      if (cipherTransform) {
        stream = cipherTransform.createStream(stream, length);
      }
      stream = this.filter(stream, dict, length);
      stream.dict = dict;
      return stream;
    },
    filter: function Parser_filter(stream, dict, length) {
      var filter = dict.get('Filter', 'F');
      var params = dict.get('DecodeParms', 'DP');
      if (isName(filter)) {
        return this.makeFilter(stream, filter.name, length, params);
      }

      var maybeLength = length;
      if (isArray(filter)) {
        var filterArray = filter;
        var paramsArray = params;
        for (var i = 0, ii = filterArray.length; i < ii; ++i) {
          filter = filterArray[i];
          if (!isName(filter)) {
            error('Bad filter name: ' + filter);
          }

          params = null;
          if (isArray(paramsArray) && (i in paramsArray)) {
            params = paramsArray[i];
          }
          stream = this.makeFilter(stream, filter.name, maybeLength, params);
          // after the first stream the length variable is invalid
          maybeLength = null;
        }
      }
      return stream;
    },
    makeFilter: function Parser_makeFilter(stream, name, maybeLength, params) {
      if (stream.dict.get('Length') === 0 && !maybeLength) {
        warn('Empty "' + name + '" stream.');
        return new NullStream(stream);
      }
      try {
        if (params && this.xref) {
          params = this.xref.fetchIfRef(params);
        }
        var xrefStreamStats = this.xref.stats.streamTypes;
        if (name === 'FlateDecode' || name === 'Fl') {
          xrefStreamStats[StreamType.FLATE] = true;
          if (params) {
            return new PredictorStream(new FlateStream(stream, maybeLength),
                                       maybeLength, params);
          }
          return new FlateStream(stream, maybeLength);
        }
        if (name === 'LZWDecode' || name === 'LZW') {
          xrefStreamStats[StreamType.LZW] = true;
          var earlyChange = 1;
          if (params) {
            if (params.has('EarlyChange')) {
              earlyChange = params.get('EarlyChange');
            }
            return new PredictorStream(
              new LZWStream(stream, maybeLength, earlyChange),
              maybeLength, params);
          }
          return new LZWStream(stream, maybeLength, earlyChange);
        }
        if (name === 'DCTDecode' || name === 'DCT') {
          xrefStreamStats[StreamType.DCT] = true;
          return new JpegStream(stream, maybeLength, stream.dict, this.xref);
        }
        if (name === 'JPXDecode' || name === 'JPX') {
          xrefStreamStats[StreamType.JPX] = true;
          return new JpxStream(stream, maybeLength, stream.dict);
        }
        if (name === 'ASCII85Decode' || name === 'A85') {
          xrefStreamStats[StreamType.A85] = true;
          return new Ascii85Stream(stream, maybeLength);
        }
        if (name === 'ASCIIHexDecode' || name === 'AHx') {
          xrefStreamStats[StreamType.AHX] = true;
          return new AsciiHexStream(stream, maybeLength);
        }
        if (name === 'CCITTFaxDecode' || name === 'CCF') {
          xrefStreamStats[StreamType.CCF] = true;
          return new CCITTFaxStream(stream, maybeLength, params);
        }
        if (name === 'RunLengthDecode' || name === 'RL') {
          xrefStreamStats[StreamType.RL] = true;
          return new RunLengthStream(stream, maybeLength);
        }
        if (name === 'JBIG2Decode') {
          xrefStreamStats[StreamType.JBIG] = true;
          return new Jbig2Stream(stream, maybeLength, stream.dict);
        }
        warn('filter "' + name + '" not supported yet');
        return stream;
      } catch (ex) {
        if (ex instanceof MissingDataException) {
          throw ex;
        }
        warn('Invalid stream: \"' + ex + '\"');
        return new NullStream(stream);
      }
    }
  };

  return Parser;
})();

var Lexer = (function LexerClosure() {
  function Lexer(stream, knownCommands) {
    this.stream = stream;
    this.nextChar();

    // While lexing, we build up many strings one char at a time. Using += for
    // this can result in lots of garbage strings. It's better to build an
    // array of single-char strings and then join() them together at the end.
    // And reusing a single array (i.e. |this.strBuf|) over and over for this
    // purpose uses less memory than using a new array for each string.
    this.strBuf = [];

    // The PDFs might have "glued" commands with other commands, operands or
    // literals, e.g. "q1". The knownCommands is a dictionary of the valid
    // commands and their prefixes. The prefixes are built the following way:
    // if there a command that is a prefix of the other valid command or
    // literal (e.g. 'f' and 'false') the following prefixes must be included,
    // 'fa', 'fal', 'fals'. The prefixes are not needed, if the command has no
    // other commands or literals as a prefix. The knowCommands is optional.
    this.knownCommands = knownCommands;
  }

  // A '1' in this array means the character is white space. A '1' or
  // '2' means the character ends a name or command.
  var specialChars = [
    1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, // 0x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 1x
    1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, // 2x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, // 3x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 4x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, // 5x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 6x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, // 7x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 8x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 9x
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // ax
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // bx
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // cx
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // dx
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // ex
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0  // fx
  ];

  function toHexDigit(ch) {
    if (ch >= 0x30 && ch <= 0x39) { // '0'-'9'
      return ch & 0x0F;
    }
    if ((ch >= 0x41 && ch <= 0x46) || (ch >= 0x61 && ch <= 0x66)) {
      // 'A'-'F', 'a'-'f'
      return (ch & 0x0F) + 9;
    }
    return -1;
  }

  Lexer.prototype = {
    nextChar: function Lexer_nextChar() {
      return (this.currentChar = this.stream.getByte());
    },
    peekChar: function Lexer_peekChar() {
      return this.stream.peekByte();
    },
    getNumber: function Lexer_getNumber() {
      var ch = this.currentChar;
      var eNotation = false;
      var divideBy = 0; // different from 0 if it's a floating point value
      var sign = 1;

      if (ch === 0x2D) { // '-'
        sign = -1;
        ch = this.nextChar();

        if (ch === 0x2D) { // '-'
          // Ignore double negative (this is consistent with Adobe Reader).
          ch = this.nextChar();
        }
      } else if (ch === 0x2B) { // '+'
        ch = this.nextChar();
      }
      if (ch === 0x2E) { // '.'
        divideBy = 10;
        ch = this.nextChar();
      }
      if (ch < 0x30 || ch > 0x39) { // '0' - '9'
        error('Invalid number: ' + String.fromCharCode(ch));
        return 0;
      }

      var baseValue = ch - 0x30; // '0'
      var powerValue = 0;
      var powerValueSign = 1;

      while ((ch = this.nextChar()) >= 0) {
        if (0x30 <= ch && ch <= 0x39) { // '0' - '9'
          var currentDigit = ch - 0x30; // '0'
          if (eNotation) { // We are after an 'e' or 'E'
            powerValue = powerValue * 10 + currentDigit;
          } else {
            if (divideBy !== 0) { // We are after a point
              divideBy *= 10;
            }
            baseValue = baseValue * 10 + currentDigit;
          }
        } else if (ch === 0x2E) { // '.'
          if (divideBy === 0) {
            divideBy = 1;
          } else {
            // A number can have only one '.'
            break;
          }
        } else if (ch === 0x2D) { // '-'
          // ignore minus signs in the middle of numbers to match
          // Adobe's behavior
          warn('Badly formatted number');
        } else if (ch === 0x45 || ch === 0x65) { // 'E', 'e'
          // 'E' can be either a scientific notation or the beginning of a new
          // operator
          ch = this.peekChar();
          if (ch === 0x2B || ch === 0x2D) { // '+', '-'
            powerValueSign = (ch === 0x2D) ? -1 : 1;
            this.nextChar(); // Consume the sign character
          } else if (ch < 0x30 || ch > 0x39) { // '0' - '9'
            // The 'E' must be the beginning of a new operator
            break;
          }
          eNotation = true;
        } else {
          // the last character doesn't belong to us
          break;
        }
      }

      if (divideBy !== 0) {
        baseValue /= divideBy;
      }
      if (eNotation) {
        baseValue *= Math.pow(10, powerValueSign * powerValue);
      }
      return sign * baseValue;
    },
    getString: function Lexer_getString() {
      var numParen = 1;
      var done = false;
      var strBuf = this.strBuf;
      strBuf.length = 0;

      var ch = this.nextChar();
      while (true) {
        var charBuffered = false;
        switch (ch | 0) {
          case -1:
            warn('Unterminated string');
            done = true;
            break;
          case 0x28: // '('
            ++numParen;
            strBuf.push('(');
            break;
          case 0x29: // ')'
            if (--numParen === 0) {
              this.nextChar(); // consume strings ')'
              done = true;
            } else {
              strBuf.push(')');
            }
            break;
          case 0x5C: // '\\'
            ch = this.nextChar();
            switch (ch) {
              case -1:
                warn('Unterminated string');
                done = true;
                break;
              case 0x6E: // 'n'
                strBuf.push('\n');
                break;
              case 0x72: // 'r'
                strBuf.push('\r');
                break;
              case 0x74: // 't'
                strBuf.push('\t');
                break;
              case 0x62: // 'b'
                strBuf.push('\b');
                break;
              case 0x66: // 'f'
                strBuf.push('\f');
                break;
              case 0x5C: // '\'
              case 0x28: // '('
              case 0x29: // ')'
                strBuf.push(String.fromCharCode(ch));
                break;
              case 0x30: case 0x31: case 0x32: case 0x33: // '0'-'3'
              case 0x34: case 0x35: case 0x36: case 0x37: // '4'-'7'
                var x = ch & 0x0F;
                ch = this.nextChar();
                charBuffered = true;
                if (ch >= 0x30 && ch <= 0x37) { // '0'-'7'
                  x = (x << 3) + (ch & 0x0F);
                  ch = this.nextChar();
                  if (ch >= 0x30 && ch <= 0x37) {  // '0'-'7'
                    charBuffered = false;
                    x = (x << 3) + (ch & 0x0F);
                  }
                }
                strBuf.push(String.fromCharCode(x));
                break;
              case 0x0D: // CR
                if (this.peekChar() === 0x0A) { // LF
                  this.nextChar();
                }
                break;
              case 0x0A: // LF
                break;
              default:
                strBuf.push(String.fromCharCode(ch));
                break;
            }
            break;
          default:
            strBuf.push(String.fromCharCode(ch));
            break;
        }
        if (done) {
          break;
        }
        if (!charBuffered) {
          ch = this.nextChar();
        }
      }
      return strBuf.join('');
    },
    getName: function Lexer_getName() {
      var ch, previousCh;
      var strBuf = this.strBuf;
      strBuf.length = 0;
      while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
        if (ch === 0x23) { // '#'
          ch = this.nextChar();
          if (specialChars[ch]) {
            warn('Lexer_getName: ' +
                 'NUMBER SIGN (#) should be followed by a hexadecimal number.');
            strBuf.push('#');
            break;
          }
          var x = toHexDigit(ch);
          if (x !== -1) {
            previousCh = ch;
            ch = this.nextChar();
            var x2 = toHexDigit(ch);
            if (x2 === -1) {
              warn('Lexer_getName: Illegal digit (' +
                   String.fromCharCode(ch) +') in hexadecimal number.');
              strBuf.push('#', String.fromCharCode(previousCh));
              if (specialChars[ch]) {
                break;
              }
              strBuf.push(String.fromCharCode(ch));
              continue;
            }
            strBuf.push(String.fromCharCode((x << 4) | x2));
          } else {
            strBuf.push('#', String.fromCharCode(ch));
          }
        } else {
          strBuf.push(String.fromCharCode(ch));
        }
      }
      if (strBuf.length > 127) {
        warn('name token is longer than allowed by the spec: ' + strBuf.length);
      }
      return Name.get(strBuf.join(''));
    },
    getHexString: function Lexer_getHexString() {
      var strBuf = this.strBuf;
      strBuf.length = 0;
      var ch = this.currentChar;
      var isFirstHex = true;
      var firstDigit;
      var secondDigit;
      while (true) {
        if (ch < 0) {
          warn('Unterminated hex string');
          break;
        } else if (ch === 0x3E) { // '>'
          this.nextChar();
          break;
        } else if (specialChars[ch] === 1) {
          ch = this.nextChar();
          continue;
        } else {
          if (isFirstHex) {
            firstDigit = toHexDigit(ch);
            if (firstDigit === -1) {
              warn('Ignoring invalid character "' + ch + '" in hex string');
              ch = this.nextChar();
              continue;
            }
          } else {
            secondDigit = toHexDigit(ch);
            if (secondDigit === -1) {
              warn('Ignoring invalid character "' + ch + '" in hex string');
              ch = this.nextChar();
              continue;
            }
            strBuf.push(String.fromCharCode((firstDigit << 4) | secondDigit));
          }
          isFirstHex = !isFirstHex;
          ch = this.nextChar();
        }
      }
      return strBuf.join('');
    },
    getObj: function Lexer_getObj() {
      // skip whitespace and comments
      var comment = false;
      var ch = this.currentChar;
      while (true) {
        if (ch < 0) {
          return EOF;
        }
        if (comment) {
          if (ch === 0x0A || ch === 0x0D) { // LF, CR
            comment = false;
          }
        } else if (ch === 0x25) { // '%'
          comment = true;
        } else if (specialChars[ch] !== 1) {
          break;
        }
        ch = this.nextChar();
      }

      // start reading token
      switch (ch | 0) {
        case 0x30: case 0x31: case 0x32: case 0x33: case 0x34: // '0'-'4'
        case 0x35: case 0x36: case 0x37: case 0x38: case 0x39: // '5'-'9'
        case 0x2B: case 0x2D: case 0x2E: // '+', '-', '.'
          return this.getNumber();
        case 0x28: // '('
          return this.getString();
        case 0x2F: // '/'
          return this.getName();
        // array punctuation
        case 0x5B: // '['
          this.nextChar();
          return Cmd.get('[');
        case 0x5D: // ']'
          this.nextChar();
          return Cmd.get(']');
        // hex string or dict punctuation
        case 0x3C: // '<'
          ch = this.nextChar();
          if (ch === 0x3C) {
            // dict punctuation
            this.nextChar();
            return Cmd.get('<<');
          }
          return this.getHexString();
        // dict punctuation
        case 0x3E: // '>'
          ch = this.nextChar();
          if (ch === 0x3E) {
            this.nextChar();
            return Cmd.get('>>');
          }
          return Cmd.get('>');
        case 0x7B: // '{'
          this.nextChar();
          return Cmd.get('{');
        case 0x7D: // '}'
          this.nextChar();
          return Cmd.get('}');
        case 0x29: // ')'
          error('Illegal character: ' + ch);
          break;
      }

      // command
      var str = String.fromCharCode(ch);
      var knownCommands = this.knownCommands;
      var knownCommandFound = knownCommands && knownCommands[str] !== undefined;
      while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
        // stop if known command is found and next character does not make
        // the str a command
        var possibleCommand = str + String.fromCharCode(ch);
        if (knownCommandFound && knownCommands[possibleCommand] === undefined) {
          break;
        }
        if (str.length === 128) {
          error('Command token too long: ' + str.length);
        }
        str = possibleCommand;
        knownCommandFound = knownCommands && knownCommands[str] !== undefined;
      }
      if (str === 'true') {
        return true;
      }
      if (str === 'false') {
        return false;
      }
      if (str === 'null') {
        return null;
      }
      return Cmd.get(str);
    },
    skipToNextLine: function Lexer_skipToNextLine() {
      var ch = this.currentChar;
      while (ch >= 0) {
        if (ch === 0x0D) { // CR
          ch = this.nextChar();
          if (ch === 0x0A) { // LF
            this.nextChar();
          }
          break;
        } else if (ch === 0x0A) { // LF
          this.nextChar();
          break;
        }
        ch = this.nextChar();
      }
    }
  };

  return Lexer;
})();

var Linearization = {
  create: function LinearizationCreate(stream) {
    function getInt(name, allowZeroValue) {
      var obj = linDict.get(name);
      if (isInt(obj) && (allowZeroValue ? obj >= 0 : obj > 0)) {
        return obj;
      }
      throw new Error('The "' + name + '" parameter in the linearization ' +
                      'dictionary is invalid.');
    }
    function getHints() {
      var hints = linDict.get('H'), hintsLength, item;
      if (isArray(hints) &&
          ((hintsLength = hints.length) === 2 || hintsLength === 4)) {
        for (var index = 0; index < hintsLength; index++) {
          if (!(isInt(item = hints[index]) && item > 0)) {
            throw new Error('Hint (' + index +
                            ') in the linearization dictionary is invalid.');
          }
        }
        return hints;
      }
      throw new Error('Hint array in the linearization dictionary is invalid.');
    }
    var parser = new Parser(new Lexer(stream), false, null);
    var obj1 = parser.getObj();
    var obj2 = parser.getObj();
    var obj3 = parser.getObj();
    var linDict = parser.getObj();
    var obj, length;
    if (!(isInt(obj1) && isInt(obj2) && isCmd(obj3, 'obj') && isDict(linDict) &&
          isNum(obj = linDict.get('Linearized')) && obj > 0)) {
      return null; // No valid linearization dictionary found.
    } else if ((length = getInt('L')) !== stream.length) {
      throw new Error('The "L" parameter in the linearization dictionary ' +
                      'does not equal the stream length.');
    }
    return {
      length: length,
      hints: getHints(),
      objectNumberFirst: getInt('O'),
      endFirst: getInt('E'),
      numPages: getInt('N'),
      mainXRefEntriesOffset: getInt('T'),
      pageFirst: (linDict.has('P') ? getInt('P', true) : 0)
    };
  }
};

exports.EOF = EOF;
exports.Lexer = Lexer;
exports.Linearization = Linearization;
exports.Parser = Parser;
exports.isEOF = isEOF;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreType1Parser = {}), root.pdfjsSharedUtil,
      root.pdfjsCoreStream, root.pdfjsCoreEncodings);
  }
}(this, function (exports, sharedUtil, coreStream, coreEncodings) {

var warn = sharedUtil.warn;
var isSpace = sharedUtil.isSpace;
var Stream = coreStream.Stream;
var getEncoding = coreEncodings.getEncoding;

// Hinting is currently disabled due to unknown problems on windows
// in tracemonkey and various other pdfs with type1 fonts.
var HINTING_ENABLED = false;

/*
 * CharStrings are encoded following the the CharString Encoding sequence
 * describe in Chapter 6 of the "Adobe Type1 Font Format" specification.
 * The value in a byte indicates a command, a number, or subsequent bytes
 * that are to be interpreted in a special way.
 *
 * CharString Number Encoding:
 *  A CharString byte containing the values from 32 through 255 inclusive
 *  indicate an integer. These values are decoded in four ranges.
 *
 * 1. A CharString byte containing a value, v, between 32 and 246 inclusive,
 * indicate the integer v - 139. Thus, the integer values from -107 through
 * 107 inclusive may be encoded in single byte.
 *
 * 2. A CharString byte containing a value, v, between 247 and 250 inclusive,
 * indicates an integer involving the next byte, w, according to the formula:
 * [(v - 247) x 256] + w + 108
 *
 * 3. A CharString byte containing a value, v, between 251 and 254 inclusive,
 * indicates an integer involving the next byte, w, according to the formula:
 * -[(v - 251) * 256] - w - 108
 *
 * 4. A CharString containing the value 255 indicates that the next 4 bytes
 * are a two complement signed integer. The first of these bytes contains the
 * highest order bits, the second byte contains the next higher order bits
 * and the fourth byte contain the lowest order bits.
 *
 *
 * CharString Command Encoding:
 *  CharStrings commands are encoded in 1 or 2 bytes.
 *
 *  Single byte commands are encoded in 1 byte that contains a value between
 *  0 and 31 inclusive.
 *  If a command byte contains the value 12, then the value in the next byte
 *  indicates a command. This "escape" mechanism allows many extra commands
 * to be encoded and this encoding technique helps to minimize the length of
 * the charStrings.
 */
var Type1CharString = (function Type1CharStringClosure() {
  var COMMAND_MAP = {
    'hstem': [1],
    'vstem': [3],
    'vmoveto': [4],
    'rlineto': [5],
    'hlineto': [6],
    'vlineto': [7],
    'rrcurveto': [8],
    'callsubr': [10],
    'flex': [12, 35],
    'drop' : [12, 18],
    'endchar': [14],
    'rmoveto': [21],
    'hmoveto': [22],
    'vhcurveto': [30],
    'hvcurveto': [31]
  };

  function Type1CharString() {
    this.width = 0;
    this.lsb = 0;
    this.flexing = false;
    this.output = [];
    this.stack = [];
  }

  Type1CharString.prototype = {
    convert: function Type1CharString_convert(encoded, subrs,
                                              seacAnalysisEnabled) {
      var count = encoded.length;
      var error = false;
      var wx, sbx, subrNumber;
      for (var i = 0; i < count; i++) {
        var value = encoded[i];
        if (value < 32) {
          if (value === 12) {
            value = (value << 8) + encoded[++i];
          }
          switch (value) {
            case 1: // hstem
              if (!HINTING_ENABLED) {
                this.stack = [];
                break;
              }
              error = this.executeCommand(2, COMMAND_MAP.hstem);
              break;
            case 3: // vstem
              if (!HINTING_ENABLED) {
                this.stack = [];
                break;
              }
              error = this.executeCommand(2, COMMAND_MAP.vstem);
              break;
            case 4: // vmoveto
              if (this.flexing) {
                if (this.stack.length < 1) {
                  error = true;
                  break;
                }
                // Add the dx for flex and but also swap the values so they are
                // the right order.
                var dy = this.stack.pop();
                this.stack.push(0, dy);
                break;
              }
              error = this.executeCommand(1, COMMAND_MAP.vmoveto);
              break;
            case 5: // rlineto
              error = this.executeCommand(2, COMMAND_MAP.rlineto);
              break;
            case 6: // hlineto
              error = this.executeCommand(1, COMMAND_MAP.hlineto);
              break;
            case 7: // vlineto
              error = this.executeCommand(1, COMMAND_MAP.vlineto);
              break;
            case 8: // rrcurveto
              error = this.executeCommand(6, COMMAND_MAP.rrcurveto);
              break;
            case 9: // closepath
              // closepath is a Type1 command that does not take argument and is
              // useless in Type2 and it can simply be ignored.
              this.stack = [];
              break;
            case 10: // callsubr
              if (this.stack.length < 1) {
                error = true;
                break;
              }
              subrNumber = this.stack.pop();
              error = this.convert(subrs[subrNumber], subrs,
                                   seacAnalysisEnabled);
              break;
            case 11: // return
              return error;
            case 13: // hsbw
              if (this.stack.length < 2) {
                error = true;
                break;
              }
              // To convert to type2 we have to move the width value to the
              // first part of the charstring and then use hmoveto with lsb.
              wx = this.stack.pop();
              sbx = this.stack.pop();
              this.lsb = sbx;
              this.width = wx;
              this.stack.push(wx, sbx);
              error = this.executeCommand(2, COMMAND_MAP.hmoveto);
              break;
            case 14: // endchar
              this.output.push(COMMAND_MAP.endchar[0]);
              break;
            case 21: // rmoveto
              if (this.flexing) {
                break;
              }
              error = this.executeCommand(2, COMMAND_MAP.rmoveto);
              break;
            case 22: // hmoveto
              if (this.flexing) {
                // Add the dy for flex.
                this.stack.push(0);
                break;
              }
              error = this.executeCommand(1, COMMAND_MAP.hmoveto);
              break;
            case 30: // vhcurveto
              error = this.executeCommand(4, COMMAND_MAP.vhcurveto);
              break;
            case 31: // hvcurveto
              error = this.executeCommand(4, COMMAND_MAP.hvcurveto);
              break;
            case (12 << 8) + 0: // dotsection
              // dotsection is a Type1 command to specify some hinting feature
              // for dots that do not take a parameter and it can safely be
              // ignored for Type2.
              this.stack = [];
              break;
            case (12 << 8) + 1: // vstem3
              if (!HINTING_ENABLED) {
                this.stack = [];
                break;
              }
              // [vh]stem3 are Type1 only and Type2 supports [vh]stem with
              // multiple parameters, so instead of returning [vh]stem3 take a
              // shortcut and return [vhstem] instead.
              error = this.executeCommand(2, COMMAND_MAP.vstem);
              break;
            case (12 << 8) + 2: // hstem3
              if (!HINTING_ENABLED) {
                 this.stack = [];
                break;
              }
              // See vstem3.
              error = this.executeCommand(2, COMMAND_MAP.hstem);
              break;
            case (12 << 8) + 6: // seac
              // seac is like type 2's special endchar but it doesn't use the
              // first argument asb, so remove it.
              if (seacAnalysisEnabled) {
                this.seac = this.stack.splice(-4, 4);
                error = this.executeCommand(0, COMMAND_MAP.endchar);
              } else {
                error = this.executeCommand(4, COMMAND_MAP.endchar);
              }
              break;
            case (12 << 8) + 7: // sbw
              if (this.stack.length < 4) {
                error = true;
                break;
              }
              // To convert to type2 we have to move the width value to the
              // first part of the charstring and then use rmoveto with
              // (dx, dy). The height argument will not be used for vmtx and
              // vhea tables reconstruction -- ignoring it.
              var wy = this.stack.pop();
              wx = this.stack.pop();
              var sby = this.stack.pop();
              sbx = this.stack.pop();
              this.lsb = sbx;
              this.width = wx;
              this.stack.push(wx, sbx, sby);
              error = this.executeCommand(3, COMMAND_MAP.rmoveto);
              break;
            case (12 << 8) + 12: // div
              if (this.stack.length < 2) {
                error = true;
                break;
              }
              var num2 = this.stack.pop();
              var num1 = this.stack.pop();
              this.stack.push(num1 / num2);
              break;
            case (12 << 8) + 16: // callothersubr
              if (this.stack.length < 2) {
                error = true;
                break;
              }
              subrNumber = this.stack.pop();
              var numArgs = this.stack.pop();
              if (subrNumber === 0 && numArgs === 3) {
                var flexArgs = this.stack.splice(this.stack.length - 17, 17);
                this.stack.push(
                  flexArgs[2] + flexArgs[0], // bcp1x + rpx
                  flexArgs[3] + flexArgs[1], // bcp1y + rpy
                  flexArgs[4], // bcp2x
                  flexArgs[5], // bcp2y
                  flexArgs[6], // p2x
                  flexArgs[7], // p2y
                  flexArgs[8], // bcp3x
                  flexArgs[9], // bcp3y
                  flexArgs[10], // bcp4x
                  flexArgs[11], // bcp4y
                  flexArgs[12], // p3x
                  flexArgs[13], // p3y
                  flexArgs[14] // flexDepth
                  // 15 = finalx unused by flex
                  // 16 = finaly unused by flex
                );
                error = this.executeCommand(13, COMMAND_MAP.flex, true);
                this.flexing = false;
                this.stack.push(flexArgs[15], flexArgs[16]);
              } else if (subrNumber === 1 && numArgs === 0) {
                this.flexing = true;
              }
              break;
            case (12 << 8) + 17: // pop
              // Ignore this since it is only used with othersubr.
              break;
            case (12 << 8) + 33: // setcurrentpoint
              // Ignore for now.
              this.stack = [];
              break;
            default:
              warn('Unknown type 1 charstring command of "' + value + '"');
              break;
          }
          if (error) {
            break;
          }
          continue;
        } else if (value <= 246) {
          value = value - 139;
        } else if (value <= 250) {
          value = ((value - 247) * 256) + encoded[++i] + 108;
        } else if (value <= 254) {
          value = -((value - 251) * 256) - encoded[++i] - 108;
        } else {
          value = (encoded[++i] & 0xff) << 24 | (encoded[++i] & 0xff) << 16 |
                  (encoded[++i] & 0xff) << 8 | (encoded[++i] & 0xff) << 0;
        }
        this.stack.push(value);
      }
      return error;
    },

    executeCommand: function(howManyArgs, command, keepStack) {
      var stackLength = this.stack.length;
      if (howManyArgs > stackLength) {
        return true;
      }
      var start = stackLength - howManyArgs;
      for (var i = start; i < stackLength; i++) {
        var value = this.stack[i];
        if (value === (value | 0)) { // int
          this.output.push(28, (value >> 8) & 0xff, value & 0xff);
        } else { // fixed point
          value = (65536 * value) | 0;
          this.output.push(255,
                           (value >> 24) & 0xFF,
                           (value >> 16) & 0xFF,
                           (value >> 8) & 0xFF,
                           value & 0xFF);
        }
      }
      this.output.push.apply(this.output, command);
      if (keepStack) {
        this.stack.splice(start, howManyArgs);
      } else {
        this.stack.length = 0;
      }
      return false;
    }
  };

  return Type1CharString;
})();

/*
 * Type1Parser encapsulate the needed code for parsing a Type1 font
 * program. Some of its logic depends on the Type2 charstrings
 * structure.
 * Note: this doesn't really parse the font since that would require evaluation
 * of PostScript, but it is possible in most cases to extract what we need
 * without a full parse.
 */
var Type1Parser = (function Type1ParserClosure() {
  /*
   * Decrypt a Sequence of Ciphertext Bytes to Produce the Original Sequence
   * of Plaintext Bytes. The function took a key as a parameter which can be
   * for decrypting the eexec block of for decoding charStrings.
   */
  var EEXEC_ENCRYPT_KEY = 55665;
  var CHAR_STRS_ENCRYPT_KEY = 4330;

  function isHexDigit(code) {
    return code >= 48 && code <= 57 || // '0'-'9'
           code >= 65 && code <= 70 || // 'A'-'F'
           code >= 97 && code <= 102;  // 'a'-'f'
  }

  function decrypt(data, key, discardNumber) {
    if (discardNumber >= data.length) {
      return new Uint8Array(0);
    }
    var r = key | 0, c1 = 52845, c2 = 22719, i, j;
    for (i = 0; i < discardNumber; i++) {
      r = ((data[i] + r) * c1 + c2) & ((1 << 16) - 1);
    }
    var count = data.length - discardNumber;
    var decrypted = new Uint8Array(count);
    for (i = discardNumber, j = 0; j < count; i++, j++) {
      var value = data[i];
      decrypted[j] = value ^ (r >> 8);
      r = ((value + r) * c1 + c2) & ((1 << 16) - 1);
    }
    return decrypted;
  }

  function decryptAscii(data, key, discardNumber) {
    var r = key | 0, c1 = 52845, c2 = 22719;
    var count = data.length, maybeLength = count >>> 1;
    var decrypted = new Uint8Array(maybeLength);
    var i, j;
    for (i = 0, j = 0; i < count; i++) {
      var digit1 = data[i];
      if (!isHexDigit(digit1)) {
        continue;
      }
      i++;
      var digit2;
      while (i < count && !isHexDigit(digit2 = data[i])) {
        i++;
      }
      if (i < count) {
        var value = parseInt(String.fromCharCode(digit1, digit2), 16);
        decrypted[j++] = value ^ (r >> 8);
        r = ((value + r) * c1 + c2) & ((1 << 16) - 1);
      }
    }
    return Array.prototype.slice.call(decrypted, discardNumber, j);
  }

  function isSpecial(c) {
    return c === 0x2F || // '/'
           c === 0x5B || c === 0x5D || // '[', ']'
           c === 0x7B || c === 0x7D || // '{', '}'
           c === 0x28 || c === 0x29; // '(', ')'
  }

  function Type1Parser(stream, encrypted, seacAnalysisEnabled) {
    if (encrypted) {
      var data = stream.getBytes();
      var isBinary = !(isHexDigit(data[0]) && isHexDigit(data[1]) &&
                       isHexDigit(data[2]) && isHexDigit(data[3]));
      stream = new Stream(isBinary ? decrypt(data, EEXEC_ENCRYPT_KEY, 4) :
                          decryptAscii(data, EEXEC_ENCRYPT_KEY, 4));
    }
    this.seacAnalysisEnabled = !!seacAnalysisEnabled;

    this.stream = stream;
    this.nextChar();
  }

  Type1Parser.prototype = {
    readNumberArray: function Type1Parser_readNumberArray() {
      this.getToken(); // read '[' or '{' (arrays can start with either)
      var array = [];
      while (true) {
        var token = this.getToken();
        if (token === null || token === ']' || token === '}') {
          break;
        }
        array.push(parseFloat(token || 0));
      }
      return array;
    },

    readNumber: function Type1Parser_readNumber() {
      var token = this.getToken();
      return parseFloat(token || 0);
    },

    readInt: function Type1Parser_readInt() {
      // Use '| 0' to prevent setting a double into length such as the double
      // does not flow into the loop variable.
      var token = this.getToken();
      return parseInt(token || 0, 10) | 0;
    },

    readBoolean: function Type1Parser_readBoolean() {
      var token = this.getToken();

      // Use 1 and 0 since that's what type2 charstrings use.
      return token === 'true' ? 1 : 0;
    },

    nextChar : function Type1_nextChar() {
      return (this.currentChar = this.stream.getByte());
    },

    getToken: function Type1Parser_getToken() {
      // Eat whitespace and comments.
      var comment = false;
      var ch = this.currentChar;
      while (true) {
        if (ch === -1) {
          return null;
        }

        if (comment) {
          if (ch === 0x0A || ch === 0x0D) {
            comment = false;
          }
        } else if (ch === 0x25) { // '%'
          comment = true;
        } else if (!isSpace(ch)) {
          break;
        }
        ch = this.nextChar();
      }
      if (isSpecial(ch)) {
        this.nextChar();
        return String.fromCharCode(ch);
      }
      var token = '';
      do {
        token += String.fromCharCode(ch);
        ch = this.nextChar();
      } while (ch >= 0 && !isSpace(ch) && !isSpecial(ch));
      return token;
    },

    /*
     * Returns an object containing a Subrs array and a CharStrings
     * array extracted from and eexec encrypted block of data
     */
    extractFontProgram: function Type1Parser_extractFontProgram() {
      var stream = this.stream;

      var subrs = [], charstrings = [];
      var privateData = Object.create(null);
      privateData['lenIV'] = 4;
      var program = {
        subrs: [],
        charstrings: [],
        properties: {
          'privateData': privateData
        }
      };
      var token, length, data, lenIV, encoded;
      while ((token = this.getToken()) !== null) {
        if (token !== '/') {
          continue;
        }
        token = this.getToken();
        switch (token) {
          case 'CharStrings':
            // The number immediately following CharStrings must be greater or
            // equal to the number of CharStrings.
            this.getToken();
            this.getToken(); // read in 'dict'
            this.getToken(); // read in 'dup'
            this.getToken(); // read in 'begin'
            while(true) {
              token = this.getToken();
              if (token === null || token === 'end') {
                break;
              }

              if (token !== '/') {
                continue;
              }
              var glyph = this.getToken();
              length = this.readInt();
              this.getToken(); // read in 'RD' or '-|'
              data = stream.makeSubStream(stream.pos, length);
              lenIV = program.properties.privateData['lenIV'];
              encoded = decrypt(data.getBytes(), CHAR_STRS_ENCRYPT_KEY, lenIV);
              // Skip past the required space and binary data.
              stream.skip(length);
              this.nextChar();
              token = this.getToken(); // read in 'ND' or '|-'
              if (token === 'noaccess') {
                this.getToken(); // read in 'def'
              }
              charstrings.push({
                glyph: glyph,
                encoded: encoded
              });
            }
            break;
          case 'Subrs':
            var num = this.readInt();
            this.getToken(); // read in 'array'
            while ((token = this.getToken()) === 'dup') {
              var index = this.readInt();
              length = this.readInt();
              this.getToken(); // read in 'RD' or '-|'
              data = stream.makeSubStream(stream.pos, length);
              lenIV = program.properties.privateData['lenIV'];
              encoded = decrypt(data.getBytes(), CHAR_STRS_ENCRYPT_KEY, lenIV);
              // Skip past the required space and binary data.
              stream.skip(length);
              this.nextChar();
              token = this.getToken(); // read in 'NP' or '|'
              if (token === 'noaccess') {
                this.getToken(); // read in 'put'
              }
              subrs[index] = encoded;
            }
            break;
          case 'BlueValues':
          case 'OtherBlues':
          case 'FamilyBlues':
          case 'FamilyOtherBlues':
            var blueArray = this.readNumberArray();
            // *Blue* values may contain invalid data: disables reading of
            // those values when hinting is disabled.
            if (blueArray.length > 0 && (blueArray.length % 2) === 0 &&
                HINTING_ENABLED) {
              program.properties.privateData[token] = blueArray;
            }
            break;
          case 'StemSnapH':
          case 'StemSnapV':
            program.properties.privateData[token] = this.readNumberArray();
            break;
          case 'StdHW':
          case 'StdVW':
            program.properties.privateData[token] =
              this.readNumberArray()[0];
            break;
          case 'BlueShift':
          case 'lenIV':
          case 'BlueFuzz':
          case 'BlueScale':
          case 'LanguageGroup':
          case 'ExpansionFactor':
            program.properties.privateData[token] = this.readNumber();
            break;
          case 'ForceBold':
            program.properties.privateData[token] = this.readBoolean();
            break;
        }
      }

      for (var i = 0; i < charstrings.length; i++) {
        glyph = charstrings[i].glyph;
        encoded = charstrings[i].encoded;
        var charString = new Type1CharString();
        var error = charString.convert(encoded, subrs,
                                       this.seacAnalysisEnabled);
        var output = charString.output;
        if (error) {
          // It seems when FreeType encounters an error while evaluating a glyph
          // that it completely ignores the glyph so we'll mimic that behaviour
          // here and put an endchar to make the validator happy.
          output = [14];
        }
        program.charstrings.push({
          glyphName: glyph,
          charstring: output,
          width: charString.width,
          lsb: charString.lsb,
          seac: charString.seac
        });
      }

      return program;
    },

    extractFontHeader: function Type1Parser_extractFontHeader(properties) {
      var token;
      while ((token = this.getToken()) !== null) {
        if (token !== '/') {
          continue;
        }
        token = this.getToken();
        switch (token) {
          case 'FontMatrix':
            var matrix = this.readNumberArray();
            properties.fontMatrix = matrix;
            break;
          case 'Encoding':
            var encodingArg = this.getToken();
            var encoding;
            if (!/^\d+$/.test(encodingArg)) {
              // encoding name is specified
              encoding = getEncoding(encodingArg);
            } else {
              encoding = [];
              var size = parseInt(encodingArg, 10) | 0;
              this.getToken(); // read in 'array'

              for (var j = 0; j < size; j++) {
                token = this.getToken();
                // skipping till first dup or def (e.g. ignoring for statement)
                while (token !== 'dup' && token !== 'def') {
                  token = this.getToken();
                  if (token === null) {
                    return; // invalid header
                  }
                }
                if (token === 'def') {
                  break; // read all array data
                }
                var index = this.readInt();
                this.getToken(); // read in '/'
                var glyph = this.getToken();
                encoding[index] = glyph;
                this.getToken(); // read the in 'put'
              }
            }
            properties.builtInEncoding = encoding;
            break;
          case 'FontBBox':
            var fontBBox = this.readNumberArray();
            // adjusting ascent/descent
            properties.ascent = fontBBox[3];
            properties.descent = fontBBox[1];
            properties.ascentScaled = true;
            break;
        }
      }
    }
  };

  return Type1Parser;
})();

exports.Type1Parser = Type1Parser;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreCMap = {}), root.pdfjsSharedUtil,
      root.pdfjsCorePrimitives, root.pdfjsCoreStream, root.pdfjsCoreParser);
  }
}(this, function (exports, sharedUtil, corePrimitives, coreStream, coreParser) {

var Util = sharedUtil.Util;
var assert = sharedUtil.assert;
var warn = sharedUtil.warn;
var error = sharedUtil.error;
var isInt = sharedUtil.isInt;
var isString = sharedUtil.isString;
var MissingDataException = sharedUtil.MissingDataException;
var isName = corePrimitives.isName;
var isCmd = corePrimitives.isCmd;
var isStream = corePrimitives.isStream;
var StringStream = coreStream.StringStream;
var Lexer = coreParser.Lexer;
var isEOF = coreParser.isEOF;

var BUILT_IN_CMAPS = [
// << Start unicode maps.
'Adobe-GB1-UCS2',
'Adobe-CNS1-UCS2',
'Adobe-Japan1-UCS2',
'Adobe-Korea1-UCS2',
// >> End unicode maps.
'78-EUC-H',
'78-EUC-V',
'78-H',
'78-RKSJ-H',
'78-RKSJ-V',
'78-V',
'78ms-RKSJ-H',
'78ms-RKSJ-V',
'83pv-RKSJ-H',
'90ms-RKSJ-H',
'90ms-RKSJ-V',
'90msp-RKSJ-H',
'90msp-RKSJ-V',
'90pv-RKSJ-H',
'90pv-RKSJ-V',
'Add-H',
'Add-RKSJ-H',
'Add-RKSJ-V',
'Add-V',
'Adobe-CNS1-0',
'Adobe-CNS1-1',
'Adobe-CNS1-2',
'Adobe-CNS1-3',
'Adobe-CNS1-4',
'Adobe-CNS1-5',
'Adobe-CNS1-6',
'Adobe-GB1-0',
'Adobe-GB1-1',
'Adobe-GB1-2',
'Adobe-GB1-3',
'Adobe-GB1-4',
'Adobe-GB1-5',
'Adobe-Japan1-0',
'Adobe-Japan1-1',
'Adobe-Japan1-2',
'Adobe-Japan1-3',
'Adobe-Japan1-4',
'Adobe-Japan1-5',
'Adobe-Japan1-6',
'Adobe-Korea1-0',
'Adobe-Korea1-1',
'Adobe-Korea1-2',
'B5-H',
'B5-V',
'B5pc-H',
'B5pc-V',
'CNS-EUC-H',
'CNS-EUC-V',
'CNS1-H',
'CNS1-V',
'CNS2-H',
'CNS2-V',
'ETHK-B5-H',
'ETHK-B5-V',
'ETen-B5-H',
'ETen-B5-V',
'ETenms-B5-H',
'ETenms-B5-V',
'EUC-H',
'EUC-V',
'Ext-H',
'Ext-RKSJ-H',
'Ext-RKSJ-V',
'Ext-V',
'GB-EUC-H',
'GB-EUC-V',
'GB-H',
'GB-V',
'GBK-EUC-H',
'GBK-EUC-V',
'GBK2K-H',
'GBK2K-V',
'GBKp-EUC-H',
'GBKp-EUC-V',
'GBT-EUC-H',
'GBT-EUC-V',
'GBT-H',
'GBT-V',
'GBTpc-EUC-H',
'GBTpc-EUC-V',
'GBpc-EUC-H',
'GBpc-EUC-V',
'H',
'HKdla-B5-H',
'HKdla-B5-V',
'HKdlb-B5-H',
'HKdlb-B5-V',
'HKgccs-B5-H',
'HKgccs-B5-V',
'HKm314-B5-H',
'HKm314-B5-V',
'HKm471-B5-H',
'HKm471-B5-V',
'HKscs-B5-H',
'HKscs-B5-V',
'Hankaku',
'Hiragana',
'KSC-EUC-H',
'KSC-EUC-V',
'KSC-H',
'KSC-Johab-H',
'KSC-Johab-V',
'KSC-V',
'KSCms-UHC-H',
'KSCms-UHC-HW-H',
'KSCms-UHC-HW-V',
'KSCms-UHC-V',
'KSCpc-EUC-H',
'KSCpc-EUC-V',
'Katakana',
'NWP-H',
'NWP-V',
'RKSJ-H',
'RKSJ-V',
'Roman',
'UniCNS-UCS2-H',
'UniCNS-UCS2-V',
'UniCNS-UTF16-H',
'UniCNS-UTF16-V',
'UniCNS-UTF32-H',
'UniCNS-UTF32-V',
'UniCNS-UTF8-H',
'UniCNS-UTF8-V',
'UniGB-UCS2-H',
'UniGB-UCS2-V',
'UniGB-UTF16-H',
'UniGB-UTF16-V',
'UniGB-UTF32-H',
'UniGB-UTF32-V',
'UniGB-UTF8-H',
'UniGB-UTF8-V',
'UniJIS-UCS2-H',
'UniJIS-UCS2-HW-H',
'UniJIS-UCS2-HW-V',
'UniJIS-UCS2-V',
'UniJIS-UTF16-H',
'UniJIS-UTF16-V',
'UniJIS-UTF32-H',
'UniJIS-UTF32-V',
'UniJIS-UTF8-H',
'UniJIS-UTF8-V',
'UniJIS2004-UTF16-H',
'UniJIS2004-UTF16-V',
'UniJIS2004-UTF32-H',
'UniJIS2004-UTF32-V',
'UniJIS2004-UTF8-H',
'UniJIS2004-UTF8-V',
'UniJISPro-UCS2-HW-V',
'UniJISPro-UCS2-V',
'UniJISPro-UTF8-V',
'UniJISX0213-UTF32-H',
'UniJISX0213-UTF32-V',
'UniJISX02132004-UTF32-H',
'UniJISX02132004-UTF32-V',
'UniKS-UCS2-H',
'UniKS-UCS2-V',
'UniKS-UTF16-H',
'UniKS-UTF16-V',
'UniKS-UTF32-H',
'UniKS-UTF32-V',
'UniKS-UTF8-H',
'UniKS-UTF8-V',
'V',
'WP-Symbol'];

// CMap, not to be confused with TrueType's cmap.
var CMap = (function CMapClosure() {
  function CMap(builtInCMap) {
    // Codespace ranges are stored as follows:
    // [[1BytePairs], [2BytePairs], [3BytePairs], [4BytePairs]]
    // where nBytePairs are ranges e.g. [low1, high1, low2, high2, ...]
    this.codespaceRanges = [[], [], [], []];
    this.numCodespaceRanges = 0;
    // Map entries have one of two forms.
    // - cid chars are 16-bit unsigned integers, stored as integers.
    // - bf chars are variable-length byte sequences, stored as strings, with
    //   one byte per character.
    this._map = [];
    this.name = '';
    this.vertical = false;
    this.useCMap = null;
    this.builtInCMap = builtInCMap;
  }
  CMap.prototype = {
    addCodespaceRange: function(n, low, high) {
      this.codespaceRanges[n - 1].push(low, high);
      this.numCodespaceRanges++;
    },

    mapCidRange: function(low, high, dstLow) {
      while (low <= high) {
        this._map[low++] = dstLow++;
      }
    },

    mapBfRange: function(low, high, dstLow) {
      var lastByte = dstLow.length - 1;
      while (low <= high) {
        this._map[low++] = dstLow;
        // Only the last byte has to be incremented.
        dstLow = dstLow.substr(0, lastByte) +
                 String.fromCharCode(dstLow.charCodeAt(lastByte) + 1);
      }
    },

    mapBfRangeToArray: function(low, high, array) {
      var i = 0, ii = array.length;
      while (low <= high && i < ii) {
        this._map[low] = array[i++];
        ++low;
      }
    },

    // This is used for both bf and cid chars.
    mapOne: function(src, dst) {
      this._map[src] = dst;
    },

    lookup: function(code) {
      return this._map[code];
    },

    contains: function(code) {
      return this._map[code] !== undefined;
    },

    forEach: function(callback) {
      // Most maps have fewer than 65536 entries, and for those we use normal
      // array iteration. But really sparse tables are possible -- e.g. with
      // indices in the *billions*. For such tables we use for..in, which isn't
      // ideal because it stringifies the indices for all present elements, but
      // it does avoid iterating over every undefined entry.
      var map = this._map;
      var length = map.length;
      var i;
      if (length <= 0x10000) {
        for (i = 0; i < length; i++) {
          if (map[i] !== undefined) {
            callback(i, map[i]);
          }
        }
      } else {
        for (i in this._map) {
          callback(i, map[i]);
        }
      }
    },

    charCodeOf: function(value) {
      return this._map.indexOf(value);
    },

    getMap: function() {
      return this._map;
    },

    readCharCode: function(str, offset, out) {
      var c = 0;
      var codespaceRanges = this.codespaceRanges;
      var codespaceRangesLen = this.codespaceRanges.length;
      // 9.7.6.2 CMap Mapping
      // The code length is at most 4.
      for (var n = 0; n < codespaceRangesLen; n++) {
        c = ((c << 8) | str.charCodeAt(offset + n)) >>> 0;
        // Check each codespace range to see if it falls within.
        var codespaceRange = codespaceRanges[n];
        for (var k = 0, kk = codespaceRange.length; k < kk;) {
          var low = codespaceRange[k++];
          var high = codespaceRange[k++];
          if (c >= low && c <= high) {
            out.charcode = c;
            out.length = n + 1;
            return;
          }
        }
      }
      out.charcode = 0;
      out.length = 1;
    },

    get length() {
      return this._map.length;
    },

    get isIdentityCMap() {
      if (!(this.name === 'Identity-H' || this.name === 'Identity-V')) {
        return false;
      }
      if (this._map.length !== 0x10000) {
        return false;
      }
      for (var i = 0; i < 0x10000; i++) {
        if (this._map[i] !== i) {
          return false;
        }
      }
      return true;
    }
  };
  return CMap;
})();

// A special case of CMap, where the _map array implicitly has a length of
// 65536 and each element is equal to its index.
var IdentityCMap = (function IdentityCMapClosure() {
  function IdentityCMap(vertical, n) {
    CMap.call(this);
    this.vertical = vertical;
    this.addCodespaceRange(n, 0, 0xffff);
  }
  Util.inherit(IdentityCMap, CMap, {});

  IdentityCMap.prototype = {
    addCodespaceRange: CMap.prototype.addCodespaceRange,

    mapCidRange: function(low, high, dstLow) {
      error('should not call mapCidRange');
    },

    mapBfRange: function(low, high, dstLow) {
      error('should not call mapBfRange');
    },

    mapBfRangeToArray: function(low, high, array) {
      error('should not call mapBfRangeToArray');
    },

    mapOne: function(src, dst) {
      error('should not call mapCidOne');
    },

    lookup: function(code) {
      return (isInt(code) && code <= 0xffff) ? code : undefined;
    },

    contains: function(code) {
      return isInt(code) && code <= 0xffff;
    },

    forEach: function(callback) {
      for (var i = 0; i <= 0xffff; i++) {
        callback(i, i);
      }
    },

    charCodeOf: function(value) {
      return (isInt(value) && value <= 0xffff) ? value : -1;
    },

    getMap: function() {
      // Sometimes identity maps must be instantiated, but it's rare.
      var map = new Array(0x10000);
      for (var i = 0; i <= 0xffff; i++) {
        map[i] = i;
      }
      return map;
    },

    readCharCode: CMap.prototype.readCharCode,

    get length() {
      return 0x10000;
    },

    get isIdentityCMap() {
      error('should not access .isIdentityCMap');
    }
  };

  return IdentityCMap;
})();

var BinaryCMapReader = (function BinaryCMapReaderClosure() {
  function fetchBinaryData(url) {
    return new Promise(function (resolve, reject) {
      var request = new XMLHttpRequest();
      request.open('GET', url, true);
      request.responseType = 'arraybuffer';
      request.onreadystatechange = function () {
        if (request.readyState === XMLHttpRequest.DONE) {
          if (!request.response || request.status !== 200 &&
              request.status !== 0) {
            reject(new Error('Unable to get binary cMap at: ' + url));
          } else {
            resolve(new Uint8Array(request.response));
          }
        }
      };
      request.send(null);
    });
  }

  function hexToInt(a, size) {
    var n = 0;
    for (var i = 0; i <= size; i++) {
      n = (n << 8) | a[i];
    }
    return n >>> 0;
  }

  function hexToStr(a, size) {
    // This code is hot. Special-case some common values to avoid creating an
    // object with subarray().
    if (size === 1) {
      return String.fromCharCode(a[0], a[1]);
    }
    if (size === 3) {
      return String.fromCharCode(a[0], a[1], a[2], a[3]);
    }
    return String.fromCharCode.apply(null, a.subarray(0, size + 1));
  }

  function addHex(a, b, size) {
    var c = 0;
    for (var i = size; i >= 0; i--) {
      c += a[i] + b[i];
      a[i] = c & 255;
      c >>= 8;
    }
  }

  function incHex(a, size) {
    var c = 1;
    for (var i = size; i >= 0 && c > 0; i--) {
      c += a[i];
      a[i] = c & 255;
      c >>= 8;
    }
  }

  var MAX_NUM_SIZE = 16;
  var MAX_ENCODED_NUM_SIZE = 19; // ceil(MAX_NUM_SIZE * 7 / 8)

  function BinaryCMapStream(data) {
    this.buffer = data;
    this.pos = 0;
    this.end = data.length;
    this.tmpBuf = new Uint8Array(MAX_ENCODED_NUM_SIZE);
  }

  BinaryCMapStream.prototype = {
    readByte: function () {
      if (this.pos >= this.end) {
        return -1;
      }
      return this.buffer[this.pos++];
    },
    readNumber: function () {
      var n = 0;
      var last;
      do {
        var b = this.readByte();
        if (b < 0) {
          error('unexpected EOF in bcmap');
        }
        last = !(b & 0x80);
        n = (n << 7) | (b & 0x7F);
      } while (!last);
      return n;
    },
    readSigned: function () {
      var n = this.readNumber();
      return (n & 1) ? ~(n >>> 1) : n >>> 1;
    },
    readHex: function (num, size) {
      num.set(this.buffer.subarray(this.pos,
        this.pos + size + 1));
      this.pos += size + 1;
    },
    readHexNumber: function (num, size) {
      var last;
      var stack = this.tmpBuf, sp = 0;
      do {
        var b = this.readByte();
        if (b < 0) {
          error('unexpected EOF in bcmap');
        }
        last = !(b & 0x80);
        stack[sp++] = b & 0x7F;
      } while (!last);
      var i = size, buffer = 0, bufferSize = 0;
      while (i >= 0) {
        while (bufferSize < 8 && stack.length > 0) {
          buffer = (stack[--sp] << bufferSize) | buffer;
          bufferSize += 7;
        }
        num[i] = buffer & 255;
        i--;
        buffer >>= 8;
        bufferSize -= 8;
      }
    },
    readHexSigned: function (num, size) {
      this.readHexNumber(num, size);
      var sign = num[size] & 1 ? 255 : 0;
      var c = 0;
      for (var i = 0; i <= size; i++) {
        c = ((c & 1) << 8) | num[i];
        num[i] = (c >> 1) ^ sign;
      }
    },
    readString: function () {
      var len = this.readNumber();
      var s = '';
      for (var i = 0; i < len; i++) {
        s += String.fromCharCode(this.readNumber());
      }
      return s;
    }
  };

  function processBinaryCMap(url, cMap, extend) {
    return fetchBinaryData(url).then(function (data) {
      var stream = new BinaryCMapStream(data);
      var header = stream.readByte();
      cMap.vertical = !!(header & 1);

      var useCMap = null;
      var start = new Uint8Array(MAX_NUM_SIZE);
      var end = new Uint8Array(MAX_NUM_SIZE);
      var char = new Uint8Array(MAX_NUM_SIZE);
      var charCode = new Uint8Array(MAX_NUM_SIZE);
      var tmp = new Uint8Array(MAX_NUM_SIZE);
      var code;

      var b;
      while ((b = stream.readByte()) >= 0) {
        var type = b >> 5;
        if (type === 7) { // metadata, e.g. comment or usecmap
          switch (b & 0x1F) {
            case 0:
              stream.readString(); // skipping comment
              break;
            case 1:
              useCMap = stream.readString();
              break;
          }
          continue;
        }
        var sequence = !!(b & 0x10);
        var dataSize = b & 15;

        assert(dataSize + 1 <= MAX_NUM_SIZE);

        var ucs2DataSize = 1;
        var subitemsCount = stream.readNumber();
        var i;
        switch (type) {
          case 0: // codespacerange
            stream.readHex(start, dataSize);
            stream.readHexNumber(end, dataSize);
            addHex(end, start, dataSize);
            cMap.addCodespaceRange(dataSize + 1, hexToInt(start, dataSize),
                                   hexToInt(end, dataSize));
            for (i = 1; i < subitemsCount; i++) {
              incHex(end, dataSize);
              stream.readHexNumber(start, dataSize);
              addHex(start, end, dataSize);
              stream.readHexNumber(end, dataSize);
              addHex(end, start, dataSize);
              cMap.addCodespaceRange(dataSize + 1, hexToInt(start, dataSize),
                                     hexToInt(end, dataSize));
            }
            break;
          case 1: // notdefrange
            stream.readHex(start, dataSize);
            stream.readHexNumber(end, dataSize);
            addHex(end, start, dataSize);
            code = stream.readNumber();
            // undefined range, skipping
            for (i = 1; i < subitemsCount; i++) {
              incHex(end, dataSize);
              stream.readHexNumber(start, dataSize);
              addHex(start, end, dataSize);
              stream.readHexNumber(end, dataSize);
              addHex(end, start, dataSize);
              code = stream.readNumber();
              // nop
            }
            break;
          case 2: // cidchar
            stream.readHex(char, dataSize);
            code = stream.readNumber();
            cMap.mapOne(hexToInt(char, dataSize), code);
            for (i = 1; i < subitemsCount; i++) {
              incHex(char, dataSize);
              if (!sequence) {
                stream.readHexNumber(tmp, dataSize);
                addHex(char, tmp, dataSize);
              }
              code = stream.readSigned() + (code + 1);
              cMap.mapOne(hexToInt(char, dataSize), code);
            }
            break;
          case 3: // cidrange
            stream.readHex(start, dataSize);
            stream.readHexNumber(end, dataSize);
            addHex(end, start, dataSize);
            code = stream.readNumber();
            cMap.mapCidRange(hexToInt(start, dataSize), hexToInt(end, dataSize),
                             code);
            for (i = 1; i < subitemsCount; i++) {
              incHex(end, dataSize);
              if (!sequence) {
                stream.readHexNumber(start, dataSize);
                addHex(start, end, dataSize);
              } else {
                start.set(end);
              }
              stream.readHexNumber(end, dataSize);
              addHex(end, start, dataSize);
              code = stream.readNumber();
              cMap.mapCidRange(hexToInt(start, dataSize),
                               hexToInt(end, dataSize), code);
            }
            break;
          case 4: // bfchar
            stream.readHex(char, ucs2DataSize);
            stream.readHex(charCode, dataSize);
            cMap.mapOne(hexToInt(char, ucs2DataSize),
                        hexToStr(charCode, dataSize));
            for (i = 1; i < subitemsCount; i++) {
              incHex(char, ucs2DataSize);
              if (!sequence) {
                stream.readHexNumber(tmp, ucs2DataSize);
                addHex(char, tmp, ucs2DataSize);
              }
              incHex(charCode, dataSize);
              stream.readHexSigned(tmp, dataSize);
              addHex(charCode, tmp, dataSize);
              cMap.mapOne(hexToInt(char, ucs2DataSize),
                          hexToStr(charCode, dataSize));
            }
            break;
          case 5: // bfrange
            stream.readHex(start, ucs2DataSize);
            stream.readHexNumber(end, ucs2DataSize);
            addHex(end, start, ucs2DataSize);
            stream.readHex(charCode, dataSize);
            cMap.mapBfRange(hexToInt(start, ucs2DataSize),
                            hexToInt(end, ucs2DataSize),
                            hexToStr(charCode, dataSize));
            for (i = 1; i < subitemsCount; i++) {
              incHex(end, ucs2DataSize);
              if (!sequence) {
                stream.readHexNumber(start, ucs2DataSize);
                addHex(start, end, ucs2DataSize);
              } else {
                start.set(end);
              }
              stream.readHexNumber(end, ucs2DataSize);
              addHex(end, start, ucs2DataSize);
              stream.readHex(charCode, dataSize);
              cMap.mapBfRange(hexToInt(start, ucs2DataSize),
                              hexToInt(end, ucs2DataSize),
                              hexToStr(charCode, dataSize));
            }
            break;
          default:
            error('Unknown type: ' + type);
            break;
        }
      }

      if (useCMap) {
        return extend(useCMap);
      }
      return cMap;
    });
  }

  function BinaryCMapReader() {}

  BinaryCMapReader.prototype = {
    read: processBinaryCMap
  };

  return BinaryCMapReader;
})();

var CMapFactory = (function CMapFactoryClosure() {
  function strToInt(str) {
    var a = 0;
    for (var i = 0; i < str.length; i++) {
      a = (a << 8) | str.charCodeAt(i);
    }
    return a >>> 0;
  }

  function expectString(obj) {
    if (!isString(obj)) {
      error('Malformed CMap: expected string.');
    }
  }

  function expectInt(obj) {
    if (!isInt(obj)) {
      error('Malformed CMap: expected int.');
    }
  }

  function parseBfChar(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();
      if (isEOF(obj)) {
        break;
      }
      if (isCmd(obj, 'endbfchar')) {
        return;
      }
      expectString(obj);
      var src = strToInt(obj);
      obj = lexer.getObj();
      // TODO are /dstName used?
      expectString(obj);
      var dst = obj;
      cMap.mapOne(src, dst);
    }
  }

  function parseBfRange(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();
      if (isEOF(obj)) {
        break;
      }
      if (isCmd(obj, 'endbfrange')) {
        return;
      }
      expectString(obj);
      var low = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      var high = strToInt(obj);
      obj = lexer.getObj();
      if (isInt(obj) || isString(obj)) {
        var dstLow = isInt(obj) ? String.fromCharCode(obj) : obj;
        cMap.mapBfRange(low, high, dstLow);
      } else if (isCmd(obj, '[')) {
        obj = lexer.getObj();
        var array = [];
        while (!isCmd(obj, ']') && !isEOF(obj)) {
          array.push(obj);
          obj = lexer.getObj();
        }
        cMap.mapBfRangeToArray(low, high, array);
      } else {
        break;
      }
    }
    error('Invalid bf range.');
  }

  function parseCidChar(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();
      if (isEOF(obj)) {
        break;
      }
      if (isCmd(obj, 'endcidchar')) {
        return;
      }
      expectString(obj);
      var src = strToInt(obj);
      obj = lexer.getObj();
      expectInt(obj);
      var dst = obj;
      cMap.mapOne(src, dst);
    }
  }

  function parseCidRange(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();
      if (isEOF(obj)) {
        break;
      }
      if (isCmd(obj, 'endcidrange')) {
        return;
      }
      expectString(obj);
      var low = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      var high = strToInt(obj);
      obj = lexer.getObj();
      expectInt(obj);
      var dstLow = obj;
      cMap.mapCidRange(low, high, dstLow);
    }
  }

  function parseCodespaceRange(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();
      if (isEOF(obj)) {
        break;
      }
      if (isCmd(obj, 'endcodespacerange')) {
        return;
      }
      if (!isString(obj)) {
        break;
      }
      var low = strToInt(obj);
      obj = lexer.getObj();
      if (!isString(obj)) {
        break;
      }
      var high = strToInt(obj);
      cMap.addCodespaceRange(obj.length, low, high);
    }
    error('Invalid codespace range.');
  }

  function parseWMode(cMap, lexer) {
    var obj = lexer.getObj();
    if (isInt(obj)) {
      cMap.vertical = !!obj;
    }
  }

  function parseCMapName(cMap, lexer) {
    var obj = lexer.getObj();
    if (isName(obj) && isString(obj.name)) {
      cMap.name = obj.name;
    }
  }

  function parseCMap(cMap, lexer, builtInCMapParams, useCMap) {
    var previous;
    var embededUseCMap;
    objLoop: while (true) {
      try {
        var obj = lexer.getObj();
        if (isEOF(obj)) {
          break;
        } else if (isName(obj)) {
          if (obj.name === 'WMode') {
            parseWMode(cMap, lexer);
          } else if (obj.name === 'CMapName') {
            parseCMapName(cMap, lexer);
          }
          previous = obj;
        } else if (isCmd(obj)) {
          switch (obj.cmd) {
            case 'endcmap':
              break objLoop;
            case 'usecmap':
              if (isName(previous)) {
                embededUseCMap = previous.name;
              }
              break;
            case 'begincodespacerange':
              parseCodespaceRange(cMap, lexer);
              break;
            case 'beginbfchar':
              parseBfChar(cMap, lexer);
              break;
            case 'begincidchar':
              parseCidChar(cMap, lexer);
              break;
            case 'beginbfrange':
              parseBfRange(cMap, lexer);
              break;
            case 'begincidrange':
              parseCidRange(cMap, lexer);
              break;
          }
        }
      } catch (ex) {
        if (ex instanceof MissingDataException) {
          throw ex;
        }
        warn('Invalid cMap data: ' + ex);
        continue;
      }
    }

    if (!useCMap && embededUseCMap) {
      // Load the usecmap definition from the file only if there wasn't one
      // specified.
      useCMap = embededUseCMap;
    }
    if (useCMap) {
      return extendCMap(cMap, builtInCMapParams, useCMap);
    }
    return Promise.resolve(cMap);
  }

  function extendCMap(cMap, builtInCMapParams, useCMap) {
    return createBuiltInCMap(useCMap, builtInCMapParams).then(
        function(newCMap) {
      cMap.useCMap = newCMap;
      // If there aren't any code space ranges defined clone all the parent ones
      // into this cMap.
      if (cMap.numCodespaceRanges === 0) {
        var useCodespaceRanges = cMap.useCMap.codespaceRanges;
        for (var i = 0; i < useCodespaceRanges.length; i++) {
          cMap.codespaceRanges[i] = useCodespaceRanges[i].slice();
        }
        cMap.numCodespaceRanges = cMap.useCMap.numCodespaceRanges;
      }
      // Merge the map into the current one, making sure not to override
      // any previously defined entries.
      cMap.useCMap.forEach(function(key, value) {
        if (!cMap.contains(key)) {
          cMap.mapOne(key, cMap.useCMap.lookup(key));
        }
      });

      return cMap;
    });
  }

  function parseBinaryCMap(name, builtInCMapParams) {
    var url = builtInCMapParams.url + name + '.bcmap';
    var cMap = new CMap(true);
    return new BinaryCMapReader().read(url, cMap, function (useCMap) {
      return extendCMap(cMap, builtInCMapParams, useCMap);
    });
  }

  function createBuiltInCMap(name, builtInCMapParams) {
    if (name === 'Identity-H') {
      return Promise.resolve(new IdentityCMap(false, 2));
    } else if (name === 'Identity-V') {
      return Promise.resolve(new IdentityCMap(true, 2));
    }
    if (BUILT_IN_CMAPS.indexOf(name) === -1) {
      return Promise.reject(new Error('Unknown cMap name: ' + name));
    }
    assert(builtInCMapParams, 'built-in cMap parameters are not provided');

    if (builtInCMapParams.packed) {
      return parseBinaryCMap(name, builtInCMapParams);
    }

    return new Promise(function (resolve, reject) {
      var url = builtInCMapParams.url + name;
      var request = new XMLHttpRequest();
      request.onreadystatechange = function () {
        if (request.readyState === XMLHttpRequest.DONE) {
          if (request.status === 200 || request.status === 0) {
            var cMap = new CMap(true);
            var lexer = new Lexer(new StringStream(request.responseText));
            parseCMap(cMap, lexer, builtInCMapParams, null).then(
                function (parsedCMap) {
              resolve(parsedCMap);
            });
          } else {
            reject(new Error('Unable to get cMap at: ' + url));
          }
        }
      };
      request.open('GET', url, true);
      request.send(null);
    });
  }

  return {
    create: function (encoding, builtInCMapParams, useCMap) {
      if (isName(encoding)) {
        return createBuiltInCMap(encoding.name, builtInCMapParams);
      } else if (isStream(encoding)) {
        var cMap = new CMap();
        var lexer = new Lexer(encoding);
        return parseCMap(cMap, lexer, builtInCMapParams, useCMap).then(
            function (parsedCMap) {
          if (parsedCMap.isIdentityCMap) {
            return createBuiltInCMap(parsedCMap.name, builtInCMapParams);
          }
          return parsedCMap;
        });
      }
      return Promise.reject(new Error('Encoding required.'));
    }
  };
})();

exports.CMap = CMap;
exports.CMapFactory = CMapFactory;
exports.IdentityCMap = IdentityCMap;
}));


(function (root, factory) {
  {
    factory((root.pdfjsCoreFonts = {}), root.pdfjsSharedUtil,
      root.pdfjsCorePrimitives, root.pdfjsCoreStream, root.pdfjsCoreGlyphList,
      root.pdfjsCoreFontRenderer, root.pdfjsCoreEncodings,
      root.pdfjsCoreStandardFonts, root.pdfjsCoreUnicode,
      root.pdfjsCoreType1Parser, root.pdfjsCoreCFFParser);
  }
}(this, function (exports, sharedUtil, corePrimitives, coreStream,
                  coreGlyphList, coreFontRenderer, coreEncodings,
                  coreStandardFonts, coreUnicode, coreType1Parser,
                  coreCFFParser) {

var FONT_IDENTITY_MATRIX = sharedUtil.FONT_IDENTITY_MATRIX;
var FontType = sharedUtil.FontType;
var assert = sharedUtil.assert;
var bytesToString = sharedUtil.bytesToString;
var error = sharedUtil.error;
var info = sharedUtil.info;
var isArray = sharedUtil.isArray;
var isInt = sharedUtil.isInt;
var isNum = sharedUtil.isNum;
var readUint32 = sharedUtil.readUint32;
var shadow = sharedUtil.shadow;
var string32 = sharedUtil.string32;
var warn = sharedUtil.warn;
var MissingDataException = sharedUtil.MissingDataException;
var isSpace = sharedUtil.isSpace;
var Stream = coreStream.Stream;
var getGlyphsUnicode = coreGlyphList.getGlyphsUnicode;
var getDingbatsGlyphsUnicode = coreGlyphList.getDingbatsGlyphsUnicode;
var FontRendererFactory = coreFontRenderer.FontRendererFactory;
var StandardEncoding = coreEncodings.StandardEncoding;
var MacRomanEncoding = coreEncodings.MacRomanEncoding;
var SymbolSetEncoding = coreEncodings.SymbolSetEncoding;
var ZapfDingbatsEncoding = coreEncodings.ZapfDingbatsEncoding;
var getEncoding = coreEncodings.getEncoding;
var getStdFontMap = coreStandardFonts.getStdFontMap;
var getNonStdFontMap = coreStandardFonts.getNonStdFontMap;
var getGlyphMapForStandardFonts = coreStandardFonts.getGlyphMapForStandardFonts;
var getSupplementalGlyphMapForArialBlack =
  coreStandardFonts.getSupplementalGlyphMapForArialBlack;
var getUnicodeRangeFor = coreUnicode.getUnicodeRangeFor;
var mapSpecialUnicodeValues = coreUnicode.mapSpecialUnicodeValues;
var getUnicodeForGlyph = coreUnicode.getUnicodeForGlyph;
var Type1Parser = coreType1Parser.Type1Parser;
var CFFStandardStrings = coreCFFParser.CFFStandardStrings;
var CFFParser = coreCFFParser.CFFParser;
var CFFCompiler = coreCFFParser.CFFCompiler;
var CFF = coreCFFParser.CFF;
var CFFHeader = coreCFFParser.CFFHeader;
var CFFTopDict = coreCFFParser.CFFTopDict;
var CFFPrivateDict = coreCFFParser.CFFPrivateDict;
var CFFStrings = coreCFFParser.CFFStrings;
var CFFIndex = coreCFFParser.CFFIndex;
var CFFCharset = coreCFFParser.CFFCharset;

// Unicode Private Use Area
var PRIVATE_USE_OFFSET_START = 0xE000;
var PRIVATE_USE_OFFSET_END = 0xF8FF;
var SKIP_PRIVATE_USE_RANGE_F000_TO_F01F = false;

// PDF Glyph Space Units are one Thousandth of a TextSpace Unit
// except for Type 3 fonts
var PDF_GLYPH_SPACE_UNITS = 1000;

// Accented charactars are not displayed properly on Windows, using this flag
// to control analysis of seac charstrings.
var SEAC_ANALYSIS_ENABLED = false;

var FontFlags = {
  FixedPitch: 1,
  Serif: 2,
  Symbolic: 4,
  Script: 8,
  Nonsymbolic: 32,
  Italic: 64,
  AllCap: 65536,
  SmallCap: 131072,
  ForceBold: 262144
};

var MacStandardGlyphOrdering = [
  '.notdef', '.null', 'nonmarkingreturn', 'space', 'exclam', 'quotedbl',
  'numbersign', 'dollar', 'percent', 'ampersand', 'quotesingle', 'parenleft',
  'parenright', 'asterisk', 'plus', 'comma', 'hyphen', 'period', 'slash',
  'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight',
  'nine', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at',
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
  'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft',
  'backslash', 'bracketright', 'asciicircum', 'underscore', 'grave', 'a', 'b',
  'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q',
  'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright',
  'asciitilde', 'Adieresis', 'Aring', 'Ccedilla', 'Eacute', 'Ntilde',
  'Odieresis', 'Udieresis', 'aacute', 'agrave', 'acircumflex', 'adieresis',
  'atilde', 'aring', 'ccedilla', 'eacute', 'egrave', 'ecircumflex', 'edieresis',
  'iacute', 'igrave', 'icircumflex', 'idieresis', 'ntilde', 'oacute', 'ograve',
  'ocircumflex', 'odieresis', 'otilde', 'uacute', 'ugrave', 'ucircumflex',
  'udieresis', 'dagger', 'degree', 'cent', 'sterling', 'section', 'bullet',
  'paragraph', 'germandbls', 'registered', 'copyright', 'trademark', 'acute',
  'dieresis', 'notequal', 'AE', 'Oslash', 'infinity', 'plusminus', 'lessequal',
  'greaterequal', 'yen', 'mu', 'partialdiff', 'summation', 'product', 'pi',
  'integral', 'ordfeminine', 'ordmasculine', 'Omega', 'ae', 'oslash',
  'questiondown', 'exclamdown', 'logicalnot', 'radical', 'florin',
  'approxequal', 'Delta', 'guillemotleft', 'guillemotright', 'ellipsis',
  'nonbreakingspace', 'Agrave', 'Atilde', 'Otilde', 'OE', 'oe', 'endash',
  'emdash', 'quotedblleft', 'quotedblright', 'quoteleft', 'quoteright',
  'divide', 'lozenge', 'ydieresis', 'Ydieresis', 'fraction', 'currency',
  'guilsinglleft', 'guilsinglright', 'fi', 'fl', 'daggerdbl', 'periodcentered',
  'quotesinglbase', 'quotedblbase', 'perthousand', 'Acircumflex',
  'Ecircumflex', 'Aacute', 'Edieresis', 'Egrave', 'Iacute', 'Icircumflex',
  'Idieresis', 'Igrave', 'Oacute', 'Ocircumflex', 'apple', 'Ograve', 'Uacute',
  'Ucircumflex', 'Ugrave', 'dotlessi', 'circumflex', 'tilde', 'macron',
  'breve', 'dotaccent', 'ring', 'cedilla', 'hungarumlaut', 'ogonek', 'caron',
  'Lslash', 'lslash', 'Scaron', 'scaron', 'Zcaron', 'zcaron', 'brokenbar',
  'Eth', 'eth', 'Yacute', 'yacute', 'Thorn', 'thorn', 'minus', 'multiply',
  'onesuperior', 'twosuperior', 'threesuperior', 'onehalf', 'onequarter',
  'threequarters', 'franc', 'Gbreve', 'gbreve', 'Idotaccent', 'Scedilla',
  'scedilla', 'Cacute', 'cacute', 'Ccaron', 'ccaron', 'dcroat'];

function adjustWidths(properties) {
  if (!properties.fontMatrix) {
    return;
  }
  if (properties.fontMatrix[0] === FONT_IDENTITY_MATRIX[0]) {
    return;
  }
  // adjusting width to fontMatrix scale
  var scale = 0.001 / properties.fontMatrix[0];
  var glyphsWidths = properties.widths;
  for (var glyph in glyphsWidths) {
    glyphsWidths[glyph] *= scale;
  }
  properties.defaultWidth *= scale;
}

function getFontType(type, subtype) {
  switch (type) {
    case 'Type1':
      return subtype === 'Type1C' ? FontType.TYPE1C : FontType.TYPE1;
    case 'CIDFontType0':
      return subtype === 'CIDFontType0C' ? FontType.CIDFONTTYPE0C :
        FontType.CIDFONTTYPE0;
    case 'OpenType':
      return FontType.OPENTYPE;
    case 'TrueType':
      return FontType.TRUETYPE;
    case 'CIDFontType2':
      return FontType.CIDFONTTYPE2;
    case 'MMType1':
      return FontType.MMTYPE1;
    case 'Type0':
      return FontType.TYPE0;
    default:
      return FontType.UNKNOWN;
  }
}

// Some bad PDF generators, e.g. Scribus PDF, include glyph names
// in a 'uniXXXX' format -- attempting to recover proper ones.
function recoverGlyphName(name, glyphsUnicodeMap) {
  if (glyphsUnicodeMap[name] !== undefined) {
    return name;
  }
  // The glyph name is non-standard, trying to recover.
  var unicode = getUnicodeForGlyph(name, glyphsUnicodeMap);
  if (unicode !== -1) {
    for (var key in glyphsUnicodeMap) {
      if (glyphsUnicodeMap[key] === unicode) {
        return key;
      }
    }
  }
  info('Unable to recover a standard glyph name for: ' + name);
  return name;
}

var Glyph = (function GlyphClosure() {
  function Glyph(fontChar, unicode, accent, width, vmetric, operatorListId,
                 isSpace, isInFont) {
    this.fontChar = fontChar;
    this.unicode = unicode;
    this.accent = accent;
    this.width = width;
    this.vmetric = vmetric;
    this.operatorListId = operatorListId;
    this.isSpace = isSpace;
    this.isInFont = isInFont;
  }

  Glyph.prototype.matchesForCache = function(fontChar, unicode, accent, width,
                                             vmetric, operatorListId, isSpace,
                                             isInFont) {
    return this.fontChar === fontChar &&
           this.unicode === unicode &&
           this.accent === accent &&
           this.width === width &&
           this.vmetric === vmetric &&
           this.operatorListId === operatorListId &&
           this.isSpace === isSpace &&
           this.isInFont === isInFont;
  };

  return Glyph;
})();

var ToUnicodeMap = (function ToUnicodeMapClosure() {
  function ToUnicodeMap(cmap) {
    // The elements of this._map can be integers or strings, depending on how
    // |cmap| was created.
    this._map = cmap;
  }

  ToUnicodeMap.prototype = {
    get length() {
      return this._map.length;
    },

    forEach: function(callback) {
      for (var charCode in this._map) {
        callback(charCode, this._map[charCode].charCodeAt(0));
      }
    },

    has: function(i) {
      return this._map[i] !== undefined;
    },

    get: function(i) {
      return this._map[i];
    },

    charCodeOf: function(v) {
      return this._map.indexOf(v);
    }
  };

  return ToUnicodeMap;
})();

var IdentityToUnicodeMap = (function IdentityToUnicodeMapClosure() {
  function IdentityToUnicodeMap(firstChar, lastChar) {
    this.firstChar = firstChar;
    this.lastChar = lastChar;
  }

  IdentityToUnicodeMap.prototype = {
    get length() {
      return (this.lastChar + 1) - this.firstChar;
    },

    forEach: function (callback) {
      for (var i = this.firstChar, ii = this.lastChar; i <= ii; i++) {
        callback(i, i);
      }
    },

    has: function (i) {
      return this.firstChar <= i && i <= this.lastChar;
    },

    get: function (i) {
      if (this.firstChar <= i && i <= this.lastChar) {
        return String.fromCharCode(i);
      }
      return undefined;
    },

    charCodeOf: function (v) {
      return (isInt(v) && v >= this.firstChar && v <= this.lastChar) ? v : -1;
    }
  };

  return IdentityToUnicodeMap;
})();

var OpenTypeFileBuilder = (function OpenTypeFileBuilderClosure() {
  function writeInt16(dest, offset, num) {
    dest[offset] = (num >> 8) & 0xFF;
    dest[offset + 1] = num & 0xFF;
  }

  function writeInt32(dest, offset, num) {
    dest[offset] = (num >> 24) & 0xFF;
    dest[offset + 1] = (num >> 16) & 0xFF;
    dest[offset + 2] = (num >> 8) & 0xFF;
    dest[offset + 3] = num & 0xFF;
  }

  function writeData(dest, offset, data) {
    var i, ii;
    if (data instanceof Uint8Array) {
      dest.set(data, offset);
    } else if (typeof data === 'string') {
      for (i = 0, ii = data.length; i < ii; i++) {
        dest[offset++] = data.charCodeAt(i) & 0xFF;
      }
    } else {
      // treating everything else as array
      for (i = 0, ii = data.length; i < ii; i++) {
        dest[offset++] = data[i] & 0xFF;
      }
    }
  }

  function OpenTypeFileBuilder(sfnt) {
    this.sfnt = sfnt;
    this.tables = Object.create(null);
  }

  OpenTypeFileBuilder.getSearchParams =
      function OpenTypeFileBuilder_getSearchParams(entriesCount, entrySize) {
    var maxPower2 = 1, log2 = 0;
    while ((maxPower2 ^ entriesCount) > maxPower2) {
      maxPower2 <<= 1;
      log2++;
    }
    var searchRange = maxPower2 * entrySize;
    return {
      range: searchRange,
      entry: log2,
      rangeShift: entrySize * entriesCount - searchRange
    };
  };

  var OTF_HEADER_SIZE = 12;
  var OTF_TABLE_ENTRY_SIZE = 16;

  OpenTypeFileBuilder.prototype = {
    toArray: function OpenTypeFileBuilder_toArray() {
      var sfnt = this.sfnt;

      // Tables needs to be written by ascendant alphabetic order
      var tables = this.tables;
      var tablesNames = Object.keys(tables);
      tablesNames.sort();
      var numTables = tablesNames.length;

      var i, j, jj, table, tableName;
      // layout the tables data
      var offset = OTF_HEADER_SIZE + numTables * OTF_TABLE_ENTRY_SIZE;
      var tableOffsets = [offset];
      for (i = 0; i < numTables; i++) {
        table = tables[tablesNames[i]];
        var paddedLength = ((table.length + 3) & ~3) >>> 0;
        offset += paddedLength;
        tableOffsets.push(offset);
      }

      var file = new Uint8Array(offset);
      // write the table data first (mostly for checksum)
      for (i = 0; i < numTables; i++) {
        table = tables[tablesNames[i]];
        writeData(file, tableOffsets[i], table);
      }

      // sfnt version (4 bytes)
      if (sfnt === 'true') {
        // Windows hates the Mac TrueType sfnt version number
        sfnt = string32(0x00010000);
      }
      file[0] = sfnt.charCodeAt(0) & 0xFF;
      file[1] = sfnt.charCodeAt(1) & 0xFF;
      file[2] = sfnt.charCodeAt(2) & 0xFF;
      file[3] = sfnt.charCodeAt(3) & 0xFF;

      // numTables (2 bytes)
      writeInt16(file, 4, numTables);

      var searchParams = OpenTypeFileBuilder.getSearchParams(numTables, 16);

      // searchRange (2 bytes)
      writeInt16(file, 6, searchParams.range);
      // entrySelector (2 bytes)
      writeInt16(file, 8, searchParams.entry);
      // rangeShift (2 bytes)
      writeInt16(file, 10, searchParams.rangeShift);

      offset = OTF_HEADER_SIZE;
      // writing table entries
      for (i = 0; i < numTables; i++) {
        tableName = tablesNames[i];
        file[offset] = tableName.charCodeAt(0) & 0xFF;
        file[offset + 1] = tableName.charCodeAt(1) & 0xFF;
        file[offset + 2] = tableName.charCodeAt(2) & 0xFF;
        file[offset + 3] = tableName.charCodeAt(3) & 0xFF;

        // checksum
        var checksum = 0;
        for (j = tableOffsets[i], jj = tableOffsets[i + 1]; j < jj; j += 4) {
          var quad = readUint32(file, j);
          checksum = (checksum + quad) >>> 0;
        }
        writeInt32(file, offset + 4, checksum);

        // offset
        writeInt32(file, offset + 8, tableOffsets[i]);
        // length
        writeInt32(file, offset + 12, tables[tableName].length);

        offset += OTF_TABLE_ENTRY_SIZE;
      }
      return file;
    },

    addTable: function OpenTypeFileBuilder_addTable(tag, data) {
      if (tag in this.tables) {
        throw new Error('Table ' + tag + ' already exists');
      }
      this.tables[tag] = data;
    }
  };

  return OpenTypeFileBuilder;
})();

// Problematic Unicode characters in the fonts that needs to be moved to avoid
// issues when they are painted on the canvas, e.g. complex-script shaping or
// control/whitespace characters. The ranges are listed in pairs: the first item
// is a code of the first problematic code, the second one is the next
// non-problematic code. The ranges must be in sorted order.
var ProblematicCharRanges = new Int32Array([
  // Control characters.
  0x0000, 0x0020,
  0x007F, 0x00A1,
  0x00AD, 0x00AE,
  // Chars that is used in complex-script shaping.
  0x0600, 0x0780,
  0x08A0, 0x10A0,
  0x1780, 0x1800,
  0x1C00, 0x1C50,
  // General punctuation chars.
  0x2000, 0x2010,
  0x2011, 0x2012,
  0x2028, 0x2030,
  0x205F, 0x2070,
  0x25CC, 0x25CD,
  0x3000, 0x3001,
  // Chars that is used in complex-script shaping.
  0xAA60, 0xAA80,
  // Specials Unicode block.
  0xFFF0, 0x10000
]);


/**
 * 'Font' is the class the outside world should use, it encapsulate all the font
 * decoding logics whatever type it is (assuming the font type is supported).
 *
 * For example to read a Type1 font and to attach it to the document:
 *   var type1Font = new Font("MyFontName", binaryFile, propertiesObject);
 *   type1Font.bind();
 */
var Font = (function FontClosure() {
  function Font(name, file, properties) {
    var charCode, glyphName, unicode;

    this.name = name;
    this.loadedName = properties.loadedName;
    this.isType3Font = properties.isType3Font;
    this.sizes = [];
    this.missingFile = false;

    this.glyphCache = Object.create(null);

    var names = name.split('+');
    names = names.length > 1 ? names[1] : names[0];
    names = names.split(/[-,_]/g)[0];
    this.isSerifFont = !!(properties.flags & FontFlags.Serif);
    this.isSymbolicFont = !!(properties.flags & FontFlags.Symbolic);
    this.isMonospace = !!(properties.flags & FontFlags.FixedPitch);

    var type = properties.type;
    var subtype = properties.subtype;
    this.type = type;

    this.fallbackName = (this.isMonospace ? 'monospace' :
                         (this.isSerifFont ? 'serif' : 'sans-serif'));

    this.differences = properties.differences;
    this.widths = properties.widths;
    this.defaultWidth = properties.defaultWidth;
    this.composite = properties.composite;
    this.wideChars = properties.wideChars;
    this.cMap = properties.cMap;
    this.ascent = properties.ascent / PDF_GLYPH_SPACE_UNITS;
    this.descent = properties.descent / PDF_GLYPH_SPACE_UNITS;
    this.fontMatrix = properties.fontMatrix;
    this.bbox = properties.bbox;

    this.toUnicode = properties.toUnicode;

    this.toFontChar = [];

    if (properties.type === 'Type3') {
      for (charCode = 0; charCode < 256; charCode++) {
        this.toFontChar[charCode] = (this.differences[charCode] ||
                                     properties.defaultEncoding[charCode]);
      }
      this.fontType = FontType.TYPE3;
      return;
    }

    this.cidEncoding = properties.cidEncoding;
    this.vertical = properties.vertical;
    if (this.vertical) {
      this.vmetrics = properties.vmetrics;
      this.defaultVMetrics = properties.defaultVMetrics;
    }
    var glyphsUnicodeMap;
    if (!file || file.isEmpty) {
      if (file) {
        // Some bad PDF generators will include empty font files,
        // attempting to recover by assuming that no file exists.
        warn('Font file is empty in "' + name + '" (' + this.loadedName + ')');
      }

      this.missingFile = true;
      // The file data is not specified. Trying to fix the font name
      // to be used with the canvas.font.
      var fontName = name.replace(/[,_]/g, '-');
      var stdFontMap = getStdFontMap(), nonStdFontMap = getNonStdFontMap();
      var isStandardFont = !!stdFontMap[fontName] ||
        !!(nonStdFontMap[fontName] && stdFontMap[nonStdFontMap[fontName]]);
      fontName = stdFontMap[fontName] || nonStdFontMap[fontName] || fontName;

      this.bold = (fontName.search(/bold/gi) !== -1);
      this.italic = ((fontName.search(/oblique/gi) !== -1) ||
                     (fontName.search(/italic/gi) !== -1));

      // Use 'name' instead of 'fontName' here because the original
      // name ArialBlack for example will be replaced by Helvetica.
      this.black = (name.search(/Black/g) !== -1);

      // if at least one width is present, remeasure all chars when exists
      this.remeasure = Object.keys(this.widths).length > 0;
      if (isStandardFont && type === 'CIDFontType2' &&
          properties.cidEncoding.indexOf('Identity-') === 0) {
        var GlyphMapForStandardFonts = getGlyphMapForStandardFonts();
        // Standard fonts might be embedded as CID font without glyph mapping.
        // Building one based on GlyphMapForStandardFonts.
        var map = [];
        for (charCode in GlyphMapForStandardFonts) {
          map[+charCode] = GlyphMapForStandardFonts[charCode];
        }
        if (/ArialBlack/i.test(name)) {
          var SupplementalGlyphMapForArialBlack =
            getSupplementalGlyphMapForArialBlack();
          for (charCode in SupplementalGlyphMapForArialBlack) {
            map[+charCode] = SupplementalGlyphMapForArialBlack[charCode];
          }
        }
        var isIdentityUnicode = this.toUnicode instanceof IdentityToUnicodeMap;
        if (!isIdentityUnicode) {
          this.toUnicode.forEach(function(charCode, unicodeCharCode) {
            map[+charCode] = unicodeCharCode;
          });
        }
        this.toFontChar = map;
        this.toUnicode = new ToUnicodeMap(map);
      } else if (/Symbol/i.test(fontName)) {
        this.toFontChar = buildToFontChar(SymbolSetEncoding, getGlyphsUnicode(),
                                          properties.differences);
      } else if (/Dingbats/i.test(fontName)) {
        if (/Wingdings/i.test(name)) {
          warn('Non-embedded Wingdings font, falling back to ZapfDingbats.');
        }
        this.toFontChar = buildToFontChar(ZapfDingbatsEncoding,
                                          getDingbatsGlyphsUnicode(),
                                          properties.differences);
      } else if (isStandardFont) {
        this.toFontChar = buildToFontChar(properties.defaultEncoding,
                                          getGlyphsUnicode(),
                                          properties.differences);
      } else {
        glyphsUnicodeMap = getGlyphsUnicode();
        this.toUnicode.forEach(function(charCode, unicodeCharCode) {
          if (!this.composite) {
            glyphName = (properties.differences[charCode] ||
                         properties.defaultEncoding[charCode]);
            unicode = getUnicodeForGlyph(glyphName, glyphsUnicodeMap);
            if (unicode !== -1) {
              unicodeCharCode = unicode;
            }
          }
          this.toFontChar[charCode] = unicodeCharCode;
        }.bind(this));
      }
      this.loadedName = fontName.split('-')[0];
      this.loading = false;
      this.fontType = getFontType(type, subtype);
      return;
    }

    // Some fonts might use wrong font types for Type1C or CIDFontType0C
    if (subtype === 'Type1C' && (type !== 'Type1' && type !== 'MMType1')) {
      // Some TrueType fonts by mistake claim Type1C
      if (isTrueTypeFile(file)) {
        subtype = 'TrueType';
      } else {
        type = 'Type1';
      }
    }
    if (subtype === 'CIDFontType0C' && type !== 'CIDFontType0') {
      type = 'CIDFontType0';
    }
    if (subtype === 'OpenType') {
      type = 'OpenType';
    }
    // Some CIDFontType0C fonts by mistake claim CIDFontType0.
    if (type === 'CIDFontType0') {
      if (isType1File(file)) {
        subtype = 'CIDFontType0';
      } else if (isOpenTypeFile(file)) {
        // Sometimes the type/subtype can be a complete lie (see issue6782.pdf).
        type = subtype = 'OpenType';
      } else {
        subtype = 'CIDFontType0C';
      }
    }

    var data;
    switch (type) {
      case 'MMType1':
        info('MMType1 font (' + name + '), falling back to Type1.');
        /* falls through */
      case 'Type1':
      case 'CIDFontType0':
        this.mimetype = 'font/opentype';

        var cff = (subtype === 'Type1C' || subtype === 'CIDFontType0C') ?
          new CFFFont(file, properties) : new Type1Font(name, file, properties);

        adjustWidths(properties);

        // Wrap the CFF data inside an OTF font file
        data = this.convert(name, cff, properties);
        break;

      case 'OpenType':
      case 'TrueType':
      case 'CIDFontType2':
        this.mimetype = 'font/opentype';

        // Repair the TrueType file. It is can be damaged in the point of
        // view of the sanitizer
        data = this.checkAndRepair(name, file, properties);
        if (this.isOpenType) {
          adjustWidths(properties);

          type = 'OpenType';
        }
        break;

      default:
        error('Font ' + type + ' is not supported');
        break;
    }

    this.data = data;
    this.fontType = getFontType(type, subtype);

    // Transfer some properties again that could change during font conversion
    this.fontMatrix = properties.fontMatrix;
    this.widths = properties.widths;
    this.defaultWidth = properties.defaultWidth;
    this.encoding = properties.baseEncoding;
    this.seacMap = properties.seacMap;

    this.loading = true;
  }

  Font.getFontID = (function () {
    var ID = 1;
    return function Font_getFontID() {
      return String(ID++);
    };
  })();

  function int16(b0, b1) {
    return (b0 << 8) + b1;
  }

  function signedInt16(b0, b1) {
    var value = (b0 << 8) + b1;
    return value & (1 << 15) ? value - 0x10000 : value;
  }

  function int32(b0, b1, b2, b3) {
    return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
  }

  function string16(value) {
    return String.fromCharCode((value >> 8) & 0xff, value & 0xff);
  }

  function safeString16(value) {
    // clamp value to the 16-bit int range
    value = (value > 0x7FFF ? 0x7FFF : (value < -0x8000 ? -0x8000 : value));
    return String.fromCharCode((value >> 8) & 0xff, value & 0xff);
  }

  function isTrueTypeFile(file) {
    var header = file.peekBytes(4);
    return readUint32(header, 0) === 0x00010000;
  }

  function isOpenTypeFile(file) {
    var header = file.peekBytes(4);
    return bytesToString(header) === 'OTTO';
  }

  function isType1File(file) {
    var header = file.peekBytes(2);
    // All Type1 font programs must begin with the comment '%!' (0x25 + 0x21).
    if (header[0] === 0x25 && header[1] === 0x21) {
      return true;
    }
    // ... obviously some fonts violate that part of the specification,
    // please refer to the comment in |Type1Font| below.
    if (header[0] === 0x80 && header[1] === 0x01) { // pfb file header.
      return true;
    }
    return false;
  }

  function buildToFontChar(encoding, glyphsUnicodeMap, differences) {
    var toFontChar = [], unicode;
    for (var i = 0, ii = encoding.length; i < ii; i++) {
      unicode = getUnicodeForGlyph(encoding[i], glyphsUnicodeMap);
      if (unicode !== -1) {
        toFontChar[i] = unicode;
      }
    }
    for (var charCode in differences) {
      unicode = getUnicodeForGlyph(differences[charCode], glyphsUnicodeMap);
      if (unicode !== -1) {
        toFontChar[+charCode] = unicode;
      }
    }
    return toFontChar;
  }

  /**
   * Helper function for |adjustMapping|.
   * @return {boolean}
   */
  function isProblematicUnicodeLocation(code) {
    // Using binary search to find a range start.
    var i = 0, j = ProblematicCharRanges.length - 1;
    while (i < j) {
      var c = (i + j + 1) >> 1;
      if (code < ProblematicCharRanges[c]) {
        j = c - 1;
      } else {
        i = c;
      }
    }
    // Even index means code in problematic range.
    return !(i & 1);
  }

  /**
   * Rebuilds the char code to glyph ID map by trying to replace the char codes
   * with their unicode value. It also moves char codes that are in known
   * problematic locations.
   * @return {Object} Two properties:
   * 'toFontChar' - maps original char codes(the value that will be read
   * from commands such as show text) to the char codes that will be used in the
   * font that we build
   * 'charCodeToGlyphId' - maps the new font char codes to glyph ids
   */
  function adjustMapping(charCodeToGlyphId, properties) {
    var toUnicode = properties.toUnicode;
    var isSymbolic = !!(properties.flags & FontFlags.Symbolic);
    var isIdentityUnicode =
      properties.toUnicode instanceof IdentityToUnicodeMap;
    var newMap = Object.create(null);
    var toFontChar = [];
    var usedFontCharCodes = [];
    var nextAvailableFontCharCode = PRIVATE_USE_OFFSET_START;
    for (var originalCharCode in charCodeToGlyphId) {
      originalCharCode |= 0;
      var glyphId = charCodeToGlyphId[originalCharCode];
      var fontCharCode = originalCharCode;
      // First try to map the value to a unicode position if a non identity map
      // was created.
      if (!isIdentityUnicode && toUnicode.has(originalCharCode)) {
        var unicode = toUnicode.get(fontCharCode);
        // TODO: Try to map ligatures to the correct spot.
        if (unicode.length === 1) {
          fontCharCode = unicode.charCodeAt(0);
        }
      }
      // Try to move control characters, special characters and already mapped
      // characters to the private use area since they will not be drawn by
      // canvas if left in their current position. Also, move characters if the
      // font was symbolic and there is only an identity unicode map since the
      // characters probably aren't in the correct position (fixes an issue
      // with firefox and thuluthfont).
      if ((usedFontCharCodes[fontCharCode] !== undefined ||
           isProblematicUnicodeLocation(fontCharCode) ||
           (isSymbolic && isIdentityUnicode)) &&
          nextAvailableFontCharCode <= PRIVATE_USE_OFFSET_END) { // Room left.
        // Loop to try and find a free spot in the private use area.
        do {
          fontCharCode = nextAvailableFontCharCode++;

          if (SKIP_PRIVATE_USE_RANGE_F000_TO_F01F && fontCharCode === 0xF000) {
            fontCharCode = 0xF020;
            nextAvailableFontCharCode = fontCharCode + 1;
          }

        } while (usedFontCharCodes[fontCharCode] !== undefined &&
                 nextAvailableFontCharCode <= PRIVATE_USE_OFFSET_END);
      }

      newMap[fontCharCode] = glyphId;
      toFontChar[originalCharCode] = fontCharCode;
      usedFontCharCodes[fontCharCode] = true;
    }
    return {
      toFontChar: toFontChar,
      charCodeToGlyphId: newMap,
      nextAvailableFontCharCode: nextAvailableFontCharCode
    };
  }

  function getRanges(glyphs, numGlyphs) {
    // Array.sort() sorts by characters, not numerically, so convert to an
    // array of characters.
    var codes = [];
    for (var charCode in glyphs) {
      // Remove an invalid glyph ID mappings to make OTS happy.
      if (glyphs[charCode] >= numGlyphs) {
        continue;
      }
      codes.push({ fontCharCode: charCode | 0, glyphId: glyphs[charCode] });
    }
    codes.sort(function fontGetRangesSort(a, b) {
      return a.fontCharCode - b.fontCharCode;
    });

    // Split the sorted codes into ranges.
    var ranges = [];
    var length = codes.length;
    for (var n = 0; n < length; ) {
      var start = codes[n].fontCharCode;
      var codeIndices = [codes[n].glyphId];
      ++n;
      var end = start;
      while (n < length && end + 1 === codes[n].fontCharCode) {
        codeIndices.push(codes[n].glyphId);
        ++end;
        ++n;
        if (end === 0xFFFF) {
          break;
        }
      }
      ranges.push([start, end, codeIndices]);
    }

    return ranges;
  }

  function createCmapTable(glyphs, numGlyphs) {
    var ranges = getRanges(glyphs, numGlyphs);
    var numTables = ranges[ranges.length - 1][1] > 0xFFFF ? 2 : 1;
    var cmap = '\x00\x00' + // version
               string16(numTables) +  // numTables
               '\x00\x03' + // platformID
               '\x00\x01' + // encodingID
               string32(4 + numTables * 8); // start of the table record

    var i, ii, j, jj;
    for (i = ranges.length - 1; i >= 0; --i) {
      if (ranges[i][0] <= 0xFFFF) { break; }
    }
    var bmpLength = i + 1;

    if (ranges[i][0] < 0xFFFF && ranges[i][1] === 0xFFFF) {
      ranges[i][1] = 0xFFFE;
    }
    var trailingRangesCount = ranges[i][1] < 0xFFFF ? 1 : 0;
    var segCount = bmpLength + trailingRangesCount;
    var searchParams = OpenTypeFileBuilder.getSearchParams(segCount, 2);

    // Fill up the 4 parallel arrays describing the segments.
    var startCount = '';
    var endCount = '';
    var idDeltas = '';
    var idRangeOffsets = '';
    var glyphsIds = '';
    var bias = 0;

    var range, start, end, codes;
    for (i = 0, ii = bmpLength; i < ii; i++) {
      range = ranges[i];
      start = range[0];
      end = range[1];
      startCount += string16(start);
      endCount += string16(end);
      codes = range[2];
      var contiguous = true;
      for (j = 1, jj = codes.length; j < jj; ++j) {
        if (codes[j] !== codes[j - 1] + 1) {
          contiguous = false;
          break;
        }
      }
      if (!contiguous) {
        var offset = (segCount - i) * 2 + bias * 2;
        bias += (end - start + 1);

        idDeltas += string16(0);
        idRangeOffsets += string16(offset);

        for (j = 0, jj = codes.length; j < jj; ++j) {
          glyphsIds += string16(codes[j]);
        }
      } else {
        var startCode = codes[0];

        idDeltas += string16((startCode - start) & 0xFFFF);
        idRangeOffsets += string16(0);
      }
    }

    if (trailingRangesCount > 0) {
      endCount += '\xFF\xFF';
      startCount += '\xFF\xFF';
      idDeltas += '\x00\x01';
      idRangeOffsets += '\x00\x00';
    }

    var format314 = '\x00\x00' + // language
                    string16(2 * segCount) +
                    string16(searchParams.range) +
                    string16(searchParams.entry) +
                    string16(searchParams.rangeShift) +
                    endCount + '\x00\x00' + startCount +
                    idDeltas + idRangeOffsets + glyphsIds;

    var format31012 = '';
    var header31012 = '';
    if (numTables > 1) {
      cmap += '\x00\x03' + // platformID
              '\x00\x0A' + // encodingID
              string32(4 + numTables * 8 +
                       4 + format314.length); // start of the table record
      format31012 = '';
      for (i = 0, ii = ranges.length; i < ii; i++) {
        range = ranges[i];
        start = range[0];
        codes = range[2];
        var code = codes[0];
        for (j = 1, jj = codes.length; j < jj; ++j) {
          if (codes[j] !== codes[j - 1] + 1) {
            end = range[0] + j - 1;
            format31012 += string32(start) + // startCharCode
                           string32(end) + // endCharCode
                           string32(code); // startGlyphID
            start = end + 1;
            code = codes[j];
          }
        }
        format31012 += string32(start) + // startCharCode
                       string32(range[1]) + // endCharCode
                       string32(code); // startGlyphID
      }
      header31012 = '\x00\x0C' + // format
                    '\x00\x00' + // reserved
                    string32(format31012.length + 16) + // length
                    '\x00\x00\x00\x00' + // language
                    string32(format31012.length / 12); // nGroups
    }

    return cmap + '\x00\x04' + // format
                  string16(format314.length + 4) + // length
                  format314 + header31012 + format31012;
  }

  function validateOS2Table(os2) {
    var stream = new Stream(os2.data);
    var version = stream.getUint16();
    // TODO verify all OS/2 tables fields, but currently we validate only those
    // that give us issues
    stream.getBytes(60); // skipping type, misc sizes, panose, unicode ranges
    var selection = stream.getUint16();
    if (version < 4 && (selection & 0x0300)) {
      return false;
    }
    var firstChar = stream.getUint16();
    var lastChar = stream.getUint16();
    if (firstChar > lastChar) {
      return false;
    }
    stream.getBytes(6); // skipping sTypoAscender/Descender/LineGap
    var usWinAscent = stream.getUint16();
    if (usWinAscent === 0) { // makes font unreadable by windows
      return false;
    }

    // OS/2 appears to be valid, resetting some fields
    os2.data[8] = os2.data[9] = 0; // IE rejects fonts if fsType != 0
    return true;
  }

  function createOS2Table(properties, charstrings, override) {
    override = override || {
      unitsPerEm: 0,
      yMax: 0,
      yMin: 0,
      ascent: 0,
      descent: 0
    };

    var ulUnicodeRange1 = 0;
    var ulUnicodeRange2 = 0;
    var ulUnicodeRange3 = 0;
    var ulUnicodeRange4 = 0;

    var firstCharIndex = null;
    var lastCharIndex = 0;

    if (charstrings) {
      for (var code in charstrings) {
        code |= 0;
        if (firstCharIndex > code || !firstCharIndex) {
          firstCharIndex = code;
        }
        if (lastCharIndex < code) {
          lastCharIndex = code;
        }

        var position = getUnicodeRangeFor(code);
        if (position < 32) {
          ulUnicodeRange1 |= 1 << position;
        } else if (position < 64) {
          ulUnicodeRange2 |= 1 << position - 32;
        } else if (position < 96) {
          ulUnicodeRange3 |= 1 << position - 64;
        } else if (position < 123) {
          ulUnicodeRange4 |= 1 << position - 96;
        } else {
          error('Unicode ranges Bits > 123 are reserved for internal usage');
        }
      }
    } else {
      // TODO
      firstCharIndex = 0;
      lastCharIndex = 255;
    }

    var bbox = properties.bbox || [0, 0, 0, 0];
    var unitsPerEm = (override.unitsPerEm ||
                      1 / (properties.fontMatrix || FONT_IDENTITY_MATRIX)[0]);

    // if the font units differ to the PDF glyph space units
    // then scale up the values
    var scale = (properties.ascentScaled ? 1.0 :
                 unitsPerEm / PDF_GLYPH_SPACE_UNITS);

    var typoAscent = (override.ascent ||
                      Math.round(scale * (properties.ascent || bbox[3])));
    var typoDescent = (override.descent ||
                       Math.round(scale * (properties.descent || bbox[1])));
    if (typoDescent > 0 && properties.descent > 0 && bbox[1] < 0) {
      typoDescent = -typoDescent; // fixing incorrect descent
    }
    var winAscent = override.yMax || typoAscent;
    var winDescent = -override.yMin || -typoDescent;

    return '\x00\x03' + // version
           '\x02\x24' + // xAvgCharWidth
           '\x01\xF4' + // usWeightClass
           '\x00\x05' + // usWidthClass
           '\x00\x00' + // fstype (0 to let the font loads via font-face on IE)
           '\x02\x8A' + // ySubscriptXSize
           '\x02\xBB' + // ySubscriptYSize
           '\x00\x00' + // ySubscriptXOffset
           '\x00\x8C' + // ySubscriptYOffset
           '\x02\x8A' + // ySuperScriptXSize
           '\x02\xBB' + // ySuperScriptYSize
           '\x00\x00' + // ySuperScriptXOffset
           '\x01\xDF' + // ySuperScriptYOffset
           '\x00\x31' + // yStrikeOutSize
           '\x01\x02' + // yStrikeOutPosition
           '\x00\x00' + // sFamilyClass
           '\x00\x00\x06' +
           String.fromCharCode(properties.fixedPitch ? 0x09 : 0x00) +
           '\x00\x00\x00\x00\x00\x00' + // Panose
           string32(ulUnicodeRange1) + // ulUnicodeRange1 (Bits 0-31)
           string32(ulUnicodeRange2) + // ulUnicodeRange2 (Bits 32-63)
           string32(ulUnicodeRange3) + // ulUnicodeRange3 (Bits 64-95)
           string32(ulUnicodeRange4) + // ulUnicodeRange4 (Bits 96-127)
           '\x2A\x32\x31\x2A' + // achVendID
           string16(properties.italicAngle ? 1 : 0) + // fsSelection
           string16(firstCharIndex ||
                    properties.firstChar) + // usFirstCharIndex
           string16(lastCharIndex || properties.lastChar) +  // usLastCharIndex
           string16(typoAscent) + // sTypoAscender
           string16(typoDescent) + // sTypoDescender
           '\x00\x64' + // sTypoLineGap (7%-10% of the unitsPerEM value)
           string16(winAscent) + // usWinAscent
           string16(winDescent) + // usWinDescent
           '\x00\x00\x00\x00' + // ulCodePageRange1 (Bits 0-31)
           '\x00\x00\x00\x00' + // ulCodePageRange2 (Bits 32-63)
           string16(properties.xHeight) + // sxHeight
           string16(properties.capHeight) + // sCapHeight
           string16(0) + // usDefaultChar
           string16(firstCharIndex || properties.firstChar) + // usBreakChar
           '\x00\x03';  // usMaxContext
  }

  function createPostTable(properties) {
    var angle = Math.floor(properties.italicAngle * (Math.pow(2, 16)));
    return ('\x00\x03\x00\x00' + // Version number
            string32(angle) + // italicAngle
            '\x00\x00' + // underlinePosition
            '\x00\x00' + // underlineThickness
            string32(properties.fixedPitch) + // isFixedPitch
            '\x00\x00\x00\x00' + // minMemType42
            '\x00\x00\x00\x00' + // maxMemType42
            '\x00\x00\x00\x00' + // minMemType1
            '\x00\x00\x00\x00');  // maxMemType1
  }

  function createNameTable(name, proto) {
    if (!proto) {
      proto = [[], []]; // no strings and unicode strings
    }

    var strings = [
      proto[0][0] || 'Original licence',  // 0.Copyright
      proto[0][1] || name,                // 1.Font family
      proto[0][2] || 'Unknown',           // 2.Font subfamily (font weight)
      proto[0][3] || 'uniqueID',          // 3.Unique ID
      proto[0][4] || name,                // 4.Full font name
      proto[0][5] || 'Version 0.11',      // 5.Version
      proto[0][6] || '',                  // 6.Postscript name
      proto[0][7] || 'Unknown',           // 7.Trademark
      proto[0][8] || 'Unknown',           // 8.Manufacturer
      proto[0][9] || 'Unknown'            // 9.Designer
    ];

    // Mac want 1-byte per character strings while Windows want
    // 2-bytes per character, so duplicate the names table
    var stringsUnicode = [];
    var i, ii, j, jj, str;
    for (i = 0, ii = strings.length; i < ii; i++) {
      str = proto[1][i] || strings[i];

      var strBufUnicode = [];
      for (j = 0, jj = str.length; j < jj; j++) {
        strBufUnicode.push(string16(str.charCodeAt(j)));
      }
      stringsUnicode.push(strBufUnicode.join(''));
    }

    var names = [strings, stringsUnicode];
    var platforms = ['\x00\x01', '\x00\x03'];
    var encodings = ['\x00\x00', '\x00\x01'];
    var languages = ['\x00\x00', '\x04\x09'];

    var namesRecordCount = strings.length * platforms.length;
    var nameTable =
      '\x00\x00' +                           // format
      string16(namesRecordCount) +           // Number of names Record
      string16(namesRecordCount * 12 + 6);   // Storage

    // Build the name records field
    var strOffset = 0;
    for (i = 0, ii = platforms.length; i < ii; i++) {
      var strs = names[i];
      for (j = 0, jj = strs.length; j < jj; j++) {
        str = strs[j];
        var nameRecord =
          platforms[i] + // platform ID
          encodings[i] + // encoding ID
          languages[i] + // language ID
          string16(j) + // name ID
          string16(str.length) +
          string16(strOffset);
        nameTable += nameRecord;
        strOffset += str.length;
      }
    }

    nameTable += strings.join('') + stringsUnicode.join('');
    return nameTable;
  }

  Font.prototype = {
    name: null,
    font: null,
    mimetype: null,
    encoding: null,
    get renderer() {
      var renderer = FontRendererFactory.create(this, SEAC_ANALYSIS_ENABLED);
      return shadow(this, 'renderer', renderer);
    },

    exportData: function Font_exportData() {
      // TODO remove enumerating of the properties, e.g. hardcode exact names.
      var data = {};
      for (var i in this) {
        if (this.hasOwnProperty(i)) {
          data[i] = this[i];
        }
      }
      return data;
    },

    checkAndRepair: function Font_checkAndRepair(name, font, properties) {
      function readTableEntry(file) {
        var tag = bytesToString(file.getBytes(4));

        var checksum = file.getInt32() >>> 0;
        var offset = file.getInt32() >>> 0;
        var length = file.getInt32() >>> 0;

        // Read the table associated data
        var previousPosition = file.pos;
        file.pos = file.start ? file.start : 0;
        file.skip(offset);
        var data = file.getBytes(length);
        file.pos = previousPosition;

        if (tag === 'head') {
          // clearing checksum adjustment
          data[8] = data[9] = data[10] = data[11] = 0;
          data[17] |= 0x20; //Set font optimized for cleartype flag
        }

        return {
          tag: tag,
          checksum: checksum,
          length: length,
          offset: offset,
          data: data
        };
      }

      function readOpenTypeHeader(ttf) {
        return {
          version: bytesToString(ttf.getBytes(4)),
          numTables: ttf.getUint16(),
          searchRange: ttf.getUint16(),
          entrySelector: ttf.getUint16(),
          rangeShift: ttf.getUint16()
        };
      }

      /**
       * Read the appropriate subtable from the cmap according to 9.6.6.4 from
       * PDF spec
       */
      function readCmapTable(cmap, font, isSymbolicFont, hasEncoding) {
        if (!cmap) {
          warn('No cmap table available.');
          return {
            platformId: -1,
            encodingId: -1,
            mappings: [],
            hasShortCmap: false
          };
        }
        var segment;
        var start = (font.start ? font.start : 0) + cmap.offset;
        font.pos = start;

        var version = font.getUint16();
        var numTables = font.getUint16();

        var potentialTable;
        var canBreak = false;
        // There's an order of preference in terms of which cmap subtable to
        // use:
        // - non-symbolic fonts the preference is a 3,1 table then a 1,0 table
        // - symbolic fonts the preference is a 3,0 table then a 1,0 table
        // The following takes advantage of the fact that the tables are sorted
        // to work.
        for (var i = 0; i < numTables; i++) {
          var platformId = font.getUint16();
          var encodingId = font.getUint16();
          var offset = font.getInt32() >>> 0;
          var useTable = false;

          if (platformId === 0 && encodingId === 0) {
            useTable = true;
            // Continue the loop since there still may be a higher priority
            // table.
          } else if (platformId === 1 && encodingId === 0) {
            useTable = true;
            // Continue the loop since there still may be a higher priority
            // table.
          } else if (platformId === 3 && encodingId === 1 &&
                     ((!isSymbolicFont && hasEncoding) || !potentialTable)) {
            useTable = true;
            if (!isSymbolicFont) {
              canBreak = true;
            }
          } else if (isSymbolicFont && platformId === 3 && encodingId === 0) {
            useTable = true;
            canBreak = true;
          }

          if (useTable) {
            potentialTable = {
              platformId: platformId,
              encodingId: encodingId,
              offset: offset
            };
          }
          if (canBreak) {
            break;
          }
        }

        if (potentialTable) {
          font.pos = start + potentialTable.offset;
        }
        if (!potentialTable || font.peekByte() === -1) {
          warn('Could not find a preferred cmap table.');
          return {
            platformId: -1,
            encodingId: -1,
            mappings: [],
            hasShortCmap: false
          };
        }

        var format = font.getUint16();
        var length = font.getUint16();
        var language = font.getUint16();

        var hasShortCmap = false;
        var mappings = [];
        var j, glyphId;

        // TODO(mack): refactor this cmap subtable reading logic out
        if (format === 0) {
          for (j = 0; j < 256; j++) {
            var index = font.getByte();
            if (!index) {
              continue;
            }
            mappings.push({
              charCode: j,
              glyphId: index
            });
          }
          hasShortCmap = true;
        } else if (format === 4) {
          // re-creating the table in format 4 since the encoding
          // might be changed
          var segCount = (font.getUint16() >> 1);
          font.getBytes(6); // skipping range fields
          var segIndex, segments = [];
          for (segIndex = 0; segIndex < segCount; segIndex++) {
            segments.push({ end: font.getUint16() });
          }
          font.getUint16();
          for (segIndex = 0; segIndex < segCount; segIndex++) {
            segments[segIndex].start = font.getUint16();
          }

          for (segIndex = 0; segIndex < segCount; segIndex++) {
            segments[segIndex].delta = font.getUint16();
          }

          var offsetsCount = 0;
          for (segIndex = 0; segIndex < segCount; segIndex++) {
            segment = segments[segIndex];
            var rangeOffset = font.getUint16();
            if (!rangeOffset) {
              segment.offsetIndex = -1;
              continue;
            }

            var offsetIndex = (rangeOffset >> 1) - (segCount - segIndex);
            segment.offsetIndex = offsetIndex;
            offsetsCount = Math.max(offsetsCount, offsetIndex +
                                    segment.end - segment.start + 1);
          }

          var offsets = [];
          for (j = 0; j < offsetsCount; j++) {
            offsets.push(font.getUint16());
          }

          for (segIndex = 0; segIndex < segCount; segIndex++) {
            segment = segments[segIndex];
            start = segment.start;
            var end = segment.end;
            var delta = segment.delta;
            offsetIndex = segment.offsetIndex;

            for (j = start; j <= end; j++) {
              if (j === 0xFFFF) {
                continue;
              }

              glyphId = (offsetIndex < 0 ?
                         j : offsets[offsetIndex + j - start]);
              glyphId = (glyphId + delta) & 0xFFFF;
              if (glyphId === 0) {
                continue;
              }
              mappings.push({
                charCode: j,
                glyphId: glyphId
              });
            }
          }
        } else if (format === 6) {
          // Format 6 is a 2-bytes dense mapping, which means the font data
          // lives glue together even if they are pretty far in the unicode
          // table. (This looks weird, so I can have missed something), this
          // works on Linux but seems to fails on Mac so let's rewrite the
          // cmap table to a 3-1-4 style
          var firstCode = font.getUint16();
          var entryCount = font.getUint16();

          for (j = 0; j < entryCount; j++) {
            glyphId = font.getUint16();
            var charCode = firstCode + j;

            mappings.push({
              charCode: charCode,
              glyphId: glyphId
            });
          }
        } else {
          warn('cmap table has unsupported format: ' + format);
          return {
            platformId: -1,
            encodingId: -1,
            mappings: [],
            hasShortCmap: false
          };
        }

        // removing duplicate entries
        mappings.sort(function (a, b) {
          return a.charCode - b.charCode;
        });
        for (i = 1; i < mappings.length; i++) {
          if (mappings[i - 1].charCode === mappings[i].charCode) {
            mappings.splice(i, 1);
            i--;
          }
        }

        return {
          platformId: potentialTable.platformId,
          encodingId: potentialTable.encodingId,
          mappings: mappings,
          hasShortCmap: hasShortCmap
        };
      }

      function sanitizeMetrics(font, header, metrics, numGlyphs) {
        if (!header) {
          if (metrics) {
            metrics.data = null;
          }
          return;
        }

        font.pos = (font.start ? font.start : 0) + header.offset;
        font.pos += header.length - 2;
        var numOfMetrics = font.getUint16();

        if (numOfMetrics > numGlyphs) {
          info('The numOfMetrics (' + numOfMetrics + ') should not be ' +
               'greater than the numGlyphs (' + numGlyphs + ')');
          // Reduce numOfMetrics if it is greater than numGlyphs
          numOfMetrics = numGlyphs;
          header.data[34] = (numOfMetrics & 0xff00) >> 8;
          header.data[35] = numOfMetrics & 0x00ff;
        }

        var numOfSidebearings = numGlyphs - numOfMetrics;
        var numMissing = numOfSidebearings -
          ((metrics.length - numOfMetrics * 4) >> 1);

        if (numMissing > 0) {
          // For each missing glyph, we set both the width and lsb to 0 (zero).
          // Since we need to add two properties for each glyph, this explains
          // the use of |numMissing * 2| when initializing the typed array.
          var entries = new Uint8Array(metrics.length + numMissing * 2);
          entries.set(metrics.data);
          metrics.data = entries;
        }
      }

      function sanitizeGlyph(source, sourceStart, sourceEnd, dest, destStart,
                             hintsValid) {
        if (sourceEnd - sourceStart <= 12) {
          // glyph with data less than 12 is invalid one
          return 0;
        }
        var glyf = source.subarray(sourceStart, sourceEnd);
        var contoursCount = (glyf[0] << 8) | glyf[1];
        if (contoursCount & 0x8000) {
          // complex glyph, writing as is
          dest.set(glyf, destStart);
          return glyf.length;
        }

        var i, j = 10, flagsCount = 0;
        for (i = 0; i < contoursCount; i++) {
          var endPoint = (glyf[j] << 8) | glyf[j + 1];
          flagsCount = endPoint + 1;
          j += 2;
        }
        // skipping instructions
        var instructionsStart = j;
        var instructionsLength = (glyf[j] << 8) | glyf[j + 1];
        j += 2 + instructionsLength;
        var instructionsEnd = j;
        // validating flags
        var coordinatesLength = 0;
        for (i = 0; i < flagsCount; i++) {
          var flag = glyf[j++];
          if (flag & 0xC0) {
            // reserved flags must be zero, cleaning up
            glyf[j - 1] = flag & 0x3F;
          }
          var xyLength = ((flag & 2) ? 1 : (flag & 16) ? 0 : 2) +
                         ((flag & 4) ? 1 : (flag & 32) ? 0 : 2);
          coordinatesLength += xyLength;
          if (flag & 8) {
            var repeat = glyf[j++];
            i += repeat;
            coordinatesLength += repeat * xyLength;
          }
        }
        // glyph without coordinates will be rejected
        if (coordinatesLength === 0) {
          return 0;
        }
        var glyphDataLength = j + coordinatesLength;
        if (glyphDataLength > glyf.length) {
          // not enough data for coordinates
          return 0;
        }
        if (!hintsValid && instructionsLength > 0) {
          dest.set(glyf.subarray(0, instructionsStart), destStart);
          dest.set([0, 0], destStart + instructionsStart);
          dest.set(glyf.subarray(instructionsEnd, glyphDataLength),
                   destStart + instructionsStart + 2);
          glyphDataLength -= instructionsLength;
          if (glyf.length - glyphDataLength > 3) {
            glyphDataLength = (glyphDataLength + 3) & ~3;
          }
          return glyphDataLength;
        }
        if (glyf.length - glyphDataLength > 3) {
          // truncating and aligning to 4 bytes the long glyph data
          glyphDataLength = (glyphDataLength + 3) & ~3;
          dest.set(glyf.subarray(0, glyphDataLength), destStart);
          return glyphDataLength;
        }
        // glyph data is fine
        dest.set(glyf, destStart);
        return glyf.length;
      }

      function sanitizeHead(head, numGlyphs, locaLength) {
        var data = head.data;

        // Validate version:
        // Should always be 0x00010000
        var version = int32(data[0], data[1], data[2], data[3]);
        if (version >> 16 !== 1) {
          info('Attempting to fix invalid version in head table: ' + version);
          data[0] = 0;
          data[1] = 1;
          data[2] = 0;
          data[3] = 0;
        }

        var indexToLocFormat = int16(data[50], data[51]);
        if (indexToLocFormat < 0 || indexToLocFormat > 1) {
          info('Attempting to fix invalid indexToLocFormat in head table: ' +
               indexToLocFormat);

          // The value of indexToLocFormat should be 0 if the loca table
          // consists of short offsets, and should be 1 if the loca table
          // consists of long offsets.
          //
          // The number of entries in the loca table should be numGlyphs + 1.
          //
          // Using this information, we can work backwards to deduce if the
          // size of each offset in the loca table, and thus figure out the
          // appropriate value for indexToLocFormat.

          var numGlyphsPlusOne = numGlyphs + 1;
          if (locaLength === numGlyphsPlusOne << 1) {
            // 0x0000 indicates the loca table consists of short offsets
            data[50] = 0;
            data[51] = 0;
          } else if (locaLength === numGlyphsPlusOne << 2) {
            // 0x0001 indicates the loca table consists of long offsets
            data[50] = 0;
            data[51] = 1;
          } else {
            warn('Could not fix indexToLocFormat: ' + indexToLocFormat);
          }
        }
      }

      function sanitizeGlyphLocations(loca, glyf, numGlyphs,
                                      isGlyphLocationsLong, hintsValid,
                                      dupFirstEntry) {
        var itemSize, itemDecode, itemEncode;
        if (isGlyphLocationsLong) {
          itemSize = 4;
          itemDecode = function fontItemDecodeLong(data, offset) {
            return (data[offset] << 24) | (data[offset + 1] << 16) |
                   (data[offset + 2] << 8) | data[offset + 3];
          };
          itemEncode = function fontItemEncodeLong(data, offset, value) {
            data[offset] = (value >>> 24) & 0xFF;
            data[offset + 1] = (value >> 16) & 0xFF;
            data[offset + 2] = (value >> 8) & 0xFF;
            data[offset + 3] = value & 0xFF;
          };
        } else {
          itemSize = 2;
          itemDecode = function fontItemDecode(data, offset) {
            return (data[offset] << 9) | (data[offset + 1] << 1);
          };
          itemEncode = function fontItemEncode(data, offset, value) {
            data[offset] = (value >> 9) & 0xFF;
            data[offset + 1] = (value >> 1) & 0xFF;
          };
        }
        var locaData = loca.data;
        var locaDataSize = itemSize * (1 + numGlyphs);
        // is loca.data too short or long?
        if (locaData.length !== locaDataSize) {
          locaData = new Uint8Array(locaDataSize);
          locaData.set(loca.data.subarray(0, locaDataSize));
          loca.data = locaData;
        }
        // removing the invalid glyphs
        var oldGlyfData = glyf.data;
        var oldGlyfDataLength = oldGlyfData.length;
        var newGlyfData = new Uint8Array(oldGlyfDataLength);
        var startOffset = itemDecode(locaData, 0);
        var writeOffset = 0;
        var missingGlyphData = Object.create(null);
        itemEncode(locaData, 0, writeOffset);
        var i, j;
        for (i = 0, j = itemSize; i < numGlyphs; i++, j += itemSize) {
          var endOffset = itemDecode(locaData, j);
          if (endOffset > oldGlyfDataLength &&
              ((oldGlyfDataLength + 3) & ~3) === endOffset) {
            // Aspose breaks fonts by aligning the glyphs to the qword, but not
            // the glyf table size, which makes last glyph out of range.
            endOffset = oldGlyfDataLength;
          }
          if (endOffset > oldGlyfDataLength) {
            // glyph end offset points outside glyf data, rejecting the glyph
            itemEncode(locaData, j, writeOffset);
            startOffset = endOffset;
            continue;
          }

          if (startOffset === endOffset) {
            missingGlyphData[i] = true;
          }

          var newLength = sanitizeGlyph(oldGlyfData, startOffset, endOffset,
                                        newGlyfData, writeOffset, hintsValid);
          writeOffset += newLength;
          itemEncode(locaData, j, writeOffset);
          startOffset = endOffset;
        }

        if (writeOffset === 0) {
          // glyf table cannot be empty -- redoing the glyf and loca tables
          // to have single glyph with one point
          var simpleGlyph = new Uint8Array(
            [0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 0]);
          for (i = 0, j = itemSize; i < numGlyphs; i++, j += itemSize) {
            itemEncode(locaData, j, simpleGlyph.length);
          }
          glyf.data = simpleGlyph;
          return missingGlyphData;
        }

        if (dupFirstEntry) {
          var firstEntryLength = itemDecode(locaData, itemSize);
          if (newGlyfData.length > firstEntryLength + writeOffset) {
            glyf.data = newGlyfData.subarray(0, firstEntryLength + writeOffset);
          } else {
            glyf.data = new Uint8Array(firstEntryLength + writeOffset);
            glyf.data.set(newGlyfData.subarray(0, writeOffset));
          }
          glyf.data.set(newGlyfData.subarray(0, firstEntryLength), writeOffset);
          itemEncode(loca.data, locaData.length - itemSize,
                     writeOffset + firstEntryLength);
        } else {
          glyf.data = newGlyfData.subarray(0, writeOffset);
        }
        return missingGlyphData;
      }

      function readPostScriptTable(post, properties, maxpNumGlyphs) {
        var start = (font.start ? font.start : 0) + post.offset;
        font.pos = start;

        var length = post.length, end = start + length;
        var version = font.getInt32();
        // skip rest to the tables
        font.getBytes(28);

        var glyphNames;
        var valid = true;
        var i;

        switch (version) {
          case 0x00010000:
            glyphNames = MacStandardGlyphOrdering;
            break;
          case 0x00020000:
            var numGlyphs = font.getUint16();
            if (numGlyphs !== maxpNumGlyphs) {
              valid = false;
              break;
            }
            var glyphNameIndexes = [];
            for (i = 0; i < numGlyphs; ++i) {
              var index = font.getUint16();
              if (index >= 32768) {
                valid = false;
                break;
              }
              glyphNameIndexes.push(index);
            }
            if (!valid) {
              break;
            }
            var customNames = [];
            var strBuf = [];
            while (font.pos < end) {
              var stringLength = font.getByte();
              strBuf.length = stringLength;
              for (i = 0; i < stringLength; ++i) {
                strBuf[i] = String.fromCharCode(font.getByte());
              }
              customNames.push(strBuf.join(''));
            }
            glyphNames = [];
            for (i = 0; i < numGlyphs; ++i) {
              var j = glyphNameIndexes[i];
              if (j < 258) {
                glyphNames.push(MacStandardGlyphOrdering[j]);
                continue;
              }
              glyphNames.push(customNames[j - 258]);
            }
            break;
          case 0x00030000:
            break;
          default:
            warn('Unknown/unsupported post table version ' + version);
            valid = false;
            if (properties.defaultEncoding) {
              glyphNames = properties.defaultEncoding;
            }
            break;
        }
        properties.glyphNames = glyphNames;
        return valid;
      }

      function readNameTable(nameTable) {
        var start = (font.start ? font.start : 0) + nameTable.offset;
        font.pos = start;

        var names = [[], []];
        var length = nameTable.length, end = start + length;
        var format = font.getUint16();
        var FORMAT_0_HEADER_LENGTH = 6;
        if (format !== 0 || length < FORMAT_0_HEADER_LENGTH) {
          // unsupported name table format or table "too" small
          return names;
        }
        var numRecords = font.getUint16();
        var stringsStart = font.getUint16();
        var records = [];
        var NAME_RECORD_LENGTH = 12;
        var i, ii;

        for (i = 0; i < numRecords &&
                        font.pos + NAME_RECORD_LENGTH <= end; i++) {
          var r = {
            platform: font.getUint16(),
            encoding: font.getUint16(),
            language: font.getUint16(),
            name: font.getUint16(),
            length: font.getUint16(),
            offset: font.getUint16()
          };
          // using only Macintosh and Windows platform/encoding names
          if ((r.platform === 1 && r.encoding === 0 && r.language === 0) ||
              (r.platform === 3 && r.encoding === 1 && r.language === 0x409)) {
            records.push(r);
          }
        }
        for (i = 0, ii = records.length; i < ii; i++) {
          var record = records[i];
          if (record.length <= 0) {
            continue; // Nothing to process, ignoring.
          }
          var pos = start + stringsStart + record.offset;
          if (pos + record.length > end) {
            continue; // outside of name table, ignoring
          }
          font.pos = pos;
          var nameIndex = record.name;
          if (record.encoding) {
            // unicode
            var str = '';
            for (var j = 0, jj = record.length; j < jj; j += 2) {
              str += String.fromCharCode(font.getUint16());
            }
            names[1][nameIndex] = str;
          } else {
            names[0][nameIndex] = bytesToString(font.getBytes(record.length));
          }
        }
        return names;
      }

      var TTOpsStackDeltas = [
        0, 0, 0, 0, 0, 0, 0, 0, -2, -2, -2, -2, 0, 0, -2, -5,
        -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, -1, -1, -1, -1,
        1, -1, -999, 0, 1, 0, -1, -2, 0, -1, -2, -1, -1, 0, -1, -1,
        0, 0, -999, -999, -1, -1, -1, -1, -2, -999, -2, -2, -999, 0, -2, -2,
        0, 0, -2, 0, -2, 0, 0, 0, -2, -1, -1, 1, 1, 0, 0, -1,
        -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, -1, -1, 0, -999, -1, -1,
        -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        -2, -999, -999, -999, -999, -999, -1, -1, -2, -2, 0, 0, 0, 0, -1, -1,
        -999, -2, -2, 0, 0, -1, -2, -2, 0, 0, 0, -1, -1, -1, -2];
        // 0xC0-DF == -1 and 0xE0-FF == -2

      function sanitizeTTProgram(table, ttContext) {
        var data = table.data;
        var i = 0, j, n, b, funcId, pc, lastEndf = 0, lastDeff = 0;
        var stack = [];
        var callstack = [];
        var functionsCalled = [];
        var tooComplexToFollowFunctions =
          ttContext.tooComplexToFollowFunctions;
        var inFDEF = false, ifLevel = 0, inELSE = 0;
        for (var ii = data.length; i < ii;) {
          var op = data[i++];
          // The TrueType instruction set docs can be found at
          // https://developer.apple.com/fonts/TTRefMan/RM05/Chap5.html
          if (op === 0x40) { // NPUSHB - pushes n bytes
            n = data[i++];
            if (inFDEF || inELSE) {
              i += n;
            } else {
              for (j = 0; j < n; j++) {
                stack.push(data[i++]);
              }
            }
          } else if (op === 0x41) { // NPUSHW - pushes n words
            n = data[i++];
            if (inFDEF || inELSE) {
              i += n * 2;
            } else {
              for (j = 0; j < n; j++) {
                b = data[i++];
                stack.push((b << 8) | data[i++]);
              }
            }
          } else if ((op & 0xF8) === 0xB0) { // PUSHB - pushes bytes
            n = op - 0xB0 + 1;
            if (inFDEF || inELSE) {
              i += n;
            } else {
              for (j = 0; j < n; j++) {
                stack.push(data[i++]);
              }
            }
          } else if ((op & 0xF8) === 0xB8) { // PUSHW - pushes words
            n = op - 0xB8 + 1;
            if (inFDEF || inELSE) {
              i += n * 2;
            } else {
              for (j = 0; j < n; j++) {
                b = data[i++];
                stack.push((b << 8) | data[i++]);
              }
            }
          } else if (op === 0x2B && !tooComplexToFollowFunctions) { // CALL
            if (!inFDEF && !inELSE) {
              // collecting inforamtion about which functions are used
              funcId = stack[stack.length - 1];
              ttContext.functionsUsed[funcId] = true;
              if (funcId in ttContext.functionsStackDeltas) {
                stack.length += ttContext.functionsStackDeltas[funcId];
              } else if (funcId in ttContext.functionsDefined &&
                         functionsCalled.indexOf(funcId) < 0) {
                callstack.push({data: data, i: i, stackTop: stack.length - 1});
                functionsCalled.push(funcId);
                pc = ttContext.functionsDefined[funcId];
                if (!pc) {
                  warn('TT: CALL non-existent function');
                  ttContext.hintsValid = false;
                  return;
                }
                data = pc.data;
                i = pc.i;
              }
            }
          } else if (op === 0x2C && !tooComplexToFollowFunctions) { // FDEF
            if (inFDEF || inELSE) {
              warn('TT: nested FDEFs not allowed');
              tooComplexToFollowFunctions = true;
            }
            inFDEF = true;
            // collecting inforamtion about which functions are defined
            lastDeff = i;
            funcId = stack.pop();
            ttContext.functionsDefined[funcId] = {data: data, i: i};
          } else if (op === 0x2D) { // ENDF - end of function
            if (inFDEF) {
              inFDEF = false;
              lastEndf = i;
            } else {
              pc = callstack.pop();
              if (!pc) {
                warn('TT: ENDF bad stack');
                ttContext.hintsValid = false;
                return;
              }
              funcId = functionsCalled.pop();
              data = pc.data;
              i = pc.i;
              ttContext.functionsStackDeltas[funcId] =
                stack.length - pc.stackTop;
            }
          } else if (op === 0x89) { // IDEF - instruction definition
            if (inFDEF || inELSE) {
              warn('TT: nested IDEFs not allowed');
              tooComplexToFollowFunctions = true;
            }
            inFDEF = true;
            // recording it as a function to track ENDF
            lastDeff = i;
          } else if (op === 0x58) { // IF
            ++ifLevel;
          } else if (op === 0x1B) { // ELSE
            inELSE = ifLevel;
          } else if (op === 0x59) { // EIF
            if (inELSE === ifLevel) {
              inELSE = 0;
            }
            --ifLevel;
          } else if (op === 0x1C) { // JMPR
            if (!inFDEF && !inELSE) {
              var offset = stack[stack.length - 1];
              // only jumping forward to prevent infinite loop
              if (offset > 0) {
                i += offset - 1;
              }
            }
          }
          // Adjusting stack not extactly, but just enough to get function id
          if (!inFDEF && !inELSE) {
            var stackDelta = op <= 0x8E ? TTOpsStackDeltas[op] :
              op >= 0xC0 && op <= 0xDF ? -1 : op >= 0xE0 ? -2 : 0;
            if (op >= 0x71 && op <= 0x75) {
              n = stack.pop();
              if (n === n) {
                stackDelta = -n * 2;
              }
            }
            while (stackDelta < 0 && stack.length > 0) {
              stack.pop();
              stackDelta++;
            }
            while (stackDelta > 0) {
              stack.push(NaN); // pushing any number into stack
              stackDelta--;
            }
          }
        }
        ttContext.tooComplexToFollowFunctions = tooComplexToFollowFunctions;
        var content = [data];
        if (i > data.length) {
          content.push(new Uint8Array(i - data.length));
        }
        if (lastDeff > lastEndf) {
          warn('TT: complementing a missing function tail');
          // new function definition started, but not finished
          // complete function by [CLEAR, ENDF]
          content.push(new Uint8Array([0x22, 0x2D]));
        }
        foldTTTable(table, content);
      }

      function checkInvalidFunctions(ttContext, maxFunctionDefs) {
        if (ttContext.tooComplexToFollowFunctions) {
          return;
        }
        if (ttContext.functionsDefined.length > maxFunctionDefs) {
          warn('TT: more functions defined than expected');
          ttContext.hintsValid = false;
          return;
        }
        for (var j = 0, jj = ttContext.functionsUsed.length; j < jj; j++) {
          if (j > maxFunctionDefs) {
            warn('TT: invalid function id: ' + j);
            ttContext.hintsValid = false;
            return;
          }
          if (ttContext.functionsUsed[j] && !ttContext.functionsDefined[j]) {
            warn('TT: undefined function: ' + j);
            ttContext.hintsValid = false;
            return;
          }
        }
      }

      function foldTTTable(table, content) {
        if (content.length > 1) {
          // concatenating the content items
          var newLength = 0;
          var j, jj;
          for (j = 0, jj = content.length; j < jj; j++) {
            newLength += content[j].length;
          }
          newLength = (newLength + 3) & ~3;
          var result = new Uint8Array(newLength);
          var pos = 0;
          for (j = 0, jj = content.length; j < jj; j++) {
            result.set(content[j], pos);
            pos += content[j].length;
          }
          table.data = result;
          table.length = newLength;
        }
      }

      function sanitizeTTPrograms(fpgm, prep, cvt, maxFunctionDefs) {
        var ttContext = {
          functionsDefined: [],
          functionsUsed: [],
          functionsStackDeltas: [],
          tooComplexToFollowFunctions: false,
          hintsValid: true
        };
        if (fpgm) {
          sanitizeTTProgram(fpgm, ttContext);
        }
        if (prep) {
          sanitizeTTProgram(prep, ttContext);
        }
        if (fpgm) {
          checkInvalidFunctions(ttContext, maxFunctionDefs);
        }
        if (cvt && (cvt.length & 1)) {
          var cvtData = new Uint8Array(cvt.length + 1);
          cvtData.set(cvt.data);
          cvt.data = cvtData;
        }
        return ttContext.hintsValid;
      }

      // The following steps modify the original font data, making copy
      font = new Stream(new Uint8Array(font.getBytes()));

      var VALID_TABLES = ['OS/2', 'cmap', 'head', 'hhea', 'hmtx', 'maxp',
        'name', 'post', 'loca', 'glyf', 'fpgm', 'prep', 'cvt ', 'CFF '];

      var header = readOpenTypeHeader(font);
      var numTables = header.numTables;
      var cff, cffFile;

      var tables = Object.create(null);
      tables['OS/2'] = null;
      tables['cmap'] = null;
      tables['head'] = null;
      tables['hhea'] = null;
      tables['hmtx'] = null;
      tables['maxp'] = null;
      tables['name'] = null;
      tables['post'] = null;

      var table;
      for (var i = 0; i < numTables; i++) {
        table = readTableEntry(font);
        if (VALID_TABLES.indexOf(table.tag) < 0) {
          continue; // skipping table if it's not a required or optional table
        }
        if (table.length === 0) {
          continue; // skipping empty tables
        }
        tables[table.tag] = table;
      }

      var isTrueType = !tables['CFF '];
      if (!isTrueType) {
        // OpenType font
        if ((header.version === 'OTTO' && properties.type !== 'CIDFontType2') ||
            !tables['head'] || !tables['hhea'] || !tables['maxp'] ||
            !tables['post']) {
          // no major tables: throwing everything at CFFFont
          cffFile = new Stream(tables['CFF '].data);
          cff = new CFFFont(cffFile, properties);

          adjustWidths(properties);

          return this.convert(name, cff, properties);
        }

        delete tables['glyf'];
        delete tables['loca'];
        delete tables['fpgm'];
        delete tables['prep'];
        delete tables['cvt '];
        this.isOpenType = true;
      } else {
        if (!tables['loca']) {
          error('Required "loca" table is not found');
        }
        if (!tables['glyf']) {
          warn('Required "glyf" table is not found -- trying to recover.');
          // Note: We use `sanitizeGlyphLocations` to add dummy glyf data below.
          tables['glyf'] = {
            tag: 'glyf',
            data: new Uint8Array(0),
          };
        }
        this.isOpenType = false;
      }

      if (!tables['maxp']) {
        error('Required "maxp" table is not found');
      }

      font.pos = (font.start || 0) + tables['maxp'].offset;
      var version = font.getInt32();
      var numGlyphs = font.getUint16();
      var maxFunctionDefs = 0;
      if (version >= 0x00010000 && tables['maxp'].length >= 22) {
        // maxZones can be invalid
        font.pos += 8;
        var maxZones = font.getUint16();
        if (maxZones > 2) { // reset to 2 if font has invalid maxZones
          tables['maxp'].data[14] = 0;
          tables['maxp'].data[15] = 2;
        }
        font.pos += 4;
        maxFunctionDefs = font.getUint16();
      }

      var dupFirstEntry = false;
      if (properties.type === 'CIDFontType2' && properties.toUnicode &&
          properties.toUnicode.get(0) > '\u0000') {
        // oracle's defect (see 3427), duplicating first entry
        dupFirstEntry = true;
        numGlyphs++;
        tables['maxp'].data[4] = numGlyphs >> 8;
        tables['maxp'].data[5] = numGlyphs & 255;
      }

      var hintsValid = sanitizeTTPrograms(tables['fpgm'], tables['prep'],
                                          tables['cvt '], maxFunctionDefs);
      if (!hintsValid) {
        delete tables['fpgm'];
        delete tables['prep'];
        delete tables['cvt '];
      }

      // Ensure the hmtx table contains the advance width and
      // sidebearings information for numGlyphs in the maxp table
      sanitizeMetrics(font, tables['hhea'], tables['hmtx'], numGlyphs);

      if (!tables['head']) {
        error('Required "head" table is not found');
      }

      sanitizeHead(tables['head'], numGlyphs,
                   isTrueType ? tables['loca'].length : 0);

      var missingGlyphs = Object.create(null);
      if (isTrueType) {
        var isGlyphLocationsLong = int16(tables['head'].data[50],
                                         tables['head'].data[51]);
        missingGlyphs = sanitizeGlyphLocations(tables['loca'], tables['glyf'],
                                               numGlyphs, isGlyphLocationsLong,
                                               hintsValid, dupFirstEntry);
      }

      if (!tables['hhea']) {
        error('Required "hhea" table is not found');
      }

      // Sanitizer reduces the glyph advanceWidth to the maxAdvanceWidth
      // Sometimes it's 0. That needs to be fixed
      if (tables['hhea'].data[10] === 0 && tables['hhea'].data[11] === 0) {
        tables['hhea'].data[10] = 0xFF;
        tables['hhea'].data[11] = 0xFF;
      }

      // Extract some more font properties from the OpenType head and
      // hhea tables; yMin and descent value are always negative.
      var metricsOverride = {
        unitsPerEm: int16(tables['head'].data[18], tables['head'].data[19]),
        yMax: int16(tables['head'].data[42], tables['head'].data[43]),
        yMin: signedInt16(tables['head'].data[38], tables['head'].data[39]),
        ascent: int16(tables['hhea'].data[4], tables['hhea'].data[5]),
        descent: signedInt16(tables['hhea'].data[6], tables['hhea'].data[7])
      };

      // PDF FontDescriptor metrics lie -- using data from actual font.
      this.ascent = metricsOverride.ascent / metricsOverride.unitsPerEm;
      this.descent = metricsOverride.descent / metricsOverride.unitsPerEm;

      // The 'post' table has glyphs names.
      if (tables['post']) {
        var valid = readPostScriptTable(tables['post'], properties, numGlyphs);
        if (!valid) {
          tables['post'] = null;
        }
      }

      var charCodeToGlyphId = [], charCode;
      var toUnicode = properties.toUnicode, widths = properties.widths;
      var skipToUnicode = (toUnicode instanceof IdentityToUnicodeMap ||
                           toUnicode.length === 0x10000);

      // Helper function to try to skip mapping of empty glyphs.
      // Note: In some cases, just relying on the glyph data doesn't work,
      //       hence we also use a few heuristics to fix various PDF files.
      function hasGlyph(glyphId, charCode, widthCode) {
        if (!missingGlyphs[glyphId]) {
          return true;
        }
        if (!skipToUnicode && charCode >= 0 && toUnicode.has(charCode)) {
          return true;
        }
        if (widths && widthCode >= 0 && isNum(widths[widthCode])) {
          return true;
        }
        return false;
      }

      if (properties.type === 'CIDFontType2') {
        var cidToGidMap = properties.cidToGidMap || [];
        var isCidToGidMapEmpty = cidToGidMap.length === 0;

        properties.cMap.forEach(function(charCode, cid) {
          assert(cid <= 0xffff, 'Max size of CID is 65,535');
          var glyphId = -1;
          if (isCidToGidMapEmpty) {
            glyphId = cid;
          } else if (cidToGidMap[cid] !== undefined) {
            glyphId = cidToGidMap[cid];
          }

          if (glyphId >= 0 && glyphId < numGlyphs &&
              hasGlyph(glyphId, charCode, cid)) {
            charCodeToGlyphId[charCode] = glyphId;
          }
        });
        if (dupFirstEntry) {
          charCodeToGlyphId[0] = numGlyphs - 1;
        }
      } else {
        // Most of the following logic in this code branch is based on the
        // 9.6.6.4 of the PDF spec.
        var hasEncoding =
          properties.differences.length > 0 || !!properties.baseEncodingName;
        var cmapTable =
          readCmapTable(tables['cmap'], font, this.isSymbolicFont, hasEncoding);
        var cmapPlatformId = cmapTable.platformId;
        var cmapEncodingId = cmapTable.encodingId;
        var cmapMappings = cmapTable.mappings;
        var cmapMappingsLength = cmapMappings.length;

        // The spec seems to imply that if the font is symbolic the encoding
        // should be ignored, this doesn't appear to work for 'preistabelle.pdf'
        // where the the font is symbolic and it has an encoding.
        if (hasEncoding &&
            (cmapPlatformId === 3 && cmapEncodingId === 1 ||
             cmapPlatformId === 1 && cmapEncodingId === 0) ||
            (cmapPlatformId === -1 && cmapEncodingId === -1 && // Temporary hack
             !!getEncoding(properties.baseEncodingName))) {    // Temporary hack
          // When no preferred cmap table was found and |baseEncodingName| is
          // one of the predefined encodings, we seem to obtain a better
          // |charCodeToGlyphId| map from the code below (fixes bug 1057544).
          // TODO: Note that this is a hack which should be removed as soon as
          //       we have proper support for more exotic cmap tables.

          var baseEncoding = [];
          if (properties.baseEncodingName === 'MacRomanEncoding' ||
              properties.baseEncodingName === 'WinAnsiEncoding') {
            baseEncoding = getEncoding(properties.baseEncodingName);
          }
          var glyphsUnicodeMap = getGlyphsUnicode();
          for (charCode = 0; charCode < 256; charCode++) {
            var glyphName, standardGlyphName;
            if (this.differences && charCode in this.differences) {
              glyphName = this.differences[charCode];
            } else if (charCode in baseEncoding &&
                       baseEncoding[charCode] !== '') {
              glyphName = baseEncoding[charCode];
            } else {
              glyphName = StandardEncoding[charCode];
            }
            if (!glyphName) {
              continue;
            }
            // Ensure that non-standard glyph names are resolved to valid ones.
            standardGlyphName = recoverGlyphName(glyphName, glyphsUnicodeMap);

            var unicodeOrCharCode, isUnicode = false;
            if (cmapPlatformId === 3 && cmapEncodingId === 1) {
              unicodeOrCharCode = glyphsUnicodeMap[standardGlyphName];
              isUnicode = true;
            } else if (cmapPlatformId === 1 && cmapEncodingId === 0) {
              // TODO: the encoding needs to be updated with mac os table.
              unicodeOrCharCode = MacRomanEncoding.indexOf(standardGlyphName);
            }

            var found = false;
            for (i = 0; i < cmapMappingsLength; ++i) {
              if (cmapMappings[i].charCode !== unicodeOrCharCode) {
                continue;
              }
              var code = isUnicode ? charCode : unicodeOrCharCode;
              if (hasGlyph(cmapMappings[i].glyphId, code, -1)) {
                charCodeToGlyphId[charCode] = cmapMappings[i].glyphId;
                found = true;
                break;
              }
            }
            if (!found && properties.glyphNames) {
              // Try to map using the post table.
              var glyphId = properties.glyphNames.indexOf(glyphName);
              // The post table ought to use the same kind of glyph names as the
              // `differences` array, but check the standard ones as a fallback.
              if (glyphId === -1 && standardGlyphName !== glyphName) {
                glyphId = properties.glyphNames.indexOf(standardGlyphName);
              }
              if (glyphId > 0 && hasGlyph(glyphId, -1, -1)) {
                charCodeToGlyphId[charCode] = glyphId;
                found = true;
              }
            }
            if (!found) {
              charCodeToGlyphId[charCode] = 0; // notdef
            }
          }
        } else if (cmapPlatformId === 0 && cmapEncodingId === 0) {
          // Default Unicode semantics, use the charcodes as is.
          for (i = 0; i < cmapMappingsLength; ++i) {
            charCodeToGlyphId[cmapMappings[i].charCode] =
              cmapMappings[i].glyphId;
          }
        } else {
          // For (3, 0) cmap tables:
          // The charcode key being stored in charCodeToGlyphId is the lower
          // byte of the two-byte charcodes of the cmap table since according to
          // the spec: 'each byte from the string shall be prepended with the
          // high byte of the range [of charcodes in the cmap table], to form
          // a two-byte character, which shall be used to select the
          // associated glyph description from the subtable'.
          //
          // For (1, 0) cmap tables:
          // 'single bytes from the string shall be used to look up the
          // associated glyph descriptions from the subtable'. This means
          // charcodes in the cmap will be single bytes, so no-op since
          // glyph.charCode & 0xFF === glyph.charCode
          for (i = 0; i < cmapMappingsLength; ++i) {
            charCode = cmapMappings[i].charCode & 0xFF;
            charCodeToGlyphId[charCode] = cmapMappings[i].glyphId;
          }
        }
      }

      if (charCodeToGlyphId.length === 0) {
        // defines at least one glyph
        charCodeToGlyphId[0] = 0;
      }

      // Converting glyphs and ids into font's cmap table
      var newMapping = adjustMapping(charCodeToGlyphId, properties);
      this.toFontChar = newMapping.toFontChar;
      tables['cmap'] = {
        tag: 'cmap',
        data: createCmapTable(newMapping.charCodeToGlyphId, numGlyphs)
      };

      if (!tables['OS/2'] || !validateOS2Table(tables['OS/2'])) {
        tables['OS/2'] = {
          tag: 'OS/2',
          data: createOS2Table(properties, newMapping.charCodeToGlyphId,
                               metricsOverride)
        };
      }

      // Rewrite the 'post' table if needed
      if (!tables['post']) {
        tables['post'] = {
          tag: 'post',
          data: createPostTable(properties)
        };
      }

      if (!isTrueType) {
        try {
          // Trying to repair CFF file
          cffFile = new Stream(tables['CFF '].data);
          var parser = new CFFParser(cffFile, properties,
                                     SEAC_ANALYSIS_ENABLED);
          cff = parser.parse();
          var compiler = new CFFCompiler(cff);
          tables['CFF '].data = compiler.compile();
        } catch (e) {
          warn('Failed to compile font ' + properties.loadedName);
        }
      }

      // Re-creating 'name' table
      if (!tables['name']) {
        tables['name'] = {
          tag: 'name',
          data: createNameTable(this.name)
        };
      } else {
        // ... using existing 'name' table as prototype
        var namePrototype = readNameTable(tables['name']);
        tables['name'].data = createNameTable(name, namePrototype);
      }

      var builder = new OpenTypeFileBuilder(header.version);
      for (var tableTag in tables) {
        builder.addTable(tableTag, tables[tableTag].data);
      }
      return builder.toArray();
    },

    convert: function Font_convert(fontName, font, properties) {
      // TODO: Check the charstring widths to determine this.
      properties.fixedPitch = false;

      var mapping = font.getGlyphMapping(properties);
      var newMapping = adjustMapping(mapping, properties);
      this.toFontChar = newMapping.toFontChar;
      var numGlyphs = font.numGlyphs;

      function getCharCodes(charCodeToGlyphId, glyphId) {
        var charCodes = null;
        for (var charCode in charCodeToGlyphId) {
          if (glyphId === charCodeToGlyphId[charCode]) {
            if (!charCodes) {
              charCodes = [];
            }
            charCodes.push(charCode | 0);
          }
        }
        return charCodes;
      }

      function createCharCode(charCodeToGlyphId, glyphId) {
        for (var charCode in charCodeToGlyphId) {
          if (glyphId === charCodeToGlyphId[charCode]) {
            return charCode | 0;
          }
        }
        newMapping.charCodeToGlyphId[newMapping.nextAvailableFontCharCode] =
            glyphId;
        return newMapping.nextAvailableFontCharCode++;
      }

      var seacs = font.seacs;
      if (SEAC_ANALYSIS_ENABLED && seacs && seacs.length) {
        var matrix = properties.fontMatrix || FONT_IDENTITY_MATRIX;
        var charset = font.getCharset();
        var seacMap = Object.create(null);
        for (var glyphId in seacs) {
          glyphId |= 0;
          var seac = seacs[glyphId];
          var baseGlyphName = StandardEncoding[seac[2]];
          var accentGlyphName = StandardEncoding[seac[3]];
          var baseGlyphId = charset.indexOf(baseGlyphName);
          var accentGlyphId = charset.indexOf(accentGlyphName);
          if (baseGlyphId < 0 || accentGlyphId < 0) {
            continue;
          }
          var accentOffset = {
            x: seac[0] * matrix[0] + seac[1] * matrix[2] + matrix[4],
            y: seac[0] * matrix[1] + seac[1] * matrix[3] + matrix[5]
          };

          var charCodes = getCharCodes(mapping, glyphId);
          if (!charCodes) {
            // There's no point in mapping it if the char code was never mapped
            // to begin with.
            continue;
          }
          for (var i = 0, ii = charCodes.length; i < ii; i++) {
            var charCode = charCodes[i];
            // Find a fontCharCode that maps to the base and accent glyphs.
            // If one doesn't exists, create it.
            var charCodeToGlyphId = newMapping.charCodeToGlyphId;
            var baseFontCharCode = createCharCode(charCodeToGlyphId,
                                                  baseGlyphId);
            var accentFontCharCode = createCharCode(charCodeToGlyphId,
                                                    accentGlyphId);
            seacMap[charCode] = {
              baseFontCharCode: baseFontCharCode,
              accentFontCharCode: accentFontCharCode,
              accentOffset: accentOffset
            };
          }
        }
        properties.seacMap = seacMap;
      }

      var unitsPerEm = 1 / (properties.fontMatrix || FONT_IDENTITY_MATRIX)[0];

      var builder = new OpenTypeFileBuilder('\x4F\x54\x54\x4F');
      // PostScript Font Program
      builder.addTable('CFF ', font.data);
      // OS/2 and Windows Specific metrics
      builder.addTable('OS/2', createOS2Table(properties,
                                              newMapping.charCodeToGlyphId));
      // Character to glyphs mapping
      builder.addTable('cmap', createCmapTable(newMapping.charCodeToGlyphId,
                       numGlyphs));
      // Font header
      builder.addTable('head',
            '\x00\x01\x00\x00' + // Version number
            '\x00\x00\x10\x00' + // fontRevision
            '\x00\x00\x00\x00' + // checksumAdjustement
            '\x5F\x0F\x3C\xF5' + // magicNumber
            '\x00\x00' + // Flags
            safeString16(unitsPerEm) + // unitsPerEM
            '\x00\x00\x00\x00\x9e\x0b\x7e\x27' + // creation date
            '\x00\x00\x00\x00\x9e\x0b\x7e\x27' + // modifification date
            '\x00\x00' + // xMin
            safeString16(properties.descent) + // yMin
            '\x0F\xFF' + // xMax
            safeString16(properties.ascent) + // yMax
            string16(properties.italicAngle ? 2 : 0) + // macStyle
            '\x00\x11' + // lowestRecPPEM
            '\x00\x00' + // fontDirectionHint
            '\x00\x00' + // indexToLocFormat
            '\x00\x00');  // glyphDataFormat

      // Horizontal header
      builder.addTable('hhea',
            '\x00\x01\x00\x00' + // Version number
            safeString16(properties.ascent) + // Typographic Ascent
            safeString16(properties.descent) + // Typographic Descent
            '\x00\x00' + // Line Gap
            '\xFF\xFF' + // advanceWidthMax
            '\x00\x00' + // minLeftSidebearing
            '\x00\x00' + // minRightSidebearing
            '\x00\x00' + // xMaxExtent
            safeString16(properties.capHeight) + // caretSlopeRise
            safeString16(Math.tan(properties.italicAngle) *
                         properties.xHeight) + // caretSlopeRun
            '\x00\x00' + // caretOffset
            '\x00\x00' + // -reserved-
            '\x00\x00' + // -reserved-
            '\x00\x00' + // -reserved-
            '\x00\x00' + // -reserved-
            '\x00\x00' + // metricDataFormat
            string16(numGlyphs)); // Number of HMetrics

      // Horizontal metrics
      builder.addTable('hmtx', (function fontFieldsHmtx() {
          var charstrings = font.charstrings;
          var cffWidths = font.cff ? font.cff.widths : null;
          var hmtx = '\x00\x00\x00\x00'; // Fake .notdef
          for (var i = 1, ii = numGlyphs; i < ii; i++) {
            var width = 0;
            if (charstrings) {
              var charstring = charstrings[i - 1];
              width = 'width' in charstring ? charstring.width : 0;
            } else if (cffWidths) {
              width = Math.ceil(cffWidths[i] || 0);
            }
            hmtx += string16(width) + string16(0);
          }
          return hmtx;
        })());

      // Maximum profile
      builder.addTable('maxp',
            '\x00\x00\x50\x00' + // Version number
            string16(numGlyphs)); // Num of glyphs

      // Naming tables
      builder.addTable('name', createNameTable(fontName));

      // PostScript information
      builder.addTable('post', createPostTable(properties));

      return builder.toArray();
    },

    get spaceWidth() {
      if ('_shadowWidth' in this) {
        return this._shadowWidth;
      }

      // trying to estimate space character width
      var possibleSpaceReplacements = ['space', 'minus', 'one', 'i', 'I'];
      var width;
      for (var i = 0, ii = possibleSpaceReplacements.length; i < ii; i++) {
        var glyphName = possibleSpaceReplacements[i];
        // if possible, getting width by glyph name
        if (glyphName in this.widths) {
          width = this.widths[glyphName];
          break;
        }
        var glyphsUnicodeMap = getGlyphsUnicode();
        var glyphUnicode = glyphsUnicodeMap[glyphName];
        // finding the charcode via unicodeToCID map
        var charcode = 0;
        if (this.composite) {
          if (this.cMap.contains(glyphUnicode)) {
            charcode = this.cMap.lookup(glyphUnicode);
          }
        }
        // ... via toUnicode map
        if (!charcode && this.toUnicode) {
          charcode = this.toUnicode.charCodeOf(glyphUnicode);
        }
        // setting it to unicode if negative or undefined
        if (charcode <= 0) {
          charcode = glyphUnicode;
        }
        // trying to get width via charcode
        width = this.widths[charcode];
        if (width) {
          break; // the non-zero width found
        }
      }
      width = width || this.defaultWidth;
      // Do not shadow the property here. See discussion:
      // https://github.com/mozilla/pdf.js/pull/2127#discussion_r1662280
      this._shadowWidth = width;
      return width;
    },

    charToGlyph: function Font_charToGlyph(charcode, isSpace) {
      var fontCharCode, width, operatorListId;

      var widthCode = charcode;
      if (this.cMap && this.cMap.contains(charcode)) {
        widthCode = this.cMap.lookup(charcode);
      }
      width = this.widths[widthCode];
      width = isNum(width) ? width : this.defaultWidth;
      var vmetric = this.vmetrics && this.vmetrics[widthCode];

      var unicode = this.toUnicode.get(charcode) || charcode;
      if (typeof unicode === 'number') {
        unicode = String.fromCharCode(unicode);
      }

      var isInFont = charcode in this.toFontChar;
      // First try the toFontChar map, if it's not there then try falling
      // back to the char code.
      fontCharCode = this.toFontChar[charcode] || charcode;
      if (this.missingFile) {
        fontCharCode = mapSpecialUnicodeValues(fontCharCode);
      }

      if (this.isType3Font) {
        // Font char code in this case is actually a glyph name.
        operatorListId = fontCharCode;
      }

      var accent = null;
      if (this.seacMap && this.seacMap[charcode]) {
        isInFont = true;
        var seac = this.seacMap[charcode];
        fontCharCode = seac.baseFontCharCode;
        accent = {
          fontChar: String.fromCharCode(seac.accentFontCharCode),
          offset: seac.accentOffset
        };
      }

      var fontChar = String.fromCharCode(fontCharCode);

      var glyph = this.glyphCache[charcode];
      if (!glyph ||
          !glyph.matchesForCache(fontChar, unicode, accent, width, vmetric,
                                 operatorListId, isSpace, isInFont)) {
        glyph = new Glyph(fontChar, unicode, accent, width, vmetric,
                          operatorListId, isSpace, isInFont);
        this.glyphCache[charcode] = glyph;
      }
      return glyph;
    },

    charsToGlyphs: function Font_charsToGlyphs(chars) {
      var charsCache = this.charsCache;
      var glyphs, glyph, charcode;

      // if we translated this string before, just grab it from the cache
      if (charsCache) {
        glyphs = charsCache[chars];
        if (glyphs) {
          return glyphs;
        }
      }

      // lazily create the translation cache
      if (!charsCache) {
        charsCache = this.charsCache = Object.create(null);
      }

      glyphs = [];
      var charsCacheKey = chars;
      var i = 0, ii;

      if (this.cMap) {
        // composite fonts have multi-byte strings convert the string from
        // single-byte to multi-byte
        var c = Object.create(null);
        while (i < chars.length) {
          this.cMap.readCharCode(chars, i, c);
          charcode = c.charcode;
          var length = c.length;
          i += length;
          // Space is char with code 0x20 and length 1 in multiple-byte codes.
          var isSpace = length === 1 && chars.charCodeAt(i - 1) === 0x20;
          glyph = this.charToGlyph(charcode, isSpace);
          glyphs.push(glyph);
        }
      } else {
        for (i = 0, ii = chars.length; i < ii; ++i) {
          charcode = chars.charCodeAt(i);
          glyph = this.charToGlyph(charcode, charcode === 0x20);
          glyphs.push(glyph);
        }
      }

      // Enter the translated string into the cache
      return (charsCache[charsCacheKey] = glyphs);
    }
  };

  return Font;
})();

var ErrorFont = (function ErrorFontClosure() {
  function ErrorFont(error) {
    this.error = error;
    this.loadedName = 'g_font_error';
    this.loading = false;
  }

  ErrorFont.prototype = {
    charsToGlyphs: function ErrorFont_charsToGlyphs() {
      return [];
    },
    exportData: function ErrorFont_exportData() {
      return {error: this.error};
    }
  };

  return ErrorFont;
})();

/**
 * Shared logic for building a char code to glyph id mapping for Type1 and
 * simple CFF fonts. See section 9.6.6.2 of the spec.
 * @param {Object} properties Font properties object.
 * @param {Object} builtInEncoding The encoding contained within the actual font
 * data.
 * @param {Array} glyphNames Array of glyph names where the index is the
 * glyph ID.
 * @returns {Object} A char code to glyph ID map.
 */
function type1FontGlyphMapping(properties, builtInEncoding, glyphNames) {
  var charCodeToGlyphId = Object.create(null);
  var glyphId, charCode, baseEncoding;

  if (properties.baseEncodingName) {
    // If a valid base encoding name was used, the mapping is initialized with
    // that.
    baseEncoding = getEncoding(properties.baseEncodingName);
    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);
      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0; // notdef
      }
    }
  } else if (!!(properties.flags & FontFlags.Symbolic)) {
    // For a symbolic font the encoding should be the fonts built-in
    // encoding.
    for (charCode in builtInEncoding) {
      charCodeToGlyphId[charCode] = builtInEncoding[charCode];
    }
  } else {
    // For non-symbolic fonts that don't have a base encoding the standard
    // encoding should be used.
    baseEncoding = StandardEncoding;
    for (charCode = 0; charCode < baseEncoding.length; charCode++) {
      glyphId = glyphNames.indexOf(baseEncoding[charCode]);
      if (glyphId >= 0) {
        charCodeToGlyphId[charCode] = glyphId;
      } else {
        charCodeToGlyphId[charCode] = 0; // notdef
      }
    }
  }

  // Lastly, merge in the differences.
  var differences = properties.differences, glyphsUnicodeMap;
  if (differences) {
    for (charCode in differences) {
      var glyphName = differences[charCode];
      glyphId = glyphNames.indexOf(glyphName);

      if (glyphId === -1) {
        if (!glyphsUnicodeMap) {
          gl