/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.interlis.iliimport;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.interlis.iliimport.TransferFromIli2cMetamodel;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.config.PersistenceService;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.softenvironment.view.BaseDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class ImportInterlis {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(ImportInterlis.class);

    public static void readIliFile(File[] iliFiles) {
        LauncherView editor = LauncherView.getInstance();
        TransferFromIli2cMetamodel convert = new TransferFromIli2cMetamodel();
        Configuration config = new Configuration();
        for (int filei = 0; filei < iliFiles.length; ++filei) {
            config.addFileEntry(new FileEntry(iliFiles[filei].getAbsolutePath(), 1));
        }
        config.setGenerateWarnings(false);
        config.setOutputKind(1);
        config.setAutoCompleteModelList(true);
        Settings settings = LauncherView.getIli2cSettings();
        TransferDescription ili2cModel = Main.runCompiler(config, settings);
        if (ili2cModel != null) {
            convert.visitTransferDescription(editor.getModel(), ili2cModel, null, config);
            editor.refreshModel();
            editor.log(convert.getFuncDesc(), rsrc.getString("CIdone"));
        }
    }

    public static void readIlcFile(String ilcFileName) {
        LauncherView editor = LauncherView.getInstance();
        TransferFromIli2cMetamodel convert = new TransferFromIli2cMetamodel();
        Configuration config = null;
        try {
            config = PersistenceService.readConfig(ilcFileName);
        }
        catch (FileNotFoundException ex) {
            EhiLogger.logError(ex);
        }
        catch (IOException ex) {
            EhiLogger.logError(ex);
        }
        config.setOutputKind(1);
        TransferDescription ili2cModel = Main.runCompiler(config);
        if (ili2cModel != null) {
            convert.visitTransferDescription(editor.getModel(), ili2cModel, ilcFileName, config);
            editor.refreshModel();
            editor.log(convert.getFuncDesc(), rsrc.getString("CIdone"));
        }
    }

    public static void readFileset() {
        FileChooser importDialog = new FileChooser(LauncherView.getSettings().getImportDirectory());
        importDialog.setDialogTitle(rsrc.getString("CTfileSelector"));
        GenericFileFilter ilcFilter = LauncherView.createInterlisCompilerFilter();
        importDialog.addChoosableFileFilter(ilcFilter);
        if (importDialog.showOpenDialog(LauncherView.getInstance()) == 0) {
            LauncherView.getSettings().setImportDirectory(importDialog.getCurrentDirectory().getAbsolutePath());
            String newFile = importDialog.getSelectedFile().getAbsolutePath();
            if (ilcFilter.accept(importDialog.getSelectedFile())) {
                ImportInterlis.readIlcFile(newFile);
            } else {
                BaseDialog.showWarning(LauncherView.getInstance(), rsrc.getString("CTunkwFormat"), rsrc.getString("CIunkwFormat"));
            }
        }
    }

    public static void doImport() {
        FileChooser importDialog = new FileChooser(LauncherView.getSettings().getImportDirectory());
        importDialog.setDialogTitle(rsrc.getString("CTfileSelector"));
        importDialog.setMultiSelectionEnabled(true);
        GenericFileFilter iliFilter = LauncherView.createInterlisModelFilter();
        importDialog.addChoosableFileFilter(iliFilter);
        if (importDialog.showOpenDialog(LauncherView.getInstance()) == 0) {
            LauncherView.getSettings().setImportDirectory(importDialog.getCurrentDirectory().getAbsolutePath());
            File[] filev = importDialog.getSelectedFiles();
            ImportInterlis.readIliFile(filev);
        }
    }

    private static void logIliFiles(Configuration config) {
        Iterator filei = config.iteratorFileEntry();
        while (filei.hasNext()) {
            FileEntry file = (FileEntry)filei.next();
            EhiLogger.logState("ilifile <" + file.getFilename() + ">");
        }
    }
}

