/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS;

public class MinimalHTMLWriter
extends AbstractWriter {
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int UNDERLINE = 4;
    private static final CSS css = new CSS();
    private int fontMask = 0;
    int startOffset = 0;
    int endOffset = 0;
    private AttributeSet fontAttributes;
    private Hashtable<String, String> styleNameMapping;

    public MinimalHTMLWriter(Writer w, StyledDocument doc) {
        super(w, doc);
    }

    public MinimalHTMLWriter(Writer w, StyledDocument doc, int pos, int len) {
        super(w, doc, pos, len);
    }

    @Override
    public void write() throws IOException, BadLocationException {
        this.styleNameMapping = new Hashtable();
        this.writeStartTag("<html>");
        this.writeHeader();
        this.writeBody();
        this.writeEndTag("</html>");
    }

    @Override
    protected void writeAttributes(AttributeSet attr) throws IOException {
        Enumeration<?> attributeNames = attr.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object name = attributeNames.nextElement();
            if (!(name instanceof StyleConstants.ParagraphConstants) && !(name instanceof StyleConstants.CharacterConstants) && !(name instanceof StyleConstants.FontConstants) && !(name instanceof StyleConstants.ColorConstants)) continue;
            this.indent();
            this.write(name.toString());
            this.write(':');
            this.write(css.styleConstantsValueToCSSValue((StyleConstants)name, attr.getAttribute(name)).toString());
            this.write(';');
            this.write('\n');
        }
    }

    @Override
    protected void text(Element elem) throws IOException, BadLocationException {
        String contentStr = this.getText(elem);
        if (contentStr.length() > 0 && contentStr.charAt(contentStr.length() - 1) == '\n') {
            contentStr = contentStr.substring(0, contentStr.length() - 1);
        }
        if (contentStr.length() > 0) {
            this.write(contentStr);
        }
    }

    protected void writeStartTag(String tag) throws IOException {
        this.indent();
        this.write(tag);
        this.write('\n');
        this.incrIndent();
    }

    protected void writeEndTag(String endTag) throws IOException {
        this.decrIndent();
        this.indent();
        this.write(endTag);
        this.write('\n');
    }

    protected void writeHeader() throws IOException {
        this.writeStartTag("<head>");
        this.writeStartTag("<style>");
        this.writeStartTag("<!--");
        this.writeStyles();
        this.writeEndTag("-->");
        this.writeEndTag("</style>");
        this.writeEndTag("</head>");
    }

    protected void writeStyles() throws IOException {
        DefaultStyledDocument styledDoc = (DefaultStyledDocument)this.getDocument();
        Enumeration<?> styleNames = styledDoc.getStyleNames();
        while (styleNames.hasMoreElements()) {
            Style s = styledDoc.getStyle((String)styleNames.nextElement());
            if (s.getAttributeCount() == 1 && s.isDefined(StyleConstants.NameAttribute)) continue;
            this.indent();
            this.write("p." + this.addStyleName(s.getName()));
            this.write(" {\n");
            this.incrIndent();
            this.writeAttributes(s);
            this.decrIndent();
            this.indent();
            this.write("}\n");
        }
    }

    protected void writeBody() throws IOException, BadLocationException {
        Element next;
        ElementIterator it = this.getElementIterator();
        it.current();
        this.writeStartTag("<body>");
        boolean inContent = false;
        while ((next = it.next()) != null) {
            if (!this.inRange(next)) continue;
            if (next instanceof AbstractDocument.BranchElement) {
                if (inContent) {
                    this.writeEndParagraph();
                    inContent = false;
                    this.fontMask = 0;
                }
                this.writeStartParagraph(next);
                continue;
            }
            if (this.isText(next)) {
                this.writeContent(next, !inContent);
                inContent = true;
                continue;
            }
            this.writeLeaf(next);
            inContent = true;
        }
        if (inContent) {
            this.writeEndParagraph();
        }
        this.writeEndTag("</body>");
    }

    protected void writeEndParagraph() throws IOException {
        this.writeEndMask(this.fontMask);
        if (this.inFontTag()) {
            this.endSpanTag();
        } else {
            this.write('\n');
        }
        this.writeEndTag("</p>");
    }

    protected void writeStartParagraph(Element elem) throws IOException {
        AttributeSet attr = elem.getAttributes();
        Object resolveAttr = attr.getAttribute(StyleConstants.ResolveAttribute);
        if (resolveAttr instanceof StyleContext.NamedStyle) {
            this.writeStartTag("<p class=" + this.mapStyleName(((StyleContext.NamedStyle)resolveAttr).getName()) + ">");
        } else {
            this.writeStartTag("<p>");
        }
    }

    protected void writeLeaf(Element elem) throws IOException {
        this.indent();
        if (elem.getName() == "icon") {
            this.writeImage(elem);
        } else if (elem.getName() == "component") {
            this.writeComponent(elem);
        }
    }

    protected void writeImage(Element elem) throws IOException {
    }

    protected void writeComponent(Element elem) throws IOException {
    }

    protected boolean isText(Element elem) {
        return elem.getName() == "content";
    }

    protected void writeContent(Element elem, boolean needsIndenting) throws IOException, BadLocationException {
        AttributeSet attr = elem.getAttributes();
        this.writeNonHTMLAttributes(attr);
        if (needsIndenting) {
            this.indent();
        }
        this.writeHTMLTags(attr);
        this.text(elem);
    }

    protected void writeHTMLTags(AttributeSet attr) throws IOException {
        int oldMask = this.fontMask;
        this.setFontMask(attr);
        int endMask = 0;
        int startMask = 0;
        if ((oldMask & 1) != 0) {
            if ((this.fontMask & 1) == 0) {
                endMask |= 1;
            }
        } else if ((this.fontMask & 1) != 0) {
            startMask |= 1;
        }
        if ((oldMask & 2) != 0) {
            if ((this.fontMask & 2) == 0) {
                endMask |= 2;
            }
        } else if ((this.fontMask & 2) != 0) {
            startMask |= 2;
        }
        if ((oldMask & 4) != 0) {
            if ((this.fontMask & 4) == 0) {
                endMask |= 4;
            }
        } else if ((this.fontMask & 4) != 0) {
            startMask |= 4;
        }
        this.writeEndMask(endMask);
        this.writeStartMask(startMask);
    }

    private void setFontMask(AttributeSet attr) {
        if (StyleConstants.isBold(attr)) {
            this.fontMask |= 1;
        }
        if (StyleConstants.isItalic(attr)) {
            this.fontMask |= 2;
        }
        if (StyleConstants.isUnderline(attr)) {
            this.fontMask |= 4;
        }
    }

    private void writeStartMask(int mask) throws IOException {
        if (mask != 0) {
            if ((mask & 4) != 0) {
                this.write("<u>");
            }
            if ((mask & 2) != 0) {
                this.write("<i>");
            }
            if ((mask & 1) != 0) {
                this.write("<b>");
            }
        }
    }

    private void writeEndMask(int mask) throws IOException {
        if (mask != 0) {
            if ((mask & 1) != 0) {
                this.write("</b>");
            }
            if ((mask & 2) != 0) {
                this.write("</i>");
            }
            if ((mask & 4) != 0) {
                this.write("</u>");
            }
        }
    }

    protected void writeNonHTMLAttributes(AttributeSet attr) throws IOException {
        String family;
        Integer size;
        String style = "";
        String separator = "; ";
        if (this.inFontTag() && this.fontAttributes.isEqual(attr)) {
            return;
        }
        boolean first = true;
        Color color = (Color)attr.getAttribute(StyleConstants.Foreground);
        if (color != null) {
            style = style + "color: " + css.styleConstantsValueToCSSValue((StyleConstants)StyleConstants.Foreground, color);
            first = false;
        }
        if ((size = (Integer)attr.getAttribute(StyleConstants.FontSize)) != null) {
            if (!first) {
                style = style + separator;
            }
            style = style + "font-size: " + size + "pt";
            first = false;
        }
        if ((family = (String)attr.getAttribute(StyleConstants.FontFamily)) != null) {
            if (!first) {
                style = style + separator;
            }
            style = style + "font-family: " + family;
            first = false;
        }
        if (style.length() > 0) {
            if (this.fontMask != 0) {
                this.writeEndMask(this.fontMask);
                this.fontMask = 0;
            }
            this.startSpanTag(style);
            this.fontAttributes = attr;
        } else if (this.fontAttributes != null) {
            this.writeEndMask(this.fontMask);
            this.fontMask = 0;
            this.endSpanTag();
        }
    }

    protected boolean inFontTag() {
        return this.fontAttributes != null;
    }

    protected void endFontTag() throws IOException {
        this.write('\n');
        this.writeEndTag("</font>");
        this.fontAttributes = null;
    }

    protected void startFontTag(String style) throws IOException {
        boolean callIndent = false;
        if (this.inFontTag()) {
            this.endFontTag();
            callIndent = true;
        }
        this.writeStartTag("<font style=\"" + style + "\">");
        if (callIndent) {
            this.indent();
        }
    }

    private void startSpanTag(String style) throws IOException {
        boolean callIndent = false;
        if (this.inFontTag()) {
            this.endSpanTag();
            callIndent = true;
        }
        this.writeStartTag("<span style=\"" + style + "\">");
        if (callIndent) {
            this.indent();
        }
    }

    private void endSpanTag() throws IOException {
        this.write('\n');
        this.writeEndTag("</span>");
        this.fontAttributes = null;
    }

    private String addStyleName(String style) {
        String mappedName;
        if (this.styleNameMapping == null) {
            return style;
        }
        StringBuilder sb = null;
        for (int counter = style.length() - 1; counter >= 0; --counter) {
            if (this.isValidCharacter(style.charAt(counter))) continue;
            if (sb == null) {
                sb = new StringBuilder(style);
            }
            sb.setCharAt(counter, 'a');
        }
        String string = mappedName = sb != null ? sb.toString() : style;
        while (this.styleNameMapping.get(mappedName) != null) {
            mappedName = mappedName + 'x';
        }
        this.styleNameMapping.put(style, mappedName);
        return mappedName;
    }

    private String mapStyleName(String style) {
        if (this.styleNameMapping == null) {
            return style;
        }
        String retValue = this.styleNameMapping.get(style);
        return retValue == null ? style : retValue;
    }

    private boolean isValidCharacter(char character) {
        return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z';
    }
}

