/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.VM;

public enum LauncherHelper {
    INSTANCE;

    private static final String MAIN_CLASS = "Main-Class";
    private static StringBuilder outBuf;
    private static final String INDENT = "    ";
    private static final String VM_SETTINGS = "VM settings:";
    private static final String PROP_SETTINGS = "Property settings:";
    private static final String LOCALE_SETTINGS = "Locale settings:";
    private static final String diagprop = "sun.java.launcher.diag";
    static final boolean trace;
    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static final int LM_UNKNOWN = 0;
    private static final int LM_CLASS = 1;
    private static final int LM_JAR = 2;
    private static final String encprop = "sun.jnu.encoding";
    private static String encoding;
    private static boolean isCharsetSupported;

    static void showSettings(boolean printToStderr, String optionFlag, long initialHeapSize, long maxHeapSize, long stackSize, boolean isServer) {
        String optStr;
        PrintStream ostream = printToStderr ? System.err : System.out;
        String[] opts = optionFlag.split(":");
        switch (optStr = opts.length > 1 && opts[1] != null ? opts[1].trim() : "all") {
            case "vm": {
                LauncherHelper.printVmSettings(ostream, initialHeapSize, maxHeapSize, stackSize, isServer);
                break;
            }
            case "properties": {
                LauncherHelper.printProperties(ostream);
                break;
            }
            case "locale": {
                LauncherHelper.printLocale(ostream);
                break;
            }
            default: {
                LauncherHelper.printVmSettings(ostream, initialHeapSize, maxHeapSize, stackSize, isServer);
                LauncherHelper.printProperties(ostream);
                LauncherHelper.printLocale(ostream);
            }
        }
    }

    private static void printVmSettings(PrintStream ostream, long initialHeapSize, long maxHeapSize, long stackSize, boolean isServer) {
        ostream.println(VM_SETTINGS);
        if (stackSize != 0L) {
            ostream.println("    Stack Size: " + SizePrefix.scaleValue(stackSize));
        }
        if (initialHeapSize != 0L) {
            ostream.println("    Min. Heap Size: " + SizePrefix.scaleValue(initialHeapSize));
        }
        if (maxHeapSize != 0L) {
            ostream.println("    Max. Heap Size: " + SizePrefix.scaleValue(maxHeapSize));
        } else {
            ostream.println("    Max. Heap Size (Estimated): " + SizePrefix.scaleValue(Runtime.getRuntime().maxMemory()));
        }
        ostream.println("    Ergonomics Machine Class: " + (isServer ? "server" : "client"));
        ostream.println("    Using VM: " + System.getProperty("java.vm.name"));
        ostream.println();
    }

    private static void printProperties(PrintStream ostream) {
        Properties p = System.getProperties();
        ostream.println(PROP_SETTINGS);
        ArrayList<String> sortedPropertyKeys = new ArrayList<String>();
        sortedPropertyKeys.addAll(p.stringPropertyNames());
        Collections.sort(sortedPropertyKeys);
        for (String x : sortedPropertyKeys) {
            LauncherHelper.printPropertyValue(ostream, x, p.getProperty(x));
        }
        ostream.println();
    }

    private static boolean isPath(String key) {
        return key.endsWith(".dirs") || key.endsWith(".path");
    }

    private static void printPropertyValue(PrintStream ostream, String key, String value) {
        ostream.print(INDENT + key + " = ");
        if (key.equals("line.separator")) {
            block4: for (byte b : value.getBytes()) {
                switch (b) {
                    case 13: {
                        ostream.print("\\r ");
                        continue block4;
                    }
                    case 10: {
                        ostream.print("\\n ");
                        continue block4;
                    }
                    default: {
                        ostream.printf("0x%02X", b & 0xFF);
                    }
                }
            }
            ostream.println();
            return;
        }
        if (!LauncherHelper.isPath(key)) {
            ostream.println(value);
            return;
        }
        String[] values = value.split(System.getProperty("path.separator"));
        boolean first = true;
        for (String s : values) {
            if (first) {
                ostream.println(s);
                first = false;
                continue;
            }
            ostream.println("        " + s);
        }
    }

    private static void printLocale(PrintStream ostream) {
        Locale locale = Locale.getDefault();
        ostream.println(LOCALE_SETTINGS);
        ostream.println("    default locale = " + locale.getDisplayLanguage());
        ostream.println("    default display locale = " + Locale.getDefault(Locale.Category.DISPLAY).getDisplayName());
        ostream.println("    default format locale = " + Locale.getDefault(Locale.Category.FORMAT).getDisplayName());
        LauncherHelper.printLocales(ostream);
        ostream.println();
    }

    private static void printLocales(PrintStream ostream) {
        int len;
        Locale[] tlocales = Locale.getAvailableLocales();
        int n = len = tlocales == null ? 0 : tlocales.length;
        if (len < 1) {
            return;
        }
        TreeSet<String> sortedSet = new TreeSet<String>();
        for (Locale l : tlocales) {
            sortedSet.add(l.toString());
        }
        ostream.print("    available locales = ");
        Iterator iter = sortedSet.iterator();
        int last = len - 1;
        int i = 0;
        while (iter.hasNext()) {
            String s = (String)iter.next();
            ostream.print(s);
            if (i != last) {
                ostream.print(", ");
            }
            if ((i + 1) % 8 == 0) {
                ostream.println();
                ostream.print("        ");
            }
            ++i;
        }
    }

    private static String getLocalizedMessage(String key, Object ... args) {
        String msg = ResourceBundleHolder.RB.getString(key);
        return args != null ? MessageFormat.format(msg, args) : msg;
    }

    static void initHelpMessage(String progname) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.header", progname == null ? "java" : progname));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 32));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 64));
    }

    static void appendVmSelectMessage(String vm1, String vm2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.vmselect", vm1, vm2));
    }

    static void appendVmSynonymMessage(String vm1, String vm2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.hotspot", vm1, vm2));
    }

    static void appendVmErgoMessage(boolean isServerClass, String vm) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.ergo.message1", vm));
        outBuf = isServerClass ? outBuf.append(",\n" + LauncherHelper.getLocalizedMessage("java.launcher.ergo.message2", new Object[0]) + "\n\n") : outBuf.append(".\n\n");
    }

    static void printHelpMessage(boolean printToStderr) {
        PrintStream ostream = printToStderr ? System.err : System.out;
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.footer", File.pathSeparator));
        ostream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean printToStderr) {
        PrintStream ostream = printToStderr ? System.err : System.out;
        ostream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.usage", File.pathSeparator));
        if (System.getProperty("os.name").contains("OS X")) {
            ostream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.macosx.usage", File.pathSeparator));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassFromJar(PrintStream ostream, String jarname) {
        String string;
        block9: {
            JarFile jarFile = null;
            try {
                String mainValue;
                Attributes mainAttrs;
                jarFile = new JarFile(jarname);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    LauncherHelper.abort(ostream, null, "java.launcher.jar.error2", jarname);
                }
                if ((mainAttrs = manifest.getMainAttributes()) == null) {
                    LauncherHelper.abort(ostream, null, "java.launcher.jar.error3", jarname);
                }
                if ((mainValue = mainAttrs.getValue(MAIN_CLASS)) == null) {
                    LauncherHelper.abort(ostream, null, "java.launcher.jar.error3", jarname);
                }
                string = mainValue.trim();
                if (jarFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    LauncherHelper.abort(ostream, ioe, "java.launcher.jar.error1", jarname);
                    return null;
                }
            }
            jarFile.close();
        }
        return string;
    }

    static void abort(PrintStream ostream, Throwable t, String msgKey, Object ... args) {
        if (msgKey != null) {
            ostream.println(LauncherHelper.getLocalizedMessage(msgKey, args));
        }
        if (trace) {
            if (t != null) {
                t.printStackTrace();
            } else {
                Thread.dumpStack();
            }
        }
        System.exit(1);
    }

    public static Class<?> checkAndLoadMain(boolean printToStderr, int mode, String what) {
        PrintStream ostream = printToStderr ? System.err : System.out;
        ClassLoader ld = ClassLoader.getSystemClassLoader();
        String cn = null;
        switch (mode) {
            case 1: {
                cn = what;
                break;
            }
            case 2: {
                cn = LauncherHelper.getMainClassFromJar(ostream, what);
                break;
            }
            default: {
                throw new InternalError("" + mode + ": Unknown launch mode");
            }
        }
        cn = cn.replace('/', '.');
        Class<?> c = null;
        try {
            c = ld.loadClass(cn);
        }
        catch (ClassNotFoundException cnfe) {
            LauncherHelper.abort(ostream, cnfe, "java.launcher.cls.error1", cn);
        }
        LauncherHelper.getMainMethod(ostream, c);
        return c;
    }

    static Method getMainMethod(PrintStream ostream, Class<?> clazz) {
        String classname = clazz.getName();
        Method method = null;
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException nsme) {
            LauncherHelper.abort(ostream, null, "java.launcher.cls.error4", classname);
        }
        int mod = method.getModifiers();
        if (!Modifier.isStatic(mod)) {
            LauncherHelper.abort(ostream, null, "java.launcher.cls.error2", "static", classname);
        }
        if (method.getReturnType() != Void.TYPE) {
            LauncherHelper.abort(ostream, null, "java.launcher.cls.error3", classname);
        }
        return method;
    }

    static String makePlatformString(boolean printToStderr, byte[] inArray) {
        PrintStream ostream;
        PrintStream printStream = ostream = printToStderr ? System.err : System.out;
        if (encoding == null) {
            encoding = System.getProperty(encprop);
            isCharsetSupported = Charset.isSupported(encoding);
        }
        try {
            String out = isCharsetSupported ? new String(inArray, encoding) : new String(inArray);
            return out;
        }
        catch (UnsupportedEncodingException uee) {
            LauncherHelper.abort(ostream, uee, null, new Object[0]);
            return null;
        }
    }

    static String[] expandArgs(String[] argArray) {
        ArrayList<StdArg> aList = new ArrayList<StdArg>();
        for (String x : argArray) {
            aList.add(new StdArg(x));
        }
        return LauncherHelper.expandArgs(aList);
    }

    static String[] expandArgs(List<StdArg> argList) {
        ArrayList<String> out = new ArrayList<String>();
        if (trace) {
            System.err.println("Incoming arguments:");
        }
        for (StdArg a : argList) {
            if (trace) {
                System.err.println(a);
            }
            if (a.needsExpansion) {
                File x = new File(a.arg);
                File parent = x.getParentFile();
                String glob = x.getName();
                if (parent == null) {
                    parent = new File(".");
                }
                try {
                    DirectoryStream<Path> dstream = Files.newDirectoryStream(parent.toPath(), glob);
                    Throwable throwable = null;
                    try {
                        int entries = 0;
                        for (Path p : dstream) {
                            out.add(p.normalize().toString());
                            ++entries;
                        }
                        if (entries != 0) continue;
                        out.add(a.arg);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dstream == null) continue;
                        if (throwable != null) {
                            try {
                                dstream.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        dstream.close();
                    }
                }
                catch (Exception e) {
                    out.add(a.arg);
                    if (!trace) continue;
                    System.err.println("Warning: passing argument as-is " + a);
                    System.err.print(e);
                }
                continue;
            }
            out.add(a.arg);
        }
        String[] oarray = new String[out.size()];
        out.toArray(oarray);
        if (trace) {
            System.err.println("Expanded arguments:");
            for (String x : oarray) {
                System.err.println(x);
            }
        }
        return oarray;
    }

    static {
        outBuf = new StringBuilder();
        trace = VM.getSavedProperty(diagprop) != null;
        encoding = null;
        isCharsetSupported = false;
    }

    private static class StdArg {
        final String arg;
        final boolean needsExpansion;

        StdArg(String arg, boolean expand) {
            this.arg = arg;
            this.needsExpansion = expand;
        }

        StdArg(String in) {
            this.arg = in.substring(1);
            this.needsExpansion = in.charAt(0) == 'T';
        }

        public String toString() {
            return "StdArg{arg=" + this.arg + ", needsExpansion=" + this.needsExpansion + '}';
        }
    }

    private static enum SizePrefix {
        KILO(1024L, "K"),
        MEGA(0x100000L, "M"),
        GIGA(0x40000000L, "G"),
        TERA(0x10000000000L, "T");

        long size;
        String abbrev;

        private SizePrefix(long size, String abbrev) {
            this.size = size;
            this.abbrev = abbrev;
        }

        private static String scale(long v, SizePrefix prefix) {
            return BigDecimal.valueOf(v).divide(BigDecimal.valueOf(prefix.size), 2, RoundingMode.HALF_EVEN).toPlainString() + prefix.abbrev;
        }

        static String scaleValue(long v) {
            if (v < SizePrefix.MEGA.size) {
                return SizePrefix.scale(v, KILO);
            }
            if (v < SizePrefix.GIGA.size) {
                return SizePrefix.scale(v, MEGA);
            }
            if (v < SizePrefix.TERA.size) {
                return SizePrefix.scale(v, GIGA);
            }
            return SizePrefix.scale(v, TERA);
        }
    }

    private static class ResourceBundleHolder {
        private static final ResourceBundle RB = ResourceBundle.getBundle("sun.launcher.resources.launcher");

        private ResourceBundleHolder() {
        }
    }
}

