/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncStateMachine;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.ErrorState;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProcessor<S>
implements ActionHook,
Processor<S> {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote");
    protected Adapter adapter;
    protected AsyncStateMachine<S> asyncStateMachine;
    protected AbstractEndpoint<S> endpoint;
    protected Request request;
    protected Response response;
    protected SocketWrapper<S> socketWrapper = null;
    private int maxCookieCount = 200;
    private ErrorState errorState = ErrorState.NONE;

    protected AbstractProcessor() {
    }

    public AbstractProcessor(AbstractEndpoint<S> endpoint) {
        this.endpoint = endpoint;
        this.asyncStateMachine = new AsyncStateMachine(this);
        this.request = new Request();
        this.response = new Response();
        this.response.setHook(this);
        this.request.setResponse(this.response);
    }

    protected void setErrorState(ErrorState errorState, Throwable t) {
        boolean blockIo = this.errorState.isIoAllowed() && !errorState.isIoAllowed();
        this.errorState = this.errorState.getMostSevere(errorState);
        if (blockIo && !ContainerThreadMarker.isContainerThread() && this.isAsync()) {
            if (this.response.getStatus() < 400) {
                this.response.setStatus(500);
            }
            this.getLog().info((Object)sm.getString("abstractProcessor.nonContainerThreadError"), t);
            this.getEndpoint().processSocketAsync(this.socketWrapper, SocketStatus.CLOSE_NOW);
        }
    }

    protected void resetErrorState() {
        this.errorState = ErrorState.NONE;
    }

    protected ErrorState getErrorState() {
        return this.errorState;
    }

    protected AbstractEndpoint<S> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected final void setSocketWrapper(SocketWrapper<S> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    protected final SocketWrapper<S> getSocketWrapper() {
        return this.socketWrapper;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    @Override
    public boolean isAsync() {
        return this.asyncStateMachine != null && this.asyncStateMachine.isAsync();
    }

    @Override
    public AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        return this.asyncStateMachine.asyncPostProcess();
    }

    @Override
    public void errorDispatch() {
        this.getAdapter().errorDispatch(this.request, this.response);
    }

    @Override
    public abstract boolean isComet();

    @Override
    public abstract boolean isUpgrade();

    @Override
    public abstract AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> var1) throws IOException;

    @Override
    public abstract AbstractEndpoint.Handler.SocketState event(SocketStatus var1) throws IOException;

    @Override
    public abstract AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus var1);

    @Override
    public abstract AbstractEndpoint.Handler.SocketState upgradeDispatch() throws IOException;

    public int getMaxCookieCount() {
        return this.maxCookieCount;
    }

    public void setMaxCookieCount(int maxCookieCount) {
        this.maxCookieCount = maxCookieCount;
    }

    @Override
    @Deprecated
    public abstract UpgradeInbound getUpgradeInbound();

    protected abstract Log getLog();
}

