/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class WeightFactorFunction
extends ScoreFunction {
    private static final ScoreFunction SCORE_ONE = new ScoreOne(CombineFunction.MULT);
    private final ScoreFunction scoreFunction;
    private float weight = 1.0f;

    public WeightFactorFunction(float weight, ScoreFunction scoreFunction) {
        super(CombineFunction.MULT);
        if (scoreFunction instanceof BoostScoreFunction) {
            throw new IllegalArgumentException("'boost_factor' and 'weight' cannot be used together. Use 'weight'.");
        }
        this.scoreFunction = scoreFunction == null ? SCORE_ONE : scoreFunction;
        this.weight = weight;
    }

    public WeightFactorFunction(float weight) {
        super(CombineFunction.MULT);
        this.scoreFunction = SCORE_ONE;
        this.weight = weight;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final LeafScoreFunction leafFunction = this.scoreFunction.getLeafScoreFunction(ctx);
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) {
                return leafFunction.score(docId, subQueryScore) * (double)WeightFactorFunction.this.getWeight();
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                Explanation functionExplanation = leafFunction.explainScore(docId, subQueryScore);
                return Explanation.match((float)(functionExplanation.getValue() * WeightFactorFunction.this.getWeight()), (String)"product of:", (Explanation[])new Explanation[]{functionExplanation, WeightFactorFunction.this.explainWeight()});
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    public Explanation explainWeight() {
        return Explanation.match((float)this.getWeight(), (String)"weight", (Explanation[])new Explanation[0]);
    }

    public float getWeight() {
        return this.weight;
    }

    private static class ScoreOne
    extends ScoreFunction {
        protected ScoreOne(CombineFunction scoreCombiner) {
            super(scoreCombiner);
        }

        @Override
        public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) {
            return new LeafScoreFunction(){

                @Override
                public double score(int docId, float subQueryScore) {
                    return 1.0;
                }

                @Override
                public Explanation explainScore(int docId, Explanation subQueryScore) {
                    return Explanation.match((float)1.0f, (String)"constant score 1.0 - no function provided", (Explanation[])new Explanation[0]);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }
    }
}

