/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter.condition;

import freemind.controller.Controller;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.ConditionFactory;
import freemind.controller.filter.condition.NodeCondition;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.NodeAttributeTableModel;

public class AttributeNotExistsCondition
extends NodeCondition {
    static final String ATTRIBUTE = "attribute";
    static final String NAME = "attribute_not_exists_condition";
    private String attribute;

    public AttributeNotExistsCondition(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean checkNode(Controller c, MindMapNode node) {
        NodeAttributeTableModel attributes = node.getAttributes();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save(XMLElement element) {
        XMLElement child = new XMLElement();
        child.setName(NAME);
        super.saveAttributes(child);
        child.setAttribute(ATTRIBUTE, this.attribute);
        element.addChild(child);
    }

    static Condition load(XMLElement element) {
        return new AttributeNotExistsCondition(element.getStringAttribute(ATTRIBUTE));
    }

    @Override
    protected String createDesctiption() {
        String simpleCondition = Resources.getInstance().getResourceString("filter_does_not_exist");
        return ConditionFactory.createDescription(this.attribute, simpleCondition, null, false);
    }
}

