/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.util.Vector;
import org.gjt.sp.jedit.bsh.InterpreterError;
import org.gjt.sp.jedit.bsh.NameSpace;

public class CallStack {
    private Vector<NameSpace> stack = new Vector(2);

    public CallStack() {
    }

    public CallStack(NameSpace nameSpace) {
        this.push(nameSpace);
    }

    public void clear() {
        this.stack.removeAllElements();
    }

    public void push(NameSpace nameSpace) {
        this.stack.insertElementAt(nameSpace, 0);
    }

    public NameSpace top() {
        return this.get(0);
    }

    public NameSpace get(int n) {
        if (n >= this.depth()) {
            return NameSpace.JAVACODE;
        }
        return this.stack.elementAt(n);
    }

    public void set(int n, NameSpace nameSpace) {
        this.stack.setElementAt(nameSpace, n);
    }

    public NameSpace pop() {
        if (this.depth() < 1) {
            throw new InterpreterError("pop on empty CallStack");
        }
        NameSpace nameSpace = this.top();
        this.stack.removeElementAt(0);
        return nameSpace;
    }

    public NameSpace swap(NameSpace nameSpace) {
        NameSpace nameSpace2 = this.stack.elementAt(0);
        this.stack.setElementAt(nameSpace, 0);
        return nameSpace2;
    }

    public int depth() {
        return this.stack.size();
    }

    public NameSpace[] toArray() {
        Object[] objectArray = new NameSpace[this.depth()];
        this.stack.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CallStack:\n");
        NameSpace[] nameSpaceArray = this.toArray();
        for (int i = 0; i < nameSpaceArray.length; ++i) {
            stringBuilder.append("\t" + nameSpaceArray[i] + "\n");
        }
        return stringBuilder.toString();
    }

    public CallStack copy() {
        CallStack callStack = new CallStack();
        callStack.stack = (Vector)this.stack.clone();
        return callStack;
    }
}

