/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;

public final class ProbeNode
extends Node {
    private final InstrumentationHandler handler;
    private final EventContext context;
    @Node.Child
    private volatile EventChainNode chain;
    @CompilerDirectives.CompilationFinal
    private volatile Assumption version;

    ProbeNode(InstrumentationHandler handler, SourceSection sourceSection) {
        this.handler = handler;
        this.context = new EventContext(this, sourceSection);
    }

    public void onEnter(VirtualFrame frame) {
        EventChainNode localChain = this.lazyUpdate(frame);
        if (localChain != null) {
            localChain.onEnter(this.context, frame);
        }
    }

    public void onReturnValue(VirtualFrame frame, Object result) {
        EventChainNode localChain = this.lazyUpdate(frame);
        if (localChain != null) {
            localChain.onReturnValue(this.context, frame, result);
        }
    }

    public void onReturnExceptional(VirtualFrame frame, Throwable exception) {
        if (exception instanceof ThreadDeath) {
            throw (ThreadDeath)exception;
        }
        EventChainNode localChain = this.lazyUpdate(frame);
        if (localChain != null) {
            localChain.onReturnExceptional(this.context, frame, exception);
        }
    }

    EventContext getContext() {
        return this.context;
    }

    InstrumentableFactory.WrapperNode findWrapper() throws AssertionError {
        Node parent = this.getParent();
        if (!(parent instanceof InstrumentableFactory.WrapperNode)) {
            if (parent == null) {
                throw new AssertionError((Object)"Probe node disconnected from AST.");
            }
            throw new AssertionError((Object)"ProbeNodes must have a parent Node that implements NodeWrapper.");
        }
        return (InstrumentableFactory.WrapperNode)((Object)parent);
    }

    synchronized void invalidate() {
        Assumption localVersion = this.version;
        if (localVersion != null) {
            localVersion.invalidate();
        }
    }

    private EventChainNode lazyUpdate(VirtualFrame frame) {
        Assumption localVersion = this.version;
        if (localVersion == null || !localVersion.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.lazyUpdatedImpl(frame);
        }
        return this.chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventChainNode lazyUpdatedImpl(VirtualFrame frame) {
        EventChainNode oldChain;
        EventChainNode nextChain = this.handler.createBindings(this);
        if (nextChain == null) {
            InstrumentationHandler.removeWrapper(this);
            return null;
        }
        ProbeNode probeNode = this;
        synchronized (probeNode) {
            oldChain = this.chain;
            this.chain = this.insert(nextChain);
            this.version = Truffle.getRuntime().createAssumption("Instruments unchanged");
        }
        if (oldChain != null) {
            oldChain.onDispose(this.context, frame);
        }
        return nextChain;
    }

    EventChainNode createEventChainCallback(EventBinding<?> binding) {
        EventChainNode next;
        Object element = binding.getElement();
        if (element instanceof ExecutionEventListener) {
            next = new EventFilterChainNode(binding, (ExecutionEventListener)element);
        } else {
            assert (element instanceof ExecutionEventNodeFactory);
            ExecutionEventNode eventNode = this.createEventNode(binding, element);
            if (eventNode == null) {
                return null;
            }
            next = new EventProviderChainNode(binding, eventNode);
        }
        return next;
    }

    private ExecutionEventNode createEventNode(EventBinding<?> binding, Object element) {
        ExecutionEventNode eventNode;
        try {
            eventNode = ((ExecutionEventNodeFactory)element).create(this.context);
            if (eventNode.getParent() != null) {
                throw new IllegalStateException(String.format("Returned EventNode %s was already adopted by another AST.", eventNode));
            }
        }
        catch (Throwable t) {
            if (binding.isLanguageBinding()) {
                throw t;
            }
            ProbeNode.exceptionEventForClientInstrument(binding, "ProbeNodeFactory.create", t);
            return null;
        }
        return eventNode;
    }

    @CompilerDirectives.TruffleBoundary
    static void exceptionEventForClientInstrument(EventBinding<?> b, String eventName, Throwable t) {
        assert (!b.isLanguageBinding());
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        InstrumentationHandler.InstrumentClientInstrumenter instrumenter = (InstrumentationHandler.InstrumentClientInstrumenter)b.getInstrumenter();
        Class<?> instrumentClass = instrumenter.getInstrumentClass();
        String message = String.format("Event %s failed for instrument class %s and listener/factory %s.", eventName, instrumentClass.getName(), b.getElement());
        Exception exception = new Exception(message, t);
        PrintStream stream = new PrintStream(instrumenter.getEnv().err());
        exception.printStackTrace(stream);
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    private static class EventProviderChainNode
    extends EventChainNode {
        @Node.Child
        private ExecutionEventNode eventNode;

        EventProviderChainNode(EventBinding<?> binding, ExecutionEventNode eventNode) {
            super(binding);
            this.eventNode = eventNode;
        }

        @Override
        protected void innerOnEnter(EventContext context, VirtualFrame frame) {
            this.eventNode.onEnter(frame);
        }

        @Override
        protected void innerOnReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            this.eventNode.onReturnExceptional(frame, exception);
        }

        @Override
        protected void innerOnReturnValue(EventContext context, VirtualFrame frame, Object result) {
            this.eventNode.onReturnValue(frame, result);
        }

        @Override
        protected void innerOnDispose(EventContext context, VirtualFrame frame) {
            this.eventNode.onDispose(frame);
        }
    }

    private static class EventFilterChainNode
    extends EventChainNode {
        private final ExecutionEventListener listener;

        EventFilterChainNode(EventBinding<?> binding, ExecutionEventListener listener) {
            super(binding);
            this.listener = listener;
        }

        @Override
        protected void innerOnEnter(EventContext context, VirtualFrame frame) {
            this.listener.onEnter(context, frame);
        }

        @Override
        protected void innerOnReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            this.listener.onReturnExceptional(context, frame, exception);
        }

        @Override
        protected void innerOnReturnValue(EventContext context, VirtualFrame frame, Object result) {
            this.listener.onReturnValue(context, frame, result);
        }

        @Override
        protected void innerOnDispose(EventContext context, VirtualFrame frame) {
        }
    }

    static abstract class EventChainNode
    extends Node {
        @Node.Child
        private EventChainNode next;
        private final EventBinding<?> binding;
        @CompilerDirectives.CompilationFinal
        private boolean seenException;

        EventChainNode(EventBinding<?> binding) {
            this.binding = binding;
        }

        final void setNext(EventChainNode next) {
            this.next = this.insert(next);
        }

        EventBinding<?> getBinding() {
            return this.binding;
        }

        EventChainNode getNext() {
            return this.next;
        }

        @Override
        public final NodeCost getCost() {
            return NodeCost.NONE;
        }

        final void onDispose(EventContext context, VirtualFrame frame) {
            try {
                this.innerOnDispose(context, frame);
            }
            catch (Throwable t) {
                if (!this.seenException) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenException = true;
                }
                if (this.binding.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onEnter", t);
            }
            if (this.next != null) {
                this.next.onDispose(context, frame);
            }
        }

        protected abstract void innerOnDispose(EventContext var1, VirtualFrame var2);

        final void onEnter(EventContext context, VirtualFrame frame) {
            try {
                this.innerOnEnter(context, frame);
            }
            catch (Throwable t) {
                if (!this.seenException) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenException = true;
                }
                if (this.binding.isLanguageBinding()) {
                    throw t;
                }
                CompilerDirectives.transferToInterpreter();
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onEnter", t);
            }
            if (this.next != null) {
                this.next.onEnter(context, frame);
            }
        }

        protected abstract void innerOnEnter(EventContext var1, VirtualFrame var2);

        final void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
            try {
                this.innerOnReturnValue(context, frame, result);
            }
            catch (Throwable t) {
                if (!this.seenException) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenException = true;
                }
                if (this.binding.isLanguageBinding()) {
                    throw t;
                }
                CompilerDirectives.transferToInterpreter();
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onReturnValue", t);
            }
            if (this.next != null) {
                this.next.onReturnValue(context, frame, result);
            }
        }

        protected abstract void innerOnReturnValue(EventContext var1, VirtualFrame var2, Object var3);

        final void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            try {
                this.innerOnReturnExceptional(context, frame, exception);
            }
            catch (Throwable t) {
                if (!this.seenException) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenException = true;
                }
                if (this.binding.isLanguageBinding()) {
                    exception.addSuppressed(t);
                }
                CompilerDirectives.transferToInterpreter();
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onReturnExceptional", t);
            }
            if (this.next != null) {
                this.next.onReturnExceptional(context, frame, exception);
            }
        }

        protected abstract void innerOnReturnExceptional(EventContext var1, VirtualFrame var2, Throwable var3);
    }
}

