/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.extra;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.platform.graal.Graal;

@CoreClass(value="Truffle::Graal")
public abstract class TruffleGraalNodes {

    @CoreMethod(names={"version"}, onSingleton=true)
    public static abstract class GraalVersionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject graalVersion() {
            return this.createString(StringOperations.encodeRope(Graal.getVersion(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"substrate?"}, onSingleton=true)
    public static abstract class SubstrateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean substrate() {
            return TruffleOptions.AOT;
        }
    }

    @CoreMethod(names={"graal?"}, onSingleton=true)
    public static abstract class GraalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean graal() {
            return Graal.isGraal();
        }
    }

    @CoreMethod(names={"assert_not_compiled"}, onSingleton=true)
    public static abstract class AssertNotCompiledNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject assertNotCompiled() {
            throw new RaiseException(this.coreExceptions().runtimeErrorCompiled(this));
        }
    }

    @CoreMethod(names={"assert_constant"}, onSingleton=true, required=1)
    public static abstract class AssertConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject assertConstant(Object value) {
            throw new RaiseException(this.coreExceptions().runtimeErrorNotConstant(this));
        }
    }
}

