/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions;

import com.google.common.collect.Lists;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.LongOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.NumberAndCharConversionFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.PrimitiveBinaryOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.PrimitiveUnaryOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ProgressionCompanionFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.StringOperationFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;

public final class FunctionIntrinsics {
    @NotNull
    private final Map<FunctionDescriptor, FunctionIntrinsic> intrinsicCache = new THashMap<FunctionDescriptor, FunctionIntrinsic>();
    @NotNull
    private final List<FunctionIntrinsicFactory> factories = Lists.newArrayList();

    public FunctionIntrinsics() {
        this.registerFactories();
    }

    private void registerFactories() {
        this.register(LongOperationFIF.INSTANCE);
        this.register(PrimitiveUnaryOperationFIF.INSTANCE);
        this.register(PrimitiveBinaryOperationFIF.INSTANCE);
        this.register(StringOperationFIF.INSTANCE);
        this.register(ArrayFIF.INSTANCE);
        this.register(TopLevelFIF.INSTANCE);
        this.register(NumberAndCharConversionFIF.INSTANCE);
        this.register(ProgressionCompanionFIF.INSTANCE);
    }

    private void register(@NotNull FunctionIntrinsicFactory instance) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "register"));
        }
        this.factories.add(instance);
    }

    @NotNull
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "getIntrinsic"));
        }
        FunctionIntrinsic intrinsic = this.lookUpCache(descriptor2);
        if (intrinsic != null) {
            FunctionIntrinsic functionIntrinsic = intrinsic;
            if (functionIntrinsic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "getIntrinsic"));
            }
            return functionIntrinsic;
        }
        FunctionIntrinsic functionIntrinsic = intrinsic = this.computeAndCacheIntrinsic(descriptor2);
        if (functionIntrinsic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "getIntrinsic"));
        }
        return functionIntrinsic;
    }

    @Nullable
    private FunctionIntrinsic lookUpCache(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "lookUpCache"));
        }
        return this.intrinsicCache.get(descriptor2);
    }

    @NotNull
    private FunctionIntrinsic computeAndCacheIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "computeAndCacheIntrinsic"));
        }
        FunctionIntrinsic result2 = this.computeIntrinsic(descriptor2);
        this.intrinsicCache.put(descriptor2, result2);
        FunctionIntrinsic functionIntrinsic = result2;
        if (functionIntrinsic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "computeAndCacheIntrinsic"));
        }
        return functionIntrinsic;
    }

    @NotNull
    private FunctionIntrinsic computeIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "computeIntrinsic"));
        }
        for (FunctionIntrinsicFactory factory : this.factories) {
            FunctionIntrinsic intrinsic = factory.getIntrinsic(descriptor2);
            if (intrinsic == null) continue;
            FunctionIntrinsic functionIntrinsic = intrinsic;
            if (functionIntrinsic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "computeIntrinsic"));
            }
            return functionIntrinsic;
        }
        FunctionIntrinsic functionIntrinsic = FunctionIntrinsic.NO_INTRINSIC;
        if (functionIntrinsic == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/FunctionIntrinsics", "computeIntrinsic"));
        }
        return functionIntrinsic;
    }
}

