/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Viewable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractClassDef<E extends Element>
extends Viewable<E> {
    private Domain oid = null;
    private final Set<RoleDef> targetForRoles = new HashSet<RoleDef>(2);

    public void addTargetForRole(RoleDef role) {
        AssociationDef assoc = (AssociationDef)role.getContainer();
        RoleDef rootRole = role.getRootExtending();
        if (rootRole == null) {
            rootRole = role;
        }
        Iterator<Element> iter = assoc.getAttributesAndRoles();
        while (iter.hasNext()) {
            RoleDef otherRole;
            Element obj = iter.next();
            if (!(obj instanceof RoleDef) || (otherRole = (RoleDef)obj) == role) continue;
            AbstractClassDef targetClass = otherRole.getDestination();
            Iterator<Element> attri = targetClass.getAttributesAndRoles();
            while (attri.hasNext()) {
                Element attrOrRole = attri.next();
                if (!attrOrRole.getName().equals(role.getName())) continue;
                throw new Ili2cSemanticException(role.getSourceLine(), AbstractClassDef.formatMessage("err_abstractClassDef_nameConflictInOtherRoleTarget", role.getName(), otherRole.getName(), targetClass.getName()));
            }
            Iterator<RoleDef> rolei = targetClass.getOpposideRoles();
            while (rolei.hasNext()) {
                RoleDef targetOppRole = rolei.next();
                RoleDef rootTargetOppRole = targetOppRole.getRootExtending();
                if (rootTargetOppRole == null) {
                    rootTargetOppRole = targetOppRole;
                }
                if (!targetOppRole.getName().equals(role.getName()) || rootRole == rootTargetOppRole) continue;
                throw new Ili2cSemanticException(role.getSourceLine(), AbstractClassDef.formatMessage("err_abstractClassDef_nameConflictInOtherRoleTarget", role.getName(), otherRole.getName(), targetClass.getName()));
            }
        }
        this.targetForRoles.add(role);
    }

    public Iterator<RoleDef> getDefinedTargetForRoles() {
        return this.targetForRoles.iterator();
    }

    public Iterator<RoleDef> getTargetForRoles() {
        LinkedList result = new LinkedList();
        HashMap<RoleDef, RoleDef> mostDerived = new HashMap<RoleDef, RoleDef>();
        for (AbstractClassDef v = this; v != null; v = (AbstractClassDef)v.getRealExtending()) {
            LinkedList attrsOfV_reversed = new LinkedList();
            Iterator<RoleDef> iter = v.getDefinedTargetForRoles();
            while (iter.hasNext()) {
                RoleDef role;
                Extendable leastDerived = role = iter.next();
                Extendable leastDerivedParent = null;
                while ((leastDerivedParent = (Extendable)((Object)leastDerived.getRealExtending())) != null) {
                    leastDerived = leastDerivedParent;
                }
                if (!mostDerived.containsKey(leastDerived)) {
                    mostDerived.put((RoleDef)leastDerived, role);
                }
                if (role != leastDerived) continue;
                attrsOfV_reversed.add(0, mostDerived.get(role));
            }
            Iterator attrsOfV_iter = attrsOfV_reversed.iterator();
            while (attrsOfV_iter.hasNext()) {
                result.add(0, attrsOfV_iter.next());
            }
        }
        return result.iterator();
    }

    public Iterator<RoleDef> getOpposideRoles() {
        ArrayList<RoleDef> result = new ArrayList<RoleDef>();
        Iterator<RoleDef> rolei = this.getTargetForRoles();
        while (rolei.hasNext()) {
            RoleDef role = rolei.next();
            AssociationDef assoc = (AssociationDef)role.getContainer();
            Iterator<Element> iter = assoc.getAttributesAndRoles();
            while (iter.hasNext()) {
                Element oppRole = iter.next();
                if (!(oppRole instanceof RoleDef) || oppRole == role) continue;
                result.add((RoleDef)oppRole);
            }
        }
        return result.iterator();
    }

    public RoleDef findOpposideRole(String roleName) {
        if (roleName == null) {
            return null;
        }
        Iterator<RoleDef> it = this.getOpposideRoles();
        while (it.hasNext()) {
            RoleDef e = it.next();
            if (!roleName.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    public List<RoleDef> getDefinedLightweightAssociations() {
        ArrayList<RoleDef> assocv = new ArrayList<RoleDef>();
        Iterator<RoleDef> it = this.getDefinedTargetForRoles();
        while (it.hasNext()) {
            RoleDef e = it.next();
            if (!e.isAssociationEmbedded()) continue;
            assocv.add(e);
        }
        return assocv;
    }

    public List<RoleDef> getLightweightAssociations() {
        ArrayList<RoleDef> assocv = new ArrayList<RoleDef>();
        Iterator<RoleDef> it = this.getTargetForRoles();
        while (it.hasNext()) {
            RoleDef e = it.next();
            if (!e.isAssociationEmbedded()) continue;
            assocv.add(e);
        }
        return assocv;
    }

    public Domain getOid() {
        return this.oid;
    }

    public void setOid(Domain oid) {
        this.oid = oid;
    }
}

