/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.IndexCacheableQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.search.internal.SearchContext;

@Deprecated
@SuppressForbidden(reason="Old p/c queries still use filters")
public class ParentQuery
extends IndexCacheableQuery {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query parentQuery;
    private final String parentType;
    private final Filter childrenFilter;

    public ParentQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query parentQuery, String parentType, Filter childrenFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.parentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ParentQuery that = (ParentQuery)((Object)obj);
        if (!this.parentQuery.equals((Object)that.parentQuery)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.parentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public String toString(String field) {
        return "ParentQuery[" + this.parentType + "](" + this.parentQuery.toString(field) + ')' + ToStringUtils.boost((float)this.getBoost());
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewritten = this.parentQuery.rewrite(reader);
        if (parentRewritten != this.parentQuery) {
            ParentQuery rewritten = new ParentQuery(this.parentChildIndexFieldData, parentRewritten, this.parentType, this.childrenFilter);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return super.rewrite(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Weight doCreateWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        block7: {
            block8: {
                if (searcher.getIndexReader().numDocs() == 0) {
                    return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
                }
                sc = SearchContext.current();
                releaseCollectorResource = true;
                collector = null;
                globalIfd = this.parentChildIndexFieldData.loadGlobal((DirectoryReader)searcher.getIndexReader());
                if (globalIfd == null) {
                    return new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
                }
                try {
                    collector = new ParentOrdAndScoreCollector(sc, globalIfd, this.parentType);
                    searcher.search(this.parentQuery, (Collector)collector);
                    if (collector.parentCount() != 0L) break block7;
                    var8_7 = new BooleanQuery.Builder().build().createWeight(searcher, needsScores);
                    if (!releaseCollectorResource) break block8;
                }
                catch (Throwable var9_9) {
                    if (releaseCollectorResource) {
                        Releasables.close(new Releasable[]{collector});
                    }
                    throw var9_9;
                }
                Releasables.close(new Releasable[]{collector});
            }
            return var8_7;
        }
        childWeight = new ChildWeight(this, this.parentQuery.createWeight(searcher, needsScores), this.childrenFilter, collector, globalIfd);
        releaseCollectorResource = false;
        ** if (!releaseCollectorResource) goto lbl29
lbl-1000:
        // 1 sources

        {
            Releasables.close(new Releasable[]{collector});
        }
        {
        }
lbl29:
        // 2 sources

        sc.addReleasable(collector, SearchContext.Lifetime.COLLECTION);
        return childWeight;
    }

    private static class ChildScorer
    extends Scorer {
        private final LongHash parentIdxs;
        private final FloatArray scores;
        private final DocIdSetIterator childrenIterator;
        private final SortedDocValues ordinals;
        private int currentChildDoc = -1;
        private float currentScore;

        ChildScorer(Weight weight, LongHash parentIdxs, FloatArray scores, DocIdSetIterator childrenIterator, SortedDocValues ordinals) {
            super(weight);
            this.parentIdxs = parentIdxs;
            this.scores = scores;
            this.childrenIterator = childrenIterator;
            this.ordinals = ordinals;
        }

        public float score() throws IOException {
            return this.currentScore;
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentChildDoc;
        }

        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                public int docID() {
                    return ChildScorer.this.currentChildDoc;
                }

                public int nextDoc() throws IOException {
                    long parentIdx;
                    int globalOrdinal;
                    do {
                        ChildScorer.this.currentChildDoc = ChildScorer.this.childrenIterator.nextDoc();
                        if (ChildScorer.this.currentChildDoc != Integer.MAX_VALUE) continue;
                        return ChildScorer.this.currentChildDoc;
                    } while ((globalOrdinal = ChildScorer.this.ordinals.getOrd(ChildScorer.this.currentChildDoc)) < 0 || (parentIdx = ChildScorer.this.parentIdxs.find(globalOrdinal)) == -1L);
                    ChildScorer.this.currentScore = ChildScorer.this.scores.get(parentIdx);
                    return ChildScorer.this.currentChildDoc;
                }

                public int advance(int target) throws IOException {
                    ChildScorer.this.currentChildDoc = ChildScorer.this.childrenIterator.advance(target);
                    if (ChildScorer.this.currentChildDoc == Integer.MAX_VALUE) {
                        return ChildScorer.this.currentChildDoc;
                    }
                    int globalOrdinal = ChildScorer.this.ordinals.getOrd(ChildScorer.this.currentChildDoc);
                    if (globalOrdinal < 0) {
                        return this.nextDoc();
                    }
                    long parentIdx = ChildScorer.this.parentIdxs.find(globalOrdinal);
                    if (parentIdx != -1L) {
                        ChildScorer.this.currentScore = ChildScorer.this.scores.get(parentIdx);
                        return ChildScorer.this.currentChildDoc;
                    }
                    return this.nextDoc();
                }

                public long cost() {
                    return ChildScorer.this.childrenIterator.cost();
                }
            };
        }
    }

    @SuppressForbidden(reason="Old p/c queries still use filters")
    private class ChildWeight
    extends Weight {
        private final Weight parentWeight;
        private final Filter childrenFilter;
        private final LongHash parentIdxs;
        private final FloatArray scores;
        private final IndexParentChildFieldData globalIfd;

        private ChildWeight(Query query, Weight parentWeight, Filter childrenFilter, ParentOrdAndScoreCollector collector, IndexParentChildFieldData globalIfd) {
            super(query);
            this.parentWeight = parentWeight;
            this.childrenFilter = childrenFilter;
            this.parentIdxs = collector.parentIdxs;
            this.scores = collector.scores;
            this.globalIfd = globalIfd;
        }

        public void extractTerms(Set<Term> terms) {
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return Explanation.match((float)ParentQuery.this.getBoost(), (String)"not implemented yet...", (Explanation[])new Explanation[0]);
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.parentWeight.getValueForNormalization();
            return sum *= ParentQuery.this.getBoost() * ParentQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            DocIdSet childrenDocSet = this.childrenFilter.getDocIdSet(context, null);
            if (Lucene.isEmpty(childrenDocSet = BitsFilteredDocIdSet.wrap((DocIdSet)childrenDocSet, (Bits)context.reader().getLiveDocs()))) {
                return null;
            }
            DocIdSetIterator childIterator = childrenDocSet.iterator();
            if (childIterator == null) {
                return null;
            }
            SortedDocValues bytesValues = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(ParentQuery.this.parentType);
            if (bytesValues == null) {
                return null;
            }
            return new ChildScorer(this, this.parentIdxs, this.scores, childIterator, bytesValues);
        }
    }

    private static class ParentOrdAndScoreCollector
    implements Collector,
    Releasable {
        private final LongHash parentIdxs;
        private FloatArray scores;
        private final IndexParentChildFieldData globalIfd;
        private final BigArrays bigArrays;
        private final String parentType;

        ParentOrdAndScoreCollector(SearchContext searchContext, IndexParentChildFieldData globalIfd, String parentType) {
            this.bigArrays = searchContext.bigArrays();
            this.parentIdxs = new LongHash(512L, this.bigArrays);
            this.scores = this.bigArrays.newFloatArray(512L, false);
            this.globalIfd = globalIfd;
            this.parentType = parentType;
        }

        public boolean needsScores() {
            return true;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final SortedDocValues values = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(this.parentType);
            if (values == null) {
                throw new CollectionTerminatedException();
            }
            return new LeafCollector(){
                Scorer scorer;

                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                public void collect(int doc) throws IOException {
                    long globalOrdinal = values.getOrd(doc);
                    if (globalOrdinal != -1L) {
                        long parentIdx = ParentOrdAndScoreCollector.this.parentIdxs.add(globalOrdinal);
                        if (parentIdx >= 0L) {
                            ParentOrdAndScoreCollector.this.scores = ParentOrdAndScoreCollector.this.bigArrays.grow(ParentOrdAndScoreCollector.this.scores, parentIdx + 1L);
                            ParentOrdAndScoreCollector.this.scores.set(parentIdx, this.scorer.score());
                        } else assert (false) : "parent id should only match once, since there can only be one parent doc";
                    }
                }
            };
        }

        @Override
        public void close() {
            Releasables.close(this.parentIdxs, this.scores);
        }

        public long parentCount() {
            return this.parentIdxs.size();
        }
    }
}

