/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.util.Callback;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;

final class ChannelReference
extends AbstractRefCounted {
    private final Path file;
    private final FileChannel channel;
    protected final long generation;
    private final Callback<ChannelReference> onClose;

    ChannelReference(Path file, long generation, FileChannel channel, Callback<ChannelReference> onClose) throws IOException {
        super(file.toString());
        this.generation = generation;
        this.file = file;
        this.channel = channel;
        this.onClose = onClose;
    }

    public long getGeneration() {
        return this.generation;
    }

    public Path getPath() {
        return this.file;
    }

    public FileChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "channel: file [" + this.file + "], ref count [" + this.refCount() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeInternal() {
        try {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.channel});
        }
        finally {
            if (this.onClose != null) {
                this.onClose.handle(this);
            }
        }
    }
}

