/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class KeywordLiteral
extends AstNode {
    public KeywordLiteral() {
    }

    public KeywordLiteral(int n) {
        super(n);
    }

    public KeywordLiteral(int n, int n2) {
        super(n, n2);
    }

    public KeywordLiteral(int n, int n2, int n3) {
        super(n, n2);
        this.setType(n3);
    }

    @Override
    public KeywordLiteral setType(int n) {
        if (n != 43 && n != 42 && n != 45 && n != 44 && n != 160) {
            throw new IllegalArgumentException("Invalid node type: " + n);
        }
        this.type = n;
        return this;
    }

    public boolean isBooleanLiteral() {
        return this.type == 45 || this.type == 44;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        switch (this.getType()) {
            case 43: {
                stringBuilder.append("this");
                break;
            }
            case 42: {
                stringBuilder.append("null");
                break;
            }
            case 45: {
                stringBuilder.append("true");
                break;
            }
            case 44: {
                stringBuilder.append("false");
                break;
            }
            case 160: {
                stringBuilder.append("debugger;\n");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid keyword literal type: " + this.getType());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

