/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinScriptStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.script.GetScriptDefinitionKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;

public class KtScript
extends KtNamedDeclarationStub<KotlinScriptStub>
implements KtDeclarationContainer {
    private KotlinScriptDefinition kotlinScriptDefinitionField;
    private boolean kotlinScriptDefinitionInitialized;

    private KotlinScriptDefinition getKotlinScriptDefinition() {
        if (!this.kotlinScriptDefinitionInitialized) {
            this.kotlinScriptDefinitionField = GetScriptDefinitionKt.getScriptDefinition(this.getContainingKtFile());
            this.kotlinScriptDefinitionInitialized = true;
            assert (this.kotlinScriptDefinitionField != null) : "Should not parse a script without definition";
        }
        return this.kotlinScriptDefinitionField;
    }

    public KtScript(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtScript", "<init>"));
        }
        super(node);
        this.kotlinScriptDefinitionField = null;
        this.kotlinScriptDefinitionInitialized = false;
    }

    public KtScript(@NotNull KotlinScriptStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtScript", "<init>"));
        }
        super(stub, KtStubElementTypes.SCRIPT);
        this.kotlinScriptDefinitionField = null;
        this.kotlinScriptDefinitionInitialized = false;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        KotlinScriptStub stub = (KotlinScriptStub)this.getStub();
        if (stub != null) {
            FqName fqName2 = stub.getFqName();
            if (fqName2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtScript", "getFqName"));
            }
            return fqName2;
        }
        KtFile containingKtFile = this.getContainingKtFile();
        FqName fqName3 = containingKtFile.getPackageFqName().child(this.getKotlinScriptDefinition().getScriptName(this));
        if (fqName3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtScript", "getFqName"));
        }
        return fqName3;
    }

    @Override
    public String getName() {
        return this.getFqName().shortName().asString();
    }

    @NotNull
    public KtBlockExpression getBlockExpression() {
        KtBlockExpression ktBlockExpression = this.findNotNullChildByClass(KtBlockExpression.class);
        if (ktBlockExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtScript", "getBlockExpression"));
        }
        return ktBlockExpression;
    }

    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations() {
        List<KtDeclaration> list2 = PsiTreeUtil.getChildrenOfTypeAsList(this.getBlockExpression(), KtDeclaration.class);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtScript", "getDeclarations"));
        }
        return list2;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtScript", "accept"));
        }
        return visitor2.visitScript(this, data);
    }
}

