/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.DynamicObjectUtil;
import org.gradle.internal.Actions;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.InvokeMethodResult;
import org.gradle.internal.metaobject.SetPropertyResult;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureUtil {
    public static <T> T configureByMap(Map<?, ?> properties, T delegate) {
        DynamicObject dynamicObject = DynamicObjectUtil.asDynamicObject(delegate);
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            String name = entry.getKey().toString();
            Object value = entry.getValue();
            SetPropertyResult setterResult = new SetPropertyResult();
            dynamicObject.setProperty(name, value, setterResult);
            if (setterResult.isFound()) continue;
            InvokeMethodResult invokeResult = new InvokeMethodResult();
            dynamicObject.invokeMethod(name, invokeResult, value);
            if (invokeResult.isFound()) continue;
            throw dynamicObject.setMissingProperty(name);
        }
        return delegate;
    }

    public static <T> T configureByMap(Map<?, ?> properties, T delegate, Collection<?> mandatoryKeys) {
        if (!mandatoryKeys.isEmpty()) {
            List missingKeys = CollectionUtils.toStringList(mandatoryKeys);
            missingKeys.removeAll(CollectionUtils.toStringList(properties.keySet()));
            if (!missingKeys.isEmpty()) {
                throw new IncompleteInputException("Input configuration map does not contain following mandatory keys: " + missingKeys, missingKeys);
            }
        }
        return ConfigureUtil.configureByMap(properties, delegate);
    }

    public static <T> T configure(@Nullable Closure configureClosure, T target) {
        if (configureClosure == null) {
            return target;
        }
        if (target instanceof Configurable) {
            ((Configurable)target).configure(configureClosure);
        } else {
            ConfigureUtil.configureTarget(configureClosure, target, new ConfigureDelegate(configureClosure, target));
        }
        return target;
    }

    public static <T> Action<T> configureUsing(final @Nullable Closure configureClosure) {
        if (configureClosure == null) {
            return Actions.doNothing();
        }
        return new Action<T>(){

            public void execute(T t) {
                ConfigureUtil.configure(configureClosure, t);
            }
        };
    }

    public static <T> T configureSelf(@Nullable Closure configureClosure, T target) {
        if (configureClosure == null) {
            return target;
        }
        ConfigureUtil.configureTarget(configureClosure, target, new ConfigureDelegate(configureClosure, target));
        return target;
    }

    public static <T> T configureSelf(@Nullable Closure configureClosure, T target, ConfigureDelegate closureDelegate) {
        if (configureClosure == null) {
            return target;
        }
        ConfigureUtil.configureTarget(configureClosure, target, closureDelegate);
        return target;
    }

    private static <T> void configureTarget(Closure configureClosure, T target, ConfigureDelegate closureDelegate) {
        if (!(configureClosure instanceof GeneratedClosure)) {
            new ClosureBackedAction(configureClosure, 1, false).execute(target);
            return;
        }
        Closure withNewOwner = configureClosure.rehydrate(target, (Object)closureDelegate, configureClosure.getThisObject());
        new ClosureBackedAction(withNewOwner, 2, false).execute(target);
    }

    public static class IncompleteInputException
    extends RuntimeException {
        private final Collection missingKeys;

        public IncompleteInputException(String message, Collection missingKeys) {
            super(message);
            this.missingKeys = missingKeys;
        }

        public Collection getMissingKeys() {
            return this.missingKeys;
        }
    }
}

