/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.serialize.Serializer;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateSerializer;

public class DefaultCompilationStateCacheFactory
implements CompilationStateCacheFactory {
    private final PersistentIndexedCache<String, CompilationState> compilationStateIndexedCache;

    public DefaultCompilationStateCacheFactory(TaskArtifactStateCacheAccess cacheAccess) {
        this.compilationStateIndexedCache = cacheAccess.createCache("compilationState", String.class, (Serializer)new CompilationStateSerializer());
    }

    @Override
    public PersistentStateCache<CompilationState> create(String taskPath) {
        return new PersistentCompilationStateCache(taskPath, this.compilationStateIndexedCache);
    }

    private static class PersistentCompilationStateCache
    implements PersistentStateCache<CompilationState> {
        private final String taskPath;
        private final PersistentIndexedCache<String, CompilationState> compilationStateIndexedCache;

        public PersistentCompilationStateCache(String taskPath, PersistentIndexedCache<String, CompilationState> compilationStateIndexedCache) {
            this.taskPath = taskPath;
            this.compilationStateIndexedCache = compilationStateIndexedCache;
        }

        public CompilationState get() {
            return (CompilationState)this.compilationStateIndexedCache.get((Object)this.taskPath);
        }

        public void set(CompilationState newValue) {
            this.compilationStateIndexedCache.put((Object)this.taskPath, (Object)newValue);
        }

        public void update(PersistentStateCache.UpdateAction<CompilationState> updateAction) {
            throw new UnsupportedOperationException();
        }
    }
}

