/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonClientGlobalServices;
import org.gradle.launcher.exec.BuildExecuter;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.provider.ClassLoaderCache;
import org.gradle.tooling.internal.provider.ClasspathInferer;
import org.gradle.tooling.internal.provider.ClientSidePayloadClassLoaderFactory;
import org.gradle.tooling.internal.provider.ClientSidePayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.DefaultPayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.ModelClassLoaderFactory;
import org.gradle.tooling.internal.provider.PayloadSerializer;
import org.gradle.tooling.internal.provider.ProviderConnection;
import org.gradle.tooling.internal.provider.ShutdownCoordinator;

public class ConnectionScopeServices {
    private final LoggingServiceRegistry loggingServices;

    public ConnectionScopeServices(LoggingServiceRegistry loggingServices) {
        this.loggingServices = loggingServices;
    }

    void configure(ServiceRegistration serviceRegistration) {
        serviceRegistration.add(LoggingServiceRegistry.class, this.loggingServices);
        serviceRegistration.addProvider(new GlobalScopeServices(true));
        serviceRegistration.addProvider(new DaemonClientGlobalServices());
    }

    ShutdownCoordinator createShutdownCoordinator(ListenerManager listenerManager, DaemonClientFactory daemonClientFactory, OutputEventListener outputEventListener) {
        ShutdownCoordinator shutdownCoordinator = new ShutdownCoordinator(daemonClientFactory, outputEventListener);
        listenerManager.addListener((Object)shutdownCoordinator);
        return shutdownCoordinator;
    }

    ProviderConnection createProviderConnection(BuildExecuter buildActionExecuter, DaemonClientFactory daemonClientFactory, ServiceRegistry serviceRegistry, JvmVersionDetector jvmVersionDetector, ShutdownCoordinator shutdownCoordinator) {
        ClassLoaderCache classLoaderCache = new ClassLoaderCache();
        return new ProviderConnection(serviceRegistry, this.loggingServices, daemonClientFactory, buildActionExecuter, new PayloadSerializer(new ClientSidePayloadClassLoaderRegistry(new DefaultPayloadClassLoaderRegistry(classLoaderCache, new ClientSidePayloadClassLoaderFactory(new ModelClassLoaderFactory())), new ClasspathInferer(), classLoaderCache)), jvmVersionDetector);
    }

    ProtocolToModelAdapter createProtocolToModelAdapter() {
        return new ProtocolToModelAdapter();
    }
}

